"use strict";
const iam = require("@aws-cdk/aws-iam");
const kms = require("../lib");
module.exports = {
    'Via service, any principal'(test) {
        // WHEN
        const statement = new iam.PolicyStatement({
            actions: ['abc:call'],
            principals: [new kms.ViaServicePrincipal('bla.amazonaws.com')],
            resources: ['*']
        });
        // THEN
        test.deepEqual(statement.toStatementJson(), {
            Action: 'abc:call',
            Condition: { StringEquals: { 'kms:ViaService': 'bla.amazonaws.com' } },
            Effect: 'Allow',
            Principal: '*',
            Resource: '*'
        });
        test.done();
    },
    'Via service, principal with conditions'(test) {
        // WHEN
        const statement = new iam.PolicyStatement({
            actions: ['abc:call'],
            principals: [new kms.ViaServicePrincipal('bla.amazonaws.com', new iam.OrganizationPrincipal('o-1234'))],
            resources: ['*']
        });
        // THEN
        test.deepEqual(statement.toStatementJson(), {
            Action: 'abc:call',
            Condition: {
                StringEquals: {
                    'kms:ViaService': 'bla.amazonaws.com',
                    'aws:PrincipalOrgID': 'o-1234'
                }
            },
            Effect: 'Allow',
            Principal: '*',
            Resource: '*'
        });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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