from typing import List, Optional, Dict, Any, Protocol
from .._types import ProxiesList
from ..proxy import Proxy


class ProxiesReaderProtocol(Protocol):
    @property
    def total(self) -> int: ...

    @property
    def total_working(self) -> int: ...

    @property
    def total_bad(self) -> int: ...

    @property
    def proxies(self) -> ProxiesList: ...

    @property
    def bad_proxies(self) -> ProxiesList: ...

    @property
    def working_proxies(self) -> ProxiesList: ...

    @working_proxies.setter
    def working_proxies(self, working_proxies: List[Proxy]) -> None: ...

    def _random_proxy_check_url(self) -> str: ...

    def read_with_auth(self) -> None: ...

    def read_authless(self) -> None: ...

    async def _check_proxy(
        self, proxy: Proxy, response_time: Optional[int] = None
    ) -> bool: ...

    async def check_all_proxies(self, max_resp_time: int = 30) -> None: ...

    async def _check_proxy_socks(
        self, proxy: Proxy, response_time: Optional[int] = None
    ) -> bool: ...

    async def check_all_proxies_socks5(self, max_resp_time: int = 5) -> None: ...

    def get_working_proxies_list_http(self) -> List[str]: ...

    def write_working_proxies(self, filename: str) -> None: ...

    def get_random_http(self) -> Optional[str]: ...

    def get_random_socks5(self) -> Optional[str]: ...

    def get_random_socks5_telegram(self) -> Optional[Dict[str, Any]]: ...

    def next_http_from_list(self) -> Optional[str]: ...

    def next_http_from_cycle(self) -> str: ...

    def next_socks5_from_list(self) -> str: ...

    def next_socks5_from_cycle(self) -> str: ...

    def next_http_telegram_from_list(self) -> Dict[str, Any]: ...

    def next_http_telegram_from_cycle(self) -> Dict[str, Any]: ...

    def next_socks5_telegram_from_cycle(self) -> Dict[str, Any]: ...

    def next_socks5_telegram_from_list(self) -> Dict[str, Any]: ...

    def next_https_from_list(self) -> str: ...

    def next_https_from_cycle(self) -> str: ...
