/*
 * pyhddm_s.cpy - DO NOT EDIT THIS FILE
 *
 * This file was generated automatically by hddm-py from the file
 * event.xml

 * This source file contains the Python/C++ API wrappers that
 * provide a python interface to the hddm classes and methods
 * generated by hddm-cpp from event.xml.
 *
 * The hddm data model tool set was written by
 * Richard Jones, University of Connecticut.
 *
 * For more information see the documentation at
 * http://github.com/rjones30/HDDM
 *
 */

#include <Python.h>
#include <structmember.h>

#include <hddm_s.hpp>
#include <fstream>
#include <iostream>
#include <exception>
#include <particleType.h>
#ifdef ISTREAM_OVER_HTTP
#include <httpstream.hpp>
#endif
#ifdef ISTREAM_OVER_XROOTD
#include <xrootdstream.hpp>
#endif

using namespace hddm_s;

#if PY_MAJOR_VERSION >= 3
   #define PyInt_FromLong PyLong_FromLong
   #define PyInt_AsLong PyLong_AsLong
#endif


inline void LOG_NEW(PyTypeObject *t, PyTypeObject *subt=0, int own=0) {
#if 0
   if (subt == 0)
      std::cout << "creating a new element of " << t->tp_name
                << " " << ((own == 0)? "(borrowed)" : "(owned)")
                << std::endl;
   else
      std::cout << "creating a new list of " << subt->tp_name
                << " " << ((own == 0)? "(borrowed)" : "(owned)")
                << std::endl;
#endif
}

inline void LOG_DEALLOC(PyTypeObject *t, PyTypeObject *subt=0, int own=0) {
#if 0
   if (subt == 0)
      std::cout << "destroying an element of " << t->tp_name
                << " " << ((own == 0)? "(borrowed)" : "(owned)")
                << std::endl;
   else
      std::cout << "destroying a list of " << subt->tp_name
                << " " << ((own == 0)? "(borrowed)" : "(owned)")
                << std::endl;
#endif
}

inline void My_INCREF(PyObject *o) {
   //std::cout << "incrementing reference at " << o << std::endl;
   Py_INCREF(o);
}

inline void My_DECREF(PyObject *o) {
   //std::cout << "decrementing reference at " << o << std::endl;
   Py_DECREF(o);
}

// wrap base class hddm_s::HDDM_Element as hddm_s.HDDM_Element

typedef struct {
   PyObject_HEAD
   HDDM_Element *elem;
   PyObject *host;
} _HDDM_Element;

static void
_HDDM_Element_dealloc(_HDDM_Element* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_HDDM_Element_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _HDDM_Element *self;
   self = (_HDDM_Element*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_HDDM_Element_init(_HDDM_Element *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_HDDM_Element_getAttribute(PyObject *self, PyObject *args)
{
   char *attr;
   if (! PyArg_ParseTuple(args, "s", &attr)) {
      return NULL;
   }
   _HDDM_Element *me = (_HDDM_Element*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid element");
      return NULL;
   }
   hddm_type atype;
   void *val((int*)me->elem->getAttribute(std::string(attr),&atype));
   if (val == 0) {
      Py_INCREF(Py_None);
      return Py_None;
   }
   else if (atype == k_hddm_int) {
      return PyLong_FromLong(*(int*)val);
   }
   else if (atype == k_hddm_long) {
      return PyLong_FromLongLong(*(long long*)val);
   }
   else if (atype == k_hddm_float) {
      return PyFloat_FromDouble(double(*(float*)val));
   }
   else if (atype == k_hddm_double) {
      return PyFloat_FromDouble(*(double*)val);
   }
   else if (atype == k_hddm_boolean) {
      if (*(bool*)val == 0) {
         Py_INCREF(Py_False);
         return Py_False;
      }
      else {
         Py_INCREF(Py_True);
         return Py_True;
      }
   }
   else if (atype == k_hddm_string) {
      return PyUnicode_FromString(((std::string*)val)->c_str());
   }
   else if (atype == k_hddm_anyURI) {
      return PyUnicode_FromString(((std::string*)val)->c_str());
   }
   else if (atype == k_hddm_Particle_t) {
      return PyUnicode_FromString(ParticleType(*(Particle_t*)val));
   }
   return PyUnicode_FromString(((std::string*)val)->c_str());
}

static PyMemberDef _HDDM_Element_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _HDDM_Element_methods[] = {
   {"getAttribute", _HDDM_Element_getAttribute, METH_VARARGS,
    "look up named attribute in this element"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _HDDM_Element_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.HDDM_Element",     /*tp_name*/
    sizeof(_HDDM_Element),     /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_HDDM_Element_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    0,                         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s basic element",    /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _HDDM_Element_methods,     /* tp_methods */
    _HDDM_Element_members,     /* tp_members */
    0,                         /* tp_getset */
    0,                         /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_HDDM_Element_init, /* tp_init */
    0,                         /* tp_alloc */
    _HDDM_Element_new,         /* tp_new */
};


// wrap base class hddm_s::HDDM_ElementList as hddm_s.HDDM_ElementList

typedef struct {
   PyObject_HEAD
   PyTypeObject *subtype; // type of wrapper derived from _HDDM_Element
   HDDM_ElementList<HDDM_Element> *list;
   PyObject *host;
   int borrowed;
} _HDDM_ElementList;

static void
_HDDM_ElementList_dealloc(_HDDM_ElementList* self)
{
   if (self->list != 0) {
      LOG_DEALLOC(Py_TYPE(self), self->subtype, self->borrowed == 0);
      if (self->borrowed == 0)
         delete self->list;
      My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_HDDM_ElementList_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _HDDM_ElementList *self;
   self = (_HDDM_ElementList*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->subtype = 0;
      self->borrowed = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_HDDM_ElementList_init(_HDDM_ElementList *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static Py_ssize_t
_HDDM_ElementList_size(_HDDM_ElementList *self, void *closure)
{
   if (self->list == 0) {
      PyErr_SetString(PyExc_RuntimeError, "size attempted on invalid list");
      return -1;
   }
   return self->list->size();
}

static PyObject*
_HDDM_ElementList_item(_HDDM_ElementList *self, Py_ssize_t i)
{
   if (self->list == 0)
      return NULL;
   int len = self->list->size();
   if (i < 0 || i >= len) {
      PyErr_Format(PyExc_IndexError, "index %ld out of bounds.", i);
      return NULL;
   }
   PyObject *elem_obj = _HDDM_Element_new(self->subtype, 0, 0);
   ((_HDDM_Element*)elem_obj)->elem = &(HDDM_Element&)(*self->list)((int)i);
   ((_HDDM_Element*)elem_obj)->host = self->host;
   My_INCREF(self->host);
   LOG_NEW(self->subtype);
   return elem_obj;
}

extern PyTypeObject _HDDM_ElementList_type;

static PyObject *
_HDDM_ElementList_add(PyObject *self, PyObject *args)
{
   int count=0;
   int start=-1;
   if (! PyArg_ParseTuple(args, "i|i", &count, &start)) {
      return NULL;
   }
   _HDDM_ElementList *me = (_HDDM_ElementList*)self;
   if (me->list == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid list");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = me->subtype;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new HDDM_ElementList<HDDM_Element>(me->list->add(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(self), me->subtype, 1);
   return list;
}

static PyObject *
_HDDM_ElementList_del(PyObject *self, PyObject *args)
{
   int start=0;
   int count=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _HDDM_ElementList *list_obj;
   list_obj = (_HDDM_ElementList*)self;
   if (list_obj->list == 0) {
      PyErr_SetString(PyExc_RuntimeError, "del attempted on invalid list");
      return NULL;
   }
   list_obj->list->del(count, start);
   Py_INCREF(self);
   return self;
}

static PyObject *
_HDDM_ElementList_clear(PyObject *self, PyObject *args)
{
   _HDDM_ElementList *list_obj;
   list_obj = (_HDDM_ElementList*)self;
   if (list_obj->list == 0) {
      PyErr_SetString(PyExc_RuntimeError, "clear attempted on invalid list");
      return NULL;
   }
   list_obj->list->clear();
   Py_INCREF(self);
   return self;
}

static PyMemberDef _HDDM_ElementList_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _HDDM_ElementList_methods[] = {
   {"add",  _HDDM_ElementList_add, METH_VARARGS,
    "add (or insert) a new element to the list."},
   {"del",  _HDDM_ElementList_del, METH_VARARGS,
    "delete an existing element from the list."},
   {"clear",  _HDDM_ElementList_clear, METH_NOARGS,
    "reset the list to zero elements."},
   {NULL}  /* Sentinel */
};

static PySequenceMethods _HDDM_ElementList_as_sequence = {
    (lenfunc)_HDDM_ElementList_size,            /* sq_length */
    0,                                          /* sq_concat */
    0,                                          /* sq_repeat */
    (ssizeargfunc)_HDDM_ElementList_item,       /* sq_item */
    0,                                          /* sq_slice */
    0,                                          /* sq_ass_item */
    0,                                          /* sq_ass_slice */
    0,                                          /* sq_contains */
    0,                                          /* sq_inplace_concat */
    0,                                          /* sq_inplace_repeat */
};

PyTypeObject _HDDM_ElementList_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.HDDM_ElementList", /*tp_name*/
    sizeof(_HDDM_ElementList), /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_HDDM_ElementList_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    &_HDDM_ElementList_as_sequence, /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    0,                         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s element list",    /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _HDDM_ElementList_methods, /* tp_methods */
    _HDDM_ElementList_members, /* tp_members */
    0,                         /* tp_getset */
    0,                         /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_HDDM_ElementList_init,   /* tp_init */
    0,                         /* tp_alloc */
    _HDDM_ElementList_new,     /* tp_new */
};


// wrap element class hddm_s::Geometry as hddm_s.Geometry

typedef struct {
   PyObject_HEAD
   Geometry *elem;
   PyObject *host;
} _Geometry;

static void
_Geometry_dealloc(_Geometry* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Geometry_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Geometry *self;
   self = (_Geometry*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Geometry_init(_Geometry *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Geometry_getClass(_Geometry *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Geometry_getVersion(_Geometry *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_Geometry_getXmlns(_Geometry *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Geometry_getMaxOccurs(_Geometry *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_Geometry_getMd5reconstruction(_Geometry *self, void *closure)
{
   std::string val(self->elem->getMd5reconstruction());
   return PyUnicode_FromString(val.c_str());
}

static int
_Geometry_setMd5reconstruction(_Geometry *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setMd5reconstruction(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_Geometry_getMd5simulation(_Geometry *self, void *closure)
{
   std::string val(self->elem->getMd5simulation());
   return PyUnicode_FromString(val.c_str());
}

static int
_Geometry_setMd5simulation(_Geometry *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setMd5simulation(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_Geometry_getMd5smear(_Geometry *self, void *closure)
{
   std::string val(self->elem->getMd5smear());
   return PyUnicode_FromString(val.c_str());
}

static int
_Geometry_setMd5smear(_Geometry *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setMd5smear(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_Geometry_getMinOccurs(_Geometry *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Geometry_toString(PyObject *self, PyObject *args=0)
{
   _Geometry *me = (_Geometry*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid geometry element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Geometry_toXML(PyObject *self, PyObject *args=0)
{
   _Geometry *me = (_Geometry*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid geometry element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Geometry_getsetters[] = {
   {(char*)"class",
    (getter)_Geometry_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Geometry_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"md5reconstruction",
    (getter)_Geometry_getMd5reconstruction, (setter)_Geometry_setMd5reconstruction,
    (char*)"md5reconstruction string",
    NULL},
   {(char*)"md5simulation",
    (getter)_Geometry_getMd5simulation, (setter)_Geometry_setMd5simulation,
    (char*)"md5simulation string",
    NULL},
   {(char*)"md5smear",
    (getter)_Geometry_getMd5smear, (setter)_Geometry_setMd5smear,
    (char*)"md5smear string",
    NULL},
   {(char*)"minOccurs",
    (getter)_Geometry_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"version",
    (getter)_Geometry_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_Geometry_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Geometry_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Geometry_methods[] = {
   {"toString", _Geometry_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Geometry_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Geometry_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.Geometry",         /*tp_name*/
    sizeof(_Geometry),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Geometry_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Geometry_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s geometry element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Geometry_methods,          /* tp_methods */
    _Geometry_members,          /* tp_members */
    _Geometry_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Geometry_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Geometry_new,              /* tp_new */
};



// wrap element class hddm_s::DataVersionString as hddm_s.DataVersionString

typedef struct {
   PyObject_HEAD
   DataVersionString *elem;
   PyObject *host;
} _DataVersionString;

static void
_DataVersionString_dealloc(_DataVersionString* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_DataVersionString_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _DataVersionString *self;
   self = (_DataVersionString*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_DataVersionString_init(_DataVersionString *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_DataVersionString_getClass(_DataVersionString *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DataVersionString_getVersion(_DataVersionString *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_DataVersionString_getXmlns(_DataVersionString *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DataVersionString_getEventNo(_DataVersionString *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_DataVersionString_getRunNo(_DataVersionString *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_DataVersionString_getMaxOccurs(_DataVersionString *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DataVersionString_getMinOccurs(_DataVersionString *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_DataVersionString_getText(_DataVersionString *self, void *closure)
{
   std::string val(self->elem->getText());
   return PyUnicode_FromString(val.c_str());
}

static int
_DataVersionString_setText(_DataVersionString *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setText(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_DataVersionString_toString(PyObject *self, PyObject *args=0)
{
   _DataVersionString *me = (_DataVersionString*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dataVersionString element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_DataVersionString_toXML(PyObject *self, PyObject *args=0)
{
   _DataVersionString *me = (_DataVersionString*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dataVersionString element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _DataVersionString_getsetters[] = {
   {(char*)"class",
    (getter)_DataVersionString_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_DataVersionString_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_DataVersionString_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_DataVersionString_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_DataVersionString_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"text",
    (getter)_DataVersionString_getText, (setter)_DataVersionString_setText,
    (char*)"text string",
    NULL},
   {(char*)"version",
    (getter)_DataVersionString_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_DataVersionString_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _DataVersionString_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _DataVersionString_methods[] = {
   {"toString", _DataVersionString_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _DataVersionString_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _DataVersionString_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.DataVersionString",         /*tp_name*/
    sizeof(_DataVersionString),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_DataVersionString_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_DataVersionString_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s dataVersionString element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _DataVersionString_methods,          /* tp_methods */
    _DataVersionString_members,          /* tp_members */
    _DataVersionString_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_DataVersionString_init,   /* tp_init */
    0,                         /* tp_alloc */
    _DataVersionString_new,              /* tp_new */
};



// wrap element class hddm_s::CcdbContext as hddm_s.CcdbContext

typedef struct {
   PyObject_HEAD
   CcdbContext *elem;
   PyObject *host;
} _CcdbContext;

static void
_CcdbContext_dealloc(_CcdbContext* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_CcdbContext_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _CcdbContext *self;
   self = (_CcdbContext*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_CcdbContext_init(_CcdbContext *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_CcdbContext_getClass(_CcdbContext *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CcdbContext_getVersion(_CcdbContext *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_CcdbContext_getXmlns(_CcdbContext *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CcdbContext_getEventNo(_CcdbContext *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_CcdbContext_getRunNo(_CcdbContext *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_CcdbContext_getMaxOccurs(_CcdbContext *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CcdbContext_getMinOccurs(_CcdbContext *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_CcdbContext_getText(_CcdbContext *self, void *closure)
{
   std::string val(self->elem->getText());
   return PyUnicode_FromString(val.c_str());
}

static int
_CcdbContext_setText(_CcdbContext *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setText(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_CcdbContext_toString(PyObject *self, PyObject *args=0)
{
   _CcdbContext *me = (_CcdbContext*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ccdbContext element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_CcdbContext_toXML(PyObject *self, PyObject *args=0)
{
   _CcdbContext *me = (_CcdbContext*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ccdbContext element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _CcdbContext_getsetters[] = {
   {(char*)"class",
    (getter)_CcdbContext_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_CcdbContext_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_CcdbContext_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_CcdbContext_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_CcdbContext_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"text",
    (getter)_CcdbContext_getText, (setter)_CcdbContext_setText,
    (char*)"text string",
    NULL},
   {(char*)"version",
    (getter)_CcdbContext_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_CcdbContext_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _CcdbContext_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _CcdbContext_methods[] = {
   {"toString", _CcdbContext_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _CcdbContext_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _CcdbContext_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.CcdbContext",         /*tp_name*/
    sizeof(_CcdbContext),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_CcdbContext_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_CcdbContext_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s ccdbContext element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _CcdbContext_methods,          /* tp_methods */
    _CcdbContext_members,          /* tp_members */
    _CcdbContext_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_CcdbContext_init,   /* tp_init */
    0,                         /* tp_alloc */
    _CcdbContext_new,              /* tp_new */
};



// wrap element class hddm_s::Momentum as hddm_s.Momentum

typedef struct {
   PyObject_HEAD
   Momentum *elem;
   PyObject *host;
} _Momentum;

static void
_Momentum_dealloc(_Momentum* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Momentum_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Momentum *self;
   self = (_Momentum*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Momentum_init(_Momentum *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Momentum_getClass(_Momentum *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Momentum_getVersion(_Momentum *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_Momentum_getXmlns(_Momentum *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Momentum_getEventNo(_Momentum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_Momentum_getMaxOccurs(_Momentum *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Momentum_getRunNo(_Momentum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Momentum_getMinOccurs(_Momentum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Momentum_getFOM(_Momentum *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getFOM());
}

static PyObject*
_Momentum_getNdof(_Momentum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getNdof());
}

static PyObject*
_Momentum_getCandidateid(_Momentum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCandidateid());
}

static PyObject*
_Momentum_getChisq(_Momentum *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getChisq());
}

static PyObject*
_Momentum_getId(_Momentum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getId());
}

static PyObject*
_Momentum_getTrackid(_Momentum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrackid());
}

static PyObject*
_Momentum_getType(_Momentum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getType());
}

static PyObject*
_Momentum_getWeight(_Momentum *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getWeight());
}

static PyObject*
_Momentum_getDecayVertex(_Momentum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getDecayVertex());
}

static PyObject*
_Momentum_getMech(_Momentum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMech());
}

static PyObject*
_Momentum_getParentid(_Momentum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getParentid());
}

static PyObject*
_Momentum_getPdgtype(_Momentum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPdgtype());
}

static PyObject*
_Momentum_getE(_Momentum *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_Momentum_setE(_Momentum *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_Momentum_getPx(_Momentum *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPx());
}

static int
_Momentum_setPx(_Momentum *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPx((float)var);
   return 0;
}

static PyObject*
_Momentum_getPy(_Momentum *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPy());
}

static int
_Momentum_setPy(_Momentum *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPy((float)var);
   return 0;
}

static PyObject*
_Momentum_getPz(_Momentum *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPz());
}

static int
_Momentum_setPz(_Momentum *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPz((float)var);
   return 0;
}

static PyObject*
_Momentum_toString(PyObject *self, PyObject *args=0)
{
   _Momentum *me = (_Momentum*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid momentum element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Momentum_toXML(PyObject *self, PyObject *args=0)
{
   _Momentum *me = (_Momentum*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid momentum element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Momentum_getsetters[] = {
   {(char*)"E",
    (getter)_Momentum_getE, (setter)_Momentum_setE,
    (char*)"E value",
    NULL},
   {(char*)"FOM",
    (getter)_Momentum_getFOM, 0,
    (char*)"FOM value",
    NULL},
   {(char*)"Ndof",
    (getter)_Momentum_getNdof, 0,
    (char*)"Ndof value",
    NULL},
   {(char*)"candidateid",
    (getter)_Momentum_getCandidateid, 0,
    (char*)"candidateid value",
    NULL},
   {(char*)"chisq",
    (getter)_Momentum_getChisq, 0,
    (char*)"chisq value",
    NULL},
   {(char*)"class",
    (getter)_Momentum_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"decayVertex",
    (getter)_Momentum_getDecayVertex, 0,
    (char*)"decayVertex value",
    NULL},
   {(char*)"eventNo",
    (getter)_Momentum_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"id",
    (getter)_Momentum_getId, 0,
    (char*)"id value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Momentum_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"mech",
    (getter)_Momentum_getMech, 0,
    (char*)"mech value",
    NULL},
   {(char*)"minOccurs",
    (getter)_Momentum_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"parentid",
    (getter)_Momentum_getParentid, 0,
    (char*)"parentid value",
    NULL},
   {(char*)"pdgtype",
    (getter)_Momentum_getPdgtype, 0,
    (char*)"pdgtype value",
    NULL},
   {(char*)"px",
    (getter)_Momentum_getPx, (setter)_Momentum_setPx,
    (char*)"px value",
    NULL},
   {(char*)"py",
    (getter)_Momentum_getPy, (setter)_Momentum_setPy,
    (char*)"py value",
    NULL},
   {(char*)"pz",
    (getter)_Momentum_getPz, (setter)_Momentum_setPz,
    (char*)"pz value",
    NULL},
   {(char*)"runNo",
    (getter)_Momentum_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"trackid",
    (getter)_Momentum_getTrackid, 0,
    (char*)"trackid value",
    NULL},
   {(char*)"type",
    (getter)_Momentum_getType, 0,
    (char*)"type value",
    NULL},
   {(char*)"version",
    (getter)_Momentum_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"weight",
    (getter)_Momentum_getWeight, 0,
    (char*)"weight value",
    NULL},
   {(char*)"xmlns",
    (getter)_Momentum_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Momentum_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Momentum_methods[] = {
   {"toString", _Momentum_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Momentum_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Momentum_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.Momentum",         /*tp_name*/
    sizeof(_Momentum),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Momentum_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Momentum_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s momentum element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Momentum_methods,          /* tp_methods */
    _Momentum_members,          /* tp_members */
    _Momentum_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Momentum_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Momentum_new,              /* tp_new */
};



// wrap element class hddm_s::Polarization as hddm_s.Polarization

typedef struct {
   PyObject_HEAD
   Polarization *elem;
   PyObject *host;
} _Polarization;

static void
_Polarization_dealloc(_Polarization* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Polarization_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Polarization *self;
   self = (_Polarization*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Polarization_init(_Polarization *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Polarization_getClass(_Polarization *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Polarization_getVersion(_Polarization *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_Polarization_getXmlns(_Polarization *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Polarization_getEventNo(_Polarization *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_Polarization_getMaxOccurs(_Polarization *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Polarization_getRunNo(_Polarization *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Polarization_getType(_Polarization *self, void *closure)
{
   return PyLong_FromLong(self->elem->getType());
}

static PyObject*
_Polarization_getWeight(_Polarization *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getWeight());
}

static PyObject*
_Polarization_getDecayVertex(_Polarization *self, void *closure)
{
   return PyLong_FromLong(self->elem->getDecayVertex());
}

static PyObject*
_Polarization_getId(_Polarization *self, void *closure)
{
   return PyLong_FromLong(self->elem->getId());
}

static PyObject*
_Polarization_getMech(_Polarization *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMech());
}

static PyObject*
_Polarization_getParentid(_Polarization *self, void *closure)
{
   return PyLong_FromLong(self->elem->getParentid());
}

static PyObject*
_Polarization_getPdgtype(_Polarization *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPdgtype());
}

static PyObject*
_Polarization_getPx(_Polarization *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPx());
}

static int
_Polarization_setPx(_Polarization *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPx((float)var);
   return 0;
}

static PyObject*
_Polarization_getPy(_Polarization *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPy());
}

static int
_Polarization_setPy(_Polarization *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPy((float)var);
   return 0;
}

static PyObject*
_Polarization_getPz(_Polarization *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPz());
}

static int
_Polarization_setPz(_Polarization *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPz((float)var);
   return 0;
}

static PyObject*
_Polarization_getMinOccurs(_Polarization *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Polarization_toString(PyObject *self, PyObject *args=0)
{
   _Polarization *me = (_Polarization*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid polarization element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Polarization_toXML(PyObject *self, PyObject *args=0)
{
   _Polarization *me = (_Polarization*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid polarization element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Polarization_getsetters[] = {
   {(char*)"Px",
    (getter)_Polarization_getPx, (setter)_Polarization_setPx,
    (char*)"Px value",
    NULL},
   {(char*)"Py",
    (getter)_Polarization_getPy, (setter)_Polarization_setPy,
    (char*)"Py value",
    NULL},
   {(char*)"Pz",
    (getter)_Polarization_getPz, (setter)_Polarization_setPz,
    (char*)"Pz value",
    NULL},
   {(char*)"class",
    (getter)_Polarization_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"decayVertex",
    (getter)_Polarization_getDecayVertex, 0,
    (char*)"decayVertex value",
    NULL},
   {(char*)"eventNo",
    (getter)_Polarization_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"id",
    (getter)_Polarization_getId, 0,
    (char*)"id value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Polarization_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"mech",
    (getter)_Polarization_getMech, 0,
    (char*)"mech value",
    NULL},
   {(char*)"minOccurs",
    (getter)_Polarization_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"parentid",
    (getter)_Polarization_getParentid, 0,
    (char*)"parentid value",
    NULL},
   {(char*)"pdgtype",
    (getter)_Polarization_getPdgtype, 0,
    (char*)"pdgtype value",
    NULL},
   {(char*)"runNo",
    (getter)_Polarization_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"type",
    (getter)_Polarization_getType, 0,
    (char*)"type value",
    NULL},
   {(char*)"version",
    (getter)_Polarization_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"weight",
    (getter)_Polarization_getWeight, 0,
    (char*)"weight value",
    NULL},
   {(char*)"xmlns",
    (getter)_Polarization_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Polarization_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Polarization_methods[] = {
   {"toString", _Polarization_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Polarization_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Polarization_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.Polarization",         /*tp_name*/
    sizeof(_Polarization),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Polarization_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Polarization_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s polarization element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Polarization_methods,          /* tp_methods */
    _Polarization_members,          /* tp_members */
    _Polarization_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Polarization_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Polarization_new,              /* tp_new */
};



// wrap element class hddm_s::Properties as hddm_s.Properties

typedef struct {
   PyObject_HEAD
   Properties *elem;
   PyObject *host;
} _Properties;

static void
_Properties_dealloc(_Properties* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Properties_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Properties *self;
   self = (_Properties*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Properties_init(_Properties *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Properties_getClass(_Properties *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Properties_getVersion(_Properties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_Properties_getXmlns(_Properties *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Properties_getEventNo(_Properties *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_Properties_getMaxOccurs(_Properties *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Properties_getRunNo(_Properties *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Properties_getMinOccurs(_Properties *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Properties_getFOM(_Properties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getFOM());
}

static PyObject*
_Properties_getNdof(_Properties *self, void *closure)
{
   return PyLong_FromLong(self->elem->getNdof());
}

static PyObject*
_Properties_getCandidateid(_Properties *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCandidateid());
}

static PyObject*
_Properties_getChisq(_Properties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getChisq());
}

static PyObject*
_Properties_getId(_Properties *self, void *closure)
{
   return PyLong_FromLong(self->elem->getId());
}

static PyObject*
_Properties_getTrackid(_Properties *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrackid());
}

static PyObject*
_Properties_getType(_Properties *self, void *closure)
{
   return PyLong_FromLong(self->elem->getType());
}

static PyObject*
_Properties_getWeight(_Properties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getWeight());
}

static PyObject*
_Properties_getDecayVertex(_Properties *self, void *closure)
{
   return PyLong_FromLong(self->elem->getDecayVertex());
}

static PyObject*
_Properties_getMech(_Properties *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMech());
}

static PyObject*
_Properties_getParentid(_Properties *self, void *closure)
{
   return PyLong_FromLong(self->elem->getParentid());
}

static PyObject*
_Properties_getPdgtype(_Properties *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPdgtype());
}

static PyObject*
_Properties_getCharge(_Properties *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCharge());
}

static int
_Properties_setCharge(_Properties *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setCharge(var);
   return 0;
}

static PyObject*
_Properties_getMass(_Properties *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getMass());
}

static int
_Properties_setMass(_Properties *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setMass((float)var);
   return 0;
}

static PyObject*
_Properties_toString(PyObject *self, PyObject *args=0)
{
   _Properties *me = (_Properties*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid properties element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Properties_toXML(PyObject *self, PyObject *args=0)
{
   _Properties *me = (_Properties*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid properties element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Properties_getsetters[] = {
   {(char*)"FOM",
    (getter)_Properties_getFOM, 0,
    (char*)"FOM value",
    NULL},
   {(char*)"Ndof",
    (getter)_Properties_getNdof, 0,
    (char*)"Ndof value",
    NULL},
   {(char*)"candidateid",
    (getter)_Properties_getCandidateid, 0,
    (char*)"candidateid value",
    NULL},
   {(char*)"charge",
    (getter)_Properties_getCharge, (setter)_Properties_setCharge,
    (char*)"charge value",
    NULL},
   {(char*)"chisq",
    (getter)_Properties_getChisq, 0,
    (char*)"chisq value",
    NULL},
   {(char*)"class",
    (getter)_Properties_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"decayVertex",
    (getter)_Properties_getDecayVertex, 0,
    (char*)"decayVertex value",
    NULL},
   {(char*)"eventNo",
    (getter)_Properties_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"id",
    (getter)_Properties_getId, 0,
    (char*)"id value",
    NULL},
   {(char*)"mass",
    (getter)_Properties_getMass, (setter)_Properties_setMass,
    (char*)"mass value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Properties_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"mech",
    (getter)_Properties_getMech, 0,
    (char*)"mech value",
    NULL},
   {(char*)"minOccurs",
    (getter)_Properties_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"parentid",
    (getter)_Properties_getParentid, 0,
    (char*)"parentid value",
    NULL},
   {(char*)"pdgtype",
    (getter)_Properties_getPdgtype, 0,
    (char*)"pdgtype value",
    NULL},
   {(char*)"runNo",
    (getter)_Properties_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"trackid",
    (getter)_Properties_getTrackid, 0,
    (char*)"trackid value",
    NULL},
   {(char*)"type",
    (getter)_Properties_getType, 0,
    (char*)"type value",
    NULL},
   {(char*)"version",
    (getter)_Properties_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"weight",
    (getter)_Properties_getWeight, 0,
    (char*)"weight value",
    NULL},
   {(char*)"xmlns",
    (getter)_Properties_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Properties_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Properties_methods[] = {
   {"toString", _Properties_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Properties_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Properties_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.Properties",         /*tp_name*/
    sizeof(_Properties),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Properties_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Properties_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s properties element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Properties_methods,          /* tp_methods */
    _Properties_members,          /* tp_members */
    _Properties_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Properties_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Properties_new,              /* tp_new */
};



// wrap element class hddm_s::Beam as hddm_s.Beam

typedef struct {
   PyObject_HEAD
   Beam *elem;
   PyObject *host;
} _Beam;

static void
_Beam_dealloc(_Beam* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Beam_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Beam *self;
   self = (_Beam*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Beam_init(_Beam *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Beam_getClass(_Beam *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Beam_getVersion(_Beam *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_Beam_getXmlns(_Beam *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Beam_getEventNo(_Beam *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_Beam_getMaxOccurs(_Beam *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Beam_getRunNo(_Beam *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Beam_getWeight(_Beam *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getWeight());
}

static PyObject*
_Beam_getMinOccurs(_Beam *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Beam_getType(_Beam *self, void *closure)
{
   Particle_t p(self->elem->getType());
   std::string val(ParticleType(p));
   return PyUnicode_FromString(val.c_str());
}

static int
_Beam_setType(_Beam *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setType((Particle_t)var);
   return 0;
}

static PyObject*
_Beam_getMomentum(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Beam *me = (_Beam*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid beam element");
      return NULL;
   }
   PyObject *obj = _Momentum_new(&_Momentum_type, 0, 0);
   ((_Momentum*)obj)->elem = &me->elem->getMomentum();
   ((_Momentum*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Beam_getMomenta(PyObject *self, PyObject *args)
{
   _Beam *me = (_Beam*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid beam element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Momentum_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getMomenta();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Beam_addMomenta(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Beam *me = (_Beam*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid beam element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Momentum_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new MomentumList(me->elem->addMomenta(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Beam_deleteMomenta(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Beam *me = (_Beam*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid beam element");
      return NULL;
   }
   me->elem->deleteMomenta(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Beam_getPolarization(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Beam *me = (_Beam*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid beam element");
      return NULL;
   }
   PyObject *obj = _Polarization_new(&_Polarization_type, 0, 0);
   ((_Polarization*)obj)->elem = &me->elem->getPolarization();
   ((_Polarization*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Beam_getPolarizations(PyObject *self, PyObject *args)
{
   _Beam *me = (_Beam*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid beam element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Polarization_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getPolarizations();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Beam_addPolarizations(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Beam *me = (_Beam*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid beam element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Polarization_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new PolarizationList(me->elem->addPolarizations(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Beam_deletePolarizations(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Beam *me = (_Beam*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid beam element");
      return NULL;
   }
   me->elem->deletePolarizations(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Beam_getProperties(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Beam *me = (_Beam*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid beam element");
      return NULL;
   }
   PyObject *obj = _Properties_new(&_Properties_type, 0, 0);
   ((_Properties*)obj)->elem = &me->elem->getProperties();
   ((_Properties*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Beam_getPropertiesList(PyObject *self, PyObject *args)
{
   _Beam *me = (_Beam*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid beam element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Properties_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getPropertiesList();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Beam_addPropertiesList(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Beam *me = (_Beam*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid beam element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Properties_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new PropertiesList(me->elem->addPropertiesList(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Beam_deletePropertiesList(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Beam *me = (_Beam*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid beam element");
      return NULL;
   }
   me->elem->deletePropertiesList(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Beam_toString(PyObject *self, PyObject *args=0)
{
   _Beam *me = (_Beam*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid beam element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Beam_toXML(PyObject *self, PyObject *args=0)
{
   _Beam *me = (_Beam*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid beam element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Beam_getsetters[] = {
   {(char*)"class",
    (getter)_Beam_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_Beam_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Beam_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_Beam_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_Beam_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"type",
    (getter)_Beam_getType, (setter)_Beam_setType,
    (char*)"type value",
    NULL},
   {(char*)"version",
    (getter)_Beam_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"weight",
    (getter)_Beam_getWeight, 0,
    (char*)"weight value",
    NULL},
   {(char*)"xmlns",
    (getter)_Beam_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Beam_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Beam_methods[] = {
   {"addMomenta", _Beam_addMomenta, METH_VARARGS,
    "extend (or insert into) the list of momentum objects for this beam"},
   {"addPolarizations", _Beam_addPolarizations, METH_VARARGS,
    "extend (or insert into) the list of polarization objects for this beam"},
   {"addPropertiesList", _Beam_addPropertiesList, METH_VARARGS,
    "extend (or insert into) the list of properties objects for this beam"},
   {"deleteMomenta", _Beam_deleteMomenta, METH_VARARGS,
    "delete momentum objects for this beam"},
   {"deletePolarizations", _Beam_deletePolarizations, METH_VARARGS,
    "delete polarization objects for this beam"},
   {"deletePropertiesList", _Beam_deletePropertiesList, METH_VARARGS,
    "delete properties objects for this beam"},
   {"getMomenta", _Beam_getMomenta, METH_NOARGS,
    "get list of momentum objects for this beam"},
   {"getMomentum", _Beam_getMomentum, METH_VARARGS,
    "get an individual momentum object from this beam"},
   {"getPolarization", _Beam_getPolarization, METH_VARARGS,
    "get an individual polarization object from this beam"},
   {"getPolarizations", _Beam_getPolarizations, METH_NOARGS,
    "get list of polarization objects for this beam"},
   {"getProperties", _Beam_getProperties, METH_VARARGS,
    "get an individual properties object from this beam"},
   {"getPropertiesList", _Beam_getPropertiesList, METH_NOARGS,
    "get list of properties objects for this beam"},
   {"toString", _Beam_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Beam_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Beam_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.Beam",         /*tp_name*/
    sizeof(_Beam),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Beam_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Beam_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s beam element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Beam_methods,          /* tp_methods */
    _Beam_members,          /* tp_members */
    _Beam_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Beam_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Beam_new,              /* tp_new */
};



// wrap element class hddm_s::Target as hddm_s.Target

typedef struct {
   PyObject_HEAD
   Target *elem;
   PyObject *host;
} _Target;

static void
_Target_dealloc(_Target* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Target_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Target *self;
   self = (_Target*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Target_init(_Target *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Target_getClass(_Target *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Target_getVersion(_Target *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_Target_getXmlns(_Target *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Target_getEventNo(_Target *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_Target_getMaxOccurs(_Target *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Target_getRunNo(_Target *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Target_getWeight(_Target *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getWeight());
}

static PyObject*
_Target_getMinOccurs(_Target *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Target_getType(_Target *self, void *closure)
{
   Particle_t p(self->elem->getType());
   std::string val(ParticleType(p));
   return PyUnicode_FromString(val.c_str());
}

static int
_Target_setType(_Target *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setType((Particle_t)var);
   return 0;
}

static PyObject*
_Target_getMomentum(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Target *me = (_Target*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid target element");
      return NULL;
   }
   PyObject *obj = _Momentum_new(&_Momentum_type, 0, 0);
   ((_Momentum*)obj)->elem = &me->elem->getMomentum();
   ((_Momentum*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Target_getMomenta(PyObject *self, PyObject *args)
{
   _Target *me = (_Target*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid target element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Momentum_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getMomenta();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Target_addMomenta(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Target *me = (_Target*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid target element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Momentum_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new MomentumList(me->elem->addMomenta(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Target_deleteMomenta(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Target *me = (_Target*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid target element");
      return NULL;
   }
   me->elem->deleteMomenta(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Target_getPolarization(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Target *me = (_Target*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid target element");
      return NULL;
   }
   PyObject *obj = _Polarization_new(&_Polarization_type, 0, 0);
   ((_Polarization*)obj)->elem = &me->elem->getPolarization();
   ((_Polarization*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Target_getPolarizations(PyObject *self, PyObject *args)
{
   _Target *me = (_Target*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid target element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Polarization_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getPolarizations();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Target_addPolarizations(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Target *me = (_Target*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid target element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Polarization_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new PolarizationList(me->elem->addPolarizations(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Target_deletePolarizations(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Target *me = (_Target*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid target element");
      return NULL;
   }
   me->elem->deletePolarizations(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Target_getProperties(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Target *me = (_Target*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid target element");
      return NULL;
   }
   PyObject *obj = _Properties_new(&_Properties_type, 0, 0);
   ((_Properties*)obj)->elem = &me->elem->getProperties();
   ((_Properties*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Target_getPropertiesList(PyObject *self, PyObject *args)
{
   _Target *me = (_Target*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid target element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Properties_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getPropertiesList();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Target_addPropertiesList(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Target *me = (_Target*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid target element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Properties_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new PropertiesList(me->elem->addPropertiesList(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Target_deletePropertiesList(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Target *me = (_Target*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid target element");
      return NULL;
   }
   me->elem->deletePropertiesList(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Target_toString(PyObject *self, PyObject *args=0)
{
   _Target *me = (_Target*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid target element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Target_toXML(PyObject *self, PyObject *args=0)
{
   _Target *me = (_Target*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid target element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Target_getsetters[] = {
   {(char*)"class",
    (getter)_Target_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_Target_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Target_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_Target_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_Target_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"type",
    (getter)_Target_getType, (setter)_Target_setType,
    (char*)"type value",
    NULL},
   {(char*)"version",
    (getter)_Target_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"weight",
    (getter)_Target_getWeight, 0,
    (char*)"weight value",
    NULL},
   {(char*)"xmlns",
    (getter)_Target_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Target_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Target_methods[] = {
   {"addMomenta", _Target_addMomenta, METH_VARARGS,
    "extend (or insert into) the list of momentum objects for this target"},
   {"addPolarizations", _Target_addPolarizations, METH_VARARGS,
    "extend (or insert into) the list of polarization objects for this target"},
   {"addPropertiesList", _Target_addPropertiesList, METH_VARARGS,
    "extend (or insert into) the list of properties objects for this target"},
   {"deleteMomenta", _Target_deleteMomenta, METH_VARARGS,
    "delete momentum objects for this target"},
   {"deletePolarizations", _Target_deletePolarizations, METH_VARARGS,
    "delete polarization objects for this target"},
   {"deletePropertiesList", _Target_deletePropertiesList, METH_VARARGS,
    "delete properties objects for this target"},
   {"getMomenta", _Target_getMomenta, METH_NOARGS,
    "get list of momentum objects for this target"},
   {"getMomentum", _Target_getMomentum, METH_VARARGS,
    "get an individual momentum object from this target"},
   {"getPolarization", _Target_getPolarization, METH_VARARGS,
    "get an individual polarization object from this target"},
   {"getPolarizations", _Target_getPolarizations, METH_NOARGS,
    "get list of polarization objects for this target"},
   {"getProperties", _Target_getProperties, METH_VARARGS,
    "get an individual properties object from this target"},
   {"getPropertiesList", _Target_getPropertiesList, METH_NOARGS,
    "get list of properties objects for this target"},
   {"toString", _Target_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Target_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Target_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.Target",         /*tp_name*/
    sizeof(_Target),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Target_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Target_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s target element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Target_methods,          /* tp_methods */
    _Target_members,          /* tp_members */
    _Target_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Target_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Target_new,              /* tp_new */
};



// wrap element class hddm_s::Product as hddm_s.Product

typedef struct {
   PyObject_HEAD
   Product *elem;
   PyObject *host;
} _Product;

static void
_Product_dealloc(_Product* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Product_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Product *self;
   self = (_Product*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Product_init(_Product *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Product_getClass(_Product *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Product_getVersion(_Product *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_Product_getXmlns(_Product *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Product_getEventNo(_Product *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_Product_getRunNo(_Product *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Product_getMinOccurs(_Product *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Product_getWeight(_Product *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getWeight());
}

static PyObject*
_Product_getDecayVertex(_Product *self, void *closure)
{
   return PyLong_FromLong(self->elem->getDecayVertex());
}

static int
_Product_setDecayVertex(_Product *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setDecayVertex(var);
   return 0;
}

static PyObject*
_Product_getId(_Product *self, void *closure)
{
   return PyLong_FromLong(self->elem->getId());
}

static int
_Product_setId(_Product *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setId(var);
   return 0;
}

static PyObject*
_Product_getMaxOccurs(_Product *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Product_getMech(_Product *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMech());
}

static int
_Product_setMech(_Product *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setMech(var);
   return 0;
}

static PyObject*
_Product_getParentid(_Product *self, void *closure)
{
   return PyLong_FromLong(self->elem->getParentid());
}

static int
_Product_setParentid(_Product *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setParentid(var);
   return 0;
}

static PyObject*
_Product_getPdgtype(_Product *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPdgtype());
}

static int
_Product_setPdgtype(_Product *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPdgtype(var);
   return 0;
}

static PyObject*
_Product_getType(_Product *self, void *closure)
{
   Particle_t p(self->elem->getType());
   std::string val(ParticleType(p));
   return PyUnicode_FromString(val.c_str());
}

static int
_Product_setType(_Product *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setType((Particle_t)var);
   return 0;
}

static PyObject*
_Product_getMomentum(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Product *me = (_Product*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid product element");
      return NULL;
   }
   PyObject *obj = _Momentum_new(&_Momentum_type, 0, 0);
   ((_Momentum*)obj)->elem = &me->elem->getMomentum();
   ((_Momentum*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Product_getMomenta(PyObject *self, PyObject *args)
{
   _Product *me = (_Product*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid product element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Momentum_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getMomenta();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Product_addMomenta(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Product *me = (_Product*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid product element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Momentum_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new MomentumList(me->elem->addMomenta(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Product_deleteMomenta(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Product *me = (_Product*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid product element");
      return NULL;
   }
   me->elem->deleteMomenta(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Product_getPolarization(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Product *me = (_Product*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid product element");
      return NULL;
   }
   PyObject *obj = _Polarization_new(&_Polarization_type, 0, 0);
   ((_Polarization*)obj)->elem = &me->elem->getPolarization();
   ((_Polarization*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Product_getPolarizations(PyObject *self, PyObject *args)
{
   _Product *me = (_Product*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid product element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Polarization_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getPolarizations();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Product_addPolarizations(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Product *me = (_Product*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid product element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Polarization_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new PolarizationList(me->elem->addPolarizations(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Product_deletePolarizations(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Product *me = (_Product*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid product element");
      return NULL;
   }
   me->elem->deletePolarizations(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Product_getProperties(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Product *me = (_Product*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid product element");
      return NULL;
   }
   PyObject *obj = _Properties_new(&_Properties_type, 0, 0);
   ((_Properties*)obj)->elem = &me->elem->getProperties();
   ((_Properties*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Product_getPropertiesList(PyObject *self, PyObject *args)
{
   _Product *me = (_Product*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid product element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Properties_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getPropertiesList();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Product_addPropertiesList(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Product *me = (_Product*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid product element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Properties_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new PropertiesList(me->elem->addPropertiesList(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Product_deletePropertiesList(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Product *me = (_Product*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid product element");
      return NULL;
   }
   me->elem->deletePropertiesList(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Product_toString(PyObject *self, PyObject *args=0)
{
   _Product *me = (_Product*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid product element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Product_toXML(PyObject *self, PyObject *args=0)
{
   _Product *me = (_Product*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid product element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Product_getsetters[] = {
   {(char*)"class",
    (getter)_Product_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"decayVertex",
    (getter)_Product_getDecayVertex, (setter)_Product_setDecayVertex,
    (char*)"decayVertex value",
    NULL},
   {(char*)"eventNo",
    (getter)_Product_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"id",
    (getter)_Product_getId, (setter)_Product_setId,
    (char*)"id value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Product_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"mech",
    (getter)_Product_getMech, (setter)_Product_setMech,
    (char*)"mech value",
    NULL},
   {(char*)"minOccurs",
    (getter)_Product_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"parentid",
    (getter)_Product_getParentid, (setter)_Product_setParentid,
    (char*)"parentid value",
    NULL},
   {(char*)"pdgtype",
    (getter)_Product_getPdgtype, (setter)_Product_setPdgtype,
    (char*)"pdgtype value",
    NULL},
   {(char*)"runNo",
    (getter)_Product_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"type",
    (getter)_Product_getType, (setter)_Product_setType,
    (char*)"type value",
    NULL},
   {(char*)"version",
    (getter)_Product_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"weight",
    (getter)_Product_getWeight, 0,
    (char*)"weight value",
    NULL},
   {(char*)"xmlns",
    (getter)_Product_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Product_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Product_methods[] = {
   {"addMomenta", _Product_addMomenta, METH_VARARGS,
    "extend (or insert into) the list of momentum objects for this product"},
   {"addPolarizations", _Product_addPolarizations, METH_VARARGS,
    "extend (or insert into) the list of polarization objects for this product"},
   {"addPropertiesList", _Product_addPropertiesList, METH_VARARGS,
    "extend (or insert into) the list of properties objects for this product"},
   {"deleteMomenta", _Product_deleteMomenta, METH_VARARGS,
    "delete momentum objects for this product"},
   {"deletePolarizations", _Product_deletePolarizations, METH_VARARGS,
    "delete polarization objects for this product"},
   {"deletePropertiesList", _Product_deletePropertiesList, METH_VARARGS,
    "delete properties objects for this product"},
   {"getMomenta", _Product_getMomenta, METH_NOARGS,
    "get list of momentum objects for this product"},
   {"getMomentum", _Product_getMomentum, METH_VARARGS,
    "get an individual momentum object from this product"},
   {"getPolarization", _Product_getPolarization, METH_VARARGS,
    "get an individual polarization object from this product"},
   {"getPolarizations", _Product_getPolarizations, METH_NOARGS,
    "get list of polarization objects for this product"},
   {"getProperties", _Product_getProperties, METH_VARARGS,
    "get an individual properties object from this product"},
   {"getPropertiesList", _Product_getPropertiesList, METH_NOARGS,
    "get list of properties objects for this product"},
   {"toString", _Product_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Product_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Product_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.Product",         /*tp_name*/
    sizeof(_Product),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Product_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Product_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s product element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Product_methods,          /* tp_methods */
    _Product_members,          /* tp_members */
    _Product_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Product_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Product_new,              /* tp_new */
};



// wrap element class hddm_s::Origin as hddm_s.Origin

typedef struct {
   PyObject_HEAD
   Origin *elem;
   PyObject *host;
} _Origin;

static void
_Origin_dealloc(_Origin* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Origin_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Origin *self;
   self = (_Origin*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Origin_init(_Origin *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Origin_getClass(_Origin *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Origin_getVersion(_Origin *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_Origin_getXmlns(_Origin *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Origin_getEventNo(_Origin *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_Origin_getMaxOccurs(_Origin *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Origin_getRunNo(_Origin *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Origin_getMinOccurs(_Origin *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Origin_getFOM(_Origin *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getFOM());
}

static PyObject*
_Origin_getNdof(_Origin *self, void *closure)
{
   return PyLong_FromLong(self->elem->getNdof());
}

static PyObject*
_Origin_getCandidateid(_Origin *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCandidateid());
}

static PyObject*
_Origin_getChisq(_Origin *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getChisq());
}

static PyObject*
_Origin_getId(_Origin *self, void *closure)
{
   return PyLong_FromLong(self->elem->getId());
}

static PyObject*
_Origin_getTrackid(_Origin *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrackid());
}

static PyObject*
_Origin_getType(_Origin *self, void *closure)
{
   return PyLong_FromLong(self->elem->getType());
}

static PyObject*
_Origin_getWeight(_Origin *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getWeight());
}

static PyObject*
_Origin_getT(_Origin *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_Origin_setT(_Origin *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_Origin_getVx(_Origin *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVx());
}

static int
_Origin_setVx(_Origin *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setVx((float)var);
   return 0;
}

static PyObject*
_Origin_getVy(_Origin *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVy());
}

static int
_Origin_setVy(_Origin *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setVy((float)var);
   return 0;
}

static PyObject*
_Origin_getVz(_Origin *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVz());
}

static int
_Origin_setVz(_Origin *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setVz((float)var);
   return 0;
}

static PyObject*
_Origin_toString(PyObject *self, PyObject *args=0)
{
   _Origin *me = (_Origin*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid origin element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Origin_toXML(PyObject *self, PyObject *args=0)
{
   _Origin *me = (_Origin*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid origin element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Origin_getsetters[] = {
   {(char*)"FOM",
    (getter)_Origin_getFOM, 0,
    (char*)"FOM value",
    NULL},
   {(char*)"Ndof",
    (getter)_Origin_getNdof, 0,
    (char*)"Ndof value",
    NULL},
   {(char*)"candidateid",
    (getter)_Origin_getCandidateid, 0,
    (char*)"candidateid value",
    NULL},
   {(char*)"chisq",
    (getter)_Origin_getChisq, 0,
    (char*)"chisq value",
    NULL},
   {(char*)"class",
    (getter)_Origin_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_Origin_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"id",
    (getter)_Origin_getId, 0,
    (char*)"id value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Origin_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_Origin_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_Origin_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_Origin_getT, (setter)_Origin_setT,
    (char*)"t value",
    NULL},
   {(char*)"trackid",
    (getter)_Origin_getTrackid, 0,
    (char*)"trackid value",
    NULL},
   {(char*)"type",
    (getter)_Origin_getType, 0,
    (char*)"type value",
    NULL},
   {(char*)"version",
    (getter)_Origin_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"vx",
    (getter)_Origin_getVx, (setter)_Origin_setVx,
    (char*)"vx value",
    NULL},
   {(char*)"vy",
    (getter)_Origin_getVy, (setter)_Origin_setVy,
    (char*)"vy value",
    NULL},
   {(char*)"vz",
    (getter)_Origin_getVz, (setter)_Origin_setVz,
    (char*)"vz value",
    NULL},
   {(char*)"weight",
    (getter)_Origin_getWeight, 0,
    (char*)"weight value",
    NULL},
   {(char*)"xmlns",
    (getter)_Origin_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Origin_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Origin_methods[] = {
   {"toString", _Origin_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Origin_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Origin_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.Origin",         /*tp_name*/
    sizeof(_Origin),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Origin_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Origin_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s origin element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Origin_methods,          /* tp_methods */
    _Origin_members,          /* tp_members */
    _Origin_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Origin_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Origin_new,              /* tp_new */
};



// wrap element class hddm_s::Vertex as hddm_s.Vertex

typedef struct {
   PyObject_HEAD
   Vertex *elem;
   PyObject *host;
} _Vertex;

static void
_Vertex_dealloc(_Vertex* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Vertex_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Vertex *self;
   self = (_Vertex*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Vertex_init(_Vertex *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Vertex_getClass(_Vertex *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Vertex_getVersion(_Vertex *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_Vertex_getXmlns(_Vertex *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Vertex_getEventNo(_Vertex *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_Vertex_getRunNo(_Vertex *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Vertex_getMinOccurs(_Vertex *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Vertex_getType(_Vertex *self, void *closure)
{
   return PyLong_FromLong(self->elem->getType());
}

static PyObject*
_Vertex_getWeight(_Vertex *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getWeight());
}

static PyObject*
_Vertex_getMaxOccurs(_Vertex *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Vertex_getProduct(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Vertex *me = (_Vertex*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid vertex element");
      return NULL;
   }
   PyObject *obj = _Product_new(&_Product_type, 0, 0);
   ((_Product*)obj)->elem = &me->elem->getProduct(index);
   ((_Product*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Vertex_getProducts(PyObject *self, PyObject *args)
{
   _Vertex *me = (_Vertex*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid vertex element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Product_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getProducts();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Vertex_addProducts(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Vertex *me = (_Vertex*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid vertex element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Product_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new ProductList(me->elem->addProducts(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Vertex_deleteProducts(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Vertex *me = (_Vertex*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid vertex element");
      return NULL;
   }
   me->elem->deleteProducts(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Vertex_getOrigin(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Vertex *me = (_Vertex*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid vertex element");
      return NULL;
   }
   PyObject *obj = _Origin_new(&_Origin_type, 0, 0);
   ((_Origin*)obj)->elem = &me->elem->getOrigin();
   ((_Origin*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Vertex_getOrigins(PyObject *self, PyObject *args)
{
   _Vertex *me = (_Vertex*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid vertex element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Origin_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getOrigins();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Vertex_addOrigins(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Vertex *me = (_Vertex*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid vertex element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Origin_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new OriginList(me->elem->addOrigins(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Vertex_deleteOrigins(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Vertex *me = (_Vertex*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid vertex element");
      return NULL;
   }
   me->elem->deleteOrigins(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Vertex_toString(PyObject *self, PyObject *args=0)
{
   _Vertex *me = (_Vertex*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid vertex element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Vertex_toXML(PyObject *self, PyObject *args=0)
{
   _Vertex *me = (_Vertex*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid vertex element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Vertex_getsetters[] = {
   {(char*)"class",
    (getter)_Vertex_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_Vertex_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Vertex_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_Vertex_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_Vertex_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"type",
    (getter)_Vertex_getType, 0,
    (char*)"type value",
    NULL},
   {(char*)"version",
    (getter)_Vertex_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"weight",
    (getter)_Vertex_getWeight, 0,
    (char*)"weight value",
    NULL},
   {(char*)"xmlns",
    (getter)_Vertex_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Vertex_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Vertex_methods[] = {
   {"addOrigins", _Vertex_addOrigins, METH_VARARGS,
    "extend (or insert into) the list of origin objects for this vertex"},
   {"addProducts", _Vertex_addProducts, METH_VARARGS,
    "extend (or insert into) the list of product objects for this vertex"},
   {"deleteOrigins", _Vertex_deleteOrigins, METH_VARARGS,
    "delete origin objects for this vertex"},
   {"deleteProducts", _Vertex_deleteProducts, METH_VARARGS,
    "delete product objects for this vertex"},
   {"getOrigin", _Vertex_getOrigin, METH_VARARGS,
    "get an individual origin object from this vertex"},
   {"getOrigins", _Vertex_getOrigins, METH_NOARGS,
    "get list of origin objects for this vertex"},
   {"getProduct", _Vertex_getProduct, METH_VARARGS,
    "get an individual product object from this vertex"},
   {"getProducts", _Vertex_getProducts, METH_NOARGS,
    "get list of product objects for this vertex"},
   {"toString", _Vertex_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Vertex_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Vertex_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.Vertex",         /*tp_name*/
    sizeof(_Vertex),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Vertex_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Vertex_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s vertex element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Vertex_methods,          /* tp_methods */
    _Vertex_members,          /* tp_members */
    _Vertex_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Vertex_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Vertex_new,              /* tp_new */
};



// wrap element class hddm_s::Random as hddm_s.Random

typedef struct {
   PyObject_HEAD
   Random *elem;
   PyObject *host;
} _Random;

static void
_Random_dealloc(_Random* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Random_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Random *self;
   self = (_Random*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Random_init(_Random *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Random_getClass(_Random *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Random_getVersion(_Random *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_Random_getXmlns(_Random *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Random_getEventNo(_Random *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_Random_getRunNo(_Random *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Random_getType(_Random *self, void *closure)
{
   return PyLong_FromLong(self->elem->getType());
}

static PyObject*
_Random_getWeight(_Random *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getWeight());
}

static PyObject*
_Random_getMaxOccurs(_Random *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_Random_getMinOccurs(_Random *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Random_getSeed1(_Random *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSeed1());
}

static int
_Random_setSeed1(_Random *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setSeed1(var);
   return 0;
}

static PyObject*
_Random_getSeed2(_Random *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSeed2());
}

static int
_Random_setSeed2(_Random *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setSeed2(var);
   return 0;
}

static PyObject*
_Random_getSeed3(_Random *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSeed3());
}

static int
_Random_setSeed3(_Random *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setSeed3(var);
   return 0;
}

static PyObject*
_Random_getSeed4(_Random *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSeed4());
}

static int
_Random_setSeed4(_Random *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setSeed4(var);
   return 0;
}

static PyObject*
_Random_toString(PyObject *self, PyObject *args=0)
{
   _Random *me = (_Random*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid random element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Random_toXML(PyObject *self, PyObject *args=0)
{
   _Random *me = (_Random*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid random element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Random_getsetters[] = {
   {(char*)"class",
    (getter)_Random_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_Random_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Random_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_Random_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_Random_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"seed1",
    (getter)_Random_getSeed1, (setter)_Random_setSeed1,
    (char*)"seed1 value",
    NULL},
   {(char*)"seed2",
    (getter)_Random_getSeed2, (setter)_Random_setSeed2,
    (char*)"seed2 value",
    NULL},
   {(char*)"seed3",
    (getter)_Random_getSeed3, (setter)_Random_setSeed3,
    (char*)"seed3 value",
    NULL},
   {(char*)"seed4",
    (getter)_Random_getSeed4, (setter)_Random_setSeed4,
    (char*)"seed4 value",
    NULL},
   {(char*)"type",
    (getter)_Random_getType, 0,
    (char*)"type value",
    NULL},
   {(char*)"version",
    (getter)_Random_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"weight",
    (getter)_Random_getWeight, 0,
    (char*)"weight value",
    NULL},
   {(char*)"xmlns",
    (getter)_Random_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Random_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Random_methods[] = {
   {"toString", _Random_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Random_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Random_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.Random",         /*tp_name*/
    sizeof(_Random),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Random_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Random_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s random element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Random_methods,          /* tp_methods */
    _Random_members,          /* tp_members */
    _Random_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Random_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Random_new,              /* tp_new */
};



// wrap element class hddm_s::UserDataFloat as hddm_s.UserDataFloat

typedef struct {
   PyObject_HEAD
   UserDataFloat *elem;
   PyObject *host;
} _UserDataFloat;

static void
_UserDataFloat_dealloc(_UserDataFloat* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_UserDataFloat_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _UserDataFloat *self;
   self = (_UserDataFloat*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_UserDataFloat_init(_UserDataFloat *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_UserDataFloat_getClass(_UserDataFloat *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_UserDataFloat_getVersion(_UserDataFloat *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_UserDataFloat_getXmlns(_UserDataFloat *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_UserDataFloat_getEventNo(_UserDataFloat *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_UserDataFloat_getRunNo(_UserDataFloat *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_UserDataFloat_getType(_UserDataFloat *self, void *closure)
{
   return PyLong_FromLong(self->elem->getType());
}

static PyObject*
_UserDataFloat_getWeight(_UserDataFloat *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getWeight());
}

static PyObject*
_UserDataFloat_getDescription(_UserDataFloat *self, void *closure)
{
   std::string val(self->elem->getDescription());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_UserDataFloat_getData(_UserDataFloat *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getData());
}

static int
_UserDataFloat_setData(_UserDataFloat *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setData((float)var);
   return 0;
}

static PyObject*
_UserDataFloat_getMaxOccurs(_UserDataFloat *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_UserDataFloat_getMeaning(_UserDataFloat *self, void *closure)
{
   std::string val(self->elem->getMeaning());
   return PyUnicode_FromString(val.c_str());
}

static int
_UserDataFloat_setMeaning(_UserDataFloat *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setMeaning(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_UserDataFloat_getMinOccurs(_UserDataFloat *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_UserDataFloat_toString(PyObject *self, PyObject *args=0)
{
   _UserDataFloat *me = (_UserDataFloat*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid userDataFloat element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_UserDataFloat_toXML(PyObject *self, PyObject *args=0)
{
   _UserDataFloat *me = (_UserDataFloat*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid userDataFloat element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _UserDataFloat_getsetters[] = {
   {(char*)"class",
    (getter)_UserDataFloat_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"data",
    (getter)_UserDataFloat_getData, (setter)_UserDataFloat_setData,
    (char*)"data value",
    NULL},
   {(char*)"description",
    (getter)_UserDataFloat_getDescription, 0,
    (char*)"description string",
    NULL},
   {(char*)"eventNo",
    (getter)_UserDataFloat_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_UserDataFloat_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"meaning",
    (getter)_UserDataFloat_getMeaning, (setter)_UserDataFloat_setMeaning,
    (char*)"meaning string",
    NULL},
   {(char*)"minOccurs",
    (getter)_UserDataFloat_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_UserDataFloat_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"type",
    (getter)_UserDataFloat_getType, 0,
    (char*)"type value",
    NULL},
   {(char*)"version",
    (getter)_UserDataFloat_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"weight",
    (getter)_UserDataFloat_getWeight, 0,
    (char*)"weight value",
    NULL},
   {(char*)"xmlns",
    (getter)_UserDataFloat_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _UserDataFloat_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _UserDataFloat_methods[] = {
   {"toString", _UserDataFloat_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _UserDataFloat_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _UserDataFloat_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.UserDataFloat",         /*tp_name*/
    sizeof(_UserDataFloat),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_UserDataFloat_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_UserDataFloat_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s userDataFloat element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _UserDataFloat_methods,          /* tp_methods */
    _UserDataFloat_members,          /* tp_members */
    _UserDataFloat_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_UserDataFloat_init,   /* tp_init */
    0,                         /* tp_alloc */
    _UserDataFloat_new,              /* tp_new */
};



// wrap element class hddm_s::UserDataInt as hddm_s.UserDataInt

typedef struct {
   PyObject_HEAD
   UserDataInt *elem;
   PyObject *host;
} _UserDataInt;

static void
_UserDataInt_dealloc(_UserDataInt* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_UserDataInt_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _UserDataInt *self;
   self = (_UserDataInt*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_UserDataInt_init(_UserDataInt *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_UserDataInt_getClass(_UserDataInt *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_UserDataInt_getVersion(_UserDataInt *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_UserDataInt_getXmlns(_UserDataInt *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_UserDataInt_getEventNo(_UserDataInt *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_UserDataInt_getRunNo(_UserDataInt *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_UserDataInt_getType(_UserDataInt *self, void *closure)
{
   return PyLong_FromLong(self->elem->getType());
}

static PyObject*
_UserDataInt_getWeight(_UserDataInt *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getWeight());
}

static PyObject*
_UserDataInt_getDescription(_UserDataInt *self, void *closure)
{
   std::string val(self->elem->getDescription());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_UserDataInt_getData(_UserDataInt *self, void *closure)
{
   return PyLong_FromLong(self->elem->getData());
}

static int
_UserDataInt_setData(_UserDataInt *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setData(var);
   return 0;
}

static PyObject*
_UserDataInt_getMaxOccurs(_UserDataInt *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_UserDataInt_getMeaning(_UserDataInt *self, void *closure)
{
   std::string val(self->elem->getMeaning());
   return PyUnicode_FromString(val.c_str());
}

static int
_UserDataInt_setMeaning(_UserDataInt *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setMeaning(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_UserDataInt_getMinOccurs(_UserDataInt *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_UserDataInt_toString(PyObject *self, PyObject *args=0)
{
   _UserDataInt *me = (_UserDataInt*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid userDataInt element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_UserDataInt_toXML(PyObject *self, PyObject *args=0)
{
   _UserDataInt *me = (_UserDataInt*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid userDataInt element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _UserDataInt_getsetters[] = {
   {(char*)"class",
    (getter)_UserDataInt_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"data",
    (getter)_UserDataInt_getData, (setter)_UserDataInt_setData,
    (char*)"data value",
    NULL},
   {(char*)"description",
    (getter)_UserDataInt_getDescription, 0,
    (char*)"description string",
    NULL},
   {(char*)"eventNo",
    (getter)_UserDataInt_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_UserDataInt_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"meaning",
    (getter)_UserDataInt_getMeaning, (setter)_UserDataInt_setMeaning,
    (char*)"meaning string",
    NULL},
   {(char*)"minOccurs",
    (getter)_UserDataInt_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_UserDataInt_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"type",
    (getter)_UserDataInt_getType, 0,
    (char*)"type value",
    NULL},
   {(char*)"version",
    (getter)_UserDataInt_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"weight",
    (getter)_UserDataInt_getWeight, 0,
    (char*)"weight value",
    NULL},
   {(char*)"xmlns",
    (getter)_UserDataInt_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _UserDataInt_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _UserDataInt_methods[] = {
   {"toString", _UserDataInt_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _UserDataInt_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _UserDataInt_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.UserDataInt",         /*tp_name*/
    sizeof(_UserDataInt),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_UserDataInt_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_UserDataInt_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s userDataInt element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _UserDataInt_methods,          /* tp_methods */
    _UserDataInt_members,          /* tp_members */
    _UserDataInt_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_UserDataInt_init,   /* tp_init */
    0,                         /* tp_alloc */
    _UserDataInt_new,              /* tp_new */
};



// wrap element class hddm_s::UserData as hddm_s.UserData

typedef struct {
   PyObject_HEAD
   UserData *elem;
   PyObject *host;
} _UserData;

static void
_UserData_dealloc(_UserData* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_UserData_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _UserData *self;
   self = (_UserData*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_UserData_init(_UserData *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_UserData_getClass(_UserData *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_UserData_getVersion(_UserData *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_UserData_getXmlns(_UserData *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_UserData_getEventNo(_UserData *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_UserData_getRunNo(_UserData *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_UserData_getType(_UserData *self, void *closure)
{
   return PyLong_FromLong(self->elem->getType());
}

static PyObject*
_UserData_getWeight(_UserData *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getWeight());
}

static PyObject*
_UserData_getDescription(_UserData *self, void *closure)
{
   std::string val(self->elem->getDescription());
   return PyUnicode_FromString(val.c_str());
}

static int
_UserData_setDescription(_UserData *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setDescription(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_UserData_getMaxOccurs(_UserData *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_UserData_getMinOccurs(_UserData *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_UserData_getUserDataFloat(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _UserData *me = (_UserData*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid userData element");
      return NULL;
   }
   PyObject *obj = _UserDataFloat_new(&_UserDataFloat_type, 0, 0);
   ((_UserDataFloat*)obj)->elem = &me->elem->getUserDataFloat(index);
   ((_UserDataFloat*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_UserData_getUserDataFloats(PyObject *self, PyObject *args)
{
   _UserData *me = (_UserData*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid userData element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_UserDataFloat_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getUserDataFloats();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_UserData_addUserDataFloats(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _UserData *me = (_UserData*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid userData element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_UserDataFloat_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new UserDataFloatList(me->elem->addUserDataFloats(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_UserData_deleteUserDataFloats(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _UserData *me = (_UserData*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid userData element");
      return NULL;
   }
   me->elem->deleteUserDataFloats(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_UserData_getUserDataInt(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _UserData *me = (_UserData*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid userData element");
      return NULL;
   }
   PyObject *obj = _UserDataInt_new(&_UserDataInt_type, 0, 0);
   ((_UserDataInt*)obj)->elem = &me->elem->getUserDataInt(index);
   ((_UserDataInt*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_UserData_getUserDataInts(PyObject *self, PyObject *args)
{
   _UserData *me = (_UserData*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid userData element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_UserDataInt_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getUserDataInts();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_UserData_addUserDataInts(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _UserData *me = (_UserData*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid userData element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_UserDataInt_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new UserDataIntList(me->elem->addUserDataInts(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_UserData_deleteUserDataInts(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _UserData *me = (_UserData*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid userData element");
      return NULL;
   }
   me->elem->deleteUserDataInts(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_UserData_toString(PyObject *self, PyObject *args=0)
{
   _UserData *me = (_UserData*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid userData element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_UserData_toXML(PyObject *self, PyObject *args=0)
{
   _UserData *me = (_UserData*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid userData element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _UserData_getsetters[] = {
   {(char*)"class",
    (getter)_UserData_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"description",
    (getter)_UserData_getDescription, (setter)_UserData_setDescription,
    (char*)"description string",
    NULL},
   {(char*)"eventNo",
    (getter)_UserData_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_UserData_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_UserData_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_UserData_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"type",
    (getter)_UserData_getType, 0,
    (char*)"type value",
    NULL},
   {(char*)"version",
    (getter)_UserData_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"weight",
    (getter)_UserData_getWeight, 0,
    (char*)"weight value",
    NULL},
   {(char*)"xmlns",
    (getter)_UserData_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _UserData_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _UserData_methods[] = {
   {"addUserDataFloats", _UserData_addUserDataFloats, METH_VARARGS,
    "extend (or insert into) the list of userDataFloat objects for this userData"},
   {"addUserDataInts", _UserData_addUserDataInts, METH_VARARGS,
    "extend (or insert into) the list of userDataInt objects for this userData"},
   {"deleteUserDataFloats", _UserData_deleteUserDataFloats, METH_VARARGS,
    "delete userDataFloat objects for this userData"},
   {"deleteUserDataInts", _UserData_deleteUserDataInts, METH_VARARGS,
    "delete userDataInt objects for this userData"},
   {"getUserDataFloat", _UserData_getUserDataFloat, METH_VARARGS,
    "get an individual userDataFloat object from this userData"},
   {"getUserDataFloats", _UserData_getUserDataFloats, METH_NOARGS,
    "get list of userDataFloat objects for this userData"},
   {"getUserDataInt", _UserData_getUserDataInt, METH_VARARGS,
    "get an individual userDataInt object from this userData"},
   {"getUserDataInts", _UserData_getUserDataInts, METH_NOARGS,
    "get list of userDataInt objects for this userData"},
   {"toString", _UserData_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _UserData_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _UserData_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.UserData",         /*tp_name*/
    sizeof(_UserData),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_UserData_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_UserData_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s userData element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _UserData_methods,          /* tp_methods */
    _UserData_members,          /* tp_members */
    _UserData_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_UserData_init,   /* tp_init */
    0,                         /* tp_alloc */
    _UserData_new,              /* tp_new */
};



// wrap element class hddm_s::Reaction as hddm_s.Reaction

typedef struct {
   PyObject_HEAD
   Reaction *elem;
   PyObject *host;
} _Reaction;

static void
_Reaction_dealloc(_Reaction* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Reaction_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Reaction *self;
   self = (_Reaction*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Reaction_init(_Reaction *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Reaction_getClass(_Reaction *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Reaction_getVersion(_Reaction *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_Reaction_getXmlns(_Reaction *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Reaction_getEventNo(_Reaction *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_Reaction_getRunNo(_Reaction *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Reaction_getMaxOccurs(_Reaction *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Reaction_getMinOccurs(_Reaction *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Reaction_getType(_Reaction *self, void *closure)
{
   return PyLong_FromLong(self->elem->getType());
}

static int
_Reaction_setType(_Reaction *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setType(var);
   return 0;
}

static PyObject*
_Reaction_getWeight(_Reaction *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getWeight());
}

static int
_Reaction_setWeight(_Reaction *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setWeight((float)var);
   return 0;
}

static PyObject*
_Reaction_getBeam(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reaction element");
      return NULL;
   }
   PyObject *obj = _Beam_new(&_Beam_type, 0, 0);
   ((_Beam*)obj)->elem = &me->elem->getBeam();
   ((_Beam*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Reaction_getBeams(PyObject *self, PyObject *args)
{
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reaction element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Beam_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getBeams();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Reaction_addBeams(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reaction element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Beam_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BeamList(me->elem->addBeams(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Reaction_deleteBeams(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reaction element");
      return NULL;
   }
   me->elem->deleteBeams(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Reaction_getTarget(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reaction element");
      return NULL;
   }
   PyObject *obj = _Target_new(&_Target_type, 0, 0);
   ((_Target*)obj)->elem = &me->elem->getTarget();
   ((_Target*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Reaction_getTargets(PyObject *self, PyObject *args)
{
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reaction element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Target_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTargets();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Reaction_addTargets(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reaction element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Target_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TargetList(me->elem->addTargets(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Reaction_deleteTargets(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reaction element");
      return NULL;
   }
   me->elem->deleteTargets(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Reaction_getVertex(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reaction element");
      return NULL;
   }
   PyObject *obj = _Vertex_new(&_Vertex_type, 0, 0);
   ((_Vertex*)obj)->elem = &me->elem->getVertex(index);
   ((_Vertex*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Reaction_getVertices(PyObject *self, PyObject *args)
{
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reaction element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Vertex_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getVertices();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Reaction_addVertices(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reaction element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Vertex_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new VertexList(me->elem->addVertices(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Reaction_deleteVertices(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reaction element");
      return NULL;
   }
   me->elem->deleteVertices(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Reaction_getRandom(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reaction element");
      return NULL;
   }
   PyObject *obj = _Random_new(&_Random_type, 0, 0);
   ((_Random*)obj)->elem = &me->elem->getRandom();
   ((_Random*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Reaction_getRandoms(PyObject *self, PyObject *args)
{
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reaction element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Random_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getRandoms();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Reaction_addRandoms(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reaction element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_Random_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new RandomList(me->elem->addRandoms(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Reaction_deleteRandoms(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reaction element");
      return NULL;
   }
   me->elem->deleteRandoms(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Reaction_getUserData(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reaction element");
      return NULL;
   }
   PyObject *obj = _UserData_new(&_UserData_type, 0, 0);
   ((_UserData*)obj)->elem = &me->elem->getUserData(index);
   ((_UserData*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Reaction_getUserDatas(PyObject *self, PyObject *args)
{
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reaction element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_UserData_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getUserDatas();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Reaction_addUserDatas(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid reaction element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_UserData_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new UserDataList(me->elem->addUserDatas(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Reaction_deleteUserDatas(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid reaction element");
      return NULL;
   }
   me->elem->deleteUserDatas(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Reaction_toString(PyObject *self, PyObject *args=0)
{
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reaction element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Reaction_toXML(PyObject *self, PyObject *args=0)
{
   _Reaction *me = (_Reaction*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid reaction element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Reaction_getsetters[] = {
   {(char*)"class",
    (getter)_Reaction_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_Reaction_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Reaction_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_Reaction_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_Reaction_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"type",
    (getter)_Reaction_getType, (setter)_Reaction_setType,
    (char*)"type value",
    NULL},
   {(char*)"version",
    (getter)_Reaction_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"weight",
    (getter)_Reaction_getWeight, (setter)_Reaction_setWeight,
    (char*)"weight value",
    NULL},
   {(char*)"xmlns",
    (getter)_Reaction_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Reaction_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Reaction_methods[] = {
   {"addBeams", _Reaction_addBeams, METH_VARARGS,
    "extend (or insert into) the list of beam objects for this reaction"},
   {"addRandoms", _Reaction_addRandoms, METH_VARARGS,
    "extend (or insert into) the list of random objects for this reaction"},
   {"addTargets", _Reaction_addTargets, METH_VARARGS,
    "extend (or insert into) the list of target objects for this reaction"},
   {"addUserDatas", _Reaction_addUserDatas, METH_VARARGS,
    "extend (or insert into) the list of userData objects for this reaction"},
   {"addVertices", _Reaction_addVertices, METH_VARARGS,
    "extend (or insert into) the list of vertex objects for this reaction"},
   {"deleteBeams", _Reaction_deleteBeams, METH_VARARGS,
    "delete beam objects for this reaction"},
   {"deleteRandoms", _Reaction_deleteRandoms, METH_VARARGS,
    "delete random objects for this reaction"},
   {"deleteTargets", _Reaction_deleteTargets, METH_VARARGS,
    "delete target objects for this reaction"},
   {"deleteUserDatas", _Reaction_deleteUserDatas, METH_VARARGS,
    "delete userData objects for this reaction"},
   {"deleteVertices", _Reaction_deleteVertices, METH_VARARGS,
    "delete vertex objects for this reaction"},
   {"getBeam", _Reaction_getBeam, METH_VARARGS,
    "get an individual beam object from this reaction"},
   {"getBeams", _Reaction_getBeams, METH_NOARGS,
    "get list of beam objects for this reaction"},
   {"getRandom", _Reaction_getRandom, METH_VARARGS,
    "get an individual random object from this reaction"},
   {"getRandoms", _Reaction_getRandoms, METH_NOARGS,
    "get list of random objects for this reaction"},
   {"getTarget", _Reaction_getTarget, METH_VARARGS,
    "get an individual target object from this reaction"},
   {"getTargets", _Reaction_getTargets, METH_NOARGS,
    "get list of target objects for this reaction"},
   {"getUserData", _Reaction_getUserData, METH_VARARGS,
    "get an individual userData object from this reaction"},
   {"getUserDatas", _Reaction_getUserDatas, METH_NOARGS,
    "get list of userData objects for this reaction"},
   {"getVertex", _Reaction_getVertex, METH_VARARGS,
    "get an individual vertex object from this reaction"},
   {"getVertices", _Reaction_getVertices, METH_NOARGS,
    "get list of vertex objects for this reaction"},
   {"toString", _Reaction_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Reaction_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Reaction_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.Reaction",         /*tp_name*/
    sizeof(_Reaction),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Reaction_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Reaction_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s reaction element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Reaction_methods,          /* tp_methods */
    _Reaction_members,          /* tp_members */
    _Reaction_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Reaction_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Reaction_new,              /* tp_new */
};



// wrap element class hddm_s::CdcDigihit as hddm_s.CdcDigihit

typedef struct {
   PyObject_HEAD
   CdcDigihit *elem;
   PyObject *host;
} _CdcDigihit;

static void
_CdcDigihit_dealloc(_CdcDigihit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_CdcDigihit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _CdcDigihit *self;
   self = (_CdcDigihit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_CdcDigihit_init(_CdcDigihit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_CdcDigihit_getClass(_CdcDigihit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcDigihit_getVersion(_CdcDigihit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_CdcDigihit_getXmlns(_CdcDigihit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcDigihit_getEventNo(_CdcDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_CdcDigihit_getMaxOccurs(_CdcDigihit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcDigihit_getRunNo(_CdcDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_CdcDigihit_getRing(_CdcDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRing());
}

static PyObject*
_CdcDigihit_getStraw(_CdcDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getStraw());
}

static PyObject*
_CdcDigihit_getQ(_CdcDigihit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getQ());
}

static PyObject*
_CdcDigihit_getT(_CdcDigihit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_CdcDigihit_getMinOccurs(_CdcDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_CdcDigihit_getPeakAmp(_CdcDigihit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPeakAmp());
}

static int
_CdcDigihit_setPeakAmp(_CdcDigihit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPeakAmp((float)var);
   return 0;
}

static PyObject*
_CdcDigihit_toString(PyObject *self, PyObject *args=0)
{
   _CdcDigihit *me = (_CdcDigihit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcDigihit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_CdcDigihit_toXML(PyObject *self, PyObject *args=0)
{
   _CdcDigihit *me = (_CdcDigihit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcDigihit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _CdcDigihit_getsetters[] = {
   {(char*)"class",
    (getter)_CdcDigihit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_CdcDigihit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_CdcDigihit_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_CdcDigihit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"peakAmp",
    (getter)_CdcDigihit_getPeakAmp, (setter)_CdcDigihit_setPeakAmp,
    (char*)"peakAmp value",
    NULL},
   {(char*)"q",
    (getter)_CdcDigihit_getQ, 0,
    (char*)"q value",
    NULL},
   {(char*)"ring",
    (getter)_CdcDigihit_getRing, 0,
    (char*)"ring value",
    NULL},
   {(char*)"runNo",
    (getter)_CdcDigihit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"straw",
    (getter)_CdcDigihit_getStraw, 0,
    (char*)"straw value",
    NULL},
   {(char*)"t",
    (getter)_CdcDigihit_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_CdcDigihit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_CdcDigihit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _CdcDigihit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _CdcDigihit_methods[] = {
   {"toString", _CdcDigihit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _CdcDigihit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _CdcDigihit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.CdcDigihit",         /*tp_name*/
    sizeof(_CdcDigihit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_CdcDigihit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_CdcDigihit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s cdcDigihit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _CdcDigihit_methods,          /* tp_methods */
    _CdcDigihit_members,          /* tp_members */
    _CdcDigihit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_CdcDigihit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _CdcDigihit_new,              /* tp_new */
};



// wrap element class hddm_s::CdcHitQF as hddm_s.CdcHitQF

typedef struct {
   PyObject_HEAD
   CdcHitQF *elem;
   PyObject *host;
} _CdcHitQF;

static void
_CdcHitQF_dealloc(_CdcHitQF* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_CdcHitQF_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _CdcHitQF *self;
   self = (_CdcHitQF*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_CdcHitQF_init(_CdcHitQF *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_CdcHitQF_getClass(_CdcHitQF *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcHitQF_getVersion(_CdcHitQF *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_CdcHitQF_getXmlns(_CdcHitQF *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcHitQF_getEventNo(_CdcHitQF *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_CdcHitQF_getMaxOccurs(_CdcHitQF *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcHitQF_getRunNo(_CdcHitQF *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_CdcHitQF_getRing(_CdcHitQF *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRing());
}

static PyObject*
_CdcHitQF_getStraw(_CdcHitQF *self, void *closure)
{
   return PyLong_FromLong(self->elem->getStraw());
}

static PyObject*
_CdcHitQF_getQ(_CdcHitQF *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getQ());
}

static PyObject*
_CdcHitQF_getT(_CdcHitQF *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_CdcHitQF_getQF(_CdcHitQF *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getQF());
}

static int
_CdcHitQF_setQF(_CdcHitQF *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setQF((float)var);
   return 0;
}

static PyObject*
_CdcHitQF_getMinOccurs(_CdcHitQF *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_CdcHitQF_toString(PyObject *self, PyObject *args=0)
{
   _CdcHitQF *me = (_CdcHitQF*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcHitQF element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_CdcHitQF_toXML(PyObject *self, PyObject *args=0)
{
   _CdcHitQF *me = (_CdcHitQF*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcHitQF element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _CdcHitQF_getsetters[] = {
   {(char*)"QF",
    (getter)_CdcHitQF_getQF, (setter)_CdcHitQF_setQF,
    (char*)"QF value",
    NULL},
   {(char*)"class",
    (getter)_CdcHitQF_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_CdcHitQF_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_CdcHitQF_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_CdcHitQF_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"q",
    (getter)_CdcHitQF_getQ, 0,
    (char*)"q value",
    NULL},
   {(char*)"ring",
    (getter)_CdcHitQF_getRing, 0,
    (char*)"ring value",
    NULL},
   {(char*)"runNo",
    (getter)_CdcHitQF_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"straw",
    (getter)_CdcHitQF_getStraw, 0,
    (char*)"straw value",
    NULL},
   {(char*)"t",
    (getter)_CdcHitQF_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_CdcHitQF_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_CdcHitQF_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _CdcHitQF_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _CdcHitQF_methods[] = {
   {"toString", _CdcHitQF_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _CdcHitQF_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _CdcHitQF_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.CdcHitQF",         /*tp_name*/
    sizeof(_CdcHitQF),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_CdcHitQF_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_CdcHitQF_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s cdcHitQF element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _CdcHitQF_methods,          /* tp_methods */
    _CdcHitQF_members,          /* tp_members */
    _CdcHitQF_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_CdcHitQF_init,   /* tp_init */
    0,                         /* tp_alloc */
    _CdcHitQF_new,              /* tp_new */
};



// wrap element class hddm_s::CdcStrawHit as hddm_s.CdcStrawHit

typedef struct {
   PyObject_HEAD
   CdcStrawHit *elem;
   PyObject *host;
} _CdcStrawHit;

static void
_CdcStrawHit_dealloc(_CdcStrawHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_CdcStrawHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _CdcStrawHit *self;
   self = (_CdcStrawHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_CdcStrawHit_init(_CdcStrawHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_CdcStrawHit_getClass(_CdcStrawHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcStrawHit_getVersion(_CdcStrawHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_CdcStrawHit_getXmlns(_CdcStrawHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcStrawHit_getEventNo(_CdcStrawHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_CdcStrawHit_getRunNo(_CdcStrawHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_CdcStrawHit_getMinOccurs(_CdcStrawHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_CdcStrawHit_getRing(_CdcStrawHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRing());
}

static PyObject*
_CdcStrawHit_getStraw(_CdcStrawHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getStraw());
}

static PyObject*
_CdcStrawHit_getMaxOccurs(_CdcStrawHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcStrawHit_getQ(_CdcStrawHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getQ());
}

static int
_CdcStrawHit_setQ(_CdcStrawHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setQ((float)var);
   return 0;
}

static PyObject*
_CdcStrawHit_getT(_CdcStrawHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_CdcStrawHit_setT(_CdcStrawHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_CdcStrawHit_getCdcDigihit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _CdcStrawHit *me = (_CdcStrawHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcStrawHit element");
      return NULL;
   }
   PyObject *obj = _CdcDigihit_new(&_CdcDigihit_type, 0, 0);
   ((_CdcDigihit*)obj)->elem = &me->elem->getCdcDigihit();
   ((_CdcDigihit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_CdcStrawHit_getCdcDigihits(PyObject *self, PyObject *args)
{
   _CdcStrawHit *me = (_CdcStrawHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcStrawHit element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CdcDigihit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getCdcDigihits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_CdcStrawHit_addCdcDigihits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CdcStrawHit *me = (_CdcStrawHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid cdcStrawHit element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CdcDigihit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CdcDigihitList(me->elem->addCdcDigihits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_CdcStrawHit_deleteCdcDigihits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CdcStrawHit *me = (_CdcStrawHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid cdcStrawHit element");
      return NULL;
   }
   me->elem->deleteCdcDigihits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_CdcStrawHit_getCdcHitQF(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _CdcStrawHit *me = (_CdcStrawHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcStrawHit element");
      return NULL;
   }
   PyObject *obj = _CdcHitQF_new(&_CdcHitQF_type, 0, 0);
   ((_CdcHitQF*)obj)->elem = &me->elem->getCdcHitQF();
   ((_CdcHitQF*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_CdcStrawHit_getCdcHitQFs(PyObject *self, PyObject *args)
{
   _CdcStrawHit *me = (_CdcStrawHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcStrawHit element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CdcHitQF_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getCdcHitQFs();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_CdcStrawHit_addCdcHitQFs(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CdcStrawHit *me = (_CdcStrawHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid cdcStrawHit element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CdcHitQF_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CdcHitQFList(me->elem->addCdcHitQFs(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_CdcStrawHit_deleteCdcHitQFs(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CdcStrawHit *me = (_CdcStrawHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid cdcStrawHit element");
      return NULL;
   }
   me->elem->deleteCdcHitQFs(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_CdcStrawHit_toString(PyObject *self, PyObject *args=0)
{
   _CdcStrawHit *me = (_CdcStrawHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcStrawHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_CdcStrawHit_toXML(PyObject *self, PyObject *args=0)
{
   _CdcStrawHit *me = (_CdcStrawHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcStrawHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _CdcStrawHit_getsetters[] = {
   {(char*)"class",
    (getter)_CdcStrawHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_CdcStrawHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_CdcStrawHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_CdcStrawHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"q",
    (getter)_CdcStrawHit_getQ, (setter)_CdcStrawHit_setQ,
    (char*)"q value",
    NULL},
   {(char*)"ring",
    (getter)_CdcStrawHit_getRing, 0,
    (char*)"ring value",
    NULL},
   {(char*)"runNo",
    (getter)_CdcStrawHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"straw",
    (getter)_CdcStrawHit_getStraw, 0,
    (char*)"straw value",
    NULL},
   {(char*)"t",
    (getter)_CdcStrawHit_getT, (setter)_CdcStrawHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_CdcStrawHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_CdcStrawHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _CdcStrawHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _CdcStrawHit_methods[] = {
   {"addCdcDigihits", _CdcStrawHit_addCdcDigihits, METH_VARARGS,
    "extend (or insert into) the list of cdcDigihit objects for this cdcStrawHit"},
   {"addCdcHitQFs", _CdcStrawHit_addCdcHitQFs, METH_VARARGS,
    "extend (or insert into) the list of cdcHitQF objects for this cdcStrawHit"},
   {"deleteCdcDigihits", _CdcStrawHit_deleteCdcDigihits, METH_VARARGS,
    "delete cdcDigihit objects for this cdcStrawHit"},
   {"deleteCdcHitQFs", _CdcStrawHit_deleteCdcHitQFs, METH_VARARGS,
    "delete cdcHitQF objects for this cdcStrawHit"},
   {"getCdcDigihit", _CdcStrawHit_getCdcDigihit, METH_VARARGS,
    "get an individual cdcDigihit object from this cdcStrawHit"},
   {"getCdcDigihits", _CdcStrawHit_getCdcDigihits, METH_NOARGS,
    "get list of cdcDigihit objects for this cdcStrawHit"},
   {"getCdcHitQF", _CdcStrawHit_getCdcHitQF, METH_VARARGS,
    "get an individual cdcHitQF object from this cdcStrawHit"},
   {"getCdcHitQFs", _CdcStrawHit_getCdcHitQFs, METH_NOARGS,
    "get list of cdcHitQF objects for this cdcStrawHit"},
   {"toString", _CdcStrawHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _CdcStrawHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _CdcStrawHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.CdcStrawHit",         /*tp_name*/
    sizeof(_CdcStrawHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_CdcStrawHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_CdcStrawHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s cdcStrawHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _CdcStrawHit_methods,          /* tp_methods */
    _CdcStrawHit_members,          /* tp_members */
    _CdcStrawHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_CdcStrawHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _CdcStrawHit_new,              /* tp_new */
};



// wrap element class hddm_s::CdcStrawTruthHit as hddm_s.CdcStrawTruthHit

typedef struct {
   PyObject_HEAD
   CdcStrawTruthHit *elem;
   PyObject *host;
} _CdcStrawTruthHit;

static void
_CdcStrawTruthHit_dealloc(_CdcStrawTruthHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_CdcStrawTruthHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _CdcStrawTruthHit *self;
   self = (_CdcStrawTruthHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_CdcStrawTruthHit_init(_CdcStrawTruthHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_CdcStrawTruthHit_getClass(_CdcStrawTruthHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcStrawTruthHit_getVersion(_CdcStrawTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_CdcStrawTruthHit_getXmlns(_CdcStrawTruthHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcStrawTruthHit_getEventNo(_CdcStrawTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_CdcStrawTruthHit_getRunNo(_CdcStrawTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_CdcStrawTruthHit_getMinOccurs(_CdcStrawTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_CdcStrawTruthHit_getRing(_CdcStrawTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRing());
}

static PyObject*
_CdcStrawTruthHit_getStraw(_CdcStrawTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getStraw());
}

static PyObject*
_CdcStrawTruthHit_getD(_CdcStrawTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getD());
}

static int
_CdcStrawTruthHit_setD(_CdcStrawTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setD((float)var);
   return 0;
}

static PyObject*
_CdcStrawTruthHit_getItrack(_CdcStrawTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getItrack());
}

static int
_CdcStrawTruthHit_setItrack(_CdcStrawTruthHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setItrack(var);
   return 0;
}

static PyObject*
_CdcStrawTruthHit_getMaxOccurs(_CdcStrawTruthHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcStrawTruthHit_getPtype(_CdcStrawTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPtype());
}

static int
_CdcStrawTruthHit_setPtype(_CdcStrawTruthHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPtype(var);
   return 0;
}

static PyObject*
_CdcStrawTruthHit_getQ(_CdcStrawTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getQ());
}

static int
_CdcStrawTruthHit_setQ(_CdcStrawTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setQ((float)var);
   return 0;
}

static PyObject*
_CdcStrawTruthHit_getT(_CdcStrawTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_CdcStrawTruthHit_setT(_CdcStrawTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_CdcStrawTruthHit_toString(PyObject *self, PyObject *args=0)
{
   _CdcStrawTruthHit *me = (_CdcStrawTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcStrawTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_CdcStrawTruthHit_toXML(PyObject *self, PyObject *args=0)
{
   _CdcStrawTruthHit *me = (_CdcStrawTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcStrawTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _CdcStrawTruthHit_getsetters[] = {
   {(char*)"class",
    (getter)_CdcStrawTruthHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"d",
    (getter)_CdcStrawTruthHit_getD, (setter)_CdcStrawTruthHit_setD,
    (char*)"d value",
    NULL},
   {(char*)"eventNo",
    (getter)_CdcStrawTruthHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"itrack",
    (getter)_CdcStrawTruthHit_getItrack, (setter)_CdcStrawTruthHit_setItrack,
    (char*)"itrack value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_CdcStrawTruthHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_CdcStrawTruthHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"ptype",
    (getter)_CdcStrawTruthHit_getPtype, (setter)_CdcStrawTruthHit_setPtype,
    (char*)"ptype value",
    NULL},
   {(char*)"q",
    (getter)_CdcStrawTruthHit_getQ, (setter)_CdcStrawTruthHit_setQ,
    (char*)"q value",
    NULL},
   {(char*)"ring",
    (getter)_CdcStrawTruthHit_getRing, 0,
    (char*)"ring value",
    NULL},
   {(char*)"runNo",
    (getter)_CdcStrawTruthHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"straw",
    (getter)_CdcStrawTruthHit_getStraw, 0,
    (char*)"straw value",
    NULL},
   {(char*)"t",
    (getter)_CdcStrawTruthHit_getT, (setter)_CdcStrawTruthHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_CdcStrawTruthHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_CdcStrawTruthHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _CdcStrawTruthHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _CdcStrawTruthHit_methods[] = {
   {"toString", _CdcStrawTruthHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _CdcStrawTruthHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _CdcStrawTruthHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.CdcStrawTruthHit",         /*tp_name*/
    sizeof(_CdcStrawTruthHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_CdcStrawTruthHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_CdcStrawTruthHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s cdcStrawTruthHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _CdcStrawTruthHit_methods,          /* tp_methods */
    _CdcStrawTruthHit_members,          /* tp_members */
    _CdcStrawTruthHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_CdcStrawTruthHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _CdcStrawTruthHit_new,              /* tp_new */
};



// wrap element class hddm_s::CdcStraw as hddm_s.CdcStraw

typedef struct {
   PyObject_HEAD
   CdcStraw *elem;
   PyObject *host;
} _CdcStraw;

static void
_CdcStraw_dealloc(_CdcStraw* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_CdcStraw_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _CdcStraw *self;
   self = (_CdcStraw*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_CdcStraw_init(_CdcStraw *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_CdcStraw_getClass(_CdcStraw *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcStraw_getVersion(_CdcStraw *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_CdcStraw_getXmlns(_CdcStraw *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcStraw_getEventNo(_CdcStraw *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_CdcStraw_getRunNo(_CdcStraw *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_CdcStraw_getMaxOccurs(_CdcStraw *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcStraw_getMinOccurs(_CdcStraw *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_CdcStraw_getRing(_CdcStraw *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRing());
}

static int
_CdcStraw_setRing(_CdcStraw *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setRing(var);
   return 0;
}

static PyObject*
_CdcStraw_getStraw(_CdcStraw *self, void *closure)
{
   return PyLong_FromLong(self->elem->getStraw());
}

static int
_CdcStraw_setStraw(_CdcStraw *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setStraw(var);
   return 0;
}

static PyObject*
_CdcStraw_getCdcStrawHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _CdcStraw *me = (_CdcStraw*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcStraw element");
      return NULL;
   }
   PyObject *obj = _CdcStrawHit_new(&_CdcStrawHit_type, 0, 0);
   ((_CdcStrawHit*)obj)->elem = &me->elem->getCdcStrawHit(index);
   ((_CdcStrawHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_CdcStraw_getCdcStrawHits(PyObject *self, PyObject *args)
{
   _CdcStraw *me = (_CdcStraw*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcStraw element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CdcStrawHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getCdcStrawHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_CdcStraw_addCdcStrawHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CdcStraw *me = (_CdcStraw*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid cdcStraw element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CdcStrawHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CdcStrawHitList(me->elem->addCdcStrawHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_CdcStraw_deleteCdcStrawHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CdcStraw *me = (_CdcStraw*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid cdcStraw element");
      return NULL;
   }
   me->elem->deleteCdcStrawHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_CdcStraw_getCdcStrawTruthHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _CdcStraw *me = (_CdcStraw*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcStraw element");
      return NULL;
   }
   PyObject *obj = _CdcStrawTruthHit_new(&_CdcStrawTruthHit_type, 0, 0);
   ((_CdcStrawTruthHit*)obj)->elem = &me->elem->getCdcStrawTruthHit(index);
   ((_CdcStrawTruthHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_CdcStraw_getCdcStrawTruthHits(PyObject *self, PyObject *args)
{
   _CdcStraw *me = (_CdcStraw*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcStraw element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CdcStrawTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getCdcStrawTruthHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_CdcStraw_addCdcStrawTruthHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CdcStraw *me = (_CdcStraw*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid cdcStraw element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CdcStrawTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CdcStrawTruthHitList(me->elem->addCdcStrawTruthHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_CdcStraw_deleteCdcStrawTruthHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CdcStraw *me = (_CdcStraw*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid cdcStraw element");
      return NULL;
   }
   me->elem->deleteCdcStrawTruthHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_CdcStraw_toString(PyObject *self, PyObject *args=0)
{
   _CdcStraw *me = (_CdcStraw*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcStraw element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_CdcStraw_toXML(PyObject *self, PyObject *args=0)
{
   _CdcStraw *me = (_CdcStraw*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcStraw element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _CdcStraw_getsetters[] = {
   {(char*)"class",
    (getter)_CdcStraw_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_CdcStraw_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_CdcStraw_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_CdcStraw_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"ring",
    (getter)_CdcStraw_getRing, (setter)_CdcStraw_setRing,
    (char*)"ring value",
    NULL},
   {(char*)"runNo",
    (getter)_CdcStraw_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"straw",
    (getter)_CdcStraw_getStraw, (setter)_CdcStraw_setStraw,
    (char*)"straw value",
    NULL},
   {(char*)"version",
    (getter)_CdcStraw_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_CdcStraw_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _CdcStraw_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _CdcStraw_methods[] = {
   {"addCdcStrawHits", _CdcStraw_addCdcStrawHits, METH_VARARGS,
    "extend (or insert into) the list of cdcStrawHit objects for this cdcStraw"},
   {"addCdcStrawTruthHits", _CdcStraw_addCdcStrawTruthHits, METH_VARARGS,
    "extend (or insert into) the list of cdcStrawTruthHit objects for this cdcStraw"},
   {"deleteCdcStrawHits", _CdcStraw_deleteCdcStrawHits, METH_VARARGS,
    "delete cdcStrawHit objects for this cdcStraw"},
   {"deleteCdcStrawTruthHits", _CdcStraw_deleteCdcStrawTruthHits, METH_VARARGS,
    "delete cdcStrawTruthHit objects for this cdcStraw"},
   {"getCdcStrawHit", _CdcStraw_getCdcStrawHit, METH_VARARGS,
    "get an individual cdcStrawHit object from this cdcStraw"},
   {"getCdcStrawHits", _CdcStraw_getCdcStrawHits, METH_NOARGS,
    "get list of cdcStrawHit objects for this cdcStraw"},
   {"getCdcStrawTruthHit", _CdcStraw_getCdcStrawTruthHit, METH_VARARGS,
    "get an individual cdcStrawTruthHit object from this cdcStraw"},
   {"getCdcStrawTruthHits", _CdcStraw_getCdcStrawTruthHits, METH_NOARGS,
    "get list of cdcStrawTruthHit objects for this cdcStraw"},
   {"toString", _CdcStraw_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _CdcStraw_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _CdcStraw_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.CdcStraw",         /*tp_name*/
    sizeof(_CdcStraw),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_CdcStraw_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_CdcStraw_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s cdcStraw element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _CdcStraw_methods,          /* tp_methods */
    _CdcStraw_members,          /* tp_members */
    _CdcStraw_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_CdcStraw_init,   /* tp_init */
    0,                         /* tp_alloc */
    _CdcStraw_new,              /* tp_new */
};



// wrap element class hddm_s::TrackID as hddm_s.TrackID

typedef struct {
   PyObject_HEAD
   TrackID *elem;
   PyObject *host;
} _TrackID;

static void
_TrackID_dealloc(_TrackID* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_TrackID_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _TrackID *self;
   self = (_TrackID*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_TrackID_init(_TrackID *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_TrackID_getClass(_TrackID *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TrackID_getVersion(_TrackID *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_TrackID_getXmlns(_TrackID *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TrackID_getEventNo(_TrackID *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_TrackID_getMaxOccurs(_TrackID *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_TrackID_getRunNo(_TrackID *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_TrackID_getE(_TrackID *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static PyObject*
_TrackID_getPrimary(_TrackID *self, void *closure)
{
   return PyBool_FromLong(self->elem->getPrimary());
}

static PyObject*
_TrackID_getPtype(_TrackID *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPtype());
}

static PyObject*
_TrackID_getPx(_TrackID *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPx());
}

static PyObject*
_TrackID_getPy(_TrackID *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPy());
}

static PyObject*
_TrackID_getPz(_TrackID *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPz());
}

static PyObject*
_TrackID_getT(_TrackID *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_TrackID_getTrack(_TrackID *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static PyObject*
_TrackID_getX(_TrackID *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static PyObject*
_TrackID_getY(_TrackID *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static PyObject*
_TrackID_getZ(_TrackID *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static PyObject*
_TrackID_getDEdx(_TrackID *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdx());
}

static PyObject*
_TrackID_getPhi(_TrackID *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPhi());
}

static PyObject*
_TrackID_getR(_TrackID *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getR());
}

static PyObject*
_TrackID_getArm(_TrackID *self, void *closure)
{
   return PyLong_FromLong(self->elem->getArm());
}

static PyObject*
_TrackID_getModule(_TrackID *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static PyObject*
_TrackID_getColumn(_TrackID *self, void *closure)
{
   return PyLong_FromLong(self->elem->getColumn());
}

static PyObject*
_TrackID_getSector(_TrackID *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSector());
}

static PyObject*
_TrackID_getLayer(_TrackID *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static PyObject*
_TrackID_getDradius(_TrackID *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDradius());
}

static PyObject*
_TrackID_getItrack(_TrackID *self, void *closure)
{
   return PyLong_FromLong(self->elem->getItrack());
}

static int
_TrackID_setItrack(_TrackID *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setItrack(var);
   return 0;
}

static PyObject*
_TrackID_getMinOccurs(_TrackID *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_TrackID_toString(PyObject *self, PyObject *args=0)
{
   _TrackID *me = (_TrackID*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid trackID element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_TrackID_toXML(PyObject *self, PyObject *args=0)
{
   _TrackID *me = (_TrackID*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid trackID element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _TrackID_getsetters[] = {
   {(char*)"E",
    (getter)_TrackID_getE, 0,
    (char*)"E value",
    NULL},
   {(char*)"arm",
    (getter)_TrackID_getArm, 0,
    (char*)"arm value",
    NULL},
   {(char*)"class",
    (getter)_TrackID_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"column",
    (getter)_TrackID_getColumn, 0,
    (char*)"column value",
    NULL},
   {(char*)"dEdx",
    (getter)_TrackID_getDEdx, 0,
    (char*)"dEdx value",
    NULL},
   {(char*)"dradius",
    (getter)_TrackID_getDradius, 0,
    (char*)"dradius value",
    NULL},
   {(char*)"eventNo",
    (getter)_TrackID_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"itrack",
    (getter)_TrackID_getItrack, (setter)_TrackID_setItrack,
    (char*)"itrack value",
    NULL},
   {(char*)"layer",
    (getter)_TrackID_getLayer, 0,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_TrackID_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_TrackID_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_TrackID_getModule, 0,
    (char*)"module value",
    NULL},
   {(char*)"phi",
    (getter)_TrackID_getPhi, 0,
    (char*)"phi value",
    NULL},
   {(char*)"primary",
    (getter)_TrackID_getPrimary, 0,
    (char*)"primary value",
    NULL},
   {(char*)"ptype",
    (getter)_TrackID_getPtype, 0,
    (char*)"ptype value",
    NULL},
   {(char*)"px",
    (getter)_TrackID_getPx, 0,
    (char*)"px value",
    NULL},
   {(char*)"py",
    (getter)_TrackID_getPy, 0,
    (char*)"py value",
    NULL},
   {(char*)"pz",
    (getter)_TrackID_getPz, 0,
    (char*)"pz value",
    NULL},
   {(char*)"r",
    (getter)_TrackID_getR, 0,
    (char*)"r value",
    NULL},
   {(char*)"runNo",
    (getter)_TrackID_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sector",
    (getter)_TrackID_getSector, 0,
    (char*)"sector value",
    NULL},
   {(char*)"t",
    (getter)_TrackID_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"track",
    (getter)_TrackID_getTrack, 0,
    (char*)"track value",
    NULL},
   {(char*)"version",
    (getter)_TrackID_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"x",
    (getter)_TrackID_getX, 0,
    (char*)"x value",
    NULL},
   {(char*)"xmlns",
    (getter)_TrackID_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y",
    (getter)_TrackID_getY, 0,
    (char*)"y value",
    NULL},
   {(char*)"z",
    (getter)_TrackID_getZ, 0,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _TrackID_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _TrackID_methods[] = {
   {"toString", _TrackID_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _TrackID_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _TrackID_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.TrackID",         /*tp_name*/
    sizeof(_TrackID),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_TrackID_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_TrackID_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s trackID element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _TrackID_methods,          /* tp_methods */
    _TrackID_members,          /* tp_members */
    _TrackID_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_TrackID_init,   /* tp_init */
    0,                         /* tp_alloc */
    _TrackID_new,              /* tp_new */
};



// wrap element class hddm_s::CdcTruthPoint as hddm_s.CdcTruthPoint

typedef struct {
   PyObject_HEAD
   CdcTruthPoint *elem;
   PyObject *host;
} _CdcTruthPoint;

static void
_CdcTruthPoint_dealloc(_CdcTruthPoint* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_CdcTruthPoint_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _CdcTruthPoint *self;
   self = (_CdcTruthPoint*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_CdcTruthPoint_init(_CdcTruthPoint *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_CdcTruthPoint_getClass(_CdcTruthPoint *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcTruthPoint_getVersion(_CdcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_CdcTruthPoint_getXmlns(_CdcTruthPoint *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcTruthPoint_getEventNo(_CdcTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_CdcTruthPoint_getRunNo(_CdcTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_CdcTruthPoint_getDEdx(_CdcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdx());
}

static int
_CdcTruthPoint_setDEdx(_CdcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDEdx((float)var);
   return 0;
}

static PyObject*
_CdcTruthPoint_getDradius(_CdcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDradius());
}

static int
_CdcTruthPoint_setDradius(_CdcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDradius((float)var);
   return 0;
}

static PyObject*
_CdcTruthPoint_getMaxOccurs(_CdcTruthPoint *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CdcTruthPoint_getMinOccurs(_CdcTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_CdcTruthPoint_getPhi(_CdcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPhi());
}

static int
_CdcTruthPoint_setPhi(_CdcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPhi((float)var);
   return 0;
}

static PyObject*
_CdcTruthPoint_getPrimary(_CdcTruthPoint *self, void *closure)
{
   return PyBool_FromLong(self->elem->getPrimary());
}

static int
_CdcTruthPoint_setPrimary(_CdcTruthPoint *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPrimary((var==0)? false : true);
   return 0;
}

static PyObject*
_CdcTruthPoint_getPtype(_CdcTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPtype());
}

static int
_CdcTruthPoint_setPtype(_CdcTruthPoint *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPtype(var);
   return 0;
}

static PyObject*
_CdcTruthPoint_getPx(_CdcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPx());
}

static int
_CdcTruthPoint_setPx(_CdcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPx((float)var);
   return 0;
}

static PyObject*
_CdcTruthPoint_getPy(_CdcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPy());
}

static int
_CdcTruthPoint_setPy(_CdcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPy((float)var);
   return 0;
}

static PyObject*
_CdcTruthPoint_getPz(_CdcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPz());
}

static int
_CdcTruthPoint_setPz(_CdcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPz((float)var);
   return 0;
}

static PyObject*
_CdcTruthPoint_getR(_CdcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getR());
}

static int
_CdcTruthPoint_setR(_CdcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setR((float)var);
   return 0;
}

static PyObject*
_CdcTruthPoint_getT(_CdcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_CdcTruthPoint_setT(_CdcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_CdcTruthPoint_getTrack(_CdcTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static int
_CdcTruthPoint_setTrack(_CdcTruthPoint *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTrack(var);
   return 0;
}

static PyObject*
_CdcTruthPoint_getZ(_CdcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static int
_CdcTruthPoint_setZ(_CdcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ((float)var);
   return 0;
}

static PyObject*
_CdcTruthPoint_getTrackID(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _CdcTruthPoint *me = (_CdcTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcTruthPoint element");
      return NULL;
   }
   PyObject *obj = _TrackID_new(&_TrackID_type, 0, 0);
   ((_TrackID*)obj)->elem = &me->elem->getTrackID();
   ((_TrackID*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_CdcTruthPoint_getTrackIDs(PyObject *self, PyObject *args)
{
   _CdcTruthPoint *me = (_CdcTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcTruthPoint element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackID_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTrackIDs();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_CdcTruthPoint_addTrackIDs(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CdcTruthPoint *me = (_CdcTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid cdcTruthPoint element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackID_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TrackIDList(me->elem->addTrackIDs(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_CdcTruthPoint_deleteTrackIDs(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CdcTruthPoint *me = (_CdcTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid cdcTruthPoint element");
      return NULL;
   }
   me->elem->deleteTrackIDs(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_CdcTruthPoint_toString(PyObject *self, PyObject *args=0)
{
   _CdcTruthPoint *me = (_CdcTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcTruthPoint element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_CdcTruthPoint_toXML(PyObject *self, PyObject *args=0)
{
   _CdcTruthPoint *me = (_CdcTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cdcTruthPoint element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _CdcTruthPoint_getsetters[] = {
   {(char*)"class",
    (getter)_CdcTruthPoint_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dEdx",
    (getter)_CdcTruthPoint_getDEdx, (setter)_CdcTruthPoint_setDEdx,
    (char*)"dEdx value",
    NULL},
   {(char*)"dradius",
    (getter)_CdcTruthPoint_getDradius, (setter)_CdcTruthPoint_setDradius,
    (char*)"dradius value",
    NULL},
   {(char*)"eventNo",
    (getter)_CdcTruthPoint_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_CdcTruthPoint_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_CdcTruthPoint_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"phi",
    (getter)_CdcTruthPoint_getPhi, (setter)_CdcTruthPoint_setPhi,
    (char*)"phi value",
    NULL},
   {(char*)"primary",
    (getter)_CdcTruthPoint_getPrimary, (setter)_CdcTruthPoint_setPrimary,
    (char*)"primary value",
    NULL},
   {(char*)"ptype",
    (getter)_CdcTruthPoint_getPtype, (setter)_CdcTruthPoint_setPtype,
    (char*)"ptype value",
    NULL},
   {(char*)"px",
    (getter)_CdcTruthPoint_getPx, (setter)_CdcTruthPoint_setPx,
    (char*)"px value",
    NULL},
   {(char*)"py",
    (getter)_CdcTruthPoint_getPy, (setter)_CdcTruthPoint_setPy,
    (char*)"py value",
    NULL},
   {(char*)"pz",
    (getter)_CdcTruthPoint_getPz, (setter)_CdcTruthPoint_setPz,
    (char*)"pz value",
    NULL},
   {(char*)"r",
    (getter)_CdcTruthPoint_getR, (setter)_CdcTruthPoint_setR,
    (char*)"r value",
    NULL},
   {(char*)"runNo",
    (getter)_CdcTruthPoint_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_CdcTruthPoint_getT, (setter)_CdcTruthPoint_setT,
    (char*)"t value",
    NULL},
   {(char*)"track",
    (getter)_CdcTruthPoint_getTrack, (setter)_CdcTruthPoint_setTrack,
    (char*)"track value",
    NULL},
   {(char*)"version",
    (getter)_CdcTruthPoint_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_CdcTruthPoint_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"z",
    (getter)_CdcTruthPoint_getZ, (setter)_CdcTruthPoint_setZ,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _CdcTruthPoint_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _CdcTruthPoint_methods[] = {
   {"addTrackIDs", _CdcTruthPoint_addTrackIDs, METH_VARARGS,
    "extend (or insert into) the list of trackID objects for this cdcTruthPoint"},
   {"deleteTrackIDs", _CdcTruthPoint_deleteTrackIDs, METH_VARARGS,
    "delete trackID objects for this cdcTruthPoint"},
   {"getTrackID", _CdcTruthPoint_getTrackID, METH_VARARGS,
    "get an individual trackID object from this cdcTruthPoint"},
   {"getTrackIDs", _CdcTruthPoint_getTrackIDs, METH_NOARGS,
    "get list of trackID objects for this cdcTruthPoint"},
   {"toString", _CdcTruthPoint_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _CdcTruthPoint_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _CdcTruthPoint_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.CdcTruthPoint",         /*tp_name*/
    sizeof(_CdcTruthPoint),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_CdcTruthPoint_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_CdcTruthPoint_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s cdcTruthPoint element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _CdcTruthPoint_methods,          /* tp_methods */
    _CdcTruthPoint_members,          /* tp_members */
    _CdcTruthPoint_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_CdcTruthPoint_init,   /* tp_init */
    0,                         /* tp_alloc */
    _CdcTruthPoint_new,              /* tp_new */
};



// wrap element class hddm_s::CentralDC as hddm_s.CentralDC

typedef struct {
   PyObject_HEAD
   CentralDC *elem;
   PyObject *host;
} _CentralDC;

static void
_CentralDC_dealloc(_CentralDC* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_CentralDC_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _CentralDC *self;
   self = (_CentralDC*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_CentralDC_init(_CentralDC *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_CentralDC_getClass(_CentralDC *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CentralDC_getVersion(_CentralDC *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_CentralDC_getXmlns(_CentralDC *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CentralDC_getEventNo(_CentralDC *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_CentralDC_getMaxOccurs(_CentralDC *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CentralDC_getRunNo(_CentralDC *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_CentralDC_getMinOccurs(_CentralDC *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_CentralDC_getCdcStraw(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _CentralDC *me = (_CentralDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid centralDC element");
      return NULL;
   }
   PyObject *obj = _CdcStraw_new(&_CdcStraw_type, 0, 0);
   ((_CdcStraw*)obj)->elem = &me->elem->getCdcStraw(index);
   ((_CdcStraw*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_CentralDC_getCdcStraws(PyObject *self, PyObject *args)
{
   _CentralDC *me = (_CentralDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid centralDC element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CdcStraw_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getCdcStraws();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_CentralDC_addCdcStraws(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CentralDC *me = (_CentralDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid centralDC element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CdcStraw_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CdcStrawList(me->elem->addCdcStraws(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_CentralDC_deleteCdcStraws(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CentralDC *me = (_CentralDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid centralDC element");
      return NULL;
   }
   me->elem->deleteCdcStraws(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_CentralDC_getCdcTruthPoint(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _CentralDC *me = (_CentralDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid centralDC element");
      return NULL;
   }
   PyObject *obj = _CdcTruthPoint_new(&_CdcTruthPoint_type, 0, 0);
   ((_CdcTruthPoint*)obj)->elem = &me->elem->getCdcTruthPoint(index);
   ((_CdcTruthPoint*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_CentralDC_getCdcTruthPoints(PyObject *self, PyObject *args)
{
   _CentralDC *me = (_CentralDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid centralDC element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CdcTruthPoint_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getCdcTruthPoints();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_CentralDC_addCdcTruthPoints(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CentralDC *me = (_CentralDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid centralDC element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CdcTruthPoint_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CdcTruthPointList(me->elem->addCdcTruthPoints(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_CentralDC_deleteCdcTruthPoints(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CentralDC *me = (_CentralDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid centralDC element");
      return NULL;
   }
   me->elem->deleteCdcTruthPoints(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_CentralDC_toString(PyObject *self, PyObject *args=0)
{
   _CentralDC *me = (_CentralDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid centralDC element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_CentralDC_toXML(PyObject *self, PyObject *args=0)
{
   _CentralDC *me = (_CentralDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid centralDC element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _CentralDC_getsetters[] = {
   {(char*)"class",
    (getter)_CentralDC_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_CentralDC_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_CentralDC_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_CentralDC_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_CentralDC_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_CentralDC_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_CentralDC_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _CentralDC_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _CentralDC_methods[] = {
   {"addCdcStraws", _CentralDC_addCdcStraws, METH_VARARGS,
    "extend (or insert into) the list of cdcStraw objects for this centralDC"},
   {"addCdcTruthPoints", _CentralDC_addCdcTruthPoints, METH_VARARGS,
    "extend (or insert into) the list of cdcTruthPoint objects for this centralDC"},
   {"deleteCdcStraws", _CentralDC_deleteCdcStraws, METH_VARARGS,
    "delete cdcStraw objects for this centralDC"},
   {"deleteCdcTruthPoints", _CentralDC_deleteCdcTruthPoints, METH_VARARGS,
    "delete cdcTruthPoint objects for this centralDC"},
   {"getCdcStraw", _CentralDC_getCdcStraw, METH_VARARGS,
    "get an individual cdcStraw object from this centralDC"},
   {"getCdcStraws", _CentralDC_getCdcStraws, METH_NOARGS,
    "get list of cdcStraw objects for this centralDC"},
   {"getCdcTruthPoint", _CentralDC_getCdcTruthPoint, METH_VARARGS,
    "get an individual cdcTruthPoint object from this centralDC"},
   {"getCdcTruthPoints", _CentralDC_getCdcTruthPoints, METH_NOARGS,
    "get list of cdcTruthPoint objects for this centralDC"},
   {"toString", _CentralDC_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _CentralDC_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _CentralDC_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.CentralDC",         /*tp_name*/
    sizeof(_CentralDC),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_CentralDC_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_CentralDC_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s centralDC element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _CentralDC_methods,          /* tp_methods */
    _CentralDC_members,          /* tp_members */
    _CentralDC_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_CentralDC_init,   /* tp_init */
    0,                         /* tp_alloc */
    _CentralDC_new,              /* tp_new */
};



// wrap element class hddm_s::FdcAnodeHit as hddm_s.FdcAnodeHit

typedef struct {
   PyObject_HEAD
   FdcAnodeHit *elem;
   PyObject *host;
} _FdcAnodeHit;

static void
_FdcAnodeHit_dealloc(_FdcAnodeHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FdcAnodeHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FdcAnodeHit *self;
   self = (_FdcAnodeHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FdcAnodeHit_init(_FdcAnodeHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FdcAnodeHit_getClass(_FdcAnodeHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcAnodeHit_getVersion(_FdcAnodeHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_FdcAnodeHit_getXmlns(_FdcAnodeHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcAnodeHit_getEventNo(_FdcAnodeHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_FdcAnodeHit_getRunNo(_FdcAnodeHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FdcAnodeHit_getMinOccurs(_FdcAnodeHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FdcAnodeHit_getLayer(_FdcAnodeHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static PyObject*
_FdcAnodeHit_getModule(_FdcAnodeHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static PyObject*
_FdcAnodeHit_getWire(_FdcAnodeHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getWire());
}

static PyObject*
_FdcAnodeHit_getDE(_FdcAnodeHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDE());
}

static int
_FdcAnodeHit_setDE(_FdcAnodeHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDE((float)var);
   return 0;
}

static PyObject*
_FdcAnodeHit_getMaxOccurs(_FdcAnodeHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcAnodeHit_getT(_FdcAnodeHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_FdcAnodeHit_setT(_FdcAnodeHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_FdcAnodeHit_toString(PyObject *self, PyObject *args=0)
{
   _FdcAnodeHit *me = (_FdcAnodeHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcAnodeHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FdcAnodeHit_toXML(PyObject *self, PyObject *args=0)
{
   _FdcAnodeHit *me = (_FdcAnodeHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcAnodeHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FdcAnodeHit_getsetters[] = {
   {(char*)"class",
    (getter)_FdcAnodeHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dE",
    (getter)_FdcAnodeHit_getDE, (setter)_FdcAnodeHit_setDE,
    (char*)"dE value",
    NULL},
   {(char*)"eventNo",
    (getter)_FdcAnodeHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"layer",
    (getter)_FdcAnodeHit_getLayer, 0,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FdcAnodeHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FdcAnodeHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_FdcAnodeHit_getModule, 0,
    (char*)"module value",
    NULL},
   {(char*)"runNo",
    (getter)_FdcAnodeHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_FdcAnodeHit_getT, (setter)_FdcAnodeHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_FdcAnodeHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"wire",
    (getter)_FdcAnodeHit_getWire, 0,
    (char*)"wire value",
    NULL},
   {(char*)"xmlns",
    (getter)_FdcAnodeHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FdcAnodeHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FdcAnodeHit_methods[] = {
   {"toString", _FdcAnodeHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FdcAnodeHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FdcAnodeHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.FdcAnodeHit",         /*tp_name*/
    sizeof(_FdcAnodeHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FdcAnodeHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FdcAnodeHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s fdcAnodeHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FdcAnodeHit_methods,          /* tp_methods */
    _FdcAnodeHit_members,          /* tp_members */
    _FdcAnodeHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FdcAnodeHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FdcAnodeHit_new,              /* tp_new */
};



// wrap element class hddm_s::FdcAnodeTruthHit as hddm_s.FdcAnodeTruthHit

typedef struct {
   PyObject_HEAD
   FdcAnodeTruthHit *elem;
   PyObject *host;
} _FdcAnodeTruthHit;

static void
_FdcAnodeTruthHit_dealloc(_FdcAnodeTruthHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FdcAnodeTruthHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FdcAnodeTruthHit *self;
   self = (_FdcAnodeTruthHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FdcAnodeTruthHit_init(_FdcAnodeTruthHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FdcAnodeTruthHit_getClass(_FdcAnodeTruthHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcAnodeTruthHit_getVersion(_FdcAnodeTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_FdcAnodeTruthHit_getXmlns(_FdcAnodeTruthHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcAnodeTruthHit_getEventNo(_FdcAnodeTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_FdcAnodeTruthHit_getRunNo(_FdcAnodeTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FdcAnodeTruthHit_getMinOccurs(_FdcAnodeTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FdcAnodeTruthHit_getLayer(_FdcAnodeTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static PyObject*
_FdcAnodeTruthHit_getModule(_FdcAnodeTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static PyObject*
_FdcAnodeTruthHit_getWire(_FdcAnodeTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getWire());
}

static PyObject*
_FdcAnodeTruthHit_getD(_FdcAnodeTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getD());
}

static int
_FdcAnodeTruthHit_setD(_FdcAnodeTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setD((float)var);
   return 0;
}

static PyObject*
_FdcAnodeTruthHit_getDE(_FdcAnodeTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDE());
}

static int
_FdcAnodeTruthHit_setDE(_FdcAnodeTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDE((float)var);
   return 0;
}

static PyObject*
_FdcAnodeTruthHit_getItrack(_FdcAnodeTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getItrack());
}

static int
_FdcAnodeTruthHit_setItrack(_FdcAnodeTruthHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setItrack(var);
   return 0;
}

static PyObject*
_FdcAnodeTruthHit_getMaxOccurs(_FdcAnodeTruthHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcAnodeTruthHit_getPtype(_FdcAnodeTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPtype());
}

static int
_FdcAnodeTruthHit_setPtype(_FdcAnodeTruthHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPtype(var);
   return 0;
}

static PyObject*
_FdcAnodeTruthHit_getT(_FdcAnodeTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_FdcAnodeTruthHit_setT(_FdcAnodeTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_FdcAnodeTruthHit_getT_unsmeared(_FdcAnodeTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT_unsmeared());
}

static int
_FdcAnodeTruthHit_setT_unsmeared(_FdcAnodeTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT_unsmeared((float)var);
   return 0;
}

static PyObject*
_FdcAnodeTruthHit_toString(PyObject *self, PyObject *args=0)
{
   _FdcAnodeTruthHit *me = (_FdcAnodeTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcAnodeTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FdcAnodeTruthHit_toXML(PyObject *self, PyObject *args=0)
{
   _FdcAnodeTruthHit *me = (_FdcAnodeTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcAnodeTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FdcAnodeTruthHit_getsetters[] = {
   {(char*)"class",
    (getter)_FdcAnodeTruthHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"d",
    (getter)_FdcAnodeTruthHit_getD, (setter)_FdcAnodeTruthHit_setD,
    (char*)"d value",
    NULL},
   {(char*)"dE",
    (getter)_FdcAnodeTruthHit_getDE, (setter)_FdcAnodeTruthHit_setDE,
    (char*)"dE value",
    NULL},
   {(char*)"eventNo",
    (getter)_FdcAnodeTruthHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"itrack",
    (getter)_FdcAnodeTruthHit_getItrack, (setter)_FdcAnodeTruthHit_setItrack,
    (char*)"itrack value",
    NULL},
   {(char*)"layer",
    (getter)_FdcAnodeTruthHit_getLayer, 0,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FdcAnodeTruthHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FdcAnodeTruthHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_FdcAnodeTruthHit_getModule, 0,
    (char*)"module value",
    NULL},
   {(char*)"ptype",
    (getter)_FdcAnodeTruthHit_getPtype, (setter)_FdcAnodeTruthHit_setPtype,
    (char*)"ptype value",
    NULL},
   {(char*)"runNo",
    (getter)_FdcAnodeTruthHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_FdcAnodeTruthHit_getT, (setter)_FdcAnodeTruthHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"t_unsmeared",
    (getter)_FdcAnodeTruthHit_getT_unsmeared, (setter)_FdcAnodeTruthHit_setT_unsmeared,
    (char*)"t_unsmeared value",
    NULL},
   {(char*)"version",
    (getter)_FdcAnodeTruthHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"wire",
    (getter)_FdcAnodeTruthHit_getWire, 0,
    (char*)"wire value",
    NULL},
   {(char*)"xmlns",
    (getter)_FdcAnodeTruthHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FdcAnodeTruthHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FdcAnodeTruthHit_methods[] = {
   {"toString", _FdcAnodeTruthHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FdcAnodeTruthHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FdcAnodeTruthHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.FdcAnodeTruthHit",         /*tp_name*/
    sizeof(_FdcAnodeTruthHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FdcAnodeTruthHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FdcAnodeTruthHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s fdcAnodeTruthHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FdcAnodeTruthHit_methods,          /* tp_methods */
    _FdcAnodeTruthHit_members,          /* tp_members */
    _FdcAnodeTruthHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FdcAnodeTruthHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FdcAnodeTruthHit_new,              /* tp_new */
};



// wrap element class hddm_s::FdcAnodeWire as hddm_s.FdcAnodeWire

typedef struct {
   PyObject_HEAD
   FdcAnodeWire *elem;
   PyObject *host;
} _FdcAnodeWire;

static void
_FdcAnodeWire_dealloc(_FdcAnodeWire* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FdcAnodeWire_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FdcAnodeWire *self;
   self = (_FdcAnodeWire*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FdcAnodeWire_init(_FdcAnodeWire *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FdcAnodeWire_getClass(_FdcAnodeWire *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcAnodeWire_getVersion(_FdcAnodeWire *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_FdcAnodeWire_getXmlns(_FdcAnodeWire *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcAnodeWire_getEventNo(_FdcAnodeWire *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_FdcAnodeWire_getRunNo(_FdcAnodeWire *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FdcAnodeWire_getLayer(_FdcAnodeWire *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static PyObject*
_FdcAnodeWire_getModule(_FdcAnodeWire *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static PyObject*
_FdcAnodeWire_getMaxOccurs(_FdcAnodeWire *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcAnodeWire_getMinOccurs(_FdcAnodeWire *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FdcAnodeWire_getWire(_FdcAnodeWire *self, void *closure)
{
   return PyLong_FromLong(self->elem->getWire());
}

static int
_FdcAnodeWire_setWire(_FdcAnodeWire *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setWire(var);
   return 0;
}

static PyObject*
_FdcAnodeWire_getFdcAnodeHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FdcAnodeWire *me = (_FdcAnodeWire*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcAnodeWire element");
      return NULL;
   }
   PyObject *obj = _FdcAnodeHit_new(&_FdcAnodeHit_type, 0, 0);
   ((_FdcAnodeHit*)obj)->elem = &me->elem->getFdcAnodeHit(index);
   ((_FdcAnodeHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FdcAnodeWire_getFdcAnodeHits(PyObject *self, PyObject *args)
{
   _FdcAnodeWire *me = (_FdcAnodeWire*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcAnodeWire element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FdcAnodeHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFdcAnodeHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FdcAnodeWire_addFdcAnodeHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FdcAnodeWire *me = (_FdcAnodeWire*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid fdcAnodeWire element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FdcAnodeHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FdcAnodeHitList(me->elem->addFdcAnodeHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FdcAnodeWire_deleteFdcAnodeHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FdcAnodeWire *me = (_FdcAnodeWire*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid fdcAnodeWire element");
      return NULL;
   }
   me->elem->deleteFdcAnodeHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FdcAnodeWire_getFdcAnodeTruthHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FdcAnodeWire *me = (_FdcAnodeWire*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcAnodeWire element");
      return NULL;
   }
   PyObject *obj = _FdcAnodeTruthHit_new(&_FdcAnodeTruthHit_type, 0, 0);
   ((_FdcAnodeTruthHit*)obj)->elem = &me->elem->getFdcAnodeTruthHit(index);
   ((_FdcAnodeTruthHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FdcAnodeWire_getFdcAnodeTruthHits(PyObject *self, PyObject *args)
{
   _FdcAnodeWire *me = (_FdcAnodeWire*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcAnodeWire element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FdcAnodeTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFdcAnodeTruthHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FdcAnodeWire_addFdcAnodeTruthHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FdcAnodeWire *me = (_FdcAnodeWire*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid fdcAnodeWire element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FdcAnodeTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FdcAnodeTruthHitList(me->elem->addFdcAnodeTruthHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FdcAnodeWire_deleteFdcAnodeTruthHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FdcAnodeWire *me = (_FdcAnodeWire*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid fdcAnodeWire element");
      return NULL;
   }
   me->elem->deleteFdcAnodeTruthHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FdcAnodeWire_toString(PyObject *self, PyObject *args=0)
{
   _FdcAnodeWire *me = (_FdcAnodeWire*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcAnodeWire element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FdcAnodeWire_toXML(PyObject *self, PyObject *args=0)
{
   _FdcAnodeWire *me = (_FdcAnodeWire*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcAnodeWire element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FdcAnodeWire_getsetters[] = {
   {(char*)"class",
    (getter)_FdcAnodeWire_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_FdcAnodeWire_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"layer",
    (getter)_FdcAnodeWire_getLayer, 0,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FdcAnodeWire_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FdcAnodeWire_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_FdcAnodeWire_getModule, 0,
    (char*)"module value",
    NULL},
   {(char*)"runNo",
    (getter)_FdcAnodeWire_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_FdcAnodeWire_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"wire",
    (getter)_FdcAnodeWire_getWire, (setter)_FdcAnodeWire_setWire,
    (char*)"wire value",
    NULL},
   {(char*)"xmlns",
    (getter)_FdcAnodeWire_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FdcAnodeWire_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FdcAnodeWire_methods[] = {
   {"addFdcAnodeHits", _FdcAnodeWire_addFdcAnodeHits, METH_VARARGS,
    "extend (or insert into) the list of fdcAnodeHit objects for this fdcAnodeWire"},
   {"addFdcAnodeTruthHits", _FdcAnodeWire_addFdcAnodeTruthHits, METH_VARARGS,
    "extend (or insert into) the list of fdcAnodeTruthHit objects for this fdcAnodeWire"},
   {"deleteFdcAnodeHits", _FdcAnodeWire_deleteFdcAnodeHits, METH_VARARGS,
    "delete fdcAnodeHit objects for this fdcAnodeWire"},
   {"deleteFdcAnodeTruthHits", _FdcAnodeWire_deleteFdcAnodeTruthHits, METH_VARARGS,
    "delete fdcAnodeTruthHit objects for this fdcAnodeWire"},
   {"getFdcAnodeHit", _FdcAnodeWire_getFdcAnodeHit, METH_VARARGS,
    "get an individual fdcAnodeHit object from this fdcAnodeWire"},
   {"getFdcAnodeHits", _FdcAnodeWire_getFdcAnodeHits, METH_NOARGS,
    "get list of fdcAnodeHit objects for this fdcAnodeWire"},
   {"getFdcAnodeTruthHit", _FdcAnodeWire_getFdcAnodeTruthHit, METH_VARARGS,
    "get an individual fdcAnodeTruthHit object from this fdcAnodeWire"},
   {"getFdcAnodeTruthHits", _FdcAnodeWire_getFdcAnodeTruthHits, METH_NOARGS,
    "get list of fdcAnodeTruthHit objects for this fdcAnodeWire"},
   {"toString", _FdcAnodeWire_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FdcAnodeWire_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FdcAnodeWire_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.FdcAnodeWire",         /*tp_name*/
    sizeof(_FdcAnodeWire),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FdcAnodeWire_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FdcAnodeWire_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s fdcAnodeWire element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FdcAnodeWire_methods,          /* tp_methods */
    _FdcAnodeWire_members,          /* tp_members */
    _FdcAnodeWire_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FdcAnodeWire_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FdcAnodeWire_new,              /* tp_new */
};



// wrap element class hddm_s::FdcDigihit as hddm_s.FdcDigihit

typedef struct {
   PyObject_HEAD
   FdcDigihit *elem;
   PyObject *host;
} _FdcDigihit;

static void
_FdcDigihit_dealloc(_FdcDigihit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FdcDigihit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FdcDigihit *self;
   self = (_FdcDigihit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FdcDigihit_init(_FdcDigihit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FdcDigihit_getClass(_FdcDigihit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcDigihit_getVersion(_FdcDigihit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_FdcDigihit_getXmlns(_FdcDigihit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcDigihit_getEventNo(_FdcDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_FdcDigihit_getMaxOccurs(_FdcDigihit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcDigihit_getRunNo(_FdcDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FdcDigihit_getLayer(_FdcDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static PyObject*
_FdcDigihit_getModule(_FdcDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static PyObject*
_FdcDigihit_getPlane(_FdcDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPlane());
}

static PyObject*
_FdcDigihit_getStrip(_FdcDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getStrip());
}

static PyObject*
_FdcDigihit_getQ(_FdcDigihit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getQ());
}

static PyObject*
_FdcDigihit_getT(_FdcDigihit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_FdcDigihit_getMinOccurs(_FdcDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FdcDigihit_getPeakAmp(_FdcDigihit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPeakAmp());
}

static int
_FdcDigihit_setPeakAmp(_FdcDigihit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPeakAmp((float)var);
   return 0;
}

static PyObject*
_FdcDigihit_toString(PyObject *self, PyObject *args=0)
{
   _FdcDigihit *me = (_FdcDigihit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcDigihit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FdcDigihit_toXML(PyObject *self, PyObject *args=0)
{
   _FdcDigihit *me = (_FdcDigihit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcDigihit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FdcDigihit_getsetters[] = {
   {(char*)"class",
    (getter)_FdcDigihit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_FdcDigihit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"layer",
    (getter)_FdcDigihit_getLayer, 0,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FdcDigihit_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_FdcDigihit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_FdcDigihit_getModule, 0,
    (char*)"module value",
    NULL},
   {(char*)"peakAmp",
    (getter)_FdcDigihit_getPeakAmp, (setter)_FdcDigihit_setPeakAmp,
    (char*)"peakAmp value",
    NULL},
   {(char*)"plane",
    (getter)_FdcDigihit_getPlane, 0,
    (char*)"plane value",
    NULL},
   {(char*)"q",
    (getter)_FdcDigihit_getQ, 0,
    (char*)"q value",
    NULL},
   {(char*)"runNo",
    (getter)_FdcDigihit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"strip",
    (getter)_FdcDigihit_getStrip, 0,
    (char*)"strip value",
    NULL},
   {(char*)"t",
    (getter)_FdcDigihit_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_FdcDigihit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_FdcDigihit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FdcDigihit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FdcDigihit_methods[] = {
   {"toString", _FdcDigihit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FdcDigihit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FdcDigihit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.FdcDigihit",         /*tp_name*/
    sizeof(_FdcDigihit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FdcDigihit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FdcDigihit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s fdcDigihit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FdcDigihit_methods,          /* tp_methods */
    _FdcDigihit_members,          /* tp_members */
    _FdcDigihit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FdcDigihit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FdcDigihit_new,              /* tp_new */
};



// wrap element class hddm_s::FdcCathodeHit as hddm_s.FdcCathodeHit

typedef struct {
   PyObject_HEAD
   FdcCathodeHit *elem;
   PyObject *host;
} _FdcCathodeHit;

static void
_FdcCathodeHit_dealloc(_FdcCathodeHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FdcCathodeHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FdcCathodeHit *self;
   self = (_FdcCathodeHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FdcCathodeHit_init(_FdcCathodeHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FdcCathodeHit_getClass(_FdcCathodeHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcCathodeHit_getVersion(_FdcCathodeHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_FdcCathodeHit_getXmlns(_FdcCathodeHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcCathodeHit_getEventNo(_FdcCathodeHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_FdcCathodeHit_getRunNo(_FdcCathodeHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FdcCathodeHit_getMinOccurs(_FdcCathodeHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FdcCathodeHit_getLayer(_FdcCathodeHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static PyObject*
_FdcCathodeHit_getModule(_FdcCathodeHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static PyObject*
_FdcCathodeHit_getPlane(_FdcCathodeHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPlane());
}

static PyObject*
_FdcCathodeHit_getStrip(_FdcCathodeHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getStrip());
}

static PyObject*
_FdcCathodeHit_getMaxOccurs(_FdcCathodeHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcCathodeHit_getQ(_FdcCathodeHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getQ());
}

static int
_FdcCathodeHit_setQ(_FdcCathodeHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setQ((float)var);
   return 0;
}

static PyObject*
_FdcCathodeHit_getT(_FdcCathodeHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_FdcCathodeHit_setT(_FdcCathodeHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_FdcCathodeHit_getFdcDigihit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FdcCathodeHit *me = (_FdcCathodeHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcCathodeHit element");
      return NULL;
   }
   PyObject *obj = _FdcDigihit_new(&_FdcDigihit_type, 0, 0);
   ((_FdcDigihit*)obj)->elem = &me->elem->getFdcDigihit();
   ((_FdcDigihit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FdcCathodeHit_getFdcDigihits(PyObject *self, PyObject *args)
{
   _FdcCathodeHit *me = (_FdcCathodeHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcCathodeHit element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FdcDigihit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFdcDigihits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FdcCathodeHit_addFdcDigihits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FdcCathodeHit *me = (_FdcCathodeHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid fdcCathodeHit element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FdcDigihit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FdcDigihitList(me->elem->addFdcDigihits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FdcCathodeHit_deleteFdcDigihits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FdcCathodeHit *me = (_FdcCathodeHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid fdcCathodeHit element");
      return NULL;
   }
   me->elem->deleteFdcDigihits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FdcCathodeHit_toString(PyObject *self, PyObject *args=0)
{
   _FdcCathodeHit *me = (_FdcCathodeHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcCathodeHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FdcCathodeHit_toXML(PyObject *self, PyObject *args=0)
{
   _FdcCathodeHit *me = (_FdcCathodeHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcCathodeHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FdcCathodeHit_getsetters[] = {
   {(char*)"class",
    (getter)_FdcCathodeHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_FdcCathodeHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"layer",
    (getter)_FdcCathodeHit_getLayer, 0,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FdcCathodeHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FdcCathodeHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_FdcCathodeHit_getModule, 0,
    (char*)"module value",
    NULL},
   {(char*)"plane",
    (getter)_FdcCathodeHit_getPlane, 0,
    (char*)"plane value",
    NULL},
   {(char*)"q",
    (getter)_FdcCathodeHit_getQ, (setter)_FdcCathodeHit_setQ,
    (char*)"q value",
    NULL},
   {(char*)"runNo",
    (getter)_FdcCathodeHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"strip",
    (getter)_FdcCathodeHit_getStrip, 0,
    (char*)"strip value",
    NULL},
   {(char*)"t",
    (getter)_FdcCathodeHit_getT, (setter)_FdcCathodeHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_FdcCathodeHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_FdcCathodeHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FdcCathodeHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FdcCathodeHit_methods[] = {
   {"addFdcDigihits", _FdcCathodeHit_addFdcDigihits, METH_VARARGS,
    "extend (or insert into) the list of fdcDigihit objects for this fdcCathodeHit"},
   {"deleteFdcDigihits", _FdcCathodeHit_deleteFdcDigihits, METH_VARARGS,
    "delete fdcDigihit objects for this fdcCathodeHit"},
   {"getFdcDigihit", _FdcCathodeHit_getFdcDigihit, METH_VARARGS,
    "get an individual fdcDigihit object from this fdcCathodeHit"},
   {"getFdcDigihits", _FdcCathodeHit_getFdcDigihits, METH_NOARGS,
    "get list of fdcDigihit objects for this fdcCathodeHit"},
   {"toString", _FdcCathodeHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FdcCathodeHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FdcCathodeHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.FdcCathodeHit",         /*tp_name*/
    sizeof(_FdcCathodeHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FdcCathodeHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FdcCathodeHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s fdcCathodeHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FdcCathodeHit_methods,          /* tp_methods */
    _FdcCathodeHit_members,          /* tp_members */
    _FdcCathodeHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FdcCathodeHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FdcCathodeHit_new,              /* tp_new */
};



// wrap element class hddm_s::FdcCathodeTruthHit as hddm_s.FdcCathodeTruthHit

typedef struct {
   PyObject_HEAD
   FdcCathodeTruthHit *elem;
   PyObject *host;
} _FdcCathodeTruthHit;

static void
_FdcCathodeTruthHit_dealloc(_FdcCathodeTruthHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FdcCathodeTruthHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FdcCathodeTruthHit *self;
   self = (_FdcCathodeTruthHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FdcCathodeTruthHit_init(_FdcCathodeTruthHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FdcCathodeTruthHit_getClass(_FdcCathodeTruthHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcCathodeTruthHit_getVersion(_FdcCathodeTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_FdcCathodeTruthHit_getXmlns(_FdcCathodeTruthHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcCathodeTruthHit_getEventNo(_FdcCathodeTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_FdcCathodeTruthHit_getRunNo(_FdcCathodeTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FdcCathodeTruthHit_getMinOccurs(_FdcCathodeTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FdcCathodeTruthHit_getLayer(_FdcCathodeTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static PyObject*
_FdcCathodeTruthHit_getModule(_FdcCathodeTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static PyObject*
_FdcCathodeTruthHit_getPlane(_FdcCathodeTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPlane());
}

static PyObject*
_FdcCathodeTruthHit_getStrip(_FdcCathodeTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getStrip());
}

static PyObject*
_FdcCathodeTruthHit_getItrack(_FdcCathodeTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getItrack());
}

static int
_FdcCathodeTruthHit_setItrack(_FdcCathodeTruthHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setItrack(var);
   return 0;
}

static PyObject*
_FdcCathodeTruthHit_getMaxOccurs(_FdcCathodeTruthHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcCathodeTruthHit_getPtype(_FdcCathodeTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPtype());
}

static int
_FdcCathodeTruthHit_setPtype(_FdcCathodeTruthHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPtype(var);
   return 0;
}

static PyObject*
_FdcCathodeTruthHit_getQ(_FdcCathodeTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getQ());
}

static int
_FdcCathodeTruthHit_setQ(_FdcCathodeTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setQ((float)var);
   return 0;
}

static PyObject*
_FdcCathodeTruthHit_getT(_FdcCathodeTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_FdcCathodeTruthHit_setT(_FdcCathodeTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_FdcCathodeTruthHit_toString(PyObject *self, PyObject *args=0)
{
   _FdcCathodeTruthHit *me = (_FdcCathodeTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcCathodeTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FdcCathodeTruthHit_toXML(PyObject *self, PyObject *args=0)
{
   _FdcCathodeTruthHit *me = (_FdcCathodeTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcCathodeTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FdcCathodeTruthHit_getsetters[] = {
   {(char*)"class",
    (getter)_FdcCathodeTruthHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_FdcCathodeTruthHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"itrack",
    (getter)_FdcCathodeTruthHit_getItrack, (setter)_FdcCathodeTruthHit_setItrack,
    (char*)"itrack value",
    NULL},
   {(char*)"layer",
    (getter)_FdcCathodeTruthHit_getLayer, 0,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FdcCathodeTruthHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FdcCathodeTruthHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_FdcCathodeTruthHit_getModule, 0,
    (char*)"module value",
    NULL},
   {(char*)"plane",
    (getter)_FdcCathodeTruthHit_getPlane, 0,
    (char*)"plane value",
    NULL},
   {(char*)"ptype",
    (getter)_FdcCathodeTruthHit_getPtype, (setter)_FdcCathodeTruthHit_setPtype,
    (char*)"ptype value",
    NULL},
   {(char*)"q",
    (getter)_FdcCathodeTruthHit_getQ, (setter)_FdcCathodeTruthHit_setQ,
    (char*)"q value",
    NULL},
   {(char*)"runNo",
    (getter)_FdcCathodeTruthHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"strip",
    (getter)_FdcCathodeTruthHit_getStrip, 0,
    (char*)"strip value",
    NULL},
   {(char*)"t",
    (getter)_FdcCathodeTruthHit_getT, (setter)_FdcCathodeTruthHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_FdcCathodeTruthHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_FdcCathodeTruthHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FdcCathodeTruthHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FdcCathodeTruthHit_methods[] = {
   {"toString", _FdcCathodeTruthHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FdcCathodeTruthHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FdcCathodeTruthHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.FdcCathodeTruthHit",         /*tp_name*/
    sizeof(_FdcCathodeTruthHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FdcCathodeTruthHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FdcCathodeTruthHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s fdcCathodeTruthHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FdcCathodeTruthHit_methods,          /* tp_methods */
    _FdcCathodeTruthHit_members,          /* tp_members */
    _FdcCathodeTruthHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FdcCathodeTruthHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FdcCathodeTruthHit_new,              /* tp_new */
};



// wrap element class hddm_s::FdcCathodeStrip as hddm_s.FdcCathodeStrip

typedef struct {
   PyObject_HEAD
   FdcCathodeStrip *elem;
   PyObject *host;
} _FdcCathodeStrip;

static void
_FdcCathodeStrip_dealloc(_FdcCathodeStrip* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FdcCathodeStrip_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FdcCathodeStrip *self;
   self = (_FdcCathodeStrip*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FdcCathodeStrip_init(_FdcCathodeStrip *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FdcCathodeStrip_getClass(_FdcCathodeStrip *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcCathodeStrip_getVersion(_FdcCathodeStrip *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_FdcCathodeStrip_getXmlns(_FdcCathodeStrip *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcCathodeStrip_getEventNo(_FdcCathodeStrip *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_FdcCathodeStrip_getRunNo(_FdcCathodeStrip *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FdcCathodeStrip_getLayer(_FdcCathodeStrip *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static PyObject*
_FdcCathodeStrip_getModule(_FdcCathodeStrip *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static PyObject*
_FdcCathodeStrip_getMaxOccurs(_FdcCathodeStrip *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcCathodeStrip_getMinOccurs(_FdcCathodeStrip *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FdcCathodeStrip_getPlane(_FdcCathodeStrip *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPlane());
}

static int
_FdcCathodeStrip_setPlane(_FdcCathodeStrip *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPlane(var);
   return 0;
}

static PyObject*
_FdcCathodeStrip_getStrip(_FdcCathodeStrip *self, void *closure)
{
   return PyLong_FromLong(self->elem->getStrip());
}

static int
_FdcCathodeStrip_setStrip(_FdcCathodeStrip *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setStrip(var);
   return 0;
}

static PyObject*
_FdcCathodeStrip_getFdcCathodeHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FdcCathodeStrip *me = (_FdcCathodeStrip*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcCathodeStrip element");
      return NULL;
   }
   PyObject *obj = _FdcCathodeHit_new(&_FdcCathodeHit_type, 0, 0);
   ((_FdcCathodeHit*)obj)->elem = &me->elem->getFdcCathodeHit(index);
   ((_FdcCathodeHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FdcCathodeStrip_getFdcCathodeHits(PyObject *self, PyObject *args)
{
   _FdcCathodeStrip *me = (_FdcCathodeStrip*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcCathodeStrip element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FdcCathodeHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFdcCathodeHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FdcCathodeStrip_addFdcCathodeHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FdcCathodeStrip *me = (_FdcCathodeStrip*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid fdcCathodeStrip element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FdcCathodeHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FdcCathodeHitList(me->elem->addFdcCathodeHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FdcCathodeStrip_deleteFdcCathodeHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FdcCathodeStrip *me = (_FdcCathodeStrip*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid fdcCathodeStrip element");
      return NULL;
   }
   me->elem->deleteFdcCathodeHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FdcCathodeStrip_getFdcCathodeTruthHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FdcCathodeStrip *me = (_FdcCathodeStrip*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcCathodeStrip element");
      return NULL;
   }
   PyObject *obj = _FdcCathodeTruthHit_new(&_FdcCathodeTruthHit_type, 0, 0);
   ((_FdcCathodeTruthHit*)obj)->elem = &me->elem->getFdcCathodeTruthHit(index);
   ((_FdcCathodeTruthHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FdcCathodeStrip_getFdcCathodeTruthHits(PyObject *self, PyObject *args)
{
   _FdcCathodeStrip *me = (_FdcCathodeStrip*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcCathodeStrip element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FdcCathodeTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFdcCathodeTruthHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FdcCathodeStrip_addFdcCathodeTruthHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FdcCathodeStrip *me = (_FdcCathodeStrip*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid fdcCathodeStrip element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FdcCathodeTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FdcCathodeTruthHitList(me->elem->addFdcCathodeTruthHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FdcCathodeStrip_deleteFdcCathodeTruthHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FdcCathodeStrip *me = (_FdcCathodeStrip*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid fdcCathodeStrip element");
      return NULL;
   }
   me->elem->deleteFdcCathodeTruthHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FdcCathodeStrip_toString(PyObject *self, PyObject *args=0)
{
   _FdcCathodeStrip *me = (_FdcCathodeStrip*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcCathodeStrip element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FdcCathodeStrip_toXML(PyObject *self, PyObject *args=0)
{
   _FdcCathodeStrip *me = (_FdcCathodeStrip*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcCathodeStrip element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FdcCathodeStrip_getsetters[] = {
   {(char*)"class",
    (getter)_FdcCathodeStrip_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_FdcCathodeStrip_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"layer",
    (getter)_FdcCathodeStrip_getLayer, 0,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FdcCathodeStrip_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FdcCathodeStrip_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_FdcCathodeStrip_getModule, 0,
    (char*)"module value",
    NULL},
   {(char*)"plane",
    (getter)_FdcCathodeStrip_getPlane, (setter)_FdcCathodeStrip_setPlane,
    (char*)"plane value",
    NULL},
   {(char*)"runNo",
    (getter)_FdcCathodeStrip_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"strip",
    (getter)_FdcCathodeStrip_getStrip, (setter)_FdcCathodeStrip_setStrip,
    (char*)"strip value",
    NULL},
   {(char*)"version",
    (getter)_FdcCathodeStrip_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_FdcCathodeStrip_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FdcCathodeStrip_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FdcCathodeStrip_methods[] = {
   {"addFdcCathodeHits", _FdcCathodeStrip_addFdcCathodeHits, METH_VARARGS,
    "extend (or insert into) the list of fdcCathodeHit objects for this fdcCathodeStrip"},
   {"addFdcCathodeTruthHits", _FdcCathodeStrip_addFdcCathodeTruthHits, METH_VARARGS,
    "extend (or insert into) the list of fdcCathodeTruthHit objects for this fdcCathodeStrip"},
   {"deleteFdcCathodeHits", _FdcCathodeStrip_deleteFdcCathodeHits, METH_VARARGS,
    "delete fdcCathodeHit objects for this fdcCathodeStrip"},
   {"deleteFdcCathodeTruthHits", _FdcCathodeStrip_deleteFdcCathodeTruthHits, METH_VARARGS,
    "delete fdcCathodeTruthHit objects for this fdcCathodeStrip"},
   {"getFdcCathodeHit", _FdcCathodeStrip_getFdcCathodeHit, METH_VARARGS,
    "get an individual fdcCathodeHit object from this fdcCathodeStrip"},
   {"getFdcCathodeHits", _FdcCathodeStrip_getFdcCathodeHits, METH_NOARGS,
    "get list of fdcCathodeHit objects for this fdcCathodeStrip"},
   {"getFdcCathodeTruthHit", _FdcCathodeStrip_getFdcCathodeTruthHit, METH_VARARGS,
    "get an individual fdcCathodeTruthHit object from this fdcCathodeStrip"},
   {"getFdcCathodeTruthHits", _FdcCathodeStrip_getFdcCathodeTruthHits, METH_NOARGS,
    "get list of fdcCathodeTruthHit objects for this fdcCathodeStrip"},
   {"toString", _FdcCathodeStrip_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FdcCathodeStrip_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FdcCathodeStrip_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.FdcCathodeStrip",         /*tp_name*/
    sizeof(_FdcCathodeStrip),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FdcCathodeStrip_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FdcCathodeStrip_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s fdcCathodeStrip element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FdcCathodeStrip_methods,          /* tp_methods */
    _FdcCathodeStrip_members,          /* tp_members */
    _FdcCathodeStrip_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FdcCathodeStrip_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FdcCathodeStrip_new,              /* tp_new */
};



// wrap element class hddm_s::FdcTruthPoint as hddm_s.FdcTruthPoint

typedef struct {
   PyObject_HEAD
   FdcTruthPoint *elem;
   PyObject *host;
} _FdcTruthPoint;

static void
_FdcTruthPoint_dealloc(_FdcTruthPoint* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FdcTruthPoint_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FdcTruthPoint *self;
   self = (_FdcTruthPoint*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FdcTruthPoint_init(_FdcTruthPoint *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FdcTruthPoint_getClass(_FdcTruthPoint *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcTruthPoint_getVersion(_FdcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_FdcTruthPoint_getXmlns(_FdcTruthPoint *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcTruthPoint_getEventNo(_FdcTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_FdcTruthPoint_getRunNo(_FdcTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FdcTruthPoint_getLayer(_FdcTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static PyObject*
_FdcTruthPoint_getModule(_FdcTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static PyObject*
_FdcTruthPoint_getE(_FdcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_FdcTruthPoint_setE(_FdcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_FdcTruthPoint_getDEdx(_FdcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdx());
}

static int
_FdcTruthPoint_setDEdx(_FdcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDEdx((float)var);
   return 0;
}

static PyObject*
_FdcTruthPoint_getDradius(_FdcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDradius());
}

static int
_FdcTruthPoint_setDradius(_FdcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDradius((float)var);
   return 0;
}

static PyObject*
_FdcTruthPoint_getMaxOccurs(_FdcTruthPoint *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcTruthPoint_getMinOccurs(_FdcTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FdcTruthPoint_getPrimary(_FdcTruthPoint *self, void *closure)
{
   return PyBool_FromLong(self->elem->getPrimary());
}

static int
_FdcTruthPoint_setPrimary(_FdcTruthPoint *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPrimary((var==0)? false : true);
   return 0;
}

static PyObject*
_FdcTruthPoint_getPtype(_FdcTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPtype());
}

static int
_FdcTruthPoint_setPtype(_FdcTruthPoint *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPtype(var);
   return 0;
}

static PyObject*
_FdcTruthPoint_getPx(_FdcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPx());
}

static int
_FdcTruthPoint_setPx(_FdcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPx((float)var);
   return 0;
}

static PyObject*
_FdcTruthPoint_getPy(_FdcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPy());
}

static int
_FdcTruthPoint_setPy(_FdcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPy((float)var);
   return 0;
}

static PyObject*
_FdcTruthPoint_getPz(_FdcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPz());
}

static int
_FdcTruthPoint_setPz(_FdcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPz((float)var);
   return 0;
}

static PyObject*
_FdcTruthPoint_getT(_FdcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_FdcTruthPoint_setT(_FdcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_FdcTruthPoint_getTrack(_FdcTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static int
_FdcTruthPoint_setTrack(_FdcTruthPoint *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTrack(var);
   return 0;
}

static PyObject*
_FdcTruthPoint_getX(_FdcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static int
_FdcTruthPoint_setX(_FdcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setX((float)var);
   return 0;
}

static PyObject*
_FdcTruthPoint_getY(_FdcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static int
_FdcTruthPoint_setY(_FdcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setY((float)var);
   return 0;
}

static PyObject*
_FdcTruthPoint_getZ(_FdcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static int
_FdcTruthPoint_setZ(_FdcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ((float)var);
   return 0;
}

static PyObject*
_FdcTruthPoint_getTrackID(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FdcTruthPoint *me = (_FdcTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcTruthPoint element");
      return NULL;
   }
   PyObject *obj = _TrackID_new(&_TrackID_type, 0, 0);
   ((_TrackID*)obj)->elem = &me->elem->getTrackID();
   ((_TrackID*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FdcTruthPoint_getTrackIDs(PyObject *self, PyObject *args)
{
   _FdcTruthPoint *me = (_FdcTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcTruthPoint element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackID_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTrackIDs();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FdcTruthPoint_addTrackIDs(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FdcTruthPoint *me = (_FdcTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid fdcTruthPoint element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackID_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TrackIDList(me->elem->addTrackIDs(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FdcTruthPoint_deleteTrackIDs(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FdcTruthPoint *me = (_FdcTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid fdcTruthPoint element");
      return NULL;
   }
   me->elem->deleteTrackIDs(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FdcTruthPoint_toString(PyObject *self, PyObject *args=0)
{
   _FdcTruthPoint *me = (_FdcTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcTruthPoint element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FdcTruthPoint_toXML(PyObject *self, PyObject *args=0)
{
   _FdcTruthPoint *me = (_FdcTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcTruthPoint element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FdcTruthPoint_getsetters[] = {
   {(char*)"E",
    (getter)_FdcTruthPoint_getE, (setter)_FdcTruthPoint_setE,
    (char*)"E value",
    NULL},
   {(char*)"class",
    (getter)_FdcTruthPoint_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dEdx",
    (getter)_FdcTruthPoint_getDEdx, (setter)_FdcTruthPoint_setDEdx,
    (char*)"dEdx value",
    NULL},
   {(char*)"dradius",
    (getter)_FdcTruthPoint_getDradius, (setter)_FdcTruthPoint_setDradius,
    (char*)"dradius value",
    NULL},
   {(char*)"eventNo",
    (getter)_FdcTruthPoint_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"layer",
    (getter)_FdcTruthPoint_getLayer, 0,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FdcTruthPoint_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FdcTruthPoint_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_FdcTruthPoint_getModule, 0,
    (char*)"module value",
    NULL},
   {(char*)"primary",
    (getter)_FdcTruthPoint_getPrimary, (setter)_FdcTruthPoint_setPrimary,
    (char*)"primary value",
    NULL},
   {(char*)"ptype",
    (getter)_FdcTruthPoint_getPtype, (setter)_FdcTruthPoint_setPtype,
    (char*)"ptype value",
    NULL},
   {(char*)"px",
    (getter)_FdcTruthPoint_getPx, (setter)_FdcTruthPoint_setPx,
    (char*)"px value",
    NULL},
   {(char*)"py",
    (getter)_FdcTruthPoint_getPy, (setter)_FdcTruthPoint_setPy,
    (char*)"py value",
    NULL},
   {(char*)"pz",
    (getter)_FdcTruthPoint_getPz, (setter)_FdcTruthPoint_setPz,
    (char*)"pz value",
    NULL},
   {(char*)"runNo",
    (getter)_FdcTruthPoint_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_FdcTruthPoint_getT, (setter)_FdcTruthPoint_setT,
    (char*)"t value",
    NULL},
   {(char*)"track",
    (getter)_FdcTruthPoint_getTrack, (setter)_FdcTruthPoint_setTrack,
    (char*)"track value",
    NULL},
   {(char*)"version",
    (getter)_FdcTruthPoint_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"x",
    (getter)_FdcTruthPoint_getX, (setter)_FdcTruthPoint_setX,
    (char*)"x value",
    NULL},
   {(char*)"xmlns",
    (getter)_FdcTruthPoint_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y",
    (getter)_FdcTruthPoint_getY, (setter)_FdcTruthPoint_setY,
    (char*)"y value",
    NULL},
   {(char*)"z",
    (getter)_FdcTruthPoint_getZ, (setter)_FdcTruthPoint_setZ,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FdcTruthPoint_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FdcTruthPoint_methods[] = {
   {"addTrackIDs", _FdcTruthPoint_addTrackIDs, METH_VARARGS,
    "extend (or insert into) the list of trackID objects for this fdcTruthPoint"},
   {"deleteTrackIDs", _FdcTruthPoint_deleteTrackIDs, METH_VARARGS,
    "delete trackID objects for this fdcTruthPoint"},
   {"getTrackID", _FdcTruthPoint_getTrackID, METH_VARARGS,
    "get an individual trackID object from this fdcTruthPoint"},
   {"getTrackIDs", _FdcTruthPoint_getTrackIDs, METH_NOARGS,
    "get list of trackID objects for this fdcTruthPoint"},
   {"toString", _FdcTruthPoint_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FdcTruthPoint_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FdcTruthPoint_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.FdcTruthPoint",         /*tp_name*/
    sizeof(_FdcTruthPoint),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FdcTruthPoint_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FdcTruthPoint_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s fdcTruthPoint element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FdcTruthPoint_methods,          /* tp_methods */
    _FdcTruthPoint_members,          /* tp_members */
    _FdcTruthPoint_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FdcTruthPoint_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FdcTruthPoint_new,              /* tp_new */
};



// wrap element class hddm_s::FdcChamber as hddm_s.FdcChamber

typedef struct {
   PyObject_HEAD
   FdcChamber *elem;
   PyObject *host;
} _FdcChamber;

static void
_FdcChamber_dealloc(_FdcChamber* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FdcChamber_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FdcChamber *self;
   self = (_FdcChamber*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FdcChamber_init(_FdcChamber *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FdcChamber_getClass(_FdcChamber *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcChamber_getVersion(_FdcChamber *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_FdcChamber_getXmlns(_FdcChamber *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcChamber_getEventNo(_FdcChamber *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_FdcChamber_getRunNo(_FdcChamber *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FdcChamber_getMinOccurs(_FdcChamber *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FdcChamber_getLayer(_FdcChamber *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static int
_FdcChamber_setLayer(_FdcChamber *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setLayer(var);
   return 0;
}

static PyObject*
_FdcChamber_getMaxOccurs(_FdcChamber *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FdcChamber_getModule(_FdcChamber *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static int
_FdcChamber_setModule(_FdcChamber *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setModule(var);
   return 0;
}

static PyObject*
_FdcChamber_getFdcAnodeWire(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FdcChamber *me = (_FdcChamber*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcChamber element");
      return NULL;
   }
   PyObject *obj = _FdcAnodeWire_new(&_FdcAnodeWire_type, 0, 0);
   ((_FdcAnodeWire*)obj)->elem = &me->elem->getFdcAnodeWire(index);
   ((_FdcAnodeWire*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FdcChamber_getFdcAnodeWires(PyObject *self, PyObject *args)
{
   _FdcChamber *me = (_FdcChamber*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcChamber element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FdcAnodeWire_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFdcAnodeWires();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FdcChamber_addFdcAnodeWires(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FdcChamber *me = (_FdcChamber*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid fdcChamber element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FdcAnodeWire_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FdcAnodeWireList(me->elem->addFdcAnodeWires(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FdcChamber_deleteFdcAnodeWires(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FdcChamber *me = (_FdcChamber*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid fdcChamber element");
      return NULL;
   }
   me->elem->deleteFdcAnodeWires(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FdcChamber_getFdcCathodeStrip(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FdcChamber *me = (_FdcChamber*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcChamber element");
      return NULL;
   }
   PyObject *obj = _FdcCathodeStrip_new(&_FdcCathodeStrip_type, 0, 0);
   ((_FdcCathodeStrip*)obj)->elem = &me->elem->getFdcCathodeStrip(index);
   ((_FdcCathodeStrip*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FdcChamber_getFdcCathodeStrips(PyObject *self, PyObject *args)
{
   _FdcChamber *me = (_FdcChamber*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcChamber element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FdcCathodeStrip_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFdcCathodeStrips();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FdcChamber_addFdcCathodeStrips(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FdcChamber *me = (_FdcChamber*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid fdcChamber element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FdcCathodeStrip_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FdcCathodeStripList(me->elem->addFdcCathodeStrips(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FdcChamber_deleteFdcCathodeStrips(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FdcChamber *me = (_FdcChamber*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid fdcChamber element");
      return NULL;
   }
   me->elem->deleteFdcCathodeStrips(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FdcChamber_getFdcTruthPoint(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FdcChamber *me = (_FdcChamber*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcChamber element");
      return NULL;
   }
   PyObject *obj = _FdcTruthPoint_new(&_FdcTruthPoint_type, 0, 0);
   ((_FdcTruthPoint*)obj)->elem = &me->elem->getFdcTruthPoint(index);
   ((_FdcTruthPoint*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FdcChamber_getFdcTruthPoints(PyObject *self, PyObject *args)
{
   _FdcChamber *me = (_FdcChamber*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcChamber element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FdcTruthPoint_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFdcTruthPoints();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FdcChamber_addFdcTruthPoints(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FdcChamber *me = (_FdcChamber*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid fdcChamber element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FdcTruthPoint_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FdcTruthPointList(me->elem->addFdcTruthPoints(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FdcChamber_deleteFdcTruthPoints(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FdcChamber *me = (_FdcChamber*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid fdcChamber element");
      return NULL;
   }
   me->elem->deleteFdcTruthPoints(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FdcChamber_toString(PyObject *self, PyObject *args=0)
{
   _FdcChamber *me = (_FdcChamber*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcChamber element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FdcChamber_toXML(PyObject *self, PyObject *args=0)
{
   _FdcChamber *me = (_FdcChamber*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fdcChamber element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FdcChamber_getsetters[] = {
   {(char*)"class",
    (getter)_FdcChamber_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_FdcChamber_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"layer",
    (getter)_FdcChamber_getLayer, (setter)_FdcChamber_setLayer,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FdcChamber_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FdcChamber_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_FdcChamber_getModule, (setter)_FdcChamber_setModule,
    (char*)"module value",
    NULL},
   {(char*)"runNo",
    (getter)_FdcChamber_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_FdcChamber_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_FdcChamber_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FdcChamber_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FdcChamber_methods[] = {
   {"addFdcAnodeWires", _FdcChamber_addFdcAnodeWires, METH_VARARGS,
    "extend (or insert into) the list of fdcAnodeWire objects for this fdcChamber"},
   {"addFdcCathodeStrips", _FdcChamber_addFdcCathodeStrips, METH_VARARGS,
    "extend (or insert into) the list of fdcCathodeStrip objects for this fdcChamber"},
   {"addFdcTruthPoints", _FdcChamber_addFdcTruthPoints, METH_VARARGS,
    "extend (or insert into) the list of fdcTruthPoint objects for this fdcChamber"},
   {"deleteFdcAnodeWires", _FdcChamber_deleteFdcAnodeWires, METH_VARARGS,
    "delete fdcAnodeWire objects for this fdcChamber"},
   {"deleteFdcCathodeStrips", _FdcChamber_deleteFdcCathodeStrips, METH_VARARGS,
    "delete fdcCathodeStrip objects for this fdcChamber"},
   {"deleteFdcTruthPoints", _FdcChamber_deleteFdcTruthPoints, METH_VARARGS,
    "delete fdcTruthPoint objects for this fdcChamber"},
   {"getFdcAnodeWire", _FdcChamber_getFdcAnodeWire, METH_VARARGS,
    "get an individual fdcAnodeWire object from this fdcChamber"},
   {"getFdcAnodeWires", _FdcChamber_getFdcAnodeWires, METH_NOARGS,
    "get list of fdcAnodeWire objects for this fdcChamber"},
   {"getFdcCathodeStrip", _FdcChamber_getFdcCathodeStrip, METH_VARARGS,
    "get an individual fdcCathodeStrip object from this fdcChamber"},
   {"getFdcCathodeStrips", _FdcChamber_getFdcCathodeStrips, METH_NOARGS,
    "get list of fdcCathodeStrip objects for this fdcChamber"},
   {"getFdcTruthPoint", _FdcChamber_getFdcTruthPoint, METH_VARARGS,
    "get an individual fdcTruthPoint object from this fdcChamber"},
   {"getFdcTruthPoints", _FdcChamber_getFdcTruthPoints, METH_NOARGS,
    "get list of fdcTruthPoint objects for this fdcChamber"},
   {"toString", _FdcChamber_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FdcChamber_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FdcChamber_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.FdcChamber",         /*tp_name*/
    sizeof(_FdcChamber),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FdcChamber_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FdcChamber_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s fdcChamber element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FdcChamber_methods,          /* tp_methods */
    _FdcChamber_members,          /* tp_members */
    _FdcChamber_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FdcChamber_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FdcChamber_new,              /* tp_new */
};



// wrap element class hddm_s::ForwardDC as hddm_s.ForwardDC

typedef struct {
   PyObject_HEAD
   ForwardDC *elem;
   PyObject *host;
} _ForwardDC;

static void
_ForwardDC_dealloc(_ForwardDC* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_ForwardDC_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _ForwardDC *self;
   self = (_ForwardDC*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_ForwardDC_init(_ForwardDC *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_ForwardDC_getClass(_ForwardDC *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ForwardDC_getVersion(_ForwardDC *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_ForwardDC_getXmlns(_ForwardDC *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ForwardDC_getEventNo(_ForwardDC *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_ForwardDC_getMaxOccurs(_ForwardDC *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ForwardDC_getRunNo(_ForwardDC *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_ForwardDC_getMinOccurs(_ForwardDC *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_ForwardDC_getFdcChamber(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ForwardDC *me = (_ForwardDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid forwardDC element");
      return NULL;
   }
   PyObject *obj = _FdcChamber_new(&_FdcChamber_type, 0, 0);
   ((_FdcChamber*)obj)->elem = &me->elem->getFdcChamber(index);
   ((_FdcChamber*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ForwardDC_getFdcChambers(PyObject *self, PyObject *args)
{
   _ForwardDC *me = (_ForwardDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid forwardDC element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FdcChamber_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFdcChambers();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ForwardDC_addFdcChambers(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ForwardDC *me = (_ForwardDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid forwardDC element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FdcChamber_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FdcChamberList(me->elem->addFdcChambers(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ForwardDC_deleteFdcChambers(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ForwardDC *me = (_ForwardDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid forwardDC element");
      return NULL;
   }
   me->elem->deleteFdcChambers(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ForwardDC_toString(PyObject *self, PyObject *args=0)
{
   _ForwardDC *me = (_ForwardDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid forwardDC element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_ForwardDC_toXML(PyObject *self, PyObject *args=0)
{
   _ForwardDC *me = (_ForwardDC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid forwardDC element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _ForwardDC_getsetters[] = {
   {(char*)"class",
    (getter)_ForwardDC_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_ForwardDC_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_ForwardDC_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_ForwardDC_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_ForwardDC_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_ForwardDC_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_ForwardDC_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _ForwardDC_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _ForwardDC_methods[] = {
   {"addFdcChambers", _ForwardDC_addFdcChambers, METH_VARARGS,
    "extend (or insert into) the list of fdcChamber objects for this forwardDC"},
   {"deleteFdcChambers", _ForwardDC_deleteFdcChambers, METH_VARARGS,
    "delete fdcChamber objects for this forwardDC"},
   {"getFdcChamber", _ForwardDC_getFdcChamber, METH_VARARGS,
    "get an individual fdcChamber object from this forwardDC"},
   {"getFdcChambers", _ForwardDC_getFdcChambers, METH_NOARGS,
    "get list of fdcChamber objects for this forwardDC"},
   {"toString", _ForwardDC_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _ForwardDC_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _ForwardDC_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.ForwardDC",         /*tp_name*/
    sizeof(_ForwardDC),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_ForwardDC_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_ForwardDC_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s forwardDC element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _ForwardDC_methods,          /* tp_methods */
    _ForwardDC_members,          /* tp_members */
    _ForwardDC_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_ForwardDC_init,   /* tp_init */
    0,                         /* tp_alloc */
    _ForwardDC_new,              /* tp_new */
};



// wrap element class hddm_s::StcDigihit as hddm_s.StcDigihit

typedef struct {
   PyObject_HEAD
   StcDigihit *elem;
   PyObject *host;
} _StcDigihit;

static void
_StcDigihit_dealloc(_StcDigihit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_StcDigihit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _StcDigihit *self;
   self = (_StcDigihit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_StcDigihit_init(_StcDigihit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_StcDigihit_getClass(_StcDigihit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StcDigihit_getVersion(_StcDigihit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_StcDigihit_getXmlns(_StcDigihit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StcDigihit_getEventNo(_StcDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_StcDigihit_getMaxOccurs(_StcDigihit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StcDigihit_getRunNo(_StcDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_StcDigihit_getSector(_StcDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSector());
}

static PyObject*
_StcDigihit_getDE(_StcDigihit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDE());
}

static PyObject*
_StcDigihit_getT(_StcDigihit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_StcDigihit_getMinOccurs(_StcDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_StcDigihit_getPeakAmp(_StcDigihit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPeakAmp());
}

static int
_StcDigihit_setPeakAmp(_StcDigihit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPeakAmp((float)var);
   return 0;
}

static PyObject*
_StcDigihit_toString(PyObject *self, PyObject *args=0)
{
   _StcDigihit *me = (_StcDigihit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid stcDigihit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_StcDigihit_toXML(PyObject *self, PyObject *args=0)
{
   _StcDigihit *me = (_StcDigihit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid stcDigihit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _StcDigihit_getsetters[] = {
   {(char*)"class",
    (getter)_StcDigihit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dE",
    (getter)_StcDigihit_getDE, 0,
    (char*)"dE value",
    NULL},
   {(char*)"eventNo",
    (getter)_StcDigihit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_StcDigihit_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_StcDigihit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"peakAmp",
    (getter)_StcDigihit_getPeakAmp, (setter)_StcDigihit_setPeakAmp,
    (char*)"peakAmp value",
    NULL},
   {(char*)"runNo",
    (getter)_StcDigihit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sector",
    (getter)_StcDigihit_getSector, 0,
    (char*)"sector value",
    NULL},
   {(char*)"t",
    (getter)_StcDigihit_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_StcDigihit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_StcDigihit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _StcDigihit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _StcDigihit_methods[] = {
   {"toString", _StcDigihit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _StcDigihit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _StcDigihit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.StcDigihit",         /*tp_name*/
    sizeof(_StcDigihit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_StcDigihit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_StcDigihit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s stcDigihit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _StcDigihit_methods,          /* tp_methods */
    _StcDigihit_members,          /* tp_members */
    _StcDigihit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_StcDigihit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _StcDigihit_new,              /* tp_new */
};



// wrap element class hddm_s::StcHit as hddm_s.StcHit

typedef struct {
   PyObject_HEAD
   StcHit *elem;
   PyObject *host;
} _StcHit;

static void
_StcHit_dealloc(_StcHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_StcHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _StcHit *self;
   self = (_StcHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_StcHit_init(_StcHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_StcHit_getClass(_StcHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StcHit_getVersion(_StcHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_StcHit_getXmlns(_StcHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StcHit_getEventNo(_StcHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_StcHit_getRunNo(_StcHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_StcHit_getMinOccurs(_StcHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_StcHit_getSector(_StcHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSector());
}

static PyObject*
_StcHit_getDE(_StcHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDE());
}

static int
_StcHit_setDE(_StcHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDE((float)var);
   return 0;
}

static PyObject*
_StcHit_getMaxOccurs(_StcHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StcHit_getT(_StcHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_StcHit_setT(_StcHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_StcHit_getStcDigihit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _StcHit *me = (_StcHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid stcHit element");
      return NULL;
   }
   PyObject *obj = _StcDigihit_new(&_StcDigihit_type, 0, 0);
   ((_StcDigihit*)obj)->elem = &me->elem->getStcDigihit();
   ((_StcDigihit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_StcHit_getStcDigihits(PyObject *self, PyObject *args)
{
   _StcHit *me = (_StcHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid stcHit element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_StcDigihit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getStcDigihits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_StcHit_addStcDigihits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _StcHit *me = (_StcHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid stcHit element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_StcDigihit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new StcDigihitList(me->elem->addStcDigihits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_StcHit_deleteStcDigihits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _StcHit *me = (_StcHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid stcHit element");
      return NULL;
   }
   me->elem->deleteStcDigihits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_StcHit_toString(PyObject *self, PyObject *args=0)
{
   _StcHit *me = (_StcHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid stcHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_StcHit_toXML(PyObject *self, PyObject *args=0)
{
   _StcHit *me = (_StcHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid stcHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _StcHit_getsetters[] = {
   {(char*)"class",
    (getter)_StcHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dE",
    (getter)_StcHit_getDE, (setter)_StcHit_setDE,
    (char*)"dE value",
    NULL},
   {(char*)"eventNo",
    (getter)_StcHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_StcHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_StcHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_StcHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sector",
    (getter)_StcHit_getSector, 0,
    (char*)"sector value",
    NULL},
   {(char*)"t",
    (getter)_StcHit_getT, (setter)_StcHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_StcHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_StcHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _StcHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _StcHit_methods[] = {
   {"addStcDigihits", _StcHit_addStcDigihits, METH_VARARGS,
    "extend (or insert into) the list of stcDigihit objects for this stcHit"},
   {"deleteStcDigihits", _StcHit_deleteStcDigihits, METH_VARARGS,
    "delete stcDigihit objects for this stcHit"},
   {"getStcDigihit", _StcHit_getStcDigihit, METH_VARARGS,
    "get an individual stcDigihit object from this stcHit"},
   {"getStcDigihits", _StcHit_getStcDigihits, METH_NOARGS,
    "get list of stcDigihit objects for this stcHit"},
   {"toString", _StcHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _StcHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _StcHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.StcHit",         /*tp_name*/
    sizeof(_StcHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_StcHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_StcHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s stcHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _StcHit_methods,          /* tp_methods */
    _StcHit_members,          /* tp_members */
    _StcHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_StcHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _StcHit_new,              /* tp_new */
};



// wrap element class hddm_s::StcTruthHit as hddm_s.StcTruthHit

typedef struct {
   PyObject_HEAD
   StcTruthHit *elem;
   PyObject *host;
} _StcTruthHit;

static void
_StcTruthHit_dealloc(_StcTruthHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_StcTruthHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _StcTruthHit *self;
   self = (_StcTruthHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_StcTruthHit_init(_StcTruthHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_StcTruthHit_getClass(_StcTruthHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StcTruthHit_getVersion(_StcTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_StcTruthHit_getXmlns(_StcTruthHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StcTruthHit_getEventNo(_StcTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_StcTruthHit_getRunNo(_StcTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_StcTruthHit_getMinOccurs(_StcTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_StcTruthHit_getSector(_StcTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSector());
}

static PyObject*
_StcTruthHit_getDE(_StcTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDE());
}

static int
_StcTruthHit_setDE(_StcTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDE((float)var);
   return 0;
}

static PyObject*
_StcTruthHit_getItrack(_StcTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getItrack());
}

static int
_StcTruthHit_setItrack(_StcTruthHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setItrack(var);
   return 0;
}

static PyObject*
_StcTruthHit_getMaxOccurs(_StcTruthHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StcTruthHit_getPtype(_StcTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPtype());
}

static int
_StcTruthHit_setPtype(_StcTruthHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPtype(var);
   return 0;
}

static PyObject*
_StcTruthHit_getT(_StcTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_StcTruthHit_setT(_StcTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_StcTruthHit_toString(PyObject *self, PyObject *args=0)
{
   _StcTruthHit *me = (_StcTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid stcTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_StcTruthHit_toXML(PyObject *self, PyObject *args=0)
{
   _StcTruthHit *me = (_StcTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid stcTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _StcTruthHit_getsetters[] = {
   {(char*)"class",
    (getter)_StcTruthHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dE",
    (getter)_StcTruthHit_getDE, (setter)_StcTruthHit_setDE,
    (char*)"dE value",
    NULL},
   {(char*)"eventNo",
    (getter)_StcTruthHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"itrack",
    (getter)_StcTruthHit_getItrack, (setter)_StcTruthHit_setItrack,
    (char*)"itrack value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_StcTruthHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_StcTruthHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"ptype",
    (getter)_StcTruthHit_getPtype, (setter)_StcTruthHit_setPtype,
    (char*)"ptype value",
    NULL},
   {(char*)"runNo",
    (getter)_StcTruthHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sector",
    (getter)_StcTruthHit_getSector, 0,
    (char*)"sector value",
    NULL},
   {(char*)"t",
    (getter)_StcTruthHit_getT, (setter)_StcTruthHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_StcTruthHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_StcTruthHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _StcTruthHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _StcTruthHit_methods[] = {
   {"toString", _StcTruthHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _StcTruthHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _StcTruthHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.StcTruthHit",         /*tp_name*/
    sizeof(_StcTruthHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_StcTruthHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_StcTruthHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s stcTruthHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _StcTruthHit_methods,          /* tp_methods */
    _StcTruthHit_members,          /* tp_members */
    _StcTruthHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_StcTruthHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _StcTruthHit_new,              /* tp_new */
};



// wrap element class hddm_s::StcPaddle as hddm_s.StcPaddle

typedef struct {
   PyObject_HEAD
   StcPaddle *elem;
   PyObject *host;
} _StcPaddle;

static void
_StcPaddle_dealloc(_StcPaddle* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_StcPaddle_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _StcPaddle *self;
   self = (_StcPaddle*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_StcPaddle_init(_StcPaddle *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_StcPaddle_getClass(_StcPaddle *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StcPaddle_getVersion(_StcPaddle *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_StcPaddle_getXmlns(_StcPaddle *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StcPaddle_getEventNo(_StcPaddle *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_StcPaddle_getRunNo(_StcPaddle *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_StcPaddle_getMaxOccurs(_StcPaddle *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StcPaddle_getMinOccurs(_StcPaddle *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_StcPaddle_getSector(_StcPaddle *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSector());
}

static int
_StcPaddle_setSector(_StcPaddle *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setSector(var);
   return 0;
}

static PyObject*
_StcPaddle_getStcHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _StcPaddle *me = (_StcPaddle*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid stcPaddle element");
      return NULL;
   }
   PyObject *obj = _StcHit_new(&_StcHit_type, 0, 0);
   ((_StcHit*)obj)->elem = &me->elem->getStcHit(index);
   ((_StcHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_StcPaddle_getStcHits(PyObject *self, PyObject *args)
{
   _StcPaddle *me = (_StcPaddle*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid stcPaddle element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_StcHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getStcHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_StcPaddle_addStcHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _StcPaddle *me = (_StcPaddle*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid stcPaddle element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_StcHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new StcHitList(me->elem->addStcHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_StcPaddle_deleteStcHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _StcPaddle *me = (_StcPaddle*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid stcPaddle element");
      return NULL;
   }
   me->elem->deleteStcHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_StcPaddle_getStcTruthHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _StcPaddle *me = (_StcPaddle*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid stcPaddle element");
      return NULL;
   }
   PyObject *obj = _StcTruthHit_new(&_StcTruthHit_type, 0, 0);
   ((_StcTruthHit*)obj)->elem = &me->elem->getStcTruthHit(index);
   ((_StcTruthHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_StcPaddle_getStcTruthHits(PyObject *self, PyObject *args)
{
   _StcPaddle *me = (_StcPaddle*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid stcPaddle element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_StcTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getStcTruthHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_StcPaddle_addStcTruthHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _StcPaddle *me = (_StcPaddle*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid stcPaddle element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_StcTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new StcTruthHitList(me->elem->addStcTruthHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_StcPaddle_deleteStcTruthHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _StcPaddle *me = (_StcPaddle*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid stcPaddle element");
      return NULL;
   }
   me->elem->deleteStcTruthHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_StcPaddle_toString(PyObject *self, PyObject *args=0)
{
   _StcPaddle *me = (_StcPaddle*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid stcPaddle element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_StcPaddle_toXML(PyObject *self, PyObject *args=0)
{
   _StcPaddle *me = (_StcPaddle*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid stcPaddle element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _StcPaddle_getsetters[] = {
   {(char*)"class",
    (getter)_StcPaddle_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_StcPaddle_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_StcPaddle_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_StcPaddle_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_StcPaddle_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sector",
    (getter)_StcPaddle_getSector, (setter)_StcPaddle_setSector,
    (char*)"sector value",
    NULL},
   {(char*)"version",
    (getter)_StcPaddle_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_StcPaddle_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _StcPaddle_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _StcPaddle_methods[] = {
   {"addStcHits", _StcPaddle_addStcHits, METH_VARARGS,
    "extend (or insert into) the list of stcHit objects for this stcPaddle"},
   {"addStcTruthHits", _StcPaddle_addStcTruthHits, METH_VARARGS,
    "extend (or insert into) the list of stcTruthHit objects for this stcPaddle"},
   {"deleteStcHits", _StcPaddle_deleteStcHits, METH_VARARGS,
    "delete stcHit objects for this stcPaddle"},
   {"deleteStcTruthHits", _StcPaddle_deleteStcTruthHits, METH_VARARGS,
    "delete stcTruthHit objects for this stcPaddle"},
   {"getStcHit", _StcPaddle_getStcHit, METH_VARARGS,
    "get an individual stcHit object from this stcPaddle"},
   {"getStcHits", _StcPaddle_getStcHits, METH_NOARGS,
    "get list of stcHit objects for this stcPaddle"},
   {"getStcTruthHit", _StcPaddle_getStcTruthHit, METH_VARARGS,
    "get an individual stcTruthHit object from this stcPaddle"},
   {"getStcTruthHits", _StcPaddle_getStcTruthHits, METH_NOARGS,
    "get list of stcTruthHit objects for this stcPaddle"},
   {"toString", _StcPaddle_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _StcPaddle_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _StcPaddle_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.StcPaddle",         /*tp_name*/
    sizeof(_StcPaddle),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_StcPaddle_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_StcPaddle_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s stcPaddle element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _StcPaddle_methods,          /* tp_methods */
    _StcPaddle_members,          /* tp_members */
    _StcPaddle_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_StcPaddle_init,   /* tp_init */
    0,                         /* tp_alloc */
    _StcPaddle_new,              /* tp_new */
};



// wrap element class hddm_s::StcTruthPoint as hddm_s.StcTruthPoint

typedef struct {
   PyObject_HEAD
   StcTruthPoint *elem;
   PyObject *host;
} _StcTruthPoint;

static void
_StcTruthPoint_dealloc(_StcTruthPoint* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_StcTruthPoint_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _StcTruthPoint *self;
   self = (_StcTruthPoint*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_StcTruthPoint_init(_StcTruthPoint *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_StcTruthPoint_getClass(_StcTruthPoint *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StcTruthPoint_getVersion(_StcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_StcTruthPoint_getXmlns(_StcTruthPoint *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StcTruthPoint_getEventNo(_StcTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_StcTruthPoint_getRunNo(_StcTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_StcTruthPoint_getE(_StcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_StcTruthPoint_setE(_StcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_StcTruthPoint_getDEdx(_StcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDEdx());
}

static int
_StcTruthPoint_setDEdx(_StcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDEdx((float)var);
   return 0;
}

static PyObject*
_StcTruthPoint_getMaxOccurs(_StcTruthPoint *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StcTruthPoint_getMinOccurs(_StcTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_StcTruthPoint_getPhi(_StcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPhi());
}

static int
_StcTruthPoint_setPhi(_StcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPhi((float)var);
   return 0;
}

static PyObject*
_StcTruthPoint_getPrimary(_StcTruthPoint *self, void *closure)
{
   return PyBool_FromLong(self->elem->getPrimary());
}

static int
_StcTruthPoint_setPrimary(_StcTruthPoint *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPrimary((var==0)? false : true);
   return 0;
}

static PyObject*
_StcTruthPoint_getPtype(_StcTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPtype());
}

static int
_StcTruthPoint_setPtype(_StcTruthPoint *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPtype(var);
   return 0;
}

static PyObject*
_StcTruthPoint_getPx(_StcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPx());
}

static int
_StcTruthPoint_setPx(_StcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPx((float)var);
   return 0;
}

static PyObject*
_StcTruthPoint_getPy(_StcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPy());
}

static int
_StcTruthPoint_setPy(_StcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPy((float)var);
   return 0;
}

static PyObject*
_StcTruthPoint_getPz(_StcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPz());
}

static int
_StcTruthPoint_setPz(_StcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPz((float)var);
   return 0;
}

static PyObject*
_StcTruthPoint_getR(_StcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getR());
}

static int
_StcTruthPoint_setR(_StcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setR((float)var);
   return 0;
}

static PyObject*
_StcTruthPoint_getSector(_StcTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSector());
}

static int
_StcTruthPoint_setSector(_StcTruthPoint *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setSector(var);
   return 0;
}

static PyObject*
_StcTruthPoint_getT(_StcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_StcTruthPoint_setT(_StcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_StcTruthPoint_getTrack(_StcTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static int
_StcTruthPoint_setTrack(_StcTruthPoint *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTrack(var);
   return 0;
}

static PyObject*
_StcTruthPoint_getZ(_StcTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static int
_StcTruthPoint_setZ(_StcTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ((float)var);
   return 0;
}

static PyObject*
_StcTruthPoint_getTrackID(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _StcTruthPoint *me = (_StcTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid stcTruthPoint element");
      return NULL;
   }
   PyObject *obj = _TrackID_new(&_TrackID_type, 0, 0);
   ((_TrackID*)obj)->elem = &me->elem->getTrackID();
   ((_TrackID*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_StcTruthPoint_getTrackIDs(PyObject *self, PyObject *args)
{
   _StcTruthPoint *me = (_StcTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid stcTruthPoint element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackID_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTrackIDs();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_StcTruthPoint_addTrackIDs(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _StcTruthPoint *me = (_StcTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid stcTruthPoint element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackID_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TrackIDList(me->elem->addTrackIDs(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_StcTruthPoint_deleteTrackIDs(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _StcTruthPoint *me = (_StcTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid stcTruthPoint element");
      return NULL;
   }
   me->elem->deleteTrackIDs(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_StcTruthPoint_toString(PyObject *self, PyObject *args=0)
{
   _StcTruthPoint *me = (_StcTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid stcTruthPoint element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_StcTruthPoint_toXML(PyObject *self, PyObject *args=0)
{
   _StcTruthPoint *me = (_StcTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid stcTruthPoint element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _StcTruthPoint_getsetters[] = {
   {(char*)"E",
    (getter)_StcTruthPoint_getE, (setter)_StcTruthPoint_setE,
    (char*)"E value",
    NULL},
   {(char*)"class",
    (getter)_StcTruthPoint_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dEdx",
    (getter)_StcTruthPoint_getDEdx, (setter)_StcTruthPoint_setDEdx,
    (char*)"dEdx value",
    NULL},
   {(char*)"eventNo",
    (getter)_StcTruthPoint_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_StcTruthPoint_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_StcTruthPoint_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"phi",
    (getter)_StcTruthPoint_getPhi, (setter)_StcTruthPoint_setPhi,
    (char*)"phi value",
    NULL},
   {(char*)"primary",
    (getter)_StcTruthPoint_getPrimary, (setter)_StcTruthPoint_setPrimary,
    (char*)"primary value",
    NULL},
   {(char*)"ptype",
    (getter)_StcTruthPoint_getPtype, (setter)_StcTruthPoint_setPtype,
    (char*)"ptype value",
    NULL},
   {(char*)"px",
    (getter)_StcTruthPoint_getPx, (setter)_StcTruthPoint_setPx,
    (char*)"px value",
    NULL},
   {(char*)"py",
    (getter)_StcTruthPoint_getPy, (setter)_StcTruthPoint_setPy,
    (char*)"py value",
    NULL},
   {(char*)"pz",
    (getter)_StcTruthPoint_getPz, (setter)_StcTruthPoint_setPz,
    (char*)"pz value",
    NULL},
   {(char*)"r",
    (getter)_StcTruthPoint_getR, (setter)_StcTruthPoint_setR,
    (char*)"r value",
    NULL},
   {(char*)"runNo",
    (getter)_StcTruthPoint_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sector",
    (getter)_StcTruthPoint_getSector, (setter)_StcTruthPoint_setSector,
    (char*)"sector value",
    NULL},
   {(char*)"t",
    (getter)_StcTruthPoint_getT, (setter)_StcTruthPoint_setT,
    (char*)"t value",
    NULL},
   {(char*)"track",
    (getter)_StcTruthPoint_getTrack, (setter)_StcTruthPoint_setTrack,
    (char*)"track value",
    NULL},
   {(char*)"version",
    (getter)_StcTruthPoint_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_StcTruthPoint_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"z",
    (getter)_StcTruthPoint_getZ, (setter)_StcTruthPoint_setZ,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _StcTruthPoint_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _StcTruthPoint_methods[] = {
   {"addTrackIDs", _StcTruthPoint_addTrackIDs, METH_VARARGS,
    "extend (or insert into) the list of trackID objects for this stcTruthPoint"},
   {"deleteTrackIDs", _StcTruthPoint_deleteTrackIDs, METH_VARARGS,
    "delete trackID objects for this stcTruthPoint"},
   {"getTrackID", _StcTruthPoint_getTrackID, METH_VARARGS,
    "get an individual trackID object from this stcTruthPoint"},
   {"getTrackIDs", _StcTruthPoint_getTrackIDs, METH_NOARGS,
    "get list of trackID objects for this stcTruthPoint"},
   {"toString", _StcTruthPoint_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _StcTruthPoint_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _StcTruthPoint_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.StcTruthPoint",         /*tp_name*/
    sizeof(_StcTruthPoint),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_StcTruthPoint_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_StcTruthPoint_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s stcTruthPoint element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _StcTruthPoint_methods,          /* tp_methods */
    _StcTruthPoint_members,          /* tp_members */
    _StcTruthPoint_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_StcTruthPoint_init,   /* tp_init */
    0,                         /* tp_alloc */
    _StcTruthPoint_new,              /* tp_new */
};



// wrap element class hddm_s::StartCntr as hddm_s.StartCntr

typedef struct {
   PyObject_HEAD
   StartCntr *elem;
   PyObject *host;
} _StartCntr;

static void
_StartCntr_dealloc(_StartCntr* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_StartCntr_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _StartCntr *self;
   self = (_StartCntr*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_StartCntr_init(_StartCntr *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_StartCntr_getClass(_StartCntr *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StartCntr_getVersion(_StartCntr *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_StartCntr_getXmlns(_StartCntr *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StartCntr_getEventNo(_StartCntr *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_StartCntr_getMaxOccurs(_StartCntr *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_StartCntr_getRunNo(_StartCntr *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_StartCntr_getMinOccurs(_StartCntr *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_StartCntr_getStcPaddle(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _StartCntr *me = (_StartCntr*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid startCntr element");
      return NULL;
   }
   PyObject *obj = _StcPaddle_new(&_StcPaddle_type, 0, 0);
   ((_StcPaddle*)obj)->elem = &me->elem->getStcPaddle(index);
   ((_StcPaddle*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_StartCntr_getStcPaddles(PyObject *self, PyObject *args)
{
   _StartCntr *me = (_StartCntr*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid startCntr element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_StcPaddle_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getStcPaddles();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_StartCntr_addStcPaddles(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _StartCntr *me = (_StartCntr*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid startCntr element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_StcPaddle_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new StcPaddleList(me->elem->addStcPaddles(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_StartCntr_deleteStcPaddles(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _StartCntr *me = (_StartCntr*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid startCntr element");
      return NULL;
   }
   me->elem->deleteStcPaddles(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_StartCntr_getStcTruthPoint(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _StartCntr *me = (_StartCntr*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid startCntr element");
      return NULL;
   }
   PyObject *obj = _StcTruthPoint_new(&_StcTruthPoint_type, 0, 0);
   ((_StcTruthPoint*)obj)->elem = &me->elem->getStcTruthPoint(index);
   ((_StcTruthPoint*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_StartCntr_getStcTruthPoints(PyObject *self, PyObject *args)
{
   _StartCntr *me = (_StartCntr*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid startCntr element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_StcTruthPoint_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getStcTruthPoints();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_StartCntr_addStcTruthPoints(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _StartCntr *me = (_StartCntr*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid startCntr element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_StcTruthPoint_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new StcTruthPointList(me->elem->addStcTruthPoints(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_StartCntr_deleteStcTruthPoints(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _StartCntr *me = (_StartCntr*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid startCntr element");
      return NULL;
   }
   me->elem->deleteStcTruthPoints(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_StartCntr_toString(PyObject *self, PyObject *args=0)
{
   _StartCntr *me = (_StartCntr*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid startCntr element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_StartCntr_toXML(PyObject *self, PyObject *args=0)
{
   _StartCntr *me = (_StartCntr*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid startCntr element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _StartCntr_getsetters[] = {
   {(char*)"class",
    (getter)_StartCntr_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_StartCntr_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_StartCntr_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_StartCntr_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_StartCntr_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_StartCntr_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_StartCntr_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _StartCntr_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _StartCntr_methods[] = {
   {"addStcPaddles", _StartCntr_addStcPaddles, METH_VARARGS,
    "extend (or insert into) the list of stcPaddle objects for this startCntr"},
   {"addStcTruthPoints", _StartCntr_addStcTruthPoints, METH_VARARGS,
    "extend (or insert into) the list of stcTruthPoint objects for this startCntr"},
   {"deleteStcPaddles", _StartCntr_deleteStcPaddles, METH_VARARGS,
    "delete stcPaddle objects for this startCntr"},
   {"deleteStcTruthPoints", _StartCntr_deleteStcTruthPoints, METH_VARARGS,
    "delete stcTruthPoint objects for this startCntr"},
   {"getStcPaddle", _StartCntr_getStcPaddle, METH_VARARGS,
    "get an individual stcPaddle object from this startCntr"},
   {"getStcPaddles", _StartCntr_getStcPaddles, METH_NOARGS,
    "get list of stcPaddle objects for this startCntr"},
   {"getStcTruthPoint", _StartCntr_getStcTruthPoint, METH_VARARGS,
    "get an individual stcTruthPoint object from this startCntr"},
   {"getStcTruthPoints", _StartCntr_getStcTruthPoints, METH_NOARGS,
    "get list of stcTruthPoint objects for this startCntr"},
   {"toString", _StartCntr_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _StartCntr_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _StartCntr_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.StartCntr",         /*tp_name*/
    sizeof(_StartCntr),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_StartCntr_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_StartCntr_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s startCntr element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _StartCntr_methods,          /* tp_methods */
    _StartCntr_members,          /* tp_members */
    _StartCntr_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_StartCntr_init,   /* tp_init */
    0,                         /* tp_alloc */
    _StartCntr_new,              /* tp_new */
};



// wrap element class hddm_s::BcalSiPMUpHit as hddm_s.BcalSiPMUpHit

typedef struct {
   PyObject_HEAD
   BcalSiPMUpHit *elem;
   PyObject *host;
} _BcalSiPMUpHit;

static void
_BcalSiPMUpHit_dealloc(_BcalSiPMUpHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_BcalSiPMUpHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _BcalSiPMUpHit *self;
   self = (_BcalSiPMUpHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_BcalSiPMUpHit_init(_BcalSiPMUpHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_BcalSiPMUpHit_getClass(_BcalSiPMUpHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalSiPMUpHit_getVersion(_BcalSiPMUpHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_BcalSiPMUpHit_getXmlns(_BcalSiPMUpHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalSiPMUpHit_getEventNo(_BcalSiPMUpHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_BcalSiPMUpHit_getRunNo(_BcalSiPMUpHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_BcalSiPMUpHit_getLayer(_BcalSiPMUpHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static PyObject*
_BcalSiPMUpHit_getModule(_BcalSiPMUpHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static PyObject*
_BcalSiPMUpHit_getSector(_BcalSiPMUpHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSector());
}

static PyObject*
_BcalSiPMUpHit_getE(_BcalSiPMUpHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_BcalSiPMUpHit_setE(_BcalSiPMUpHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_BcalSiPMUpHit_getMaxOccurs(_BcalSiPMUpHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalSiPMUpHit_getMinOccurs(_BcalSiPMUpHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_BcalSiPMUpHit_getT(_BcalSiPMUpHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_BcalSiPMUpHit_setT(_BcalSiPMUpHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_BcalSiPMUpHit_toString(PyObject *self, PyObject *args=0)
{
   _BcalSiPMUpHit *me = (_BcalSiPMUpHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalSiPMUpHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_BcalSiPMUpHit_toXML(PyObject *self, PyObject *args=0)
{
   _BcalSiPMUpHit *me = (_BcalSiPMUpHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalSiPMUpHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _BcalSiPMUpHit_getsetters[] = {
   {(char*)"E",
    (getter)_BcalSiPMUpHit_getE, (setter)_BcalSiPMUpHit_setE,
    (char*)"E value",
    NULL},
   {(char*)"class",
    (getter)_BcalSiPMUpHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_BcalSiPMUpHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"layer",
    (getter)_BcalSiPMUpHit_getLayer, 0,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_BcalSiPMUpHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_BcalSiPMUpHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_BcalSiPMUpHit_getModule, 0,
    (char*)"module value",
    NULL},
   {(char*)"runNo",
    (getter)_BcalSiPMUpHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sector",
    (getter)_BcalSiPMUpHit_getSector, 0,
    (char*)"sector value",
    NULL},
   {(char*)"t",
    (getter)_BcalSiPMUpHit_getT, (setter)_BcalSiPMUpHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_BcalSiPMUpHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_BcalSiPMUpHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _BcalSiPMUpHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _BcalSiPMUpHit_methods[] = {
   {"toString", _BcalSiPMUpHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _BcalSiPMUpHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _BcalSiPMUpHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.BcalSiPMUpHit",         /*tp_name*/
    sizeof(_BcalSiPMUpHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_BcalSiPMUpHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_BcalSiPMUpHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s bcalSiPMUpHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _BcalSiPMUpHit_methods,          /* tp_methods */
    _BcalSiPMUpHit_members,          /* tp_members */
    _BcalSiPMUpHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_BcalSiPMUpHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _BcalSiPMUpHit_new,              /* tp_new */
};



// wrap element class hddm_s::BcalSiPMDownHit as hddm_s.BcalSiPMDownHit

typedef struct {
   PyObject_HEAD
   BcalSiPMDownHit *elem;
   PyObject *host;
} _BcalSiPMDownHit;

static void
_BcalSiPMDownHit_dealloc(_BcalSiPMDownHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_BcalSiPMDownHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _BcalSiPMDownHit *self;
   self = (_BcalSiPMDownHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_BcalSiPMDownHit_init(_BcalSiPMDownHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_BcalSiPMDownHit_getClass(_BcalSiPMDownHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalSiPMDownHit_getVersion(_BcalSiPMDownHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_BcalSiPMDownHit_getXmlns(_BcalSiPMDownHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalSiPMDownHit_getEventNo(_BcalSiPMDownHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_BcalSiPMDownHit_getRunNo(_BcalSiPMDownHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_BcalSiPMDownHit_getLayer(_BcalSiPMDownHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static PyObject*
_BcalSiPMDownHit_getModule(_BcalSiPMDownHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static PyObject*
_BcalSiPMDownHit_getSector(_BcalSiPMDownHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSector());
}

static PyObject*
_BcalSiPMDownHit_getE(_BcalSiPMDownHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_BcalSiPMDownHit_setE(_BcalSiPMDownHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_BcalSiPMDownHit_getMaxOccurs(_BcalSiPMDownHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalSiPMDownHit_getMinOccurs(_BcalSiPMDownHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_BcalSiPMDownHit_getT(_BcalSiPMDownHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_BcalSiPMDownHit_setT(_BcalSiPMDownHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_BcalSiPMDownHit_toString(PyObject *self, PyObject *args=0)
{
   _BcalSiPMDownHit *me = (_BcalSiPMDownHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalSiPMDownHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_BcalSiPMDownHit_toXML(PyObject *self, PyObject *args=0)
{
   _BcalSiPMDownHit *me = (_BcalSiPMDownHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalSiPMDownHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _BcalSiPMDownHit_getsetters[] = {
   {(char*)"E",
    (getter)_BcalSiPMDownHit_getE, (setter)_BcalSiPMDownHit_setE,
    (char*)"E value",
    NULL},
   {(char*)"class",
    (getter)_BcalSiPMDownHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_BcalSiPMDownHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"layer",
    (getter)_BcalSiPMDownHit_getLayer, 0,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_BcalSiPMDownHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_BcalSiPMDownHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_BcalSiPMDownHit_getModule, 0,
    (char*)"module value",
    NULL},
   {(char*)"runNo",
    (getter)_BcalSiPMDownHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sector",
    (getter)_BcalSiPMDownHit_getSector, 0,
    (char*)"sector value",
    NULL},
   {(char*)"t",
    (getter)_BcalSiPMDownHit_getT, (setter)_BcalSiPMDownHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_BcalSiPMDownHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_BcalSiPMDownHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _BcalSiPMDownHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _BcalSiPMDownHit_methods[] = {
   {"toString", _BcalSiPMDownHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _BcalSiPMDownHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _BcalSiPMDownHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.BcalSiPMDownHit",         /*tp_name*/
    sizeof(_BcalSiPMDownHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_BcalSiPMDownHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_BcalSiPMDownHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s bcalSiPMDownHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _BcalSiPMDownHit_methods,          /* tp_methods */
    _BcalSiPMDownHit_members,          /* tp_members */
    _BcalSiPMDownHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_BcalSiPMDownHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _BcalSiPMDownHit_new,              /* tp_new */
};



// wrap element class hddm_s::BcalSiPMTruth as hddm_s.BcalSiPMTruth

typedef struct {
   PyObject_HEAD
   BcalSiPMTruth *elem;
   PyObject *host;
} _BcalSiPMTruth;

static void
_BcalSiPMTruth_dealloc(_BcalSiPMTruth* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_BcalSiPMTruth_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _BcalSiPMTruth *self;
   self = (_BcalSiPMTruth*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_BcalSiPMTruth_init(_BcalSiPMTruth *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_BcalSiPMTruth_getClass(_BcalSiPMTruth *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalSiPMTruth_getVersion(_BcalSiPMTruth *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_BcalSiPMTruth_getXmlns(_BcalSiPMTruth *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalSiPMTruth_getEventNo(_BcalSiPMTruth *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_BcalSiPMTruth_getMaxOccurs(_BcalSiPMTruth *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalSiPMTruth_getRunNo(_BcalSiPMTruth *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_BcalSiPMTruth_getLayer(_BcalSiPMTruth *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static PyObject*
_BcalSiPMTruth_getModule(_BcalSiPMTruth *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static PyObject*
_BcalSiPMTruth_getSector(_BcalSiPMTruth *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSector());
}

static PyObject*
_BcalSiPMTruth_getBin_width(_BcalSiPMTruth *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getBin_width());
}

static PyObject*
_BcalSiPMTruth_getEnd(_BcalSiPMTruth *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEnd());
}

static PyObject*
_BcalSiPMTruth_getTstart(_BcalSiPMTruth *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTstart());
}

static PyObject*
_BcalSiPMTruth_getVals(_BcalSiPMTruth *self, void *closure)
{
   std::string val(self->elem->getVals());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalSiPMTruth_getE(_BcalSiPMTruth *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_BcalSiPMTruth_setE(_BcalSiPMTruth *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_BcalSiPMTruth_getIncident_id(_BcalSiPMTruth *self, void *closure)
{
   return PyLong_FromLong(self->elem->getIncident_id());
}

static int
_BcalSiPMTruth_setIncident_id(_BcalSiPMTruth *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setIncident_id(var);
   return 0;
}

static PyObject*
_BcalSiPMTruth_getMinOccurs(_BcalSiPMTruth *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_BcalSiPMTruth_toString(PyObject *self, PyObject *args=0)
{
   _BcalSiPMTruth *me = (_BcalSiPMTruth*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalSiPMTruth element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_BcalSiPMTruth_toXML(PyObject *self, PyObject *args=0)
{
   _BcalSiPMTruth *me = (_BcalSiPMTruth*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalSiPMTruth element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _BcalSiPMTruth_getsetters[] = {
   {(char*)"E",
    (getter)_BcalSiPMTruth_getE, (setter)_BcalSiPMTruth_setE,
    (char*)"E value",
    NULL},
   {(char*)"bin_width",
    (getter)_BcalSiPMTruth_getBin_width, 0,
    (char*)"bin_width value",
    NULL},
   {(char*)"class",
    (getter)_BcalSiPMTruth_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"end",
    (getter)_BcalSiPMTruth_getEnd, 0,
    (char*)"end value",
    NULL},
   {(char*)"eventNo",
    (getter)_BcalSiPMTruth_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"incident_id",
    (getter)_BcalSiPMTruth_getIncident_id, (setter)_BcalSiPMTruth_setIncident_id,
    (char*)"incident_id value",
    NULL},
   {(char*)"layer",
    (getter)_BcalSiPMTruth_getLayer, 0,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_BcalSiPMTruth_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_BcalSiPMTruth_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_BcalSiPMTruth_getModule, 0,
    (char*)"module value",
    NULL},
   {(char*)"runNo",
    (getter)_BcalSiPMTruth_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sector",
    (getter)_BcalSiPMTruth_getSector, 0,
    (char*)"sector value",
    NULL},
   {(char*)"tstart",
    (getter)_BcalSiPMTruth_getTstart, 0,
    (char*)"tstart value",
    NULL},
   {(char*)"vals",
    (getter)_BcalSiPMTruth_getVals, 0,
    (char*)"vals string",
    NULL},
   {(char*)"version",
    (getter)_BcalSiPMTruth_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_BcalSiPMTruth_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _BcalSiPMTruth_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _BcalSiPMTruth_methods[] = {
   {"toString", _BcalSiPMTruth_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _BcalSiPMTruth_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _BcalSiPMTruth_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.BcalSiPMTruth",         /*tp_name*/
    sizeof(_BcalSiPMTruth),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_BcalSiPMTruth_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_BcalSiPMTruth_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s bcalSiPMTruth element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _BcalSiPMTruth_methods,          /* tp_methods */
    _BcalSiPMTruth_members,          /* tp_members */
    _BcalSiPMTruth_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_BcalSiPMTruth_init,   /* tp_init */
    0,                         /* tp_alloc */
    _BcalSiPMTruth_new,              /* tp_new */
};



// wrap element class hddm_s::BcalSiPMSpectrum as hddm_s.BcalSiPMSpectrum

typedef struct {
   PyObject_HEAD
   BcalSiPMSpectrum *elem;
   PyObject *host;
} _BcalSiPMSpectrum;

static void
_BcalSiPMSpectrum_dealloc(_BcalSiPMSpectrum* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_BcalSiPMSpectrum_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _BcalSiPMSpectrum *self;
   self = (_BcalSiPMSpectrum*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_BcalSiPMSpectrum_init(_BcalSiPMSpectrum *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_BcalSiPMSpectrum_getClass(_BcalSiPMSpectrum *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalSiPMSpectrum_getVersion(_BcalSiPMSpectrum *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_BcalSiPMSpectrum_getXmlns(_BcalSiPMSpectrum *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalSiPMSpectrum_getEventNo(_BcalSiPMSpectrum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_BcalSiPMSpectrum_getRunNo(_BcalSiPMSpectrum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_BcalSiPMSpectrum_getLayer(_BcalSiPMSpectrum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static PyObject*
_BcalSiPMSpectrum_getModule(_BcalSiPMSpectrum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static PyObject*
_BcalSiPMSpectrum_getSector(_BcalSiPMSpectrum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSector());
}

static PyObject*
_BcalSiPMSpectrum_getBin_width(_BcalSiPMSpectrum *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getBin_width());
}

static int
_BcalSiPMSpectrum_setBin_width(_BcalSiPMSpectrum *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setBin_width((float)var);
   return 0;
}

static PyObject*
_BcalSiPMSpectrum_getEnd(_BcalSiPMSpectrum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEnd());
}

static int
_BcalSiPMSpectrum_setEnd(_BcalSiPMSpectrum *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setEnd(var);
   return 0;
}

static PyObject*
_BcalSiPMSpectrum_getMaxOccurs(_BcalSiPMSpectrum *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalSiPMSpectrum_getMinOccurs(_BcalSiPMSpectrum *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_BcalSiPMSpectrum_getTstart(_BcalSiPMSpectrum *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTstart());
}

static int
_BcalSiPMSpectrum_setTstart(_BcalSiPMSpectrum *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTstart((float)var);
   return 0;
}

static PyObject*
_BcalSiPMSpectrum_getVals(_BcalSiPMSpectrum *self, void *closure)
{
   std::string val(self->elem->getVals());
   return PyUnicode_FromString(val.c_str());
}

static int
_BcalSiPMSpectrum_setVals(_BcalSiPMSpectrum *self, PyObject *value, void *closure)
{
   PyObject *str=0;
   if (PyUnicode_Check(value))
      str = PyUnicode_AsEncodedString(value, "ASCII", "strict");
   else
      str = value;
#if PY_MAJOR_VERSION < 3
   char *var = PyString_AsString(str);
#else
   char *var = PyBytes_AsString(str);
#endif
   if (var == 0) {
      return -1;
   }
   self->elem->setVals(std::string(var));
   if (str != value) {
      Py_DECREF(str);
   }
   return 0;
}

static PyObject*
_BcalSiPMSpectrum_getBcalSiPMTruth(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _BcalSiPMSpectrum *me = (_BcalSiPMSpectrum*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalSiPMSpectrum element");
      return NULL;
   }
   PyObject *obj = _BcalSiPMTruth_new(&_BcalSiPMTruth_type, 0, 0);
   ((_BcalSiPMTruth*)obj)->elem = &me->elem->getBcalSiPMTruth();
   ((_BcalSiPMTruth*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_BcalSiPMSpectrum_getBcalSiPMTruths(PyObject *self, PyObject *args)
{
   _BcalSiPMSpectrum *me = (_BcalSiPMSpectrum*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalSiPMSpectrum element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalSiPMTruth_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getBcalSiPMTruths();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_BcalSiPMSpectrum_addBcalSiPMTruths(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalSiPMSpectrum *me = (_BcalSiPMSpectrum*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid bcalSiPMSpectrum element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalSiPMTruth_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalSiPMTruthList(me->elem->addBcalSiPMTruths(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_BcalSiPMSpectrum_deleteBcalSiPMTruths(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalSiPMSpectrum *me = (_BcalSiPMSpectrum*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid bcalSiPMSpectrum element");
      return NULL;
   }
   me->elem->deleteBcalSiPMTruths(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_BcalSiPMSpectrum_toString(PyObject *self, PyObject *args=0)
{
   _BcalSiPMSpectrum *me = (_BcalSiPMSpectrum*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalSiPMSpectrum element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_BcalSiPMSpectrum_toXML(PyObject *self, PyObject *args=0)
{
   _BcalSiPMSpectrum *me = (_BcalSiPMSpectrum*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalSiPMSpectrum element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _BcalSiPMSpectrum_getsetters[] = {
   {(char*)"bin_width",
    (getter)_BcalSiPMSpectrum_getBin_width, (setter)_BcalSiPMSpectrum_setBin_width,
    (char*)"bin_width value",
    NULL},
   {(char*)"class",
    (getter)_BcalSiPMSpectrum_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"end",
    (getter)_BcalSiPMSpectrum_getEnd, (setter)_BcalSiPMSpectrum_setEnd,
    (char*)"end value",
    NULL},
   {(char*)"eventNo",
    (getter)_BcalSiPMSpectrum_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"layer",
    (getter)_BcalSiPMSpectrum_getLayer, 0,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_BcalSiPMSpectrum_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_BcalSiPMSpectrum_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_BcalSiPMSpectrum_getModule, 0,
    (char*)"module value",
    NULL},
   {(char*)"runNo",
    (getter)_BcalSiPMSpectrum_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sector",
    (getter)_BcalSiPMSpectrum_getSector, 0,
    (char*)"sector value",
    NULL},
   {(char*)"tstart",
    (getter)_BcalSiPMSpectrum_getTstart, (setter)_BcalSiPMSpectrum_setTstart,
    (char*)"tstart value",
    NULL},
   {(char*)"vals",
    (getter)_BcalSiPMSpectrum_getVals, (setter)_BcalSiPMSpectrum_setVals,
    (char*)"vals string",
    NULL},
   {(char*)"version",
    (getter)_BcalSiPMSpectrum_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_BcalSiPMSpectrum_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _BcalSiPMSpectrum_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _BcalSiPMSpectrum_methods[] = {
   {"addBcalSiPMTruths", _BcalSiPMSpectrum_addBcalSiPMTruths, METH_VARARGS,
    "extend (or insert into) the list of bcalSiPMTruth objects for this bcalSiPMSpectrum"},
   {"deleteBcalSiPMTruths", _BcalSiPMSpectrum_deleteBcalSiPMTruths, METH_VARARGS,
    "delete bcalSiPMTruth objects for this bcalSiPMSpectrum"},
   {"getBcalSiPMTruth", _BcalSiPMSpectrum_getBcalSiPMTruth, METH_VARARGS,
    "get an individual bcalSiPMTruth object from this bcalSiPMSpectrum"},
   {"getBcalSiPMTruths", _BcalSiPMSpectrum_getBcalSiPMTruths, METH_NOARGS,
    "get list of bcalSiPMTruth objects for this bcalSiPMSpectrum"},
   {"toString", _BcalSiPMSpectrum_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _BcalSiPMSpectrum_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _BcalSiPMSpectrum_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.BcalSiPMSpectrum",         /*tp_name*/
    sizeof(_BcalSiPMSpectrum),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_BcalSiPMSpectrum_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_BcalSiPMSpectrum_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s bcalSiPMSpectrum element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _BcalSiPMSpectrum_methods,          /* tp_methods */
    _BcalSiPMSpectrum_members,          /* tp_members */
    _BcalSiPMSpectrum_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_BcalSiPMSpectrum_init,   /* tp_init */
    0,                         /* tp_alloc */
    _BcalSiPMSpectrum_new,              /* tp_new */
};



// wrap element class hddm_s::BcalfADCHit as hddm_s.BcalfADCHit

typedef struct {
   PyObject_HEAD
   BcalfADCHit *elem;
   PyObject *host;
} _BcalfADCHit;

static void
_BcalfADCHit_dealloc(_BcalfADCHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_BcalfADCHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _BcalfADCHit *self;
   self = (_BcalfADCHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_BcalfADCHit_init(_BcalfADCHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_BcalfADCHit_getClass(_BcalfADCHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalfADCHit_getVersion(_BcalfADCHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_BcalfADCHit_getXmlns(_BcalfADCHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalfADCHit_getEventNo(_BcalfADCHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_BcalfADCHit_getRunNo(_BcalfADCHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_BcalfADCHit_getLayer(_BcalfADCHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static PyObject*
_BcalfADCHit_getModule(_BcalfADCHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static PyObject*
_BcalfADCHit_getSector(_BcalfADCHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSector());
}

static PyObject*
_BcalfADCHit_getE(_BcalfADCHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_BcalfADCHit_setE(_BcalfADCHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_BcalfADCHit_getEnd(_BcalfADCHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEnd());
}

static int
_BcalfADCHit_setEnd(_BcalfADCHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setEnd(var);
   return 0;
}

static PyObject*
_BcalfADCHit_getMaxOccurs(_BcalfADCHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalfADCHit_getMinOccurs(_BcalfADCHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_BcalfADCHit_getT(_BcalfADCHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_BcalfADCHit_setT(_BcalfADCHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_BcalfADCHit_toString(PyObject *self, PyObject *args=0)
{
   _BcalfADCHit *me = (_BcalfADCHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalfADCHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_BcalfADCHit_toXML(PyObject *self, PyObject *args=0)
{
   _BcalfADCHit *me = (_BcalfADCHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalfADCHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _BcalfADCHit_getsetters[] = {
   {(char*)"E",
    (getter)_BcalfADCHit_getE, (setter)_BcalfADCHit_setE,
    (char*)"E value",
    NULL},
   {(char*)"class",
    (getter)_BcalfADCHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"end",
    (getter)_BcalfADCHit_getEnd, (setter)_BcalfADCHit_setEnd,
    (char*)"end value",
    NULL},
   {(char*)"eventNo",
    (getter)_BcalfADCHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"layer",
    (getter)_BcalfADCHit_getLayer, 0,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_BcalfADCHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_BcalfADCHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_BcalfADCHit_getModule, 0,
    (char*)"module value",
    NULL},
   {(char*)"runNo",
    (getter)_BcalfADCHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sector",
    (getter)_BcalfADCHit_getSector, 0,
    (char*)"sector value",
    NULL},
   {(char*)"t",
    (getter)_BcalfADCHit_getT, (setter)_BcalfADCHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_BcalfADCHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_BcalfADCHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _BcalfADCHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _BcalfADCHit_methods[] = {
   {"toString", _BcalfADCHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _BcalfADCHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _BcalfADCHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.BcalfADCHit",         /*tp_name*/
    sizeof(_BcalfADCHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_BcalfADCHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_BcalfADCHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s bcalfADCHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _BcalfADCHit_methods,          /* tp_methods */
    _BcalfADCHit_members,          /* tp_members */
    _BcalfADCHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_BcalfADCHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _BcalfADCHit_new,              /* tp_new */
};



// wrap element class hddm_s::BcalfADCPeak as hddm_s.BcalfADCPeak

typedef struct {
   PyObject_HEAD
   BcalfADCPeak *elem;
   PyObject *host;
} _BcalfADCPeak;

static void
_BcalfADCPeak_dealloc(_BcalfADCPeak* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_BcalfADCPeak_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _BcalfADCPeak *self;
   self = (_BcalfADCPeak*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_BcalfADCPeak_init(_BcalfADCPeak *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_BcalfADCPeak_getClass(_BcalfADCPeak *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalfADCPeak_getVersion(_BcalfADCPeak *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_BcalfADCPeak_getXmlns(_BcalfADCPeak *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalfADCPeak_getEventNo(_BcalfADCPeak *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_BcalfADCPeak_getMaxOccurs(_BcalfADCPeak *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalfADCPeak_getRunNo(_BcalfADCPeak *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_BcalfADCPeak_getLayer(_BcalfADCPeak *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static PyObject*
_BcalfADCPeak_getModule(_BcalfADCPeak *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static PyObject*
_BcalfADCPeak_getSector(_BcalfADCPeak *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSector());
}

static PyObject*
_BcalfADCPeak_getEnd(_BcalfADCPeak *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEnd());
}

static PyObject*
_BcalfADCPeak_getPulse_integral(_BcalfADCPeak *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPulse_integral());
}

static PyObject*
_BcalfADCPeak_getPulse_time(_BcalfADCPeak *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPulse_time());
}

static PyObject*
_BcalfADCPeak_getMinOccurs(_BcalfADCPeak *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_BcalfADCPeak_getPeakAmp(_BcalfADCPeak *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPeakAmp());
}

static int
_BcalfADCPeak_setPeakAmp(_BcalfADCPeak *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPeakAmp((float)var);
   return 0;
}

static PyObject*
_BcalfADCPeak_toString(PyObject *self, PyObject *args=0)
{
   _BcalfADCPeak *me = (_BcalfADCPeak*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalfADCPeak element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_BcalfADCPeak_toXML(PyObject *self, PyObject *args=0)
{
   _BcalfADCPeak *me = (_BcalfADCPeak*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalfADCPeak element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _BcalfADCPeak_getsetters[] = {
   {(char*)"class",
    (getter)_BcalfADCPeak_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"end",
    (getter)_BcalfADCPeak_getEnd, 0,
    (char*)"end value",
    NULL},
   {(char*)"eventNo",
    (getter)_BcalfADCPeak_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"layer",
    (getter)_BcalfADCPeak_getLayer, 0,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_BcalfADCPeak_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_BcalfADCPeak_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_BcalfADCPeak_getModule, 0,
    (char*)"module value",
    NULL},
   {(char*)"peakAmp",
    (getter)_BcalfADCPeak_getPeakAmp, (setter)_BcalfADCPeak_setPeakAmp,
    (char*)"peakAmp value",
    NULL},
   {(char*)"pulse_integral",
    (getter)_BcalfADCPeak_getPulse_integral, 0,
    (char*)"pulse_integral value",
    NULL},
   {(char*)"pulse_time",
    (getter)_BcalfADCPeak_getPulse_time, 0,
    (char*)"pulse_time value",
    NULL},
   {(char*)"runNo",
    (getter)_BcalfADCPeak_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sector",
    (getter)_BcalfADCPeak_getSector, 0,
    (char*)"sector value",
    NULL},
   {(char*)"version",
    (getter)_BcalfADCPeak_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_BcalfADCPeak_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _BcalfADCPeak_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _BcalfADCPeak_methods[] = {
   {"toString", _BcalfADCPeak_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _BcalfADCPeak_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _BcalfADCPeak_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.BcalfADCPeak",         /*tp_name*/
    sizeof(_BcalfADCPeak),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_BcalfADCPeak_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_BcalfADCPeak_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s bcalfADCPeak element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _BcalfADCPeak_methods,          /* tp_methods */
    _BcalfADCPeak_members,          /* tp_members */
    _BcalfADCPeak_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_BcalfADCPeak_init,   /* tp_init */
    0,                         /* tp_alloc */
    _BcalfADCPeak_new,              /* tp_new */
};



// wrap element class hddm_s::BcalfADCDigiHit as hddm_s.BcalfADCDigiHit

typedef struct {
   PyObject_HEAD
   BcalfADCDigiHit *elem;
   PyObject *host;
} _BcalfADCDigiHit;

static void
_BcalfADCDigiHit_dealloc(_BcalfADCDigiHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_BcalfADCDigiHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _BcalfADCDigiHit *self;
   self = (_BcalfADCDigiHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_BcalfADCDigiHit_init(_BcalfADCDigiHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_BcalfADCDigiHit_getClass(_BcalfADCDigiHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalfADCDigiHit_getVersion(_BcalfADCDigiHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_BcalfADCDigiHit_getXmlns(_BcalfADCDigiHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalfADCDigiHit_getEventNo(_BcalfADCDigiHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_BcalfADCDigiHit_getRunNo(_BcalfADCDigiHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_BcalfADCDigiHit_getLayer(_BcalfADCDigiHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static PyObject*
_BcalfADCDigiHit_getModule(_BcalfADCDigiHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static PyObject*
_BcalfADCDigiHit_getSector(_BcalfADCDigiHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSector());
}

static PyObject*
_BcalfADCDigiHit_getEnd(_BcalfADCDigiHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEnd());
}

static int
_BcalfADCDigiHit_setEnd(_BcalfADCDigiHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setEnd(var);
   return 0;
}

static PyObject*
_BcalfADCDigiHit_getMaxOccurs(_BcalfADCDigiHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalfADCDigiHit_getMinOccurs(_BcalfADCDigiHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_BcalfADCDigiHit_getPulse_integral(_BcalfADCDigiHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPulse_integral());
}

static int
_BcalfADCDigiHit_setPulse_integral(_BcalfADCDigiHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPulse_integral(var);
   return 0;
}

static PyObject*
_BcalfADCDigiHit_getPulse_time(_BcalfADCDigiHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPulse_time());
}

static int
_BcalfADCDigiHit_setPulse_time(_BcalfADCDigiHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPulse_time(var);
   return 0;
}

static PyObject*
_BcalfADCDigiHit_getBcalfADCPeak(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _BcalfADCDigiHit *me = (_BcalfADCDigiHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalfADCDigiHit element");
      return NULL;
   }
   PyObject *obj = _BcalfADCPeak_new(&_BcalfADCPeak_type, 0, 0);
   ((_BcalfADCPeak*)obj)->elem = &me->elem->getBcalfADCPeak();
   ((_BcalfADCPeak*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_BcalfADCDigiHit_getBcalfADCPeaks(PyObject *self, PyObject *args)
{
   _BcalfADCDigiHit *me = (_BcalfADCDigiHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalfADCDigiHit element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalfADCPeak_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getBcalfADCPeaks();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_BcalfADCDigiHit_addBcalfADCPeaks(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalfADCDigiHit *me = (_BcalfADCDigiHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid bcalfADCDigiHit element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalfADCPeak_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalfADCPeakList(me->elem->addBcalfADCPeaks(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_BcalfADCDigiHit_deleteBcalfADCPeaks(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalfADCDigiHit *me = (_BcalfADCDigiHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid bcalfADCDigiHit element");
      return NULL;
   }
   me->elem->deleteBcalfADCPeaks(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_BcalfADCDigiHit_toString(PyObject *self, PyObject *args=0)
{
   _BcalfADCDigiHit *me = (_BcalfADCDigiHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalfADCDigiHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_BcalfADCDigiHit_toXML(PyObject *self, PyObject *args=0)
{
   _BcalfADCDigiHit *me = (_BcalfADCDigiHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalfADCDigiHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _BcalfADCDigiHit_getsetters[] = {
   {(char*)"class",
    (getter)_BcalfADCDigiHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"end",
    (getter)_BcalfADCDigiHit_getEnd, (setter)_BcalfADCDigiHit_setEnd,
    (char*)"end value",
    NULL},
   {(char*)"eventNo",
    (getter)_BcalfADCDigiHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"layer",
    (getter)_BcalfADCDigiHit_getLayer, 0,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_BcalfADCDigiHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_BcalfADCDigiHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_BcalfADCDigiHit_getModule, 0,
    (char*)"module value",
    NULL},
   {(char*)"pulse_integral",
    (getter)_BcalfADCDigiHit_getPulse_integral, (setter)_BcalfADCDigiHit_setPulse_integral,
    (char*)"pulse_integral value",
    NULL},
   {(char*)"pulse_time",
    (getter)_BcalfADCDigiHit_getPulse_time, (setter)_BcalfADCDigiHit_setPulse_time,
    (char*)"pulse_time value",
    NULL},
   {(char*)"runNo",
    (getter)_BcalfADCDigiHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sector",
    (getter)_BcalfADCDigiHit_getSector, 0,
    (char*)"sector value",
    NULL},
   {(char*)"version",
    (getter)_BcalfADCDigiHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_BcalfADCDigiHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _BcalfADCDigiHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _BcalfADCDigiHit_methods[] = {
   {"addBcalfADCPeaks", _BcalfADCDigiHit_addBcalfADCPeaks, METH_VARARGS,
    "extend (or insert into) the list of bcalfADCPeak objects for this bcalfADCDigiHit"},
   {"deleteBcalfADCPeaks", _BcalfADCDigiHit_deleteBcalfADCPeaks, METH_VARARGS,
    "delete bcalfADCPeak objects for this bcalfADCDigiHit"},
   {"getBcalfADCPeak", _BcalfADCDigiHit_getBcalfADCPeak, METH_VARARGS,
    "get an individual bcalfADCPeak object from this bcalfADCDigiHit"},
   {"getBcalfADCPeaks", _BcalfADCDigiHit_getBcalfADCPeaks, METH_NOARGS,
    "get list of bcalfADCPeak objects for this bcalfADCDigiHit"},
   {"toString", _BcalfADCDigiHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _BcalfADCDigiHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _BcalfADCDigiHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.BcalfADCDigiHit",         /*tp_name*/
    sizeof(_BcalfADCDigiHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_BcalfADCDigiHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_BcalfADCDigiHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s bcalfADCDigiHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _BcalfADCDigiHit_methods,          /* tp_methods */
    _BcalfADCDigiHit_members,          /* tp_members */
    _BcalfADCDigiHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_BcalfADCDigiHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _BcalfADCDigiHit_new,              /* tp_new */
};



// wrap element class hddm_s::BcalTDCHit as hddm_s.BcalTDCHit

typedef struct {
   PyObject_HEAD
   BcalTDCHit *elem;
   PyObject *host;
} _BcalTDCHit;

static void
_BcalTDCHit_dealloc(_BcalTDCHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_BcalTDCHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _BcalTDCHit *self;
   self = (_BcalTDCHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_BcalTDCHit_init(_BcalTDCHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_BcalTDCHit_getClass(_BcalTDCHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalTDCHit_getVersion(_BcalTDCHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_BcalTDCHit_getXmlns(_BcalTDCHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalTDCHit_getEventNo(_BcalTDCHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_BcalTDCHit_getRunNo(_BcalTDCHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_BcalTDCHit_getLayer(_BcalTDCHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static PyObject*
_BcalTDCHit_getModule(_BcalTDCHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static PyObject*
_BcalTDCHit_getSector(_BcalTDCHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSector());
}

static PyObject*
_BcalTDCHit_getEnd(_BcalTDCHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEnd());
}

static int
_BcalTDCHit_setEnd(_BcalTDCHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setEnd(var);
   return 0;
}

static PyObject*
_BcalTDCHit_getMaxOccurs(_BcalTDCHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalTDCHit_getMinOccurs(_BcalTDCHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_BcalTDCHit_getT(_BcalTDCHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_BcalTDCHit_setT(_BcalTDCHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_BcalTDCHit_toString(PyObject *self, PyObject *args=0)
{
   _BcalTDCHit *me = (_BcalTDCHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalTDCHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_BcalTDCHit_toXML(PyObject *self, PyObject *args=0)
{
   _BcalTDCHit *me = (_BcalTDCHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalTDCHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _BcalTDCHit_getsetters[] = {
   {(char*)"class",
    (getter)_BcalTDCHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"end",
    (getter)_BcalTDCHit_getEnd, (setter)_BcalTDCHit_setEnd,
    (char*)"end value",
    NULL},
   {(char*)"eventNo",
    (getter)_BcalTDCHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"layer",
    (getter)_BcalTDCHit_getLayer, 0,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_BcalTDCHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_BcalTDCHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_BcalTDCHit_getModule, 0,
    (char*)"module value",
    NULL},
   {(char*)"runNo",
    (getter)_BcalTDCHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sector",
    (getter)_BcalTDCHit_getSector, 0,
    (char*)"sector value",
    NULL},
   {(char*)"t",
    (getter)_BcalTDCHit_getT, (setter)_BcalTDCHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_BcalTDCHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_BcalTDCHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _BcalTDCHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _BcalTDCHit_methods[] = {
   {"toString", _BcalTDCHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _BcalTDCHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _BcalTDCHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.BcalTDCHit",         /*tp_name*/
    sizeof(_BcalTDCHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_BcalTDCHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_BcalTDCHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s bcalTDCHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _BcalTDCHit_methods,          /* tp_methods */
    _BcalTDCHit_members,          /* tp_members */
    _BcalTDCHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_BcalTDCHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _BcalTDCHit_new,              /* tp_new */
};



// wrap element class hddm_s::BcalTDCDigiHit as hddm_s.BcalTDCDigiHit

typedef struct {
   PyObject_HEAD
   BcalTDCDigiHit *elem;
   PyObject *host;
} _BcalTDCDigiHit;

static void
_BcalTDCDigiHit_dealloc(_BcalTDCDigiHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_BcalTDCDigiHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _BcalTDCDigiHit *self;
   self = (_BcalTDCDigiHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_BcalTDCDigiHit_init(_BcalTDCDigiHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_BcalTDCDigiHit_getClass(_BcalTDCDigiHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalTDCDigiHit_getVersion(_BcalTDCDigiHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_BcalTDCDigiHit_getXmlns(_BcalTDCDigiHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalTDCDigiHit_getEventNo(_BcalTDCDigiHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_BcalTDCDigiHit_getRunNo(_BcalTDCDigiHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_BcalTDCDigiHit_getLayer(_BcalTDCDigiHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static PyObject*
_BcalTDCDigiHit_getModule(_BcalTDCDigiHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static PyObject*
_BcalTDCDigiHit_getSector(_BcalTDCDigiHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSector());
}

static PyObject*
_BcalTDCDigiHit_getEnd(_BcalTDCDigiHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEnd());
}

static int
_BcalTDCDigiHit_setEnd(_BcalTDCDigiHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setEnd(var);
   return 0;
}

static PyObject*
_BcalTDCDigiHit_getMaxOccurs(_BcalTDCDigiHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalTDCDigiHit_getMinOccurs(_BcalTDCDigiHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_BcalTDCDigiHit_getTime(_BcalTDCDigiHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getTime());
}

static int
_BcalTDCDigiHit_setTime(_BcalTDCDigiHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setTime((float)var);
   return 0;
}

static PyObject*
_BcalTDCDigiHit_toString(PyObject *self, PyObject *args=0)
{
   _BcalTDCDigiHit *me = (_BcalTDCDigiHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalTDCDigiHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_BcalTDCDigiHit_toXML(PyObject *self, PyObject *args=0)
{
   _BcalTDCDigiHit *me = (_BcalTDCDigiHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalTDCDigiHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _BcalTDCDigiHit_getsetters[] = {
   {(char*)"class",
    (getter)_BcalTDCDigiHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"end",
    (getter)_BcalTDCDigiHit_getEnd, (setter)_BcalTDCDigiHit_setEnd,
    (char*)"end value",
    NULL},
   {(char*)"eventNo",
    (getter)_BcalTDCDigiHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"layer",
    (getter)_BcalTDCDigiHit_getLayer, 0,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_BcalTDCDigiHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_BcalTDCDigiHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_BcalTDCDigiHit_getModule, 0,
    (char*)"module value",
    NULL},
   {(char*)"runNo",
    (getter)_BcalTDCDigiHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sector",
    (getter)_BcalTDCDigiHit_getSector, 0,
    (char*)"sector value",
    NULL},
   {(char*)"time",
    (getter)_BcalTDCDigiHit_getTime, (setter)_BcalTDCDigiHit_setTime,
    (char*)"time value",
    NULL},
   {(char*)"version",
    (getter)_BcalTDCDigiHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_BcalTDCDigiHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _BcalTDCDigiHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _BcalTDCDigiHit_methods[] = {
   {"toString", _BcalTDCDigiHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _BcalTDCDigiHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _BcalTDCDigiHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.BcalTDCDigiHit",         /*tp_name*/
    sizeof(_BcalTDCDigiHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_BcalTDCDigiHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_BcalTDCDigiHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s bcalTDCDigiHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _BcalTDCDigiHit_methods,          /* tp_methods */
    _BcalTDCDigiHit_members,          /* tp_members */
    _BcalTDCDigiHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_BcalTDCDigiHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _BcalTDCDigiHit_new,              /* tp_new */
};



// wrap element class hddm_s::BcalTruthHit as hddm_s.BcalTruthHit

typedef struct {
   PyObject_HEAD
   BcalTruthHit *elem;
   PyObject *host;
} _BcalTruthHit;

static void
_BcalTruthHit_dealloc(_BcalTruthHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_BcalTruthHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _BcalTruthHit *self;
   self = (_BcalTruthHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_BcalTruthHit_init(_BcalTruthHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_BcalTruthHit_getClass(_BcalTruthHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalTruthHit_getVersion(_BcalTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_BcalTruthHit_getXmlns(_BcalTruthHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalTruthHit_getEventNo(_BcalTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_BcalTruthHit_getRunNo(_BcalTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_BcalTruthHit_getLayer(_BcalTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static PyObject*
_BcalTruthHit_getModule(_BcalTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static PyObject*
_BcalTruthHit_getSector(_BcalTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSector());
}

static PyObject*
_BcalTruthHit_getE(_BcalTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_BcalTruthHit_setE(_BcalTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_BcalTruthHit_getIncident_id(_BcalTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getIncident_id());
}

static int
_BcalTruthHit_setIncident_id(_BcalTruthHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setIncident_id(var);
   return 0;
}

static PyObject*
_BcalTruthHit_getMaxOccurs(_BcalTruthHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalTruthHit_getMinOccurs(_BcalTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_BcalTruthHit_getT(_BcalTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_BcalTruthHit_setT(_BcalTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_BcalTruthHit_getZLocal(_BcalTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZLocal());
}

static int
_BcalTruthHit_setZLocal(_BcalTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZLocal((float)var);
   return 0;
}

static PyObject*
_BcalTruthHit_toString(PyObject *self, PyObject *args=0)
{
   _BcalTruthHit *me = (_BcalTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_BcalTruthHit_toXML(PyObject *self, PyObject *args=0)
{
   _BcalTruthHit *me = (_BcalTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _BcalTruthHit_getsetters[] = {
   {(char*)"E",
    (getter)_BcalTruthHit_getE, (setter)_BcalTruthHit_setE,
    (char*)"E value",
    NULL},
   {(char*)"class",
    (getter)_BcalTruthHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_BcalTruthHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"incident_id",
    (getter)_BcalTruthHit_getIncident_id, (setter)_BcalTruthHit_setIncident_id,
    (char*)"incident_id value",
    NULL},
   {(char*)"layer",
    (getter)_BcalTruthHit_getLayer, 0,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_BcalTruthHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_BcalTruthHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_BcalTruthHit_getModule, 0,
    (char*)"module value",
    NULL},
   {(char*)"runNo",
    (getter)_BcalTruthHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sector",
    (getter)_BcalTruthHit_getSector, 0,
    (char*)"sector value",
    NULL},
   {(char*)"t",
    (getter)_BcalTruthHit_getT, (setter)_BcalTruthHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_BcalTruthHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_BcalTruthHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"zLocal",
    (getter)_BcalTruthHit_getZLocal, (setter)_BcalTruthHit_setZLocal,
    (char*)"zLocal value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _BcalTruthHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _BcalTruthHit_methods[] = {
   {"toString", _BcalTruthHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _BcalTruthHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _BcalTruthHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.BcalTruthHit",         /*tp_name*/
    sizeof(_BcalTruthHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_BcalTruthHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_BcalTruthHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s bcalTruthHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _BcalTruthHit_methods,          /* tp_methods */
    _BcalTruthHit_members,          /* tp_members */
    _BcalTruthHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_BcalTruthHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _BcalTruthHit_new,              /* tp_new */
};



// wrap element class hddm_s::BcalCell as hddm_s.BcalCell

typedef struct {
   PyObject_HEAD
   BcalCell *elem;
   PyObject *host;
} _BcalCell;

static void
_BcalCell_dealloc(_BcalCell* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_BcalCell_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _BcalCell *self;
   self = (_BcalCell*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_BcalCell_init(_BcalCell *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_BcalCell_getClass(_BcalCell *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalCell_getVersion(_BcalCell *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_BcalCell_getXmlns(_BcalCell *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalCell_getEventNo(_BcalCell *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_BcalCell_getRunNo(_BcalCell *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_BcalCell_getLayer(_BcalCell *self, void *closure)
{
   return PyLong_FromLong(self->elem->getLayer());
}

static int
_BcalCell_setLayer(_BcalCell *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setLayer(var);
   return 0;
}

static PyObject*
_BcalCell_getMaxOccurs(_BcalCell *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalCell_getMinOccurs(_BcalCell *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_BcalCell_getModule(_BcalCell *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static int
_BcalCell_setModule(_BcalCell *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setModule(var);
   return 0;
}

static PyObject*
_BcalCell_getSector(_BcalCell *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSector());
}

static int
_BcalCell_setSector(_BcalCell *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setSector(var);
   return 0;
}

static PyObject*
_BcalCell_getBcalSiPMUpHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *obj = _BcalSiPMUpHit_new(&_BcalSiPMUpHit_type, 0, 0);
   ((_BcalSiPMUpHit*)obj)->elem = &me->elem->getBcalSiPMUpHit(index);
   ((_BcalSiPMUpHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_BcalCell_getBcalSiPMUpHits(PyObject *self, PyObject *args)
{
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalSiPMUpHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getBcalSiPMUpHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_BcalCell_addBcalSiPMUpHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalSiPMUpHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalSiPMUpHitList(me->elem->addBcalSiPMUpHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_BcalCell_deleteBcalSiPMUpHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid bcalCell element");
      return NULL;
   }
   me->elem->deleteBcalSiPMUpHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_BcalCell_getBcalSiPMDownHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *obj = _BcalSiPMDownHit_new(&_BcalSiPMDownHit_type, 0, 0);
   ((_BcalSiPMDownHit*)obj)->elem = &me->elem->getBcalSiPMDownHit(index);
   ((_BcalSiPMDownHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_BcalCell_getBcalSiPMDownHits(PyObject *self, PyObject *args)
{
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalSiPMDownHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getBcalSiPMDownHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_BcalCell_addBcalSiPMDownHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalSiPMDownHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalSiPMDownHitList(me->elem->addBcalSiPMDownHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_BcalCell_deleteBcalSiPMDownHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid bcalCell element");
      return NULL;
   }
   me->elem->deleteBcalSiPMDownHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_BcalCell_getBcalSiPMSpectrum(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *obj = _BcalSiPMSpectrum_new(&_BcalSiPMSpectrum_type, 0, 0);
   ((_BcalSiPMSpectrum*)obj)->elem = &me->elem->getBcalSiPMSpectrum(index);
   ((_BcalSiPMSpectrum*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_BcalCell_getBcalSiPMSpectrums(PyObject *self, PyObject *args)
{
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalSiPMSpectrum_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getBcalSiPMSpectrums();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_BcalCell_addBcalSiPMSpectrums(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalSiPMSpectrum_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalSiPMSpectrumList(me->elem->addBcalSiPMSpectrums(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_BcalCell_deleteBcalSiPMSpectrums(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid bcalCell element");
      return NULL;
   }
   me->elem->deleteBcalSiPMSpectrums(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_BcalCell_getBcalfADCHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *obj = _BcalfADCHit_new(&_BcalfADCHit_type, 0, 0);
   ((_BcalfADCHit*)obj)->elem = &me->elem->getBcalfADCHit(index);
   ((_BcalfADCHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_BcalCell_getBcalfADCHits(PyObject *self, PyObject *args)
{
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalfADCHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getBcalfADCHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_BcalCell_addBcalfADCHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalfADCHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalfADCHitList(me->elem->addBcalfADCHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_BcalCell_deleteBcalfADCHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid bcalCell element");
      return NULL;
   }
   me->elem->deleteBcalfADCHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_BcalCell_getBcalfADCDigiHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *obj = _BcalfADCDigiHit_new(&_BcalfADCDigiHit_type, 0, 0);
   ((_BcalfADCDigiHit*)obj)->elem = &me->elem->getBcalfADCDigiHit(index);
   ((_BcalfADCDigiHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_BcalCell_getBcalfADCDigiHits(PyObject *self, PyObject *args)
{
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalfADCDigiHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getBcalfADCDigiHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_BcalCell_addBcalfADCDigiHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalfADCDigiHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalfADCDigiHitList(me->elem->addBcalfADCDigiHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_BcalCell_deleteBcalfADCDigiHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid bcalCell element");
      return NULL;
   }
   me->elem->deleteBcalfADCDigiHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_BcalCell_getBcalTDCHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *obj = _BcalTDCHit_new(&_BcalTDCHit_type, 0, 0);
   ((_BcalTDCHit*)obj)->elem = &me->elem->getBcalTDCHit(index);
   ((_BcalTDCHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_BcalCell_getBcalTDCHits(PyObject *self, PyObject *args)
{
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalTDCHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getBcalTDCHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_BcalCell_addBcalTDCHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalTDCHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalTDCHitList(me->elem->addBcalTDCHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_BcalCell_deleteBcalTDCHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid bcalCell element");
      return NULL;
   }
   me->elem->deleteBcalTDCHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_BcalCell_getBcalTDCDigiHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *obj = _BcalTDCDigiHit_new(&_BcalTDCDigiHit_type, 0, 0);
   ((_BcalTDCDigiHit*)obj)->elem = &me->elem->getBcalTDCDigiHit(index);
   ((_BcalTDCDigiHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_BcalCell_getBcalTDCDigiHits(PyObject *self, PyObject *args)
{
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalTDCDigiHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getBcalTDCDigiHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_BcalCell_addBcalTDCDigiHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalTDCDigiHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalTDCDigiHitList(me->elem->addBcalTDCDigiHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_BcalCell_deleteBcalTDCDigiHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid bcalCell element");
      return NULL;
   }
   me->elem->deleteBcalTDCDigiHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_BcalCell_getBcalTruthHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *obj = _BcalTruthHit_new(&_BcalTruthHit_type, 0, 0);
   ((_BcalTruthHit*)obj)->elem = &me->elem->getBcalTruthHit(index);
   ((_BcalTruthHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_BcalCell_getBcalTruthHits(PyObject *self, PyObject *args)
{
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getBcalTruthHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_BcalCell_addBcalTruthHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid bcalCell element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalTruthHitList(me->elem->addBcalTruthHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_BcalCell_deleteBcalTruthHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid bcalCell element");
      return NULL;
   }
   me->elem->deleteBcalTruthHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_BcalCell_toString(PyObject *self, PyObject *args=0)
{
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCell element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_BcalCell_toXML(PyObject *self, PyObject *args=0)
{
   _BcalCell *me = (_BcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalCell element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _BcalCell_getsetters[] = {
   {(char*)"class",
    (getter)_BcalCell_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_BcalCell_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"layer",
    (getter)_BcalCell_getLayer, (setter)_BcalCell_setLayer,
    (char*)"layer value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_BcalCell_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_BcalCell_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_BcalCell_getModule, (setter)_BcalCell_setModule,
    (char*)"module value",
    NULL},
   {(char*)"runNo",
    (getter)_BcalCell_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sector",
    (getter)_BcalCell_getSector, (setter)_BcalCell_setSector,
    (char*)"sector value",
    NULL},
   {(char*)"version",
    (getter)_BcalCell_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_BcalCell_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _BcalCell_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _BcalCell_methods[] = {
   {"addBcalSiPMDownHits", _BcalCell_addBcalSiPMDownHits, METH_VARARGS,
    "extend (or insert into) the list of bcalSiPMDownHit objects for this bcalCell"},
   {"addBcalSiPMSpectrums", _BcalCell_addBcalSiPMSpectrums, METH_VARARGS,
    "extend (or insert into) the list of bcalSiPMSpectrum objects for this bcalCell"},
   {"addBcalSiPMUpHits", _BcalCell_addBcalSiPMUpHits, METH_VARARGS,
    "extend (or insert into) the list of bcalSiPMUpHit objects for this bcalCell"},
   {"addBcalTDCDigiHits", _BcalCell_addBcalTDCDigiHits, METH_VARARGS,
    "extend (or insert into) the list of bcalTDCDigiHit objects for this bcalCell"},
   {"addBcalTDCHits", _BcalCell_addBcalTDCHits, METH_VARARGS,
    "extend (or insert into) the list of bcalTDCHit objects for this bcalCell"},
   {"addBcalTruthHits", _BcalCell_addBcalTruthHits, METH_VARARGS,
    "extend (or insert into) the list of bcalTruthHit objects for this bcalCell"},
   {"addBcalfADCDigiHits", _BcalCell_addBcalfADCDigiHits, METH_VARARGS,
    "extend (or insert into) the list of bcalfADCDigiHit objects for this bcalCell"},
   {"addBcalfADCHits", _BcalCell_addBcalfADCHits, METH_VARARGS,
    "extend (or insert into) the list of bcalfADCHit objects for this bcalCell"},
   {"deleteBcalSiPMDownHits", _BcalCell_deleteBcalSiPMDownHits, METH_VARARGS,
    "delete bcalSiPMDownHit objects for this bcalCell"},
   {"deleteBcalSiPMSpectrums", _BcalCell_deleteBcalSiPMSpectrums, METH_VARARGS,
    "delete bcalSiPMSpectrum objects for this bcalCell"},
   {"deleteBcalSiPMUpHits", _BcalCell_deleteBcalSiPMUpHits, METH_VARARGS,
    "delete bcalSiPMUpHit objects for this bcalCell"},
   {"deleteBcalTDCDigiHits", _BcalCell_deleteBcalTDCDigiHits, METH_VARARGS,
    "delete bcalTDCDigiHit objects for this bcalCell"},
   {"deleteBcalTDCHits", _BcalCell_deleteBcalTDCHits, METH_VARARGS,
    "delete bcalTDCHit objects for this bcalCell"},
   {"deleteBcalTruthHits", _BcalCell_deleteBcalTruthHits, METH_VARARGS,
    "delete bcalTruthHit objects for this bcalCell"},
   {"deleteBcalfADCDigiHits", _BcalCell_deleteBcalfADCDigiHits, METH_VARARGS,
    "delete bcalfADCDigiHit objects for this bcalCell"},
   {"deleteBcalfADCHits", _BcalCell_deleteBcalfADCHits, METH_VARARGS,
    "delete bcalfADCHit objects for this bcalCell"},
   {"getBcalSiPMDownHit", _BcalCell_getBcalSiPMDownHit, METH_VARARGS,
    "get an individual bcalSiPMDownHit object from this bcalCell"},
   {"getBcalSiPMDownHits", _BcalCell_getBcalSiPMDownHits, METH_NOARGS,
    "get list of bcalSiPMDownHit objects for this bcalCell"},
   {"getBcalSiPMSpectrum", _BcalCell_getBcalSiPMSpectrum, METH_VARARGS,
    "get an individual bcalSiPMSpectrum object from this bcalCell"},
   {"getBcalSiPMSpectrums", _BcalCell_getBcalSiPMSpectrums, METH_NOARGS,
    "get list of bcalSiPMSpectrum objects for this bcalCell"},
   {"getBcalSiPMUpHit", _BcalCell_getBcalSiPMUpHit, METH_VARARGS,
    "get an individual bcalSiPMUpHit object from this bcalCell"},
   {"getBcalSiPMUpHits", _BcalCell_getBcalSiPMUpHits, METH_NOARGS,
    "get list of bcalSiPMUpHit objects for this bcalCell"},
   {"getBcalTDCDigiHit", _BcalCell_getBcalTDCDigiHit, METH_VARARGS,
    "get an individual bcalTDCDigiHit object from this bcalCell"},
   {"getBcalTDCDigiHits", _BcalCell_getBcalTDCDigiHits, METH_NOARGS,
    "get list of bcalTDCDigiHit objects for this bcalCell"},
   {"getBcalTDCHit", _BcalCell_getBcalTDCHit, METH_VARARGS,
    "get an individual bcalTDCHit object from this bcalCell"},
   {"getBcalTDCHits", _BcalCell_getBcalTDCHits, METH_NOARGS,
    "get list of bcalTDCHit objects for this bcalCell"},
   {"getBcalTruthHit", _BcalCell_getBcalTruthHit, METH_VARARGS,
    "get an individual bcalTruthHit object from this bcalCell"},
   {"getBcalTruthHits", _BcalCell_getBcalTruthHits, METH_NOARGS,
    "get list of bcalTruthHit objects for this bcalCell"},
   {"getBcalfADCDigiHit", _BcalCell_getBcalfADCDigiHit, METH_VARARGS,
    "get an individual bcalfADCDigiHit object from this bcalCell"},
   {"getBcalfADCDigiHits", _BcalCell_getBcalfADCDigiHits, METH_NOARGS,
    "get list of bcalfADCDigiHit objects for this bcalCell"},
   {"getBcalfADCHit", _BcalCell_getBcalfADCHit, METH_VARARGS,
    "get an individual bcalfADCHit object from this bcalCell"},
   {"getBcalfADCHits", _BcalCell_getBcalfADCHits, METH_NOARGS,
    "get list of bcalfADCHit objects for this bcalCell"},
   {"toString", _BcalCell_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _BcalCell_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _BcalCell_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.BcalCell",         /*tp_name*/
    sizeof(_BcalCell),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_BcalCell_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_BcalCell_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s bcalCell element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _BcalCell_methods,          /* tp_methods */
    _BcalCell_members,          /* tp_members */
    _BcalCell_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_BcalCell_init,   /* tp_init */
    0,                         /* tp_alloc */
    _BcalCell_new,              /* tp_new */
};



// wrap element class hddm_s::BcalTruthIncidentParticle as hddm_s.BcalTruthIncidentParticle

typedef struct {
   PyObject_HEAD
   BcalTruthIncidentParticle *elem;
   PyObject *host;
} _BcalTruthIncidentParticle;

static void
_BcalTruthIncidentParticle_dealloc(_BcalTruthIncidentParticle* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_BcalTruthIncidentParticle_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _BcalTruthIncidentParticle *self;
   self = (_BcalTruthIncidentParticle*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_BcalTruthIncidentParticle_init(_BcalTruthIncidentParticle *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_BcalTruthIncidentParticle_getClass(_BcalTruthIncidentParticle *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalTruthIncidentParticle_getVersion(_BcalTruthIncidentParticle *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_BcalTruthIncidentParticle_getXmlns(_BcalTruthIncidentParticle *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalTruthIncidentParticle_getEventNo(_BcalTruthIncidentParticle *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_BcalTruthIncidentParticle_getRunNo(_BcalTruthIncidentParticle *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_BcalTruthIncidentParticle_getId(_BcalTruthIncidentParticle *self, void *closure)
{
   return PyLong_FromLong(self->elem->getId());
}

static int
_BcalTruthIncidentParticle_setId(_BcalTruthIncidentParticle *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setId(var);
   return 0;
}

static PyObject*
_BcalTruthIncidentParticle_getMaxOccurs(_BcalTruthIncidentParticle *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalTruthIncidentParticle_getMinOccurs(_BcalTruthIncidentParticle *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_BcalTruthIncidentParticle_getPtype(_BcalTruthIncidentParticle *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPtype());
}

static int
_BcalTruthIncidentParticle_setPtype(_BcalTruthIncidentParticle *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPtype(var);
   return 0;
}

static PyObject*
_BcalTruthIncidentParticle_getPx(_BcalTruthIncidentParticle *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPx());
}

static int
_BcalTruthIncidentParticle_setPx(_BcalTruthIncidentParticle *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPx((float)var);
   return 0;
}

static PyObject*
_BcalTruthIncidentParticle_getPy(_BcalTruthIncidentParticle *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPy());
}

static int
_BcalTruthIncidentParticle_setPy(_BcalTruthIncidentParticle *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPy((float)var);
   return 0;
}

static PyObject*
_BcalTruthIncidentParticle_getPz(_BcalTruthIncidentParticle *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPz());
}

static int
_BcalTruthIncidentParticle_setPz(_BcalTruthIncidentParticle *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPz((float)var);
   return 0;
}

static PyObject*
_BcalTruthIncidentParticle_getX(_BcalTruthIncidentParticle *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static int
_BcalTruthIncidentParticle_setX(_BcalTruthIncidentParticle *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setX((float)var);
   return 0;
}

static PyObject*
_BcalTruthIncidentParticle_getY(_BcalTruthIncidentParticle *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static int
_BcalTruthIncidentParticle_setY(_BcalTruthIncidentParticle *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setY((float)var);
   return 0;
}

static PyObject*
_BcalTruthIncidentParticle_getZ(_BcalTruthIncidentParticle *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static int
_BcalTruthIncidentParticle_setZ(_BcalTruthIncidentParticle *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ((float)var);
   return 0;
}

static PyObject*
_BcalTruthIncidentParticle_toString(PyObject *self, PyObject *args=0)
{
   _BcalTruthIncidentParticle *me = (_BcalTruthIncidentParticle*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalTruthIncidentParticle element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_BcalTruthIncidentParticle_toXML(PyObject *self, PyObject *args=0)
{
   _BcalTruthIncidentParticle *me = (_BcalTruthIncidentParticle*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalTruthIncidentParticle element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _BcalTruthIncidentParticle_getsetters[] = {
   {(char*)"class",
    (getter)_BcalTruthIncidentParticle_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_BcalTruthIncidentParticle_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"id",
    (getter)_BcalTruthIncidentParticle_getId, (setter)_BcalTruthIncidentParticle_setId,
    (char*)"id value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_BcalTruthIncidentParticle_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_BcalTruthIncidentParticle_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"ptype",
    (getter)_BcalTruthIncidentParticle_getPtype, (setter)_BcalTruthIncidentParticle_setPtype,
    (char*)"ptype value",
    NULL},
   {(char*)"px",
    (getter)_BcalTruthIncidentParticle_getPx, (setter)_BcalTruthIncidentParticle_setPx,
    (char*)"px value",
    NULL},
   {(char*)"py",
    (getter)_BcalTruthIncidentParticle_getPy, (setter)_BcalTruthIncidentParticle_setPy,
    (char*)"py value",
    NULL},
   {(char*)"pz",
    (getter)_BcalTruthIncidentParticle_getPz, (setter)_BcalTruthIncidentParticle_setPz,
    (char*)"pz value",
    NULL},
   {(char*)"runNo",
    (getter)_BcalTruthIncidentParticle_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_BcalTruthIncidentParticle_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"x",
    (getter)_BcalTruthIncidentParticle_getX, (setter)_BcalTruthIncidentParticle_setX,
    (char*)"x value",
    NULL},
   {(char*)"xmlns",
    (getter)_BcalTruthIncidentParticle_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y",
    (getter)_BcalTruthIncidentParticle_getY, (setter)_BcalTruthIncidentParticle_setY,
    (char*)"y value",
    NULL},
   {(char*)"z",
    (getter)_BcalTruthIncidentParticle_getZ, (setter)_BcalTruthIncidentParticle_setZ,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _BcalTruthIncidentParticle_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _BcalTruthIncidentParticle_methods[] = {
   {"toString", _BcalTruthIncidentParticle_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _BcalTruthIncidentParticle_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _BcalTruthIncidentParticle_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.BcalTruthIncidentParticle",         /*tp_name*/
    sizeof(_BcalTruthIncidentParticle),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_BcalTruthIncidentParticle_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_BcalTruthIncidentParticle_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s bcalTruthIncidentParticle element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _BcalTruthIncidentParticle_methods,          /* tp_methods */
    _BcalTruthIncidentParticle_members,          /* tp_members */
    _BcalTruthIncidentParticle_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_BcalTruthIncidentParticle_init,   /* tp_init */
    0,                         /* tp_alloc */
    _BcalTruthIncidentParticle_new,              /* tp_new */
};



// wrap element class hddm_s::BcalTruthShower as hddm_s.BcalTruthShower

typedef struct {
   PyObject_HEAD
   BcalTruthShower *elem;
   PyObject *host;
} _BcalTruthShower;

static void
_BcalTruthShower_dealloc(_BcalTruthShower* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_BcalTruthShower_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _BcalTruthShower *self;
   self = (_BcalTruthShower*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_BcalTruthShower_init(_BcalTruthShower *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_BcalTruthShower_getClass(_BcalTruthShower *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalTruthShower_getVersion(_BcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_BcalTruthShower_getXmlns(_BcalTruthShower *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalTruthShower_getEventNo(_BcalTruthShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_BcalTruthShower_getRunNo(_BcalTruthShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_BcalTruthShower_getE(_BcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_BcalTruthShower_setE(_BcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_BcalTruthShower_getMaxOccurs(_BcalTruthShower *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BcalTruthShower_getMinOccurs(_BcalTruthShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_BcalTruthShower_getPhi(_BcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPhi());
}

static int
_BcalTruthShower_setPhi(_BcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPhi((float)var);
   return 0;
}

static PyObject*
_BcalTruthShower_getPrimary(_BcalTruthShower *self, void *closure)
{
   return PyBool_FromLong(self->elem->getPrimary());
}

static int
_BcalTruthShower_setPrimary(_BcalTruthShower *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPrimary((var==0)? false : true);
   return 0;
}

static PyObject*
_BcalTruthShower_getPtype(_BcalTruthShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPtype());
}

static int
_BcalTruthShower_setPtype(_BcalTruthShower *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPtype(var);
   return 0;
}

static PyObject*
_BcalTruthShower_getPx(_BcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPx());
}

static int
_BcalTruthShower_setPx(_BcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPx((float)var);
   return 0;
}

static PyObject*
_BcalTruthShower_getPy(_BcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPy());
}

static int
_BcalTruthShower_setPy(_BcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPy((float)var);
   return 0;
}

static PyObject*
_BcalTruthShower_getPz(_BcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPz());
}

static int
_BcalTruthShower_setPz(_BcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPz((float)var);
   return 0;
}

static PyObject*
_BcalTruthShower_getR(_BcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getR());
}

static int
_BcalTruthShower_setR(_BcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setR((float)var);
   return 0;
}

static PyObject*
_BcalTruthShower_getT(_BcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_BcalTruthShower_setT(_BcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_BcalTruthShower_getTrack(_BcalTruthShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static int
_BcalTruthShower_setTrack(_BcalTruthShower *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTrack(var);
   return 0;
}

static PyObject*
_BcalTruthShower_getZ(_BcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static int
_BcalTruthShower_setZ(_BcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ((float)var);
   return 0;
}

static PyObject*
_BcalTruthShower_getTrackID(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _BcalTruthShower *me = (_BcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalTruthShower element");
      return NULL;
   }
   PyObject *obj = _TrackID_new(&_TrackID_type, 0, 0);
   ((_TrackID*)obj)->elem = &me->elem->getTrackID();
   ((_TrackID*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_BcalTruthShower_getTrackIDs(PyObject *self, PyObject *args)
{
   _BcalTruthShower *me = (_BcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalTruthShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackID_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTrackIDs();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_BcalTruthShower_addTrackIDs(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalTruthShower *me = (_BcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid bcalTruthShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackID_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TrackIDList(me->elem->addTrackIDs(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_BcalTruthShower_deleteTrackIDs(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BcalTruthShower *me = (_BcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid bcalTruthShower element");
      return NULL;
   }
   me->elem->deleteTrackIDs(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_BcalTruthShower_toString(PyObject *self, PyObject *args=0)
{
   _BcalTruthShower *me = (_BcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalTruthShower element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_BcalTruthShower_toXML(PyObject *self, PyObject *args=0)
{
   _BcalTruthShower *me = (_BcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid bcalTruthShower element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _BcalTruthShower_getsetters[] = {
   {(char*)"E",
    (getter)_BcalTruthShower_getE, (setter)_BcalTruthShower_setE,
    (char*)"E value",
    NULL},
   {(char*)"class",
    (getter)_BcalTruthShower_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_BcalTruthShower_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_BcalTruthShower_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_BcalTruthShower_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"phi",
    (getter)_BcalTruthShower_getPhi, (setter)_BcalTruthShower_setPhi,
    (char*)"phi value",
    NULL},
   {(char*)"primary",
    (getter)_BcalTruthShower_getPrimary, (setter)_BcalTruthShower_setPrimary,
    (char*)"primary value",
    NULL},
   {(char*)"ptype",
    (getter)_BcalTruthShower_getPtype, (setter)_BcalTruthShower_setPtype,
    (char*)"ptype value",
    NULL},
   {(char*)"px",
    (getter)_BcalTruthShower_getPx, (setter)_BcalTruthShower_setPx,
    (char*)"px value",
    NULL},
   {(char*)"py",
    (getter)_BcalTruthShower_getPy, (setter)_BcalTruthShower_setPy,
    (char*)"py value",
    NULL},
   {(char*)"pz",
    (getter)_BcalTruthShower_getPz, (setter)_BcalTruthShower_setPz,
    (char*)"pz value",
    NULL},
   {(char*)"r",
    (getter)_BcalTruthShower_getR, (setter)_BcalTruthShower_setR,
    (char*)"r value",
    NULL},
   {(char*)"runNo",
    (getter)_BcalTruthShower_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_BcalTruthShower_getT, (setter)_BcalTruthShower_setT,
    (char*)"t value",
    NULL},
   {(char*)"track",
    (getter)_BcalTruthShower_getTrack, (setter)_BcalTruthShower_setTrack,
    (char*)"track value",
    NULL},
   {(char*)"version",
    (getter)_BcalTruthShower_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_BcalTruthShower_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"z",
    (getter)_BcalTruthShower_getZ, (setter)_BcalTruthShower_setZ,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _BcalTruthShower_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _BcalTruthShower_methods[] = {
   {"addTrackIDs", _BcalTruthShower_addTrackIDs, METH_VARARGS,
    "extend (or insert into) the list of trackID objects for this bcalTruthShower"},
   {"deleteTrackIDs", _BcalTruthShower_deleteTrackIDs, METH_VARARGS,
    "delete trackID objects for this bcalTruthShower"},
   {"getTrackID", _BcalTruthShower_getTrackID, METH_VARARGS,
    "get an individual trackID object from this bcalTruthShower"},
   {"getTrackIDs", _BcalTruthShower_getTrackIDs, METH_NOARGS,
    "get list of trackID objects for this bcalTruthShower"},
   {"toString", _BcalTruthShower_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _BcalTruthShower_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _BcalTruthShower_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.BcalTruthShower",         /*tp_name*/
    sizeof(_BcalTruthShower),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_BcalTruthShower_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_BcalTruthShower_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s bcalTruthShower element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _BcalTruthShower_methods,          /* tp_methods */
    _BcalTruthShower_members,          /* tp_members */
    _BcalTruthShower_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_BcalTruthShower_init,   /* tp_init */
    0,                         /* tp_alloc */
    _BcalTruthShower_new,              /* tp_new */
};



// wrap element class hddm_s::BarrelEMcal as hddm_s.BarrelEMcal

typedef struct {
   PyObject_HEAD
   BarrelEMcal *elem;
   PyObject *host;
} _BarrelEMcal;

static void
_BarrelEMcal_dealloc(_BarrelEMcal* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_BarrelEMcal_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _BarrelEMcal *self;
   self = (_BarrelEMcal*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_BarrelEMcal_init(_BarrelEMcal *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_BarrelEMcal_getClass(_BarrelEMcal *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BarrelEMcal_getVersion(_BarrelEMcal *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_BarrelEMcal_getXmlns(_BarrelEMcal *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BarrelEMcal_getEventNo(_BarrelEMcal *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_BarrelEMcal_getMaxOccurs(_BarrelEMcal *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_BarrelEMcal_getRunNo(_BarrelEMcal *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_BarrelEMcal_getMinOccurs(_BarrelEMcal *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_BarrelEMcal_getBcalCell(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _BarrelEMcal *me = (_BarrelEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid barrelEMcal element");
      return NULL;
   }
   PyObject *obj = _BcalCell_new(&_BcalCell_type, 0, 0);
   ((_BcalCell*)obj)->elem = &me->elem->getBcalCell(index);
   ((_BcalCell*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_BarrelEMcal_getBcalCells(PyObject *self, PyObject *args)
{
   _BarrelEMcal *me = (_BarrelEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid barrelEMcal element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalCell_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getBcalCells();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_BarrelEMcal_addBcalCells(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BarrelEMcal *me = (_BarrelEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid barrelEMcal element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalCell_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalCellList(me->elem->addBcalCells(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_BarrelEMcal_deleteBcalCells(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BarrelEMcal *me = (_BarrelEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid barrelEMcal element");
      return NULL;
   }
   me->elem->deleteBcalCells(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_BarrelEMcal_getBcalTruthIncidentParticle(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _BarrelEMcal *me = (_BarrelEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid barrelEMcal element");
      return NULL;
   }
   PyObject *obj = _BcalTruthIncidentParticle_new(&_BcalTruthIncidentParticle_type, 0, 0);
   ((_BcalTruthIncidentParticle*)obj)->elem = &me->elem->getBcalTruthIncidentParticle(index);
   ((_BcalTruthIncidentParticle*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_BarrelEMcal_getBcalTruthIncidentParticles(PyObject *self, PyObject *args)
{
   _BarrelEMcal *me = (_BarrelEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid barrelEMcal element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalTruthIncidentParticle_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getBcalTruthIncidentParticles();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_BarrelEMcal_addBcalTruthIncidentParticles(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BarrelEMcal *me = (_BarrelEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid barrelEMcal element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalTruthIncidentParticle_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalTruthIncidentParticleList(me->elem->addBcalTruthIncidentParticles(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_BarrelEMcal_deleteBcalTruthIncidentParticles(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BarrelEMcal *me = (_BarrelEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid barrelEMcal element");
      return NULL;
   }
   me->elem->deleteBcalTruthIncidentParticles(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_BarrelEMcal_getBcalTruthShower(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _BarrelEMcal *me = (_BarrelEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid barrelEMcal element");
      return NULL;
   }
   PyObject *obj = _BcalTruthShower_new(&_BcalTruthShower_type, 0, 0);
   ((_BcalTruthShower*)obj)->elem = &me->elem->getBcalTruthShower(index);
   ((_BcalTruthShower*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_BarrelEMcal_getBcalTruthShowers(PyObject *self, PyObject *args)
{
   _BarrelEMcal *me = (_BarrelEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid barrelEMcal element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalTruthShower_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getBcalTruthShowers();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_BarrelEMcal_addBcalTruthShowers(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BarrelEMcal *me = (_BarrelEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid barrelEMcal element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_BcalTruthShower_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new BcalTruthShowerList(me->elem->addBcalTruthShowers(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_BarrelEMcal_deleteBcalTruthShowers(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _BarrelEMcal *me = (_BarrelEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid barrelEMcal element");
      return NULL;
   }
   me->elem->deleteBcalTruthShowers(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_BarrelEMcal_toString(PyObject *self, PyObject *args=0)
{
   _BarrelEMcal *me = (_BarrelEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid barrelEMcal element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_BarrelEMcal_toXML(PyObject *self, PyObject *args=0)
{
   _BarrelEMcal *me = (_BarrelEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid barrelEMcal element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _BarrelEMcal_getsetters[] = {
   {(char*)"class",
    (getter)_BarrelEMcal_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_BarrelEMcal_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_BarrelEMcal_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_BarrelEMcal_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_BarrelEMcal_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_BarrelEMcal_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_BarrelEMcal_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _BarrelEMcal_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _BarrelEMcal_methods[] = {
   {"addBcalCells", _BarrelEMcal_addBcalCells, METH_VARARGS,
    "extend (or insert into) the list of bcalCell objects for this barrelEMcal"},
   {"addBcalTruthIncidentParticles", _BarrelEMcal_addBcalTruthIncidentParticles, METH_VARARGS,
    "extend (or insert into) the list of bcalTruthIncidentParticle objects for this barrelEMcal"},
   {"addBcalTruthShowers", _BarrelEMcal_addBcalTruthShowers, METH_VARARGS,
    "extend (or insert into) the list of bcalTruthShower objects for this barrelEMcal"},
   {"deleteBcalCells", _BarrelEMcal_deleteBcalCells, METH_VARARGS,
    "delete bcalCell objects for this barrelEMcal"},
   {"deleteBcalTruthIncidentParticles", _BarrelEMcal_deleteBcalTruthIncidentParticles, METH_VARARGS,
    "delete bcalTruthIncidentParticle objects for this barrelEMcal"},
   {"deleteBcalTruthShowers", _BarrelEMcal_deleteBcalTruthShowers, METH_VARARGS,
    "delete bcalTruthShower objects for this barrelEMcal"},
   {"getBcalCell", _BarrelEMcal_getBcalCell, METH_VARARGS,
    "get an individual bcalCell object from this barrelEMcal"},
   {"getBcalCells", _BarrelEMcal_getBcalCells, METH_NOARGS,
    "get list of bcalCell objects for this barrelEMcal"},
   {"getBcalTruthIncidentParticle", _BarrelEMcal_getBcalTruthIncidentParticle, METH_VARARGS,
    "get an individual bcalTruthIncidentParticle object from this barrelEMcal"},
   {"getBcalTruthIncidentParticles", _BarrelEMcal_getBcalTruthIncidentParticles, METH_NOARGS,
    "get list of bcalTruthIncidentParticle objects for this barrelEMcal"},
   {"getBcalTruthShower", _BarrelEMcal_getBcalTruthShower, METH_VARARGS,
    "get an individual bcalTruthShower object from this barrelEMcal"},
   {"getBcalTruthShowers", _BarrelEMcal_getBcalTruthShowers, METH_NOARGS,
    "get list of bcalTruthShower objects for this barrelEMcal"},
   {"toString", _BarrelEMcal_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _BarrelEMcal_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _BarrelEMcal_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.BarrelEMcal",         /*tp_name*/
    sizeof(_BarrelEMcal),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_BarrelEMcal_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_BarrelEMcal_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s barrelEMcal element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _BarrelEMcal_methods,          /* tp_methods */
    _BarrelEMcal_members,          /* tp_members */
    _BarrelEMcal_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_BarrelEMcal_init,   /* tp_init */
    0,                         /* tp_alloc */
    _BarrelEMcal_new,              /* tp_new */
};



// wrap element class hddm_s::GcalHit as hddm_s.GcalHit

typedef struct {
   PyObject_HEAD
   GcalHit *elem;
   PyObject *host;
} _GcalHit;

static void
_GcalHit_dealloc(_GcalHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_GcalHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _GcalHit *self;
   self = (_GcalHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_GcalHit_init(_GcalHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_GcalHit_getClass(_GcalHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_GcalHit_getVersion(_GcalHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_GcalHit_getXmlns(_GcalHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_GcalHit_getEventNo(_GcalHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_GcalHit_getRunNo(_GcalHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_GcalHit_getModule(_GcalHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static PyObject*
_GcalHit_getE(_GcalHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_GcalHit_setE(_GcalHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_GcalHit_getMaxOccurs(_GcalHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_GcalHit_getMinOccurs(_GcalHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_GcalHit_getT(_GcalHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_GcalHit_setT(_GcalHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_GcalHit_getZLocal(_GcalHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZLocal());
}

static int
_GcalHit_setZLocal(_GcalHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZLocal((float)var);
   return 0;
}

static PyObject*
_GcalHit_toString(PyObject *self, PyObject *args=0)
{
   _GcalHit *me = (_GcalHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid gcalHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_GcalHit_toXML(PyObject *self, PyObject *args=0)
{
   _GcalHit *me = (_GcalHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid gcalHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _GcalHit_getsetters[] = {
   {(char*)"E",
    (getter)_GcalHit_getE, (setter)_GcalHit_setE,
    (char*)"E value",
    NULL},
   {(char*)"class",
    (getter)_GcalHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_GcalHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_GcalHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_GcalHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_GcalHit_getModule, 0,
    (char*)"module value",
    NULL},
   {(char*)"runNo",
    (getter)_GcalHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_GcalHit_getT, (setter)_GcalHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_GcalHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_GcalHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"zLocal",
    (getter)_GcalHit_getZLocal, (setter)_GcalHit_setZLocal,
    (char*)"zLocal value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _GcalHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _GcalHit_methods[] = {
   {"toString", _GcalHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _GcalHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _GcalHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.GcalHit",         /*tp_name*/
    sizeof(_GcalHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_GcalHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_GcalHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s gcalHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _GcalHit_methods,          /* tp_methods */
    _GcalHit_members,          /* tp_members */
    _GcalHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_GcalHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _GcalHit_new,              /* tp_new */
};



// wrap element class hddm_s::GcalTruthHit as hddm_s.GcalTruthHit

typedef struct {
   PyObject_HEAD
   GcalTruthHit *elem;
   PyObject *host;
} _GcalTruthHit;

static void
_GcalTruthHit_dealloc(_GcalTruthHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_GcalTruthHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _GcalTruthHit *self;
   self = (_GcalTruthHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_GcalTruthHit_init(_GcalTruthHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_GcalTruthHit_getClass(_GcalTruthHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_GcalTruthHit_getVersion(_GcalTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_GcalTruthHit_getXmlns(_GcalTruthHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_GcalTruthHit_getEventNo(_GcalTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_GcalTruthHit_getRunNo(_GcalTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_GcalTruthHit_getModule(_GcalTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static PyObject*
_GcalTruthHit_getE(_GcalTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_GcalTruthHit_setE(_GcalTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_GcalTruthHit_getMaxOccurs(_GcalTruthHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_GcalTruthHit_getMinOccurs(_GcalTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_GcalTruthHit_getT(_GcalTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_GcalTruthHit_setT(_GcalTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_GcalTruthHit_getZLocal(_GcalTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZLocal());
}

static int
_GcalTruthHit_setZLocal(_GcalTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZLocal((float)var);
   return 0;
}

static PyObject*
_GcalTruthHit_toString(PyObject *self, PyObject *args=0)
{
   _GcalTruthHit *me = (_GcalTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid gcalTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_GcalTruthHit_toXML(PyObject *self, PyObject *args=0)
{
   _GcalTruthHit *me = (_GcalTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid gcalTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _GcalTruthHit_getsetters[] = {
   {(char*)"E",
    (getter)_GcalTruthHit_getE, (setter)_GcalTruthHit_setE,
    (char*)"E value",
    NULL},
   {(char*)"class",
    (getter)_GcalTruthHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_GcalTruthHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_GcalTruthHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_GcalTruthHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_GcalTruthHit_getModule, 0,
    (char*)"module value",
    NULL},
   {(char*)"runNo",
    (getter)_GcalTruthHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_GcalTruthHit_getT, (setter)_GcalTruthHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_GcalTruthHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_GcalTruthHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"zLocal",
    (getter)_GcalTruthHit_getZLocal, (setter)_GcalTruthHit_setZLocal,
    (char*)"zLocal value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _GcalTruthHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _GcalTruthHit_methods[] = {
   {"toString", _GcalTruthHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _GcalTruthHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _GcalTruthHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.GcalTruthHit",         /*tp_name*/
    sizeof(_GcalTruthHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_GcalTruthHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_GcalTruthHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s gcalTruthHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _GcalTruthHit_methods,          /* tp_methods */
    _GcalTruthHit_members,          /* tp_members */
    _GcalTruthHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_GcalTruthHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _GcalTruthHit_new,              /* tp_new */
};



// wrap element class hddm_s::GcalCell as hddm_s.GcalCell

typedef struct {
   PyObject_HEAD
   GcalCell *elem;
   PyObject *host;
} _GcalCell;

static void
_GcalCell_dealloc(_GcalCell* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_GcalCell_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _GcalCell *self;
   self = (_GcalCell*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_GcalCell_init(_GcalCell *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_GcalCell_getClass(_GcalCell *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_GcalCell_getVersion(_GcalCell *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_GcalCell_getXmlns(_GcalCell *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_GcalCell_getEventNo(_GcalCell *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_GcalCell_getRunNo(_GcalCell *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_GcalCell_getMaxOccurs(_GcalCell *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMaxOccurs());
}

static PyObject*
_GcalCell_getMinOccurs(_GcalCell *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_GcalCell_getModule(_GcalCell *self, void *closure)
{
   return PyLong_FromLong(self->elem->getModule());
}

static int
_GcalCell_setModule(_GcalCell *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setModule(var);
   return 0;
}

static PyObject*
_GcalCell_getGcalHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _GcalCell *me = (_GcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid gcalCell element");
      return NULL;
   }
   PyObject *obj = _GcalHit_new(&_GcalHit_type, 0, 0);
   ((_GcalHit*)obj)->elem = &me->elem->getGcalHit(index);
   ((_GcalHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_GcalCell_getGcalHits(PyObject *self, PyObject *args)
{
   _GcalCell *me = (_GcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid gcalCell element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_GcalHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getGcalHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_GcalCell_addGcalHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _GcalCell *me = (_GcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid gcalCell element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_GcalHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new GcalHitList(me->elem->addGcalHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_GcalCell_deleteGcalHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _GcalCell *me = (_GcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid gcalCell element");
      return NULL;
   }
   me->elem->deleteGcalHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_GcalCell_getGcalTruthHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _GcalCell *me = (_GcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid gcalCell element");
      return NULL;
   }
   PyObject *obj = _GcalTruthHit_new(&_GcalTruthHit_type, 0, 0);
   ((_GcalTruthHit*)obj)->elem = &me->elem->getGcalTruthHit(index);
   ((_GcalTruthHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_GcalCell_getGcalTruthHits(PyObject *self, PyObject *args)
{
   _GcalCell *me = (_GcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid gcalCell element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_GcalTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getGcalTruthHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_GcalCell_addGcalTruthHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _GcalCell *me = (_GcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid gcalCell element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_GcalTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new GcalTruthHitList(me->elem->addGcalTruthHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_GcalCell_deleteGcalTruthHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _GcalCell *me = (_GcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid gcalCell element");
      return NULL;
   }
   me->elem->deleteGcalTruthHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_GcalCell_toString(PyObject *self, PyObject *args=0)
{
   _GcalCell *me = (_GcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid gcalCell element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_GcalCell_toXML(PyObject *self, PyObject *args=0)
{
   _GcalCell *me = (_GcalCell*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid gcalCell element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _GcalCell_getsetters[] = {
   {(char*)"class",
    (getter)_GcalCell_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_GcalCell_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_GcalCell_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_GcalCell_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"module",
    (getter)_GcalCell_getModule, (setter)_GcalCell_setModule,
    (char*)"module value",
    NULL},
   {(char*)"runNo",
    (getter)_GcalCell_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_GcalCell_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_GcalCell_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _GcalCell_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _GcalCell_methods[] = {
   {"addGcalHits", _GcalCell_addGcalHits, METH_VARARGS,
    "extend (or insert into) the list of gcalHit objects for this gcalCell"},
   {"addGcalTruthHits", _GcalCell_addGcalTruthHits, METH_VARARGS,
    "extend (or insert into) the list of gcalTruthHit objects for this gcalCell"},
   {"deleteGcalHits", _GcalCell_deleteGcalHits, METH_VARARGS,
    "delete gcalHit objects for this gcalCell"},
   {"deleteGcalTruthHits", _GcalCell_deleteGcalTruthHits, METH_VARARGS,
    "delete gcalTruthHit objects for this gcalCell"},
   {"getGcalHit", _GcalCell_getGcalHit, METH_VARARGS,
    "get an individual gcalHit object from this gcalCell"},
   {"getGcalHits", _GcalCell_getGcalHits, METH_NOARGS,
    "get list of gcalHit objects for this gcalCell"},
   {"getGcalTruthHit", _GcalCell_getGcalTruthHit, METH_VARARGS,
    "get an individual gcalTruthHit object from this gcalCell"},
   {"getGcalTruthHits", _GcalCell_getGcalTruthHits, METH_NOARGS,
    "get list of gcalTruthHit objects for this gcalCell"},
   {"toString", _GcalCell_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _GcalCell_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _GcalCell_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.GcalCell",         /*tp_name*/
    sizeof(_GcalCell),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_GcalCell_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_GcalCell_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s gcalCell element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _GcalCell_methods,          /* tp_methods */
    _GcalCell_members,          /* tp_members */
    _GcalCell_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_GcalCell_init,   /* tp_init */
    0,                         /* tp_alloc */
    _GcalCell_new,              /* tp_new */
};



// wrap element class hddm_s::GcalTruthShower as hddm_s.GcalTruthShower

typedef struct {
   PyObject_HEAD
   GcalTruthShower *elem;
   PyObject *host;
} _GcalTruthShower;

static void
_GcalTruthShower_dealloc(_GcalTruthShower* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_GcalTruthShower_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _GcalTruthShower *self;
   self = (_GcalTruthShower*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_GcalTruthShower_init(_GcalTruthShower *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_GcalTruthShower_getClass(_GcalTruthShower *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_GcalTruthShower_getVersion(_GcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_GcalTruthShower_getXmlns(_GcalTruthShower *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_GcalTruthShower_getEventNo(_GcalTruthShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_GcalTruthShower_getRunNo(_GcalTruthShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_GcalTruthShower_getE(_GcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_GcalTruthShower_setE(_GcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_GcalTruthShower_getMaxOccurs(_GcalTruthShower *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_GcalTruthShower_getMinOccurs(_GcalTruthShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_GcalTruthShower_getPhi(_GcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPhi());
}

static int
_GcalTruthShower_setPhi(_GcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPhi((float)var);
   return 0;
}

static PyObject*
_GcalTruthShower_getPrimary(_GcalTruthShower *self, void *closure)
{
   return PyBool_FromLong(self->elem->getPrimary());
}

static int
_GcalTruthShower_setPrimary(_GcalTruthShower *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPrimary((var==0)? false : true);
   return 0;
}

static PyObject*
_GcalTruthShower_getPtype(_GcalTruthShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPtype());
}

static int
_GcalTruthShower_setPtype(_GcalTruthShower *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPtype(var);
   return 0;
}

static PyObject*
_GcalTruthShower_getPx(_GcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPx());
}

static int
_GcalTruthShower_setPx(_GcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPx((float)var);
   return 0;
}

static PyObject*
_GcalTruthShower_getPy(_GcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPy());
}

static int
_GcalTruthShower_setPy(_GcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPy((float)var);
   return 0;
}

static PyObject*
_GcalTruthShower_getPz(_GcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPz());
}

static int
_GcalTruthShower_setPz(_GcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPz((float)var);
   return 0;
}

static PyObject*
_GcalTruthShower_getR(_GcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getR());
}

static int
_GcalTruthShower_setR(_GcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setR((float)var);
   return 0;
}

static PyObject*
_GcalTruthShower_getT(_GcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_GcalTruthShower_setT(_GcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_GcalTruthShower_getTrack(_GcalTruthShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static int
_GcalTruthShower_setTrack(_GcalTruthShower *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTrack(var);
   return 0;
}

static PyObject*
_GcalTruthShower_getZ(_GcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static int
_GcalTruthShower_setZ(_GcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ((float)var);
   return 0;
}

static PyObject*
_GcalTruthShower_getTrackID(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _GcalTruthShower *me = (_GcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid gcalTruthShower element");
      return NULL;
   }
   PyObject *obj = _TrackID_new(&_TrackID_type, 0, 0);
   ((_TrackID*)obj)->elem = &me->elem->getTrackID();
   ((_TrackID*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_GcalTruthShower_getTrackIDs(PyObject *self, PyObject *args)
{
   _GcalTruthShower *me = (_GcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid gcalTruthShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackID_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTrackIDs();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_GcalTruthShower_addTrackIDs(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _GcalTruthShower *me = (_GcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid gcalTruthShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackID_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TrackIDList(me->elem->addTrackIDs(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_GcalTruthShower_deleteTrackIDs(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _GcalTruthShower *me = (_GcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid gcalTruthShower element");
      return NULL;
   }
   me->elem->deleteTrackIDs(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_GcalTruthShower_toString(PyObject *self, PyObject *args=0)
{
   _GcalTruthShower *me = (_GcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid gcalTruthShower element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_GcalTruthShower_toXML(PyObject *self, PyObject *args=0)
{
   _GcalTruthShower *me = (_GcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid gcalTruthShower element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _GcalTruthShower_getsetters[] = {
   {(char*)"E",
    (getter)_GcalTruthShower_getE, (setter)_GcalTruthShower_setE,
    (char*)"E value",
    NULL},
   {(char*)"class",
    (getter)_GcalTruthShower_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_GcalTruthShower_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_GcalTruthShower_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_GcalTruthShower_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"phi",
    (getter)_GcalTruthShower_getPhi, (setter)_GcalTruthShower_setPhi,
    (char*)"phi value",
    NULL},
   {(char*)"primary",
    (getter)_GcalTruthShower_getPrimary, (setter)_GcalTruthShower_setPrimary,
    (char*)"primary value",
    NULL},
   {(char*)"ptype",
    (getter)_GcalTruthShower_getPtype, (setter)_GcalTruthShower_setPtype,
    (char*)"ptype value",
    NULL},
   {(char*)"px",
    (getter)_GcalTruthShower_getPx, (setter)_GcalTruthShower_setPx,
    (char*)"px value",
    NULL},
   {(char*)"py",
    (getter)_GcalTruthShower_getPy, (setter)_GcalTruthShower_setPy,
    (char*)"py value",
    NULL},
   {(char*)"pz",
    (getter)_GcalTruthShower_getPz, (setter)_GcalTruthShower_setPz,
    (char*)"pz value",
    NULL},
   {(char*)"r",
    (getter)_GcalTruthShower_getR, (setter)_GcalTruthShower_setR,
    (char*)"r value",
    NULL},
   {(char*)"runNo",
    (getter)_GcalTruthShower_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_GcalTruthShower_getT, (setter)_GcalTruthShower_setT,
    (char*)"t value",
    NULL},
   {(char*)"track",
    (getter)_GcalTruthShower_getTrack, (setter)_GcalTruthShower_setTrack,
    (char*)"track value",
    NULL},
   {(char*)"version",
    (getter)_GcalTruthShower_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_GcalTruthShower_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"z",
    (getter)_GcalTruthShower_getZ, (setter)_GcalTruthShower_setZ,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _GcalTruthShower_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _GcalTruthShower_methods[] = {
   {"addTrackIDs", _GcalTruthShower_addTrackIDs, METH_VARARGS,
    "extend (or insert into) the list of trackID objects for this gcalTruthShower"},
   {"deleteTrackIDs", _GcalTruthShower_deleteTrackIDs, METH_VARARGS,
    "delete trackID objects for this gcalTruthShower"},
   {"getTrackID", _GcalTruthShower_getTrackID, METH_VARARGS,
    "get an individual trackID object from this gcalTruthShower"},
   {"getTrackIDs", _GcalTruthShower_getTrackIDs, METH_NOARGS,
    "get list of trackID objects for this gcalTruthShower"},
   {"toString", _GcalTruthShower_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _GcalTruthShower_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _GcalTruthShower_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.GcalTruthShower",         /*tp_name*/
    sizeof(_GcalTruthShower),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_GcalTruthShower_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_GcalTruthShower_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s gcalTruthShower element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _GcalTruthShower_methods,          /* tp_methods */
    _GcalTruthShower_members,          /* tp_members */
    _GcalTruthShower_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_GcalTruthShower_init,   /* tp_init */
    0,                         /* tp_alloc */
    _GcalTruthShower_new,              /* tp_new */
};



// wrap element class hddm_s::GapEMcal as hddm_s.GapEMcal

typedef struct {
   PyObject_HEAD
   GapEMcal *elem;
   PyObject *host;
} _GapEMcal;

static void
_GapEMcal_dealloc(_GapEMcal* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_GapEMcal_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _GapEMcal *self;
   self = (_GapEMcal*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_GapEMcal_init(_GapEMcal *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_GapEMcal_getClass(_GapEMcal *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_GapEMcal_getVersion(_GapEMcal *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_GapEMcal_getXmlns(_GapEMcal *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_GapEMcal_getEventNo(_GapEMcal *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_GapEMcal_getMaxOccurs(_GapEMcal *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_GapEMcal_getRunNo(_GapEMcal *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_GapEMcal_getMinOccurs(_GapEMcal *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_GapEMcal_getGcalCell(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _GapEMcal *me = (_GapEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid gapEMcal element");
      return NULL;
   }
   PyObject *obj = _GcalCell_new(&_GcalCell_type, 0, 0);
   ((_GcalCell*)obj)->elem = &me->elem->getGcalCell(index);
   ((_GcalCell*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_GapEMcal_getGcalCells(PyObject *self, PyObject *args)
{
   _GapEMcal *me = (_GapEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid gapEMcal element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_GcalCell_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getGcalCells();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_GapEMcal_addGcalCells(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _GapEMcal *me = (_GapEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid gapEMcal element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_GcalCell_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new GcalCellList(me->elem->addGcalCells(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_GapEMcal_deleteGcalCells(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _GapEMcal *me = (_GapEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid gapEMcal element");
      return NULL;
   }
   me->elem->deleteGcalCells(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_GapEMcal_getGcalTruthShower(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _GapEMcal *me = (_GapEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid gapEMcal element");
      return NULL;
   }
   PyObject *obj = _GcalTruthShower_new(&_GcalTruthShower_type, 0, 0);
   ((_GcalTruthShower*)obj)->elem = &me->elem->getGcalTruthShower(index);
   ((_GcalTruthShower*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_GapEMcal_getGcalTruthShowers(PyObject *self, PyObject *args)
{
   _GapEMcal *me = (_GapEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid gapEMcal element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_GcalTruthShower_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getGcalTruthShowers();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_GapEMcal_addGcalTruthShowers(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _GapEMcal *me = (_GapEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid gapEMcal element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_GcalTruthShower_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new GcalTruthShowerList(me->elem->addGcalTruthShowers(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_GapEMcal_deleteGcalTruthShowers(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _GapEMcal *me = (_GapEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid gapEMcal element");
      return NULL;
   }
   me->elem->deleteGcalTruthShowers(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_GapEMcal_toString(PyObject *self, PyObject *args=0)
{
   _GapEMcal *me = (_GapEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid gapEMcal element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_GapEMcal_toXML(PyObject *self, PyObject *args=0)
{
   _GapEMcal *me = (_GapEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid gapEMcal element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _GapEMcal_getsetters[] = {
   {(char*)"class",
    (getter)_GapEMcal_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_GapEMcal_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_GapEMcal_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_GapEMcal_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_GapEMcal_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_GapEMcal_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_GapEMcal_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _GapEMcal_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _GapEMcal_methods[] = {
   {"addGcalCells", _GapEMcal_addGcalCells, METH_VARARGS,
    "extend (or insert into) the list of gcalCell objects for this gapEMcal"},
   {"addGcalTruthShowers", _GapEMcal_addGcalTruthShowers, METH_VARARGS,
    "extend (or insert into) the list of gcalTruthShower objects for this gapEMcal"},
   {"deleteGcalCells", _GapEMcal_deleteGcalCells, METH_VARARGS,
    "delete gcalCell objects for this gapEMcal"},
   {"deleteGcalTruthShowers", _GapEMcal_deleteGcalTruthShowers, METH_VARARGS,
    "delete gcalTruthShower objects for this gapEMcal"},
   {"getGcalCell", _GapEMcal_getGcalCell, METH_VARARGS,
    "get an individual gcalCell object from this gapEMcal"},
   {"getGcalCells", _GapEMcal_getGcalCells, METH_NOARGS,
    "get list of gcalCell objects for this gapEMcal"},
   {"getGcalTruthShower", _GapEMcal_getGcalTruthShower, METH_VARARGS,
    "get an individual gcalTruthShower object from this gapEMcal"},
   {"getGcalTruthShowers", _GapEMcal_getGcalTruthShowers, METH_NOARGS,
    "get list of gcalTruthShower objects for this gapEMcal"},
   {"toString", _GapEMcal_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _GapEMcal_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _GapEMcal_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.GapEMcal",         /*tp_name*/
    sizeof(_GapEMcal),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_GapEMcal_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_GapEMcal_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s gapEMcal element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _GapEMcal_methods,          /* tp_methods */
    _GapEMcal_members,          /* tp_members */
    _GapEMcal_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_GapEMcal_init,   /* tp_init */
    0,                         /* tp_alloc */
    _GapEMcal_new,              /* tp_new */
};



// wrap element class hddm_s::CereHit as hddm_s.CereHit

typedef struct {
   PyObject_HEAD
   CereHit *elem;
   PyObject *host;
} _CereHit;

static void
_CereHit_dealloc(_CereHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_CereHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _CereHit *self;
   self = (_CereHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_CereHit_init(_CereHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_CereHit_getClass(_CereHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CereHit_getVersion(_CereHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_CereHit_getXmlns(_CereHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CereHit_getEventNo(_CereHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_CereHit_getRunNo(_CereHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_CereHit_getMinOccurs(_CereHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_CereHit_getSector(_CereHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSector());
}

static PyObject*
_CereHit_getMaxOccurs(_CereHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CereHit_getPe(_CereHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPe());
}

static int
_CereHit_setPe(_CereHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPe((float)var);
   return 0;
}

static PyObject*
_CereHit_getT(_CereHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_CereHit_setT(_CereHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_CereHit_toString(PyObject *self, PyObject *args=0)
{
   _CereHit *me = (_CereHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cereHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_CereHit_toXML(PyObject *self, PyObject *args=0)
{
   _CereHit *me = (_CereHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cereHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _CereHit_getsetters[] = {
   {(char*)"class",
    (getter)_CereHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_CereHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_CereHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_CereHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"pe",
    (getter)_CereHit_getPe, (setter)_CereHit_setPe,
    (char*)"pe value",
    NULL},
   {(char*)"runNo",
    (getter)_CereHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sector",
    (getter)_CereHit_getSector, 0,
    (char*)"sector value",
    NULL},
   {(char*)"t",
    (getter)_CereHit_getT, (setter)_CereHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_CereHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_CereHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _CereHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _CereHit_methods[] = {
   {"toString", _CereHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _CereHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _CereHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.CereHit",         /*tp_name*/
    sizeof(_CereHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_CereHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_CereHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s cereHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _CereHit_methods,          /* tp_methods */
    _CereHit_members,          /* tp_members */
    _CereHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_CereHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _CereHit_new,              /* tp_new */
};



// wrap element class hddm_s::CereTruthHit as hddm_s.CereTruthHit

typedef struct {
   PyObject_HEAD
   CereTruthHit *elem;
   PyObject *host;
} _CereTruthHit;

static void
_CereTruthHit_dealloc(_CereTruthHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_CereTruthHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _CereTruthHit *self;
   self = (_CereTruthHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_CereTruthHit_init(_CereTruthHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_CereTruthHit_getClass(_CereTruthHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CereTruthHit_getVersion(_CereTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_CereTruthHit_getXmlns(_CereTruthHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CereTruthHit_getEventNo(_CereTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_CereTruthHit_getRunNo(_CereTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_CereTruthHit_getMinOccurs(_CereTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_CereTruthHit_getSector(_CereTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSector());
}

static PyObject*
_CereTruthHit_getMaxOccurs(_CereTruthHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CereTruthHit_getPe(_CereTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPe());
}

static int
_CereTruthHit_setPe(_CereTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPe((float)var);
   return 0;
}

static PyObject*
_CereTruthHit_getT(_CereTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_CereTruthHit_setT(_CereTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_CereTruthHit_toString(PyObject *self, PyObject *args=0)
{
   _CereTruthHit *me = (_CereTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cereTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_CereTruthHit_toXML(PyObject *self, PyObject *args=0)
{
   _CereTruthHit *me = (_CereTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cereTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _CereTruthHit_getsetters[] = {
   {(char*)"class",
    (getter)_CereTruthHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_CereTruthHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_CereTruthHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_CereTruthHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"pe",
    (getter)_CereTruthHit_getPe, (setter)_CereTruthHit_setPe,
    (char*)"pe value",
    NULL},
   {(char*)"runNo",
    (getter)_CereTruthHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sector",
    (getter)_CereTruthHit_getSector, 0,
    (char*)"sector value",
    NULL},
   {(char*)"t",
    (getter)_CereTruthHit_getT, (setter)_CereTruthHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_CereTruthHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_CereTruthHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _CereTruthHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _CereTruthHit_methods[] = {
   {"toString", _CereTruthHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _CereTruthHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _CereTruthHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.CereTruthHit",         /*tp_name*/
    sizeof(_CereTruthHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_CereTruthHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_CereTruthHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s cereTruthHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _CereTruthHit_methods,          /* tp_methods */
    _CereTruthHit_members,          /* tp_members */
    _CereTruthHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_CereTruthHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _CereTruthHit_new,              /* tp_new */
};



// wrap element class hddm_s::CereSection as hddm_s.CereSection

typedef struct {
   PyObject_HEAD
   CereSection *elem;
   PyObject *host;
} _CereSection;

static void
_CereSection_dealloc(_CereSection* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_CereSection_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _CereSection *self;
   self = (_CereSection*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_CereSection_init(_CereSection *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_CereSection_getClass(_CereSection *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CereSection_getVersion(_CereSection *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_CereSection_getXmlns(_CereSection *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CereSection_getEventNo(_CereSection *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_CereSection_getRunNo(_CereSection *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_CereSection_getMaxOccurs(_CereSection *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CereSection_getMinOccurs(_CereSection *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_CereSection_getSector(_CereSection *self, void *closure)
{
   return PyLong_FromLong(self->elem->getSector());
}

static int
_CereSection_setSector(_CereSection *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setSector(var);
   return 0;
}

static PyObject*
_CereSection_getCereHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _CereSection *me = (_CereSection*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cereSection element");
      return NULL;
   }
   PyObject *obj = _CereHit_new(&_CereHit_type, 0, 0);
   ((_CereHit*)obj)->elem = &me->elem->getCereHit(index);
   ((_CereHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_CereSection_getCereHits(PyObject *self, PyObject *args)
{
   _CereSection *me = (_CereSection*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cereSection element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CereHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getCereHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_CereSection_addCereHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CereSection *me = (_CereSection*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid cereSection element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CereHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CereHitList(me->elem->addCereHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_CereSection_deleteCereHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CereSection *me = (_CereSection*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid cereSection element");
      return NULL;
   }
   me->elem->deleteCereHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_CereSection_getCereTruthHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _CereSection *me = (_CereSection*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cereSection element");
      return NULL;
   }
   PyObject *obj = _CereTruthHit_new(&_CereTruthHit_type, 0, 0);
   ((_CereTruthHit*)obj)->elem = &me->elem->getCereTruthHit(index);
   ((_CereTruthHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_CereSection_getCereTruthHits(PyObject *self, PyObject *args)
{
   _CereSection *me = (_CereSection*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cereSection element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CereTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getCereTruthHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_CereSection_addCereTruthHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CereSection *me = (_CereSection*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid cereSection element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CereTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CereTruthHitList(me->elem->addCereTruthHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_CereSection_deleteCereTruthHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CereSection *me = (_CereSection*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid cereSection element");
      return NULL;
   }
   me->elem->deleteCereTruthHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_CereSection_toString(PyObject *self, PyObject *args=0)
{
   _CereSection *me = (_CereSection*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cereSection element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_CereSection_toXML(PyObject *self, PyObject *args=0)
{
   _CereSection *me = (_CereSection*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cereSection element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _CereSection_getsetters[] = {
   {(char*)"class",
    (getter)_CereSection_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_CereSection_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_CereSection_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_CereSection_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_CereSection_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"sector",
    (getter)_CereSection_getSector, (setter)_CereSection_setSector,
    (char*)"sector value",
    NULL},
   {(char*)"version",
    (getter)_CereSection_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_CereSection_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _CereSection_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _CereSection_methods[] = {
   {"addCereHits", _CereSection_addCereHits, METH_VARARGS,
    "extend (or insert into) the list of cereHit objects for this cereSection"},
   {"addCereTruthHits", _CereSection_addCereTruthHits, METH_VARARGS,
    "extend (or insert into) the list of cereTruthHit objects for this cereSection"},
   {"deleteCereHits", _CereSection_deleteCereHits, METH_VARARGS,
    "delete cereHit objects for this cereSection"},
   {"deleteCereTruthHits", _CereSection_deleteCereTruthHits, METH_VARARGS,
    "delete cereTruthHit objects for this cereSection"},
   {"getCereHit", _CereSection_getCereHit, METH_VARARGS,
    "get an individual cereHit object from this cereSection"},
   {"getCereHits", _CereSection_getCereHits, METH_NOARGS,
    "get list of cereHit objects for this cereSection"},
   {"getCereTruthHit", _CereSection_getCereTruthHit, METH_VARARGS,
    "get an individual cereTruthHit object from this cereSection"},
   {"getCereTruthHits", _CereSection_getCereTruthHits, METH_NOARGS,
    "get list of cereTruthHit objects for this cereSection"},
   {"toString", _CereSection_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _CereSection_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _CereSection_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.CereSection",         /*tp_name*/
    sizeof(_CereSection),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_CereSection_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_CereSection_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s cereSection element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _CereSection_methods,          /* tp_methods */
    _CereSection_members,          /* tp_members */
    _CereSection_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_CereSection_init,   /* tp_init */
    0,                         /* tp_alloc */
    _CereSection_new,              /* tp_new */
};



// wrap element class hddm_s::CereTruthPoint as hddm_s.CereTruthPoint

typedef struct {
   PyObject_HEAD
   CereTruthPoint *elem;
   PyObject *host;
} _CereTruthPoint;

static void
_CereTruthPoint_dealloc(_CereTruthPoint* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_CereTruthPoint_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _CereTruthPoint *self;
   self = (_CereTruthPoint*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_CereTruthPoint_init(_CereTruthPoint *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_CereTruthPoint_getClass(_CereTruthPoint *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CereTruthPoint_getVersion(_CereTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_CereTruthPoint_getXmlns(_CereTruthPoint *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CereTruthPoint_getEventNo(_CereTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_CereTruthPoint_getRunNo(_CereTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_CereTruthPoint_getE(_CereTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_CereTruthPoint_setE(_CereTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_CereTruthPoint_getMaxOccurs(_CereTruthPoint *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CereTruthPoint_getMinOccurs(_CereTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_CereTruthPoint_getPrimary(_CereTruthPoint *self, void *closure)
{
   return PyBool_FromLong(self->elem->getPrimary());
}

static int
_CereTruthPoint_setPrimary(_CereTruthPoint *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPrimary((var==0)? false : true);
   return 0;
}

static PyObject*
_CereTruthPoint_getPtype(_CereTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPtype());
}

static int
_CereTruthPoint_setPtype(_CereTruthPoint *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPtype(var);
   return 0;
}

static PyObject*
_CereTruthPoint_getPx(_CereTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPx());
}

static int
_CereTruthPoint_setPx(_CereTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPx((float)var);
   return 0;
}

static PyObject*
_CereTruthPoint_getPy(_CereTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPy());
}

static int
_CereTruthPoint_setPy(_CereTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPy((float)var);
   return 0;
}

static PyObject*
_CereTruthPoint_getPz(_CereTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPz());
}

static int
_CereTruthPoint_setPz(_CereTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPz((float)var);
   return 0;
}

static PyObject*
_CereTruthPoint_getT(_CereTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_CereTruthPoint_setT(_CereTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_CereTruthPoint_getTrack(_CereTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static int
_CereTruthPoint_setTrack(_CereTruthPoint *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTrack(var);
   return 0;
}

static PyObject*
_CereTruthPoint_getX(_CereTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static int
_CereTruthPoint_setX(_CereTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setX((float)var);
   return 0;
}

static PyObject*
_CereTruthPoint_getY(_CereTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static int
_CereTruthPoint_setY(_CereTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setY((float)var);
   return 0;
}

static PyObject*
_CereTruthPoint_getZ(_CereTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static int
_CereTruthPoint_setZ(_CereTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ((float)var);
   return 0;
}

static PyObject*
_CereTruthPoint_getTrackID(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _CereTruthPoint *me = (_CereTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cereTruthPoint element");
      return NULL;
   }
   PyObject *obj = _TrackID_new(&_TrackID_type, 0, 0);
   ((_TrackID*)obj)->elem = &me->elem->getTrackID();
   ((_TrackID*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_CereTruthPoint_getTrackIDs(PyObject *self, PyObject *args)
{
   _CereTruthPoint *me = (_CereTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cereTruthPoint element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackID_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTrackIDs();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_CereTruthPoint_addTrackIDs(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CereTruthPoint *me = (_CereTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid cereTruthPoint element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackID_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TrackIDList(me->elem->addTrackIDs(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_CereTruthPoint_deleteTrackIDs(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CereTruthPoint *me = (_CereTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid cereTruthPoint element");
      return NULL;
   }
   me->elem->deleteTrackIDs(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_CereTruthPoint_toString(PyObject *self, PyObject *args=0)
{
   _CereTruthPoint *me = (_CereTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cereTruthPoint element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_CereTruthPoint_toXML(PyObject *self, PyObject *args=0)
{
   _CereTruthPoint *me = (_CereTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid cereTruthPoint element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _CereTruthPoint_getsetters[] = {
   {(char*)"E",
    (getter)_CereTruthPoint_getE, (setter)_CereTruthPoint_setE,
    (char*)"E value",
    NULL},
   {(char*)"class",
    (getter)_CereTruthPoint_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_CereTruthPoint_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_CereTruthPoint_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_CereTruthPoint_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"primary",
    (getter)_CereTruthPoint_getPrimary, (setter)_CereTruthPoint_setPrimary,
    (char*)"primary value",
    NULL},
   {(char*)"ptype",
    (getter)_CereTruthPoint_getPtype, (setter)_CereTruthPoint_setPtype,
    (char*)"ptype value",
    NULL},
   {(char*)"px",
    (getter)_CereTruthPoint_getPx, (setter)_CereTruthPoint_setPx,
    (char*)"px value",
    NULL},
   {(char*)"py",
    (getter)_CereTruthPoint_getPy, (setter)_CereTruthPoint_setPy,
    (char*)"py value",
    NULL},
   {(char*)"pz",
    (getter)_CereTruthPoint_getPz, (setter)_CereTruthPoint_setPz,
    (char*)"pz value",
    NULL},
   {(char*)"runNo",
    (getter)_CereTruthPoint_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_CereTruthPoint_getT, (setter)_CereTruthPoint_setT,
    (char*)"t value",
    NULL},
   {(char*)"track",
    (getter)_CereTruthPoint_getTrack, (setter)_CereTruthPoint_setTrack,
    (char*)"track value",
    NULL},
   {(char*)"version",
    (getter)_CereTruthPoint_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"x",
    (getter)_CereTruthPoint_getX, (setter)_CereTruthPoint_setX,
    (char*)"x value",
    NULL},
   {(char*)"xmlns",
    (getter)_CereTruthPoint_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y",
    (getter)_CereTruthPoint_getY, (setter)_CereTruthPoint_setY,
    (char*)"y value",
    NULL},
   {(char*)"z",
    (getter)_CereTruthPoint_getZ, (setter)_CereTruthPoint_setZ,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _CereTruthPoint_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _CereTruthPoint_methods[] = {
   {"addTrackIDs", _CereTruthPoint_addTrackIDs, METH_VARARGS,
    "extend (or insert into) the list of trackID objects for this cereTruthPoint"},
   {"deleteTrackIDs", _CereTruthPoint_deleteTrackIDs, METH_VARARGS,
    "delete trackID objects for this cereTruthPoint"},
   {"getTrackID", _CereTruthPoint_getTrackID, METH_VARARGS,
    "get an individual trackID object from this cereTruthPoint"},
   {"getTrackIDs", _CereTruthPoint_getTrackIDs, METH_NOARGS,
    "get list of trackID objects for this cereTruthPoint"},
   {"toString", _CereTruthPoint_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _CereTruthPoint_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _CereTruthPoint_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.CereTruthPoint",         /*tp_name*/
    sizeof(_CereTruthPoint),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_CereTruthPoint_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_CereTruthPoint_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s cereTruthPoint element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _CereTruthPoint_methods,          /* tp_methods */
    _CereTruthPoint_members,          /* tp_members */
    _CereTruthPoint_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_CereTruthPoint_init,   /* tp_init */
    0,                         /* tp_alloc */
    _CereTruthPoint_new,              /* tp_new */
};



// wrap element class hddm_s::Cerenkov as hddm_s.Cerenkov

typedef struct {
   PyObject_HEAD
   Cerenkov *elem;
   PyObject *host;
} _Cerenkov;

static void
_Cerenkov_dealloc(_Cerenkov* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_Cerenkov_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _Cerenkov *self;
   self = (_Cerenkov*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_Cerenkov_init(_Cerenkov *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_Cerenkov_getClass(_Cerenkov *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Cerenkov_getVersion(_Cerenkov *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_Cerenkov_getXmlns(_Cerenkov *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Cerenkov_getEventNo(_Cerenkov *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_Cerenkov_getMaxOccurs(_Cerenkov *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_Cerenkov_getRunNo(_Cerenkov *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_Cerenkov_getMinOccurs(_Cerenkov *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_Cerenkov_getCereSection(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Cerenkov *me = (_Cerenkov*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid Cerenkov element");
      return NULL;
   }
   PyObject *obj = _CereSection_new(&_CereSection_type, 0, 0);
   ((_CereSection*)obj)->elem = &me->elem->getCereSection(index);
   ((_CereSection*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Cerenkov_getCereSections(PyObject *self, PyObject *args)
{
   _Cerenkov *me = (_Cerenkov*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid Cerenkov element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CereSection_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getCereSections();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Cerenkov_addCereSections(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Cerenkov *me = (_Cerenkov*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid Cerenkov element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CereSection_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CereSectionList(me->elem->addCereSections(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Cerenkov_deleteCereSections(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Cerenkov *me = (_Cerenkov*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid Cerenkov element");
      return NULL;
   }
   me->elem->deleteCereSections(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Cerenkov_getCereTruthPoint(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _Cerenkov *me = (_Cerenkov*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid Cerenkov element");
      return NULL;
   }
   PyObject *obj = _CereTruthPoint_new(&_CereTruthPoint_type, 0, 0);
   ((_CereTruthPoint*)obj)->elem = &me->elem->getCereTruthPoint(index);
   ((_CereTruthPoint*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_Cerenkov_getCereTruthPoints(PyObject *self, PyObject *args)
{
   _Cerenkov *me = (_Cerenkov*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid Cerenkov element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CereTruthPoint_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getCereTruthPoints();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_Cerenkov_addCereTruthPoints(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Cerenkov *me = (_Cerenkov*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid Cerenkov element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_CereTruthPoint_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new CereTruthPointList(me->elem->addCereTruthPoints(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_Cerenkov_deleteCereTruthPoints(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _Cerenkov *me = (_Cerenkov*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid Cerenkov element");
      return NULL;
   }
   me->elem->deleteCereTruthPoints(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_Cerenkov_toString(PyObject *self, PyObject *args=0)
{
   _Cerenkov *me = (_Cerenkov*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid Cerenkov element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_Cerenkov_toXML(PyObject *self, PyObject *args=0)
{
   _Cerenkov *me = (_Cerenkov*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid Cerenkov element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _Cerenkov_getsetters[] = {
   {(char*)"class",
    (getter)_Cerenkov_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_Cerenkov_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_Cerenkov_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_Cerenkov_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_Cerenkov_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_Cerenkov_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_Cerenkov_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _Cerenkov_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _Cerenkov_methods[] = {
   {"addCereSections", _Cerenkov_addCereSections, METH_VARARGS,
    "extend (or insert into) the list of cereSection objects for this Cerenkov"},
   {"addCereTruthPoints", _Cerenkov_addCereTruthPoints, METH_VARARGS,
    "extend (or insert into) the list of cereTruthPoint objects for this Cerenkov"},
   {"deleteCereSections", _Cerenkov_deleteCereSections, METH_VARARGS,
    "delete cereSection objects for this Cerenkov"},
   {"deleteCereTruthPoints", _Cerenkov_deleteCereTruthPoints, METH_VARARGS,
    "delete cereTruthPoint objects for this Cerenkov"},
   {"getCereSection", _Cerenkov_getCereSection, METH_VARARGS,
    "get an individual cereSection object from this Cerenkov"},
   {"getCereSections", _Cerenkov_getCereSections, METH_NOARGS,
    "get list of cereSection objects for this Cerenkov"},
   {"getCereTruthPoint", _Cerenkov_getCereTruthPoint, METH_VARARGS,
    "get an individual cereTruthPoint object from this Cerenkov"},
   {"getCereTruthPoints", _Cerenkov_getCereTruthPoints, METH_NOARGS,
    "get list of cereTruthPoint objects for this Cerenkov"},
   {"toString", _Cerenkov_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _Cerenkov_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _Cerenkov_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.Cerenkov",         /*tp_name*/
    sizeof(_Cerenkov),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_Cerenkov_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_Cerenkov_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s Cerenkov element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _Cerenkov_methods,          /* tp_methods */
    _Cerenkov_members,          /* tp_members */
    _Cerenkov_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_Cerenkov_init,   /* tp_init */
    0,                         /* tp_alloc */
    _Cerenkov_new,              /* tp_new */
};



// wrap element class hddm_s::RichTruthHit as hddm_s.RichTruthHit

typedef struct {
   PyObject_HEAD
   RichTruthHit *elem;
   PyObject *host;
} _RichTruthHit;

static void
_RichTruthHit_dealloc(_RichTruthHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_RichTruthHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _RichTruthHit *self;
   self = (_RichTruthHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_RichTruthHit_init(_RichTruthHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_RichTruthHit_getClass(_RichTruthHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_RichTruthHit_getVersion(_RichTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_RichTruthHit_getXmlns(_RichTruthHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_RichTruthHit_getEventNo(_RichTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_RichTruthHit_getRunNo(_RichTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_RichTruthHit_getMaxOccurs(_RichTruthHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_RichTruthHit_getMinOccurs(_RichTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_RichTruthHit_getT(_RichTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_RichTruthHit_setT(_RichTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_RichTruthHit_getX(_RichTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static int
_RichTruthHit_setX(_RichTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setX((float)var);
   return 0;
}

static PyObject*
_RichTruthHit_getY(_RichTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static int
_RichTruthHit_setY(_RichTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setY((float)var);
   return 0;
}

static PyObject*
_RichTruthHit_getZ(_RichTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static int
_RichTruthHit_setZ(_RichTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ((float)var);
   return 0;
}

static PyObject*
_RichTruthHit_toString(PyObject *self, PyObject *args=0)
{
   _RichTruthHit *me = (_RichTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid richTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_RichTruthHit_toXML(PyObject *self, PyObject *args=0)
{
   _RichTruthHit *me = (_RichTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid richTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _RichTruthHit_getsetters[] = {
   {(char*)"class",
    (getter)_RichTruthHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_RichTruthHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_RichTruthHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_RichTruthHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_RichTruthHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_RichTruthHit_getT, (setter)_RichTruthHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_RichTruthHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"x",
    (getter)_RichTruthHit_getX, (setter)_RichTruthHit_setX,
    (char*)"x value",
    NULL},
   {(char*)"xmlns",
    (getter)_RichTruthHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y",
    (getter)_RichTruthHit_getY, (setter)_RichTruthHit_setY,
    (char*)"y value",
    NULL},
   {(char*)"z",
    (getter)_RichTruthHit_getZ, (setter)_RichTruthHit_setZ,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _RichTruthHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _RichTruthHit_methods[] = {
   {"toString", _RichTruthHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _RichTruthHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _RichTruthHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.RichTruthHit",         /*tp_name*/
    sizeof(_RichTruthHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_RichTruthHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_RichTruthHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s richTruthHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _RichTruthHit_methods,          /* tp_methods */
    _RichTruthHit_members,          /* tp_members */
    _RichTruthHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_RichTruthHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _RichTruthHit_new,              /* tp_new */
};



// wrap element class hddm_s::RichTruthPoint as hddm_s.RichTruthPoint

typedef struct {
   PyObject_HEAD
   RichTruthPoint *elem;
   PyObject *host;
} _RichTruthPoint;

static void
_RichTruthPoint_dealloc(_RichTruthPoint* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_RichTruthPoint_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _RichTruthPoint *self;
   self = (_RichTruthPoint*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_RichTruthPoint_init(_RichTruthPoint *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_RichTruthPoint_getClass(_RichTruthPoint *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_RichTruthPoint_getVersion(_RichTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_RichTruthPoint_getXmlns(_RichTruthPoint *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_RichTruthPoint_getEventNo(_RichTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_RichTruthPoint_getRunNo(_RichTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_RichTruthPoint_getE(_RichTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_RichTruthPoint_setE(_RichTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_RichTruthPoint_getMaxOccurs(_RichTruthPoint *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_RichTruthPoint_getMinOccurs(_RichTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_RichTruthPoint_getPrimary(_RichTruthPoint *self, void *closure)
{
   return PyBool_FromLong(self->elem->getPrimary());
}

static int
_RichTruthPoint_setPrimary(_RichTruthPoint *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPrimary((var==0)? false : true);
   return 0;
}

static PyObject*
_RichTruthPoint_getPtype(_RichTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPtype());
}

static int
_RichTruthPoint_setPtype(_RichTruthPoint *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPtype(var);
   return 0;
}

static PyObject*
_RichTruthPoint_getPx(_RichTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPx());
}

static int
_RichTruthPoint_setPx(_RichTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPx((float)var);
   return 0;
}

static PyObject*
_RichTruthPoint_getPy(_RichTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPy());
}

static int
_RichTruthPoint_setPy(_RichTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPy((float)var);
   return 0;
}

static PyObject*
_RichTruthPoint_getPz(_RichTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPz());
}

static int
_RichTruthPoint_setPz(_RichTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPz((float)var);
   return 0;
}

static PyObject*
_RichTruthPoint_getT(_RichTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_RichTruthPoint_setT(_RichTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_RichTruthPoint_getTrack(_RichTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static int
_RichTruthPoint_setTrack(_RichTruthPoint *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTrack(var);
   return 0;
}

static PyObject*
_RichTruthPoint_getX(_RichTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static int
_RichTruthPoint_setX(_RichTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setX((float)var);
   return 0;
}

static PyObject*
_RichTruthPoint_getY(_RichTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static int
_RichTruthPoint_setY(_RichTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setY((float)var);
   return 0;
}

static PyObject*
_RichTruthPoint_getZ(_RichTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static int
_RichTruthPoint_setZ(_RichTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ((float)var);
   return 0;
}

static PyObject*
_RichTruthPoint_getTrackID(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _RichTruthPoint *me = (_RichTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid richTruthPoint element");
      return NULL;
   }
   PyObject *obj = _TrackID_new(&_TrackID_type, 0, 0);
   ((_TrackID*)obj)->elem = &me->elem->getTrackID();
   ((_TrackID*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_RichTruthPoint_getTrackIDs(PyObject *self, PyObject *args)
{
   _RichTruthPoint *me = (_RichTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid richTruthPoint element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackID_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTrackIDs();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_RichTruthPoint_addTrackIDs(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _RichTruthPoint *me = (_RichTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid richTruthPoint element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackID_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TrackIDList(me->elem->addTrackIDs(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_RichTruthPoint_deleteTrackIDs(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _RichTruthPoint *me = (_RichTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid richTruthPoint element");
      return NULL;
   }
   me->elem->deleteTrackIDs(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_RichTruthPoint_toString(PyObject *self, PyObject *args=0)
{
   _RichTruthPoint *me = (_RichTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid richTruthPoint element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_RichTruthPoint_toXML(PyObject *self, PyObject *args=0)
{
   _RichTruthPoint *me = (_RichTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid richTruthPoint element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _RichTruthPoint_getsetters[] = {
   {(char*)"E",
    (getter)_RichTruthPoint_getE, (setter)_RichTruthPoint_setE,
    (char*)"E value",
    NULL},
   {(char*)"class",
    (getter)_RichTruthPoint_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_RichTruthPoint_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_RichTruthPoint_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_RichTruthPoint_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"primary",
    (getter)_RichTruthPoint_getPrimary, (setter)_RichTruthPoint_setPrimary,
    (char*)"primary value",
    NULL},
   {(char*)"ptype",
    (getter)_RichTruthPoint_getPtype, (setter)_RichTruthPoint_setPtype,
    (char*)"ptype value",
    NULL},
   {(char*)"px",
    (getter)_RichTruthPoint_getPx, (setter)_RichTruthPoint_setPx,
    (char*)"px value",
    NULL},
   {(char*)"py",
    (getter)_RichTruthPoint_getPy, (setter)_RichTruthPoint_setPy,
    (char*)"py value",
    NULL},
   {(char*)"pz",
    (getter)_RichTruthPoint_getPz, (setter)_RichTruthPoint_setPz,
    (char*)"pz value",
    NULL},
   {(char*)"runNo",
    (getter)_RichTruthPoint_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_RichTruthPoint_getT, (setter)_RichTruthPoint_setT,
    (char*)"t value",
    NULL},
   {(char*)"track",
    (getter)_RichTruthPoint_getTrack, (setter)_RichTruthPoint_setTrack,
    (char*)"track value",
    NULL},
   {(char*)"version",
    (getter)_RichTruthPoint_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"x",
    (getter)_RichTruthPoint_getX, (setter)_RichTruthPoint_setX,
    (char*)"x value",
    NULL},
   {(char*)"xmlns",
    (getter)_RichTruthPoint_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y",
    (getter)_RichTruthPoint_getY, (setter)_RichTruthPoint_setY,
    (char*)"y value",
    NULL},
   {(char*)"z",
    (getter)_RichTruthPoint_getZ, (setter)_RichTruthPoint_setZ,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _RichTruthPoint_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _RichTruthPoint_methods[] = {
   {"addTrackIDs", _RichTruthPoint_addTrackIDs, METH_VARARGS,
    "extend (or insert into) the list of trackID objects for this richTruthPoint"},
   {"deleteTrackIDs", _RichTruthPoint_deleteTrackIDs, METH_VARARGS,
    "delete trackID objects for this richTruthPoint"},
   {"getTrackID", _RichTruthPoint_getTrackID, METH_VARARGS,
    "get an individual trackID object from this richTruthPoint"},
   {"getTrackIDs", _RichTruthPoint_getTrackIDs, METH_NOARGS,
    "get list of trackID objects for this richTruthPoint"},
   {"toString", _RichTruthPoint_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _RichTruthPoint_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _RichTruthPoint_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.RichTruthPoint",         /*tp_name*/
    sizeof(_RichTruthPoint),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_RichTruthPoint_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_RichTruthPoint_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s richTruthPoint element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _RichTruthPoint_methods,          /* tp_methods */
    _RichTruthPoint_members,          /* tp_members */
    _RichTruthPoint_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_RichTruthPoint_init,   /* tp_init */
    0,                         /* tp_alloc */
    _RichTruthPoint_new,              /* tp_new */
};



// wrap element class hddm_s::RICH as hddm_s.RICH

typedef struct {
   PyObject_HEAD
   RICH *elem;
   PyObject *host;
} _RICH;

static void
_RICH_dealloc(_RICH* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_RICH_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _RICH *self;
   self = (_RICH*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_RICH_init(_RICH *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_RICH_getClass(_RICH *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_RICH_getVersion(_RICH *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_RICH_getXmlns(_RICH *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_RICH_getEventNo(_RICH *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_RICH_getMaxOccurs(_RICH *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_RICH_getRunNo(_RICH *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_RICH_getMinOccurs(_RICH *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_RICH_getRichTruthHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _RICH *me = (_RICH*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid RICH element");
      return NULL;
   }
   PyObject *obj = _RichTruthHit_new(&_RichTruthHit_type, 0, 0);
   ((_RichTruthHit*)obj)->elem = &me->elem->getRichTruthHit(index);
   ((_RichTruthHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_RICH_getRichTruthHits(PyObject *self, PyObject *args)
{
   _RICH *me = (_RICH*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid RICH element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_RichTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getRichTruthHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_RICH_addRichTruthHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _RICH *me = (_RICH*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid RICH element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_RichTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new RichTruthHitList(me->elem->addRichTruthHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_RICH_deleteRichTruthHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _RICH *me = (_RICH*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid RICH element");
      return NULL;
   }
   me->elem->deleteRichTruthHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_RICH_getRichTruthPoint(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _RICH *me = (_RICH*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid RICH element");
      return NULL;
   }
   PyObject *obj = _RichTruthPoint_new(&_RichTruthPoint_type, 0, 0);
   ((_RichTruthPoint*)obj)->elem = &me->elem->getRichTruthPoint(index);
   ((_RichTruthPoint*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_RICH_getRichTruthPoints(PyObject *self, PyObject *args)
{
   _RICH *me = (_RICH*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid RICH element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_RichTruthPoint_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getRichTruthPoints();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_RICH_addRichTruthPoints(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _RICH *me = (_RICH*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid RICH element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_RichTruthPoint_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new RichTruthPointList(me->elem->addRichTruthPoints(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_RICH_deleteRichTruthPoints(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _RICH *me = (_RICH*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid RICH element");
      return NULL;
   }
   me->elem->deleteRichTruthPoints(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_RICH_toString(PyObject *self, PyObject *args=0)
{
   _RICH *me = (_RICH*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid RICH element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_RICH_toXML(PyObject *self, PyObject *args=0)
{
   _RICH *me = (_RICH*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid RICH element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _RICH_getsetters[] = {
   {(char*)"class",
    (getter)_RICH_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_RICH_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_RICH_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_RICH_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_RICH_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_RICH_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_RICH_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _RICH_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _RICH_methods[] = {
   {"addRichTruthHits", _RICH_addRichTruthHits, METH_VARARGS,
    "extend (or insert into) the list of richTruthHit objects for this RICH"},
   {"addRichTruthPoints", _RICH_addRichTruthPoints, METH_VARARGS,
    "extend (or insert into) the list of richTruthPoint objects for this RICH"},
   {"deleteRichTruthHits", _RICH_deleteRichTruthHits, METH_VARARGS,
    "delete richTruthHit objects for this RICH"},
   {"deleteRichTruthPoints", _RICH_deleteRichTruthPoints, METH_VARARGS,
    "delete richTruthPoint objects for this RICH"},
   {"getRichTruthHit", _RICH_getRichTruthHit, METH_VARARGS,
    "get an individual richTruthHit object from this RICH"},
   {"getRichTruthHits", _RICH_getRichTruthHits, METH_NOARGS,
    "get list of richTruthHit objects for this RICH"},
   {"getRichTruthPoint", _RICH_getRichTruthPoint, METH_VARARGS,
    "get an individual richTruthPoint object from this RICH"},
   {"getRichTruthPoints", _RICH_getRichTruthPoints, METH_NOARGS,
    "get list of richTruthPoint objects for this RICH"},
   {"toString", _RICH_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _RICH_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _RICH_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.RICH",         /*tp_name*/
    sizeof(_RICH),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_RICH_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_RICH_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s RICH element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _RICH_methods,          /* tp_methods */
    _RICH_members,          /* tp_members */
    _RICH_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_RICH_init,   /* tp_init */
    0,                         /* tp_alloc */
    _RICH_new,              /* tp_new */
};



// wrap element class hddm_s::DircTruthBarHit as hddm_s.DircTruthBarHit

typedef struct {
   PyObject_HEAD
   DircTruthBarHit *elem;
   PyObject *host;
} _DircTruthBarHit;

static void
_DircTruthBarHit_dealloc(_DircTruthBarHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_DircTruthBarHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _DircTruthBarHit *self;
   self = (_DircTruthBarHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_DircTruthBarHit_init(_DircTruthBarHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_DircTruthBarHit_getClass(_DircTruthBarHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircTruthBarHit_getVersion(_DircTruthBarHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_DircTruthBarHit_getXmlns(_DircTruthBarHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircTruthBarHit_getEventNo(_DircTruthBarHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_DircTruthBarHit_getRunNo(_DircTruthBarHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_DircTruthBarHit_getE(_DircTruthBarHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_DircTruthBarHit_setE(_DircTruthBarHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_DircTruthBarHit_getBar(_DircTruthBarHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getBar());
}

static int
_DircTruthBarHit_setBar(_DircTruthBarHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setBar(var);
   return 0;
}

static PyObject*
_DircTruthBarHit_getMaxOccurs(_DircTruthBarHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircTruthBarHit_getMinOccurs(_DircTruthBarHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_DircTruthBarHit_getPdg(_DircTruthBarHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPdg());
}

static int
_DircTruthBarHit_setPdg(_DircTruthBarHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPdg(var);
   return 0;
}

static PyObject*
_DircTruthBarHit_getPx(_DircTruthBarHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPx());
}

static int
_DircTruthBarHit_setPx(_DircTruthBarHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPx((float)var);
   return 0;
}

static PyObject*
_DircTruthBarHit_getPy(_DircTruthBarHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPy());
}

static int
_DircTruthBarHit_setPy(_DircTruthBarHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPy((float)var);
   return 0;
}

static PyObject*
_DircTruthBarHit_getPz(_DircTruthBarHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPz());
}

static int
_DircTruthBarHit_setPz(_DircTruthBarHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPz((float)var);
   return 0;
}

static PyObject*
_DircTruthBarHit_getT(_DircTruthBarHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_DircTruthBarHit_setT(_DircTruthBarHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_DircTruthBarHit_getTrack(_DircTruthBarHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static int
_DircTruthBarHit_setTrack(_DircTruthBarHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTrack(var);
   return 0;
}

static PyObject*
_DircTruthBarHit_getX(_DircTruthBarHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static int
_DircTruthBarHit_setX(_DircTruthBarHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setX((float)var);
   return 0;
}

static PyObject*
_DircTruthBarHit_getY(_DircTruthBarHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static int
_DircTruthBarHit_setY(_DircTruthBarHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setY((float)var);
   return 0;
}

static PyObject*
_DircTruthBarHit_getZ(_DircTruthBarHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static int
_DircTruthBarHit_setZ(_DircTruthBarHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ((float)var);
   return 0;
}

static PyObject*
_DircTruthBarHit_toString(PyObject *self, PyObject *args=0)
{
   _DircTruthBarHit *me = (_DircTruthBarHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dircTruthBarHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_DircTruthBarHit_toXML(PyObject *self, PyObject *args=0)
{
   _DircTruthBarHit *me = (_DircTruthBarHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dircTruthBarHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _DircTruthBarHit_getsetters[] = {
   {(char*)"E",
    (getter)_DircTruthBarHit_getE, (setter)_DircTruthBarHit_setE,
    (char*)"E value",
    NULL},
   {(char*)"bar",
    (getter)_DircTruthBarHit_getBar, (setter)_DircTruthBarHit_setBar,
    (char*)"bar value",
    NULL},
   {(char*)"class",
    (getter)_DircTruthBarHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_DircTruthBarHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_DircTruthBarHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_DircTruthBarHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"pdg",
    (getter)_DircTruthBarHit_getPdg, (setter)_DircTruthBarHit_setPdg,
    (char*)"pdg value",
    NULL},
   {(char*)"px",
    (getter)_DircTruthBarHit_getPx, (setter)_DircTruthBarHit_setPx,
    (char*)"px value",
    NULL},
   {(char*)"py",
    (getter)_DircTruthBarHit_getPy, (setter)_DircTruthBarHit_setPy,
    (char*)"py value",
    NULL},
   {(char*)"pz",
    (getter)_DircTruthBarHit_getPz, (setter)_DircTruthBarHit_setPz,
    (char*)"pz value",
    NULL},
   {(char*)"runNo",
    (getter)_DircTruthBarHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_DircTruthBarHit_getT, (setter)_DircTruthBarHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"track",
    (getter)_DircTruthBarHit_getTrack, (setter)_DircTruthBarHit_setTrack,
    (char*)"track value",
    NULL},
   {(char*)"version",
    (getter)_DircTruthBarHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"x",
    (getter)_DircTruthBarHit_getX, (setter)_DircTruthBarHit_setX,
    (char*)"x value",
    NULL},
   {(char*)"xmlns",
    (getter)_DircTruthBarHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y",
    (getter)_DircTruthBarHit_getY, (setter)_DircTruthBarHit_setY,
    (char*)"y value",
    NULL},
   {(char*)"z",
    (getter)_DircTruthBarHit_getZ, (setter)_DircTruthBarHit_setZ,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _DircTruthBarHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _DircTruthBarHit_methods[] = {
   {"toString", _DircTruthBarHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _DircTruthBarHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _DircTruthBarHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.DircTruthBarHit",         /*tp_name*/
    sizeof(_DircTruthBarHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_DircTruthBarHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_DircTruthBarHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s dircTruthBarHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _DircTruthBarHit_methods,          /* tp_methods */
    _DircTruthBarHit_members,          /* tp_members */
    _DircTruthBarHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_DircTruthBarHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _DircTruthBarHit_new,              /* tp_new */
};



// wrap element class hddm_s::DircTruthPmtHitExtra as hddm_s.DircTruthPmtHitExtra

typedef struct {
   PyObject_HEAD
   DircTruthPmtHitExtra *elem;
   PyObject *host;
} _DircTruthPmtHitExtra;

static void
_DircTruthPmtHitExtra_dealloc(_DircTruthPmtHitExtra* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_DircTruthPmtHitExtra_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _DircTruthPmtHitExtra *self;
   self = (_DircTruthPmtHitExtra*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_DircTruthPmtHitExtra_init(_DircTruthPmtHitExtra *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_DircTruthPmtHitExtra_getClass(_DircTruthPmtHitExtra *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircTruthPmtHitExtra_getVersion(_DircTruthPmtHitExtra *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_DircTruthPmtHitExtra_getXmlns(_DircTruthPmtHitExtra *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircTruthPmtHitExtra_getEventNo(_DircTruthPmtHitExtra *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_DircTruthPmtHitExtra_getRunNo(_DircTruthPmtHitExtra *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_DircTruthPmtHitExtra_getE(_DircTruthPmtHitExtra *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static PyObject*
_DircTruthPmtHitExtra_getCh(_DircTruthPmtHitExtra *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCh());
}

static PyObject*
_DircTruthPmtHitExtra_getKey_bar(_DircTruthPmtHitExtra *self, void *closure)
{
   return PyLong_FromLong(self->elem->getKey_bar());
}

static PyObject*
_DircTruthPmtHitExtra_getT(_DircTruthPmtHitExtra *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_DircTruthPmtHitExtra_getX(_DircTruthPmtHitExtra *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static PyObject*
_DircTruthPmtHitExtra_getY(_DircTruthPmtHitExtra *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static PyObject*
_DircTruthPmtHitExtra_getZ(_DircTruthPmtHitExtra *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static PyObject*
_DircTruthPmtHitExtra_getBbrefl(_DircTruthPmtHitExtra *self, void *closure)
{
   return PyBool_FromLong(self->elem->getBbrefl());
}

static int
_DircTruthPmtHitExtra_setBbrefl(_DircTruthPmtHitExtra *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setBbrefl((var==0)? false : true);
   return 0;
}

static PyObject*
_DircTruthPmtHitExtra_getMaxOccurs(_DircTruthPmtHitExtra *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircTruthPmtHitExtra_getMinOccurs(_DircTruthPmtHitExtra *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_DircTruthPmtHitExtra_getPath(_DircTruthPmtHitExtra *self, void *closure)
{
   return PyLong_FromLongLong(self->elem->getPath());
}

static int
_DircTruthPmtHitExtra_setPath(_DircTruthPmtHitExtra *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPath(var);
   return 0;
}

static PyObject*
_DircTruthPmtHitExtra_getRefl(_DircTruthPmtHitExtra *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRefl());
}

static int
_DircTruthPmtHitExtra_setRefl(_DircTruthPmtHitExtra *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setRefl(var);
   return 0;
}

static PyObject*
_DircTruthPmtHitExtra_getT_fixed(_DircTruthPmtHitExtra *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT_fixed());
}

static int
_DircTruthPmtHitExtra_setT_fixed(_DircTruthPmtHitExtra *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT_fixed((float)var);
   return 0;
}

static PyObject*
_DircTruthPmtHitExtra_toString(PyObject *self, PyObject *args=0)
{
   _DircTruthPmtHitExtra *me = (_DircTruthPmtHitExtra*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dircTruthPmtHitExtra element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_DircTruthPmtHitExtra_toXML(PyObject *self, PyObject *args=0)
{
   _DircTruthPmtHitExtra *me = (_DircTruthPmtHitExtra*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dircTruthPmtHitExtra element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _DircTruthPmtHitExtra_getsetters[] = {
   {(char*)"E",
    (getter)_DircTruthPmtHitExtra_getE, 0,
    (char*)"E value",
    NULL},
   {(char*)"bbrefl",
    (getter)_DircTruthPmtHitExtra_getBbrefl, (setter)_DircTruthPmtHitExtra_setBbrefl,
    (char*)"bbrefl value",
    NULL},
   {(char*)"ch",
    (getter)_DircTruthPmtHitExtra_getCh, 0,
    (char*)"ch value",
    NULL},
   {(char*)"class",
    (getter)_DircTruthPmtHitExtra_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_DircTruthPmtHitExtra_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"key_bar",
    (getter)_DircTruthPmtHitExtra_getKey_bar, 0,
    (char*)"key_bar value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_DircTruthPmtHitExtra_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_DircTruthPmtHitExtra_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"path",
    (getter)_DircTruthPmtHitExtra_getPath, (setter)_DircTruthPmtHitExtra_setPath,
    (char*)"path value",
    NULL},
   {(char*)"refl",
    (getter)_DircTruthPmtHitExtra_getRefl, (setter)_DircTruthPmtHitExtra_setRefl,
    (char*)"refl value",
    NULL},
   {(char*)"runNo",
    (getter)_DircTruthPmtHitExtra_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_DircTruthPmtHitExtra_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"t_fixed",
    (getter)_DircTruthPmtHitExtra_getT_fixed, (setter)_DircTruthPmtHitExtra_setT_fixed,
    (char*)"t_fixed value",
    NULL},
   {(char*)"version",
    (getter)_DircTruthPmtHitExtra_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"x",
    (getter)_DircTruthPmtHitExtra_getX, 0,
    (char*)"x value",
    NULL},
   {(char*)"xmlns",
    (getter)_DircTruthPmtHitExtra_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y",
    (getter)_DircTruthPmtHitExtra_getY, 0,
    (char*)"y value",
    NULL},
   {(char*)"z",
    (getter)_DircTruthPmtHitExtra_getZ, 0,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _DircTruthPmtHitExtra_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _DircTruthPmtHitExtra_methods[] = {
   {"toString", _DircTruthPmtHitExtra_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _DircTruthPmtHitExtra_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _DircTruthPmtHitExtra_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.DircTruthPmtHitExtra",         /*tp_name*/
    sizeof(_DircTruthPmtHitExtra),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_DircTruthPmtHitExtra_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_DircTruthPmtHitExtra_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s dircTruthPmtHitExtra element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _DircTruthPmtHitExtra_methods,          /* tp_methods */
    _DircTruthPmtHitExtra_members,          /* tp_members */
    _DircTruthPmtHitExtra_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_DircTruthPmtHitExtra_init,   /* tp_init */
    0,                         /* tp_alloc */
    _DircTruthPmtHitExtra_new,              /* tp_new */
};



// wrap element class hddm_s::DircTruthPmtHit as hddm_s.DircTruthPmtHit

typedef struct {
   PyObject_HEAD
   DircTruthPmtHit *elem;
   PyObject *host;
} _DircTruthPmtHit;

static void
_DircTruthPmtHit_dealloc(_DircTruthPmtHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_DircTruthPmtHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _DircTruthPmtHit *self;
   self = (_DircTruthPmtHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_DircTruthPmtHit_init(_DircTruthPmtHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_DircTruthPmtHit_getClass(_DircTruthPmtHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircTruthPmtHit_getVersion(_DircTruthPmtHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_DircTruthPmtHit_getXmlns(_DircTruthPmtHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircTruthPmtHit_getEventNo(_DircTruthPmtHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_DircTruthPmtHit_getRunNo(_DircTruthPmtHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_DircTruthPmtHit_getE(_DircTruthPmtHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_DircTruthPmtHit_setE(_DircTruthPmtHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_DircTruthPmtHit_getCh(_DircTruthPmtHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCh());
}

static int
_DircTruthPmtHit_setCh(_DircTruthPmtHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setCh(var);
   return 0;
}

static PyObject*
_DircTruthPmtHit_getKey_bar(_DircTruthPmtHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getKey_bar());
}

static int
_DircTruthPmtHit_setKey_bar(_DircTruthPmtHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setKey_bar(var);
   return 0;
}

static PyObject*
_DircTruthPmtHit_getMaxOccurs(_DircTruthPmtHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircTruthPmtHit_getMinOccurs(_DircTruthPmtHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_DircTruthPmtHit_getT(_DircTruthPmtHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_DircTruthPmtHit_setT(_DircTruthPmtHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_DircTruthPmtHit_getX(_DircTruthPmtHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static int
_DircTruthPmtHit_setX(_DircTruthPmtHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setX((float)var);
   return 0;
}

static PyObject*
_DircTruthPmtHit_getY(_DircTruthPmtHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static int
_DircTruthPmtHit_setY(_DircTruthPmtHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setY((float)var);
   return 0;
}

static PyObject*
_DircTruthPmtHit_getZ(_DircTruthPmtHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static int
_DircTruthPmtHit_setZ(_DircTruthPmtHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ((float)var);
   return 0;
}

static PyObject*
_DircTruthPmtHit_getDircTruthPmtHitExtra(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _DircTruthPmtHit *me = (_DircTruthPmtHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dircTruthPmtHit element");
      return NULL;
   }
   PyObject *obj = _DircTruthPmtHitExtra_new(&_DircTruthPmtHitExtra_type, 0, 0);
   ((_DircTruthPmtHitExtra*)obj)->elem = &me->elem->getDircTruthPmtHitExtra(index);
   ((_DircTruthPmtHitExtra*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_DircTruthPmtHit_getDircTruthPmtHitExtras(PyObject *self, PyObject *args)
{
   _DircTruthPmtHit *me = (_DircTruthPmtHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dircTruthPmtHit element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DircTruthPmtHitExtra_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getDircTruthPmtHitExtras();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_DircTruthPmtHit_addDircTruthPmtHitExtras(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DircTruthPmtHit *me = (_DircTruthPmtHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid dircTruthPmtHit element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DircTruthPmtHitExtra_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new DircTruthPmtHitExtraList(me->elem->addDircTruthPmtHitExtras(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_DircTruthPmtHit_deleteDircTruthPmtHitExtras(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DircTruthPmtHit *me = (_DircTruthPmtHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid dircTruthPmtHit element");
      return NULL;
   }
   me->elem->deleteDircTruthPmtHitExtras(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_DircTruthPmtHit_toString(PyObject *self, PyObject *args=0)
{
   _DircTruthPmtHit *me = (_DircTruthPmtHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dircTruthPmtHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_DircTruthPmtHit_toXML(PyObject *self, PyObject *args=0)
{
   _DircTruthPmtHit *me = (_DircTruthPmtHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dircTruthPmtHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _DircTruthPmtHit_getsetters[] = {
   {(char*)"E",
    (getter)_DircTruthPmtHit_getE, (setter)_DircTruthPmtHit_setE,
    (char*)"E value",
    NULL},
   {(char*)"ch",
    (getter)_DircTruthPmtHit_getCh, (setter)_DircTruthPmtHit_setCh,
    (char*)"ch value",
    NULL},
   {(char*)"class",
    (getter)_DircTruthPmtHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_DircTruthPmtHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"key_bar",
    (getter)_DircTruthPmtHit_getKey_bar, (setter)_DircTruthPmtHit_setKey_bar,
    (char*)"key_bar value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_DircTruthPmtHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_DircTruthPmtHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_DircTruthPmtHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_DircTruthPmtHit_getT, (setter)_DircTruthPmtHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_DircTruthPmtHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"x",
    (getter)_DircTruthPmtHit_getX, (setter)_DircTruthPmtHit_setX,
    (char*)"x value",
    NULL},
   {(char*)"xmlns",
    (getter)_DircTruthPmtHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y",
    (getter)_DircTruthPmtHit_getY, (setter)_DircTruthPmtHit_setY,
    (char*)"y value",
    NULL},
   {(char*)"z",
    (getter)_DircTruthPmtHit_getZ, (setter)_DircTruthPmtHit_setZ,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _DircTruthPmtHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _DircTruthPmtHit_methods[] = {
   {"addDircTruthPmtHitExtras", _DircTruthPmtHit_addDircTruthPmtHitExtras, METH_VARARGS,
    "extend (or insert into) the list of dircTruthPmtHitExtra objects for this dircTruthPmtHit"},
   {"deleteDircTruthPmtHitExtras", _DircTruthPmtHit_deleteDircTruthPmtHitExtras, METH_VARARGS,
    "delete dircTruthPmtHitExtra objects for this dircTruthPmtHit"},
   {"getDircTruthPmtHitExtra", _DircTruthPmtHit_getDircTruthPmtHitExtra, METH_VARARGS,
    "get an individual dircTruthPmtHitExtra object from this dircTruthPmtHit"},
   {"getDircTruthPmtHitExtras", _DircTruthPmtHit_getDircTruthPmtHitExtras, METH_NOARGS,
    "get list of dircTruthPmtHitExtra objects for this dircTruthPmtHit"},
   {"toString", _DircTruthPmtHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _DircTruthPmtHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _DircTruthPmtHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.DircTruthPmtHit",         /*tp_name*/
    sizeof(_DircTruthPmtHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_DircTruthPmtHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_DircTruthPmtHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s dircTruthPmtHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _DircTruthPmtHit_methods,          /* tp_methods */
    _DircTruthPmtHit_members,          /* tp_members */
    _DircTruthPmtHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_DircTruthPmtHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _DircTruthPmtHit_new,              /* tp_new */
};



// wrap element class hddm_s::DircPmtHit as hddm_s.DircPmtHit

typedef struct {
   PyObject_HEAD
   DircPmtHit *elem;
   PyObject *host;
} _DircPmtHit;

static void
_DircPmtHit_dealloc(_DircPmtHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_DircPmtHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _DircPmtHit *self;
   self = (_DircPmtHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_DircPmtHit_init(_DircPmtHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_DircPmtHit_getClass(_DircPmtHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircPmtHit_getVersion(_DircPmtHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_DircPmtHit_getXmlns(_DircPmtHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircPmtHit_getEventNo(_DircPmtHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_DircPmtHit_getRunNo(_DircPmtHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_DircPmtHit_getCh(_DircPmtHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getCh());
}

static int
_DircPmtHit_setCh(_DircPmtHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setCh(var);
   return 0;
}

static PyObject*
_DircPmtHit_getMaxOccurs(_DircPmtHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DircPmtHit_getMinOccurs(_DircPmtHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_DircPmtHit_getT(_DircPmtHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_DircPmtHit_setT(_DircPmtHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_DircPmtHit_toString(PyObject *self, PyObject *args=0)
{
   _DircPmtHit *me = (_DircPmtHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dircPmtHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_DircPmtHit_toXML(PyObject *self, PyObject *args=0)
{
   _DircPmtHit *me = (_DircPmtHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid dircPmtHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _DircPmtHit_getsetters[] = {
   {(char*)"ch",
    (getter)_DircPmtHit_getCh, (setter)_DircPmtHit_setCh,
    (char*)"ch value",
    NULL},
   {(char*)"class",
    (getter)_DircPmtHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_DircPmtHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_DircPmtHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_DircPmtHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_DircPmtHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_DircPmtHit_getT, (setter)_DircPmtHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_DircPmtHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_DircPmtHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _DircPmtHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _DircPmtHit_methods[] = {
   {"toString", _DircPmtHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _DircPmtHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _DircPmtHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.DircPmtHit",         /*tp_name*/
    sizeof(_DircPmtHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_DircPmtHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_DircPmtHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s dircPmtHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _DircPmtHit_methods,          /* tp_methods */
    _DircPmtHit_members,          /* tp_members */
    _DircPmtHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_DircPmtHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _DircPmtHit_new,              /* tp_new */
};



// wrap element class hddm_s::DIRC as hddm_s.DIRC

typedef struct {
   PyObject_HEAD
   DIRC *elem;
   PyObject *host;
} _DIRC;

static void
_DIRC_dealloc(_DIRC* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_DIRC_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _DIRC *self;
   self = (_DIRC*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_DIRC_init(_DIRC *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_DIRC_getClass(_DIRC *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DIRC_getVersion(_DIRC *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_DIRC_getXmlns(_DIRC *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DIRC_getEventNo(_DIRC *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_DIRC_getMaxOccurs(_DIRC *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_DIRC_getRunNo(_DIRC *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_DIRC_getMinOccurs(_DIRC *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_DIRC_getDircTruthBarHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _DIRC *me = (_DIRC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid DIRC element");
      return NULL;
   }
   PyObject *obj = _DircTruthBarHit_new(&_DircTruthBarHit_type, 0, 0);
   ((_DircTruthBarHit*)obj)->elem = &me->elem->getDircTruthBarHit(index);
   ((_DircTruthBarHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_DIRC_getDircTruthBarHits(PyObject *self, PyObject *args)
{
   _DIRC *me = (_DIRC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid DIRC element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DircTruthBarHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getDircTruthBarHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_DIRC_addDircTruthBarHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DIRC *me = (_DIRC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid DIRC element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DircTruthBarHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new DircTruthBarHitList(me->elem->addDircTruthBarHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_DIRC_deleteDircTruthBarHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DIRC *me = (_DIRC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid DIRC element");
      return NULL;
   }
   me->elem->deleteDircTruthBarHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_DIRC_getDircTruthPmtHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _DIRC *me = (_DIRC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid DIRC element");
      return NULL;
   }
   PyObject *obj = _DircTruthPmtHit_new(&_DircTruthPmtHit_type, 0, 0);
   ((_DircTruthPmtHit*)obj)->elem = &me->elem->getDircTruthPmtHit(index);
   ((_DircTruthPmtHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_DIRC_getDircTruthPmtHits(PyObject *self, PyObject *args)
{
   _DIRC *me = (_DIRC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid DIRC element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DircTruthPmtHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getDircTruthPmtHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_DIRC_addDircTruthPmtHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DIRC *me = (_DIRC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid DIRC element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DircTruthPmtHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new DircTruthPmtHitList(me->elem->addDircTruthPmtHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_DIRC_deleteDircTruthPmtHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DIRC *me = (_DIRC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid DIRC element");
      return NULL;
   }
   me->elem->deleteDircTruthPmtHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_DIRC_getDircPmtHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _DIRC *me = (_DIRC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid DIRC element");
      return NULL;
   }
   PyObject *obj = _DircPmtHit_new(&_DircPmtHit_type, 0, 0);
   ((_DircPmtHit*)obj)->elem = &me->elem->getDircPmtHit(index);
   ((_DircPmtHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_DIRC_getDircPmtHits(PyObject *self, PyObject *args)
{
   _DIRC *me = (_DIRC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid DIRC element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DircPmtHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getDircPmtHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_DIRC_addDircPmtHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DIRC *me = (_DIRC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid DIRC element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_DircPmtHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new DircPmtHitList(me->elem->addDircPmtHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_DIRC_deleteDircPmtHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _DIRC *me = (_DIRC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid DIRC element");
      return NULL;
   }
   me->elem->deleteDircPmtHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_DIRC_toString(PyObject *self, PyObject *args=0)
{
   _DIRC *me = (_DIRC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid DIRC element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_DIRC_toXML(PyObject *self, PyObject *args=0)
{
   _DIRC *me = (_DIRC*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid DIRC element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _DIRC_getsetters[] = {
   {(char*)"class",
    (getter)_DIRC_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_DIRC_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_DIRC_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_DIRC_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_DIRC_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_DIRC_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_DIRC_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _DIRC_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _DIRC_methods[] = {
   {"addDircPmtHits", _DIRC_addDircPmtHits, METH_VARARGS,
    "extend (or insert into) the list of dircPmtHit objects for this DIRC"},
   {"addDircTruthBarHits", _DIRC_addDircTruthBarHits, METH_VARARGS,
    "extend (or insert into) the list of dircTruthBarHit objects for this DIRC"},
   {"addDircTruthPmtHits", _DIRC_addDircTruthPmtHits, METH_VARARGS,
    "extend (or insert into) the list of dircTruthPmtHit objects for this DIRC"},
   {"deleteDircPmtHits", _DIRC_deleteDircPmtHits, METH_VARARGS,
    "delete dircPmtHit objects for this DIRC"},
   {"deleteDircTruthBarHits", _DIRC_deleteDircTruthBarHits, METH_VARARGS,
    "delete dircTruthBarHit objects for this DIRC"},
   {"deleteDircTruthPmtHits", _DIRC_deleteDircTruthPmtHits, METH_VARARGS,
    "delete dircTruthPmtHit objects for this DIRC"},
   {"getDircPmtHit", _DIRC_getDircPmtHit, METH_VARARGS,
    "get an individual dircPmtHit object from this DIRC"},
   {"getDircPmtHits", _DIRC_getDircPmtHits, METH_NOARGS,
    "get list of dircPmtHit objects for this DIRC"},
   {"getDircTruthBarHit", _DIRC_getDircTruthBarHit, METH_VARARGS,
    "get an individual dircTruthBarHit object from this DIRC"},
   {"getDircTruthBarHits", _DIRC_getDircTruthBarHits, METH_NOARGS,
    "get list of dircTruthBarHit objects for this DIRC"},
   {"getDircTruthPmtHit", _DIRC_getDircTruthPmtHit, METH_VARARGS,
    "get an individual dircTruthPmtHit object from this DIRC"},
   {"getDircTruthPmtHits", _DIRC_getDircTruthPmtHits, METH_NOARGS,
    "get list of dircTruthPmtHit objects for this DIRC"},
   {"toString", _DIRC_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _DIRC_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _DIRC_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.DIRC",         /*tp_name*/
    sizeof(_DIRC),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_DIRC_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_DIRC_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s DIRC element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _DIRC_methods,          /* tp_methods */
    _DIRC_members,          /* tp_members */
    _DIRC_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_DIRC_init,   /* tp_init */
    0,                         /* tp_alloc */
    _DIRC_new,              /* tp_new */
};



// wrap element class hddm_s::FtofDigihit as hddm_s.FtofDigihit

typedef struct {
   PyObject_HEAD
   FtofDigihit *elem;
   PyObject *host;
} _FtofDigihit;

static void
_FtofDigihit_dealloc(_FtofDigihit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FtofDigihit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FtofDigihit *self;
   self = (_FtofDigihit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FtofDigihit_init(_FtofDigihit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FtofDigihit_getClass(_FtofDigihit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FtofDigihit_getVersion(_FtofDigihit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_FtofDigihit_getXmlns(_FtofDigihit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FtofDigihit_getEventNo(_FtofDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_FtofDigihit_getMaxOccurs(_FtofDigihit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FtofDigihit_getRunNo(_FtofDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FtofDigihit_getBar(_FtofDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getBar());
}

static PyObject*
_FtofDigihit_getPlane(_FtofDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPlane());
}

static PyObject*
_FtofDigihit_getDE(_FtofDigihit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDE());
}

static PyObject*
_FtofDigihit_getEnd(_FtofDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEnd());
}

static PyObject*
_FtofDigihit_getT(_FtofDigihit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_FtofDigihit_getMinOccurs(_FtofDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FtofDigihit_getPeakAmp(_FtofDigihit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPeakAmp());
}

static int
_FtofDigihit_setPeakAmp(_FtofDigihit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPeakAmp((float)var);
   return 0;
}

static PyObject*
_FtofDigihit_toString(PyObject *self, PyObject *args=0)
{
   _FtofDigihit *me = (_FtofDigihit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofDigihit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FtofDigihit_toXML(PyObject *self, PyObject *args=0)
{
   _FtofDigihit *me = (_FtofDigihit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofDigihit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FtofDigihit_getsetters[] = {
   {(char*)"bar",
    (getter)_FtofDigihit_getBar, 0,
    (char*)"bar value",
    NULL},
   {(char*)"class",
    (getter)_FtofDigihit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dE",
    (getter)_FtofDigihit_getDE, 0,
    (char*)"dE value",
    NULL},
   {(char*)"end",
    (getter)_FtofDigihit_getEnd, 0,
    (char*)"end value",
    NULL},
   {(char*)"eventNo",
    (getter)_FtofDigihit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FtofDigihit_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_FtofDigihit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"peakAmp",
    (getter)_FtofDigihit_getPeakAmp, (setter)_FtofDigihit_setPeakAmp,
    (char*)"peakAmp value",
    NULL},
   {(char*)"plane",
    (getter)_FtofDigihit_getPlane, 0,
    (char*)"plane value",
    NULL},
   {(char*)"runNo",
    (getter)_FtofDigihit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_FtofDigihit_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_FtofDigihit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_FtofDigihit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FtofDigihit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FtofDigihit_methods[] = {
   {"toString", _FtofDigihit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FtofDigihit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FtofDigihit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.FtofDigihit",         /*tp_name*/
    sizeof(_FtofDigihit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FtofDigihit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FtofDigihit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s ftofDigihit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FtofDigihit_methods,          /* tp_methods */
    _FtofDigihit_members,          /* tp_members */
    _FtofDigihit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FtofDigihit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FtofDigihit_new,              /* tp_new */
};



// wrap element class hddm_s::FtofHit as hddm_s.FtofHit

typedef struct {
   PyObject_HEAD
   FtofHit *elem;
   PyObject *host;
} _FtofHit;

static void
_FtofHit_dealloc(_FtofHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FtofHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FtofHit *self;
   self = (_FtofHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FtofHit_init(_FtofHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FtofHit_getClass(_FtofHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FtofHit_getVersion(_FtofHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_FtofHit_getXmlns(_FtofHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FtofHit_getEventNo(_FtofHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_FtofHit_getRunNo(_FtofHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FtofHit_getBar(_FtofHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getBar());
}

static PyObject*
_FtofHit_getPlane(_FtofHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPlane());
}

static PyObject*
_FtofHit_getDE(_FtofHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDE());
}

static int
_FtofHit_setDE(_FtofHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDE((float)var);
   return 0;
}

static PyObject*
_FtofHit_getEnd(_FtofHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEnd());
}

static int
_FtofHit_setEnd(_FtofHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setEnd(var);
   return 0;
}

static PyObject*
_FtofHit_getMaxOccurs(_FtofHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FtofHit_getMinOccurs(_FtofHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FtofHit_getT(_FtofHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_FtofHit_setT(_FtofHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_FtofHit_getFtofDigihit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FtofHit *me = (_FtofHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofHit element");
      return NULL;
   }
   PyObject *obj = _FtofDigihit_new(&_FtofDigihit_type, 0, 0);
   ((_FtofDigihit*)obj)->elem = &me->elem->getFtofDigihit();
   ((_FtofDigihit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FtofHit_getFtofDigihits(PyObject *self, PyObject *args)
{
   _FtofHit *me = (_FtofHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofHit element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FtofDigihit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFtofDigihits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FtofHit_addFtofDigihits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FtofHit *me = (_FtofHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid ftofHit element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FtofDigihit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FtofDigihitList(me->elem->addFtofDigihits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FtofHit_deleteFtofDigihits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FtofHit *me = (_FtofHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid ftofHit element");
      return NULL;
   }
   me->elem->deleteFtofDigihits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FtofHit_toString(PyObject *self, PyObject *args=0)
{
   _FtofHit *me = (_FtofHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FtofHit_toXML(PyObject *self, PyObject *args=0)
{
   _FtofHit *me = (_FtofHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FtofHit_getsetters[] = {
   {(char*)"bar",
    (getter)_FtofHit_getBar, 0,
    (char*)"bar value",
    NULL},
   {(char*)"class",
    (getter)_FtofHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dE",
    (getter)_FtofHit_getDE, (setter)_FtofHit_setDE,
    (char*)"dE value",
    NULL},
   {(char*)"end",
    (getter)_FtofHit_getEnd, (setter)_FtofHit_setEnd,
    (char*)"end value",
    NULL},
   {(char*)"eventNo",
    (getter)_FtofHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FtofHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FtofHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"plane",
    (getter)_FtofHit_getPlane, 0,
    (char*)"plane value",
    NULL},
   {(char*)"runNo",
    (getter)_FtofHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_FtofHit_getT, (setter)_FtofHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_FtofHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_FtofHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FtofHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FtofHit_methods[] = {
   {"addFtofDigihits", _FtofHit_addFtofDigihits, METH_VARARGS,
    "extend (or insert into) the list of ftofDigihit objects for this ftofHit"},
   {"deleteFtofDigihits", _FtofHit_deleteFtofDigihits, METH_VARARGS,
    "delete ftofDigihit objects for this ftofHit"},
   {"getFtofDigihit", _FtofHit_getFtofDigihit, METH_VARARGS,
    "get an individual ftofDigihit object from this ftofHit"},
   {"getFtofDigihits", _FtofHit_getFtofDigihits, METH_NOARGS,
    "get list of ftofDigihit objects for this ftofHit"},
   {"toString", _FtofHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FtofHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FtofHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.FtofHit",         /*tp_name*/
    sizeof(_FtofHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FtofHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FtofHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s ftofHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FtofHit_methods,          /* tp_methods */
    _FtofHit_members,          /* tp_members */
    _FtofHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FtofHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FtofHit_new,              /* tp_new */
};



// wrap element class hddm_s::FtofTruthExtra as hddm_s.FtofTruthExtra

typedef struct {
   PyObject_HEAD
   FtofTruthExtra *elem;
   PyObject *host;
} _FtofTruthExtra;

static void
_FtofTruthExtra_dealloc(_FtofTruthExtra* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FtofTruthExtra_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FtofTruthExtra *self;
   self = (_FtofTruthExtra*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FtofTruthExtra_init(_FtofTruthExtra *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FtofTruthExtra_getClass(_FtofTruthExtra *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FtofTruthExtra_getVersion(_FtofTruthExtra *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_FtofTruthExtra_getXmlns(_FtofTruthExtra *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FtofTruthExtra_getEventNo(_FtofTruthExtra *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_FtofTruthExtra_getRunNo(_FtofTruthExtra *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FtofTruthExtra_getBar(_FtofTruthExtra *self, void *closure)
{
   return PyLong_FromLong(self->elem->getBar());
}

static PyObject*
_FtofTruthExtra_getPlane(_FtofTruthExtra *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPlane());
}

static PyObject*
_FtofTruthExtra_getDE(_FtofTruthExtra *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDE());
}

static PyObject*
_FtofTruthExtra_getEnd(_FtofTruthExtra *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEnd());
}

static PyObject*
_FtofTruthExtra_getT(_FtofTruthExtra *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_FtofTruthExtra_getE(_FtofTruthExtra *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_FtofTruthExtra_setE(_FtofTruthExtra *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_FtofTruthExtra_getDist(_FtofTruthExtra *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDist());
}

static int
_FtofTruthExtra_setDist(_FtofTruthExtra *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDist((float)var);
   return 0;
}

static PyObject*
_FtofTruthExtra_getItrack(_FtofTruthExtra *self, void *closure)
{
   return PyLong_FromLong(self->elem->getItrack());
}

static int
_FtofTruthExtra_setItrack(_FtofTruthExtra *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setItrack(var);
   return 0;
}

static PyObject*
_FtofTruthExtra_getMaxOccurs(_FtofTruthExtra *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FtofTruthExtra_getMinOccurs(_FtofTruthExtra *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FtofTruthExtra_getPtype(_FtofTruthExtra *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPtype());
}

static int
_FtofTruthExtra_setPtype(_FtofTruthExtra *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPtype(var);
   return 0;
}

static PyObject*
_FtofTruthExtra_getPx(_FtofTruthExtra *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPx());
}

static int
_FtofTruthExtra_setPx(_FtofTruthExtra *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPx((float)var);
   return 0;
}

static PyObject*
_FtofTruthExtra_getPy(_FtofTruthExtra *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPy());
}

static int
_FtofTruthExtra_setPy(_FtofTruthExtra *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPy((float)var);
   return 0;
}

static PyObject*
_FtofTruthExtra_getPz(_FtofTruthExtra *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPz());
}

static int
_FtofTruthExtra_setPz(_FtofTruthExtra *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPz((float)var);
   return 0;
}

static PyObject*
_FtofTruthExtra_getX(_FtofTruthExtra *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static int
_FtofTruthExtra_setX(_FtofTruthExtra *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setX((float)var);
   return 0;
}

static PyObject*
_FtofTruthExtra_getY(_FtofTruthExtra *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static int
_FtofTruthExtra_setY(_FtofTruthExtra *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setY((float)var);
   return 0;
}

static PyObject*
_FtofTruthExtra_getZ(_FtofTruthExtra *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static int
_FtofTruthExtra_setZ(_FtofTruthExtra *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ((float)var);
   return 0;
}

static PyObject*
_FtofTruthExtra_toString(PyObject *self, PyObject *args=0)
{
   _FtofTruthExtra *me = (_FtofTruthExtra*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofTruthExtra element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FtofTruthExtra_toXML(PyObject *self, PyObject *args=0)
{
   _FtofTruthExtra *me = (_FtofTruthExtra*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofTruthExtra element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FtofTruthExtra_getsetters[] = {
   {(char*)"E",
    (getter)_FtofTruthExtra_getE, (setter)_FtofTruthExtra_setE,
    (char*)"E value",
    NULL},
   {(char*)"bar",
    (getter)_FtofTruthExtra_getBar, 0,
    (char*)"bar value",
    NULL},
   {(char*)"class",
    (getter)_FtofTruthExtra_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dE",
    (getter)_FtofTruthExtra_getDE, 0,
    (char*)"dE value",
    NULL},
   {(char*)"dist",
    (getter)_FtofTruthExtra_getDist, (setter)_FtofTruthExtra_setDist,
    (char*)"dist value",
    NULL},
   {(char*)"end",
    (getter)_FtofTruthExtra_getEnd, 0,
    (char*)"end value",
    NULL},
   {(char*)"eventNo",
    (getter)_FtofTruthExtra_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"itrack",
    (getter)_FtofTruthExtra_getItrack, (setter)_FtofTruthExtra_setItrack,
    (char*)"itrack value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FtofTruthExtra_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FtofTruthExtra_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"plane",
    (getter)_FtofTruthExtra_getPlane, 0,
    (char*)"plane value",
    NULL},
   {(char*)"ptype",
    (getter)_FtofTruthExtra_getPtype, (setter)_FtofTruthExtra_setPtype,
    (char*)"ptype value",
    NULL},
   {(char*)"px",
    (getter)_FtofTruthExtra_getPx, (setter)_FtofTruthExtra_setPx,
    (char*)"px value",
    NULL},
   {(char*)"py",
    (getter)_FtofTruthExtra_getPy, (setter)_FtofTruthExtra_setPy,
    (char*)"py value",
    NULL},
   {(char*)"pz",
    (getter)_FtofTruthExtra_getPz, (setter)_FtofTruthExtra_setPz,
    (char*)"pz value",
    NULL},
   {(char*)"runNo",
    (getter)_FtofTruthExtra_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_FtofTruthExtra_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_FtofTruthExtra_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"x",
    (getter)_FtofTruthExtra_getX, (setter)_FtofTruthExtra_setX,
    (char*)"x value",
    NULL},
   {(char*)"xmlns",
    (getter)_FtofTruthExtra_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y",
    (getter)_FtofTruthExtra_getY, (setter)_FtofTruthExtra_setY,
    (char*)"y value",
    NULL},
   {(char*)"z",
    (getter)_FtofTruthExtra_getZ, (setter)_FtofTruthExtra_setZ,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FtofTruthExtra_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FtofTruthExtra_methods[] = {
   {"toString", _FtofTruthExtra_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FtofTruthExtra_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FtofTruthExtra_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.FtofTruthExtra",         /*tp_name*/
    sizeof(_FtofTruthExtra),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FtofTruthExtra_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FtofTruthExtra_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s ftofTruthExtra element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FtofTruthExtra_methods,          /* tp_methods */
    _FtofTruthExtra_members,          /* tp_members */
    _FtofTruthExtra_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FtofTruthExtra_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FtofTruthExtra_new,              /* tp_new */
};



// wrap element class hddm_s::FtofTruthHit as hddm_s.FtofTruthHit

typedef struct {
   PyObject_HEAD
   FtofTruthHit *elem;
   PyObject *host;
} _FtofTruthHit;

static void
_FtofTruthHit_dealloc(_FtofTruthHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FtofTruthHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FtofTruthHit *self;
   self = (_FtofTruthHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FtofTruthHit_init(_FtofTruthHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FtofTruthHit_getClass(_FtofTruthHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FtofTruthHit_getVersion(_FtofTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_FtofTruthHit_getXmlns(_FtofTruthHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FtofTruthHit_getEventNo(_FtofTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_FtofTruthHit_getRunNo(_FtofTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FtofTruthHit_getBar(_FtofTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getBar());
}

static PyObject*
_FtofTruthHit_getPlane(_FtofTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPlane());
}

static PyObject*
_FtofTruthHit_getDE(_FtofTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDE());
}

static int
_FtofTruthHit_setDE(_FtofTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDE((float)var);
   return 0;
}

static PyObject*
_FtofTruthHit_getEnd(_FtofTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEnd());
}

static int
_FtofTruthHit_setEnd(_FtofTruthHit *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setEnd(var);
   return 0;
}

static PyObject*
_FtofTruthHit_getMaxOccurs(_FtofTruthHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FtofTruthHit_getMinOccurs(_FtofTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FtofTruthHit_getT(_FtofTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_FtofTruthHit_setT(_FtofTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_FtofTruthHit_getFtofTruthExtra(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FtofTruthHit *me = (_FtofTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofTruthHit element");
      return NULL;
   }
   PyObject *obj = _FtofTruthExtra_new(&_FtofTruthExtra_type, 0, 0);
   ((_FtofTruthExtra*)obj)->elem = &me->elem->getFtofTruthExtra(index);
   ((_FtofTruthExtra*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FtofTruthHit_getFtofTruthExtras(PyObject *self, PyObject *args)
{
   _FtofTruthHit *me = (_FtofTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofTruthHit element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FtofTruthExtra_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFtofTruthExtras();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FtofTruthHit_addFtofTruthExtras(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FtofTruthHit *me = (_FtofTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid ftofTruthHit element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FtofTruthExtra_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FtofTruthExtraList(me->elem->addFtofTruthExtras(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FtofTruthHit_deleteFtofTruthExtras(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FtofTruthHit *me = (_FtofTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid ftofTruthHit element");
      return NULL;
   }
   me->elem->deleteFtofTruthExtras(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FtofTruthHit_toString(PyObject *self, PyObject *args=0)
{
   _FtofTruthHit *me = (_FtofTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FtofTruthHit_toXML(PyObject *self, PyObject *args=0)
{
   _FtofTruthHit *me = (_FtofTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FtofTruthHit_getsetters[] = {
   {(char*)"bar",
    (getter)_FtofTruthHit_getBar, 0,
    (char*)"bar value",
    NULL},
   {(char*)"class",
    (getter)_FtofTruthHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"dE",
    (getter)_FtofTruthHit_getDE, (setter)_FtofTruthHit_setDE,
    (char*)"dE value",
    NULL},
   {(char*)"end",
    (getter)_FtofTruthHit_getEnd, (setter)_FtofTruthHit_setEnd,
    (char*)"end value",
    NULL},
   {(char*)"eventNo",
    (getter)_FtofTruthHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FtofTruthHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FtofTruthHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"plane",
    (getter)_FtofTruthHit_getPlane, 0,
    (char*)"plane value",
    NULL},
   {(char*)"runNo",
    (getter)_FtofTruthHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_FtofTruthHit_getT, (setter)_FtofTruthHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_FtofTruthHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_FtofTruthHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FtofTruthHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FtofTruthHit_methods[] = {
   {"addFtofTruthExtras", _FtofTruthHit_addFtofTruthExtras, METH_VARARGS,
    "extend (or insert into) the list of ftofTruthExtra objects for this ftofTruthHit"},
   {"deleteFtofTruthExtras", _FtofTruthHit_deleteFtofTruthExtras, METH_VARARGS,
    "delete ftofTruthExtra objects for this ftofTruthHit"},
   {"getFtofTruthExtra", _FtofTruthHit_getFtofTruthExtra, METH_VARARGS,
    "get an individual ftofTruthExtra object from this ftofTruthHit"},
   {"getFtofTruthExtras", _FtofTruthHit_getFtofTruthExtras, METH_NOARGS,
    "get list of ftofTruthExtra objects for this ftofTruthHit"},
   {"toString", _FtofTruthHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FtofTruthHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FtofTruthHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.FtofTruthHit",         /*tp_name*/
    sizeof(_FtofTruthHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FtofTruthHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FtofTruthHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s ftofTruthHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FtofTruthHit_methods,          /* tp_methods */
    _FtofTruthHit_members,          /* tp_members */
    _FtofTruthHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FtofTruthHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FtofTruthHit_new,              /* tp_new */
};



// wrap element class hddm_s::FtofCounter as hddm_s.FtofCounter

typedef struct {
   PyObject_HEAD
   FtofCounter *elem;
   PyObject *host;
} _FtofCounter;

static void
_FtofCounter_dealloc(_FtofCounter* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FtofCounter_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FtofCounter *self;
   self = (_FtofCounter*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FtofCounter_init(_FtofCounter *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FtofCounter_getClass(_FtofCounter *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FtofCounter_getVersion(_FtofCounter *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_FtofCounter_getXmlns(_FtofCounter *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FtofCounter_getEventNo(_FtofCounter *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_FtofCounter_getRunNo(_FtofCounter *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FtofCounter_getBar(_FtofCounter *self, void *closure)
{
   return PyLong_FromLong(self->elem->getBar());
}

static int
_FtofCounter_setBar(_FtofCounter *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setBar(var);
   return 0;
}

static PyObject*
_FtofCounter_getMaxOccurs(_FtofCounter *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FtofCounter_getMinOccurs(_FtofCounter *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FtofCounter_getPlane(_FtofCounter *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPlane());
}

static int
_FtofCounter_setPlane(_FtofCounter *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPlane(var);
   return 0;
}

static PyObject*
_FtofCounter_getFtofHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FtofCounter *me = (_FtofCounter*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofCounter element");
      return NULL;
   }
   PyObject *obj = _FtofHit_new(&_FtofHit_type, 0, 0);
   ((_FtofHit*)obj)->elem = &me->elem->getFtofHit(index);
   ((_FtofHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FtofCounter_getFtofHits(PyObject *self, PyObject *args)
{
   _FtofCounter *me = (_FtofCounter*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofCounter element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FtofHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFtofHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FtofCounter_addFtofHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FtofCounter *me = (_FtofCounter*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid ftofCounter element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FtofHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FtofHitList(me->elem->addFtofHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FtofCounter_deleteFtofHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FtofCounter *me = (_FtofCounter*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid ftofCounter element");
      return NULL;
   }
   me->elem->deleteFtofHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FtofCounter_getFtofTruthHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FtofCounter *me = (_FtofCounter*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofCounter element");
      return NULL;
   }
   PyObject *obj = _FtofTruthHit_new(&_FtofTruthHit_type, 0, 0);
   ((_FtofTruthHit*)obj)->elem = &me->elem->getFtofTruthHit(index);
   ((_FtofTruthHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FtofCounter_getFtofTruthHits(PyObject *self, PyObject *args)
{
   _FtofCounter *me = (_FtofCounter*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofCounter element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FtofTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFtofTruthHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FtofCounter_addFtofTruthHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FtofCounter *me = (_FtofCounter*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid ftofCounter element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FtofTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FtofTruthHitList(me->elem->addFtofTruthHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FtofCounter_deleteFtofTruthHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FtofCounter *me = (_FtofCounter*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid ftofCounter element");
      return NULL;
   }
   me->elem->deleteFtofTruthHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FtofCounter_toString(PyObject *self, PyObject *args=0)
{
   _FtofCounter *me = (_FtofCounter*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofCounter element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FtofCounter_toXML(PyObject *self, PyObject *args=0)
{
   _FtofCounter *me = (_FtofCounter*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofCounter element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FtofCounter_getsetters[] = {
   {(char*)"bar",
    (getter)_FtofCounter_getBar, (setter)_FtofCounter_setBar,
    (char*)"bar value",
    NULL},
   {(char*)"class",
    (getter)_FtofCounter_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_FtofCounter_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FtofCounter_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FtofCounter_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"plane",
    (getter)_FtofCounter_getPlane, (setter)_FtofCounter_setPlane,
    (char*)"plane value",
    NULL},
   {(char*)"runNo",
    (getter)_FtofCounter_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_FtofCounter_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_FtofCounter_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FtofCounter_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FtofCounter_methods[] = {
   {"addFtofHits", _FtofCounter_addFtofHits, METH_VARARGS,
    "extend (or insert into) the list of ftofHit objects for this ftofCounter"},
   {"addFtofTruthHits", _FtofCounter_addFtofTruthHits, METH_VARARGS,
    "extend (or insert into) the list of ftofTruthHit objects for this ftofCounter"},
   {"deleteFtofHits", _FtofCounter_deleteFtofHits, METH_VARARGS,
    "delete ftofHit objects for this ftofCounter"},
   {"deleteFtofTruthHits", _FtofCounter_deleteFtofTruthHits, METH_VARARGS,
    "delete ftofTruthHit objects for this ftofCounter"},
   {"getFtofHit", _FtofCounter_getFtofHit, METH_VARARGS,
    "get an individual ftofHit object from this ftofCounter"},
   {"getFtofHits", _FtofCounter_getFtofHits, METH_NOARGS,
    "get list of ftofHit objects for this ftofCounter"},
   {"getFtofTruthHit", _FtofCounter_getFtofTruthHit, METH_VARARGS,
    "get an individual ftofTruthHit object from this ftofCounter"},
   {"getFtofTruthHits", _FtofCounter_getFtofTruthHits, METH_NOARGS,
    "get list of ftofTruthHit objects for this ftofCounter"},
   {"toString", _FtofCounter_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FtofCounter_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FtofCounter_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.FtofCounter",         /*tp_name*/
    sizeof(_FtofCounter),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FtofCounter_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FtofCounter_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s ftofCounter element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FtofCounter_methods,          /* tp_methods */
    _FtofCounter_members,          /* tp_members */
    _FtofCounter_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FtofCounter_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FtofCounter_new,              /* tp_new */
};



// wrap element class hddm_s::FtofTruthPoint as hddm_s.FtofTruthPoint

typedef struct {
   PyObject_HEAD
   FtofTruthPoint *elem;
   PyObject *host;
} _FtofTruthPoint;

static void
_FtofTruthPoint_dealloc(_FtofTruthPoint* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FtofTruthPoint_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FtofTruthPoint *self;
   self = (_FtofTruthPoint*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FtofTruthPoint_init(_FtofTruthPoint *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FtofTruthPoint_getClass(_FtofTruthPoint *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FtofTruthPoint_getVersion(_FtofTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_FtofTruthPoint_getXmlns(_FtofTruthPoint *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FtofTruthPoint_getEventNo(_FtofTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_FtofTruthPoint_getRunNo(_FtofTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FtofTruthPoint_getE(_FtofTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_FtofTruthPoint_setE(_FtofTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_FtofTruthPoint_getMaxOccurs(_FtofTruthPoint *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FtofTruthPoint_getMinOccurs(_FtofTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FtofTruthPoint_getPrimary(_FtofTruthPoint *self, void *closure)
{
   return PyBool_FromLong(self->elem->getPrimary());
}

static int
_FtofTruthPoint_setPrimary(_FtofTruthPoint *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPrimary((var==0)? false : true);
   return 0;
}

static PyObject*
_FtofTruthPoint_getPtype(_FtofTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPtype());
}

static int
_FtofTruthPoint_setPtype(_FtofTruthPoint *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPtype(var);
   return 0;
}

static PyObject*
_FtofTruthPoint_getPx(_FtofTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPx());
}

static int
_FtofTruthPoint_setPx(_FtofTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPx((float)var);
   return 0;
}

static PyObject*
_FtofTruthPoint_getPy(_FtofTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPy());
}

static int
_FtofTruthPoint_setPy(_FtofTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPy((float)var);
   return 0;
}

static PyObject*
_FtofTruthPoint_getPz(_FtofTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPz());
}

static int
_FtofTruthPoint_setPz(_FtofTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPz((float)var);
   return 0;
}

static PyObject*
_FtofTruthPoint_getT(_FtofTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_FtofTruthPoint_setT(_FtofTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_FtofTruthPoint_getTrack(_FtofTruthPoint *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static int
_FtofTruthPoint_setTrack(_FtofTruthPoint *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTrack(var);
   return 0;
}

static PyObject*
_FtofTruthPoint_getX(_FtofTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static int
_FtofTruthPoint_setX(_FtofTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setX((float)var);
   return 0;
}

static PyObject*
_FtofTruthPoint_getY(_FtofTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static int
_FtofTruthPoint_setY(_FtofTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setY((float)var);
   return 0;
}

static PyObject*
_FtofTruthPoint_getZ(_FtofTruthPoint *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static int
_FtofTruthPoint_setZ(_FtofTruthPoint *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ((float)var);
   return 0;
}

static PyObject*
_FtofTruthPoint_getTrackID(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FtofTruthPoint *me = (_FtofTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofTruthPoint element");
      return NULL;
   }
   PyObject *obj = _TrackID_new(&_TrackID_type, 0, 0);
   ((_TrackID*)obj)->elem = &me->elem->getTrackID();
   ((_TrackID*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FtofTruthPoint_getTrackIDs(PyObject *self, PyObject *args)
{
   _FtofTruthPoint *me = (_FtofTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofTruthPoint element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackID_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTrackIDs();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FtofTruthPoint_addTrackIDs(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FtofTruthPoint *me = (_FtofTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid ftofTruthPoint element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackID_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TrackIDList(me->elem->addTrackIDs(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FtofTruthPoint_deleteTrackIDs(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FtofTruthPoint *me = (_FtofTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid ftofTruthPoint element");
      return NULL;
   }
   me->elem->deleteTrackIDs(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FtofTruthPoint_toString(PyObject *self, PyObject *args=0)
{
   _FtofTruthPoint *me = (_FtofTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofTruthPoint element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FtofTruthPoint_toXML(PyObject *self, PyObject *args=0)
{
   _FtofTruthPoint *me = (_FtofTruthPoint*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ftofTruthPoint element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FtofTruthPoint_getsetters[] = {
   {(char*)"E",
    (getter)_FtofTruthPoint_getE, (setter)_FtofTruthPoint_setE,
    (char*)"E value",
    NULL},
   {(char*)"class",
    (getter)_FtofTruthPoint_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_FtofTruthPoint_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FtofTruthPoint_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FtofTruthPoint_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"primary",
    (getter)_FtofTruthPoint_getPrimary, (setter)_FtofTruthPoint_setPrimary,
    (char*)"primary value",
    NULL},
   {(char*)"ptype",
    (getter)_FtofTruthPoint_getPtype, (setter)_FtofTruthPoint_setPtype,
    (char*)"ptype value",
    NULL},
   {(char*)"px",
    (getter)_FtofTruthPoint_getPx, (setter)_FtofTruthPoint_setPx,
    (char*)"px value",
    NULL},
   {(char*)"py",
    (getter)_FtofTruthPoint_getPy, (setter)_FtofTruthPoint_setPy,
    (char*)"py value",
    NULL},
   {(char*)"pz",
    (getter)_FtofTruthPoint_getPz, (setter)_FtofTruthPoint_setPz,
    (char*)"pz value",
    NULL},
   {(char*)"runNo",
    (getter)_FtofTruthPoint_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_FtofTruthPoint_getT, (setter)_FtofTruthPoint_setT,
    (char*)"t value",
    NULL},
   {(char*)"track",
    (getter)_FtofTruthPoint_getTrack, (setter)_FtofTruthPoint_setTrack,
    (char*)"track value",
    NULL},
   {(char*)"version",
    (getter)_FtofTruthPoint_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"x",
    (getter)_FtofTruthPoint_getX, (setter)_FtofTruthPoint_setX,
    (char*)"x value",
    NULL},
   {(char*)"xmlns",
    (getter)_FtofTruthPoint_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y",
    (getter)_FtofTruthPoint_getY, (setter)_FtofTruthPoint_setY,
    (char*)"y value",
    NULL},
   {(char*)"z",
    (getter)_FtofTruthPoint_getZ, (setter)_FtofTruthPoint_setZ,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FtofTruthPoint_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FtofTruthPoint_methods[] = {
   {"addTrackIDs", _FtofTruthPoint_addTrackIDs, METH_VARARGS,
    "extend (or insert into) the list of trackID objects for this ftofTruthPoint"},
   {"deleteTrackIDs", _FtofTruthPoint_deleteTrackIDs, METH_VARARGS,
    "delete trackID objects for this ftofTruthPoint"},
   {"getTrackID", _FtofTruthPoint_getTrackID, METH_VARARGS,
    "get an individual trackID object from this ftofTruthPoint"},
   {"getTrackIDs", _FtofTruthPoint_getTrackIDs, METH_NOARGS,
    "get list of trackID objects for this ftofTruthPoint"},
   {"toString", _FtofTruthPoint_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FtofTruthPoint_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FtofTruthPoint_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.FtofTruthPoint",         /*tp_name*/
    sizeof(_FtofTruthPoint),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FtofTruthPoint_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FtofTruthPoint_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s ftofTruthPoint element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FtofTruthPoint_methods,          /* tp_methods */
    _FtofTruthPoint_members,          /* tp_members */
    _FtofTruthPoint_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FtofTruthPoint_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FtofTruthPoint_new,              /* tp_new */
};



// wrap element class hddm_s::ForwardTOF as hddm_s.ForwardTOF

typedef struct {
   PyObject_HEAD
   ForwardTOF *elem;
   PyObject *host;
} _ForwardTOF;

static void
_ForwardTOF_dealloc(_ForwardTOF* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_ForwardTOF_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _ForwardTOF *self;
   self = (_ForwardTOF*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_ForwardTOF_init(_ForwardTOF *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_ForwardTOF_getClass(_ForwardTOF *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ForwardTOF_getVersion(_ForwardTOF *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_ForwardTOF_getXmlns(_ForwardTOF *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ForwardTOF_getEventNo(_ForwardTOF *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_ForwardTOF_getMaxOccurs(_ForwardTOF *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ForwardTOF_getRunNo(_ForwardTOF *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_ForwardTOF_getMinOccurs(_ForwardTOF *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_ForwardTOF_getFtofCounter(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ForwardTOF *me = (_ForwardTOF*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid forwardTOF element");
      return NULL;
   }
   PyObject *obj = _FtofCounter_new(&_FtofCounter_type, 0, 0);
   ((_FtofCounter*)obj)->elem = &me->elem->getFtofCounter(index);
   ((_FtofCounter*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ForwardTOF_getFtofCounters(PyObject *self, PyObject *args)
{
   _ForwardTOF *me = (_ForwardTOF*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid forwardTOF element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FtofCounter_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFtofCounters();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ForwardTOF_addFtofCounters(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ForwardTOF *me = (_ForwardTOF*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid forwardTOF element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FtofCounter_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FtofCounterList(me->elem->addFtofCounters(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ForwardTOF_deleteFtofCounters(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ForwardTOF *me = (_ForwardTOF*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid forwardTOF element");
      return NULL;
   }
   me->elem->deleteFtofCounters(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ForwardTOF_getFtofTruthPoint(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ForwardTOF *me = (_ForwardTOF*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid forwardTOF element");
      return NULL;
   }
   PyObject *obj = _FtofTruthPoint_new(&_FtofTruthPoint_type, 0, 0);
   ((_FtofTruthPoint*)obj)->elem = &me->elem->getFtofTruthPoint(index);
   ((_FtofTruthPoint*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ForwardTOF_getFtofTruthPoints(PyObject *self, PyObject *args)
{
   _ForwardTOF *me = (_ForwardTOF*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid forwardTOF element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FtofTruthPoint_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFtofTruthPoints();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ForwardTOF_addFtofTruthPoints(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ForwardTOF *me = (_ForwardTOF*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid forwardTOF element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FtofTruthPoint_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FtofTruthPointList(me->elem->addFtofTruthPoints(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ForwardTOF_deleteFtofTruthPoints(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ForwardTOF *me = (_ForwardTOF*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid forwardTOF element");
      return NULL;
   }
   me->elem->deleteFtofTruthPoints(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ForwardTOF_toString(PyObject *self, PyObject *args=0)
{
   _ForwardTOF *me = (_ForwardTOF*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid forwardTOF element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_ForwardTOF_toXML(PyObject *self, PyObject *args=0)
{
   _ForwardTOF *me = (_ForwardTOF*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid forwardTOF element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _ForwardTOF_getsetters[] = {
   {(char*)"class",
    (getter)_ForwardTOF_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_ForwardTOF_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_ForwardTOF_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_ForwardTOF_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_ForwardTOF_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_ForwardTOF_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_ForwardTOF_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _ForwardTOF_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _ForwardTOF_methods[] = {
   {"addFtofCounters", _ForwardTOF_addFtofCounters, METH_VARARGS,
    "extend (or insert into) the list of ftofCounter objects for this forwardTOF"},
   {"addFtofTruthPoints", _ForwardTOF_addFtofTruthPoints, METH_VARARGS,
    "extend (or insert into) the list of ftofTruthPoint objects for this forwardTOF"},
   {"deleteFtofCounters", _ForwardTOF_deleteFtofCounters, METH_VARARGS,
    "delete ftofCounter objects for this forwardTOF"},
   {"deleteFtofTruthPoints", _ForwardTOF_deleteFtofTruthPoints, METH_VARARGS,
    "delete ftofTruthPoint objects for this forwardTOF"},
   {"getFtofCounter", _ForwardTOF_getFtofCounter, METH_VARARGS,
    "get an individual ftofCounter object from this forwardTOF"},
   {"getFtofCounters", _ForwardTOF_getFtofCounters, METH_NOARGS,
    "get list of ftofCounter objects for this forwardTOF"},
   {"getFtofTruthPoint", _ForwardTOF_getFtofTruthPoint, METH_VARARGS,
    "get an individual ftofTruthPoint object from this forwardTOF"},
   {"getFtofTruthPoints", _ForwardTOF_getFtofTruthPoints, METH_NOARGS,
    "get list of ftofTruthPoint objects for this forwardTOF"},
   {"toString", _ForwardTOF_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _ForwardTOF_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _ForwardTOF_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.ForwardTOF",         /*tp_name*/
    sizeof(_ForwardTOF),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_ForwardTOF_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_ForwardTOF_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s forwardTOF element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _ForwardTOF_methods,          /* tp_methods */
    _ForwardTOF_members,          /* tp_members */
    _ForwardTOF_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_ForwardTOF_init,   /* tp_init */
    0,                         /* tp_alloc */
    _ForwardTOF_new,              /* tp_new */
};



// wrap element class hddm_s::FcalDigihit as hddm_s.FcalDigihit

typedef struct {
   PyObject_HEAD
   FcalDigihit *elem;
   PyObject *host;
} _FcalDigihit;

static void
_FcalDigihit_dealloc(_FcalDigihit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FcalDigihit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FcalDigihit *self;
   self = (_FcalDigihit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FcalDigihit_init(_FcalDigihit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FcalDigihit_getClass(_FcalDigihit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalDigihit_getVersion(_FcalDigihit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_FcalDigihit_getXmlns(_FcalDigihit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalDigihit_getEventNo(_FcalDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_FcalDigihit_getMaxOccurs(_FcalDigihit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalDigihit_getRunNo(_FcalDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FcalDigihit_getColumn(_FcalDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getColumn());
}

static PyObject*
_FcalDigihit_getRow(_FcalDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRow());
}

static PyObject*
_FcalDigihit_getE(_FcalDigihit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static PyObject*
_FcalDigihit_getT(_FcalDigihit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static PyObject*
_FcalDigihit_getIntegralOverPeak(_FcalDigihit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getIntegralOverPeak());
}

static int
_FcalDigihit_setIntegralOverPeak(_FcalDigihit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setIntegralOverPeak((float)var);
   return 0;
}

static PyObject*
_FcalDigihit_getMinOccurs(_FcalDigihit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FcalDigihit_toString(PyObject *self, PyObject *args=0)
{
   _FcalDigihit *me = (_FcalDigihit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalDigihit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FcalDigihit_toXML(PyObject *self, PyObject *args=0)
{
   _FcalDigihit *me = (_FcalDigihit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalDigihit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FcalDigihit_getsetters[] = {
   {(char*)"E",
    (getter)_FcalDigihit_getE, 0,
    (char*)"E value",
    NULL},
   {(char*)"class",
    (getter)_FcalDigihit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"column",
    (getter)_FcalDigihit_getColumn, 0,
    (char*)"column value",
    NULL},
   {(char*)"eventNo",
    (getter)_FcalDigihit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"integralOverPeak",
    (getter)_FcalDigihit_getIntegralOverPeak, (setter)_FcalDigihit_setIntegralOverPeak,
    (char*)"integralOverPeak value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FcalDigihit_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_FcalDigihit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"row",
    (getter)_FcalDigihit_getRow, 0,
    (char*)"row value",
    NULL},
   {(char*)"runNo",
    (getter)_FcalDigihit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_FcalDigihit_getT, 0,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_FcalDigihit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_FcalDigihit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FcalDigihit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FcalDigihit_methods[] = {
   {"toString", _FcalDigihit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FcalDigihit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FcalDigihit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.FcalDigihit",         /*tp_name*/
    sizeof(_FcalDigihit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FcalDigihit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FcalDigihit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s fcalDigihit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FcalDigihit_methods,          /* tp_methods */
    _FcalDigihit_members,          /* tp_members */
    _FcalDigihit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FcalDigihit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FcalDigihit_new,              /* tp_new */
};



// wrap element class hddm_s::FcalHit as hddm_s.FcalHit

typedef struct {
   PyObject_HEAD
   FcalHit *elem;
   PyObject *host;
} _FcalHit;

static void
_FcalHit_dealloc(_FcalHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FcalHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FcalHit *self;
   self = (_FcalHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FcalHit_init(_FcalHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FcalHit_getClass(_FcalHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalHit_getVersion(_FcalHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_FcalHit_getXmlns(_FcalHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalHit_getEventNo(_FcalHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_FcalHit_getRunNo(_FcalHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FcalHit_getMinOccurs(_FcalHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FcalHit_getColumn(_FcalHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getColumn());
}

static PyObject*
_FcalHit_getRow(_FcalHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRow());
}

static PyObject*
_FcalHit_getE(_FcalHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_FcalHit_setE(_FcalHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_FcalHit_getMaxOccurs(_FcalHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalHit_getT(_FcalHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_FcalHit_setT(_FcalHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_FcalHit_getFcalDigihit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FcalHit *me = (_FcalHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalHit element");
      return NULL;
   }
   PyObject *obj = _FcalDigihit_new(&_FcalDigihit_type, 0, 0);
   ((_FcalDigihit*)obj)->elem = &me->elem->getFcalDigihit();
   ((_FcalDigihit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FcalHit_getFcalDigihits(PyObject *self, PyObject *args)
{
   _FcalHit *me = (_FcalHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalHit element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalDigihit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFcalDigihits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FcalHit_addFcalDigihits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FcalHit *me = (_FcalHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid fcalHit element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalDigihit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalDigihitList(me->elem->addFcalDigihits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FcalHit_deleteFcalDigihits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FcalHit *me = (_FcalHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid fcalHit element");
      return NULL;
   }
   me->elem->deleteFcalDigihits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FcalHit_toString(PyObject *self, PyObject *args=0)
{
   _FcalHit *me = (_FcalHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FcalHit_toXML(PyObject *self, PyObject *args=0)
{
   _FcalHit *me = (_FcalHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FcalHit_getsetters[] = {
   {(char*)"E",
    (getter)_FcalHit_getE, (setter)_FcalHit_setE,
    (char*)"E value",
    NULL},
   {(char*)"class",
    (getter)_FcalHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"column",
    (getter)_FcalHit_getColumn, 0,
    (char*)"column value",
    NULL},
   {(char*)"eventNo",
    (getter)_FcalHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FcalHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FcalHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"row",
    (getter)_FcalHit_getRow, 0,
    (char*)"row value",
    NULL},
   {(char*)"runNo",
    (getter)_FcalHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_FcalHit_getT, (setter)_FcalHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_FcalHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_FcalHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FcalHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FcalHit_methods[] = {
   {"addFcalDigihits", _FcalHit_addFcalDigihits, METH_VARARGS,
    "extend (or insert into) the list of fcalDigihit objects for this fcalHit"},
   {"deleteFcalDigihits", _FcalHit_deleteFcalDigihits, METH_VARARGS,
    "delete fcalDigihit objects for this fcalHit"},
   {"getFcalDigihit", _FcalHit_getFcalDigihit, METH_VARARGS,
    "get an individual fcalDigihit object from this fcalHit"},
   {"getFcalDigihits", _FcalHit_getFcalDigihits, METH_NOARGS,
    "get list of fcalDigihit objects for this fcalHit"},
   {"toString", _FcalHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FcalHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FcalHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.FcalHit",         /*tp_name*/
    sizeof(_FcalHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FcalHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FcalHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s fcalHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FcalHit_methods,          /* tp_methods */
    _FcalHit_members,          /* tp_members */
    _FcalHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FcalHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FcalHit_new,              /* tp_new */
};



// wrap element class hddm_s::FcalTruthLightGuide as hddm_s.FcalTruthLightGuide

typedef struct {
   PyObject_HEAD
   FcalTruthLightGuide *elem;
   PyObject *host;
} _FcalTruthLightGuide;

static void
_FcalTruthLightGuide_dealloc(_FcalTruthLightGuide* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FcalTruthLightGuide_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FcalTruthLightGuide *self;
   self = (_FcalTruthLightGuide*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FcalTruthLightGuide_init(_FcalTruthLightGuide *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FcalTruthLightGuide_getClass(_FcalTruthLightGuide *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalTruthLightGuide_getVersion(_FcalTruthLightGuide *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_FcalTruthLightGuide_getXmlns(_FcalTruthLightGuide *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalTruthLightGuide_getEventNo(_FcalTruthLightGuide *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_FcalTruthLightGuide_getRunNo(_FcalTruthLightGuide *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FcalTruthLightGuide_getMinOccurs(_FcalTruthLightGuide *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FcalTruthLightGuide_getColumn(_FcalTruthLightGuide *self, void *closure)
{
   return PyLong_FromLong(self->elem->getColumn());
}

static PyObject*
_FcalTruthLightGuide_getRow(_FcalTruthLightGuide *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRow());
}

static PyObject*
_FcalTruthLightGuide_getE(_FcalTruthLightGuide *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static PyObject*
_FcalTruthLightGuide_getDE(_FcalTruthLightGuide *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getDE());
}

static int
_FcalTruthLightGuide_setDE(_FcalTruthLightGuide *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setDE((float)var);
   return 0;
}

static PyObject*
_FcalTruthLightGuide_getMaxOccurs(_FcalTruthLightGuide *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalTruthLightGuide_getT(_FcalTruthLightGuide *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_FcalTruthLightGuide_setT(_FcalTruthLightGuide *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_FcalTruthLightGuide_toString(PyObject *self, PyObject *args=0)
{
   _FcalTruthLightGuide *me = (_FcalTruthLightGuide*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalTruthLightGuide element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FcalTruthLightGuide_toXML(PyObject *self, PyObject *args=0)
{
   _FcalTruthLightGuide *me = (_FcalTruthLightGuide*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalTruthLightGuide element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FcalTruthLightGuide_getsetters[] = {
   {(char*)"E",
    (getter)_FcalTruthLightGuide_getE, 0,
    (char*)"E value",
    NULL},
   {(char*)"class",
    (getter)_FcalTruthLightGuide_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"column",
    (getter)_FcalTruthLightGuide_getColumn, 0,
    (char*)"column value",
    NULL},
   {(char*)"dE",
    (getter)_FcalTruthLightGuide_getDE, (setter)_FcalTruthLightGuide_setDE,
    (char*)"dE value",
    NULL},
   {(char*)"eventNo",
    (getter)_FcalTruthLightGuide_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FcalTruthLightGuide_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FcalTruthLightGuide_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"row",
    (getter)_FcalTruthLightGuide_getRow, 0,
    (char*)"row value",
    NULL},
   {(char*)"runNo",
    (getter)_FcalTruthLightGuide_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_FcalTruthLightGuide_getT, (setter)_FcalTruthLightGuide_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_FcalTruthLightGuide_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_FcalTruthLightGuide_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FcalTruthLightGuide_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FcalTruthLightGuide_methods[] = {
   {"toString", _FcalTruthLightGuide_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FcalTruthLightGuide_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FcalTruthLightGuide_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.FcalTruthLightGuide",         /*tp_name*/
    sizeof(_FcalTruthLightGuide),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FcalTruthLightGuide_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FcalTruthLightGuide_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s fcalTruthLightGuide element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FcalTruthLightGuide_methods,          /* tp_methods */
    _FcalTruthLightGuide_members,          /* tp_members */
    _FcalTruthLightGuide_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FcalTruthLightGuide_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FcalTruthLightGuide_new,              /* tp_new */
};



// wrap element class hddm_s::FcalTruthHit as hddm_s.FcalTruthHit

typedef struct {
   PyObject_HEAD
   FcalTruthHit *elem;
   PyObject *host;
} _FcalTruthHit;

static void
_FcalTruthHit_dealloc(_FcalTruthHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FcalTruthHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FcalTruthHit *self;
   self = (_FcalTruthHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FcalTruthHit_init(_FcalTruthHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FcalTruthHit_getClass(_FcalTruthHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalTruthHit_getVersion(_FcalTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_FcalTruthHit_getXmlns(_FcalTruthHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalTruthHit_getEventNo(_FcalTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_FcalTruthHit_getRunNo(_FcalTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FcalTruthHit_getMinOccurs(_FcalTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FcalTruthHit_getColumn(_FcalTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getColumn());
}

static PyObject*
_FcalTruthHit_getRow(_FcalTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRow());
}

static PyObject*
_FcalTruthHit_getE(_FcalTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_FcalTruthHit_setE(_FcalTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_FcalTruthHit_getMaxOccurs(_FcalTruthHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalTruthHit_getT(_FcalTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_FcalTruthHit_setT(_FcalTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_FcalTruthHit_getFcalTruthLightGuide(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FcalTruthHit *me = (_FcalTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalTruthHit element");
      return NULL;
   }
   PyObject *obj = _FcalTruthLightGuide_new(&_FcalTruthLightGuide_type, 0, 0);
   ((_FcalTruthLightGuide*)obj)->elem = &me->elem->getFcalTruthLightGuide(index);
   ((_FcalTruthLightGuide*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FcalTruthHit_getFcalTruthLightGuides(PyObject *self, PyObject *args)
{
   _FcalTruthHit *me = (_FcalTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalTruthHit element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalTruthLightGuide_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFcalTruthLightGuides();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FcalTruthHit_addFcalTruthLightGuides(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FcalTruthHit *me = (_FcalTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid fcalTruthHit element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalTruthLightGuide_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalTruthLightGuideList(me->elem->addFcalTruthLightGuides(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FcalTruthHit_deleteFcalTruthLightGuides(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FcalTruthHit *me = (_FcalTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid fcalTruthHit element");
      return NULL;
   }
   me->elem->deleteFcalTruthLightGuides(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FcalTruthHit_toString(PyObject *self, PyObject *args=0)
{
   _FcalTruthHit *me = (_FcalTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FcalTruthHit_toXML(PyObject *self, PyObject *args=0)
{
   _FcalTruthHit *me = (_FcalTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FcalTruthHit_getsetters[] = {
   {(char*)"E",
    (getter)_FcalTruthHit_getE, (setter)_FcalTruthHit_setE,
    (char*)"E value",
    NULL},
   {(char*)"class",
    (getter)_FcalTruthHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"column",
    (getter)_FcalTruthHit_getColumn, 0,
    (char*)"column value",
    NULL},
   {(char*)"eventNo",
    (getter)_FcalTruthHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FcalTruthHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FcalTruthHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"row",
    (getter)_FcalTruthHit_getRow, 0,
    (char*)"row value",
    NULL},
   {(char*)"runNo",
    (getter)_FcalTruthHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_FcalTruthHit_getT, (setter)_FcalTruthHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_FcalTruthHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_FcalTruthHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FcalTruthHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FcalTruthHit_methods[] = {
   {"addFcalTruthLightGuides", _FcalTruthHit_addFcalTruthLightGuides, METH_VARARGS,
    "extend (or insert into) the list of fcalTruthLightGuide objects for this fcalTruthHit"},
   {"deleteFcalTruthLightGuides", _FcalTruthHit_deleteFcalTruthLightGuides, METH_VARARGS,
    "delete fcalTruthLightGuide objects for this fcalTruthHit"},
   {"getFcalTruthLightGuide", _FcalTruthHit_getFcalTruthLightGuide, METH_VARARGS,
    "get an individual fcalTruthLightGuide object from this fcalTruthHit"},
   {"getFcalTruthLightGuides", _FcalTruthHit_getFcalTruthLightGuides, METH_NOARGS,
    "get list of fcalTruthLightGuide objects for this fcalTruthHit"},
   {"toString", _FcalTruthHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FcalTruthHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FcalTruthHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.FcalTruthHit",         /*tp_name*/
    sizeof(_FcalTruthHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FcalTruthHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FcalTruthHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s fcalTruthHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FcalTruthHit_methods,          /* tp_methods */
    _FcalTruthHit_members,          /* tp_members */
    _FcalTruthHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FcalTruthHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FcalTruthHit_new,              /* tp_new */
};



// wrap element class hddm_s::FcalBlock as hddm_s.FcalBlock

typedef struct {
   PyObject_HEAD
   FcalBlock *elem;
   PyObject *host;
} _FcalBlock;

static void
_FcalBlock_dealloc(_FcalBlock* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FcalBlock_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FcalBlock *self;
   self = (_FcalBlock*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FcalBlock_init(_FcalBlock *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FcalBlock_getClass(_FcalBlock *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalBlock_getVersion(_FcalBlock *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_FcalBlock_getXmlns(_FcalBlock *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalBlock_getEventNo(_FcalBlock *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_FcalBlock_getRunNo(_FcalBlock *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FcalBlock_getColumn(_FcalBlock *self, void *closure)
{
   return PyLong_FromLong(self->elem->getColumn());
}

static int
_FcalBlock_setColumn(_FcalBlock *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setColumn(var);
   return 0;
}

static PyObject*
_FcalBlock_getMaxOccurs(_FcalBlock *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalBlock_getMinOccurs(_FcalBlock *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FcalBlock_getRow(_FcalBlock *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRow());
}

static int
_FcalBlock_setRow(_FcalBlock *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setRow(var);
   return 0;
}

static PyObject*
_FcalBlock_getFcalHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FcalBlock *me = (_FcalBlock*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalBlock element");
      return NULL;
   }
   PyObject *obj = _FcalHit_new(&_FcalHit_type, 0, 0);
   ((_FcalHit*)obj)->elem = &me->elem->getFcalHit(index);
   ((_FcalHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FcalBlock_getFcalHits(PyObject *self, PyObject *args)
{
   _FcalBlock *me = (_FcalBlock*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalBlock element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFcalHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FcalBlock_addFcalHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FcalBlock *me = (_FcalBlock*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid fcalBlock element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalHitList(me->elem->addFcalHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FcalBlock_deleteFcalHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FcalBlock *me = (_FcalBlock*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid fcalBlock element");
      return NULL;
   }
   me->elem->deleteFcalHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FcalBlock_getFcalTruthHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FcalBlock *me = (_FcalBlock*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalBlock element");
      return NULL;
   }
   PyObject *obj = _FcalTruthHit_new(&_FcalTruthHit_type, 0, 0);
   ((_FcalTruthHit*)obj)->elem = &me->elem->getFcalTruthHit(index);
   ((_FcalTruthHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FcalBlock_getFcalTruthHits(PyObject *self, PyObject *args)
{
   _FcalBlock *me = (_FcalBlock*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalBlock element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFcalTruthHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FcalBlock_addFcalTruthHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FcalBlock *me = (_FcalBlock*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid fcalBlock element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalTruthHitList(me->elem->addFcalTruthHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FcalBlock_deleteFcalTruthHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FcalBlock *me = (_FcalBlock*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid fcalBlock element");
      return NULL;
   }
   me->elem->deleteFcalTruthHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FcalBlock_toString(PyObject *self, PyObject *args=0)
{
   _FcalBlock *me = (_FcalBlock*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalBlock element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FcalBlock_toXML(PyObject *self, PyObject *args=0)
{
   _FcalBlock *me = (_FcalBlock*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalBlock element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FcalBlock_getsetters[] = {
   {(char*)"class",
    (getter)_FcalBlock_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"column",
    (getter)_FcalBlock_getColumn, (setter)_FcalBlock_setColumn,
    (char*)"column value",
    NULL},
   {(char*)"eventNo",
    (getter)_FcalBlock_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FcalBlock_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FcalBlock_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"row",
    (getter)_FcalBlock_getRow, (setter)_FcalBlock_setRow,
    (char*)"row value",
    NULL},
   {(char*)"runNo",
    (getter)_FcalBlock_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_FcalBlock_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_FcalBlock_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FcalBlock_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FcalBlock_methods[] = {
   {"addFcalHits", _FcalBlock_addFcalHits, METH_VARARGS,
    "extend (or insert into) the list of fcalHit objects for this fcalBlock"},
   {"addFcalTruthHits", _FcalBlock_addFcalTruthHits, METH_VARARGS,
    "extend (or insert into) the list of fcalTruthHit objects for this fcalBlock"},
   {"deleteFcalHits", _FcalBlock_deleteFcalHits, METH_VARARGS,
    "delete fcalHit objects for this fcalBlock"},
   {"deleteFcalTruthHits", _FcalBlock_deleteFcalTruthHits, METH_VARARGS,
    "delete fcalTruthHit objects for this fcalBlock"},
   {"getFcalHit", _FcalBlock_getFcalHit, METH_VARARGS,
    "get an individual fcalHit object from this fcalBlock"},
   {"getFcalHits", _FcalBlock_getFcalHits, METH_NOARGS,
    "get list of fcalHit objects for this fcalBlock"},
   {"getFcalTruthHit", _FcalBlock_getFcalTruthHit, METH_VARARGS,
    "get an individual fcalTruthHit object from this fcalBlock"},
   {"getFcalTruthHits", _FcalBlock_getFcalTruthHits, METH_NOARGS,
    "get list of fcalTruthHit objects for this fcalBlock"},
   {"toString", _FcalBlock_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FcalBlock_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FcalBlock_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.FcalBlock",         /*tp_name*/
    sizeof(_FcalBlock),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FcalBlock_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FcalBlock_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s fcalBlock element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FcalBlock_methods,          /* tp_methods */
    _FcalBlock_members,          /* tp_members */
    _FcalBlock_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FcalBlock_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FcalBlock_new,              /* tp_new */
};



// wrap element class hddm_s::FcalTruthShower as hddm_s.FcalTruthShower

typedef struct {
   PyObject_HEAD
   FcalTruthShower *elem;
   PyObject *host;
} _FcalTruthShower;

static void
_FcalTruthShower_dealloc(_FcalTruthShower* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_FcalTruthShower_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _FcalTruthShower *self;
   self = (_FcalTruthShower*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_FcalTruthShower_init(_FcalTruthShower *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_FcalTruthShower_getClass(_FcalTruthShower *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalTruthShower_getVersion(_FcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_FcalTruthShower_getXmlns(_FcalTruthShower *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalTruthShower_getEventNo(_FcalTruthShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_FcalTruthShower_getRunNo(_FcalTruthShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_FcalTruthShower_getE(_FcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_FcalTruthShower_setE(_FcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_FcalTruthShower_getMaxOccurs(_FcalTruthShower *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_FcalTruthShower_getMinOccurs(_FcalTruthShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_FcalTruthShower_getPrimary(_FcalTruthShower *self, void *closure)
{
   return PyBool_FromLong(self->elem->getPrimary());
}

static int
_FcalTruthShower_setPrimary(_FcalTruthShower *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPrimary((var==0)? false : true);
   return 0;
}

static PyObject*
_FcalTruthShower_getPtype(_FcalTruthShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPtype());
}

static int
_FcalTruthShower_setPtype(_FcalTruthShower *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPtype(var);
   return 0;
}

static PyObject*
_FcalTruthShower_getPx(_FcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPx());
}

static int
_FcalTruthShower_setPx(_FcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPx((float)var);
   return 0;
}

static PyObject*
_FcalTruthShower_getPy(_FcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPy());
}

static int
_FcalTruthShower_setPy(_FcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPy((float)var);
   return 0;
}

static PyObject*
_FcalTruthShower_getPz(_FcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPz());
}

static int
_FcalTruthShower_setPz(_FcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPz((float)var);
   return 0;
}

static PyObject*
_FcalTruthShower_getT(_FcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_FcalTruthShower_setT(_FcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_FcalTruthShower_getTrack(_FcalTruthShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static int
_FcalTruthShower_setTrack(_FcalTruthShower *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTrack(var);
   return 0;
}

static PyObject*
_FcalTruthShower_getX(_FcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static int
_FcalTruthShower_setX(_FcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setX((float)var);
   return 0;
}

static PyObject*
_FcalTruthShower_getY(_FcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static int
_FcalTruthShower_setY(_FcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setY((float)var);
   return 0;
}

static PyObject*
_FcalTruthShower_getZ(_FcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static int
_FcalTruthShower_setZ(_FcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ((float)var);
   return 0;
}

static PyObject*
_FcalTruthShower_getTrackID(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _FcalTruthShower *me = (_FcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalTruthShower element");
      return NULL;
   }
   PyObject *obj = _TrackID_new(&_TrackID_type, 0, 0);
   ((_TrackID*)obj)->elem = &me->elem->getTrackID();
   ((_TrackID*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_FcalTruthShower_getTrackIDs(PyObject *self, PyObject *args)
{
   _FcalTruthShower *me = (_FcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalTruthShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackID_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTrackIDs();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_FcalTruthShower_addTrackIDs(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FcalTruthShower *me = (_FcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid fcalTruthShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackID_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TrackIDList(me->elem->addTrackIDs(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_FcalTruthShower_deleteTrackIDs(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _FcalTruthShower *me = (_FcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid fcalTruthShower element");
      return NULL;
   }
   me->elem->deleteTrackIDs(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_FcalTruthShower_toString(PyObject *self, PyObject *args=0)
{
   _FcalTruthShower *me = (_FcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalTruthShower element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_FcalTruthShower_toXML(PyObject *self, PyObject *args=0)
{
   _FcalTruthShower *me = (_FcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid fcalTruthShower element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _FcalTruthShower_getsetters[] = {
   {(char*)"E",
    (getter)_FcalTruthShower_getE, (setter)_FcalTruthShower_setE,
    (char*)"E value",
    NULL},
   {(char*)"class",
    (getter)_FcalTruthShower_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_FcalTruthShower_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_FcalTruthShower_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_FcalTruthShower_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"primary",
    (getter)_FcalTruthShower_getPrimary, (setter)_FcalTruthShower_setPrimary,
    (char*)"primary value",
    NULL},
   {(char*)"ptype",
    (getter)_FcalTruthShower_getPtype, (setter)_FcalTruthShower_setPtype,
    (char*)"ptype value",
    NULL},
   {(char*)"px",
    (getter)_FcalTruthShower_getPx, (setter)_FcalTruthShower_setPx,
    (char*)"px value",
    NULL},
   {(char*)"py",
    (getter)_FcalTruthShower_getPy, (setter)_FcalTruthShower_setPy,
    (char*)"py value",
    NULL},
   {(char*)"pz",
    (getter)_FcalTruthShower_getPz, (setter)_FcalTruthShower_setPz,
    (char*)"pz value",
    NULL},
   {(char*)"runNo",
    (getter)_FcalTruthShower_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_FcalTruthShower_getT, (setter)_FcalTruthShower_setT,
    (char*)"t value",
    NULL},
   {(char*)"track",
    (getter)_FcalTruthShower_getTrack, (setter)_FcalTruthShower_setTrack,
    (char*)"track value",
    NULL},
   {(char*)"version",
    (getter)_FcalTruthShower_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"x",
    (getter)_FcalTruthShower_getX, (setter)_FcalTruthShower_setX,
    (char*)"x value",
    NULL},
   {(char*)"xmlns",
    (getter)_FcalTruthShower_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y",
    (getter)_FcalTruthShower_getY, (setter)_FcalTruthShower_setY,
    (char*)"y value",
    NULL},
   {(char*)"z",
    (getter)_FcalTruthShower_getZ, (setter)_FcalTruthShower_setZ,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _FcalTruthShower_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _FcalTruthShower_methods[] = {
   {"addTrackIDs", _FcalTruthShower_addTrackIDs, METH_VARARGS,
    "extend (or insert into) the list of trackID objects for this fcalTruthShower"},
   {"deleteTrackIDs", _FcalTruthShower_deleteTrackIDs, METH_VARARGS,
    "delete trackID objects for this fcalTruthShower"},
   {"getTrackID", _FcalTruthShower_getTrackID, METH_VARARGS,
    "get an individual trackID object from this fcalTruthShower"},
   {"getTrackIDs", _FcalTruthShower_getTrackIDs, METH_NOARGS,
    "get list of trackID objects for this fcalTruthShower"},
   {"toString", _FcalTruthShower_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _FcalTruthShower_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _FcalTruthShower_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.FcalTruthShower",         /*tp_name*/
    sizeof(_FcalTruthShower),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_FcalTruthShower_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_FcalTruthShower_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s fcalTruthShower element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _FcalTruthShower_methods,          /* tp_methods */
    _FcalTruthShower_members,          /* tp_members */
    _FcalTruthShower_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_FcalTruthShower_init,   /* tp_init */
    0,                         /* tp_alloc */
    _FcalTruthShower_new,              /* tp_new */
};



// wrap element class hddm_s::ForwardEMcal as hddm_s.ForwardEMcal

typedef struct {
   PyObject_HEAD
   ForwardEMcal *elem;
   PyObject *host;
} _ForwardEMcal;

static void
_ForwardEMcal_dealloc(_ForwardEMcal* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_ForwardEMcal_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _ForwardEMcal *self;
   self = (_ForwardEMcal*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_ForwardEMcal_init(_ForwardEMcal *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_ForwardEMcal_getClass(_ForwardEMcal *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ForwardEMcal_getVersion(_ForwardEMcal *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_ForwardEMcal_getXmlns(_ForwardEMcal *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ForwardEMcal_getEventNo(_ForwardEMcal *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_ForwardEMcal_getMaxOccurs(_ForwardEMcal *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_ForwardEMcal_getRunNo(_ForwardEMcal *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_ForwardEMcal_getMinOccurs(_ForwardEMcal *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_ForwardEMcal_getFcalBlock(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ForwardEMcal *me = (_ForwardEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid forwardEMcal element");
      return NULL;
   }
   PyObject *obj = _FcalBlock_new(&_FcalBlock_type, 0, 0);
   ((_FcalBlock*)obj)->elem = &me->elem->getFcalBlock(index);
   ((_FcalBlock*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ForwardEMcal_getFcalBlocks(PyObject *self, PyObject *args)
{
   _ForwardEMcal *me = (_ForwardEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid forwardEMcal element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalBlock_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFcalBlocks();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ForwardEMcal_addFcalBlocks(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ForwardEMcal *me = (_ForwardEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid forwardEMcal element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalBlock_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalBlockList(me->elem->addFcalBlocks(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ForwardEMcal_deleteFcalBlocks(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ForwardEMcal *me = (_ForwardEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid forwardEMcal element");
      return NULL;
   }
   me->elem->deleteFcalBlocks(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ForwardEMcal_getFcalTruthShower(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _ForwardEMcal *me = (_ForwardEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid forwardEMcal element");
      return NULL;
   }
   PyObject *obj = _FcalTruthShower_new(&_FcalTruthShower_type, 0, 0);
   ((_FcalTruthShower*)obj)->elem = &me->elem->getFcalTruthShower(index);
   ((_FcalTruthShower*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_ForwardEMcal_getFcalTruthShowers(PyObject *self, PyObject *args)
{
   _ForwardEMcal *me = (_ForwardEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid forwardEMcal element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalTruthShower_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getFcalTruthShowers();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_ForwardEMcal_addFcalTruthShowers(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ForwardEMcal *me = (_ForwardEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid forwardEMcal element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_FcalTruthShower_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new FcalTruthShowerList(me->elem->addFcalTruthShowers(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_ForwardEMcal_deleteFcalTruthShowers(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _ForwardEMcal *me = (_ForwardEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid forwardEMcal element");
      return NULL;
   }
   me->elem->deleteFcalTruthShowers(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_ForwardEMcal_toString(PyObject *self, PyObject *args=0)
{
   _ForwardEMcal *me = (_ForwardEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid forwardEMcal element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_ForwardEMcal_toXML(PyObject *self, PyObject *args=0)
{
   _ForwardEMcal *me = (_ForwardEMcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid forwardEMcal element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _ForwardEMcal_getsetters[] = {
   {(char*)"class",
    (getter)_ForwardEMcal_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_ForwardEMcal_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_ForwardEMcal_getMaxOccurs, 0,
    (char*)"maxOccurs string",
    NULL},
   {(char*)"minOccurs",
    (getter)_ForwardEMcal_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"runNo",
    (getter)_ForwardEMcal_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_ForwardEMcal_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_ForwardEMcal_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _ForwardEMcal_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _ForwardEMcal_methods[] = {
   {"addFcalBlocks", _ForwardEMcal_addFcalBlocks, METH_VARARGS,
    "extend (or insert into) the list of fcalBlock objects for this forwardEMcal"},
   {"addFcalTruthShowers", _ForwardEMcal_addFcalTruthShowers, METH_VARARGS,
    "extend (or insert into) the list of fcalTruthShower objects for this forwardEMcal"},
   {"deleteFcalBlocks", _ForwardEMcal_deleteFcalBlocks, METH_VARARGS,
    "delete fcalBlock objects for this forwardEMcal"},
   {"deleteFcalTruthShowers", _ForwardEMcal_deleteFcalTruthShowers, METH_VARARGS,
    "delete fcalTruthShower objects for this forwardEMcal"},
   {"getFcalBlock", _ForwardEMcal_getFcalBlock, METH_VARARGS,
    "get an individual fcalBlock object from this forwardEMcal"},
   {"getFcalBlocks", _ForwardEMcal_getFcalBlocks, METH_NOARGS,
    "get list of fcalBlock objects for this forwardEMcal"},
   {"getFcalTruthShower", _ForwardEMcal_getFcalTruthShower, METH_VARARGS,
    "get an individual fcalTruthShower object from this forwardEMcal"},
   {"getFcalTruthShowers", _ForwardEMcal_getFcalTruthShowers, METH_NOARGS,
    "get list of fcalTruthShower objects for this forwardEMcal"},
   {"toString", _ForwardEMcal_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _ForwardEMcal_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _ForwardEMcal_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.ForwardEMcal",         /*tp_name*/
    sizeof(_ForwardEMcal),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_ForwardEMcal_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_ForwardEMcal_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s forwardEMcal element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _ForwardEMcal_methods,          /* tp_methods */
    _ForwardEMcal_members,          /* tp_members */
    _ForwardEMcal_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_ForwardEMcal_init,   /* tp_init */
    0,                         /* tp_alloc */
    _ForwardEMcal_new,              /* tp_new */
};



// wrap element class hddm_s::EcalHit as hddm_s.EcalHit

typedef struct {
   PyObject_HEAD
   EcalHit *elem;
   PyObject *host;
} _EcalHit;

static void
_EcalHit_dealloc(_EcalHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_EcalHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _EcalHit *self;
   self = (_EcalHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_EcalHit_init(_EcalHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_EcalHit_getClass(_EcalHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_EcalHit_getVersion(_EcalHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_EcalHit_getXmlns(_EcalHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_EcalHit_getEventNo(_EcalHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_EcalHit_getRunNo(_EcalHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_EcalHit_getMinOccurs(_EcalHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_EcalHit_getColumn(_EcalHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getColumn());
}

static PyObject*
_EcalHit_getRow(_EcalHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRow());
}

static PyObject*
_EcalHit_getE(_EcalHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_EcalHit_setE(_EcalHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_EcalHit_getMaxOccurs(_EcalHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_EcalHit_getT(_EcalHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_EcalHit_setT(_EcalHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_EcalHit_toString(PyObject *self, PyObject *args=0)
{
   _EcalHit *me = (_EcalHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ecalHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_EcalHit_toXML(PyObject *self, PyObject *args=0)
{
   _EcalHit *me = (_EcalHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ecalHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _EcalHit_getsetters[] = {
   {(char*)"E",
    (getter)_EcalHit_getE, (setter)_EcalHit_setE,
    (char*)"E value",
    NULL},
   {(char*)"class",
    (getter)_EcalHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"column",
    (getter)_EcalHit_getColumn, 0,
    (char*)"column value",
    NULL},
   {(char*)"eventNo",
    (getter)_EcalHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_EcalHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_EcalHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"row",
    (getter)_EcalHit_getRow, 0,
    (char*)"row value",
    NULL},
   {(char*)"runNo",
    (getter)_EcalHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_EcalHit_getT, (setter)_EcalHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_EcalHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_EcalHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _EcalHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _EcalHit_methods[] = {
   {"toString", _EcalHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _EcalHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _EcalHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.EcalHit",         /*tp_name*/
    sizeof(_EcalHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_EcalHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_EcalHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s ecalHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _EcalHit_methods,          /* tp_methods */
    _EcalHit_members,          /* tp_members */
    _EcalHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_EcalHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _EcalHit_new,              /* tp_new */
};



// wrap element class hddm_s::EcalTruthHit as hddm_s.EcalTruthHit

typedef struct {
   PyObject_HEAD
   EcalTruthHit *elem;
   PyObject *host;
} _EcalTruthHit;

static void
_EcalTruthHit_dealloc(_EcalTruthHit* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_EcalTruthHit_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _EcalTruthHit *self;
   self = (_EcalTruthHit*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_EcalTruthHit_init(_EcalTruthHit *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_EcalTruthHit_getClass(_EcalTruthHit *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_EcalTruthHit_getVersion(_EcalTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_EcalTruthHit_getXmlns(_EcalTruthHit *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_EcalTruthHit_getEventNo(_EcalTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_EcalTruthHit_getRunNo(_EcalTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_EcalTruthHit_getMinOccurs(_EcalTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_EcalTruthHit_getColumn(_EcalTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getColumn());
}

static PyObject*
_EcalTruthHit_getRow(_EcalTruthHit *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRow());
}

static PyObject*
_EcalTruthHit_getE(_EcalTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_EcalTruthHit_setE(_EcalTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_EcalTruthHit_getMaxOccurs(_EcalTruthHit *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_EcalTruthHit_getT(_EcalTruthHit *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_EcalTruthHit_setT(_EcalTruthHit *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_EcalTruthHit_toString(PyObject *self, PyObject *args=0)
{
   _EcalTruthHit *me = (_EcalTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ecalTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_EcalTruthHit_toXML(PyObject *self, PyObject *args=0)
{
   _EcalTruthHit *me = (_EcalTruthHit*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ecalTruthHit element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _EcalTruthHit_getsetters[] = {
   {(char*)"E",
    (getter)_EcalTruthHit_getE, (setter)_EcalTruthHit_setE,
    (char*)"E value",
    NULL},
   {(char*)"class",
    (getter)_EcalTruthHit_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"column",
    (getter)_EcalTruthHit_getColumn, 0,
    (char*)"column value",
    NULL},
   {(char*)"eventNo",
    (getter)_EcalTruthHit_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_EcalTruthHit_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_EcalTruthHit_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"row",
    (getter)_EcalTruthHit_getRow, 0,
    (char*)"row value",
    NULL},
   {(char*)"runNo",
    (getter)_EcalTruthHit_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_EcalTruthHit_getT, (setter)_EcalTruthHit_setT,
    (char*)"t value",
    NULL},
   {(char*)"version",
    (getter)_EcalTruthHit_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_EcalTruthHit_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _EcalTruthHit_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _EcalTruthHit_methods[] = {
   {"toString", _EcalTruthHit_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _EcalTruthHit_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _EcalTruthHit_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.EcalTruthHit",         /*tp_name*/
    sizeof(_EcalTruthHit),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_EcalTruthHit_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_EcalTruthHit_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s ecalTruthHit element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _EcalTruthHit_methods,          /* tp_methods */
    _EcalTruthHit_members,          /* tp_members */
    _EcalTruthHit_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_EcalTruthHit_init,   /* tp_init */
    0,                         /* tp_alloc */
    _EcalTruthHit_new,              /* tp_new */
};



// wrap element class hddm_s::EcalBlock as hddm_s.EcalBlock

typedef struct {
   PyObject_HEAD
   EcalBlock *elem;
   PyObject *host;
} _EcalBlock;

static void
_EcalBlock_dealloc(_EcalBlock* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_EcalBlock_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _EcalBlock *self;
   self = (_EcalBlock*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_EcalBlock_init(_EcalBlock *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_EcalBlock_getClass(_EcalBlock *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_EcalBlock_getVersion(_EcalBlock *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_EcalBlock_getXmlns(_EcalBlock *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_EcalBlock_getEventNo(_EcalBlock *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_EcalBlock_getRunNo(_EcalBlock *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_EcalBlock_getColumn(_EcalBlock *self, void *closure)
{
   return PyLong_FromLong(self->elem->getColumn());
}

static int
_EcalBlock_setColumn(_EcalBlock *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setColumn(var);
   return 0;
}

static PyObject*
_EcalBlock_getMaxOccurs(_EcalBlock *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_EcalBlock_getMinOccurs(_EcalBlock *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_EcalBlock_getRow(_EcalBlock *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRow());
}

static int
_EcalBlock_setRow(_EcalBlock *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setRow(var);
   return 0;
}

static PyObject*
_EcalBlock_getEcalHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _EcalBlock *me = (_EcalBlock*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ecalBlock element");
      return NULL;
   }
   PyObject *obj = _EcalHit_new(&_EcalHit_type, 0, 0);
   ((_EcalHit*)obj)->elem = &me->elem->getEcalHit(index);
   ((_EcalHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_EcalBlock_getEcalHits(PyObject *self, PyObject *args)
{
   _EcalBlock *me = (_EcalBlock*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ecalBlock element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_EcalHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getEcalHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_EcalBlock_addEcalHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _EcalBlock *me = (_EcalBlock*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid ecalBlock element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_EcalHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new EcalHitList(me->elem->addEcalHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_EcalBlock_deleteEcalHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _EcalBlock *me = (_EcalBlock*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid ecalBlock element");
      return NULL;
   }
   me->elem->deleteEcalHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_EcalBlock_getEcalTruthHit(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _EcalBlock *me = (_EcalBlock*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ecalBlock element");
      return NULL;
   }
   PyObject *obj = _EcalTruthHit_new(&_EcalTruthHit_type, 0, 0);
   ((_EcalTruthHit*)obj)->elem = &me->elem->getEcalTruthHit(index);
   ((_EcalTruthHit*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_EcalBlock_getEcalTruthHits(PyObject *self, PyObject *args)
{
   _EcalBlock *me = (_EcalBlock*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ecalBlock element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_EcalTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getEcalTruthHits();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_EcalBlock_addEcalTruthHits(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _EcalBlock *me = (_EcalBlock*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid ecalBlock element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_EcalTruthHit_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new EcalTruthHitList(me->elem->addEcalTruthHits(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_EcalBlock_deleteEcalTruthHits(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _EcalBlock *me = (_EcalBlock*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid ecalBlock element");
      return NULL;
   }
   me->elem->deleteEcalTruthHits(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_EcalBlock_toString(PyObject *self, PyObject *args=0)
{
   _EcalBlock *me = (_EcalBlock*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ecalBlock element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_EcalBlock_toXML(PyObject *self, PyObject *args=0)
{
   _EcalBlock *me = (_EcalBlock*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ecalBlock element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _EcalBlock_getsetters[] = {
   {(char*)"class",
    (getter)_EcalBlock_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"column",
    (getter)_EcalBlock_getColumn, (setter)_EcalBlock_setColumn,
    (char*)"column value",
    NULL},
   {(char*)"eventNo",
    (getter)_EcalBlock_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_EcalBlock_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_EcalBlock_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"row",
    (getter)_EcalBlock_getRow, (setter)_EcalBlock_setRow,
    (char*)"row value",
    NULL},
   {(char*)"runNo",
    (getter)_EcalBlock_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"version",
    (getter)_EcalBlock_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"xmlns",
    (getter)_EcalBlock_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _EcalBlock_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _EcalBlock_methods[] = {
   {"addEcalHits", _EcalBlock_addEcalHits, METH_VARARGS,
    "extend (or insert into) the list of ecalHit objects for this ecalBlock"},
   {"addEcalTruthHits", _EcalBlock_addEcalTruthHits, METH_VARARGS,
    "extend (or insert into) the list of ecalTruthHit objects for this ecalBlock"},
   {"deleteEcalHits", _EcalBlock_deleteEcalHits, METH_VARARGS,
    "delete ecalHit objects for this ecalBlock"},
   {"deleteEcalTruthHits", _EcalBlock_deleteEcalTruthHits, METH_VARARGS,
    "delete ecalTruthHit objects for this ecalBlock"},
   {"getEcalHit", _EcalBlock_getEcalHit, METH_VARARGS,
    "get an individual ecalHit object from this ecalBlock"},
   {"getEcalHits", _EcalBlock_getEcalHits, METH_NOARGS,
    "get list of ecalHit objects for this ecalBlock"},
   {"getEcalTruthHit", _EcalBlock_getEcalTruthHit, METH_VARARGS,
    "get an individual ecalTruthHit object from this ecalBlock"},
   {"getEcalTruthHits", _EcalBlock_getEcalTruthHits, METH_NOARGS,
    "get list of ecalTruthHit objects for this ecalBlock"},
   {"toString", _EcalBlock_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _EcalBlock_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _EcalBlock_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.EcalBlock",         /*tp_name*/
    sizeof(_EcalBlock),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_EcalBlock_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_EcalBlock_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s ecalBlock element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _EcalBlock_methods,          /* tp_methods */
    _EcalBlock_members,          /* tp_members */
    _EcalBlock_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_EcalBlock_init,   /* tp_init */
    0,                         /* tp_alloc */
    _EcalBlock_new,              /* tp_new */
};



// wrap element class hddm_s::EcalTruthShower as hddm_s.EcalTruthShower

typedef struct {
   PyObject_HEAD
   EcalTruthShower *elem;
   PyObject *host;
} _EcalTruthShower;

static void
_EcalTruthShower_dealloc(_EcalTruthShower* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_EcalTruthShower_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _EcalTruthShower *self;
   self = (_EcalTruthShower*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_EcalTruthShower_init(_EcalTruthShower *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_EcalTruthShower_getClass(_EcalTruthShower *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_EcalTruthShower_getVersion(_EcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_EcalTruthShower_getXmlns(_EcalTruthShower *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_EcalTruthShower_getEventNo(_EcalTruthShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_EcalTruthShower_getRunNo(_EcalTruthShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_EcalTruthShower_getE(_EcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getE());
}

static int
_EcalTruthShower_setE(_EcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setE((float)var);
   return 0;
}

static PyObject*
_EcalTruthShower_getMaxOccurs(_EcalTruthShower *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_EcalTruthShower_getMinOccurs(_EcalTruthShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_EcalTruthShower_getPrimary(_EcalTruthShower *self, void *closure)
{
   return PyBool_FromLong(self->elem->getPrimary());
}

static int
_EcalTruthShower_setPrimary(_EcalTruthShower *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPrimary((var==0)? false : true);
   return 0;
}

static PyObject*
_EcalTruthShower_getPtype(_EcalTruthShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getPtype());
}

static int
_EcalTruthShower_setPtype(_EcalTruthShower *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setPtype(var);
   return 0;
}

static PyObject*
_EcalTruthShower_getPx(_EcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPx());
}

static int
_EcalTruthShower_setPx(_EcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPx((float)var);
   return 0;
}

static PyObject*
_EcalTruthShower_getPy(_EcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPy());
}

static int
_EcalTruthShower_setPy(_EcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPy((float)var);
   return 0;
}

static PyObject*
_EcalTruthShower_getPz(_EcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getPz());
}

static int
_EcalTruthShower_setPz(_EcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setPz((float)var);
   return 0;
}

static PyObject*
_EcalTruthShower_getT(_EcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getT());
}

static int
_EcalTruthShower_setT(_EcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setT((float)var);
   return 0;
}

static PyObject*
_EcalTruthShower_getTrack(_EcalTruthShower *self, void *closure)
{
   return PyLong_FromLong(self->elem->getTrack());
}

static int
_EcalTruthShower_setTrack(_EcalTruthShower *self, PyObject *value, void *closure)
{
   long var = PyInt_AsLong(value);
   if (var == -1 && PyErr_Occurred()) {
      return -1;
   }
   self->elem->setTrack(var);
   return 0;
}

static PyObject*
_EcalTruthShower_getX(_EcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getX());
}

static int
_EcalTruthShower_setX(_EcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setX((float)var);
   return 0;
}

static PyObject*
_EcalTruthShower_getY(_EcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getY());
}

static int
_EcalTruthShower_setY(_EcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setY((float)var);
   return 0;
}

static PyObject*
_EcalTruthShower_getZ(_EcalTruthShower *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getZ());
}

static int
_EcalTruthShower_setZ(_EcalTruthShower *self, PyObject *value, void *closure)
{
   double var = PyFloat_AsDouble(value);
   if (var == -1 && PyErr_Occurred()) {
      return 1;
   }
   self->elem->setZ((float)var);
   return 0;
}

static PyObject*
_EcalTruthShower_getTrackID(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _EcalTruthShower *me = (_EcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ecalTruthShower element");
      return NULL;
   }
   PyObject *obj = _TrackID_new(&_TrackID_type, 0, 0);
   ((_TrackID*)obj)->elem = &me->elem->getTrackID();
   ((_TrackID*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_EcalTruthShower_getTrackIDs(PyObject *self, PyObject *args)
{
   _EcalTruthShower *me = (_EcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ecalTruthShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackID_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getTrackIDs();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_EcalTruthShower_addTrackIDs(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _EcalTruthShower *me = (_EcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid ecalTruthShower element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_TrackID_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new TrackIDList(me->elem->addTrackIDs(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_EcalTruthShower_deleteTrackIDs(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _EcalTruthShower *me = (_EcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid ecalTruthShower element");
      return NULL;
   }
   me->elem->deleteTrackIDs(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_EcalTruthShower_toString(PyObject *self, PyObject *args=0)
{
   _EcalTruthShower *me = (_EcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ecalTruthShower element");
      return NULL;
   }
   std::string str(me->elem->toString());
   return PyUnicode_FromString(str.c_str());
}

static PyObject*
_EcalTruthShower_toXML(PyObject *self, PyObject *args=0)
{
   _EcalTruthShower *me = (_EcalTruthShower*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid ecalTruthShower element");
      return NULL;
   }
   std::string str(me->elem->toXML());
   return PyUnicode_FromString(str.c_str());
}

static PyGetSetDef _EcalTruthShower_getsetters[] = {
   {(char*)"E",
    (getter)_EcalTruthShower_getE, (setter)_EcalTruthShower_setE,
    (char*)"E value",
    NULL},
   {(char*)"class",
    (getter)_EcalTruthShower_getClass, 0,
    (char*)"class string",
    NULL},
   {(char*)"eventNo",
    (getter)_EcalTruthShower_getEventNo, 0,
    (char*)"eventNo value",
    NULL},
   {(char*)"maxOccurs",
    (getter)_EcalTruthShower_getMaxOccurs, 0,
    (char*)"maxOccurs value",
    NULL},
   {(char*)"minOccurs",
    (getter)_EcalTruthShower_getMinOccurs, 0,
    (char*)"minOccurs value",
    NULL},
   {(char*)"primary",
    (getter)_EcalTruthShower_getPrimary, (setter)_EcalTruthShower_setPrimary,
    (char*)"primary value",
    NULL},
   {(char*)"ptype",
    (getter)_EcalTruthShower_getPtype, (setter)_EcalTruthShower_setPtype,
    (char*)"ptype value",
    NULL},
   {(char*)"px",
    (getter)_EcalTruthShower_getPx, (setter)_EcalTruthShower_setPx,
    (char*)"px value",
    NULL},
   {(char*)"py",
    (getter)_EcalTruthShower_getPy, (setter)_EcalTruthShower_setPy,
    (char*)"py value",
    NULL},
   {(char*)"pz",
    (getter)_EcalTruthShower_getPz, (setter)_EcalTruthShower_setPz,
    (char*)"pz value",
    NULL},
   {(char*)"runNo",
    (getter)_EcalTruthShower_getRunNo, 0,
    (char*)"runNo value",
    NULL},
   {(char*)"t",
    (getter)_EcalTruthShower_getT, (setter)_EcalTruthShower_setT,
    (char*)"t value",
    NULL},
   {(char*)"track",
    (getter)_EcalTruthShower_getTrack, (setter)_EcalTruthShower_setTrack,
    (char*)"track value",
    NULL},
   {(char*)"version",
    (getter)_EcalTruthShower_getVersion, 0,
    (char*)"version value",
    NULL},
   {(char*)"x",
    (getter)_EcalTruthShower_getX, (setter)_EcalTruthShower_setX,
    (char*)"x value",
    NULL},
   {(char*)"xmlns",
    (getter)_EcalTruthShower_getXmlns, 0,
    (char*)"xmlns string",
    NULL},
   {(char*)"y",
    (getter)_EcalTruthShower_getY, (setter)_EcalTruthShower_setY,
    (char*)"y value",
    NULL},
   {(char*)"z",
    (getter)_EcalTruthShower_getZ, (setter)_EcalTruthShower_setZ,
    (char*)"z value",
    NULL},
   {NULL}  /* Sentinel */
};

static PyMemberDef _EcalTruthShower_members[] = {
   {NULL}  /* Sentinel */
};

static PyMethodDef _EcalTruthShower_methods[] = {
   {"addTrackIDs", _EcalTruthShower_addTrackIDs, METH_VARARGS,
    "extend (or insert into) the list of trackID objects for this ecalTruthShower"},
   {"deleteTrackIDs", _EcalTruthShower_deleteTrackIDs, METH_VARARGS,
    "delete trackID objects for this ecalTruthShower"},
   {"getTrackID", _EcalTruthShower_getTrackID, METH_VARARGS,
    "get an individual trackID object from this ecalTruthShower"},
   {"getTrackIDs", _EcalTruthShower_getTrackIDs, METH_NOARGS,
    "get list of trackID objects for this ecalTruthShower"},
   {"toString", _EcalTruthShower_toString, METH_NOARGS,
    "show element as a human-readable string"},
   {"toXML", _EcalTruthShower_toXML, METH_NOARGS,
    "show element as a XML fragment"},
   {NULL}  /* Sentinel */
};

static PyTypeObject _EcalTruthShower_type = {
    PyVarObject_HEAD_INIT(NULL,0)
    "hddm_s.EcalTruthShower",         /*tp_name*/
    sizeof(_EcalTruthShower),          /*tp_basicsize*/
    0,                         /*tp_itemsize*/
    (destructor)_EcalTruthShower_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    0,                         /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    (reprfunc)_EcalTruthShower_toString,         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
    "hddm_s ecalTruthShower element",  /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    _EcalTruthShower_methods,          /* tp_methods */
    _EcalTruthShower_members,          /* tp_members */
    _EcalTruthShower_getsetters,       /* tp_getset */
    &_HDDM_Element_type,       /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)_EcalTruthShower_init,   /* tp_init */
    0,                         /* tp_alloc */
    _EcalTruthShower_new,              /* tp_new */
};



// wrap element class hddm_s::CrystalEcal as hddm_s.CrystalEcal

typedef struct {
   PyObject_HEAD
   CrystalEcal *elem;
   PyObject *host;
} _CrystalEcal;

static void
_CrystalEcal_dealloc(_CrystalEcal* self)
{
   if (self->elem != 0) {
      LOG_DEALLOC(Py_TYPE(self), 0, self->host == (PyObject*)self);
      if (self->host == (PyObject*)self)
         delete self->elem;
      else
         My_DECREF(self->host);
   }
   Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_CrystalEcal_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
   _CrystalEcal *self;
   self = (_CrystalEcal*)type->tp_alloc(type, 0);
   if (self != NULL) {
      self->elem = 0;
      self->host = 0;
   }
   return (PyObject*)self;
}

static int
_CrystalEcal_init(_CrystalEcal *self, PyObject *args, PyObject *kwds)
{
   PyErr_SetString(PyExc_RuntimeError, "illegal constructor");
   return -1;
}

static PyObject*
_CrystalEcal_getClass(_CrystalEcal *self, void *closure)
{
   std::string val(self->elem->getClass());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CrystalEcal_getVersion(_CrystalEcal *self, void *closure)
{
   return PyFloat_FromDouble(self->elem->getVersion());
}

static PyObject*
_CrystalEcal_getXmlns(_CrystalEcal *self, void *closure)
{
   std::string val(self->elem->getXmlns());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CrystalEcal_getEventNo(_CrystalEcal *self, void *closure)
{
   return PyLong_FromLong(self->elem->getEventNo());
}

static PyObject*
_CrystalEcal_getMaxOccurs(_CrystalEcal *self, void *closure)
{
   std::string val(self->elem->getMaxOccurs());
   return PyUnicode_FromString(val.c_str());
}

static PyObject*
_CrystalEcal_getRunNo(_CrystalEcal *self, void *closure)
{
   return PyLong_FromLong(self->elem->getRunNo());
}

static PyObject*
_CrystalEcal_getMinOccurs(_CrystalEcal *self, void *closure)
{
   return PyLong_FromLong(self->elem->getMinOccurs());
}

static PyObject*
_CrystalEcal_getEcalBlock(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _CrystalEcal *me = (_CrystalEcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid CrystalEcal element");
      return NULL;
   }
   PyObject *obj = _EcalBlock_new(&_EcalBlock_type, 0, 0);
   ((_EcalBlock*)obj)->elem = &me->elem->getEcalBlock(index);
   ((_EcalBlock*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_CrystalEcal_getEcalBlocks(PyObject *self, PyObject *args)
{
   _CrystalEcal *me = (_CrystalEcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid CrystalEcal element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_EcalBlock_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getEcalBlocks();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_CrystalEcal_addEcalBlocks(PyObject *self, PyObject *args)
{
   int count=1;
   int start=-1;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CrystalEcal *me = (_CrystalEcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "add attempted on invalid CrystalEcal element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_EcalBlock_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    new EcalBlockList(me->elem->addEcalBlocks(count, start));
   ((_HDDM_ElementList*)list)->borrowed = 0;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 1);
   return list;
}

static PyObject*
_CrystalEcal_deleteEcalBlocks(PyObject *self, PyObject *args)
{
   int count=-1;
   int start=0;
   if (! PyArg_ParseTuple(args, "|ii", &count, &start)) {
      return NULL;
   }
   _CrystalEcal *me = (_CrystalEcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "delete attempted on invalid CrystalEcal element");
      return NULL;
   }
   me->elem->deleteEcalBlocks(count, start);
   Py_INCREF(Py_None);
   return Py_None;
}

static PyObject*
_CrystalEcal_getEcalTruthShower(PyObject *self, PyObject *args)
{
   int index=0;
   if (! PyArg_ParseTuple(args, "|i", &index)) {
      return NULL;
   }
   _CrystalEcal *me = (_CrystalEcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid CrystalEcal element");
      return NULL;
   }
   PyObject *obj = _EcalTruthShower_new(&_EcalTruthShower_type, 0, 0);
   ((_EcalTruthShower*)obj)->elem = &me->elem->getEcalTruthShower(index);
   ((_EcalTruthShower*)obj)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(obj));
   return obj;
}

static PyObject*
_CrystalEcal_getEcalTruthShowers(PyObject *self, PyObject *args)
{
   _CrystalEcal *me = (_CrystalEcal*)self;
   if (me->elem == 0) {
      PyErr_SetString(PyExc_RuntimeError, "lookup attempted on invalid CrystalEcal element");
      return NULL;
   }
   PyObject *list = _HDDM_ElementList_new(&_HDDM_ElementList_type, 0, 0);
   ((_HDDM_ElementList*)list)->subtype = &_EcalTruthShower_type;
   ((_HDDM_ElementList*)list)->list = (HDDM_ElementList<HDDM_Element>*)
    &me->elem->getEcalTruthShowers();
   ((_HDDM_ElementList*)list)->borrowed = 1;
   ((_HDDM_ElementList*)list)->host = me->host;
   My_INCREF(me->host);
   LOG_NEW(Py_TYPE(list), ((_HDDM_ElementList*)list)->subtype, 0);
   return list;
}

static PyObject*
_CrystalEcal_addEcalTruthShowers(PyObject *self, PyObject *args)
{
   int count=