#
# This file was generated by the hddm-py utility
# from the project https://github.com/rjones30/HDDM
#
import glob
import sys
import os
import sysconfig
from distutils.core import setup, Extension
from shutil import copyfile, rmtree
import re

# Remove the "-Wstrict-prototypes" compiler options,
# which isn't valid for C++
import distutils.sysconfig
cfg_vars = distutils.sysconfig.get_config_vars()
for key,value in cfg_vars.items():
   if type(value) == str:
      cfg_vars[key] = value.replace("-Wstrict-prototypes", "")

os.environ['CC'] = 'g++'  # distutils uses compiler options unique to gcc

build_dir = 'build_hddm_s'
if len(sys.argv) == 1:
   sys.argv += ['build', '-b', build_dir]

source_dir = os.path.dirname(os.path.realpath(__file__))
if 'HDDM_DIR' in os.environ:
   hddm_dir = os.environ['HDDM_DIR']
else:
   print('HDDM_DIR not defined, module creation failed!')
   print('environment is:')
   for key in os.environ:
     print('  {0}: {1}'.format(key, os.environ[key]))
   sys.exit(1)
source_file = 'pyhddm_s.cpp'
source_files = [source_file, os.path.join(source_dir, 'hddm_s++.cpp')]
copyfile(os.path.join(source_dir, 'pyhddm_s.cpy'), source_file)
my_include_dirs = [source_dir, os.path.join(hddm_dir, 'include')]
my_library_dirs = [os.path.join(hddm_dir, 'lib'),
                   os.path.join(hddm_dir, 'lib64'),
                   os.path.join(os.sep, 'usr', 'lib64'),
                  ]
my_libraries = [
                'xstream',
                'bz2',
               ]
for dir in my_library_dirs:
   for libz in ['libz.a', 'libz.so']:
      if os.path.exists(os.path.join(dir, libz)):
          my_libraries.append('z')
          break
   for zlib in ['zlibstatic.lib']:
      if os.path.exists(os.path.join(dir, zlib)):
          my_libraries.append('zlibstatic')
          break
   for zlib in ['zlib.lib']:
      if os.path.exists(os.path.join(dir, zlib)):
          my_libraries.append('zlib')
          break
   for libpthread in ['libpthread.a', 'libpthread.so']:
      if os.path.exists(os.path.join(dir, libpthread)):
          my_libraries.append('pthread')
          break
   for libpthread in ['libpthreadVC3.lib', 'pthreadVC3.lib']:
      if os.path.exists(os.path.join(dir, libpthread)):
          my_libraries.append('libpthreadVC3')
          my_libraries.append('Ws2_32')
          break
if 'XSTREAM_SRC' in os.environ:
   xstream_src = os.environ['XSTREAM_SRC']
   my_include_dirs += [os.path.join(xstream_src, 'include')]
if 'HDDM_SRC' in os.environ:
   hddm_src = os.environ['HDDM_SRC']
   my_include_dirs += [hddm_src]
if 'XSTREAM_DIR' in os.environ:
   xstream_dir = os.environ['XSTREAM_DIR']
   xstream_libdir = os.path.join(xstream_dir, 'src')
   for lib in os.listdir(xstream_libdir):
      if lib == 'libxstream.a':
         my_library_dirs += [xstream_libdir]
      elif lib == 'Release':
         my_library_dirs += [os.path.join(xstream_libdir, 'Release')]
if 'COMPILER_STD_OPTION' in os.environ:
   my_extra_cxxflags = [os.environ['COMPILER_STD_OPTION']]
else:
   my_extra_cxxflags = ['-std=c++11']
if 'HDF5_INCLUDE_DIRS' in os.environ:
   for idir in os.environ['HDF5_INCLUDE_DIRS'].split(','):
      my_include_dirs += [idir,]
if 'HDF5_LIBRARIES' in os.environ:
   for lib in os.environ['HDF5_LIBRARIES'].split(','):
      my_libraries += [re.sub(r'\.[^\.]*$', '', re.sub('.*/lib/*', '', lib))]
   my_extra_cxxflags += ['-DHDF5_SUPPORT']
for lib in glob.glob(os.path.join(hddm_dir, 'lib*', 'libhddmstream*')):
   my_libraries += [re.sub(r'\.so$', '', re.sub('.*/lib', '', lib))]

if 'HTTP_ISTREAM' in os.environ:
   my_include_dirs.insert(0, os.path.join(hddm_src, '..', 'httpstream'))
   for lib in os.listdir(os.environ['HTTP_ISTREAM']):
      if lib == 'libhttpstream.a':
         my_library_dirs.insert(0, os.environ['HTTP_ISTREAM'])
      elif lib == 'Release':
         my_library_dirs.insert(0, os.path.join(os.environ['HTTP_ISTREAM'], 'Release'))
   my_extra_cxxflags += ['-DISTREAM_OVER_HTTP']
   my_libraries += ['httpstream']
   my_libraries += os.environ['HTTP_ISTREAM_LIBS'].split(',')
if 'XROOTD_ISTREAM' in os.environ:
   my_include_dirs.insert(0, os.path.join(hddm_dir, 'include', 'xrootd'))
   my_include_dirs.insert(0, os.path.join(hddm_src, '..', 'xrootdstream'))
   for lib in os.listdir(os.environ['XROOTD_ISTREAM']):
      if lib == 'libxrootdstream.a':
         my_library_dirs.insert(0, os.environ['XROOTD_ISTREAM'])
      elif lib == 'Release':
         my_library_dirs.insert(0, os.path.join(os.environ['XROOTD_ISTREAM'], 'Release'))
   my_extra_cxxflags += ['-DISTREAM_OVER_XROOTD']
   my_libraries += ['xrootdstream']
   my_libraries += os.environ['XROOTD_ISTREAM_LIBS'].split(',')
if 'macos' in sysconfig.get_platform():
   my_extra_cxxflags += ['-mmacosx-version-min=10.15']
print('my_include_dirs are', my_include_dirs)
print('my_library_dirs are', my_library_dirs)
print('my_libraries are', my_libraries)
module1 = Extension('hddm_s',
                    include_dirs = my_include_dirs,
                    library_dirs = my_library_dirs,
                    libraries = my_libraries,
                    extra_compile_args = my_extra_cxxflags,
                    sources = source_files)

setup (name = 'hddm_s',
       version = '1.0',
       description = 'HDDM data model i/o package',
       ext_modules = [module1])

os.remove(source_file)
for dname in os.listdir(build_dir):
    for dll in os.listdir(os.path.join(build_dir, dname)):
        if re.match(r'.*\.so', dll):
            src = os.path.join(build_dir, dname, dll)
            dest = os.path.join(source_dir, dll)
            copyfile(src, dest)
        elif re.match(r'.*\.pyd', dll):
            src = os.path.join(build_dir, dname, dll)
            dest = os.path.join(source_dir, dll)
            copyfile(src, dest)
#rmtree(build_dir)
