# -*- coding: utf-8 -*-
"""
Created on Sun Nov 29 19:05:53 2015

@author: Ben
"""
import matplotlib as _mpl
import os as _os
import numpy as _np

#Create lists of colors to cycle through when creating plots with multiple 
#curves, markers, etc.
c_lists = {}
c_lists['std'] = [[1,0,0], [0,0,1], [0,.65,0], [1,.5,0], [1,0,1], [0.6,0.4,0.2], \
    [0.0,0.7,1], [0.5,0.0,0.5], [0.55,0.7,0]]
std_np = _np.array(c_lists['std'])
#Uniformly scale down all the colors to create sets of darker colors
c_lists['dark'] = [list(a) for a in std_np * 0.5]
c_lists['darker'] = [list(a) for a in std_np * 0.35]
#Create pastel version of the color list
#These were generated by setting the alpha channel to 0.7, and then using the
#following pseudocode to overlay plain RGB values with a background
#Target = (BG + Source) =
#Target.R = ((1 - Source.A) * BG.R) + (Source.A * Source.R)
#Target.G = ((1 - Source.A) * BG.G) + (Source.A * Source.G)
#Target.B = ((1 - Source.A) * BG.B) + (Source.A * Source.B)
alpha = 0.7
bg = _np.array([1.0, 1.0, 1.0])
pastel_np = (1.0 - alpha) * bg + (alpha * std_np)
c_lists['pastel'] = [list(a) for a in pastel_np]
#Clean up so code introspection only shows variables the user may want to modify
del alpha, bg, pastel_np, std_np

#Load custom colormaps
#(These colormaps were originally stored in a pickle file and loaded upon
#importing clearplot.  This caused issues with github and PyPI (see Issue #1 
#on github).  Instead we load the colormap definitions from csv files.)
#Read the color map directory to the list of color map names
def _load_c_maps():
    c_map_dir = _os.path.join(_os.path.dirname(__file__), 'color_maps')
    c_map_datafile_names = _os.listdir(c_map_dir)
    c_maps = {}
    for c_map_datafile_name in c_map_datafile_names:
        c_map_name = c_map_datafile_name[:-4]
        c_map_data_path = _os.path.join(c_map_dir, c_map_datafile_name)
        c_map_data = _np.loadtxt(c_map_data_path, delimiter = ',')
        c_maps[c_map_name] = _mpl.colors.ListedColormap(c_map_data)
    return(c_maps)

c_maps = _load_c_maps()