"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultCloudFrontDisributionForMediaStoreProps = exports.DefaultCloudFrontWebDistributionForS3Props = exports.DefaultCloudFrontWebDistributionForApiGatewayProps = void 0;
const cloudfront = require("aws-cdk-lib/aws-cloudfront");
const aws_cloudfront_1 = require("aws-cdk-lib/aws-cloudfront");
const origins = require("aws-cdk-lib/aws-cloudfront-origins");
const cdk = require("aws-cdk-lib");
function DefaultCloudFrontWebDistributionForApiGatewayProps(apiEndPoint, loggingBucket, setHttpSecurityHeaders, cfFunction) {
    const apiEndPointUrlWithoutProtocol = cdk.Fn.select(1, cdk.Fn.split("://", apiEndPoint.url));
    const apiEndPointDomainName = cdk.Fn.select(0, cdk.Fn.split("/", apiEndPointUrlWithoutProtocol));
    return {
        defaultBehavior: {
            origin: new origins.HttpOrigin(apiEndPointDomainName, {
                originPath: `/${apiEndPoint.deploymentStage.stageName}`
            }),
            ...getFunctionAssociationsProp(setHttpSecurityHeaders, cfFunction),
            viewerProtocolPolicy: cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS
        },
        enableLogging: true,
        logBucket: loggingBucket,
    };
}
exports.DefaultCloudFrontWebDistributionForApiGatewayProps = DefaultCloudFrontWebDistributionForApiGatewayProps;
function DefaultCloudFrontWebDistributionForS3Props(sourceBucket, loggingBucket, setHttpSecurityHeaders, originPath, cfFunction) {
    let origin;
    if (originPath) {
        origin = new origins.S3Origin(sourceBucket, { originPath });
    }
    else {
        origin = new origins.S3Origin(sourceBucket);
    }
    return {
        defaultBehavior: {
            origin,
            viewerProtocolPolicy: cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
            ...getFunctionAssociationsProp(setHttpSecurityHeaders, cfFunction)
        },
        enableLogging: true,
        logBucket: loggingBucket,
        defaultRootObject: 'index.html'
    };
}
exports.DefaultCloudFrontWebDistributionForS3Props = DefaultCloudFrontWebDistributionForS3Props;
function DefaultCloudFrontDisributionForMediaStoreProps(mediastoreContainer, loggingBucket, originRequestPolicy, setHttpSecurityHeaders, customHeaders, cfFunction) {
    const mediaStoreContainerUrlWithoutProtocol = cdk.Fn.select(1, cdk.Fn.split('://', mediastoreContainer.attrEndpoint));
    const mediaStoreContainerDomainName = cdk.Fn.select(0, cdk.Fn.split('/', mediaStoreContainerUrlWithoutProtocol));
    const httpOrigin = customHeaders ?
        new origins.HttpOrigin(mediaStoreContainerDomainName, { customHeaders }) :
        new origins.HttpOrigin(mediaStoreContainerDomainName);
    return {
        defaultBehavior: {
            origin: httpOrigin,
            viewerProtocolPolicy: cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
            allowedMethods: cloudfront.AllowedMethods.ALLOW_GET_HEAD_OPTIONS,
            cachedMethods: cloudfront.CachedMethods.CACHE_GET_HEAD_OPTIONS,
            originRequestPolicy,
            ...getFunctionAssociationsProp(setHttpSecurityHeaders, cfFunction)
        },
        enableLogging: true,
        logBucket: loggingBucket
    };
}
exports.DefaultCloudFrontDisributionForMediaStoreProps = DefaultCloudFrontDisributionForMediaStoreProps;
function getFunctionAssociationsProp(setHttpSecurityHeaders, cfFunction) {
    return (setHttpSecurityHeaders && cfFunction) ? {
        functionAssociations: [
            {
                eventType: aws_cloudfront_1.FunctionEventType.VIEWER_RESPONSE,
                function: cfFunction
            }
        ]
    } : {};
}
//# sourceMappingURL=data:application/json;base64,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