"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildEventBus = void 0;
const events = require("aws-cdk-lib/aws-events");
function buildEventBus(scope, props) {
    // Check whether existing EventBus is provided
    if (props.existingEventBusInterface) {
        return props.existingEventBusInterface;
    }
    else if (props.eventBusProps) {
        // eventBusProps is provided, create a new EventBus
        const _eventBusName = props.eventBusProps.eventBusName || 'CustomEventBus';
        return new events.EventBus(scope, _eventBusName, props.eventBusProps);
    }
    return;
}
exports.buildEventBus = buildEventBus;
//# sourceMappingURL=data:application/json;base64,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