"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckListValues = exports.CheckProps = void 0;
function CheckProps(propsObject) {
    var _a, _b;
    let errorMessages = '';
    let errorFound = false;
    if (propsObject.loadBalancerProps && propsObject.existingLoadBalancerObj) {
        errorMessages += 'Error - Either provide loadBalancerProps or existingLoadBalancerObj, but not both.\n';
        errorFound = true;
    }
    if (propsObject.dynamoTableProps && propsObject.existingTableObj) {
        errorMessages += 'Error - Either provide existingTableObj or dynamoTableProps, but not both.\n';
        errorFound = true;
    }
    if (propsObject.dynamoTableProps && propsObject.existingTableInterface) {
        errorMessages += 'Error - Either provide existingTableInterface or dynamoTableProps, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingStreamObj && propsObject.kinesisStreamProps) {
        errorMessages += 'Error - Either provide existingStreamObj or kinesisStreamProps, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingLambdaObj && propsObject.lambdaFunctionProps) {
        errorMessages += 'Error - Either provide lambdaFunctionProps or existingLambdaObj, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingQueueObj && propsObject.queueProps) {
        errorMessages += 'Error - Either provide queueProps or existingQueueObj, but not both.\n';
        errorFound = true;
    }
    if (((propsObject === null || propsObject === void 0 ? void 0 : propsObject.deployDeadLetterQueue) === false) && propsObject.deadLetterQueueProps) {
        errorMessages += 'Error - If deployDeadLetterQueue is false then deadLetterQueueProps cannot be specified.\n';
        errorFound = true;
    }
    const isQueueFifo = (_a = propsObject === null || propsObject === void 0 ? void 0 : propsObject.queueProps) === null || _a === void 0 ? void 0 : _a.fifo;
    const isDeadLetterQueueFifo = (_b = propsObject === null || propsObject === void 0 ? void 0 : propsObject.deadLetterQueueProps) === null || _b === void 0 ? void 0 : _b.fifo;
    const deployDeadLetterQueue = propsObject.deployDeadLetterQueue || propsObject.deployDeadLetterQueue === undefined;
    if (deployDeadLetterQueue && (isQueueFifo !== isDeadLetterQueueFifo)) {
        errorMessages += 'Error - If you specify a fifo: true in either queueProps or deadLetterQueueProps, you must also set fifo: true in the other props object. \
    Fifo must match for the Queue and the Dead Letter Queue.\n';
        errorFound = true;
    }
    if (propsObject.existingMediaStoreContainerObj && propsObject.mediaStoreContainerProps) {
        errorMessages += 'Error - Either provide mediaStoreContainerProps or existingMediaStoreContainerObj, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingBucketObj && propsObject.bucketProps) {
        errorMessages += 'Error - Either provide bucketProps or existingBucketObj, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingBucketInterface && propsObject.bucketProps) {
        errorMessages += 'Error - Either provide bucketProps or existingBucketInterface, but not both.\n';
        errorFound = true;
    }
    if ((propsObject.topicProps) && propsObject.existingTopicObj) {
        errorMessages += 'Error - Either provide topicProps or existingTopicObj, but not both.\n';
        errorFound = true;
    }
    if (propsObject.glueJobProps && propsObject.existingGlueJob) {
        errorMessages += 'Error - Either provide glueJobProps or existingGlueJob, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingSagemakerEndpointObj && propsObject.endpointProps) {
        errorMessages += 'Error - Either provide endpointProps or existingSagemakerEndpointObj, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingSecretObj && propsObject.secretProps) {
        errorMessages += 'Error - Either provide secretProps or existingSecretObj, but not both.\n';
        errorFound = true;
    }
    if ((propsObject.deployVpc || propsObject.vpcProps) && propsObject.existingVpc) {
        errorMessages += 'Error - Either provide an existingVpc or some combination of deployVpc and vpcProps, but not both.\n';
        errorFound = true;
    }
    if (propsObject.encryptionKey && propsObject.encryptionKeyProps) {
        errorMessages += 'Error - Either provide encryptionKey or encryptionKeyProps, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingEventBusInterface && propsObject.eventBusProps) {
        errorMessages += 'Error - Either provide existingEventBusInterface or eventBusProps, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingWebaclObj && propsObject.webaclProps) {
        errorMessages += 'Error - Either provide existingWebaclObj or webaclProps, but not both.\n';
        errorFound = true;
    }
    if (((propsObject === null || propsObject === void 0 ? void 0 : propsObject.logAlbAccessLogs) === false) && (propsObject.albLoggingBucketProps)) {
        errorMessages += 'Error - If logAlbAccessLogs is false, supplying albLoggingBucketProps is invalid.\n';
        errorFound = true;
    }
    if (propsObject.existingLoggingBucketObj && propsObject.loggingBucketProps) {
        errorMessages += 'Error - Either provide existingLoggingBucketObj or loggingBucketProps, but not both.\n';
        errorFound = true;
    }
    if (((propsObject === null || propsObject === void 0 ? void 0 : propsObject.logS3AccessLogs) === false) && (propsObject.loggingBucketProps || propsObject.existingLoggingBucketObj)) {
        errorMessages += 'Error - If logS3AccessLogs is false, supplying loggingBucketProps or existingLoggingBucketObj is invalid.\n';
        errorFound = true;
    }
    if (propsObject.existingBucketObj && (propsObject.loggingBucketProps || propsObject.logS3AccessLogs)) {
        errorMessages += 'Error - If existingBucketObj is provided, supplying loggingBucketProps or logS3AccessLogs is an error.\n';
        errorFound = true;
    }
    if (errorFound) {
        throw new Error(errorMessages);
    }
}
exports.CheckProps = CheckProps;
function CheckListValues(allowedPermissions, submittedValues, valueType) {
    submittedValues.forEach((submittedValue) => {
        if (!allowedPermissions.includes(submittedValue)) {
            throw Error(`Invalid ${valueType} submitted - ${submittedValue}`);
        }
    });
}
exports.CheckListValues = CheckListValues;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5wdXQtdmFsaWRhdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImlucHV0LXZhbGlkYXRpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7Ozs7Ozs7OztHQVdHOzs7QUFxRUgsU0FBZ0IsVUFBVSxDQUFDLFdBQWdDOztJQUN6RCxJQUFJLGFBQWEsR0FBRyxFQUFFLENBQUM7SUFDdkIsSUFBSSxVQUFVLEdBQUcsS0FBSyxDQUFDO0lBRXZCLElBQUksV0FBVyxDQUFDLGlCQUFpQixJQUFJLFdBQVcsQ0FBQyx1QkFBdUIsRUFBRTtRQUN4RSxhQUFhLElBQUksc0ZBQXNGLENBQUM7UUFDeEcsVUFBVSxHQUFHLElBQUksQ0FBQztLQUNuQjtJQUVELElBQUksV0FBVyxDQUFDLGdCQUFnQixJQUFJLFdBQVcsQ0FBQyxnQkFBZ0IsRUFBRTtRQUNoRSxhQUFhLElBQUksOEVBQThFLENBQUM7UUFDaEcsVUFBVSxHQUFHLElBQUksQ0FBQztLQUNuQjtJQUVELElBQUksV0FBVyxDQUFDLGdCQUFnQixJQUFJLFdBQVcsQ0FBQyxzQkFBc0IsRUFBRTtRQUN0RSxhQUFhLElBQUksb0ZBQW9GLENBQUM7UUFDdEcsVUFBVSxHQUFHLElBQUksQ0FBQztLQUNuQjtJQUVELElBQUksV0FBVyxDQUFDLGlCQUFpQixJQUFLLFdBQVcsQ0FBQyxrQkFBa0IsRUFBRTtRQUNwRSxhQUFhLElBQUksaUZBQWlGLENBQUM7UUFDbkcsVUFBVSxHQUFHLElBQUksQ0FBQztLQUNuQjtJQUVELElBQUksV0FBVyxDQUFDLGlCQUFpQixJQUFJLFdBQVcsQ0FBQyxtQkFBbUIsRUFBRTtRQUNwRSxhQUFhLElBQUksa0ZBQWtGLENBQUM7UUFDcEcsVUFBVSxHQUFHLElBQUksQ0FBQztLQUNuQjtJQUVELElBQUksV0FBVyxDQUFDLGdCQUFnQixJQUFJLFdBQVcsQ0FBQyxVQUFVLEVBQUU7UUFDMUQsYUFBYSxJQUFJLHdFQUF3RSxDQUFDO1FBQzFGLFVBQVUsR0FBRyxJQUFJLENBQUM7S0FDbkI7SUFFRCxJQUFJLENBQUMsQ0FBQSxXQUFXLGFBQVgsV0FBVyx1QkFBWCxXQUFXLENBQUUscUJBQXFCLE1BQUssS0FBSyxDQUFDLElBQUksV0FBVyxDQUFDLG9CQUFvQixFQUFFO1FBQ3RGLGFBQWEsSUFBSSw0RkFBNEYsQ0FBQztRQUM5RyxVQUFVLEdBQUcsSUFBSSxDQUFDO0tBQ25CO0lBRUQsTUFBTSxXQUFXLFNBQVksV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFLFVBQVUsMENBQUUsSUFBSSxDQUFDO0lBQzNELE1BQU0scUJBQXFCLFNBQVksV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFLG9CQUFvQiwwQ0FBRSxJQUFJLENBQUM7SUFDL0UsTUFBTSxxQkFBcUIsR0FBWSxXQUFXLENBQUMscUJBQXFCLElBQUksV0FBVyxDQUFDLHFCQUFxQixLQUFLLFNBQVMsQ0FBQztJQUU1SCxJQUFJLHFCQUFxQixJQUFJLENBQUMsV0FBVyxLQUFLLHFCQUFxQixDQUFDLEVBQUU7UUFDcEUsYUFBYSxJQUFJOytEQUMwQyxDQUFDO1FBQzVELFVBQVUsR0FBRyxJQUFJLENBQUM7S0FDbkI7SUFFRCxJQUFJLFdBQVcsQ0FBQyw4QkFBOEIsSUFBSSxXQUFXLENBQUMsd0JBQXdCLEVBQUU7UUFDdEYsYUFBYSxJQUFJLG9HQUFvRyxDQUFDO1FBQ3RILFVBQVUsR0FBRyxJQUFJLENBQUM7S0FDbkI7SUFFRCxJQUFJLFdBQVcsQ0FBQyxpQkFBaUIsSUFBSSxXQUFXLENBQUMsV0FBVyxFQUFFO1FBQzVELGFBQWEsSUFBSSwwRUFBMEUsQ0FBQztRQUM1RixVQUFVLEdBQUcsSUFBSSxDQUFDO0tBQ25CO0lBRUQsSUFBSSxXQUFXLENBQUMsdUJBQXVCLElBQUksV0FBVyxDQUFDLFdBQVcsRUFBRTtRQUNsRSxhQUFhLElBQUksZ0ZBQWdGLENBQUM7UUFDbEcsVUFBVSxHQUFHLElBQUksQ0FBQztLQUNuQjtJQUVELElBQUksQ0FBQyxXQUFXLENBQUMsVUFBVSxDQUFDLElBQUksV0FBVyxDQUFDLGdCQUFnQixFQUFFO1FBQzVELGFBQWEsSUFBSSx3RUFBd0UsQ0FBQztRQUMxRixVQUFVLEdBQUcsSUFBSSxDQUFDO0tBQ25CO0lBRUQsSUFBSSxXQUFXLENBQUMsWUFBWSxJQUFJLFdBQVcsQ0FBQyxlQUFlLEVBQUU7UUFDM0QsYUFBYSxJQUFJLHlFQUF5RSxDQUFDO1FBQzNGLFVBQVUsR0FBRyxJQUFJLENBQUM7S0FDbkI7SUFFRCxJQUFJLFdBQVcsQ0FBQyw0QkFBNEIsSUFBSSxXQUFXLENBQUMsYUFBYSxFQUFFO1FBQ3pFLGFBQWEsSUFBSSx1RkFBdUYsQ0FBQztRQUN6RyxVQUFVLEdBQUcsSUFBSSxDQUFDO0tBQ25CO0lBRUQsSUFBSSxXQUFXLENBQUMsaUJBQWlCLElBQUksV0FBVyxDQUFDLFdBQVcsRUFBRTtRQUM1RCxhQUFhLElBQUksMEVBQTBFLENBQUM7UUFDNUYsVUFBVSxHQUFHLElBQUksQ0FBQztLQUNuQjtJQUVELElBQUksQ0FBQyxXQUFXLENBQUMsU0FBUyxJQUFJLFdBQVcsQ0FBQyxRQUFRLENBQUMsSUFBSSxXQUFXLENBQUMsV0FBVyxFQUFFO1FBQzlFLGFBQWEsSUFBSSxzR0FBc0csQ0FBQztRQUN4SCxVQUFVLEdBQUcsSUFBSSxDQUFDO0tBQ25CO0lBRUQsSUFBSSxXQUFXLENBQUMsYUFBYSxJQUFJLFdBQVcsQ0FBQyxrQkFBa0IsRUFBRTtRQUMvRCxhQUFhLElBQUksNkVBQTZFLENBQUM7UUFDL0YsVUFBVSxHQUFHLElBQUksQ0FBQztLQUNuQjtJQUVELElBQUksV0FBVyxDQUFDLHlCQUF5QixJQUFJLFdBQVcsQ0FBQyxhQUFhLEVBQUU7UUFDdEUsYUFBYSxJQUFJLG9GQUFvRixDQUFDO1FBQ3RHLFVBQVUsR0FBRyxJQUFJLENBQUM7S0FDbkI7SUFFRCxJQUFJLFdBQVcsQ0FBQyxpQkFBaUIsSUFBSSxXQUFXLENBQUMsV0FBVyxFQUFFO1FBQzVELGFBQWEsSUFBSSwwRUFBMEUsQ0FBQztRQUM1RixVQUFVLEdBQUcsSUFBSSxDQUFDO0tBQ25CO0lBRUQsSUFBSSxDQUFDLENBQUEsV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFLGdCQUFnQixNQUFLLEtBQUssQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLHFCQUFxQixDQUFDLEVBQUU7UUFDcEYsYUFBYSxJQUFJLHFGQUFxRixDQUFDO1FBQ3ZHLFVBQVUsR0FBRyxJQUFJLENBQUM7S0FDbkI7SUFFRCxJQUFJLFdBQVcsQ0FBQyx3QkFBd0IsSUFBSSxXQUFXLENBQUMsa0JBQWtCLEVBQUU7UUFDMUUsYUFBYSxJQUFJLHdGQUF3RixDQUFDO1FBQzFHLFVBQVUsR0FBRyxJQUFJLENBQUM7S0FDbkI7SUFFRCxJQUFJLENBQUMsQ0FBQSxXQUFXLGFBQVgsV0FBVyx1QkFBWCxXQUFXLENBQUUsZUFBZSxNQUFLLEtBQUssQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLGtCQUFrQixJQUFJLFdBQVcsQ0FBQyx3QkFBd0IsQ0FBQyxFQUFFO1FBQ3hILGFBQWEsSUFBSSw2R0FBNkcsQ0FBQztRQUMvSCxVQUFVLEdBQUcsSUFBSSxDQUFDO0tBQ25CO0lBRUQsSUFBSSxXQUFXLENBQUMsaUJBQWlCLElBQUksQ0FBQyxXQUFXLENBQUMsa0JBQWtCLElBQUksV0FBVyxDQUFDLGVBQWUsQ0FBQyxFQUFFO1FBQ3BHLGFBQWEsSUFBSSwwR0FBMEcsQ0FBQztRQUM1SCxVQUFVLEdBQUcsSUFBSSxDQUFDO0tBQ25CO0lBRUQsSUFBSSxVQUFVLEVBQUU7UUFDZCxNQUFNLElBQUksS0FBSyxDQUFDLGFBQWEsQ0FBQyxDQUFDO0tBQ2hDO0FBQ0gsQ0FBQztBQS9IRCxnQ0ErSEM7QUFFRCxTQUFnQixlQUFlLENBQUMsa0JBQTRCLEVBQUUsZUFBeUIsRUFBRSxTQUFpQjtJQUN4RyxlQUFlLENBQUMsT0FBTyxDQUFDLENBQUMsY0FBYyxFQUFFLEVBQUU7UUFDekMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxjQUFjLENBQUMsRUFBRTtZQUNoRCxNQUFNLEtBQUssQ0FBQyxXQUFXLFNBQVMsZ0JBQWdCLGNBQWMsRUFBRSxDQUFFLENBQUM7U0FDcEU7SUFDSCxDQUFDLENBQUMsQ0FBQztBQUNMLENBQUM7QUFORCwwQ0FNQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogIENvcHlyaWdodCAyMDIyIEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2VcbiAqICB3aXRoIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICAgaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogIG9yIGluIHRoZSAnbGljZW5zZScgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWQgb24gYW4gJ0FTIElTJyBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTXG4gKiAgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqICBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuaW1wb3J0ICogYXMgZHluYW1vZGIgZnJvbSAnYXdzLWNkay1saWIvYXdzLWR5bmFtb2RiJztcbmltcG9ydCAqIGFzIGtpbmVzaXMgZnJvbSAnYXdzLWNkay1saWIvYXdzLWtpbmVzaXMnO1xuaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJ2F3cy1jZGstbGliL2F3cy1sYW1iZGEnO1xuaW1wb3J0ICogYXMgc3FzIGZyb20gJ2F3cy1jZGstbGliL2F3cy1zcXMnO1xuaW1wb3J0ICogYXMgbWVkaWFzdG9yZSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtbWVkaWFzdG9yZSc7XG5pbXBvcnQgKiBhcyBzMyBmcm9tICdhd3MtY2RrLWxpYi9hd3MtczMnO1xuaW1wb3J0ICogYXMgZWMyIGZyb20gJ2F3cy1jZGstbGliL2F3cy1lYzInO1xuaW1wb3J0ICogYXMgZWxiIGZyb20gJ2F3cy1jZGstbGliL2F3cy1lbGFzdGljbG9hZGJhbGFuY2luZ3YyJztcbmltcG9ydCAqIGFzIHNucyBmcm9tICdhd3MtY2RrLWxpYi9hd3Mtc25zJztcbmltcG9ydCAqIGFzIGdsdWUgZnJvbSAnYXdzLWNkay1saWIvYXdzLWdsdWUnO1xuaW1wb3J0ICogYXMgc2FnZW1ha2VyIGZyb20gJ2F3cy1jZGstbGliL2F3cy1zYWdlbWFrZXInO1xuaW1wb3J0ICogYXMgc2VjcmV0c21hbmFnZXIgZnJvbSBcImF3cy1jZGstbGliL2F3cy1zZWNyZXRzbWFuYWdlclwiO1xuaW1wb3J0ICogYXMga21zIGZyb20gXCJhd3MtY2RrLWxpYi9hd3Mta21zXCI7XG5cbmV4cG9ydCBpbnRlcmZhY2UgVmVyaWZpZWRQcm9wcyB7XG4gIHJlYWRvbmx5IGR5bmFtb1RhYmxlUHJvcHM/OiBkeW5hbW9kYi5UYWJsZVByb3BzLFxuICByZWFkb25seSBleGlzdGluZ1RhYmxlT2JqPzogZHluYW1vZGIuVGFibGUsXG4gIHJlYWRvbmx5IGV4aXN0aW5nVGFibGVJbnRlcmZhY2U/OiBkeW5hbW9kYi5JVGFibGUsXG5cbiAgcmVhZG9ubHkgZXhpc3RpbmdTdHJlYW1PYmo/OiBraW5lc2lzLlN0cmVhbTtcbiAgcmVhZG9ubHkga2luZXNpc1N0cmVhbVByb3BzPzoga2luZXNpcy5TdHJlYW1Qcm9wcyxcblxuICByZWFkb25seSBleGlzdGluZ0xhbWJkYU9iaj86IGxhbWJkYS5GdW5jdGlvbixcbiAgcmVhZG9ubHkgbGFtYmRhRnVuY3Rpb25Qcm9wcz86IGxhbWJkYS5GdW5jdGlvblByb3BzLFxuXG4gIHJlYWRvbmx5IGV4aXN0aW5nUXVldWVPYmo/OiBzcXMuUXVldWUsXG4gIHJlYWRvbmx5IHF1ZXVlUHJvcHM/OiBzcXMuUXVldWVQcm9wcyxcbiAgcmVhZG9ubHkgZGVwbG95RGVhZExldHRlclF1ZXVlPzogYm9vbGVhbixcbiAgcmVhZG9ubHkgZGVhZExldHRlclF1ZXVlUHJvcHM/OiBzcXMuUXVldWVQcm9wcyxcblxuICByZWFkb25seSBleGlzdGluZ01lZGlhU3RvcmVDb250YWluZXJPYmo/OiBtZWRpYXN0b3JlLkNmbkNvbnRhaW5lcjtcbiAgcmVhZG9ubHkgbWVkaWFTdG9yZUNvbnRhaW5lclByb3BzPzogbWVkaWFzdG9yZS5DZm5Db250YWluZXJQcm9wcztcblxuICByZWFkb25seSBleGlzdGluZ0J1Y2tldE9iaj86IHMzLkJ1Y2tldCxcbiAgcmVhZG9ubHkgZXhpc3RpbmdCdWNrZXRJbnRlcmZhY2U/OiBzMy5JQnVja2V0LFxuICByZWFkb25seSBidWNrZXRQcm9wcz86IHMzLkJ1Y2tldFByb3BzLFxuXG4gIHJlYWRvbmx5IHRvcGljUHJvcHM/OiBzbnMuVG9waWNQcm9wcyxcbiAgcmVhZG9ubHkgZXhpc3RpbmdUb3BpY09iaj86IHNucy5Ub3BpYyxcblxuICByZWFkb25seSBnbHVlSm9iUHJvcHM/OiBnbHVlLkNmbkpvYlByb3BzLFxuICByZWFkb25seSBleGlzdGluZ0dsdWVKb2I/OiBnbHVlLkNmbkpvYixcblxuICByZWFkb25seSBleGlzdGluZ1NhZ2VtYWtlckVuZHBvaW50T2JqPzogc2FnZW1ha2VyLkNmbkVuZHBvaW50LFxuICByZWFkb25seSBlbmRwb2ludFByb3BzPzogc2FnZW1ha2VyLkNmbkVuZHBvaW50UHJvcHMsXG5cbiAgcmVhZG9ubHkgZXhpc3RpbmdTZWNyZXRPYmo/OiBzZWNyZXRzbWFuYWdlci5TZWNyZXQ7XG4gIHJlYWRvbmx5IHNlY3JldFByb3BzPzogc2VjcmV0c21hbmFnZXIuU2VjcmV0UHJvcHM7XG5cbiAgcmVhZG9ubHkgZXhpc3RpbmdWcGM/OiBlYzIuSVZwYztcbiAgcmVhZG9ubHkgdnBjUHJvcHM/OiBlYzIuVnBjUHJvcHM7XG4gIHJlYWRvbmx5IGRlcGxveVZwYz86IGJvb2xlYW47XG5cbiAgcmVhZG9ubHkgZW5jcnlwdGlvbktleT86IGttcy5LZXksXG4gIHJlYWRvbmx5IGVuY3J5cHRpb25LZXlQcm9wcz86IGttcy5LZXlQcm9wc1xuXG4gIHJlYWRvbmx5IGxvYWRCYWxhbmNlclByb3BzPzogZWxiLkFwcGxpY2F0aW9uTG9hZEJhbGFuY2VyUHJvcHM7XG4gIHJlYWRvbmx5IGV4aXN0aW5nTG9hZEJhbGFuY2VyT2JqPzogZWxiLkFwcGxpY2F0aW9uTG9hZEJhbGFuY2VyO1xuXG4gIHJlYWRvbmx5IGxvZ0FsYkFjY2Vzc0xvZ3M/OiBib29sZWFuO1xuICByZWFkb25seSBhbGJMb2dnaW5nQnVja2V0UHJvcHM/OiBzMy5CdWNrZXRQcm9wcztcblxuICByZWFkb25seSBleGlzdGluZ0xvZ2dpbmdCdWNrZXRPYmo/OiBzMy5JQnVja2V0O1xuICByZWFkb25seSBsb2dnaW5nQnVja2V0UHJvcHM/OiBzMy5CdWNrZXRQcm9wcztcbiAgcmVhZG9ubHkgbG9nUzNBY2Nlc3NMb2dzPzogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIENoZWNrUHJvcHMocHJvcHNPYmplY3Q6IFZlcmlmaWVkUHJvcHMgfCBhbnkpIHtcbiAgbGV0IGVycm9yTWVzc2FnZXMgPSAnJztcbiAgbGV0IGVycm9yRm91bmQgPSBmYWxzZTtcblxuICBpZiAocHJvcHNPYmplY3QubG9hZEJhbGFuY2VyUHJvcHMgJiYgcHJvcHNPYmplY3QuZXhpc3RpbmdMb2FkQmFsYW5jZXJPYmopIHtcbiAgICBlcnJvck1lc3NhZ2VzICs9ICdFcnJvciAtIEVpdGhlciBwcm92aWRlIGxvYWRCYWxhbmNlclByb3BzIG9yIGV4aXN0aW5nTG9hZEJhbGFuY2VyT2JqLCBidXQgbm90IGJvdGguXFxuJztcbiAgICBlcnJvckZvdW5kID0gdHJ1ZTtcbiAgfVxuXG4gIGlmIChwcm9wc09iamVjdC5keW5hbW9UYWJsZVByb3BzICYmIHByb3BzT2JqZWN0LmV4aXN0aW5nVGFibGVPYmopIHtcbiAgICBlcnJvck1lc3NhZ2VzICs9ICdFcnJvciAtIEVpdGhlciBwcm92aWRlIGV4aXN0aW5nVGFibGVPYmogb3IgZHluYW1vVGFibGVQcm9wcywgYnV0IG5vdCBib3RoLlxcbic7XG4gICAgZXJyb3JGb3VuZCA9IHRydWU7XG4gIH1cblxuICBpZiAocHJvcHNPYmplY3QuZHluYW1vVGFibGVQcm9wcyAmJiBwcm9wc09iamVjdC5leGlzdGluZ1RhYmxlSW50ZXJmYWNlKSB7XG4gICAgZXJyb3JNZXNzYWdlcyArPSAnRXJyb3IgLSBFaXRoZXIgcHJvdmlkZSBleGlzdGluZ1RhYmxlSW50ZXJmYWNlIG9yIGR5bmFtb1RhYmxlUHJvcHMsIGJ1dCBub3QgYm90aC5cXG4nO1xuICAgIGVycm9yRm91bmQgPSB0cnVlO1xuICB9XG5cbiAgaWYgKHByb3BzT2JqZWN0LmV4aXN0aW5nU3RyZWFtT2JqICAmJiBwcm9wc09iamVjdC5raW5lc2lzU3RyZWFtUHJvcHMpIHtcbiAgICBlcnJvck1lc3NhZ2VzICs9ICdFcnJvciAtIEVpdGhlciBwcm92aWRlIGV4aXN0aW5nU3RyZWFtT2JqIG9yIGtpbmVzaXNTdHJlYW1Qcm9wcywgYnV0IG5vdCBib3RoLlxcbic7XG4gICAgZXJyb3JGb3VuZCA9IHRydWU7XG4gIH1cblxuICBpZiAocHJvcHNPYmplY3QuZXhpc3RpbmdMYW1iZGFPYmogJiYgcHJvcHNPYmplY3QubGFtYmRhRnVuY3Rpb25Qcm9wcykge1xuICAgIGVycm9yTWVzc2FnZXMgKz0gJ0Vycm9yIC0gRWl0aGVyIHByb3ZpZGUgbGFtYmRhRnVuY3Rpb25Qcm9wcyBvciBleGlzdGluZ0xhbWJkYU9iaiwgYnV0IG5vdCBib3RoLlxcbic7XG4gICAgZXJyb3JGb3VuZCA9IHRydWU7XG4gIH1cblxuICBpZiAocHJvcHNPYmplY3QuZXhpc3RpbmdRdWV1ZU9iaiAmJiBwcm9wc09iamVjdC5xdWV1ZVByb3BzKSB7XG4gICAgZXJyb3JNZXNzYWdlcyArPSAnRXJyb3IgLSBFaXRoZXIgcHJvdmlkZSBxdWV1ZVByb3BzIG9yIGV4aXN0aW5nUXVldWVPYmosIGJ1dCBub3QgYm90aC5cXG4nO1xuICAgIGVycm9yRm91bmQgPSB0cnVlO1xuICB9XG5cbiAgaWYgKChwcm9wc09iamVjdD8uZGVwbG95RGVhZExldHRlclF1ZXVlID09PSBmYWxzZSkgJiYgcHJvcHNPYmplY3QuZGVhZExldHRlclF1ZXVlUHJvcHMpIHtcbiAgICBlcnJvck1lc3NhZ2VzICs9ICdFcnJvciAtIElmIGRlcGxveURlYWRMZXR0ZXJRdWV1ZSBpcyBmYWxzZSB0aGVuIGRlYWRMZXR0ZXJRdWV1ZVByb3BzIGNhbm5vdCBiZSBzcGVjaWZpZWQuXFxuJztcbiAgICBlcnJvckZvdW5kID0gdHJ1ZTtcbiAgfVxuXG4gIGNvbnN0IGlzUXVldWVGaWZvOiBib29sZWFuID0gcHJvcHNPYmplY3Q/LnF1ZXVlUHJvcHM/LmZpZm87XG4gIGNvbnN0IGlzRGVhZExldHRlclF1ZXVlRmlmbzogYm9vbGVhbiA9IHByb3BzT2JqZWN0Py5kZWFkTGV0dGVyUXVldWVQcm9wcz8uZmlmbztcbiAgY29uc3QgZGVwbG95RGVhZExldHRlclF1ZXVlOiBib29sZWFuID0gcHJvcHNPYmplY3QuZGVwbG95RGVhZExldHRlclF1ZXVlIHx8IHByb3BzT2JqZWN0LmRlcGxveURlYWRMZXR0ZXJRdWV1ZSA9PT0gdW5kZWZpbmVkO1xuXG4gIGlmIChkZXBsb3lEZWFkTGV0dGVyUXVldWUgJiYgKGlzUXVldWVGaWZvICE9PSBpc0RlYWRMZXR0ZXJRdWV1ZUZpZm8pKSB7XG4gICAgZXJyb3JNZXNzYWdlcyArPSAnRXJyb3IgLSBJZiB5b3Ugc3BlY2lmeSBhIGZpZm86IHRydWUgaW4gZWl0aGVyIHF1ZXVlUHJvcHMgb3IgZGVhZExldHRlclF1ZXVlUHJvcHMsIHlvdSBtdXN0IGFsc28gc2V0IGZpZm86IHRydWUgaW4gdGhlIG90aGVyIHByb3BzIG9iamVjdC4gXFxcbiAgICBGaWZvIG11c3QgbWF0Y2ggZm9yIHRoZSBRdWV1ZSBhbmQgdGhlIERlYWQgTGV0dGVyIFF1ZXVlLlxcbic7XG4gICAgZXJyb3JGb3VuZCA9IHRydWU7XG4gIH1cblxuICBpZiAocHJvcHNPYmplY3QuZXhpc3RpbmdNZWRpYVN0b3JlQ29udGFpbmVyT2JqICYmIHByb3BzT2JqZWN0Lm1lZGlhU3RvcmVDb250YWluZXJQcm9wcykge1xuICAgIGVycm9yTWVzc2FnZXMgKz0gJ0Vycm9yIC0gRWl0aGVyIHByb3ZpZGUgbWVkaWFTdG9yZUNvbnRhaW5lclByb3BzIG9yIGV4aXN0aW5nTWVkaWFTdG9yZUNvbnRhaW5lck9iaiwgYnV0IG5vdCBib3RoLlxcbic7XG4gICAgZXJyb3JGb3VuZCA9IHRydWU7XG4gIH1cblxuICBpZiAocHJvcHNPYmplY3QuZXhpc3RpbmdCdWNrZXRPYmogJiYgcHJvcHNPYmplY3QuYnVja2V0UHJvcHMpIHtcbiAgICBlcnJvck1lc3NhZ2VzICs9ICdFcnJvciAtIEVpdGhlciBwcm92aWRlIGJ1Y2tldFByb3BzIG9yIGV4aXN0aW5nQnVja2V0T2JqLCBidXQgbm90IGJvdGguXFxuJztcbiAgICBlcnJvckZvdW5kID0gdHJ1ZTtcbiAgfVxuXG4gIGlmIChwcm9wc09iamVjdC5leGlzdGluZ0J1Y2tldEludGVyZmFjZSAmJiBwcm9wc09iamVjdC5idWNrZXRQcm9wcykge1xuICAgIGVycm9yTWVzc2FnZXMgKz0gJ0Vycm9yIC0gRWl0aGVyIHByb3ZpZGUgYnVja2V0UHJvcHMgb3IgZXhpc3RpbmdCdWNrZXRJbnRlcmZhY2UsIGJ1dCBub3QgYm90aC5cXG4nO1xuICAgIGVycm9yRm91bmQgPSB0cnVlO1xuICB9XG5cbiAgaWYgKChwcm9wc09iamVjdC50b3BpY1Byb3BzKSAmJiBwcm9wc09iamVjdC5leGlzdGluZ1RvcGljT2JqKSB7XG4gICAgZXJyb3JNZXNzYWdlcyArPSAnRXJyb3IgLSBFaXRoZXIgcHJvdmlkZSB0b3BpY1Byb3BzIG9yIGV4aXN0aW5nVG9waWNPYmosIGJ1dCBub3QgYm90aC5cXG4nO1xuICAgIGVycm9yRm91bmQgPSB0cnVlO1xuICB9XG5cbiAgaWYgKHByb3BzT2JqZWN0LmdsdWVKb2JQcm9wcyAmJiBwcm9wc09iamVjdC5leGlzdGluZ0dsdWVKb2IpIHtcbiAgICBlcnJvck1lc3NhZ2VzICs9ICdFcnJvciAtIEVpdGhlciBwcm92aWRlIGdsdWVKb2JQcm9wcyBvciBleGlzdGluZ0dsdWVKb2IsIGJ1dCBub3QgYm90aC5cXG4nO1xuICAgIGVycm9yRm91bmQgPSB0cnVlO1xuICB9XG5cbiAgaWYgKHByb3BzT2JqZWN0LmV4aXN0aW5nU2FnZW1ha2VyRW5kcG9pbnRPYmogJiYgcHJvcHNPYmplY3QuZW5kcG9pbnRQcm9wcykge1xuICAgIGVycm9yTWVzc2FnZXMgKz0gJ0Vycm9yIC0gRWl0aGVyIHByb3ZpZGUgZW5kcG9pbnRQcm9wcyBvciBleGlzdGluZ1NhZ2VtYWtlckVuZHBvaW50T2JqLCBidXQgbm90IGJvdGguXFxuJztcbiAgICBlcnJvckZvdW5kID0gdHJ1ZTtcbiAgfVxuXG4gIGlmIChwcm9wc09iamVjdC5leGlzdGluZ1NlY3JldE9iaiAmJiBwcm9wc09iamVjdC5zZWNyZXRQcm9wcykge1xuICAgIGVycm9yTWVzc2FnZXMgKz0gJ0Vycm9yIC0gRWl0aGVyIHByb3ZpZGUgc2VjcmV0UHJvcHMgb3IgZXhpc3RpbmdTZWNyZXRPYmosIGJ1dCBub3QgYm90aC5cXG4nO1xuICAgIGVycm9yRm91bmQgPSB0cnVlO1xuICB9XG5cbiAgaWYgKChwcm9wc09iamVjdC5kZXBsb3lWcGMgfHwgcHJvcHNPYmplY3QudnBjUHJvcHMpICYmIHByb3BzT2JqZWN0LmV4aXN0aW5nVnBjKSB7XG4gICAgZXJyb3JNZXNzYWdlcyArPSAnRXJyb3IgLSBFaXRoZXIgcHJvdmlkZSBhbiBleGlzdGluZ1ZwYyBvciBzb21lIGNvbWJpbmF0aW9uIG9mIGRlcGxveVZwYyBhbmQgdnBjUHJvcHMsIGJ1dCBub3QgYm90aC5cXG4nO1xuICAgIGVycm9yRm91bmQgPSB0cnVlO1xuICB9XG5cbiAgaWYgKHByb3BzT2JqZWN0LmVuY3J5cHRpb25LZXkgJiYgcHJvcHNPYmplY3QuZW5jcnlwdGlvbktleVByb3BzKSB7XG4gICAgZXJyb3JNZXNzYWdlcyArPSAnRXJyb3IgLSBFaXRoZXIgcHJvdmlkZSBlbmNyeXB0aW9uS2V5IG9yIGVuY3J5cHRpb25LZXlQcm9wcywgYnV0IG5vdCBib3RoLlxcbic7XG4gICAgZXJyb3JGb3VuZCA9IHRydWU7XG4gIH1cblxuICBpZiAocHJvcHNPYmplY3QuZXhpc3RpbmdFdmVudEJ1c0ludGVyZmFjZSAmJiBwcm9wc09iamVjdC5ldmVudEJ1c1Byb3BzKSB7XG4gICAgZXJyb3JNZXNzYWdlcyArPSAnRXJyb3IgLSBFaXRoZXIgcHJvdmlkZSBleGlzdGluZ0V2ZW50QnVzSW50ZXJmYWNlIG9yIGV2ZW50QnVzUHJvcHMsIGJ1dCBub3QgYm90aC5cXG4nO1xuICAgIGVycm9yRm91bmQgPSB0cnVlO1xuICB9XG5cbiAgaWYgKHByb3BzT2JqZWN0LmV4aXN0aW5nV2ViYWNsT2JqICYmIHByb3BzT2JqZWN0LndlYmFjbFByb3BzKSB7XG4gICAgZXJyb3JNZXNzYWdlcyArPSAnRXJyb3IgLSBFaXRoZXIgcHJvdmlkZSBleGlzdGluZ1dlYmFjbE9iaiBvciB3ZWJhY2xQcm9wcywgYnV0IG5vdCBib3RoLlxcbic7XG4gICAgZXJyb3JGb3VuZCA9IHRydWU7XG4gIH1cblxuICBpZiAoKHByb3BzT2JqZWN0Py5sb2dBbGJBY2Nlc3NMb2dzID09PSBmYWxzZSkgJiYgKHByb3BzT2JqZWN0LmFsYkxvZ2dpbmdCdWNrZXRQcm9wcykpIHtcbiAgICBlcnJvck1lc3NhZ2VzICs9ICdFcnJvciAtIElmIGxvZ0FsYkFjY2Vzc0xvZ3MgaXMgZmFsc2UsIHN1cHBseWluZyBhbGJMb2dnaW5nQnVja2V0UHJvcHMgaXMgaW52YWxpZC5cXG4nO1xuICAgIGVycm9yRm91bmQgPSB0cnVlO1xuICB9XG5cbiAgaWYgKHByb3BzT2JqZWN0LmV4aXN0aW5nTG9nZ2luZ0J1Y2tldE9iaiAmJiBwcm9wc09iamVjdC5sb2dnaW5nQnVja2V0UHJvcHMpIHtcbiAgICBlcnJvck1lc3NhZ2VzICs9ICdFcnJvciAtIEVpdGhlciBwcm92aWRlIGV4aXN0aW5nTG9nZ2luZ0J1Y2tldE9iaiBvciBsb2dnaW5nQnVja2V0UHJvcHMsIGJ1dCBub3QgYm90aC5cXG4nO1xuICAgIGVycm9yRm91bmQgPSB0cnVlO1xuICB9XG5cbiAgaWYgKChwcm9wc09iamVjdD8ubG9nUzNBY2Nlc3NMb2dzID09PSBmYWxzZSkgJiYgKHByb3BzT2JqZWN0LmxvZ2dpbmdCdWNrZXRQcm9wcyB8fCBwcm9wc09iamVjdC5leGlzdGluZ0xvZ2dpbmdCdWNrZXRPYmopKSB7XG4gICAgZXJyb3JNZXNzYWdlcyArPSAnRXJyb3IgLSBJZiBsb2dTM0FjY2Vzc0xvZ3MgaXMgZmFsc2UsIHN1cHBseWluZyBsb2dnaW5nQnVja2V0UHJvcHMgb3IgZXhpc3RpbmdMb2dnaW5nQnVja2V0T2JqIGlzIGludmFsaWQuXFxuJztcbiAgICBlcnJvckZvdW5kID0gdHJ1ZTtcbiAgfVxuXG4gIGlmIChwcm9wc09iamVjdC5leGlzdGluZ0J1Y2tldE9iaiAmJiAocHJvcHNPYmplY3QubG9nZ2luZ0J1Y2tldFByb3BzIHx8IHByb3BzT2JqZWN0LmxvZ1MzQWNjZXNzTG9ncykpIHtcbiAgICBlcnJvck1lc3NhZ2VzICs9ICdFcnJvciAtIElmIGV4aXN0aW5nQnVja2V0T2JqIGlzIHByb3ZpZGVkLCBzdXBwbHlpbmcgbG9nZ2luZ0J1Y2tldFByb3BzIG9yIGxvZ1MzQWNjZXNzTG9ncyBpcyBhbiBlcnJvci5cXG4nO1xuICAgIGVycm9yRm91bmQgPSB0cnVlO1xuICB9XG5cbiAgaWYgKGVycm9yRm91bmQpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoZXJyb3JNZXNzYWdlcyk7XG4gIH1cbn1cblxuZXhwb3J0IGZ1bmN0aW9uIENoZWNrTGlzdFZhbHVlcyhhbGxvd2VkUGVybWlzc2lvbnM6IHN0cmluZ1tdLCBzdWJtaXR0ZWRWYWx1ZXM6IHN0cmluZ1tdLCB2YWx1ZVR5cGU6IHN0cmluZykge1xuICBzdWJtaXR0ZWRWYWx1ZXMuZm9yRWFjaCgoc3VibWl0dGVkVmFsdWUpID0+IHtcbiAgICBpZiAoIWFsbG93ZWRQZXJtaXNzaW9ucy5pbmNsdWRlcyhzdWJtaXR0ZWRWYWx1ZSkpIHtcbiAgICAgIHRocm93IEVycm9yKGBJbnZhbGlkICR7dmFsdWVUeXBlfSBzdWJtaXR0ZWQgLSAke3N1Ym1pdHRlZFZhbHVlfWAgKTtcbiAgICB9XG4gIH0pO1xufVxuIl19