"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildKinesisAnalyticsApp = void 0;
// Imports
const kinesisAnalytics = require("aws-cdk-lib/aws-kinesisanalytics");
const iam = require("aws-cdk-lib/aws-iam");
const defaults = require("./kinesis-analytics-defaults");
const utils_1 = require("./utils");
function buildKinesisAnalyticsApp(scope, props) {
    // Setup the IAM role for Kinesis Analytics
    const analyticsRole = new iam.Role(scope, 'KinesisAnalyticsRole', {
        assumedBy: new iam.ServicePrincipal('kinesisanalytics.amazonaws.com'),
    });
    // Setup the IAM policy for Kinesis Analytics
    const analyticsPolicy = new iam.Policy(scope, 'KinesisAnalyticsPolicy', {
        statements: [
            new iam.PolicyStatement({
                actions: [
                    'firehose:DescribeDeliveryStream',
                    'firehose:Get*'
                ],
                resources: [props.kinesisFirehose.attrArn]
            })
        ]
    });
    // Attach policy to role
    analyticsPolicy.attachToRole(analyticsRole);
    // Setup the Kinesis application properties
    const kinesisAnalyticsProps = utils_1.overrideProps(defaults.DefaultCfnApplicationProps, props.kinesisAnalyticsProps);
    kinesisAnalyticsProps.inputs[0].kinesisFirehoseInput = {
        resourceArn: props.kinesisFirehose.attrArn,
        roleArn: analyticsRole.roleArn
    };
    // Setup the Kinesis application and add dependencies
    const kinesisAnalyticsApp = new kinesisAnalytics.CfnApplication(scope, 'KinesisAnalytics', kinesisAnalyticsProps);
    kinesisAnalyticsApp.addDependsOn(analyticsPolicy.node.findChild('Resource'));
    // Create the application and return
    return kinesisAnalyticsApp;
}
exports.buildKinesisAnalyticsApp = buildKinesisAnalyticsApp;
//# sourceMappingURL=data:application/json;base64,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