"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisEventSourceProps = exports.S3EventSourceProps = exports.DynamoEventSourceProps = void 0;
const lambda = require("aws-cdk-lib/aws-lambda");
const utils_1 = require("./utils");
const aws_lambda_event_sources_1 = require("aws-cdk-lib/aws-lambda-event-sources");
const s3 = require("aws-cdk-lib/aws-s3");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const sqs_helper_1 = require("./sqs-helper");
function DynamoEventSourceProps(scope, _dynamoEventSourceProps) {
    const baseProps = {
        startingPosition: lambda.StartingPosition.TRIM_HORIZON,
        bisectBatchOnError: true,
        maxRecordAge: aws_cdk_lib_1.Duration.hours(24),
        retryAttempts: 500
    };
    let extraProps = {};
    if (_dynamoEventSourceProps === undefined || (_dynamoEventSourceProps === null || _dynamoEventSourceProps === void 0 ? void 0 : _dynamoEventSourceProps.deploySqsDlqQueue) === undefined
        || _dynamoEventSourceProps.deploySqsDlqQueue) {
        const [sqsQueue] = sqs_helper_1.buildQueue(scope, 'SqsDlqQueue', {
            queueProps: _dynamoEventSourceProps === null || _dynamoEventSourceProps === void 0 ? void 0 : _dynamoEventSourceProps.sqsDlqQueueProps
        });
        extraProps = {
            onFailure: new aws_lambda_event_sources_1.SqsDlq(sqsQueue),
        };
    }
    const defaultDynamoEventSourceProps = Object.assign(baseProps, extraProps);
    return utils_1.consolidateProps(defaultDynamoEventSourceProps, _dynamoEventSourceProps === null || _dynamoEventSourceProps === void 0 ? void 0 : _dynamoEventSourceProps.eventSourceProps);
}
exports.DynamoEventSourceProps = DynamoEventSourceProps;
function S3EventSourceProps(_s3EventSourceProps) {
    const defaultS3EventSourceProps = {
        events: [s3.EventType.OBJECT_CREATED]
    };
    return utils_1.consolidateProps(defaultS3EventSourceProps, _s3EventSourceProps);
}
exports.S3EventSourceProps = S3EventSourceProps;
function KinesisEventSourceProps(scope, _kinesisEventSourceProps) {
    const baseProps = {
        startingPosition: lambda.StartingPosition.TRIM_HORIZON,
        bisectBatchOnError: true,
        maxRecordAge: aws_cdk_lib_1.Duration.hours(24),
        retryAttempts: 500
    };
    let extraProps = {};
    if (_kinesisEventSourceProps === undefined || (_kinesisEventSourceProps === null || _kinesisEventSourceProps === void 0 ? void 0 : _kinesisEventSourceProps.deploySqsDlqQueue) === undefined
        || _kinesisEventSourceProps.deploySqsDlqQueue) {
        const [sqsQueue] = sqs_helper_1.buildQueue(scope, 'SqsDlqQueue', {
            queueProps: _kinesisEventSourceProps === null || _kinesisEventSourceProps === void 0 ? void 0 : _kinesisEventSourceProps.sqsDlqQueueProps
        });
        extraProps = {
            onFailure: new aws_lambda_event_sources_1.SqsDlq(sqsQueue),
        };
    }
    const defaultKinesisEventSourceProps = Object.assign(baseProps, extraProps);
    return utils_1.consolidateProps(defaultKinesisEventSourceProps, _kinesisEventSourceProps === null || _kinesisEventSourceProps === void 0 ? void 0 : _kinesisEventSourceProps.eventSourceProps);
}
exports.KinesisEventSourceProps = KinesisEventSourceProps;
//# sourceMappingURL=data:application/json;base64,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