"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultS3NotificationEventTypes = exports.DefaultLoggingBucketProps = exports.DefaultS3Props = void 0;
const s3 = require("aws-cdk-lib/aws-s3");
const aws_cdk_lib_1 = require("aws-cdk-lib");
function DefaultS3Props(loggingBucket, lifecycleRules) {
    return {
        encryption: s3.BucketEncryption.S3_MANAGED,
        versioned: true,
        blockPublicAccess: s3.BlockPublicAccess.BLOCK_ALL,
        removalPolicy: aws_cdk_lib_1.RemovalPolicy.RETAIN,
        enforceSSL: true,
        ...((lifecycleRules !== undefined) && { lifecycleRules }),
        ...((loggingBucket !== undefined) && { serverAccessLogsBucket: loggingBucket })
    };
}
exports.DefaultS3Props = DefaultS3Props;
function DefaultLoggingBucketProps() {
    return {
        encryption: s3.BucketEncryption.S3_MANAGED,
        versioned: true,
        blockPublicAccess: s3.BlockPublicAccess.BLOCK_ALL,
        removalPolicy: aws_cdk_lib_1.RemovalPolicy.RETAIN,
        enforceSSL: true,
    };
}
exports.DefaultLoggingBucketProps = DefaultLoggingBucketProps;
// Default event types to trigger S3 notifications
exports.defaultS3NotificationEventTypes = [s3.EventType.OBJECT_CREATED];
//# sourceMappingURL=data:application/json;base64,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