
# Robotics Language compiler reference

- Base
  - [CommandLine]( Base/CommandLine/README.md)
  - [Initialise]( Base/Initialise/README.md)
  - [Inputs]( Base/Inputs/README.md)
  - [Outputs]( Base/Outputs/README.md)
  - Tools
    - [ErrorHandling]( Base/Tools/ErrorHandling/README.md)
  - [Transformations]( Base/Transformations/README.md)
  - [Types]( Base/Types/README.md)
  - [Utilities]( Base/Utilities/README.md)
- Inputs
  - FiniteStateMachine
    - [Parse]( Inputs/FiniteStateMachine/Parse/README.md)
  - RoL
    - [Parse]( Inputs/RoL/Parse/README.md)
  - RoLXML
    - [Parse]( Inputs/RoLXML/Parse/README.md)
- Outputs
  - Developer
    - [Output]( Outputs/Developer/Output/README.md)
  - HTMLDocumentation
    - [Output]( Outputs/HTMLDocumentation/Output/README.md)
  - HTMLGUI
    - [Output]( Outputs/HTMLGUI/Output/README.md)
  - RoL
    - [Output]( Outputs/RoL/Output/README.md)
  - RoLXML
    - [Output]( Outputs/RoLXML/Output/README.md)
  - RosCpp
    - [Output]( Outputs/RosCpp/Output/README.md)
- Transformers
  - Base
    - [ErrorHandling]( Transformers/Base/ErrorHandling/README.md)
    - [Messages]( Transformers/Base/Messages/README.md)
    - [Transform]( Transformers/Base/Transform/README.md)
  - FiniteStateMachines
    - [Transform]( Transformers/FiniteStateMachines/Transform/README.md)
  - LinearAlgebra
    - [Transform]( Transformers/LinearAlgebra/Transform/README.md)
  - ROS
    - [Transform]( Transformers/ROS/Transform/README.md)
  - TemporalLogic
    - [Transform]( Transformers/TemporalLogic/Transform/README.md)

