"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsDeployment = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const ecs_appspec_1 = require("../ecs-appspec");
const ecs_deployment_provider_1 = require("../ecs-deployment-provider");
/**
 * A CodeDeploy Deployment for a Amazon ECS service DeploymentGroup. An EcsDeploymentGroup
 * must only have 1 EcsDeployment. This limit is enforced by removing the scope and id
 * from the constructor. The scope will always be set to the EcsDeploymentGroup
 * and the id will always be set to the string 'Deployment' to force an error if mulitiple
 * EcsDeployment constructs are created for a single EcsDeploymentGroup.
 */
class EcsDeployment extends constructs_1.Construct {
    constructor(props) {
        super(props.deploymentGroup, 'Deployment');
        const ecsDeploymentProvider = new ecs_deployment_provider_1.EcsDeploymentProvider(this, 'DeploymentProvider', {
            deploymentGroup: props.deploymentGroup,
            timeout: props.timeout || cdk.Duration.minutes(30),
        });
        let autoRollbackConfigurationEvents = undefined;
        let autoRollbackConfigurationEnabled = undefined;
        if (props.autoRollback) {
            let events = [];
            if (props.autoRollback.deploymentInAlarm) {
                events.push('DEPLOYMENT_STOP_ON_ALARM');
            }
            if (props.autoRollback.failedDeployment) {
                events.push('DEPLOYMENT_FAILURE');
            }
            if (props.autoRollback.stoppedDeployment) {
                events.push('DEPLOYMENT_STOP_ON_REQUEST');
            }
            if (events.length > 0) {
                autoRollbackConfigurationEnabled = 'true';
                autoRollbackConfigurationEvents = events.join(',');
            }
            else {
                autoRollbackConfigurationEnabled = 'false';
            }
        }
        const appspec = new ecs_appspec_1.EcsAppSpec(props.targetService);
        const deployment = new cdk.CustomResource(this, 'Resource', {
            serviceToken: ecsDeploymentProvider.serviceToken,
            resourceType: 'Custom::EcsDeployment',
            properties: {
                applicationName: props.deploymentGroup.application.applicationName,
                deploymentConfigName: props.deploymentGroup.deploymentConfig.deploymentConfigName,
                deploymentGroupName: props.deploymentGroup.deploymentGroupName,
                autoRollbackConfigurationEnabled,
                autoRollbackConfigurationEvents,
                description: props.description,
                revisionAppSpecContent: appspec.toString(),
            },
        });
        this.deploymentId = deployment.getAttString('deploymentId');
    }
}
exports.EcsDeployment = EcsDeployment;
_a = JSII_RTTI_SYMBOL_1;
EcsDeployment[_a] = { fqn: "@cdklabs/cdk-ecs-codedeploy.EcsDeployment", version: "0.0.32" };
//# sourceMappingURL=data:application/json;base64,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