***************************************************************
* Program Name: Z_DXI_Model1_P_AnnTotalSpend_250K_.sas
* This program uses regression results from stepwise OLS model estimated on the development sample to predict 
* P_AnnTotalSpend_250K = 'SW Predicted Annualized Total Spending topcoded at $250k Development sample 2016-18'
* tests on multi-core PCs reveal that hardwired formulas used here are approximately twice as fast as 
* the usual PROC Score or data steps that loop over arrays
* 
* Sample macro call is 
*      %Model1_P_AnnTotalSpend_250K
* or equivalently  %Model1 which calls the original
* program creates one new variable with its label
* label P_AnnTotalSpend_250K = 'SW Predicted Annualized Total Spending topcoded at $250k Development sample 2016-18'
*
* Prediction model uses FAGE_: MAGE_: CCSR_ DXI1_ (Stepwise model with p<.001);
*
* Called in program 3_DXI_PARSEAndPredict.SAS
* Programmers: Randall Ellis, Tzu-Chun Kuo, Corinne Andriola, Changwoo Lee
* Created: June 15, 2022
* Last updated: September 9, 2022
* Copyright: Boston University, September 9, 2022
*
***************************************************************;
%Macro Model1_P_AnnTotalSpend_250K;
P_AnnTotalSpend_250K = 
ONE  * 251.41 +
FAGE_0  * 544.73 +
FAGE_01  * -234.17 +
FAGE_02_04  * -219.44 +
FAGE_05_09  * -271.33 +
FAGE_10_14  * -48.10 +
FAGE_25_29  * 212.61 +
FAGE_30_34  * 223.05 +
FAGE_35_39  * 205.93 +
FAGE_40_44  * 288.56 +
FAGE_45_49  * 198.62 +
FAGE_50_54  * 119.41 +
FAGE_55_59  * -69.96 +
FAGE_60_64  * -108.59 +
MAGE_0  * 388.01 +
MAGE_01  * -287.95 +
MAGE_02_04  * -178.61 +
MAGE_05_09  * -234.83 +
MAGE_15_20  * 40.78 +
MAGE_21_24  * -91.90 +
MAGE_25_29  * 52.52 +
MAGE_40_44  * 42.85 +
MAGE_45_49  * 99.95 +
MAGE_50_54  * 208.10 +
MAGE_55_59  * 154.20 +
MAGE_60_64  * 85.44 +
CCSR_BLD001  * 885.14 +
CCSR_BLD002  * -5496.95 +
CCSR_BLD003  * 6408.75 +
CCSR_BLD006  * 1212.93 +
CCSR_BLD007  * 4451.97 +
CCSR_BLD008  * 4135.28 +
CCSR_BLD010  * 430.01 +
CCSR_CIR001  * -6470.42 +
CCSR_CIR002  * -3960.60 +
CCSR_CIR003  * -11206.4 +
CCSR_CIR005  * -5965.78 +
CCSR_CIR006  * 4245.10 +
CCSR_CIR007  * 298.36 +
CCSR_CIR008  * 629.09 +
CCSR_CIR009  * 1068.86 +
CCSR_CIR010  * 8766.57 +
CCSR_CIR011  * -6977.76 +
CCSR_CIR012  * 1194.89 +
CCSR_CIR013  * -3804.45 +
CCSR_CIR014  * -25515.8 +
CCSR_CIR015  * 971.37 +
CCSR_CIR016  * -8999.91 +
CCSR_CIR017  * -4887.36 +
CCSR_CIR018  * 3391.03 +
CCSR_CIR019  * 1003.52 +
CCSR_CIR020  * -3322.80 +
CCSR_CIR021  * -2178.55 +
CCSR_CIR022  * 1491.56 +
CCSR_CIR023  * -3308.73 +
CCSR_CIR024  * -9839.33 +
CCSR_CIR025  * -13999.1 +
CCSR_CIR026  * -4914.09 +
CCSR_CIR027  * 10033.83 +
CCSR_CIR028  * 7324.73 +
CCSR_CIR030  * -7955.70 +
CCSR_CIR032  * 1471.14 +
CCSR_CIR033  * 2303.33 +
CCSR_CIR035  * -1175.44 +
CCSR_CIR036  * -718.61 +
CCSR_DIG002  * -586.74 +
CCSR_DIG003  * 485.61 +
CCSR_DIG004  * 606.19 +
CCSR_DIG005  * 517.37 +
CCSR_DIG006  * 7762.57 +
CCSR_DIG007  * 775.79 +
CCSR_DIG008  * 185.89 +
CCSR_DIG009  * 5698.46 +
CCSR_DIG010  * -384.77 +
CCSR_DIG011  * -705.45 +
CCSR_DIG012  * 5285.16 +
CCSR_DIG014  * 1383.69 +
CCSR_DIG015  * -222.34 +
CCSR_DIG016  * 3680.53 +
CCSR_DIG017  * -1964.61 +
CCSR_DIG018  * 3803.25 +
CCSR_DIG019  * 998.18 +
CCSR_DIG020  * 1732.55 +
CCSR_DIG021  * 1658.81 +
CCSR_DIG022  * -2209.75 +
CCSR_DIG023  * -637.96 +
CCSR_DIG025  * 380.89 +
CCSR_EAR001  * -612.14 +
CCSR_EAR002  * -650.06 +
CCSR_EAR003  * -589.80 +
CCSR_EAR004  * -659.71 +
CCSR_EAR006  * -110.37 +
CCSR_END001  * -459.84 +
CCSR_END002  * 1992.61 +
CCSR_END003  * 2735.33 +
CCSR_END005  * -1663.96 +
CCSR_END006  * -2351.11 +
CCSR_END007  * -174.55 +
CCSR_END008  * 14821.48 +
CCSR_END009  * -467.58 +
CCSR_END010  * -57.68 +
CCSR_END011  * 3750.53 +
CCSR_END013  * 3878.77 +
CCSR_END014  * -2840.20 +
CCSR_END015  * 973.47 +
CCSR_END016  * -903.78 +
CCSR_END017  * 2011.10 +
CCSR_EXT001  * 178.07 +
CCSR_EXT002  * 1917.86 +
CCSR_EXT005  * 6078.09 +
CCSR_EXT007  * 1464.32 +
CCSR_EXT008  * 1783.02 +
CCSR_EXT009  * 3249.60 +
CCSR_EXT010  * 2358.22 +
CCSR_EXT013  * -330.28 +
CCSR_EXT014  * 994.66 +
CCSR_EXT017  * 2031.65 +
CCSR_EXT019  * 862.72 +
CCSR_EXT020  * -281.60 +
CCSR_EXT021  * 2451.61 +
CCSR_EXT022  * 473.66 +
CCSR_EXT023  * 465.57 +
CCSR_EXT026  * 165.90 +
CCSR_EYE002  * -1805.25 +
CCSR_EYE003  * -84.75 +
CCSR_EYE004  * -1615.31 +
CCSR_EYE005  * 401.38 +
CCSR_EYE006  * -247.33 +
CCSR_EYE008  * -517.67 +
CCSR_EYE010  * -565.54 +
CCSR_EYE012  * 117.80 +
CCSR_FAC001  * -131.48 +
CCSR_FAC003  * 579.09 +
CCSR_FAC004  * 947.32 +
CCSR_FAC006  * 18898.75 +
CCSR_FAC007  * 384.68 +
CCSR_FAC008  * 898.05 +
CCSR_FAC009  * 959.61 +
CCSR_FAC010  * 2845.66 +
CCSR_FAC014  * 113.24 +
CCSR_FAC016  * -226.11 +
CCSR_FAC019  * 347.96 +
CCSR_FAC020  * 260.90 +
CCSR_FAC021  * 574.57 +
CCSR_FAC022  * 4016.25 +
CCSR_FAC023  * 9897.29 +
CCSR_FAC024  * 503.53 +
CCSR_FAC025  * -294.95 +
CCSR_GEN001  * 527.25 +
CCSR_GEN002  * 5391.78 +
CCSR_GEN003  * 5085.63 +
CCSR_GEN005  * -1224.02 +
CCSR_GEN006  * -933.89 +
CCSR_GEN008  * 442.28 +
CCSR_GEN009  * -311.98 +
CCSR_GEN010  * -2289.37 +
CCSR_GEN011  * -1046.27 +
CCSR_GEN014  * 103.40 +
CCSR_GEN016  * 373.64 +
CCSR_GEN017  * -1295.93 +
CCSR_GEN019  * -7476.96 +
CCSR_GEN020  * -2314.43 +
CCSR_GEN021  * -73.92 +
CCSR_GEN022  * 1650.81 +
CCSR_GEN023  * -314.67 +
CCSR_GEN024  * -2447.92 +
CCSR_GEN025  * -203.39 +
CCSR_GEN026  * 4184.33 +
CCSR_INF001  * 1874.93 +
CCSR_INF002  * 11580.50 +
CCSR_INF003  * 139.34 +
CCSR_INF006  * 24284.32 +
CCSR_INF007  * 1262.45 +
CCSR_INF009  * 333.01 +
CCSR_INJ001  * 5056.02 +
CCSR_INJ002  * 8404.88 +
CCSR_INJ003  * 6369.28 +
CCSR_INJ004  * 3554.17 +
CCSR_INJ005  * 3222.03 +
CCSR_INJ006  * 15138.45 +
CCSR_INJ007  * 1715.93 +
CCSR_INJ008  * 904.63 +
CCSR_INJ009  * 14660.81 +
CCSR_INJ010  * 2628.35 +
CCSR_INJ011  * 174.56 +
CCSR_INJ012  * -595.07 +
CCSR_INJ013  * 3668.75 +
CCSR_INJ014  * 3943.99 +
CCSR_INJ016  * 2381.89 +
CCSR_INJ018  * 601.79 +
CCSR_INJ019  * -2660.14 +
CCSR_INJ020  * -531.19 +
CCSR_INJ025  * 1197.95 +
CCSR_INJ026  * 481.15 +
CCSR_INJ028  * 261.69 +
CCSR_INJ029  * 1222.74 +
CCSR_INJ030  * 2092.53 +
CCSR_INJ031  * -184.99 +
CCSR_INJ033  * 9274.12 +
CCSR_INJ034  * 1327.23 +
CCSR_INJ035  * 10743.87 +
CCSR_INJ036  * -3714.11 +
CCSR_INJ037  * 3836.35 +
CCSR_INJ038  * 4820.07 +
CCSR_INJ039  * 4317.83 +
CCSR_INJ040  * 4036.35 +
CCSR_INJ041  * 1677.01 +
CCSR_INJ042  * 1556.38 +
CCSR_INJ043  * 4923.32 +
CCSR_INJ044  * 1107.34 +
CCSR_INJ046  * 12499.58 +
CCSR_INJ047  * -1514.81 +
CCSR_INJ049  * 411.89 +
CCSR_INJ050  * 573.54 +
CCSR_INJ051  * 3044.24 +
CCSR_INJ053  * -1535.25 +
CCSR_INJ056  * 723.12 +
CCSR_INJ060  * 915.60 +
CCSR_INJ061  * 700.90 +
CCSR_INJ062  * 287.71 +
CCSR_INJ063  * 559.87 +
CCSR_INJ067  * 439.29 +
CCSR_INJ069  * 3076.40 +
CCSR_INJ071  * 6106.79 +
CCSR_INJ072  * 1450.65 +
CCSR_INJ073  * 684.10 +
CCSR_INJ075  * 645.86 +
CCSR_INJ076  * 2514.11 +
CCSR_MAL001  * -5238.69 +
CCSR_MAL002  * -2825.14 +
CCSR_MAL003  * -2833.67 +
CCSR_MAL004  * -9164.68 +
CCSR_MAL005  * -2992.17 +
CCSR_MAL006  * 1366.87 +
CCSR_MAL007  * -2338.38 +
CCSR_MAL010  * 1347.77 +
CCSR_MBD001  * -2649.56 +
CCSR_MBD002  * -316.76 +
CCSR_MBD003  * -471.03 +
CCSR_MBD004  * -1726.89 +
CCSR_MBD005  * -650.93 +
CCSR_MBD006  * -1576.69 +
CCSR_MBD008  * -3472.22 +
CCSR_MBD009  * -1933.77 +
CCSR_MBD010  * -7759.56 +
CCSR_MBD011  * -4784.94 +
CCSR_MBD012  * -2000.86 +
CCSR_MBD017  * -454.43 +
CCSR_MBD018  * -2308.17 +
CCSR_MBD019  * 459.66 +
CCSR_MBD020  * 1653.44 +
CCSR_MBD022  * 4334.70 +
CCSR_MBD026  * -711.95 +
CCSR_MBD027  * 3241.40 +
CCSR_MBD028  * -9105.71 +
CCSR_MBD033  * 8594.99 +
CCSR_MSK001  * -902.12 +
CCSR_MSK002  * -5079.46 +
CCSR_MSK003  * 9807.01 +
CCSR_MSK004  * -2828.91 +
CCSR_MSK005  * 6995.43 +
CCSR_MSK006  * -1958.02 +
CCSR_MSK007  * -815.09 +
CCSR_MSK008  * -2948.13 +
CCSR_MSK009  * -519.62 +
CCSR_MSK010  * -190.05 +
CCSR_MSK011  * -1471.96 +
CCSR_MSK012  * 427.20 +
CCSR_MSK013  * 778.22 +
CCSR_MSK015  * 862.29 +
CCSR_MSK018  * 13939.99 +
CCSR_MSK021  * -1530.38 +
CCSR_MSK022  * -7567.40 +
CCSR_MSK023  * -654.61 +
CCSR_MSK024  * -951.01 +
CCSR_MSK026  * -179.32 +
CCSR_MSK028  * 2506.57 +
CCSR_MSK029  * -1825.77 +
CCSR_MSK030  * 11027.12 +
CCSR_MSK032  * -9601.21 +
CCSR_MSK036  * 6751.42 +
CCSR_MSK037  * -2439.08 +
CCSR_MSK038  * -385.72 +
CCSR_NEO002  * -2224.62 +
CCSR_NEO003  * 2693.37 +
CCSR_NEO004  * 2466.26 +
CCSR_NEO005  * 4432.78 +
CCSR_NEO006  * 4166.73 +
CCSR_NEO007  * -2048.76 +
CCSR_NEO009  * 2938.94 +
CCSR_NEO010  * 2070.27 +
CCSR_NEO014  * 18765.92 +
CCSR_NEO015  * 4837.43 +
CCSR_NEO016  * 1148.99 +
CCSR_NEO017  * -6749.26 +
CCSR_NEO018  * -14865.6 +
CCSR_NEO020  * -1962.75 +
CCSR_NEO021  * 3437.92 +
CCSR_NEO022  * 5023.61 +
CCSR_NEO025  * -795.92 +
CCSR_NEO026  * 836.23 +
CCSR_NEO027  * -796.37 +
CCSR_NEO028  * 451.62 +
CCSR_NEO030  * -10693.0 +
CCSR_NEO034  * -2378.46 +
CCSR_NEO035  * -809.69 +
CCSR_NEO038  * -2448.03 +
CCSR_NEO039  * 1465.72 +
CCSR_NEO040  * -632.58 +
CCSR_NEO042  * 4075.68 +
CCSR_NEO043  * -5870.31 +
CCSR_NEO044  * 3429.66 +
CCSR_NEO046  * 4170.45 +
CCSR_NEO049  * 9321.90 +
CCSR_NEO051  * 9021.33 +
CCSR_NEO053  * 3417.64 +
CCSR_NEO058  * -8057.50 +
CCSR_NEO059  * 7883.87 +
CCSR_NEO060  * -28805.9 +
CCSR_NEO061  * 14555.29 +
CCSR_NEO062  * 32582.59 +
CCSR_NEO063  * -8251.63 +
CCSR_NEO064  * -2657.73 +
CCSR_NEO066  * -14857.5 +
CCSR_NEO070  * 12930.68 +
CCSR_NEO072  * 394.72 +
CCSR_NEO073  * 135.89 +
CCSR_NEO074  * 17345.25 +
CCSR_NVS001  * 3692.97 +
CCSR_NVS002  * 2641.68 +
CCSR_NVS004  * 4643.87 +
CCSR_NVS006  * 418.27 +
CCSR_NVS008  * 3875.04 +
CCSR_NVS009  * -3504.11 +
CCSR_NVS010  * -734.76 +
CCSR_NVS011  * 467.34 +
CCSR_NVS013  * 3909.42 +
CCSR_NVS014  * 16470.00 +
CCSR_NVS015  * 1059.42 +
CCSR_NVS017  * -316.74 +
CCSR_NVS018  * -3634.69 +
CCSR_NVS019  * 347.50 +
CCSR_NVS020  * 252.63 +
CCSR_PNL002  * -8779.03 +
CCSR_PNL003  * 1467.60 +
CCSR_PNL005  * 22549.39 +
CCSR_PNL006  * -15225.6 +
CCSR_PNL007  * 352.01 +
CCSR_PNL010  * -752.23 +
CCSR_PNL012  * -2282.94 +
CCSR_PNL013  * -927.22 +
CCSR_PNL014  * 5100.88 +
CCSR_PRG002  * 1018.28 +
CCSR_PRG005  * 4276.98 +
CCSR_PRG009  * 686.32 +
CCSR_PRG010  * 1099.49 +
CCSR_PRG011  * -428.57 +
CCSR_PRG013  * -355.10 +
CCSR_PRG014  * -5414.18 +
CCSR_PRG018  * -5908.68 +
CCSR_PRG019  * -1651.09 +
CCSR_PRG023  * 1254.29 +
CCSR_PRG024  * 1521.41 +
CCSR_PRG028  * 283.98 +
CCSR_PRG029  * 610.51 +
CCSR_RSP001  * -600.53 +
CCSR_RSP002  * 1548.68 +
CCSR_RSP003  * -2811.71 +
CCSR_RSP004  * -292.99 +
CCSR_RSP005  * -256.64 +
CCSR_RSP006  * -75.89 +
CCSR_RSP007  * -781.69 +
CCSR_RSP009  * -987.91 +
CCSR_RSP011  * 1524.04 +
CCSR_RSP012  * -5454.28 +
CCSR_RSP013  * -6923.82 +
CCSR_RSP014  * 16257.13 +
CCSR_RSP015  * -4444.22 +
CCSR_RSP016  * 741.11 +
CCSR_RSP017  * 23975.50 +
CCSR_SKN001  * -1031.37 +
CCSR_SKN002  * 349.23 +
CCSR_SKN003  * 3828.67 +
CCSR_SKN004  * -1247.36 +
CCSR_SKN005  * 64.68 +
CCSR_SYM001  * -1513.96 +
CCSR_SYM002  * 2791.77 +
CCSR_SYM003  * 23005.07 +
CCSR_SYM004  * -1944.97 +
CCSR_SYM006  * -129.30 +
CCSR_SYM007  * -3409.92 +
CCSR_SYM008  * -3436.56 +
CCSR_SYM010  * -228.86 +
CCSR_SYM013  * 175.04 +
CCSR_SYM015  * -1709.41 +
CCSR_SYM016  * -267.55 +
CCSR_SYM017  * 391.07 +
DXI1_BLD002  * -1191.23 +
DXI1_BLD003  * -818.78 +
DXI1_BLD004  * 22975.18 +
DXI1_BLD005  * 15460.21 +
DXI1_BLD006  * 6026.65 +
DXI1_BLD007  * 7841.05 +
DXI1_BLD008  * 6083.04 +
DXI1_BLD009  * 13216.21 +
DXI1_BLD010  * 4072.95 +
DXI1_BLD011  * 3976.58 +
DXI1_BLD013  * 6311.08 +
DXI1_BLD014  * 7161.07 +
DXI1_BLD015  * -742.30 +
DXI1_BLD016  * 427.83 +
DXI1_BLD017  * 2953.54 +
DXI1_BLD018  * 57159.48 +
DXI1_BLD019  * 76690.52 +
DXI1_BLD020  * 16843.28 +
DXI1_BLD021  * 1824.80 +
DXI1_BLD022  * 1155.28 +
DXI1_BLD023  * 4268.27 +
DXI1_BLD024  * -408.87 +
DXI1_BLD025  * 2623.24 +
DXI1_BLD026  * 5734.96 +
DXI1_BLD027  * 2714.38 +
DXI1_BLD028  * 3000.02 +
DXI1_BLD029  * 4295.82 +
DXI1_BLD030  * 29240.14 +
DXI1_BLD031  * 2934.31 +
DXI1_BLD032  * 6733.88 +
DXI1_BLD033  * -775.42 +
DXI1_BLD034  * 4258.56 +
DXI1_BLD036  * 970.59 +
DXI1_BLD037  * 31169.35 +
DXI1_BLD038  * 5294.16 +
DXI1_BLD039  * 10892.85 +
DXI1_BLD040  * -2220.61 +
DXI1_BLD041  * 9188.57 +
DXI1_BLD042  * -3864.31 +
DXI1_BLD043  * 2043.39 +
DXI1_BLD044  * -1324.42 +
DXI1_BLD046  * -2578.98 +
DXI1_BLD047  * 20353.88 +
DXI1_CIR001  * 7600.10 +
DXI1_CIR003  * -1156.80 +
DXI1_CIR004  * 1672.16 +
DXI1_CIR006  * 31107.34 +
DXI1_CIR007  * 1844.97 +
DXI1_CIR008  * 21282.79 +
DXI1_CIR009  * 9462.96 +
DXI1_CIR010  * 14390.96 +
DXI1_CIR011  * 10094.55 +
DXI1_CIR012  * 30088.98 +
DXI1_CIR013  * 4731.26 +
DXI1_CIR014  * 19871.48 +
DXI1_CIR015  * 11098.78 +
DXI1_CIR016  * 4413.62 +
DXI1_CIR017  * 12816.82 +
DXI1_CIR018  * 18974.39 +
DXI1_CIR019  * 12085.82 +
DXI1_CIR021  * 12019.32 +
DXI1_CIR022  * 6818.11 +
DXI1_CIR023  * 9173.07 +
DXI1_CIR024  * 5125.52 +
DXI1_CIR025  * 7891.00 +
DXI1_CIR026  * 12530.58 +
DXI1_CIR027  * 4778.54 +
DXI1_CIR028  * 8482.84 +
DXI1_CIR029  * 3431.17 +
DXI1_CIR030  * 10167.89 +
DXI1_CIR031  * 13297.03 +
DXI1_CIR032  * 14040.83 +
DXI1_CIR033  * 3876.85 +
DXI1_CIR034  * -5250.96 +
DXI1_CIR035  * 8219.85 +
DXI1_CIR036  * 10858.59 +
DXI1_CIR037  * 1273.41 +
DXI1_CIR038  * 7488.11 +
DXI1_CIR039  * 6218.95 +
DXI1_CIR042  * 3646.76 +
DXI1_CIR043  * 8395.62 +
DXI1_CIR045  * 2021.78 +
DXI1_CIR046  * 17086.99 +
DXI1_CIR047  * 3373.32 +
DXI1_CIR048  * 7388.43 +
DXI1_CIR050  * 18046.37 +
DXI1_CIR051  * 7634.52 +
DXI1_CIR052  * 4110.76 +
DXI1_CIR053  * 3143.91 +
DXI1_CIR054  * 18388.52 +
DXI1_CIR055  * 5417.08 +
DXI1_CIR056  * 4441.12 +
DXI1_CIR057  * 5648.02 +
DXI1_CIR058  * 12585.77 +
DXI1_CIR059  * 9113.96 +
DXI1_CIR060  * 6057.74 +
DXI1_CIR061  * 1835.74 +
DXI1_CIR062  * 10347.21 +
DXI1_CIR063  * 2006.66 +
DXI1_CIR064  * 432.08 +
DXI1_CIR065  * 6263.29 +
DXI1_CIR066  * 1786.87 +
DXI1_CIR067  * 8104.34 +
DXI1_CIR068  * 5326.15 +
DXI1_CIR069  * 2008.08 +
DXI1_CIR070  * 856.49 +
DXI1_CIR071  * 2447.22 +
DXI1_CIR072  * -906.71 +
DXI1_CIR073  * 10957.47 +
DXI1_CIR075  * 3827.90 +
DXI1_CIR076  * 2032.19 +
DXI1_CIR077  * 611.87 +
DXI1_CIR078  * 30848.62 +
DXI1_CIR079  * 29863.08 +
DXI1_CIR080  * 4580.49 +
DXI1_CIR082  * 1839.16 +
DXI1_CIR083  * 3361.27 +
DXI1_CIR084  * 3708.14 +
DXI1_CIR085  * 11587.55 +
DXI1_CIR086  * 1004.60 +
DXI1_CIR087  * 3334.54 +
DXI1_CIR088  * 8184.59 +
DXI1_DIG001  * 3347.70 +
DXI1_DIG002  * 474.77 +
DXI1_DIG003  * 819.05 +
DXI1_DIG004  * 3133.79 +
DXI1_DIG006  * 887.71 +
DXI1_DIG007  * 4451.23 +
DXI1_DIG009  * 254.48 +
DXI1_DIG010  * 265.99 +
DXI1_DIG014  * 706.55 +
DXI1_DIG015  * 1109.63 +
DXI1_DIG016  * 1126.35 +
DXI1_DIG019  * 1057.14 +
DXI1_DIG020  * 247.75 +
DXI1_DIG021  * 591.75 +
DXI1_DIG023  * 11308.65 +
DXI1_DIG024  * 1765.05 +
DXI1_DIG026  * 627.49 +
DXI1_DIG028  * 981.92 +
DXI1_DIG030  * 9043.54 +
DXI1_DIG031  * 6672.47 +
DXI1_DIG032  * 3712.49 +
DXI1_DIG033  * 325.02 +
DXI1_DIG035  * 697.67 +
DXI1_DIG036  * 7502.34 +
DXI1_DIG037  * 4455.19 +
DXI1_DIG038  * 9453.33 +
DXI1_DIG039  * 6028.35 +
DXI1_DIG040  * 25111.27 +
DXI1_DIG042  * 2192.98 +
DXI1_DIG043  * 5545.68 +
DXI1_DIG044  * 1311.81 +
DXI1_DIG045  * 6978.12 +
DXI1_DIG046  * 2671.65 +
DXI1_DIG047  * 1622.65 +
DXI1_DIG048  * 2656.31 +
DXI1_DIG049  * 3811.14 +
DXI1_DIG050  * 11520.84 +
DXI1_DIG051  * 2830.18 +
DXI1_DIG052  * 7764.42 +
DXI1_DIG053  * 10397.93 +
DXI1_DIG054  * 567.20 +
DXI1_DIG055  * 10216.53 +
DXI1_DIG056  * 5965.42 +
DXI1_DIG058  * 1264.45 +
DXI1_DIG059  * 5213.66 +
DXI1_DIG060  * 764.10 +
DXI1_DIG061  * 941.36 +
DXI1_DIG062  * -1032.51 +
DXI1_DIG063  * 4393.34 +
DXI1_DIG064  * -1206.43 +
DXI1_DIG066  * 874.70 +
DXI1_DIG067  * 1681.43 +
DXI1_DIG068  * -993.58 +
DXI1_DIG069  * 3830.90 +
DXI1_DIG070  * 7853.85 +
DXI1_DIG071  * 3871.87 +
DXI1_DIG073  * 1414.03 +
DXI1_DIG075  * 16733.07 +
DXI1_DIG076  * 2962.23 +
DXI1_DIG077  * 1191.88 +
DXI1_DIG078  * 7084.37 +
DXI1_DIG079  * 6580.94 +
DXI1_DIG080  * 1163.91 +
DXI1_DIG081  * 2779.91 +
DXI1_DIG082  * 6837.05 +
DXI1_DIG083  * 7772.03 +
DXI1_DIG084  * 5265.24 +
DXI1_DIG085  * 4618.28 +
DXI1_DIG086  * 3435.33 +
DXI1_DIG087  * 1619.99 +
DXI1_DIG088  * 2437.94 +
DXI1_DIG089  * 2867.84 +
DXI1_DIG090  * 3578.25 +
DXI1_DIG091  * 2748.80 +
DXI1_DIG092  * 4617.60 +
DXI1_DIG093  * 736.75 +
DXI1_DIG094  * -916.53 +
DXI1_DIG095  * 3169.38 +
DXI1_DIG096  * 7529.82 +
DXI1_DIG097  * 1439.06 +
DXI1_DIG098  * 3139.01 +
DXI1_DIG099  * 2687.11 +
DXI1_DIG100  * 6686.08 +
DXI1_DIG101  * 2903.07 +
DXI1_DIG102  * -4320.76 +
DXI1_EAR001  * 238.57 +
DXI1_EAR003  * 1545.82 +
DXI1_EAR004  * 1083.12 +
DXI1_EAR005  * 1156.38 +
DXI1_EAR007  * 1304.58 +
DXI1_EAR008  * 1602.40 +
DXI1_EAR010  * 569.29 +
DXI1_EAR011  * 435.22 +
DXI1_EAR012  * 684.43 +
DXI1_EAR013  * 502.99 +
DXI1_EAR014  * 471.95 +
DXI1_EAR016  * 231.87 +
DXI1_EAR018  * 201.98 +
DXI1_EAR019  * 566.10 +
DXI1_EAR020  * 1454.95 +
DXI1_EAR021  * 2361.40 +
DXI1_EAR022  * 1317.93 +
DXI1_EAR023  * 3451.82 +
DXI1_EAR024  * 1086.07 +
DXI1_EAR025  * 668.22 +
DXI1_EAR026  * 1731.41 +
DXI1_EAR027  * 2982.77 +
DXI1_EAR028  * 594.12 +
DXI1_EAR029  * 880.19 +
DXI1_EAR031  * 1077.74 +
DXI1_EAR032  * 606.78 +
DXI1_EAR033  * 383.35 +
DXI1_EAR034  * 1811.91 +
DXI1_EAR035  * 841.05 +
DXI1_EAR036  * 1325.61 +
DXI1_EAR038  * 1010.52 +
DXI1_END001  * 5212.65 +
DXI1_END002  * 1572.30 +
DXI1_END003  * 9471.07 +
DXI1_END004  * 1000.89 +
DXI1_END005  * 3630.87 +
DXI1_END006  * 4274.95 +
DXI1_END007  * 630.01 +
DXI1_END008  * 902.28 +
DXI1_END009  * 1057.86 +
DXI1_END010  * 246.78 +
DXI1_END011  * 1996.01 +
DXI1_END012  * 3389.58 +
DXI1_END013  * 3358.35 +
DXI1_END014  * 771.67 +
DXI1_END015  * 7722.87 +
DXI1_END016  * 522.80 +
DXI1_END017  * 2917.46 +
DXI1_END018  * 31343.47 +
DXI1_END019  * 1727.95 +
DXI1_END020  * 1164.15 +
DXI1_END022  * 33332.57 +
DXI1_END023  * 4747.06 +
DXI1_END024  * 341.55 +
DXI1_END025  * 4315.95 +
DXI1_END026  * 4029.83 +
DXI1_END027  * 1857.92 +
DXI1_END028  * 1549.66 +
DXI1_END029  * -2368.76 +
DXI1_END030  * -336.10 +
DXI1_END031  * -4009.04 +
DXI1_END032  * 1061.15 +
DXI1_END034  * 1352.60 +
DXI1_END035  * 7904.98 +
DXI1_END036  * 2521.52 +
DXI1_END038  * 24563.12 +
DXI1_END039  * 1244.43 +
DXI1_END040  * 4455.69 +
DXI1_END041  * 8425.10 +
DXI1_END042  * 3788.41 +
DXI1_END043  * 915.86 +
DXI1_END044  * 1088.34 +
DXI1_END045  * 5386.23 +
DXI1_END046  * 1187.22 +
DXI1_END047  * 1265.13 +
DXI1_END048  * 108.56 +
DXI1_END049  * 5027.50 +
DXI1_END050  * 1933.93 +
DXI1_END052  * -475.33 +
DXI1_END053  * 17908.51 +
DXI1_END054  * 659.50 +
DXI1_END055  * 942.25 +
DXI1_END056  * 4567.79 +
DXI1_END058  * 7313.15 +
DXI1_END059  * 85525.18 +
DXI1_END060  * 2192.59 +
DXI1_END062  * 1632.47 +
DXI1_END064  * -812.70 +
DXI1_END066  * -3767.87 +
DXI1_END067  * 3337.90 +
DXI1_END068  * 14150.14 +
DXI1_END069  * -1850.88 +
DXI1_END070  * 310.48 +
DXI1_END071  * -375.50 +
DXI1_END072  * 693.24 +
DXI1_END073  * -225.52 +
DXI1_END074  * 7757.98 +
DXI1_END076  * -592.29 +
DXI1_END077  * 3046.05 +
DXI1_END078  * 1764.67 +
DXI1_END079  * 5092.12 +
DXI1_END080  * 5944.35 +
DXI1_END081  * 419.20 +
DXI1_END083  * 11820.69 +
DXI1_EXT004  * 6470.07 +
DXI1_EXT005  * 475.36 +
DXI1_EXT006  * 903.75 +
DXI1_EXT009  * -234.77 +
DXI1_EXT010  * 275.39 +
DXI1_EXT011  * 2953.51 +
DXI1_EXT015  * 3722.70 +
DXI1_EXT019  * -288.44 +
DXI1_EXT020  * 5239.10 +
DXI1_EXT022  * 730.03 +
DXI1_EXT027  * 5834.02 +
DXI1_EXT028  * 3338.58 +
DXI1_EYE002  * 68.07 +
DXI1_EYE004  * -183.36 +
DXI1_EYE006  * -211.83 +
DXI1_EYE007  * -250.43 +
DXI1_EYE008  * 800.55 +
DXI1_EYE009  * 879.22 +
DXI1_EYE010  * 2831.44 +
DXI1_EYE011  * 1671.94 +
DXI1_EYE012  * 2420.00 +
DXI1_EYE013  * 246.51 +
DXI1_EYE015  * 1278.65 +
DXI1_EYE016  * 2790.65 +
DXI1_EYE017  * 5317.13 +
DXI1_EYE018  * 2772.94 +
DXI1_EYE020  * 1898.56 +
DXI1_EYE021  * 1424.94 +
DXI1_EYE023  * 3455.77 +
DXI1_EYE024  * 390.63 +
DXI1_EYE025  * 680.28 +
DXI1_EYE026  * 1343.64 +
DXI1_EYE027  * 3291.47 +
DXI1_EYE028  * 1027.80 +
DXI1_EYE029  * 1979.04 +
DXI1_EYE030  * 900.50 +
DXI1_EYE031  * 3612.64 +
DXI1_EYE033  * 975.51 +
DXI1_EYE034  * 1762.13 +
DXI1_EYE035  * 1939.48 +
DXI1_EYE037  * 2384.56 +
DXI1_EYE039  * 790.53 +
DXI1_EYE043  * 656.78 +
DXI1_EYE044  * 624.25 +
DXI1_EYE045  * 507.35 +
DXI1_EYE046  * 5082.92 +
DXI1_EYE047  * 820.97 +
DXI1_EYE049  * 1174.47 +
DXI1_EYE050  * 488.79 +
DXI1_EYE052  * 540.00 +
DXI1_EYE053  * 1713.30 +
DXI1_EYE058  * 98.36 +
DXI1_EYE061  * 558.08 +
DXI1_EYE063  * 361.86 +
DXI1_EYE068  * 372.19 +
DXI1_EYE072  * 177.20 +
DXI1_EYE080  * 341.31 +
DXI1_EYE081  * 1724.46 +
DXI1_EYE082  * 375.17 +
DXI1_EYE083  * -1699.22 +
DXI1_EYE085  * 488.71 +
DXI1_EYE086  * 678.83 +
DXI1_EYE087  * 426.15 +
DXI1_EYE088  * 1580.88 +
DXI1_EYE093  * 343.75 +
DXI1_EYE094  * 1824.66 +
DXI1_EYE095  * 580.32 +
DXI1_EYE096  * 638.82 +
DXI1_EYE097  * 3263.62 +
DXI1_EYE100  * 646.72 +
DXI1_EYE103  * 2337.75 +
DXI1_EYE107  * 921.94 +
DXI1_EYE110  * 298.66 +
DXI1_EYE112  * 2266.90 +
DXI1_EYE118  * 1967.70 +
DXI1_EYE122  * 2231.00 +
DXI1_EYE123  * 2764.39 +
DXI1_EYE125  * 3226.16 +
DXI1_EYE126  * 521.91 +
DXI1_EYE132  * 1399.74 +
DXI1_EYE133  * 1891.17 +
DXI1_EYE134  * 1891.97 +
DXI1_EYE135  * 3954.87 +
DXI1_EYE136  * 2981.51 +
DXI1_EYE137  * 2034.62 +
DXI1_EYE138  * -1041.02 +
DXI1_EYE140  * 1630.40 +
DXI1_EYE142  * 321.88 +
DXI1_EYE144  * 580.46 +
DXI1_EYE146  * 1322.72 +
DXI1_EYE150  * 512.04 +
DXI1_EYE152  * 962.10 +
DXI1_EYE153  * 1288.09 +
DXI1_EYE155  * 296.15 +
DXI1_EYE158  * 2073.84 +
DXI1_EYE159  * 1315.55 +
DXI1_EYE162  * 428.08 +
DXI1_EYE163  * 260.82 +
DXI1_EYE164  * 673.71 +
DXI1_EYE166  * 429.05 +
DXI1_EYE167  * 3277.27 +
DXI1_EYE168  * 974.21 +
DXI1_EYE169  * 1202.83 +
DXI1_EYE170  * 1613.48 +
DXI1_EYE171  * 484.15 +
DXI1_EYE172  * 998.16 +
DXI1_EYE173  * 2365.89 +
DXI1_EYE174  * 539.27 +
DXI1_EYE175  * 1946.02 +
DXI1_EYE176  * 443.62 +
DXI1_EYE177  * 1217.85 +
DXI1_EYE178  * 2028.84 +
DXI1_EYE179  * -2176.90 +
DXI1_EYE180  * 2764.04 +
DXI1_EYE181  * 6078.83 +
DXI1_EYE184  * 3256.03 +
DXI1_EYE185  * 1087.20 +
DXI1_EYE186  * 1975.63 +
DXI1_EYE187  * 661.26 +
DXI1_EYE188  * 556.48 +
DXI1_EYE189  * 855.71 +
DXI1_EYE190  * 762.00 +
DXI1_EYE191  * 1515.26 +
DXI1_EYE193  * 646.71 +
DXI1_EYE194  * 3606.26 +
DXI1_EYE195  * -421.76 +
DXI1_EYE197  * 790.17 +
DXI1_EYE198  * -265.24 +
DXI1_EYE200  * 2073.17 +
DXI1_EYE203  * 4047.51 +
DXI1_EYE204  * 626.01 +
DXI1_EYE208  * 212.54 +
DXI1_EYE209  * 595.46 +
DXI1_EYE211  * 798.53 +
DXI1_EYE214  * 2754.84 +
DXI1_EYE216  * 915.64 +
DXI1_EYE217  * 2222.68 +
DXI1_EYE218  * 1160.03 +
DXI1_EYE219  * 5505.35 +
DXI1_EYE220  * 1572.33 +
DXI1_EYE221  * 20628.63 +
DXI1_EYE223  * 3943.39 +
DXI1_EYE227  * -1191.29 +
DXI1_EYE229  * 2463.99 +
DXI1_EYE231  * -1193.77 +
DXI1_EYE232  * 707.65 +
DXI1_EYE233  * 626.67 +
DXI1_EYE234  * 1724.12 +
DXI1_EYE237  * 2929.66 +
DXI1_EYE238  * 1164.25 +
DXI1_EYE239  * 3617.71 +
DXI1_EYE240  * 1238.36 +
DXI1_FAC001  * 2424.23 +
DXI1_FAC002  * 1014.66 +
DXI1_FAC003  * 1103.39 +
DXI1_FAC004  * 3362.80 +
DXI1_FAC006  * 952.09 +
DXI1_FAC007  * 2602.98 +
DXI1_FAC008  * 2523.85 +
DXI1_FAC009  * 1521.19 +
DXI1_FAC010  * 4178.34 +
DXI1_FAC012  * 213.06 +
DXI1_FAC014  * 145.49 +
DXI1_FAC017  * 4316.91 +
DXI1_FAC018  * 839.68 +
DXI1_FAC020  * 653.14 +
DXI1_FAC021  * 52403.97 +
DXI1_FAC022  * 13011.34 +
DXI1_FAC023  * 11983.93 +
DXI1_FAC024  * 4597.55 +
DXI1_FAC025  * 18308.18 +
DXI1_FAC026  * 23351.83 +
DXI1_FAC027  * 8575.20 +
DXI1_FAC028  * 14885.95 +
DXI1_FAC029  * 6022.57 +
DXI1_FAC030  * 9918.30 +
DXI1_FAC031  * 18224.29 +
DXI1_FAC032  * 9093.89 +
DXI1_FAC033  * 9189.97 +
DXI1_FAC036  * 2309.31 +
DXI1_FAC037  * 1190.51 +
DXI1_FAC038  * 32109.72 +
DXI1_FAC039  * 10994.94 +
DXI1_FAC040  * -1456.43 +
DXI1_FAC041  * 269.57 +
DXI1_FAC043  * 10555.97 +
DXI1_FAC046  * -267.46 +
DXI1_FAC047  * 619.99 +
DXI1_FAC048  * 13025.60 +
DXI1_FAC049  * 9606.51 +
DXI1_FAC050  * 9763.28 +
DXI1_FAC051  * 4017.28 +
DXI1_FAC052  * 9538.96 +
DXI1_FAC053  * 15486.21 +
DXI1_FAC054  * 1089.90 +
DXI1_FAC055  * 9370.87 +
DXI1_FAC056  * -326.84 +
DXI1_FAC057  * 3844.63 +
DXI1_FAC058  * -134.15 +
DXI1_FAC059  * -291.53 +
DXI1_FAC060  * 595.31 +
DXI1_FAC064  * 20762.49 +
DXI1_FAC065  * 17974.96 +
DXI1_FAC066  * 2018.11 +
DXI1_FAC068  * 5447.51 +
DXI1_FAC069  * 10086.48 +
DXI1_FAC070  * 13184.40 +
DXI1_FAC071  * 15326.19 +
DXI1_FAC073  * 32919.46 +
DXI1_FAC074  * 6649.64 +
DXI1_FAC075  * 6323.74 +
DXI1_FAC076  * -2304.07 +
DXI1_FAC077  * -100.85 +
DXI1_FAC079  * 395.11 +
DXI1_FAC080  * -911.99 +
DXI1_FAC081  * -792.73 +
DXI1_FAC083  * 1715.99 +
DXI1_FAC085  * -413.50 +
DXI1_FAC086  * -629.59 +
DXI1_FAC087  * 2701.08 +
DXI1_FAC088  * 12758.66 +
DXI1_FAC089  * -2008.21 +
DXI1_FAC090  * 10026.92 +
DXI1_FAC091  * 523.82 +
DXI1_FAC092  * 795.46 +
DXI1_FAC093  * 2687.95 +
DXI1_FAC094  * 510.16 +
DXI1_FAC095  * 5007.73 +
DXI1_FAC096  * 7428.31 +
DXI1_FAC097  * 489.09 +
DXI1_FAC099  * 3121.23 +
DXI1_FAC100  * 9136.30 +
DXI1_FAC101  * 428.10 +
DXI1_FAC102  * 384.96 +
DXI1_FAC103  * 241.81 +
DXI1_FAC104  * -542.15 +
DXI1_FAC105  * 2090.65 +
DXI1_FAC106  * 1546.41 +
DXI1_FAC109  * -2378.44 +
DXI1_FAC111  * 11253.74 +
DXI1_FAC112  * 6879.10 +
DXI1_FAC113  * 4432.71 +
DXI1_FAC114  * 6478.15 +
DXI1_FAC115  * 6379.54 +
DXI1_FAC116  * 8843.69 +
DXI1_FAC118  * 1603.69 +
DXI1_FAC119  * 11314.06 +
DXI1_FAC120  * 4048.55 +
DXI1_FAC121  * -1986.52 +
DXI1_FAC122  * 3019.16 +
DXI1_FAC123  * 1299.75 +
DXI1_FAC124  * -727.52 +
DXI1_FAC125  * 7556.20 +
DXI1_FAC126  * 2430.10 +
DXI1_FAC127  * 1270.34 +
DXI1_FAC128  * 2101.47 +
DXI1_FAC129  * -8863.26 +
DXI1_FAC130  * -2903.21 +
DXI1_FAC131  * -1295.28 +
DXI1_FAC133  * 2201.12 +
DXI1_FAC134  * 1847.46 +
DXI1_FAC135  * 4263.35 +
DXI1_FAC136  * -1652.10 +
DXI1_FAC137  * 5804.85 +
DXI1_FAC138  * 1537.30 +
DXI1_FAC139  * 1682.54 +
DXI1_FAC140  * 308.14 +
DXI1_FAC141  * -1160.73 +
DXI1_FAC142  * 5603.80 +
DXI1_FAC143  * 3981.53 +
DXI1_FAC144  * 11405.59 +
DXI1_FAC145  * 433.23 +
DXI1_FAC146  * -8074.99 +
DXI1_FAC147  * 524.21 +
DXI1_FAC148  * 904.84 +
DXI1_FAC149  * 9196.48 +
DXI1_FAC150  * -298.22 +
DXI1_FAC151  * 606.52 +
DXI1_FAC153  * 240.56 +
DXI1_FAC154  * 414.53 +
DXI1_FAC155  * 2602.06 +
DXI1_FAC156  * 5634.90 +
DXI1_FAC158  * 12328.68 +
DXI1_FAC161  * -564.78 +
DXI1_FAC163  * 933.76 +
DXI1_GEN002  * 3153.38 +
DXI1_GEN003  * 9803.48 +
DXI1_GEN004  * 814.59 +
DXI1_GEN005  * 2232.47 +
DXI1_GEN006  * 2007.51 +
DXI1_GEN007  * 3399.41 +
DXI1_GEN008  * 1474.55 +
DXI1_GEN009  * 1185.74 +
DXI1_GEN010  * 490.83 +
DXI1_GEN011  * 1025.40 +
DXI1_GEN012  * 2789.91 +
DXI1_GEN013  * 2112.07 +
DXI1_GEN014  * 939.82 +
DXI1_GEN015  * 2711.89 +
DXI1_GEN017  * 2968.08 +
DXI1_GEN018  * 4260.94 +
DXI1_GEN019  * 635.01 +
DXI1_GEN020  * 288.15 +
DXI1_GEN021  * 1092.68 +
DXI1_GEN022  * 1278.81 +
DXI1_GEN023  * 5976.10 +
DXI1_GEN024  * 11376.28 +
DXI1_GEN025  * 10275.78 +
DXI1_GEN026  * 7946.98 +
DXI1_GEN028  * 329.19 +
DXI1_GEN030  * 7420.29 +
DXI1_GEN031  * 6720.33 +
DXI1_GEN032  * 4211.80 +
DXI1_GEN033  * 4177.43 +
DXI1_GEN034  * 1041.36 +
DXI1_GEN035  * 3980.64 +
DXI1_GEN036  * 2636.51 +
DXI1_GEN037  * 1830.32 +
DXI1_GEN038  * 4766.59 +
DXI1_GEN039  * 1611.04 +
DXI1_GEN040  * 204.37 +
DXI1_GEN043  * 4204.07 +
DXI1_GEN044  * 781.51 +
DXI1_GEN045  * 3980.06 +
DXI1_GEN046  * 1494.76 +
DXI1_GEN048  * 902.43 +
DXI1_GEN049  * 3675.99 +
DXI1_GEN051  * 241.25 +
DXI1_GEN052  * 2238.81 +
DXI1_GEN053  * 942.39 +
DXI1_GEN054  * 335.94 +
DXI1_GEN055  * 1368.17 +
DXI1_GEN057  * 3000.49 +
DXI1_GEN059  * 8413.24 +
DXI1_GEN060  * 793.42 +
DXI1_GEN061  * 2378.30 +
DXI1_GEN062  * 3494.13 +
DXI1_GEN063  * 2203.23 +
DXI1_GEN064  * 3171.31 +
DXI1_GEN065  * 408.38 +
DXI1_GEN066  * -210.84 +
DXI1_GEN067  * 480.40 +
DXI1_GEN070  * 1015.06 +
DXI1_GEN071  * 873.25 +
DXI1_GEN072  * 1836.32 +
DXI1_GEN073  * 1125.47 +
DXI1_GEN074  * 3535.17 +
DXI1_GEN075  * -5222.94 +
DXI1_GEN076  * 19826.58 +
DXI1_GEN077  * 2027.70 +
DXI1_GEN078  * 742.89 +
DXI1_GEN079  * 919.28 +
DXI1_GEN081  * 381.07 +
DXI1_GEN082  * 2010.39 +
DXI1_GEN083  * 2860.45 +
DXI1_GEN084  * 4723.59 +
DXI1_GEN085  * 1126.60 +
DXI1_GEN086  * 1902.49 +
DXI1_GEN087  * 568.67 +
DXI1_GEN088  * 1434.53 +
DXI1_GEN089  * 4042.08 +
DXI1_GEN090  * 1058.71 +
DXI1_GEN091  * 1516.80 +
DXI1_GEN092  * 2044.32 +
DXI1_GEN093  * 3161.80 +
DXI1_GEN094  * 3505.06 +
DXI1_GEN095  * 1406.02 +
DXI1_GEN096  * 239.61 +
DXI1_GEN097  * 318.60 +
DXI1_GEN098  * 14524.85 +
DXI1_GEN099  * 3404.80 +
DXI1_GEN100  * 2412.34 +
DXI1_GEN104  * -2060.07 +
DXI1_INF001  * 2731.81 +
DXI1_INF002  * 3292.14 +
DXI1_INF003  * 3795.49 +
DXI1_INF004  * 7118.64 +
DXI1_INF005  * 6729.84 +
DXI1_INF006  * -441.82 +
DXI1_INF008  * 1071.25 +
DXI1_INF009  * -3016.74 +
DXI1_INF011  * 17532.01 +
DXI1_INF012  * 1741.30 +
DXI1_INF014  * 3382.21 +
DXI1_INF016  * -758.09 +
DXI1_INF017  * -285.70 +
DXI1_INF019  * 1245.55 +
DXI1_INF020  * 4472.87 +
DXI1_INF023  * 4510.50 +
DXI1_INF025  * 5203.66 +
DXI1_INF026  * 2601.99 +
DXI1_INF027  * 2827.06 +
DXI1_INF028  * 2590.47 +
DXI1_INF030  * 3426.79 +
DXI1_INF031  * 1294.62 +
DXI1_INF034  * 2929.33 +
DXI1_INF035  * 4302.00 +
DXI1_INF038  * -1874.57 +
DXI1_INF040  * -1181.39 +
DXI1_INF041  * 11903.28 +
DXI1_INF042  * 12329.47 +
DXI1_INF043  * 285.53 +
DXI1_INF044  * -2886.58 +
DXI1_INF045  * 3066.13 +
DXI1_INF046  * 8521.39 +
DXI1_INF049  * 2870.75 +
DXI1_INF050  * 8709.85 +
DXI1_INF051  * 2851.55 +
DXI1_INF052  * -542.93 +
DXI1_INF056  * 342.36 +
DXI1_INF058  * 1618.05 +
DXI1_INF062  * 1231.06 +
DXI1_INF063  * 9081.63 +
DXI1_INF065  * 5131.79 +
DXI1_INF072  * 169.13 +
DXI1_INF073  * -1537.09 +
DXI1_INF074  * 1755.16 +
DXI1_INF075  * -234.22 +
DXI1_INF077  * 143.03 +
DXI1_INF081  * 2799.56 +
DXI1_INF082  * 274.53 +
DXI1_INF083  * 154.46 +
DXI1_INF084  * 8058.76 +
DXI1_INF086  * -3122.15 +
DXI1_INF087  * 5223.52 +
DXI1_INF089  * 2570.26 +
DXI1_INF090  * 15224.17 +
DXI1_INF091  * 1786.89 +
DXI1_INF092  * 3725.58 +
DXI1_INF093  * 1887.39 +
DXI1_INF094  * 5800.38 +
DXI1_INF095  * 1351.88 +
DXI1_INF096  * 2413.07 +
DXI1_INF098  * -283.48 +
DXI1_INF099  * 1561.48 +
DXI1_INF100  * 761.95 +
DXI1_INF101  * -894.63 +
DXI1_INF103  * 5591.93 +
DXI1_INF104  * 1506.99 +
DXI1_INF105  * 1470.85 +
DXI1_INF107  * 1456.05 +
DXI1_INF108  * 1262.75 +
DXI1_INF109  * 809.41 +
DXI1_INF113  * 5582.88 +
DXI1_INJ001  * 7057.65 +
DXI1_INJ002  * 4702.11 +
DXI1_INJ004  * 5721.57 +
DXI1_INJ005  * 141.09 +
DXI1_INJ006  * 5660.14 +
DXI1_INJ007  * 15934.65 +
DXI1_INJ008  * 8541.89 +
DXI1_INJ009  * 8271.97 +
DXI1_INJ012  * 2190.27 +
DXI1_INJ013  * 8898.12 +
DXI1_INJ014  * 627.90 +
DXI1_INJ015  * 1421.78 +
DXI1_INJ016  * 5816.83 +
DXI1_INJ017  * 3070.44 +
DXI1_INJ018  * 8640.58 +
DXI1_INJ019  * 6273.40 +
DXI1_INJ020  * 11897.48 +
DXI1_INJ021  * 5968.98 +
DXI1_INJ022  * 6757.74 +
DXI1_INJ023  * 11693.50 +
DXI1_INJ024  * 8957.20 +
DXI1_INJ026  * 12132.25 +
DXI1_INJ027  * 1365.73 +
DXI1_INJ028  * 12578.11 +
DXI1_INJ030  * 11170.31 +
DXI1_INJ031  * 2916.64 +
DXI1_INJ032  * -840.50 +
DXI1_INJ033  * 4726.21 +
DXI1_INJ034  * 33930.48 +
DXI1_INJ035  * 197.91 +
DXI1_INJ036  * 5074.21 +
DXI1_INJ037  * 13727.61 +
DXI1_INJ038  * 15441.63 +
DXI1_INJ040  * -2266.23 +
DXI1_INJ041  * 3195.50 +
DXI1_INJ042  * 6524.60 +
DXI1_INJ043  * -5091.50 +
DXI1_INJ044  * -1980.53 +
DXI1_INJ046  * 13386.62 +
DXI1_INJ047  * 2360.01 +
DXI1_INJ048  * 19994.29 +
DXI1_INJ049  * 8752.63 +
DXI1_INJ050  * 3193.93 +
DXI1_INJ051  * 617.03 +
DXI1_INJ052  * 1099.87 +
DXI1_INJ054  * 134.63 +
DXI1_INJ055  * 5257.13 +
DXI1_INJ056  * 4262.87 +
DXI1_INJ057  * 837.38 +
DXI1_INJ058  * -1013.45 +
DXI1_INJ059  * 1381.87 +
DXI1_INJ061  * 7200.20 +
DXI1_INJ062  * 188.07 +
DXI1_INJ063  * 4017.22 +
DXI1_INJ066  * 497.26 +
DXI1_INJ068  * -153.82 +
DXI1_INJ069  * 861.95 +
DXI1_INJ070  * 815.98 +
DXI1_INJ071  * -1154.46 +
DXI1_INJ072  * 936.31 +
DXI1_INJ073  * 2569.79 +
DXI1_INJ074  * 459.17 +
DXI1_INJ075  * -3397.24 +
DXI1_INJ076  * 2604.76 +
DXI1_INJ077  * 657.73 +
DXI1_INJ078  * 437.94 +
DXI1_INJ080  * 302.86 +
DXI1_INJ082  * 14188.38 +
DXI1_INJ083  * 13387.39 +
DXI1_INJ084  * 908.54 +
DXI1_INJ085  * 2030.40 +
DXI1_INJ086  * 2503.47 +
DXI1_INJ088  * 2721.98 +
DXI1_INJ089  * 1512.31 +
DXI1_INJ090  * 380.96 +
DXI1_INJ091  * 3102.06 +
DXI1_INJ092  * 1353.68 +
DXI1_INJ093  * 2381.05 +
DXI1_INJ094  * 13774.29 +
DXI1_INJ095  * 2399.15 +
DXI1_INJ096  * 1391.01 +
DXI1_INJ098  * 4038.23 +
DXI1_INJ099  * 1458.65 +
DXI1_INJ100  * 11221.55 +
DXI1_INJ101  * 1720.46 +
DXI1_INJ104  * -588.47 +
DXI1_INJ105  * 1328.25 +
DXI1_INJ106  * 2049.05 +
DXI1_INJ109  * 1516.82 +
DXI1_INJ110  * 622.84 +
DXI1_INJ116  * 2132.33 +
DXI1_INJ121  * -6449.46 +
DXI1_INJ122  * 3232.67 +
DXI1_INJ123  * 4322.51 +
DXI1_INJ124  * 1514.10 +
DXI1_INJ127  * 1351.53 +
DXI1_INJ128  * 3738.14 +
DXI1_INJ130  * 1211.46 +
DXI1_INJ131  * 6601.83 +
DXI1_INJ133  * -839.80 +
DXI1_INJ134  * 4916.16 +
DXI1_INJ137  * 1033.61 +
DXI1_INJ139  * 1470.42 +
DXI1_INJ142  * 2177.13 +
DXI1_INJ143  * -3806.93 +
DXI1_INJ144  * 637.70 +
DXI1_INJ145  * 9719.73 +
DXI1_INJ146  * 723.94 +
DXI1_INJ148  * 1201.53 +
DXI1_INJ149  * -3362.13 +
DXI1_INJ150  * 10529.02 +
DXI1_INJ151  * 4553.35 +
DXI1_INJ152  * 13449.12 +
DXI1_INJ153  * 5058.77 +
DXI1_INJ154  * 2499.22 +
DXI1_INJ155  * 1856.99 +
DXI1_INJ156  * 3846.50 +
DXI1_INJ157  * -1675.10 +
DXI1_INJ158  * 2820.29 +
DXI1_INJ160  * 2258.81 +
DXI1_INJ163  * 1170.48 +
DXI1_INJ166  * 7819.18 +
DXI1_INJ167  * 5971.31 +
DXI1_INJ168  * 2504.72 +
DXI1_INJ169  * 14819.81 +
DXI1_INJ170  * 11627.01 +
DXI1_INJ171  * 847.53 +
DXI1_INJ172  * -9676.65 +
DXI1_INJ173  * 4633.27 +
DXI1_MAL001  * 5356.83 +
DXI1_MAL002  * 3343.71 +
DXI1_MAL003  * 3130.29 +
DXI1_MAL004  * 5079.14 +
DXI1_MAL005  * 5367.72 +
DXI1_MAL006  * 7090.62 +
DXI1_MAL007  * 3009.08 +
DXI1_MAL008  * 6658.06 +
DXI1_MAL009  * 5251.63 +
DXI1_MAL010  * 5306.77 +
DXI1_MAL012  * 4401.44 +
DXI1_MAL013  * 5789.30 +
DXI1_MAL014  * 1407.75 +
DXI1_MAL015  * 5765.12 +
DXI1_MAL016  * -1146.80 +
DXI1_MAL017  * 13313.94 +
DXI1_MAL018  * -1786.10 +
DXI1_MAL019  * 8208.13 +
DXI1_MAL020  * 10601.36 +
DXI1_MAL021  * -1232.23 +
DXI1_MAL022  * 6674.33 +
DXI1_MAL023  * 4644.10 +
DXI1_MAL024  * 3703.84 +
DXI1_MAL025  * 7707.01 +
DXI1_MAL026  * 1913.06 +
DXI1_MAL027  * -843.66 +
DXI1_MAL028  * 2851.04 +
DXI1_MAL029  * -1108.11 +
DXI1_MAL030  * -1016.77 +
DXI1_MAL031  * 2371.33 +
DXI1_MAL032  * 1450.63 +
DXI1_MAL033  * 1313.51 +
DXI1_MAL034  * -837.37 +
DXI1_MBD002  * 3031.97 +
DXI1_MBD003  * 2983.05 +
DXI1_MBD004  * 1657.25 +
DXI1_MBD005  * 2115.16 +
DXI1_MBD006  * 7783.36 +
DXI1_MBD007  * 966.89 +
DXI1_MBD008  * 1969.47 +
DXI1_MBD009  * 2374.33 +
DXI1_MBD010  * 2707.70 +
DXI1_MBD011  * 962.11 +
DXI1_MBD013  * 8232.79 +
DXI1_MBD014  * 7887.11 +
DXI1_MBD015  * 492.63 +
DXI1_MBD016  * 2090.26 +
DXI1_MBD017  * 586.71 +
DXI1_MBD018  * 1135.86 +
DXI1_MBD019  * 5392.13 +
DXI1_MBD020  * 4981.84 +
DXI1_MBD022  * 1850.43 +
DXI1_MBD023  * 893.48 +
DXI1_MBD024  * -1454.62 +
DXI1_MBD025  * -1285.77 +
DXI1_MBD026  * 13914.28 +
DXI1_MBD027  * 13726.47 +
DXI1_MBD028  * 11761.31 +
DXI1_MBD029  * 7792.55 +
DXI1_MBD030  * 2948.47 +
DXI1_MBD031  * 10374.32 +
DXI1_MBD032  * 4410.56 +
DXI1_MBD033  * 3199.01 +
DXI1_MBD036  * 2566.83 +
DXI1_MBD037  * 2126.01 +
DXI1_MBD038  * 2966.77 +
DXI1_MBD039  * 2926.63 +
DXI1_MBD040  * 1653.17 +
DXI1_MBD041  * 1293.81 +
DXI1_MBD042  * 5377.09 +
DXI1_MBD043  * 1253.67 +
DXI1_MBD044  * 4383.79 +
DXI1_MBD045  * 1337.44 +
DXI1_MBD046  * 2849.61 +
DXI1_MBD047  * 2613.25 +
DXI1_MBD048  * -449.18 +
DXI1_MBD049  * 732.10 +
DXI1_MBD050  * 2627.13 +
DXI1_MBD051  * 840.96 +
DXI1_MBD052  * 171.42 +
DXI1_MBD053  * 386.30 +
DXI1_MBD057  * 5017.07 +
DXI1_MBD059  * 4258.23 +
DXI1_MBD060  * 7324.27 +
DXI1_MBD062  * 1435.10 +
DXI1_MBD065  * 928.70 +
DXI1_MBD066  * 1532.93 +
DXI1_MBD067  * 4141.81 +
DXI1_MBD068  * 8976.98 +
DXI1_MBD069  * 1406.15 +
DXI1_MBD070  * 3831.46 +
DXI1_MBD072  * 1766.78 +
DXI1_MBD073  * 7562.71 +
DXI1_MBD074  * 6531.03 +
DXI1_MBD075  * 3205.30 +
DXI1_MBD076  * 6150.07 +
DXI1_MBD077  * 7092.79 +
DXI1_MBD078  * 1560.75 +
DXI1_MBD079  * 628.53 +
DXI1_MBD080  * 4931.94 +
DXI1_MBD081  * 1024.68 +
DXI1_MBD084  * 1174.79 +
DXI1_MBD086  * 281.76 +
DXI1_MBD088  * 5058.81 +
DXI1_MBD089  * 6058.71 +
DXI1_MBD090  * 2019.57 +
DXI1_MBD091  * 5555.12 +
DXI1_MBD092  * 4485.30 +
DXI1_MBD094  * 1803.19 +
DXI1_MBD095  * 2742.18 +
DXI1_MBD096  * 5704.75 +
DXI1_MBD097  * 1936.54 +
DXI1_MBD098  * 345.88 +
DXI1_MBD100  * 6191.78 +
DXI1_MBD101  * 4660.35 +
DXI1_MBD102  * 1818.19 +
DXI1_MBD103  * 2206.90 +
DXI1_MBD104  * 3769.13 +
DXI1_MBD105  * 3951.74 +
DXI1_MBD106  * 6943.77 +
DXI1_MBD107  * 20130.58 +
DXI1_MBD108  * 5406.65 +
DXI1_MBD109  * 7331.79 +
DXI1_MBD110  * 5442.44 +
DXI1_MBD111  * 5022.40 +
DXI1_MBD114  * -241.41 +
DXI1_MBD117  * 648.31 +
DXI1_MBD118  * 1070.98 +
DXI1_MBD119  * 2630.39 +
DXI1_MBD121  * 1623.25 +
DXI1_MBD124  * 1515.45 +
DXI1_MBD125  * 6635.25 +
DXI1_MBD126  * 1575.74 +
DXI1_MBD127  * 476.68 +
DXI1_MBD128  * 5805.52 +
DXI1_MBD129  * 1638.39 +
DXI1_MBD130  * 1523.22 +
DXI1_MBD131  * 19135.73 +
DXI1_MBD133  * -2329.58 +
DXI1_MBD134  * 11717.93 +
DXI1_MBD135  * -3869.44 +
DXI1_MBD137  * 8159.59 +
DXI1_MBD138  * 739.93 +
DXI1_MBD139  * 6587.25 +
DXI1_MBD140  * 8020.40 +
DXI1_MBD141  * 3330.25 +
DXI1_MBD142  * 1332.62 +
DXI1_MBD143  * 2826.79 +
DXI1_MBD144  * 1795.20 +
DXI1_MBD145  * 15247.84 +
DXI1_MBD146  * 1790.35 +
DXI1_MBD148  * 2353.87 +
DXI1_MBD149  * 12978.17 +
DXI1_MBD150  * -2785.90 +
DXI1_MSK001  * 835.44 +
DXI1_MSK002  * 15677.01 +
DXI1_MSK003  * 309.21 +
DXI1_MSK005  * -7793.90 +
DXI1_MSK006  * -1952.86 +
DXI1_MSK007  * 14652.87 +
DXI1_MSK008  * 12576.95 +
DXI1_MSK009  * 19363.27 +
DXI1_MSK010  * 1203.59 +
DXI1_MSK011  * 375.29 +
DXI1_MSK012  * -1710.02 +
DXI1_MSK013  * -4214.80 +
DXI1_MSK014  * 3073.21 +
DXI1_MSK015  * 1244.30 +
DXI1_MSK016  * 1350.02 +
DXI1_MSK017  * 10254.55 +
DXI1_MSK019  * 776.43 +
DXI1_MSK020  * 4044.21 +
DXI1_MSK021  * 7472.66 +
DXI1_MSK022  * 549.49 +
DXI1_MSK023  * -6719.92 +
DXI1_MSK024  * 1477.62 +
DXI1_MSK025  * 6809.07 +
DXI1_MSK026  * 1927.78 +
DXI1_MSK027  * 5257.40 +
DXI1_MSK028  * 2153.90 +
DXI1_MSK031  * 9109.86 +
DXI1_MSK032  * 1371.78 +
DXI1_MSK033  * 3086.28 +
DXI1_MSK034  * 4848.56 +
DXI1_MSK035  * 2840.65 +
DXI1_MSK036  * 6606.30 +
DXI1_MSK037  * 5969.72 +
DXI1_MSK039  * 2529.10 +
DXI1_MSK040  * 3802.78 +
DXI1_MSK041  * 8617.36 +
DXI1_MSK042  * -2111.94 +
DXI1_MSK043  * -1814.55 +
DXI1_MSK044  * 5620.95 +
DXI1_MSK045  * 3086.69 +
DXI1_MSK046  * 2090.52 +
DXI1_MSK047  * 3364.37 +
DXI1_MSK048  * -2676.07 +
DXI1_MSK050  * -1749.38 +
DXI1_MSK051  * -4479.69 +
DXI1_MSK053  * 4167.16 +
DXI1_MSK054  * -2060.22 +
DXI1_MSK055  * -1012.29 +
DXI1_MSK056  * -1169.47 +
DXI1_MSK057  * -1362.23 +
DXI1_MSK058  * -1455.83 +
DXI1_MSK059  * 4650.18 +
DXI1_MSK060  * 1344.55 +
DXI1_MSK061  * 3930.53 +
DXI1_MSK062  * 767.24 +
DXI1_MSK063  * 2322.49 +
DXI1_MSK064  * 1605.16 +
DXI1_MSK065  * 1911.03 +
DXI1_MSK068  * 1915.99 +
DXI1_MSK069  * 3605.92 +
DXI1_MSK070  * 13787.42 +
DXI1_MSK071  * 12581.40 +
DXI1_MSK072  * 6274.54 +
DXI1_MSK073  * 10998.39 +
DXI1_MSK074  * 5266.40 +
DXI1_MSK075  * 1447.55 +
DXI1_MSK076  * -2801.25 +
DXI1_MSK078  * 2486.49 +
DXI1_MSK079  * 261.56 +
DXI1_MSK080  * 384.69 +
DXI1_MSK082  * -1236.39 +
DXI1_MSK083  * 2958.68 +
DXI1_MSK084  * 5211.74 +
DXI1_MSK085  * 2595.00 +
DXI1_MSK086  * 644.79 +
DXI1_MSK088  * 731.33 +
DXI1_MSK089  * 14958.64 +
DXI1_MSK090  * 1814.68 +
DXI1_MSK091  * 962.20 +
DXI1_MSK092  * 2101.26 +
DXI1_MSK093  * 1977.05 +
DXI1_MSK094  * 1026.99 +
DXI1_MSK095  * 1106.72 +
DXI1_MSK097  * 446.28 +
DXI1_MSK098  * 1471.78 +
DXI1_MSK099  * 1461.76 +
DXI1_MSK100  * 1584.06 +
DXI1_MSK101  * 1348.41 +
DXI1_MSK103  * 5276.56 +
DXI1_MSK104  * 3195.71 +
DXI1_MSK105  * 383.45 +
DXI1_MSK106  * 5314.16 +
DXI1_MSK108  * 1204.54 +
DXI1_MSK109  * 2415.55 +
DXI1_MSK110  * 1841.45 +
DXI1_MSK111  * 467.25 +
DXI1_MSK112  * 630.05 +
DXI1_MSK113  * 409.07 +
DXI1_MSK114  * 2065.28 +
DXI1_MSK115  * 463.11 +
DXI1_MSK117  * 4453.47 +
DXI1_MSK118  * 2968.68 +
DXI1_MSK119  * 1362.76 +
DXI1_MSK120  * 3802.83 +
DXI1_MSK121  * 684.13 +
DXI1_MSK122  * 4866.00 +
DXI1_MSK123  * 1183.85 +
DXI1_MSK124  * -2105.94 +
DXI1_MSK125  * 735.67 +
DXI1_MSK126  * 233.31 +
DXI1_MSK127  * 2259.76 +
DXI1_MSK128  * 2735.51 +
DXI1_MSK129  * 1774.23 +
DXI1_MSK130  * 4970.43 +
DXI1_MSK131  * 1142.22 +
DXI1_MSK133  * 2464.20 +
DXI1_MSK134  * 949.98 +
DXI1_MSK135  * 1018.98 +
DXI1_MSK136  * 1176.29 +
DXI1_MSK137  * 1230.45 +
DXI1_MSK138  * 3150.46 +
DXI1_MSK139  * 108.85 +
DXI1_MSK140  * 247.12 +
DXI1_MSK141  * 751.08 +
DXI1_MSK142  * 5951.61 +
DXI1_MSK144  * 1274.71 +
DXI1_MSK145  * 7511.36 +
DXI1_MSK146  * 3266.04 +
DXI1_MSK147  * 3533.51 +
DXI1_MSK148  * 1508.65 +
DXI1_MSK149  * -4489.40 +
DXI1_MSK150  * 1237.65 +
DXI1_MSK151  * 2557.83 +
DXI1_MSK152  * 2438.83 +
DXI1_MSK154  * 948.88 +
DXI1_MSK155  * 678.76 +
DXI1_MSK156  * 2056.42 +
DXI1_MSK158  * 1433.20 +
DXI1_MSK159  * 1095.93 +
DXI1_MSK160  * 1192.37 +
DXI1_MSK161  * 1451.04 +
DXI1_MSK162  * 3496.72 +
DXI1_MSK163  * 1685.98 +
DXI1_MSK164  * 776.04 +
DXI1_MSK165  * 1204.76 +
DXI1_MSK166  * 831.37 +
DXI1_MSK167  * 904.15 +
DXI1_MSK168  * 2267.26 +
DXI1_MSK169  * 5063.97 +
DXI1_MSK170  * 2438.57 +
DXI1_MSK171  * 1740.70 +
DXI1_MSK172  * 5073.55 +
DXI1_MSK173  * 5781.04 +
DXI1_MSK174  * 1739.37 +
DXI1_MSK175  * 1316.61 +
DXI1_MSK176  * 12918.85 +
DXI1_MSK177  * 2525.02 +
DXI1_MSK178  * 859.11 +
DXI1_MSK179  * 14133.47 +
DXI1_MSK180  * 8343.17 +
DXI1_MSK181  * 13446.18 +
DXI1_MSK182  * 3778.64 +
DXI1_MSK183  * 8740.10 +
DXI1_MSK184  * 376.73 +
DXI1_MSK185  * 13624.50 +
DXI1_MSK186  * 9183.25 +
DXI1_MSK187  * 1780.74 +
DXI1_MSK188  * 995.52 +
DXI1_MSK189  * 8707.46 +
DXI1_MSK190  * 11805.06 +
DXI1_MSK191  * -1635.44 +
DXI1_MSK192  * 6938.08 +
DXI1_MSK193  * 1421.86 +
DXI1_MSK194  * 1699.13 +
DXI1_MSK195  * 899.99 +
DXI1_MSK196  * 1911.36 +
DXI1_MSK197  * 976.58 +
DXI1_MSK198  * -295.28 +
DXI1_MSK199  * 4243.77 +
DXI1_MSK200  * 6150.64 +
DXI1_MSK201  * 6543.26 +
DXI1_MSK203  * 5070.05 +
DXI1_MSK204  * 6040.89 +
DXI1_MSK205  * 1749.35 +
DXI1_MSK206  * 9105.03 +
DXI1_NEO001  * 4519.64 +
DXI1_NEO002  * 5376.18 +
DXI1_NEO006  * 4155.05 +
DXI1_NEO007  * 8043.20 +
DXI1_NEO008  * -6870.71 +
DXI1_NEO009  * 7883.75 +
DXI1_NEO010  * 16087.83 +
DXI1_NEO011  * 14034.75 +
DXI1_NEO012  * 2138.39 +
DXI1_NEO014  * 1872.05 +
DXI1_NEO015  * 2100.68 +
DXI1_NEO016  * 12043.78 +
DXI1_NEO017  * -1040.28 +
DXI1_NEO018  * 6807.57 +
DXI1_NEO019  * 10354.69 +
DXI1_NEO020  * 8692.54 +
DXI1_NEO021  * -1476.41 +
DXI1_NEO022  * 1173.81 +
DXI1_NEO023  * 3074.66 +
DXI1_NEO024  * 1118.74 +
DXI1_NEO028  * 1395.34 +
DXI1_NEO032  * 17172.80 +
DXI1_NEO033  * 5305.96 +
DXI1_NEO034  * 3044.67 +
DXI1_NEO035  * 4684.12 +
DXI1_NEO036  * 4243.40 +
DXI1_NEO037  * -10587.8 +
DXI1_NEO038  * 8475.27 +
DXI1_NEO040  * 17678.87 +
DXI1_NEO044  * 3033.35 +
DXI1_NEO046  * 2567.77 +
DXI1_NEO049  * 5553.86 +
DXI1_NEO050  * 7420.65 +
DXI1_NEO051  * 7603.90 +
DXI1_NEO052  * 5046.03 +
DXI1_NEO053  * -3354.61 +
DXI1_NEO055  * 2752.15 +
DXI1_NEO056  * 11173.13 +
DXI1_NEO057  * 10396.91 +
DXI1_NEO058  * 13644.61 +
DXI1_NEO059  * 12961.33 +
DXI1_NEO060  * -1369.51 +
DXI1_NEO061  * 3574.04 +
DXI1_NEO062  * 11020.89 +
DXI1_NEO063  * 12204.54 +
DXI1_NEO064  * 1766.85 +
DXI1_NEO065  * 11935.74 +
DXI1_NEO066  * -5185.19 +
DXI1_NEO067  * 25672.82 +
DXI1_NEO068  * 15797.76 +
DXI1_NEO069  * -4440.75 +
DXI1_NEO070  * 46022.36 +
DXI1_NEO071  * 9560.98 +
DXI1_NEO073  * 33533.92 +
DXI1_NEO075  * 9884.12 +
DXI1_NEO076  * 3558.67 +
DXI1_NEO077  * 1644.98 +
DXI1_NEO078  * 7423.14 +
DXI1_NEO080  * 13650.72 +
DXI1_NEO081  * 735.04 +
DXI1_NEO083  * -1883.05 +
DXI1_NEO084  * 4202.32 +
DXI1_NEO085  * 579.42 +
DXI1_NEO086  * -2314.99 +
DXI1_NEO087  * 5942.34 +
DXI1_NEO088  * 10493.93 +
DXI1_NEO090  * 10015.10 +
DXI1_NEO092  * 2308.08 +
DXI1_NEO093  * -5314.66 +
DXI1_NEO094  * 1047.22 +
DXI1_NEO096  * -1002.61 +
DXI1_NEO097  * 2543.88 +
DXI1_NEO098  * 5128.76 +
DXI1_NEO099  * 5217.55 +
DXI1_NEO100  * 2027.08 +
DXI1_NEO103  * 1830.33 +
DXI1_NEO104  * 3051.39 +
DXI1_NEO105  * 2916.42 +
DXI1_NEO106  * 801.75 +
DXI1_NEO108  * 3516.09 +
DXI1_NEO109  * 2530.27 +
DXI1_NEO110  * -3566.88 +
DXI1_NEO111  * 1669.26 +
DXI1_NEO113  * 961.48 +
DXI1_NEO119  * -7198.85 +
DXI1_NEO120  * 12847.69 +
DXI1_NEO121  * 16702.40 +
DXI1_NEO122  * -5148.63 +
DXI1_NEO123  * 12840.54 +
DXI1_NEO124  * 29410.47 +
DXI1_NEO125  * 23581.16 +
DXI1_NEO126  * -16802.8 +
DXI1_NEO127  * 14092.82 +
DXI1_NEO128  * -16205.1 +
DXI1_NEO130  * 3013.56 +
DXI1_NEO131  * -2104.33 +
DXI1_NEO132  * 5111.68 +
DXI1_NEO133  * 3881.13 +
DXI1_NEO134  * 4176.68 +
DXI1_NEO136  * 5382.03 +
DXI1_NEO138  * 1906.24 +
DXI1_NEO139  * 2289.62 +
DXI1_NEO140  * 24180.23 +
DXI1_NEO142  * 2676.99 +
DXI1_NEO143  * 29329.28 +
DXI1_NEO145  * 3493.00 +
DXI1_NEO147  * 4577.02 +
DXI1_NEO149  * 2136.37 +
DXI1_NEO153  * 5297.25 +
DXI1_NEO156  * 1815.72 +
DXI1_NEO157  * 9024.73 +
DXI1_NEO160  * 820.70 +
DXI1_NEO162  * 1732.61 +
DXI1_NEO163  * 509.09 +
DXI1_NEO166  * 2927.77 +
DXI1_NEO168  * 11299.49 +
DXI1_NEO170  * 2196.25 +
DXI1_NEO172  * 1346.57 +
DXI1_NEO173  * 1992.75 +
DXI1_NEO174  * 969.19 +
DXI1_NEO175  * 2181.33 +
DXI1_NEO176  * 1510.40 +
DXI1_NEO178  * 5348.09 +
DXI1_NEO179  * 1220.68 +
DXI1_NEO181  * 10840.46 +
DXI1_NEO182  * 7105.65 +
DXI1_NEO183  * 3737.78 +
DXI1_NEO185  * 11006.26 +
DXI1_NEO186  * 20595.29 +
DXI1_NEO187  * 19263.93 +
DXI1_NEO188  * 2628.39 +
DXI1_NEO194  * 3231.64 +
DXI1_NEO196  * 2076.37 +
DXI1_NEO197  * 17713.35 +
DXI1_NEO198  * 2011.62 +
DXI1_NEO200  * 5163.62 +
DXI1_NEO202  * 10983.00 +
DXI1_NEO203  * 1847.00 +
DXI1_NEO205  * 998.45 +
DXI1_NEO206  * 1642.44 +
DXI1_NVS001  * 3372.37 +
DXI1_NVS002  * 5532.27 +
DXI1_NVS003  * 4854.23 +
DXI1_NVS004  * 31770.11 +
DXI1_NVS005  * 3288.49 +
DXI1_NVS006  * 34055.96 +
DXI1_NVS007  * 5123.88 +
DXI1_NVS008  * 1209.43 +
DXI1_NVS009  * 4670.20 +
DXI1_NVS010  * -720.49 +
DXI1_NVS011  * 777.03 +
DXI1_NVS012  * 751.07 +
DXI1_NVS013  * 1298.51 +
DXI1_NVS014  * 2981.45 +
DXI1_NVS016  * 356.34 +
DXI1_NVS017  * 225.34 +
DXI1_NVS018  * 12677.01 +
DXI1_NVS019  * 1779.38 +
DXI1_NVS020  * 103.60 +
DXI1_NVS022  * 1792.30 +
DXI1_NVS023  * 220.28 +
DXI1_NVS025  * -728.28 +
DXI1_NVS028  * 6610.09 +
DXI1_NVS030  * 5009.56 +
DXI1_NVS034  * 2663.76 +
DXI1_NVS035  * 1998.91 +
DXI1_NVS037  * 3818.65 +
DXI1_NVS038  * 447.06 +
DXI1_NVS042  * 2566.00 +
DXI1_NVS043  * 27278.71 +
DXI1_NVS044  * 1534.81 +
DXI1_NVS045  * 458.42 +
DXI1_NVS046  * 3821.97 +
DXI1_NVS047  * 1955.70 +
DXI1_NVS048  * 3781.85 +
DXI1_NVS049  * 1537.41 +
DXI1_NVS050  * -763.54 +
DXI1_NVS052  * 3181.67 +
DXI1_NVS053  * 16772.49 +
DXI1_NVS054  * 26379.57 +
DXI1_NVS055  * 1540.11 +
DXI1_NVS056  * 490.87 +
DXI1_NVS057  * 563.64 +
DXI1_NVS058  * 939.47 +
DXI1_NVS059  * 1768.93 +
DXI1_NVS060  * -192.81 +
DXI1_NVS061  * 1290.99 +
DXI1_NVS062  * 1253.39 +
DXI1_NVS063  * 948.27 +
DXI1_NVS064  * 5227.07 +
DXI1_NVS065  * 712.95 +
DXI1_NVS066  * 3864.75 +
DXI1_NVS067  * 5187.93 +
DXI1_NVS068  * 8750.39 +
DXI1_NVS069  * 14963.67 +
DXI1_NVS070  * 5087.25 +
DXI1_NVS071  * 4087.55 +
DXI1_NVS072  * 5749.92 +
DXI1_NVS073  * 6483.25 +
DXI1_NVS074  * 1911.31 +
DXI1_NVS075  * 1305.63 +
DXI1_NVS076  * 2971.01 +
DXI1_NVS077  * 532.02 +
DXI1_NVS078  * -3263.78 +
DXI1_NVS079  * 16809.73 +
DXI1_NVS080  * 4350.73 +
DXI1_NVS081  * 3878.86 +
DXI1_NVS082  * 10972.68 +
DXI1_NVS083  * 2974.45 +
DXI1_NVS084  * 6288.38 +
DXI1_NVS085  * 6085.72 +
DXI1_NVS086  * 4107.00 +
DXI1_NVS087  * 7762.16 +
DXI1_NVS088  * 10214.29 +
DXI1_NVS089  * 5253.46 +
DXI1_NVS090  * 48680.48 +
DXI1_NVS091  * -1547.55 +
DXI1_NVS092  * 7925.36 +
DXI1_NVS093  * 1724.79 +
DXI1_NVS094  * 10322.62 +
DXI1_NVS095  * 22677.11 +
DXI1_NVS096  * 39963.42 +
DXI1_NVS097  * 10136.83 +
DXI1_NVS098  * 10898.58 +
DXI1_NVS100  * 1659.76 +
DXI1_NVS103  * 2571.46 +
DXI1_NVS105  * 4378.64 +
DXI1_NVS106  * 1695.33 +
DXI1_NVS107  * 12137.77 +
DXI1_NVS108  * -2444.82 +
DXI1_NVS110  * 19507.72 +
DXI1_NVS111  * 3045.41 +
DXI1_NVS112  * 6043.73 +
DXI1_NVS113  * 2943.18 +
DXI1_NVS114  * 3609.99 +
DXI1_NVS115  * 9168.62 +
DXI1_NVS116  * 12745.91 +
DXI1_PNL001  * 11278.42 +
DXI1_PNL002  * 3281.10 +
DXI1_PNL003  * -2788.30 +
DXI1_PNL005  * 926.88 +
DXI1_PNL006  * 5433.86 +
DXI1_PNL007  * -780.84 +
DXI1_PNL010  * 1149.46 +
DXI1_PNL011  * 1930.81 +
DXI1_PNL012  * 1290.42 +
DXI1_PNL013  * -586.00 +
DXI1_PNL014  * 7389.46 +
DXI1_PNL015  * 6107.18 +
DXI1_PNL017  * 15988.16 +
DXI1_PNL018  * 8327.77 +
DXI1_PNL019  * 12729.35 +
DXI1_PNL020  * 387.49 +
DXI1_PNL021  * 20617.22 +
DXI1_PNL022  * 5599.75 +
DXI1_PNL023  * 3436.68 +
DXI1_PNL025  * 837.96 +
DXI1_PNL028  * 31498.89 +
DXI1_PNL029  * 5689.28 +
DXI1_PNL030  * 13291.79 +
DXI1_PNL031  * 19719.11 +
DXI1_PNL032  * 17044.20 +
DXI1_PNL033  * 33660.08 +
DXI1_PNL034  * 19783.00 +
DXI1_PNL035  * 8911.20 +
DXI1_PNL036  * 3982.94 +
DXI1_PNL037  * 6798.18 +
DXI1_PNL038  * 3553.88 +
DXI1_PNL040  * 613.36 +
DXI1_PNL043  * 8064.13 +
DXI1_PNL044  * 20824.73 +
DXI1_PNL045  * 379.27 +
DXI1_PNL046  * 1656.80 +
DXI1_PNL047  * 2892.18 +
DXI1_PNL048  * 4431.16 +
DXI1_PNL049  * 4635.31 +
DXI1_PNL050  * 14702.70 +
DXI1_PRG002  * 2141.30 +
DXI1_PRG003  * 2915.97 +
DXI1_PRG004  * 1289.23 +
DXI1_PRG005  * 1636.19 +
DXI1_PRG006  * -639.41 +
DXI1_PRG007  * 751.35 +
DXI1_PRG008  * 2795.45 +
DXI1_PRG011  * 2465.21 +
DXI1_PRG012  * 4033.77 +
DXI1_PRG013  * 1077.27 +
DXI1_PRG014  * 3722.77 +
DXI1_PRG015  * 2337.14 +
DXI1_PRG017  * 8258.35 +
DXI1_PRG018  * 10533.11 +
DXI1_PRG019  * 4842.02 +
DXI1_PRG023  * 2733.54 +
DXI1_PRG025  * -527.07 +
DXI1_PRG027  * 967.46 +
DXI1_PRG028  * 1767.99 +
DXI1_PRG029  * 1474.58 +
DXI1_PRG032  * 814.78 +
DXI1_PRG033  * 15068.93 +
DXI1_PRG034  * -5244.01 +
DXI1_PRG037  * 2231.12 +
DXI1_PRG038  * 976.76 +
DXI1_PRG039  * 3260.84 +
DXI1_PRG043  * 1592.57 +
DXI1_PRG044  * 8674.50 +
DXI1_PRG045  * 2109.24 +
DXI1_PRG046  * 5085.67 +
DXI1_PRG047  * -400.75 +
DXI1_PRG048  * 7251.92 +
DXI1_PRG050  * 2744.83 +
DXI1_PRG051  * 2693.90 +
DXI1_PRG055  * -1352.68 +
DXI1_PRG056  * 7226.92 +
DXI1_PRG058  * 2027.63 +
DXI1_PRG059  * 840.48 +
DXI1_PRG061  * 509.74 +
DXI1_PRG062  * 2011.89 +
DXI1_PRG063  * 650.05 +
DXI1_PRG066  * 1204.10 +
DXI1_PRG067  * 7751.12 +
DXI1_PRG068  * 974.63 +
DXI1_PRG072  * -839.70 +
DXI1_PRG073  * 2382.33 +
DXI1_PRG076  * 832.13 +
DXI1_PRG077  * 534.60 +
DXI1_PRG079  * 1083.47 +
DXI1_PRG080  * -7611.93 +
DXI1_PRG081  * 746.63 +
DXI1_PRG083  * -1054.50 +
DXI1_PRG084  * -401.58 +
DXI1_PRG086  * 19007.68 +
DXI1_PRG087  * 2497.06 +
DXI1_PRG088  * 1238.59 +
DXI1_PRG089  * -3951.96 +
DXI1_PRG091  * 1970.46 +
DXI1_PRG093  * 3888.55 +
DXI1_PRG096  * 2071.49 +
DXI1_PRG097  * 2000.91 +
DXI1_PRG098  * 2641.02 +
DXI1_PRG099  * 1234.40 +
DXI1_PRG100  * 1114.59 +
DXI1_PRG101  * 1788.49 +
DXI1_PRG103  * 2268.85 +
DXI1_PRG104  * 623.44 +
DXI1_PRG105  * 966.42 +
DXI1_PRG106  * 750.52 +
DXI1_PRG107  * 1433.85 +
DXI1_PRG112  * 1194.73 +
DXI1_PRG114  * 3369.53 +
DXI1_PRG116  * 720.15 +
DXI1_PRG117  * 893.07 +
DXI1_PRG118  * 847.65 +
DXI1_PRG120  * 4562.37 +
DXI1_PRG121  * 3211.23 +
DXI1_PRG122  * 9999.64 +
DXI1_PRG123  * 7727.87 +
DXI1_PRG124  * 7905.41 +
DXI1_PRG125  * 8302.94 +
DXI1_PRG126  * 2767.98 +
DXI1_PRG127  * 16572.25 +
DXI1_PRG128  * 826.55 +
DXI1_PRG129  * 910.57 +
DXI1_PRG130  * -2092.75 +
DXI1_PRG132  * 1849.24 +
DXI1_PRG133  * 1266.63 +
DXI1_PRG135  * 1569.36 +
DXI1_PRG138  * 2284.12 +
DXI1_PRG139  * 600.93 +
DXI1_PRG140  * 612.99 +
DXI1_PRG143  * 2388.37 +
DXI1_PRG144  * 1907.74 +
DXI1_PRG148  * 395.47 +
DXI1_PRG149  * 1940.66 +
DXI1_PRG150  * 1735.83 +
DXI1_PRG151  * -3774.67 +
DXI1_PRG152  * 2385.02 +
DXI1_PRG153  * 791.19 +
DXI1_RSP001  * 15408.61 +
DXI1_RSP002  * 1334.72 +
DXI1_RSP003  * 24627.42 +
DXI1_RSP004  * 3183.74 +
DXI1_RSP005  * 2003.80 +
DXI1_RSP006  * -9553.66 +
DXI1_RSP007  * 2763.98 +
DXI1_RSP008  * 3366.96 +
DXI1_RSP009  * -1409.31 +
DXI1_RSP011  * 6259.53 +
DXI1_RSP012  * 670.87 +
DXI1_RSP014  * 7188.51 +
DXI1_RSP015  * 10900.76 +
DXI1_RSP016  * 135.07 +
DXI1_RSP017  * -2108.21 +
DXI1_RSP018  * 8291.47 +
DXI1_RSP019  * 1766.96 +
DXI1_RSP020  * 5234.90 +
DXI1_RSP023  * 803.33 +
DXI1_RSP024  * 2126.57 +
DXI1_RSP025  * 3871.42 +
DXI1_RSP026  * 4309.69 +
DXI1_RSP027  * 7387.11 +
DXI1_RSP028  * 8866.00 +
DXI1_RSP029  * 8793.09 +
DXI1_RSP030  * 2814.75 +
DXI1_RSP031  * -115.13 +
DXI1_RSP032  * 368.29 +
DXI1_RSP033  * 901.16 +
DXI1_RSP034  * 742.55 +
DXI1_RSP035  * 1047.94 +
DXI1_RSP036  * -140.00 +
DXI1_RSP037  * 153.48 +
DXI1_RSP038  * 1765.47 +
DXI1_RSP040  * 4472.90 +
DXI1_RSP041  * 1807.33 +
DXI1_RSP042  * 1395.89 +
DXI1_RSP043  * 5366.83 +
DXI1_RSP044  * 2338.01 +
DXI1_RSP045  * 4906.73 +
DXI1_RSP046  * 195.76 +
DXI1_RSP047  * 1214.05 +
DXI1_RSP048  * 1092.94 +
DXI1_RSP049  * 1379.37 +
DXI1_RSP050  * 1414.49 +
DXI1_RSP051  * 7714.95 +
DXI1_RSP052  * -14923.1 +
DXI1_RSP053  * 1328.16 +
DXI1_RSP054  * 14294.14 +
DXI1_RSP055  * 2789.07 +
DXI1_RSP056  * -14238.4 +
DXI1_RSP057  * 5162.59 +
DXI1_RSP058  * 2611.14 +
DXI1_RSP059  * 8391.06 +
DXI1_RSP060  * -2661.79 +
DXI1_RSP061  * -3902.66 +
DXI1_RSP062  * -4666.12 +
DXI1_RSP063  * 7458.69 +
DXI1_SKN001  * 181.11 +
DXI1_SKN002  * 2084.51 +
DXI1_SKN003  * 494.31 +
DXI1_SKN004  * -128.13 +
DXI1_SKN005  * 440.37 +
DXI1_SKN007  * 495.52 +
DXI1_SKN008  * 3976.40 +
DXI1_SKN010  * 141.22 +
DXI1_SKN011  * 704.78 +
DXI1_SKN012  * 1089.70 +
DXI1_SKN013  * 7351.53 +
DXI1_SKN016  * 634.11 +
DXI1_SKN017  * 331.26 +
DXI1_SKN018  * 374.66 +
DXI1_SKN019  * -847.41 +
DXI1_SKN022  * -385.94 +
DXI1_SKN023  * -309.26 +
DXI1_SKN025  * 4405.56 +
DXI1_SKN026  * 343.34 +
DXI1_SKN029  * 270.39 +
DXI1_SKN031  * 3526.22 +
DXI1_SKN034  * -221.73 +
DXI1_SKN036  * 2817.17 +
DXI1_SKN037  * 6300.13 +
DXI1_SKN040  * -268.91 +
DXI1_SKN041  * -155.75 +
DXI1_SKN043  * 14450.55 +
DXI1_SKN044  * 7103.59 +
DXI1_SKN045  * 11838.27 +
DXI1_SKN047  * -221.34 +
DXI1_SKN050  * 760.98 +
DXI1_SKN051  * 1431.92 +
DXI1_SKN054  * 3217.13 +
DXI1_SKN055  * 1588.09 +
DXI1_SKN056  * 1448.65 +
DXI1_SKN058  * 968.45 +
DXI1_SKN059  * 958.21 +
DXI1_SKN061  * 3584.51 +
DXI1_SKN067  * 795.22 +
DXI1_SKN071  * 734.34 +
DXI1_SKN073  * 182.53 +
DXI1_SKN075  * 113.77 +
DXI1_SKN078  * 181.96 +
DXI1_SKN079  * 470.16 +
DXI1_SKN080  * 915.32 +
DXI1_SKN082  * 210.02 +
DXI1_SKN083  * -437.13 +
DXI1_SKN084  * 3082.27 +
DXI1_SKN085  * -1609.91 +
DXI1_SKN086  * 1727.59 +
DXI1_SKN089  * -798.97 +
DXI1_SKN092  * 4834.97 +
DXI1_SKN093  * -828.41 +
DXI1_SKN094  * 7806.77 +
DXI1_SKN095  * 1620.38 +
DXI1_SKN096  * 3194.05 +
DXI1_SKN097  * -1212.56 +
DXI1_SKN099  * 151.74 +
DXI1_SKN100  * 1136.20 +
DXI1_SYM001  * -1181.60 +
DXI1_SYM002  * 2846.44 +
DXI1_SYM003  * 275.97 +
DXI1_SYM004  * 559.30 +
DXI1_SYM005  * 1561.51 +
DXI1_SYM006  * 3573.82 +
DXI1_SYM008  * 2457.39 +
DXI1_SYM009  * -999.15 +
DXI1_SYM011  * 403.56 +
DXI1_SYM012  * 1095.49 +
DXI1_SYM013  * 4283.80 +
DXI1_SYM014  * -1752.98 +
DXI1_SYM015  * 886.40 +
DXI1_SYM017  * 600.00 +
DXI1_SYM018  * 622.98 +
DXI1_SYM019  * 3512.31 +
DXI1_SYM021  * 1252.12 +
DXI1_SYM022  * 1152.13 +
DXI1_SYM025  * 1041.70 +
DXI1_SYM026  * 627.01 +
DXI1_SYM027  * 789.01 +
DXI1_SYM028  * -1090.40 +
DXI1_SYM029  * -301.60 +
DXI1_SYM030  * 272.01 +
DXI1_SYM031  * 829.10 +
DXI1_SYM032  * 312.22 +
DXI1_SYM034  * 12626.99 +
DXI1_SYM035  * 3482.59 +
DXI1_SYM036  * 636.67 +
DXI1_SYM037  * -51.98 +
DXI1_SYM038  * 875.08 +
DXI1_SYM039  * 2036.38 +
DXI1_SYM040  * 5983.15 +
DXI1_SYM041  * 862.46 +
DXI1_SYM042  * 373.88 +
DXI1_SYM043  * 613.02 +
DXI1_SYM044  * 2852.71 +
DXI1_SYM045  * 708.07 +
DXI1_SYM046  * 3069.80 +
DXI1_SYM048  * 448.56 +
DXI1_SYM049  * 2002.18 +
DXI1_SYM050  * 1178.52 +
DXI1_SYM051  * 5422.68 +
DXI1_SYM053  * 593.84 +
DXI1_SYM055  * 192.39 +
DXI1_SYM057  * 204.50 +
DXI1_SYM058  * 1034.60 +
DXI1_SYM059  * 1306.04 +
DXI1_SYM060  * 2911.74 +
DXI1_SYM062  * 715.06 +
DXI1_SYM063  * -401.25 +
DXI1_SYM066  * -403.19 +
DXI1_SYM067  * -497.24 +
DXI1_SYM068  * 895.97 +
DXI1_SYM069  * 3655.15 +
DXI1_SYM073  * 747.85 +
DXI1_SYM077  * 751.18 +
DXI1_SYM078  * 1022.75 +
DXI1_SYM079  * 493.82 +
DXI1_SYM080  * 476.88 +
DXI1_SYM083  * 3566.37 +
DXI1_SYM085  * 165.23 +
DXI1_SYM086  * -113.47 +
DXI1_SYM087  * -136.56 +
DXI1_SYM088  * 2070.03 +
DXI1_SYM089  * 4250.97 +
DXI1_SYM090  * 695.25 +
DXI1_SYM091  * 328.96 +
DXI1_SYM092  * -14107.4 +
DXI1_SYM093  * 10433.13 +
DXI1_SYM094  * -2112.18 +
DXI1_SYM095  * 3955.36 +
DXI1_SYM096  * -4028.10 +
DXI1_SYM097  * 891.44 +
DXI1_SYM098  * 2771.26 +
DXI1_SYM099  * 8005.65 +
DXI1_SYM101  * 3276.37 +
DXI1_SYM102  * 8467.22 +
DXI1_SYM103  * 2646.99 +
DXI1_SYM104  * 3371.64 +
DXI1_SYM105  * 3798.65 +
DXI1_SYM107  * 4412.14 +
DXI1_SYM108  * 2861.46 +
DXI1_SYM109  * 4862.32 +
DXI1_SYM110  * 2344.44 +
DXI1_SYM112  * 435.30 +
DXI1_SYM113  * 1118.28 +
DXI1_SYM114  * -2088.14 +
DXI1_SYM115  * 4192.11 +
DXI1_SYM116  * 14178.98 +
DXI1_SYM117  * 7649.83 +
DXI1_SYM119  * -3511.79 +
DXI1_SYM120  * 3152.23 +
DXI1_SYM121  * -670.82 +
DXI1_SYM122  * 520.04 +
DXI1_SYM124  * 2842.34 +
DXI1_SYM125  * 3664.65 +
DXI1_SYM126  * 1372.90 +
DXI1_SYM127  * 5179.56 +
DXI1_SYM128  * 776.27 +
DXI1_SYM129  * 1813.16 +
DXI1_SYM131  * 5723.83 +
DXI1_SYM133  * 1197.52 +
DXI1_SYM134  * 5566.69 +
DXI1_SYM136  * 5861.66 +
DXI1_SYM137  * 15679.88 +
DXI1_SYM138  * 40691.13 +
DXI1_SYM139  * 1801.21 +
DXI1_SYM140  * 987.07 +
DXI1_SYM141  * 475.22 +
DXI1_SYM143  * 2568.79 +
DXI1_SYM144  * 1862.31 +
DXI1_SYM145  * -4156.77 +
DXI1_SYM146  * 1080.43 +
DXI1_SYM149  * 3448.98 +
DXI1_SYM150  * 1604.76 +
DXI1_SYM151  * 4149.38 +
DXI1_SYM153  * -189.63 +
DXI1_SYM154  * 1110.75 +
DXI1_SYM155  * 363.81 +
DXI1_SYM156  * 1221.13 +
DXI1_SYM158  * 2098.09 +
DXI1_SYM159  * -82.30 +
DXI1_SYM160  * -184.84 +
DXI1_SYM162  * 8784.20 +
DXI1_SYM163  * -232.05 +
DXI1_SYM164  * 2378.70 +
DXI1_SYM165  * 712.78 +
DXI1_SYM167  * -612.78 +
DXI1_SYM168  * 5551.94 +
DXI1_SYM169  * 345.05 +
DXI1_SYM170  * 793.70 +
DXI1_SYM172  * 263.61 ;

label P_AnnTotalSpend_250K = 'SW Predicted Annualized Total Spending topcoded at $250k Development sample 2016-18';
%Mend; * mend of macro Model1_P_AnnTotalSpend_250K;

*for convenience %model1 can also be used to call this macro; 
%macro Model1;
   %Model1_P_AnnTotalSpend_250K;
%mend; *mend of macro Model1;

