/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kraskov;

import infodynamics.measures.continuous.kraskov.ConditionalMutualInfoCalculatorMultiVariateKraskov;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.NeighbourNodeData;
import java.util.Calendar;
import java.util.PriorityQueue;

public class ConditionalMutualInfoCalculatorMultiVariateKraskov2
extends ConditionalMutualInfoCalculatorMultiVariateKraskov {
    @Override
    protected double[] partialComputeFromObservations(int n, int n2, boolean bl) throws Exception {
        double d = Calendar.getInstance().getTimeInMillis();
        double[] dArray = null;
        if (bl) {
            dArray = new double[n2];
        }
        double d2 = this.dimensionsCond > 0 ? 2.0 / (double)this.k : 1.0 / (double)this.k;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        boolean[] blArray = new boolean[this.totalObservations];
        int[] nArray = new int[this.totalObservations + 1];
        for (int i = n; i < n + n2; ++i) {
            double d9;
            double d10;
            int n3;
            int n4;
            PriorityQueue<NeighbourNodeData> priorityQueue = this.kdTreeJoint.findKNearestNeighbours(this.k, i, this.dynCorrExclTime);
            double d11 = 0.0;
            double d12 = 0.0;
            double d13 = 0.0;
            for (n4 = 0; n4 < this.k; ++n4) {
                NeighbourNodeData neighbourNodeData = priorityQueue.poll();
                if (neighbourNodeData.norms[0] > d11) {
                    d11 = neighbourNodeData.norms[0];
                }
                if (neighbourNodeData.norms[1] > d12) {
                    d12 = neighbourNodeData.norms[1];
                }
                if (!(neighbourNodeData.norms[2] > d13)) continue;
                d13 = neighbourNodeData.norms[2];
            }
            if (this.dimensionsCond > 0) {
                this.nnSearcherConditional.findPointsWithinR(i, d13, this.dynCorrExclTime, true, blArray, nArray);
            }
            n4 = this.dimensionsCond == 0 ? (this.dimensionsVar1 > 1 ? this.kdTreeVar1Conditional.countPointsWithinOrOnR(i, d11, this.dynCorrExclTime) : this.uniNNSearcherVar1.countPointsWithinOrOnR(i, d11, this.dynCorrExclTime)) : (this.dimensionsVar1 > 1 ? this.kdTreeVar1Conditional.countPointsWithinRs(i, new double[]{d11, d13}, true, 1, blArray) : this.uniNNSearcherVar1.countPointsWithinR(i, d11, true, blArray));
            int n5 = this.dimensionsCond == 0 ? (this.dimensionsVar2 > 1 ? this.kdTreeVar2Conditional.countPointsWithinOrOnR(i, d12, this.dynCorrExclTime) : this.uniNNSearcherVar2.countPointsWithinOrOnR(i, d12, this.dynCorrExclTime)) : (this.dimensionsVar2 > 1 ? this.kdTreeVar2Conditional.countPointsWithinRs(i, new double[]{d12, d13}, true, 1, blArray) : this.uniNNSearcherVar2.countPointsWithinR(i, d12, true, blArray));
            if (this.dimensionsCond == 0) {
                n3 = this.totalObservations;
            } else {
                n3 = 0;
                while (nArray[n3] != -1) {
                    blArray[nArray[n3]] = false;
                    ++n3;
                }
            }
            d4 += (double)n4;
            d5 += (double)n5;
            d6 += (double)n3;
            double d14 = MathsUtils.digamma(n4);
            double d15 = MathsUtils.digamma(n5);
            double d16 = MathsUtils.digamma(n3);
            if (this.dimensionsCond > 0) {
                d10 = 1.0 / (double)n4;
                d9 = 1.0 / (double)n5;
            } else {
                d10 = 0.0;
                d9 = 0.0;
            }
            d8 += d10;
            d7 += d9;
            double d17 = d16 - d14 - d15;
            d3 += d17;
            if (!bl) continue;
            dArray[i - n] = this.digammaK - d2 + d17 + d10 + d9;
            if (!this.debug) continue;
            System.out.printf("t=%d, n_xz=%d, n_yz=%d, n_z=%d, 1/n_yz=%.3f, 1/n_xz=%.3f, local=%.4f\n", i, n4, n5, n3, d9, d10, dArray[i - n]);
        }
        if (this.debug) {
            Calendar calendar = Calendar.getInstance();
            long l = calendar.getTimeInMillis();
            System.out.println("Subset " + n + ":" + (n + n2) + " Calculation time: " + ((double)l - d) / 1000.0 + " sec");
        }
        if (bl) {
            return dArray;
        }
        double[] dArray2 = new double[]{d3, d4, d5, d6, d8, d7};
        return dArray2;
    }

    @Override
    protected double[] partialComputeFromNewObservations(int n, int n2, double[][] dArray, double[][] dArray2, double[][] dArray3, boolean bl) throws Exception {
        throw new RuntimeException("Not implemented yet");
    }
}

