/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kraskov;

import infodynamics.measures.continuous.kraskov.MutualInfoCalculatorMultiVariateKraskov;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.NeighbourNodeData;
import java.util.Calendar;
import java.util.PriorityQueue;

public class MutualInfoCalculatorMultiVariateKraskov1
extends MutualInfoCalculatorMultiVariateKraskov {
    public MutualInfoCalculatorMultiVariateKraskov1() {
        this.isAlgorithm1 = true;
    }

    @Override
    protected double[] partialComputeFromObservations(int n, int n2, boolean bl) throws Exception {
        double d = Calendar.getInstance().getTimeInMillis();
        double[] dArray = null;
        if (bl) {
            dArray = new double[n2];
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = n; i < n + n2; ++i) {
            PriorityQueue<NeighbourNodeData> priorityQueue = this.kdTreeJoint.findKNearestNeighbours(this.k, i, this.dynCorrExclTime);
            NeighbourNodeData neighbourNodeData = priorityQueue.poll();
            int n3 = this.nnSearcherSource.countPointsStrictlyWithinR(i, neighbourNodeData.distance, this.dynCorrExclTime);
            int n4 = this.nnSearcherDest.countPointsStrictlyWithinR(i, neighbourNodeData.distance, this.dynCorrExclTime);
            d3 += (double)n3;
            d4 += (double)n4;
            double d5 = MathsUtils.digamma(n3 + 1);
            double d6 = MathsUtils.digamma(n4 + 1);
            d2 += d5 + d6;
            if (!bl) continue;
            dArray[i - n] = this.digammaK - d5 - d6 + this.digammaN;
        }
        if (this.debug) {
            Calendar calendar = Calendar.getInstance();
            long l = calendar.getTimeInMillis();
            System.out.println("Subset " + n + ":" + (n + n2) + " Calculation time: " + ((double)l - d) / 1000.0 + " sec");
        }
        if (bl) {
            return dArray;
        }
        return new double[]{d2, d3, d4};
    }

    public int[][] partialNeighbourCountFromObservations(int n, int n2) throws Exception {
        double d = Calendar.getInstance().getTimeInMillis();
        this.ensureKdTreesConstructed();
        int[][] nArray = new int[n2][2];
        for (int i = n; i < n + n2; ++i) {
            PriorityQueue<NeighbourNodeData> priorityQueue = this.kdTreeJoint.findKNearestNeighbours(this.k, i, this.dynCorrExclTime);
            NeighbourNodeData neighbourNodeData = priorityQueue.poll();
            int n3 = this.nnSearcherSource.countPointsStrictlyWithinR(i, neighbourNodeData.distance, this.dynCorrExclTime);
            int n4 = this.nnSearcherDest.countPointsStrictlyWithinR(i, neighbourNodeData.distance, this.dynCorrExclTime);
            nArray[i - n][0] = n3;
            nArray[i - n][1] = n4;
        }
        if (this.debug) {
            Calendar calendar = Calendar.getInstance();
            long l = calendar.getTimeInMillis();
            System.out.println("Subset " + n + ":" + (n + n2) + " Calculation time: " + ((double)l - d) / 1000.0 + " sec");
        }
        return nArray;
    }
}

