/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kraskov;

import infodynamics.measures.continuous.ConditionalMutualInfoCalculatorMultiVariate;
import infodynamics.measures.continuous.TransferEntropyCalculatorViaCondMutualInfo;
import infodynamics.measures.continuous.kraskov.ActiveInfoStorageCalculatorKraskov;
import infodynamics.measures.continuous.kraskov.ConditionalMutualInfoCalculatorMultiVariateKraskov1;
import infodynamics.measures.continuous.kraskov.ConditionalMutualInfoCalculatorMultiVariateKraskov2;
import java.util.Hashtable;

public class TransferEntropyCalculatorKraskov
extends TransferEntropyCalculatorViaCondMutualInfo {
    public static final String COND_MI_CALCULATOR_KRASKOV1 = ConditionalMutualInfoCalculatorMultiVariateKraskov1.class.getName();
    public static final String COND_MI_CALCULATOR_KRASKOV2 = ConditionalMutualInfoCalculatorMultiVariateKraskov2.class.getName();
    public static final String PROP_KRASKOV_ALG_NUM = "ALG_NUM";
    protected int kraskovAlgorithmNumber = 1;
    protected boolean algChanged = false;
    protected Hashtable<String, String> props;
    public static final String PROP_AUTO_EMBED_METHOD = "AUTO_EMBED_METHOD";
    public static final String AUTO_EMBED_METHOD_NONE = "NONE";
    public static final String AUTO_EMBED_METHOD_RAGWITZ = "RAGWITZ";
    public static final String AUTO_EMBED_METHOD_RAGWITZ_DEST_ONLY = "RAGWITZ_DEST_ONLY";
    public static final String AUTO_EMBED_METHOD_MAX_CORR_AIS = "MAX_CORR_AIS";
    public static final String AUTO_EMBED_METHOD_MAX_CORR_AIS_DEST_ONLY = "MAX_CORR_AIS_DEST_ONLY";
    protected String autoEmbeddingMethod = "NONE";
    public static final String PROP_K_SEARCH_MAX = "AUTO_EMBED_K_SEARCH_MAX";
    protected int k_search_max = 1;
    public static final String PROP_TAU_SEARCH_MAX = "AUTO_EMBED_TAU_SEARCH_MAX";
    protected int tau_search_max = 1;
    public static final String PROP_RAGWITZ_NUM_NNS = "AUTO_EMBED_RAGWITZ_NUM_NNS";
    protected int ragwitz_num_nns = 1;
    protected boolean ragwitz_num_nns_set = false;

    public TransferEntropyCalculatorKraskov() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        super(COND_MI_CALCULATOR_KRASKOV1);
        this.kraskovAlgorithmNumber = 1;
        this.props = new Hashtable();
    }

    public TransferEntropyCalculatorKraskov(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        super(string);
        if (string.equalsIgnoreCase(COND_MI_CALCULATOR_KRASKOV1)) {
            this.kraskovAlgorithmNumber = 1;
        } else if (string.equalsIgnoreCase(COND_MI_CALCULATOR_KRASKOV2)) {
            this.kraskovAlgorithmNumber = 2;
        } else {
            throw new ClassNotFoundException("Must be an underlying Kraskov-Grassberger conditional MI calculator");
        }
        this.props = new Hashtable();
    }

    @Override
    public void initialise(int n, int n2, int n3, int n4, int n5) throws Exception {
        if (this.algChanged) {
            String string = COND_MI_CALCULATOR_KRASKOV1;
            if (this.kraskovAlgorithmNumber == 2) {
                string = COND_MI_CALCULATOR_KRASKOV2;
            }
            Class<?> clazz = Class.forName(string);
            ConditionalMutualInfoCalculatorMultiVariate conditionalMutualInfoCalculatorMultiVariate = (ConditionalMutualInfoCalculatorMultiVariate)clazz.newInstance();
            this.construct(conditionalMutualInfoCalculatorMultiVariate);
            for (String string2 : this.props.keySet()) {
                conditionalMutualInfoCalculatorMultiVariate.setProperty(string2, this.props.get(string2));
            }
            this.algChanged = false;
        }
        super.initialise(n, n2, n3, n4, n5);
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        if (string.equalsIgnoreCase(PROP_KRASKOV_ALG_NUM)) {
            int n = this.kraskovAlgorithmNumber;
            this.kraskovAlgorithmNumber = Integer.parseInt(string2);
            if (this.kraskovAlgorithmNumber != 1 && this.kraskovAlgorithmNumber != 2) {
                throw new Exception("Kraskov algorithm number (" + this.kraskovAlgorithmNumber + ") must be either 1 or 2");
            }
            if (this.kraskovAlgorithmNumber != n) {
                this.algChanged = true;
            }
            if (this.debug) {
                System.out.println(this.getClass().getSimpleName() + ": Set property " + string + " to " + string2);
            }
        } else if (string.equalsIgnoreCase(PROP_AUTO_EMBED_METHOD)) {
            this.autoEmbeddingMethod = string2;
        } else if (string.equalsIgnoreCase(PROP_K_SEARCH_MAX)) {
            this.k_search_max = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase(PROP_TAU_SEARCH_MAX)) {
            this.tau_search_max = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase(PROP_RAGWITZ_NUM_NNS)) {
            this.ragwitz_num_nns = Integer.parseInt(string2);
            this.ragwitz_num_nns_set = true;
        } else {
            super.setProperty(string, string2);
            this.props.put(string, string2);
        }
    }

    @Override
    public String getProperty(String string) throws Exception {
        if (string.equalsIgnoreCase(PROP_KRASKOV_ALG_NUM)) {
            return Integer.toString(this.kraskovAlgorithmNumber);
        }
        if (string.equalsIgnoreCase(PROP_AUTO_EMBED_METHOD)) {
            return this.autoEmbeddingMethod;
        }
        if (string.equalsIgnoreCase(PROP_K_SEARCH_MAX)) {
            return Integer.toString(this.k_search_max);
        }
        if (string.equalsIgnoreCase(PROP_TAU_SEARCH_MAX)) {
            return Integer.toString(this.tau_search_max);
        }
        if (string.equalsIgnoreCase(PROP_RAGWITZ_NUM_NNS)) {
            if (this.ragwitz_num_nns_set) {
                return Integer.toString(this.ragwitz_num_nns);
            }
            return this.condMiCalc.getProperty("k");
        }
        return super.getProperty(string);
    }

    @Override
    public void preFinaliseAddObservations() throws Exception {
        if (this.autoEmbeddingMethod.equalsIgnoreCase(AUTO_EMBED_METHOD_NONE)) {
            return;
        }
        if (this.autoEmbeddingMethod.equalsIgnoreCase(AUTO_EMBED_METHOD_RAGWITZ) || this.autoEmbeddingMethod.equalsIgnoreCase(AUTO_EMBED_METHOD_RAGWITZ_DEST_ONLY) || this.autoEmbeddingMethod.equalsIgnoreCase(AUTO_EMBED_METHOD_MAX_CORR_AIS) || this.autoEmbeddingMethod.equalsIgnoreCase(AUTO_EMBED_METHOD_MAX_CORR_AIS_DEST_ONLY)) {
            ActiveInfoStorageCalculatorKraskov activeInfoStorageCalculatorKraskov = new ActiveInfoStorageCalculatorKraskov();
            for (String object2 : this.props.keySet()) {
                activeInfoStorageCalculatorKraskov.setProperty(object2, this.props.get(object2));
            }
            if (this.autoEmbeddingMethod.equalsIgnoreCase(AUTO_EMBED_METHOD_RAGWITZ) || this.autoEmbeddingMethod.equalsIgnoreCase(AUTO_EMBED_METHOD_RAGWITZ_DEST_ONLY)) {
                activeInfoStorageCalculatorKraskov.setProperty(PROP_AUTO_EMBED_METHOD, AUTO_EMBED_METHOD_RAGWITZ);
                activeInfoStorageCalculatorKraskov.setProperty(PROP_RAGWITZ_NUM_NNS, this.getProperty(PROP_RAGWITZ_NUM_NNS));
            } else {
                activeInfoStorageCalculatorKraskov.setProperty(PROP_AUTO_EMBED_METHOD, AUTO_EMBED_METHOD_MAX_CORR_AIS);
            }
            activeInfoStorageCalculatorKraskov.setProperty(PROP_K_SEARCH_MAX, Integer.toString(this.k_search_max));
            activeInfoStorageCalculatorKraskov.setProperty(PROP_TAU_SEARCH_MAX, Integer.toString(this.tau_search_max));
            if (this.debug) {
                System.out.println("Starting embedding of destination:");
            }
            activeInfoStorageCalculatorKraskov.initialise();
            activeInfoStorageCalculatorKraskov.startAddObservations();
            for (double[] dArray : this.vectorOfDestinationTimeSeries) {
                activeInfoStorageCalculatorKraskov.addObservations(dArray);
            }
            activeInfoStorageCalculatorKraskov.finaliseAddObservations();
            this.k = Integer.parseInt(activeInfoStorageCalculatorKraskov.getProperty("k_HISTORY"));
            this.k_tau = Integer.parseInt(activeInfoStorageCalculatorKraskov.getProperty("TAU"));
            if (this.debug) {
                System.out.printf("Embedding parameters for destination set to k=%d,k_tau=%d\n", this.k, this.k_tau);
            }
            if (this.autoEmbeddingMethod.equalsIgnoreCase(AUTO_EMBED_METHOD_RAGWITZ) || this.autoEmbeddingMethod.equalsIgnoreCase(AUTO_EMBED_METHOD_MAX_CORR_AIS)) {
                if (this.debug) {
                    System.out.println("Starting embedding of source:");
                }
                activeInfoStorageCalculatorKraskov.initialise();
                activeInfoStorageCalculatorKraskov.startAddObservations();
                for (double[] dArray : this.vectorOfSourceTimeSeries) {
                    activeInfoStorageCalculatorKraskov.addObservations(dArray);
                }
                activeInfoStorageCalculatorKraskov.finaliseAddObservations();
                this.l = Integer.parseInt(activeInfoStorageCalculatorKraskov.getProperty("k_HISTORY"));
                this.l_tau = Integer.parseInt(activeInfoStorageCalculatorKraskov.getProperty("TAU"));
                if (this.debug) {
                    System.out.printf("Embedding parameters for source set to l=%d,l_tau=%d\n", this.l, this.l_tau);
                }
            }
            this.setStartTimeForFirstDestEmbedding();
        }
    }
}

