/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils;

import infodynamics.utils.AnalyticMeasurementDistribution;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.commonsmath3.distribution.ChiSquaredDistribution;

public class ChiSquareMeasurementDistribution
extends AnalyticMeasurementDistribution {
    protected int degreesOfFreedom;
    protected int numObservations;
    protected ChiSquaredDistribution chi2dist;

    public ChiSquareMeasurementDistribution(double d, int n, int n2) {
        super(d, 1.0 - MathsUtils.chiSquareCdf(2.0 * (double)n * d, n2));
        this.numObservations = n;
        this.degreesOfFreedom = n2;
        this.chi2dist = new ChiSquaredDistribution(n2);
    }

    @Override
    public double computePValueForGivenEstimate(double d) {
        return 1.0 - MathsUtils.chiSquareCdf(2.0 * (double)this.numObservations * d, this.degreesOfFreedom);
    }

    @Override
    public double computeEstimateForGivenPValue(double d) {
        return this.chi2dist.inverseCumulativeProbability(1.0 - d) / (2.0 * (double)this.numObservations);
    }
}

