/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils.commonsmath3.distribution;

import infodynamics.utils.commonsmath3.distribution.AbstractIntegerDistribution;
import infodynamics.utils.commonsmath3.exception.NumberIsTooLargeException;
import infodynamics.utils.commonsmath3.exception.util.Localizable;
import infodynamics.utils.commonsmath3.exception.util.LocalizedFormats;
import infodynamics.utils.commonsmath3.random.RandomGenerator;
import infodynamics.utils.commonsmath3.random.Well19937c;

public class UniformIntegerDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 20120109L;
    private final int lower;
    private final int upper;

    public UniformIntegerDistribution(int n, int n2) throws NumberIsTooLargeException {
        this(new Well19937c(), n, n2);
    }

    public UniformIntegerDistribution(RandomGenerator randomGenerator, int n, int n2) throws NumberIsTooLargeException {
        super(randomGenerator);
        if (n > n2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)n, n2, true);
        }
        this.lower = n;
        this.upper = n2;
    }

    @Override
    public double probability(int n) {
        if (n < this.lower || n > this.upper) {
            return 0.0;
        }
        return 1.0 / (double)(this.upper - this.lower + 1);
    }

    @Override
    public double cumulativeProbability(int n) {
        if (n < this.lower) {
            return 0.0;
        }
        if (n > this.upper) {
            return 1.0;
        }
        return ((double)(n - this.lower) + 1.0) / ((double)(this.upper - this.lower) + 1.0);
    }

    @Override
    public double getNumericalMean() {
        return 0.5 * (double)(this.lower + this.upper);
    }

    @Override
    public double getNumericalVariance() {
        double d = this.upper - this.lower + 1;
        return (d * d - 1.0) / 12.0;
    }

    @Override
    public int getSupportLowerBound() {
        return this.lower;
    }

    @Override
    public int getSupportUpperBound() {
        return this.upper;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public int sample() {
        int n = this.upper - this.lower + 1;
        if (n <= 0) {
            int n2;
            while ((n2 = this.random.nextInt()) < this.lower || n2 > this.upper) {
            }
            return n2;
        }
        return this.lower + this.random.nextInt(n);
    }
}

