from typing import (
    FrozenSet,
    ItemsView,
    Iterable,
    Iterator,
    KeysView,
    Mapping,
    TypeVar,
    ValuesView,
)

T = TypeVar("T")
KT = TypeVar("KT")
VT = TypeVar("VT")

class HashTrieMap(Mapping[KT, VT]):
    def __init__(
        self,
        value: Mapping[KT, VT] | Iterable[tuple[KT, VT]] = {},
        **kwds: Mapping[KT, VT],
    ): ...
    def __getitem__(self, key: KT) -> VT: ...
    def __iter__(self) -> Iterator[KT]: ...
    def __len__(self) -> int: ...
    def discard(self, key: KT) -> "HashTrieMap[KT, VT]": ...
    def items(self) -> ItemsView[KT, VT]: ...
    def keys(self) -> KeysView[KT]: ...
    def values(self) -> ValuesView[VT]: ...
    def remove(self, key: KT) -> "HashTrieMap[KT, VT]": ...
    def insert(self, key: KT, val: VT) -> "HashTrieMap[KT, VT]": ...
    def update(self, *args: Mapping): ...

class HashTrieSet(FrozenSet[T]):
    def __init__(self, value: Iterable[T] = ()): ...
    def __iter__(self) -> Iterator[T]: ...
    def __len__(self) -> int: ...
    def discard(self, value: T) -> "HashTrieSet[T]": ...
    def remove(self, value: T) -> "HashTrieSet[T]": ...
    def insert(self, value: T) -> "HashTrieSet[T]": ...
    def update(self, *args: Iterable[T]) -> "HashTrieSet[T]": ...

class List(Iterable[T]):
    def __init__(self, value: Iterable[T] = (), *more: T): ...
    def __iter__(self) -> Iterator[T]: ...
    def __len__(self) -> int: ...
    def push_front(self, value: T) -> "List[T]": ...
