from enum import Enum


class Airport(Enum):
    """Airport codes for most airports in the world.

    This is auto-generated from data/airports.csv.
    """

    AAA = "Anaa"
    AAB = "Arrabury Airport"
    AAC = "El Arish International Airport"
    AAD = "Adado"
    AAE = "Les Salines Airport"
    AAF = "Apalachicola Regional"
    AAG = "Arapoti"
    AAH = "Aachen/Merzbruck"
    AAI = "Arraias"
    AAJ = "Cayana Airstrip"
    AAK = "Aranuka"
    AAL = "Aalborg Airport"
    AAM = "Mala Mala"
    AAN = "Al Ain Airport"
    AAO = "Anaco"
    AAP = "Andrau Airpark"
    AAQ = "Anapa Airport"
    AAR = "Aarhus Airport"
    AAS = "Apalapsili"
    AAT = "Altay Airport"
    AAU = "Asau"
    AAV = "Allah Valley"
    AAW = "Abbottabad"
    AAX = "Araxa Airport"
    AAY = "Al Ghaydah"
    AAZ = "Quetzaltenango"
    ABA = "Abakan Airport"
    ABB = "Asaba International Airport"
    ABC = "Los Llanos"
    ABD = "Abadan Airport"
    ABE = "Lehigh Valley International Airport"
    ABF = "Abaiang"
    ABG = "Abingdon"
    ABH = "Alpha"
    ABI = "Abilene Regional Airport"
    ABJ = "Felix Houphouet Boigny Airport"
    ABK = "Kabri Dar"
    ABL = "Ambler Airport"
    ABM = "Northern Peninsula Airport"
    ABN = "Albina"
    ABO = "Aboisso"
    ABP = "Atkamba"
    ABQ = "Albuquerque International Sunport"
    ABR = "Aberdeen Municipal Airport"
    ABS = "Abu Simbel"
    ABT = "Al-Aqiq Airport"
    ABU = "Haliwen Airport"
    ABV = "Nnamdi Azikiwe International Airport"
    ABW = "Abau"
    ABX = "Albury Airport"
    ABY = "Southwest Georgia Regional Airport"
    ABZ = "Aberdeen International Airport"
    ACA = "Acapulco International Airport"
    ACB = "Antrim County"
    ACC = "Kotoka International Airport"
    ACD = "Acandi"
    ACE = "Lanzarote Airport"
    ACF = "Alaer Talimu Airport"
    ACH = "Altenrhein Airport"
    ACI = "Alderney Airport"
    ACJ = "Anuradhapura"
    ACK = "Nantucket Memorial Airport"
    ACL = "Aguaclara"
    ACM = "Arica"
    ACN = "International"
    ACP = "Sahand"
    ACR = "Araracuara"
    ACS = "Achinsk"
    ACT = "Waco Municipal Airport"
    ACU = "Achutupo"
    ACV = "Arcata-Eureka Airport"
    ACX = "Xingyi Airport"
    ACY = "Atlantic City International Airport"
    ACZ = "Zabol Airport"
    ADA = "Adana Airport"
    ADB = "Izmir Adnan Menderes Airport"
    ADC = "Andakombe"
    ADD = "Addis Ababa Bole International Airport"
    ADE = "International"
    ADF = "Adiyaman Airport"
    ADG = "Lenawee County"
    ADH = "Aldan"
    ADI = "Arandis"
    ADJ = "Marka International Airport"
    ADK = "Adak Island Ns"
    ADL = "Adelaide Airport"
    ADM = "Ardmore Municipal Airport"
    ADN = "Andes"
    ADO = "Andamooka"
    ADP = "Ampara"
    ADQ = "Kodiak Benny Benson State Airport"
    ADR = "Andrews"
    ADS = "Addison Airport"
    ADT = "Ada Municipal"
    ADU = "Ardabil Airport"
    ADV = "El Daein"
    ADW = "Andrews AFB"
    ADX = "Leuchars"
    ADY = "Alldays"
    ADZ = "Gustavo Rojas Pinilla Airport"
    AEA = "Abemama Atoll"
    AEB = "Youjiang"
    AED = "Aleneva"
    AEE = "Adareil Airport"
    AEG = "Aek Godang"
    AEH = "Abéché"
    AEI = "Algeciras"
    AEK = "Aseki"
    AEL = "Albert Lea"
    AEM = "Amgu"
    AEO = "Aioun El Atrouss"
    AEP = "Jorge Newbery Airport"
    AEQ = "Ar Horqin Airport"
    AER = "Sochi International Airport"
    AES = "Vigra Alesund Airport"
    AET = "Allakaket"
    AEU = "Abu Musa"
    AEX = "Alexandria International Airport"
    AEY = "Akureyri Airport"
    AFA = "San Rafael Airport"
    AFD = "Port Alfred"
    AFF = "USAF Academy Airstrip"
    AFI = "Amalfi"
    AFK = "Ampara Kondavattavan Tank Airport"
    AFL = "Alta Floresta Airport"
    AFN = "Municipal"
    AFO = "Municipal"
    AFR = "Afore"
    AFS = "Zarafshan"
    AFT = "Afutara Aerodrome"
    AFW = "Fort Worth Alliance Airport"
    AFY = "Afyon"
    AFZ = "Sabzevar"
    AGA = "Agadir Al Massira Airport"
    AGB = "Augsburg Airport"
    AGC = "Allegheny County Airport"
    AGD = "Anggi"
    AGE = "Flugplatz"
    AGF = "La Garenne Airport"
    AGG = "Angoram"
    AGH = "Angelholm Helsingborg Airport"
    AGI = "Wageningen"
    AGJ = "Aguni"
    AGK = "Kagua"
    AGL = "Wanigela"
    AGM = "Tasiilaq"
    AGN = "Angoon"
    AGO = "Municipal"
    AGP = "Malaga Airport"
    AGQ = "Agrinion"
    AGR = "Kheria"
    AGS = "Augusta Regional Airport"
    AGT = "Alejo Garcia Airport"
    AGU = "Aguascalients International Airport"
    AGV = "Acarigua"
    AGW = "Agnew"
    AGX = "Agatti Island Airport"
    AGZ = "Aggeneys"
    AHA = "Naha AFB"
    AHB = "Abha Regional Airport"
    AHC = "Amedee AAF"
    AHD = "Downtown"
    AHE = "Ahe Airport"
    AHF = "Municipal"
    AHH = "Municipal"
    AHI = "Amahai"
    AHJ = "Hongyuan Airport"
    AHL = "Aishalton"
    AHM = "Sumner Parker Field"
    AHN = "Athens-Ben Epps"
    AHO = "Alghero-Fertilia Airport"
    AHS = "Ahuas"
    AHT = "Amchitka"
    AHU = "Charif Al Idrissi Airport"
    AHW = "Saih Rawl"
    AHY = "Ambatolahy"
    AHZ = "Alpe D Huez"
    AIA = "Alliance Airport"
    AIC = "Airok"
    AID = "Municipal"
    AIE = "Aiome"
    AIF = "Assis"
    AIG = "Yalinga"
    AIH = "Aiambak"
    AII = "Alisabieh"
    AIK = "Municipal"
    AIL = "Ailigandi"
    AIM = "Ailuk Island"
    AIN = "Wainwright"
    AIO = "Municipal"
    AIP = "Ailinglapalap Island"
    AIR = "Aripuana"
    AIS = "Arorae Island"
    AIT = "Aitutaki Airport"
    AIU = "Atiu Island"
    AIV = "George Downer"
    AIW = "Ai-ais"
    AIY = "Bader Field"
    AIZ = "Lee C Fine Memorial"
    AJA = "Ajaccio Napoleon Bonaparte Airport"
    AJF = "Jouf Airport"
    AJI = "Agri Airport"
    AJJ = "Akjoujt"
    AJK = "Araak"
    AJL = "Aizawl Airport"
    AJN = "Ouani"
    AJR = "Arvidsjaur Airport"
    AJS = "Abreojos"
    AJU = "Aracaju Airport"
    AJY = "Agades"
    AKA = "Ankang"
    AKB = "Atka"
    AKC = "Fulton International"
    AKD = "Akola"
    AKE = "Akieni"
    AKF = "Kufrah"
    AKG = "Anguganak"
    AKH = "Prince Sultan Air Base"
    AKI = "Akiak"
    AKJ = "Asahikawa Airport"
    AKK = "Akhiok SPB"
    AKL = "Auckland Airport"
    AKM = "Zakouma"
    AKN = "King Salmon Airport"
    AKO = "Colorado Plains Regional Airport"
    AKP = "Anaktuvuk"
    AKQ = "Gunung Batin"
    AKR = "Akure"
    AKS = "Gwaunaru'u"
    AKT = "Raf Akrotiri"
    AKU = "Aksu Airport"
    AKV = "Akulivik"
    AKW = "Aghajari"
    AKX = "Aktyubinsk Airport"
    AKY = "Civil Airport"
    ALA = "Almaty Airport"
    ALB = "Albany International Airport"
    ALC = "Alicante-Elche Airport"
    ALD = "Alerta"
    ALE = "Alpine"
    ALF = "Alta Airport"
    ALG = "Houari Boumediene Airport"
    ALH = "Albany Airport"
    ALI = "International"
    ALJ = "Alexander Bay Airport"
    ALK = "Asela"
    ALL = "Albenga"
    ALM = "Municipal"
    ALN = "Alton"
    ALO = "Waterloo Airport"
    ALP = "Nejrab"
    ALQ = "Federal"
    ALR = "Alexandra"
    ALS = "Alamosa Municipal Airport"
    ALT = "Alenquer"
    ALU = "Alula"
    ALW = "Walla Walla Airport"
    ALX = "Thomas C Russell Field"
    ALY = "El Nohza"
    ALZ = "Alitak SPB"
    AMA = "Rick Husband Amarillo International Airport"
    AMB = "Ambilobe"
    AMC = "Am Timan"
    AMD = "Ahmedabad Airport"
    AME = "Alto Molocue"
    AMF = "Ama"
    AMG = "Amboin"
    AMH = "Arba Mintch Airport"
    AMI = "Selaparang"
    AMJ = "Almenara"
    AMK = "Animas Airpark"
    AML = "Puerto Armuellas"
    AMM = "Queen Alia International Airport"
    AMN = "Gratiot Community"
    AMO = "Mao"
    AMP = "Ampanihy"
    AMQ = "Pattimura Airport"
    AMR = "Arno"
    AMS = "Amsterdam Airport Schiphol"
    AMT = "Amata"
    AMU = "Amanab"
    AMV = "Amderma"
    AMW = "Ames"
    AMX = "Ammaroo"
    AMY = "Ambatomainty"
    AMZ = "Ardmore"
    ANA = "John Wayne International"
    ANB = "Anniston Metropolitan"
    ANC = "Ted Stevens Anchorage International Airport"
    AND = "Anderson"
    ANE = "Angers-Marce Airport"
    ANF = "Cerro Moreno International Airport"
    ANG = "Brie-Champniers"
    ANH = "Anuha Island Resort"
    ANI = "Aniak Airport"
    ANJ = "Zanaga"
    ANK = "Etimesgut"
    ANL = "Andulo"
    ANM = "Antsirabato"
    ANN = "Annette Island"
    ANO = "Angoche"
    ANP = "Lee"
    ANQ = "Tri-State Steuben County"
    ANR = "Antwerp International Airport"
    ANS = "Andahuaylas"
    ANT = "St Anton"
    ANU = "V.C. Bird International Airport"
    ANV = "Anvik Airport"
    ANW = "Ainsworth"
    ANX = "Andenes Airport"
    ANY = "Anthony"
    ANZ = "Angus Downs"
    AOA = "Aroa"
    AOB = "Annanberg"
    AOC = "Altenburg Nobitz"
    AOD = "Abou Deia"
    AOE = "Anadolu University"
    AOG = "Anshan Teng'ao Airport"
    AOH = "Allen County"
    AOI = "Ancona Falconara Airport"
    AOJ = "Aomori Airport"
    AOK = "Karpathos Airport"
    AOL = "Paso De Los Libres"
    AOM = "Adam Airport"
    AON = "Arona"
    AOO = "Altoona Airport"
    AOP = "Alferez FAP Alfredo Vladimir Sara Bauer Airport"
    AOR = "Sultan Abdul Halim Airport"
    AOS = "Amook"
    AOT = "Corrado Gex"
    AOU = "Attopeu"
    APA = "Centennial Airport"
    APB = "Apolo"
    APC = "Napa County"
    APE = "San Juan Aposento"
    APF = "Naples Municipal Airport"
    APG = "Phillips AAF"
    APH = "Camp A P Hill"
    API = "Apiay"
    APK = "Apataki"
    APL = "Nampula Airport"
    APN = "Alpena County Regional Airport"
    APO = "Apartado Airport"
    APP = "Asapa"
    APQ = "Arapiraca"
    APR = "April River"
    APS = "Anapolis"
    APT = "Marion County"
    APU = "Apucarana"
    APV = "Apple Valley"
    APW = "Faleolo Airport"
    APX = "Arapongas"
    APY = "Alto Parnaiba"
    APZ = "Zapala"
    AQA = "Araraquara"
    AQB = "Quiche Airport"
    AQG = "Anqing Tianzhushan Airport"
    AQI = "Qaisumah Airport"
    AQJ = "King Hussein International Airport"
    AQM = "Ariquemes"
    AQP = "Rodriguez Ballon International Airport"
    AQS = "Saqani"
    AQY = "Alyeska"
    ARA = "Acadiana Regional"
    ARB = "Municipal"
    ARC = "Arctic Village"
    ARD = "Alor Island Airport"
    ARE = "Arecibo"
    ARF = "Acaricuara"
    ARG = "Walnut Ridge"
    ARH = "Talagi Airport"
    ARI = "Chacalluta Airport"
    ARJ = "Arso"
    ARK = "Arusha Airport"
    ARL = "Arly"
    ARM = "Armidale Airport"
    ARN = "Stockholm Arlanda Airport"
    ARO = "Arboletas"
    ARP = "Aragip"
    ARQ = "Arauquita"
    ARR = "Alto Rio Senguerr"
    ARS = "Aragarcas"
    ART = "Watertown Airport"
    ARU = "Aracatuba Airport"
    ARV = "Noble F. Lee"
    ARW = "Arad"
    ARX = "Asbury Park"
    ARY = "Ararat"
    ARZ = "N'zeto"
    ASA = "Assab International"
    ASB = "Ashgabat Airport"
    ASC = "Ascension"
    ASD = "Andros Town"
    ASE = "Aspen Airport"
    ASF = "Astrakhan Airport"
    ASG = "Ashburton"
    ASH = "Boire Field"
    ASI = "Saint Helena Airport"
    ASJ = "Amami Airport"
    ASK = "Yamoussoukro"
    ASL = "Harrison County"
    ASM = "Asmara International Airport"
    ASN = "Talladega"
    ASO = "Asosa Airport"
    ASP = "Alice Springs Airport"
    ASQ = "Austin"
    ASR = "Kayseri Airport"
    ASS = "Arathusa Safari Lodge"
    AST = "Astoria"
    ASU = "Silvio Pettirossi International Airport"
    ASV = "Amboseli"
    ASW = "Aswan Airport"
    ASX = "Ashland"
    ASY = "Ashley"
    ASZ = "Asirim"
    ATA = "Anta"
    ATB = "Atbara"
    ATC = "Arthur's Town"
    ATD = "Atoifi"
    ATE = "Antlers"
    ATF = "Chachoan"
    ATG = "Attock"
    ATH = "Eleftherios Venizelos International Airport"
    ATI = "Artigas"
    ATJ = "Antsirabe"
    ATK = "Atqasuk Edward Burnell Sr. Memorial Airport"
    ATL = "Hartsfield-Jackson Atlanta International Airport"
    ATM = "Altamira Airport"
    ATN = "Namatanai"
    ATO = "Ohio University"
    ATP = "Airstrip"
    ATQ = "Sri Guru Ram Dass Jee International Airport"
    ATR = "Mouakchott"
    ATS = "Artesia"
    ATT = "Atmautluak Airport"
    ATU = "Casco Cove"
    ATV = "Ati"
    ATW = "Outagamie County Regional Airport"
    ATX = "Atbasar"
    ATY = "Watertown Airport"
    ATZ = "Assiut Airport"
    AUA = "Reina Beatrix International Airport"
    AUB = "Itauba Airport"
    AUC = "Arauca Airport"
    AUD = "Augustus Downs"
    AUE = "Abu Rudeis"
    AUF = "Auxerre Branches"
    AUG = "Augusta Airport"
    AUH = "Abu Dhabi International Airport"
    AUI = "Aua Island"
    AUJ = "Ambunti"
    AUK = "Alakanuk Airport"
    AUL = "Aur Island"
    AUM = "Austin"
    AUN = "Auburn"
    AUO = "Auburn-Opelika"
    AUP = "Agaun"
    AUQ = "Hiva Oa Airport"
    AUR = "Aurillac Airport"
    AUS = "Austin-Bergstrom International Airport"
    AUT = "Atauro"
    AUU = "Aurukun Mission"
    AUV = "Aumo"
    AUW = "Municipal"
    AUX = "Araguaina Airport"
    AUY = "Aneityum"
    AUZ = "Municipal Airport"
    AVA = "An Shun/Huang Guo Shu Airport"
    AVB = "Aviano"
    AVG = "Auvergne"
    AVI = "Maximo Gomez"
    AVK = "Arvaikheer"
    AVL = "Asheville Regional Airport"
    AVN = "Avignon-Caumont Airport"
    AVO = "Municipal"
    AVP = "Wilkes-Barre/Scranton International Airport"
    AVR = "Alverca"
    AVU = "Avu Avu"
    AVV = "Avalon Airport"
    AVW = "Avra Valley"
    AVX = "Avalon Bay"
    AWA = "Awassa"
    AWB = "Awaba Airport"
    AWD = "Aniwa"
    AWE = "Alowe"
    AWK = "Wake Island"
    AWM = "Municipal"
    AWN = "Alton Downs"
    AWP = "Austral Downs Airport"
    AWR = "Awar"
    AWZ = "Ahwaz Airport"
    AXA = "Clayton J. Lloyd International Airport"
    AXB = "Alexandria Bay"
    AXC = "Aramac"
    AXD = "Demokritos Airport"
    AXE = "Xanxere"
    AXF = "Alxa Left Banner"
    AXG = "Algona"
    AXJ = "Amakusa"
    AXK = "Ataq"
    AXL = "Alexandria"
    AXM = "El Eden Airport"
    AXN = "Alexandria"
    AXO = "Bandar Udara Pantar"
    AXP = "Springpoint Airport"
    AXR = "Arutua Airport"
    AXS = "Municipal"
    AXT = "Akita Airport"
    AXU = "Axum Airport"
    AXV = "Neil Armstrong"
    AXX = "Angel Fire"
    AYA = "Ayapel"
    AYC = "Ayacucho"
    AYD = "Alroy Downs"
    AYE = "AAF Heliport"
    AYG = "Yaguara"
    AYI = "Yari"
    AYK = "Arkalyk"
    AYL = "Anthony Lagoon"
    AYM = "Yas Island SPB"
    AYN = "Anyang Airport"
    AYO = "Ayolas"
    AYP = "Yanamilla Airport"
    AYQ = "Connellan Airport"
    AYR = "Ayr"
    AYS = "Ware County"
    AYT = "Antalya Airport"
    AYU = "Aiyura"
    AYW = "Ayawasi"
    AYX = "Gerardo Pérez Pinedo"
    AYY = "Arugam Bay SPB"
    AYZ = "Zahns"
    AZA = "Phoenix-Mesa Gateway Airport"
    AZB = "Amazon Bay"
    AZD = "Yazd Airport"
    AZG = "Apatzingan"
    AZI = "Bateen"
    AZJ = "Zhenjiang Dalu"
    AZL = "Fazenda Tucunare Airport"
    AZN = "Andizhan Airport"
    AZO = "Kalamazoo Battle Creek International Airport"
    AZP = "Atizapan"
    AZR = "Adrar Airport"
    AZS = "Samaná El Catey International"
    AZT = "Zapatoca"
    AZZ = "Ambriz"
    BAA = "Bialla"
    BAB = "Beale AFB"
    BAC = "Barranca De Upia"
    BAD = "Barksdale AFB"
    BAE = "Barcelonnette"
    BAF = "Barnes"
    BAG = "Loakan"
    BAH = "Bahrain International Airport"
    BAI = "Buenos Aires"
    BAJ = "Bali"
    BAL = "Batman Airport"
    BAM = "Lander County"
    BAN = "Basongo"
    BAO = "Udorn"
    BAP = "Baibara"
    BAQ = "E Cortissoz Airport"
    BAR = "Baker AAF"
    BAS = "Balalae"
    BAT = "Airport Chafei Amsei"
    BAU = "Bauru Airport"
    BAV = "Baotou Airport"
    BAW = "Biawonque"
    BAX = "Barnaul Gherman Titov International Airport"
    BAY = "Baia Mare"
    BAZ = "Barbelos"
    BBA = "Teniente Vidal Airport"
    BBB = "Benson Municipal Airport"
    BBC = "Bay City"
    BBD = "Curtis Field"
    BBF = "Burlington"
    BBG = "Butaritari"
    BBH = "Barth"
    BBI = "Biju Patnaik International Airport"
    BBJ = "Bitburg Air Base"
    BBK = "Kasane Airport"
    BBL = "Ballera Airport"
    BBM = "Battambang"
    BBN = "Bario Airport"
    BBO = "Berbera"
    BBP = "Bembridge"
    BBQ = "Barbuda"
    BBR = "Baillif"
    BBS = "Blackbushe"
    BBT = "Berberati"
    BBU = "Baneasa"
    BBV = "Hkg"
    BBW = "Broken Bow"
    BBX = "Wings Field"
    BBY = "Bambari"
    BBZ = "Zambezi"
    BCA = "Baracoa"
    BCB = "Virginia Tech"
    BCC = "Bear Creek"
    BCD = "Bacolod-Silay International Airport"
    BCE = "Bryce"
    BCF = "Bouca"
    BCG = "Bemichi"
    BCH = "Cakung International"
    BCI = "Barcaldine Airport"
    BCJ = "Baca Grande"
    BCK = "Bolwarra"
    BCL = "Barra Colorado"
    BCM = "Bacau Airport"
    BCN = "Barcelona-El Prat Airport"
    BCO = "Jinka"
    BCP = "Bambu"
    BCQ = "Brack"
    BCR = "Boca Do Acre"
    BCS = "Southern Seaplane"
    BCT = "Public"
    BCU = "Bauchi"
    BCV = "Belmopan"
    BCW = "Benguera Island"
    BCX = "Beloreck"
    BCY = "Bulchi"
    BCZ = "Bickerton Island"
    BDA = "L.F. Wade International Airport"
    BDB = "Bundaberg Airport"
    BDC = "Barra Do Corda"
    BDD = "Badu Island"
    BDE = "Baudette"
    BDF = "Rinkenberger"
    BDG = "Blanding"
    BDH = "Bandar Lengeh"
    BDI = "Bird Island"
    BDJ = "Syamsudin Noor International Airport"
    BDK = "Bondoukou"
    BDL = "Bradley International Airport"
    BDM = "Bandirma"
    BDN = "Talhar"
    BDO = "Husein Sastranegara Airport"
    BDP = "Bhadrapur Airport"
    BDQ = "Vadodara Airport"
    BDR = "Igor I. Sikorsky Memorial"
    BDS = "Brindisi - Salento Airport"
    BDT = "Gbadolite"
    BDU = "Bardufoss Airport"
    BDV = "Moba"
    BDW = "Bedford Downs"
    BDX = "Broadus"
    BDY = "State"
    BDZ = "Baindoung"
    BEA = "Bereina"
    BEB = "Benbecula Airport"
    BEC = "Beech"
    BED = "Hanscom Field"
    BEE = "Beagle Bay"
    BEF = "Bluefields"
    BEG = "Belgrad Nikola Tesla Airport"
    BEH = "Ross Field"
    BEI = "Beica"
    BEJ = "Kalimarau Airport"
    BEK = "Bareli"
    BEL = "Val De Cans International Airport"
    BEM = "Beni Mellal Airport"
    BEN = "Benina International"
    BEO = "Belmont"
    BEP = "Bellary"
    BEQ = "Honington"
    BER = "Berlin Brandenburg Airport"
    BES = "Brest Bretagne Airport"
    BET = "Bethel Airport"
    BEU = "Bedourie"
    BEV = "Beer Sheba"
    BEW = "Beira Airport"
    BEX = "Benson RAF Station"
    BEY = "Beirut-Rafic Hariri International Airport"
    BEZ = "Beru"
    BFA = "Bahia Negra"
    BFB = "Blue Fox Bay"
    BFC = "Bloomfield"
    BFD = "Bradford Airport"
    BFE = "Bielefeld"
    BFF = "Western Nebraska Regional Airport"
    BFG = "Bullfrog Basin"
    BFH = "Bacacheri"
    BFI = "Boeing Field International Airport"
    BFJ = "Bijie Airport"
    BFK = "Buffalo Municipal Airport"
    BFL = "Meadows Field Airport"
    BFM = "Mobile Downtown Airport"
    BFN = "Bram Fischer International Airport"
    BFO = "Buffalo Range"
    BFP = "Beaver Falls"
    BFQ = "Bahia Pinas"
    BFR = "Virgil I Grissom Municipalcipal"
    BFS = "Belfast International Airport"
    BFT = "County"
    BFU = "Bengbu"
    BFV = "Buri Ram Airport"
    BFW = "Sidi Belabbes"
    BFX = "Bafoussam"
    BGA = "Palonegro International Airport"
    BGB = "Booue"
    BGC = "Braganca Airport"
    BGD = "Borger"
    BGE = "Decatur County"
    BGF = "Bangui Airport"
    BGG = "Bingol Airport"
    BGH = "Abbaye"
    BGI = "Grantley Adams International Airport"
    BGJ = "Borgarfjordur Eystri"
    BGK = "Big Creek"
    BGL = "Baglung"
    BGM = "Greater Binghamton Airport"
    BGN = "Belaya Gora Airport"
    BGO = "Bergen Airport"
    BGP = "Bongo"
    BGQ = "Big Lake"
    BGR = "Bangor International Airport"
    BGS = "Webb AFB"
    BGT = "Bagdad"
    BGU = "Bangassou"
    BGV = "Bento Goncalves"
    BGW = "Baghdad International Airport"
    BGX = "Airport Cmdt. Gustavo Kraemer"
    BGY = "Orio al Serio International Airport"
    BGZ = "Braga"
    BHA = "Bahia De Caraquez"
    BHB = "Bar Harbor Airport"
    BHC = "Bhurban Heliport"
    BHD = "George Best Belfast City Airport"
    BHE = "Woodbourne Airport"
    BHF = "Bahia Cupica"
    BHG = "Brus Laguna"
    BHH = "Bisha Airport"
    BHI = "Comandante Airport"
    BHJ = "Rudra Mata Airport"
    BHK = "Bukhara Airport"
    BHL = "Bahia Angeles"
    BHM = "Birmingham-Shuttlesworth International Airport"
    BHN = "Beihan"
    BHO = "Raja Bhoj Airport"
    BHP = "Bhojpur"
    BHQ = "Broken Hill Airport"
    BHR = "Bharatpur Airport"
    BHS = "Raglan Airport"
    BHT = "Brighton Downs"
    BHU = "Bhavnagar Airport"
    BHV = "Bahawalpur Airport"
    BHW = "Bhagatanwala Airport"
    BHX = "Birmingham International Airport"
    BHY = "Beihai Fucheng Airport"
    BIA = "Bastia Poretta Airport"
    BIB = "Baidoa"
    BIC = "Aérodrome de Belle Île"
    BID = "Block Island"
    BIE = "Beatrice"
    BIF = "Biggs AAF"
    BIG = "Intermediate Field"
    BIH = "Bishop"
    BII = "Enyu Airfield"
    BIJ = "Biliau"
    BIK = "Mokmer Airport"
    BIL = "Billings Logan International Airport"
    BIM = "Bimini International Airport"
    BIN = "Bamiyan"
    BIO = "Bilbao Airport"
    BIP = "Bulimba"
    BIQ = "Biarritz - Anglet - Bayonne Airport"
    BIR = "Biratnagar Airport"
    BIS = "Bismarck Airport"
    BIT = "Baitadi"
    BIU = "Bildudalur"
    BIV = "Bria"
    BIW = "Billiluna"
    BIX = "Keesler AFB"
    BIY = "Bisho"
    BIZ = "Bimin"
    BJA = "Bejaia Airport"
    BJB = "Bojnord"
    BJC = "Jeffco"
    BJD = "Bakkafjordur"
    BJE = "Baleela"
    BJF = "Batsfjord Airport"
    BJG = "Bolaang"
    BJH = "Bajhang"
    BJI = "Bemidji Airport"
    BJJ = "Wayne County"
    BJK = "Benjina"
    BJL = "Yundum International Airport"
    BJM = "Bujumbura International Airport"
    BJN = "Bajone"
    BJO = "Bermejo"
    BJP = "Braganca Paulista"
    BJQ = "Bahja Airport"
    BJR = "Bahar Dar Airport"
    BJT = "Bentota River"
    BJU = "Bajura Airport"
    BJV = "Milas-Bodrum Airport"
    BJW = "Bajawa Soa Airport"
    BJX = "Guanajuato International Airport"
    BJY = "Batajnica"
    BJZ = "Badajoz Airport"
    BKA = "Bykovo"
    BKB = "Bikaner"
    BKC = "Buckland Airport"
    BKD = "Stephens County"
    BKE = "Baker"
    BKF = "Lake Brooks SPB"
    BKG = "Branson"
    BKH = "Barking Sands PMRF"
    BKI = "Kota Kinabalu International Airport"
    BKJ = "Boke"
    BKK = "Suvarnabhumi Airport"
    BKL = "Burke Lakefront Airport"
    BKM = "Bakalalan"
    BKN = "Balkanabat Airport"
    BKO = "Bamako-Senou International Airport"
    BKP = "Barkly Downs"
    BKQ = "Blackall Airport"
    BKR = "Bokoro"
    BKS = "Fatmawati Soekarno Airport"
    BKT = "Blackstone AAF"
    BKU = "Betioky"
    BKV = "Bailing Airport"
    BKW = "Beckley Airport"
    BKX = "Brookings"
    BKY = "Kavumu"
    BKZ = "Bukoba Airport"
    BLA = "General Jose Antonio Anzoategui International Airport"
    BLB = "Panama Pacifico Airport"
    BLC = "Bamenda"
    BLD = "Boulder City"
    BLE = "Dala Airport"
    BLF = "Princeton"
    BLG = "Belaga"
    BLH = "Blythe"
    BLI = "Bellingham International Airport"
    BLJ = "Batna Airport"
    BLK = "Blackpool Airport"
    BLL = "Billund Airport"
    BLM = "Monmouth Executive Airport"
    BLN = "Benalla"
    BLO = "Blonduos"
    BLP = "Bellavista"
    BLQ = "Guglielmo Marconi Airport"
    BLR = "Kempegowda International Airport"
    BLS = "Bollon"
    BLT = "Blackwater"
    BLU = "Blue Canyon"
    BLV = "Belleville"
    BLW = "Bellows Field"
    BLX = "Belluno"
    BLY = "Belmullet"
    BLZ = "Chileka Airport"
    BMA = "Bromma Airport"
    BMB = "Bumba"
    BMC = "Brigham City"
    BMD = "Belo"
    BME = "Broome Airport"
    BMF = "Bakouma"
    BMG = "Bloomington"
    BMH = "Bomai"
    BMI = "Central Illinois Regional Airport"
    BMJ = "Baramita"
    BMK = "Borkum"
    BML = "Berlin Municipal Airport"
    BMM = "Bitam"
    BMN = "Bamerny"
    BMO = "Bhamo"
    BMP = "Brampton Island"
    BMQ = "Bamburi"
    BMR = "Baltrum"
    BMS = "Brumado"
    BMT = "Beaumont Municipalcipal"
    BMU = "Sultan Muhammad Salahuddin Airport"
    BMV = "Phung-Duc Airport"
    BMW = "Bordj Badji Mokhtar"
    BMX = "Big Mountain"
    BMY = "Belep Island"
    BMZ = "Bamu"
    BNA = "Nashville International Airport"
    BNB = "Boende"
    BNC = "Beni"
    BND = "Bandar Abbas International Airport"
    BNE = "Brisbane Airport"
    BNF = "Warm Spring Bay SPB"
    BNG = "Banning"
    BNH = "Barnes"
    BNI = "Benin City Airport"
    BNK = "Ballina Byron Airport"
    BNL = "Barnwell Regional"
    BNM = "Bodinumu"
    BNN = "Bronnoysund Airport Bronnoy"
    BNO = "Burns"
    BNP = "Bannu"
    BNQ = "Baganga"
    BNR = "Banfora"
    BNS = "Barinas"
    BNT = "Bundi"
    BNU = "Blumenau"
    BNV = "Boana"
    BNW = "Boone"
    BNX = "Banja Luka Airport"
    BNY = "Bellona"
    BNZ = "Banz"
    BOA = "Boma"
    BOB = "Motu Mute Airport"
    BOC = "Bocas Del Toro"
    BOD = "Bordeaux Airport"
    BOE = "Boundji"
    BOF = "Bolling AFB"
    BOG = "El Dorado International Airport"
    BOH = "Bournemouth Airport"
    BOI = "Boise Air Terminal (Gowen Field)"
    BOJ = "Bourgas Airport"
    BOK = "Brookings State"
    BOL = "Ballykelly"
    BOM = "Chhatrapati Shivaji International Airport"
    BON = "Flamingo International Airport"
    BOO = "Bodo Airport"
    BOP = "Bouar"
    BOQ = "Boku"
    BOS = "Logan International Airport"
    BOT = "Boset"
    BOU = "Bourges"
    BOV = "Boang"
    BOW = "Bartow"
    BOX = "Borroloola"
    BOY = "Borgo"
    BOZ = "Bozoum"
    BPA = "Grumman"
    BPB = "Boridi"
    BPC = "Bamenda"
    BPD = "Bapi"
    BPE = "Qinhuangdao Beidaihe Airport"
    BPF = "Batuna Aerodrome"
    BPG = "Barra Do Garcas"
    BPH = "Bislig"
    BPI = "Big Piney-marbleton"
    BPK = "Biangabip"
    BPL = "Bole Airport"
    BPM = "Begumpet"
    BPN = "Sultan Aji Muhamad Sulaiman Airport"
    BPS = "Porto Seguro Airport"
    BPT = "Jefferson County Airport"
    BPU = "Beppu"
    BPX = "Bangda Airport"
    BPY = "Besalampy"
    BQA = "Baler"
    BQB = "Bussellton Regional Airport"
    BQE = "Bubaque"
    BQG = "Bogorodskoye"
    BQH = "Biggin Hill"
    BQI = "Bagani"
    BQJ = "Batagay"
    BQK = "Glynco Jetport"
    BQL = "Boulia"
    BQN = "Rafael Hernandez Airport"
    BQO = "Bouna"
    BQQ = "Barra"
    BQS = "Blagoveschensk Airport"
    BQT = "Brest Airport"
    BQU = "J. F. Mitchell"
    BQV = "Bartlett SPB"
    BQW = "Balgo Hills"
    BRA = "Barreiras Airport"
    BRB = "Barreirinhas"
    BRC = "San Carlos de Bariloche International Airport"
    BRD = "Crow Wing County Airport"
    BRE = "Bremen Airport"
    BRF = "Bradford"
    BRG = "Municipal"
    BRH = "Brahman"
    BRI = "Palese Airport"
    BRJ = "Bright"
    BRK = "Bourke"
    BRL = "Burlington Airport"
    BRM = "Barquisimeto Airport"
    BRN = "Bern Airport"
    BRO = "South Padre Island International Airport"
    BRP = "Biaru"
    BRQ = "Turany Airport"
    BRR = "North Bay Airport"
    BRS = "Bristol Airport"
    BRT = "Bathurst Island"
    BRU = "Brussels Airport"
    BRV = "Bremerhaven"
    BRW = "Wiley Post-Will Rogers Memorial Airport"
    BRX = "Barahona"
    BRY = "Samuels Field"
    BRZ = "Borotou"
    BSA = "Bossaso"
    BSB = "Brasilia International Airport"
    BSC = "Bahia Solano"
    BSD = "Baoshan Airport"
    BSE = "Sematan"
    BSF = "Bradshaw AAF"
    BSG = "Bata Airport"
    BSH = "Brighton"
    BSI = "Blairsville"
    BSJ = "Bairnsdale"
    BSK = "Biskra Airport"
    BSL = "EuroAirport Swiss"
    BSM = "Bishe-kola"
    BSN = "Bossangoa"
    BSO = "Basco Airport"
    BSP = "Bensbach"
    BSQ = "Bisbee Municipal Airport"
    BSR = "Basra International Airport"
    BSS = "Balsas"
    BST = "Bost"
    BSU = "Basankusu"
    BSV = "Besakoa"
    BSW = "Boswell Bay"
    BSX = "Bassein"
    BSY = "Bardera"
    BSZ = "Bartletts"
    BTA = "Yaoundé"
    BTB = "Betou"
    BTC = "Batticaloa"
    BTD = "Brunette Downs"
    BTE = "Bonthe"
    BTF = "Salt Lake Skypark"
    BTG = "Batangafo"
    BTH = "Hang Nadim International Airport"
    BTI = "Barter Island Airport"
    BTJ = "Sultan Iskandar Muda International Airport"
    BTK = "Bratsk Airport"
    BTL = "WK Kellogg Regional"
    BTM = "Butte Airport"
    BTN = "Bennettsville"
    BTO = "Botopasie"
    BTP = "Butler County - Kenny Scholter Field"
    BTQ = "Butare"
    BTR = "Baton Rouge Metropolitan Airport"
    BTS = "Bratislava Airport"
    BTT = "Bettles"
    BTU = "Bintulu Airport"
    BTV = "Burlington International Airport"
    BTW = "Batu Licin"
    BTX = "Betoota"
    BTY = "Beatty"
    BTZ = "Yala Betong International Airport"
    BUA = "Buka"
    BUB = "Municipal"
    BUC = "Burketown"
    BUD = "Budapest Ferenc Liszt International Airport"
    BUF = "Buffalo Niagara International Airport"
    BUG = "Gen V Deslandes"
    BUI = "Bokondini"
    BUJ = "Ain Eddis"
    BUK = "Albuq"
    BUL = "Bulolo"
    BUM = "Butler"
    BUN = "Buenaventura"
    BUO = "Burao"
    BUP = "Bhatinda Airport"
    BUQ = "Bulawayo Airport"
    BUR = "Bob Hope Airport"
    BUS = "Batumi Airport"
    BUT = "Bathpalathang Airport"
    BUU = "Muara Bungo Airport"
    BUV = "Bella Union"
    BUW = "Baubau Airport"
    BUX = "Bunia"
    BUY = "Bunbury"
    BUZ = "Bushehr Airport"
    BVA = "Beauvais-Tille Airport"
    BVB = "Boa Vista Airport"
    BVC = "Rabil Airport"
    BVD = "Sea Port"
    BVE = "Laroche Airport"
    BVF = "Dama"
    BVG = "Berlevag Airport"
    BVH = "Vilhena Airport"
    BVI = "Birdsville"
    BVJ = "Bovanenkovo Airport"
    BVK = "Huacaraje"
    BVL = "Baures"
    BVM = "Belmonte"
    BVO = "Bartlesville"
    BVP = "Bolovip"
    BVR = "Esperadinha"
    BVS = "Breves"
    BVU = "Beluga"
    BVV = "Burevestnik AFB"
    BVW = "Batavia Downs"
    BVX = "Municipal"
    BVY = "Beverly Municipal Airport"
    BVZ = "Beverley Springs"
    BWA = "Bhairawa Airport"
    BWB = "Barrow Island"
    BWC = "Brawley"
    BWD = "Brownwood"
    BWE = "Braunschweig"
    BWF = "Walney Island"
    BWG = "Warren County"
    BWH = "Butterworth"
    BWI = "Baltimore/Wash International Thurgood Marshall Airport"
    BWJ = "Bawan"
    BWK = "Brac"
    BWL = "Blackwell"
    BWM = "Bowman"
    BWN = "Brunei International Airport"
    BWO = "Balakovo"
    BWP = "Bewani"
    BWQ = "Brewarrina"
    BWS = "Blaine"
    BWT = "Burnie Wynyard Airport"
    BWU = "Sydney Bankstown"
    BWW = "Las Brujas Airport"
    BWX = "Bandar Udara Internasional Banyuwangi"
    BXA = "George R Carr"
    BXB = "Babo"
    BXC = "Boxborough"
    BXD = "Bade"
    BXE = "Bakel"
    BXF = "Belburn"
    BXG = "Bendigo"
    BXH = "Balhash"
    BXI = "Boundiali"
    BXJ = "Burundai"
    BXK = "Buckeye Municipal"
    BXL = "Blue Lagoon"
    BXM = "Batom"
    BXN = "Imsik"
    BXO = "Buochs"
    BXP = "Biala Podlaska"
    BXR = "Bam"
    BXS = "Borrego Springs"
    BXT = "Bontang"
    BXU = "Butuan Airport"
    BXV = "Breiddalsvik"
    BXW = "Harun Thohir Airport"
    BXX = "Borama International"
    BXY = "Baikonur Krayniy Airport"
    BXZ = "Bunsil"
    BYA = "Boundary"
    BYB = "Dibaa"
    BYC = "Yacuiba"
    BYD = "Beidah"
    BYF = "Albert-Bray Airport"
    BYG = "Municipal"
    BYH = "Blytheville AFB"
    BYI = "Rupert"
    BYJ = "Beja International"
    BYK = "Bouake"
    BYL = "Bella Yella"
    BYM = "C.M. de Cespedes"
    BYN = "Bayankhongor"
    BYO = "Bonito Airport"
    BYP = "Barimunya Airport"
    BYQ = "Bunyu"
    BYR = "Laeso Airport"
    BYS = "Bicycle Lake AAF"
    BYT = "Bantry"
    BYU = "Bindlacher-Berg"
    BYV = "Beira Lake SPB"
    BYW = "Blakely Island"
    BYX = "Baniyala"
    BZA = "San Pedro"
    BZB = "Bazaruto Island"
    BZC = "Buzios"
    BZD = "Balranald"
    BZE = "Philip S.W. Goldson International Airport"
    BZF = "Benton Field"
    BZG = "Bydgoszcz Airport"
    BZH = "Bumi Hills"
    BZI = "Balikesir"
    BZK = "Bryansk International Airport"
    BZL = "Barisal Airport"
    BZM = "Bemolanga Airport"
    BZN = "Bozeman Yellowstone International Airport"
    BZO = "Bolzano"
    BZP = "Bizant"
    BZR = "Beziers Vias Airport"
    BZS = "Buzzards Pt S"
    BZT = "Eagle Air Park"
    BZU = "Buta"
    BZV = "Maya Maya Airport"
    BZX = "Bazhong Enyang Airport"
    BZY = "Beltsy Airport"
    BZZ = "Raf Brize Norton"
    CAA = "Catacamas"
    CAB = "Cabinda Airport"
    CAC = "Cascavel Airport"
    CAD = "Cadillac"
    CAE = "Columbia Metropolitan Airport"
    CAF = "Carauari"
    CAG = "Cagliari Elmas Airport"
    CAH = "Kamau"
    CAI = "Cairo International Airport"
    CAJ = "Canaima"
    CAK = "Akron-Canton Airport"
    CAL = "Machrihanish Airport"
    CAM = "Camiri"
    CAN = "Guangzhou Baiyun International Airport"
    CAO = "Clayton"
    CAP = "Cap Haitien Airport"
    CAQ = "Caucasia"
    CAR = "Municipal"
    CAS = "Anfa"
    CAT = "Cascais Municipal Aerodrome"
    CAU = "Caruaru"
    CAV = "Cazombo"
    CAW = "Bartolomeu Lisandro Airport"
    CAX = "Carlisle"
    CAY = "Felix Eboue Airport"
    CAZ = "Cobar"
    CBA = "Corner Bay"
    CBB = "J Wilsterman Airport"
    CBC = "Cherrabun"
    CBD = "Car Nicobar"
    CBE = "Greater Cumberland Regional"
    CBF = "Municipal"
    CBG = "Cambridge Airport"
    CBH = "Leger"
    CBI = "Cape Barren Island"
    CBJ = "Cabo Rojo"
    CBK = "Municipal"
    CBL = "Ciudad Bolivar"
    CBM = "Columbus AFB"
    CBN = "Penggung"
    CBO = "Awang Airport"
    CBP = "Coimbra"
    CBQ = "Calabar Airport"
    CBR = "Canberra Airport"
    CBS = "Oro Negro"
    CBT = "Catumbela Airport"
    CBU = "Cottbus"
    CBV = "Coban"
    CBW = "Campo Mourao"
    CBX = "Condobolin"
    CBY = "Canobie"
    CBZ = "Cabin Creek"
    CCA = "Chaffee AFB"
    CCB = "Cable Airport"
    CCC = "Jardines del Rey Airport"
    CCD = "Century City"
    CCE = "Grand Case"
    CCF = "Carcassonne Airport"
    CCG = "Crane County Airport"
    CCH = "Chile Chico"
    CCI = "Concordia"
    CCJ = "Calicut International Airport"
    CCK = "Cocos Islands Airport"
    CCL = "Chinchilla"
    CCM = "Criciuma"
    CCN = "Chakcharan"
    CCO = "Carimagua"
    CCP = "Carriel Sur Airport"
    CCQ = "Cachoeira"
    CCR = "Buchanan Field"
    CCS = "Simon Bolivar International Airport"
    CCT = "Colonia Catriel"
    CCU = "Netaji Subhas Chandra Bose Airport"
    CCV = "Craig Cove"
    CCW = "Cowell"
    CCX = "Caceres"
    CCY = "Municipal"
    CCZ = "Chub Cay"
    CDA = "Cooinda"
    CDB = "Cold Bay Airport"
    CDC = "Cedar City Airport"
    CDD = "Cauquira"
    CDE = "Caledonia"
    CDG = "Charles de Gaulle Airport"
    CDH = "Harrell Field"
    CDI = "Cachoeiro Itapemirim"
    CDJ = "Conceicao Do Araguaia"
    CDK = "Lewis"
    CDL = "Candle"
    CDN = "Woodward Field"
    CDO = "Cradock"
    CDP = "Cuddapah"
    CDQ = "Croydon"
    CDR = "Chadron Airport"
    CDS = "Childress"
    CDT = "Castellon"
    CDU = "Camden"
    CDV = "Mudhole Smith Airport"
    CDW = "Caldwell Wright"
    CDY = "Cagayan De Sulu"
    CDZ = "Cadiz"
    CEA = "Cessna Aircraft Field"
    CEB = "Mactan-Cebu International Airport"
    CEC = "Del Norte County Regional Airport"
    CED = "Ceduna Airport"
    CEE = "Cherepovets Airport"
    CEF = "Westover ARB/Metropolitan"
    CEG = "Hawarden Airport"
    CEH = "Chelinda"
    CEI = "Chiang Rai International Airport"
    CEK = "Chelyabinsk International Airport"
    CEL = "Cape Eleuthera"
    CEM = "Central"
    CEN = "Ciudad Obregon Airport"
    CEO = "Waco Kungo"
    CEP = "Concepcion"
    CEQ = "Mandelieu"
    CER = "Maupertus"
    CES = "Cessnock"
    CET = "Le Pontreau"
    CEU = "Oconee County"
    CEV = "Mettle Field"
    CEW = "Bob Sikes"
    CEX = "Chena Hot Springs"
    CEY = "Calloway County"
    CEZ = "Montezuma County Airport"
    CFA = "Coffee Point"
    CFB = "Cabo Frio International Airport"
    CFC = "Cacador"
    CFD = "Coulter Field"
    CFE = "Clermont-Ferrand Auvergne Airport"
    CFF = "Cafunfo"
    CFG = "Jaime Gonzalez Airport"
    CFH = "Clifton Hills"
    CFI = "Camfield"
    CFK = "Chlef International Airport"
    CFM = "Conklin (Leismer) Airport"
    CFN = "Donegal Airport"
    CFO = "Confreza"
    CFP = "Carpentaria Downs"
    CFQ = "Creston Valley Airport"
    CFR = "Carpiquet Airport"
    CFS = "Coffs Harbour Airport"
    CFT = "Morenci"
    CFU = "Ioannis Kapodistrias Airport"
    CFV = "Municipal"
    CGA = "Craig SPB"
    CGB = "Marechal Rondon International Airport"
    CGC = "Cape Gloucester"
    CGD = "Changde Airport"
    CGE = "Cambridge"
    CGF = "Cuyahoga County"
    CGG = "Casiguran"
    CGH = "Sao Paulo/Congonhas Airport"
    CGI = "Cape Girardeau Airport"
    CGJ = "Chingola"
    CGK = "Soekarno-Hatta International Airport"
    CGM = "Mambajao"
    CGN = "Cologne Bonn Airport"
    CGO = "Zhengzhou Xinzheng Airport"
    CGP = "Shah Amanat International Airport"
    CGQ = "Changchun Longjia International Airport"
    CGR = "Campo Grande International Airport"
    CGS = "College Park"
    CGT = "Chinguitti"
    CGU = "Ciudad Guayana"
    CGV = "Caiguna"
    CGX = "Merrill C Meigs"
    CGY = "Laguindingan International Airport"
    CGZ = "Municipal"
    CHA = "Chattanooga Airport"
    CHB = "Chilas"
    CHC = "Christchurch International Airport"
    CHF = "Jinhae"
    CHG = "Chaoyang Airport"
    CHH = "Chachapoyas"
    CHI = "Chicago FSS"
    CHJ = "Chipinge"
    CHK = "Municipal"
    CHL = "Challis"
    CHM = "Chimbote"
    CHN = "Jeonju"
    CHO = "Charlottesville Albemarle Airport"
    CHP = "Circle Hot Springs"
    CHQ = "Chania International Airport"
    CHR = "Chateauroux"
    CHS = "Charleston International Airport"
    CHT = "Karewa"
    CHU = "Chuathbaluk Airport"
    CHV = "Chaves"
    CHW = "Jiuhuang"
    CHX = "Changuinola"
    CHY = "Choiseul Bay Airport"
    CHZ = "State"
    CIA = "Ciampino-G. B. Pastine International Airport"
    CIB = "Ap In The Sky"
    CIC = "Chico Municipal Airport"
    CID = "The Eastern Iowa Airport"
    CIE = "Collie"
    CIF = "Chifeng Airport"
    CIG = "Craig-Moffat"
    CIH = "Changzhi Airport"
    CII = "Cildir"
    CIJ = "E. Beltram Airport"
    CIK = "Chalkyitsik"
    CIL = "Melsing Creek"
    CIM = "Cimitarra"
    CIN = "Carroll"
    CIO = "MCAL Lopez"
    CIP = "Chipata"
    CIQ = "Chiquimula"
    CIR = "Cairo"
    CIS = "Canton Island"
    CIT = "Shymkent Airport"
    CIU = "Chippewa County Airport"
    CIV = "Chomley"
    CIW = "Canouan Island"
    CIX = "Cornel Ruiz Airport"
    CIY = "Comiso Airport"
    CIZ = "Coari"
    CJA = "Cajamarca Airport"
    CJB = "Coimbatore International Airport"
    CJC = "El Loa Airport"
    CJD = "Candilejas"
    CJF = "Coondewanna Airport"
    CJH = "Chilko Lake"
    CJJ = "Cheongju Airport"
    CJL = "Chitral"
    CJM = "Chumphon Airport"
    CJN = "Gillespie Field"
    CJS = "Abraham Gonzalez International Airport"
    CJT = "Copalar"
    CJU = "Jeju International Airport"
    CKA = "Kegelman Af"
    CKB = "Benedum Airport"
    CKC = "Cherkassy"
    CKD = "Crooked Creek"
    CKE = "Clear Lake"
    CKG = "Chongqing Jiangbei International Airport"
    CKH = "Chokurdah Airport"
    CKI = "Croker Island"
    CKK = "Cherokee"
    CKL = "Chkalovsky"
    CKM = "Fletcher Field"
    CKN = "Municipal"
    CKO = "Cornelio Procopio"
    CKR = "Crane Island"
    CKS = "Carajas Airport"
    CKT = "Sarakhs"
    CKU = "City"
    CKV = "Outlaw Field"
    CKW = "Christmas Creek Mine"
    CKX = "Chicken"
    CKY = "Conakry Airport"
    CKZ = "Canakkale Airport"
    CLA = "Comilla"
    CLC = "Metroport"
    CLD = "McClellan-Palomar Airport"
    CLE = "Cleveland Hopkins International Airport"
    CLG = "Coalinga"
    CLH = "Coolah"
    CLI = "Clintonville"
    CLJ = "Avram Iancu Cluj International Airport"
    CLK = "Municipal"
    CLL = "Easterwood Airport"
    CLM = "Fairchild International"
    CLN = "Carolina"
    CLO = "Alfonso B. Aragon Airport"
    CLP = "Clarks Point"
    CLQ = "Colima Airport"
    CLR = "Calipatria"
    CLS = "Centralia"
    CLT = "Charlotte Douglas International Airport"
    CLU = "Columbus Municipal"
    CLV = "Caldas Novas"
    CLW = "Executive"
    CLX = "Clorinda"
    CLY = "Sainte Catherine Airport"
    CLZ = "Calabozo"
    CMA = "Cunnamulla"
    CMC = "Camocim"
    CMD = "Cootamundra"
    CME = "Ciudad Del Carmen Airport"
    CMF = "Chambery"
    CMG = "Corumba Internacional Airport"
    CMH = "John Glenn Columbus International Airport"
    CMI = "Willard University Airport"
    CMJ = "Chi Mei"
    CMK = "Club Makokola"
    CML = "Camooweal"
    CMM = "Carmelita"
    CMN = "Mohamed V International Airport"
    CMO = "Obbia"
    CMP = "Campo Alegre"
    CMQ = "Clermont"
    CMR = "Colmar-houssen"
    CMS = "Scusciuban"
    CMT = "Cameta"
    CMU = "Chimbu"
    CMV = "Coromandel"
    CMW = "Ign Agramonte International Airport"
    CMX = "Houghton County Airport"
    CMY = "Fort Mccoy"
    CMZ = "Caia"
    CNA = "Cananea"
    CNB = "Coonamble"
    CNC = "Coconut Island"
    CND = "Kogalniceanu Airport"
    CNE = "Canon City"
    CNF = "Tancredo Neves International Airport"
    CNG = "Parvaud"
    CNH = "Municipal"
    CNI = "Changhai"
    CNJ = "Cloncurry Airport"
    CNK = "Blosser Municipal"
    CNL = "Sindal"
    CNM = "Cavern City Air Terminal"
    CNN = "Kannur International Airport"
    CNO = "Chino"
    CNP = "Neerlerit Inaat Airport"
    CNQ = "Camba Punta Airport"
    CNR = "Chanaral"
    CNS = "Cairns Airport"
    CNT = "Charata"
    CNU = "Martin Johnson"
    CNV = "Canavieiras"
    CNW = "TSTC Waco Airport"
    CNX = "Chiang Mai International Airport"
    CNY = "Canyonlands Field"
    CNZ = "Cangamba"
    COA = "Columbia"
    COB = "Coolibah"
    COC = "Concordia"
    COD = "Yellowstone Regional Airport"
    COE = "Coeur D'Alene"
    COF = "Patrick AFB"
    COG = "Mandinga"
    COH = "Cooch Behar"
    COI = "Merritt Island"
    COJ = "Coonabarabran"
    COK = "Cochin International Airport"
    COL = "Isle Of Coll"
    COM = "Coleman"
    CON = "Concord"
    COO = "Cotonou Airport"
    COP = "Cooperstown - Westville Airport"
    COQ = "Choibalsan"
    COR = "Ingeniero Aeronautico Ambrosio L.V. Taravella International Airport"
    COS = "Colorado Springs Airport"
    COT = "Cotulla"
    COU = "Columbia Regional Airport"
    COV = "Covilha"
    COW = "Coquimbo"
    COX = "Congo Town"
    COY = "Coolawanyah"
    COZ = "Constanza"
    CPA = "A. Tubman"
    CPB = "Capurgana"
    CPC = "Chapelco Airport"
    CPD = "Coober Pedy Airport"
    CPE = "Campeche International Airport"
    CPF = "Cepu"
    CPG = "Carmen De Patagones"
    CPH = "Copenhagen Airport"
    CPI = "Cape Orford"
    CPL = "Chaparral"
    CPM = "Compton"
    CPN = "Cape Rodney"
    CPO = "Chamonate Airport"
    CPP = "Coposa Airport"
    CPQ = "International"
    CPR = "Casper/Natrona County International Airport"
    CPS = "St. Louis Downtown Airport"
    CPT = "Cape Town International Airport"
    CPU = "Cururupu"
    CPV = "Joao Suassuna Airport"
    CPX = "Benjamin Rivera Noriega Airport"
    CQA = "Canarana Airport"
    CQD = "Shahre-kord"
    CQF = "Calais"
    CQM = "Ciudad Real Central"
    CQP = "Cape Flattery"
    CQS = "Costa Marques"
    CQT = "Caquetania"
    CQW = "CHERAW MUNI/LYNCH BELLINGER FLD AIRPORT"
    CRA = "Craiova Airport"
    CRB = "Collarenebri"
    CRC = "Cartago"
    CRD = "General E. Mosconi International Airport"
    CRE = "Grand Strand Airport"
    CRF = "Carnot"
    CRG = "Craig Municipal"
    CRH = "Cherribah"
    CRI = "Crooked Island Airport"
    CRJ = "Coorabie"
    CRK = "Diosdado Macapagal International (Clark International)"
    CRL = "Charleroi Brussels South Airport"
    CRM = "National Airport"
    CRO = "Corcoran"
    CRP = "Corpus Christi International Airport"
    CRQ = "Caravelas"
    CRR = "Ceres"
    CRS = "Corsicana"
    CRT = "Municipal"
    CRU = "Carriacou Island"
    CRV = "Crotone"
    CRW = "Yeager Airport"
    CRX = "Roscoe Turner"
    CRY = "Carlton Hill"
    CRZ = "Turkmenabad"
    CSA = "Isle Of Colonsay"
    CSB = "Caransebes"
    CSC = "Canas"
    CSD = "Cresswell Downs"
    CSE = "Crested Butte"
    CSF = "Creil"
    CSG = "Columbus Airport"
    CSH = "Solovky"
    CSI = "Casino"
    CSJ = "Cape St Jacques"
    CSK = "Cap Skirring"
    CSL = "O Sullivan Army Air Field"
    CSM = "Sherman"
    CSN = "Carson City"
    CSO = "Cochstedt"
    CSP = "Cape Spencer C G Heliport"
    CSQ = "Municipal"
    CSR = "Casuarito"
    CSS = "Cassilandia"
    CST = "Castaway"
    CSU = "Santa Cruz Do Sul"
    CSV = "Memorial"
    CSW = "Colorado do Oeste"
    CSX = "Changsha Huanghua Airport"
    CSY = "Cheboksary Airport"
    CSZ = "Brigadier Hector Ruiz"
    CTA = "Catania-Fontanarossa Airport"
    CTB = "Cut Bank"
    CTC = "Catamarca Airport"
    CTD = "Chitre"
    CTE = "Carti"
    CTF = "Coatepeque Airport"
    CTG = "Rafael Nunez International Airport"
    CTH = "Chestercounty Carlson"
    CTI = "Cuito Cuanavale"
    CTK = "Canton"
    CTL = "Charleville Airport"
    CTM = "Chetumal Airport"
    CTN = "Cooktown Airport"
    CTO = "Peconic River"
    CTP = "Carutapera"
    CTQ = "Do Palmar"
    CTR = "Cattle Creek"
    CTS = "New Chitose Airport"
    CTT = "Le Castellet"
    CTU = "Chengdu Shuangliu International Airport"
    CTV = "Catoca Airport"
    CTW = "Cottonwood"
    CTX = "Cortland"
    CTY = "Cross City"
    CTZ = "Sampson County"
    CUA = "Ciudad Constitución Airport"
    CUB = "Owens Field"
    CUC = "Camilo Daza International Airport"
    CUD = "Caloundra"
    CUE = "Mariscal Lamar International Airport"
    CUF = "Levaldigi Airport"
    CUG = "Cudal"
    CUH = "Municipal"
    CUI = "Currillo"
    CUJ = "Culion"
    CUK = "Caye Caulker"
    CUL = "Culiacan International Airport"
    CUM = "Cumana"
    CUN = "Cancun International Airport"
    CUO = "Caruru"
    CUP = "Carupano"
    CUQ = "Coen"
    CUR = "Curacao International Airport"
    CUS = "Municipal"
    CUT = "Cutral"
    CUU = "Gen Fierro Villalobos Airport"
    CUV = "Casigua"
    CUW = "Cube Cove"
    CUX = "Cuddihy Field"
    CUY = "Cue"
    CUZ = "Alejandro Velasco Astete International Airport"
    CVA = "Civic Ar Heli"
    CVB = "Chungribu"
    CVC = "Cleve"
    CVE = "Covenas"
    CVF = "Courchevel"
    CVG = "Cincinnati/Northern Kentucky Airport"
    CVH = "Caviahue"
    CVI = "Caleta Olivia"
    CVJ = "General Mariano Matamoros Airport"
    CVL = "Cape Vogel"
    CVM = "Ciudad Victoria Airport"
    CVN = "Clovis Municipal Airport"
    CVO = "Albany"
    CVQ = "Carnarvon Airport"
    CVR = "Hughes"
    CVS = "Cannon AFB"
    CVT = "Coventry Airport"
    CVU = "Corvo Island (Azores) Airport"
    CWA = "Central Wisconsin Airport"
    CWB = "Afonso Pena International Airport"
    CWC = "Chernivtsi International Airport"
    CWF = "Chennault International."
    CWG = "Callaway Gardens"
    CWI = "Clinton"
    CWJ = "Cangyuan Washan Airport"
    CWL = "Cardiff Airport"
    CWO = "Ft Wolter AAF"
    CWP = "Campbellpore"
    CWR = "Cowarie"
    CWS = "Center Island"
    CWT = "Cowra"
    CWW = "Corowa"
    CWX = "Cochise County Airport"
    CXA = "Caicara Del Orinoco"
    CXB = "Coxs Bazar Airport"
    CXC = "Chitina Airport"
    CXF = "Coldfoot"
    CXH = "Coal Harbour Sea Plane Base"
    CXI = "Christmas Island Airport"
    CXJ = "Hugo Cantergiani Regional Airport"
    CXL = "International"
    CXN = "Candala"
    CXO = "Montgomery Co"
    CXP = "Tunggul Wulung"
    CXQ = "Christmas Creek"
    CXR = "Cam Ranh International Airport"
    CXT = "Charters Towers"
    CXY = "Cat Cays"
    CYA = "Les Cayes"
    CYB = "Charles Kirkconnel International Airport"
    CYC = "Caye Chapel"
    CYD = "San Ignacio Town Airstrip"
    CYE = "Crystal Lake"
    CYF = "Chefornak Sea Plane Base"
    CYG = "Corryong"
    CYI = "Chiayi Airport"
    CYL = "Coyoles"
    CYM = "Chatham SPB"
    CYO = "Cayo Largo Del Sur Airport"
    CYP = "Calbayog Airport"
    CYR = "Laguna De Los Patos"
    CYS = "Cheyenne"
    CYT = "Intermediate"
    CYU = "Cuyo"
    CYW = "Celaya"
    CYX = "Cherskiy Airport"
    CYZ = "Cauayan Airport"
    CZA = "Chichen Itza"
    CZB = "Carlos Ruhl"
    CZC = "Copper Centre"
    CZE = "Coro"
    CZF = "Cape Romanzof"
    CZH = "Corozal"
    CZJ = "Corazon De Jesus"
    CZK = "Cascade Locks/Stevens"
    CZL = "Ain El Bey Airport"
    CZM = "Cozumel Airport"
    CZN = "Chisana Field"
    CZO = "Chistochina"
    CZP = "Cape Pole"
    CZS = "Campo Internacional Airport"
    CZT = "Carrizo Springs"
    CZU = "Corozal Airport"
    CZW = "Czestochowa"
    CZX = "Changzhou Airport"
    CZY = "Cluny"
    CZZ = "Campo"
    DAA = "Davison AAF"
    DAB = "Daytona Beach International Airport"
    DAC = "Hazrat Shahjalal International Airport"
    DAD = "Da Nang International Airport"
    DAF = "Daup"
    DAG = "Barstow-Daggett"
    DAH = "Dathina"
    DAJ = "Dauan Island"
    DAK = "Dakhla"
    DAL = "Dallas Love Field"
    DAM = "Damascus International Airport"
    DAN = "Municipal"
    DAO = "Dabo"
    DAP = "Darchula"
    DAR = "Julius Nyerere International Airport"
    DAS = "Great Bear Lake"
    DAT = "Datong Airport"
    DAU = "Daru Airport"
    DAV = "Enrique Malek Airport"
    DAX = "Dazhou Heshi Airport"
    DAY = "James M. Cox Dayton International Airport"
    DAZ = "Darwaz"
    DBA = "Dalbandin"
    DBB = "Alalamain International"
    DBC = "Baicheng Chang'an"
    DBD = "Dhanbad"
    DBK = "Dutch Bay SPB Seaplane Base"
    DBM = "Debra Marcos"
    DBN = "Municipal"
    DBO = "Dubbo City Regional Airport"
    DBP = "Debepare"
    DBQ = "Dubuque Municipal Airport"
    DBR = "Darbhanga Airport"
    DBS = "Dubois"
    DBT = "Debra Tabor"
    DBU = "Dambulu Oya Tank"
    DBV = "Dubrovnik Airport"
    DBY = "Dalby"
    DCA = "Ronald Reagan National Airport"
    DCF = "Canefield Airport"
    DCG = "Dubai Creek SPB"
    DCI = "Rafsu Decimomannu"
    DCK = "Dahl Creek Airport"
    DCM = "Mazamet Airport"
    DCN = "RAAF Curtin"
    DCP = "Cabin Plant Heliport"
    DCR = "Decatur Hi-Way"
    DCT = "Duncan Town"
    DCU = "Pyor"
    DCY = "Daocheng Yading Airport"
    DDC = "Dodge City Municipal Airport"
    DDD = "Dhaalu Airport"
    DDG = "Langtou Airport"
    DDI = "Daydream Island"
    DDM = "Dodoima"
    DDN = "Delta Downs"
    DDP = "Dorado Beach"
    DDR = "Shigatse Tingri Airport"
    DDU = "Dadu"
    DEA = "Dera Ghazi Khan Airport"
    DEB = "Debrecen Airport"
    DEC = "Decatur Airport"
    DED = "Dehra Dun Airport"
    DEE = "Mendeleyevo Airport"
    DEF = "Dezful Airport"
    DEH = "Municipal"
    DEI = "Denis Island"
    DEL = "Indira Gandhi International Airport"
    DEM = "Dembidollo"
    DEN = "Denver International Airport"
    DEO = "Hyatt Regency Heliport"
    DEP = "Deparizo"
    DEQ = "Deqing Moganshan Airport"
    DER = "Derim"
    DES = "Desroches"
    DET = "Detroit City"
    DEX = "Nop Goliat Airport"
    DEZ = "Al Jafrah"
    DFA = "Danfeng Airport"
    DFI = "Memorial"
    DFP = "Drumduff"
    DFW = "Dallas/Fort Worth International Airport"
    DGA = "Dangriga"
    DGB = "Danger Bay"
    DGC = "Degahbur"
    DGD = "Dalgaranga"
    DGE = "Mudgee"
    DGF = "Douglas Lake"
    DGG = "Daugo"
    DGH = "Deoghar International Airport"
    DGK = "Dugong"
    DGL = "Douglas Municipal"
    DGM = "Dongguan"
    DGN = "NAF"
    DGO = "Guadalupe Victoria Airport"
    DGP = "Daugavpils"
    DGR = "Dargaville"
    DGT = "Dumaguete Airport"
    DGU = "Dedougou"
    DGW = "Converse County"
    DHA = "King Abdulaziz AB"
    DHB = "Deer Harbor"
    DHD = "Durham Downs"
    DHF = "Al Dhafra Military Airport"
    DHG = "Dalnegorks"
    DHI = "Dhangarhi"
    DHL = "Dhala"
    DHM = "Gaggal Airport"
    DHN = "Dothan Regional Airport"
    DHO = "Horn River"
    DHR = "De Kooy/Den Helder Airport"
    DHT = "Dalhart"
    DIA = "Doha International Airport"
    DIB = "Dibrugarh Airport"
    DIE = "Antsiranana/Arrachart"
    DIG = "Diqing Shangri-La Airport"
    DIJ = "Dijon"
    DIK = "Dickinson Regional Airport"
    DIL = "Comoro Airport"
    DIM = "Dimbokro"
    DIN = "Dien Bien Airport"
    DIO = "Diomede Island"
    DIP = "Diapaga"
    DIQ = "Divinopolis"
    DIR = "Aba Tenna D Yilma Airport"
    DIS = "Loubomo"
    DIU = "Diu Airport"
    DIV = "Divo"
    DIW = "Mawella Lagoon Airport"
    DIY = "Diyarbakir Airport"
    DJA = "Djougou"
    DJB = "Sultan Thaha Airport"
    DJE = "Melita Airport"
    DJG = "Inedbirenne Airport"
    DJH = "Jebel Ali Seaplane Base"
    DJJ = "Sentani Airport"
    DJM = "Djambala"
    DJN = "Delta Junction"
    DJO = "Daloa"
    DJU = "Djupivogur"
    DKA = "Katsina"
    DKI = "Dunk Island"
    DKK = "Dunkirk"
    DKL = "Kiwigana Lodge Heliport"
    DKR = "Leopold Sedar Senghor International Airport"
    DKS = "Dikson"
    DKV = "Docker River"
    DLA = "Douala Airport"
    DLB = "Dalbertis"
    DLC = "Dalian Zhoushuizi International Airport"
    DLE = "Dole-Jura Airport"
    DLF = "Laughlin AFB"
    DLG = "Dillingham Airport"
    DLH = "Duluth International Airport"
    DLI = "Lien Khuong Airport"
    DLK = "Dulkaninna"
    DLL = "Dillon"
    DLM = "Dalaman Airport"
    DLN = "Dillon"
    DLO = "Dolomi"
    DLR = "Dalnerechensk Airport"
    DLS = "Columbia Gorge Regional/The Dalles Municipal Airport"
    DLU = "Dali Airport"
    DLV = "Delissaville"
    DLY = "Dillons Bay"
    DLZ = "Dalanzadgad"
    DMA = "Davis Monthan AFB"
    DMB = "Jambyl Airport"
    DMD = "Doomadgee Airport"
    DME = "Moscow Domodedovo Airport"
    DMK = "Don Mueang International Airport"
    DMM = "King Fahd International Airport"
    DMN = "Deming"
    DMO = "Sedalia"
    DMR = "Dhamar"
    DMT = "Diamantino"
    DMU = "Dimapur Airport"
    DNA = "Kadena AB"
    DNB = "Dunbar"
    DND = "Dundee Airport"
    DNE = "Dallas North Airport"
    DNF = "Martuba"
    DNG = "Doongan"
    DNH = "Dunhuang Airport"
    DNI = "Wad Medani"
    DNK = "Dnepropetrovsk International Airport"
    DNL = "Daniel Field"
    DNM = "Denham"
    DNN = "Municipal"
    DNO = "Dianopolis"
    DNP = "Dang"
    DNQ = "Deniliquin"
    DNR = "Pleurtuit Airport"
    DNS = "Municipal"
    DNT = "Downtown Heliport"
    DNU = "Dinangat"
    DNV = "Vermilion County"
    DNX = "Galegu"
    DNZ = "Cardak Airport"
    DOA = "Doany"
    DOB = "Dobo Airport"
    DOC = "Dornoch"
    DOD = "Dodoma Airport"
    DOE = "Djoemoe"
    DOF = "Dora Bay"
    DOG = "Dongola"
    DOH = "Hamad International Airport"
    DOI = "Doini"
    DOK = "Donetsk International Airport"
    DOL = "Saint Gatien Airport"
    DOM = "Melville Hall Airport"
    DON = "Dos Lagunas"
    DOO = "Dorobisoro"
    DOP = "Dolpa"
    DOR = "Dori"
    DOS = "Dios"
    DOU = "Dourados Airport"
    DOV = "Dover AFB"
    DOX = "Dongara"
    DOY = "Dongying Airport"
    DPA = "DuPage Airport"
    DPB = "Pampa Guanaco Airport"
    DPE = "Dieppe"
    DPG = "Michael AAF"
    DPK = "Deer Park"
    DPL = "Dipolog Airport"
    DPO = "Devonport Airport"
    DPS = "Ngurah Rai International Airport"
    DPT = "Deputatsky"
    DPU = "Dumpu"
    DQA = "Daqing Shi Airport"
    DQM = "Duqm International Airport"
    DRA = "Desert Rock"
    DRB = "Derby"
    DRC = "Dirico"
    DRD = "Dorunda Station"
    DRE = "Drummond Island"
    DRF = "Drift River"
    DRG = "Deering Airport"
    DRH = "Dabra"
    DRI = "Beauregard Parish"
    DRJ = "Drietabbetje"
    DRK = "Drake Bay"
    DRN = "Dirranbandi"
    DRO = "Durango-La Plata County Airport"
    DRR = "Durrie"
    DRS = "Dresden International Airport"
    DRT = "Del Rio International Airport"
    DRU = "Drummond"
    DRV = "Dharavandhoo AIrport"
    DRW = "Darwin International Airport"
    DRY = "Drysdale River"
    DSA = "Doncaster Sheffield Airport"
    DSC = "Dschang"
    DSD = "La Desirade"
    DSE = "Combolcha"
    DSG = "Dilasag"
    DSI = "Destin-Fort Walton Beach Airport"
    DSK = "Dera Ismail Khan"
    DSM = "Des Moines International Airport"
    DSN = "Ordos Ejin Horo Airport"
    DSO = "Sondok"
    DSS = "Blaise Diagne International Airport"
    DST = "Dubai Seaplane Terminal"
    DSV = "Dansville"
    DSX = "Dongsha Island"
    DSY = "Dara Sakor International Airport"
    DTA = "Delta"
    DTB = "Sisingamangaraja XII International Airport"
    DTD = "Datadawai"
    DTE = "Naga"
    DTH = "Death Valley"
    DTI = "Diamantina"
    DTL = "Municipal"
    DTM = "Dortmund Airport"
    DTN = "Shreveport Downtown"
    DTR = "Decatur Island"
    DTU = "Wudalianchi Dedu Airport"
    DTW = "Detroit Metropolitan Wayne County Airport"
    DUA = "Eaker"
    DUB = "Dublin Airport"
    DUC = "Halliburton Field"
    DUD = "Dunedin International Airport"
    DUE = "Dundo"
    DUF = "Pine Island Airport"
    DUG = "Bisbee-Douglas International"
    DUJ = "Du Bois-Jefferson County"
    DUK = "Dukuduk"
    DUM = "Pinang Kampai"
    DUN = "Dundas"
    DUQ = "Duncan/Quam"
    DUR = "King Shaka International Airport"
    DUS = "Dusseldorf International Airport"
    DUT = "Unalaska Airport"
    DVD = "Andavadoaka"
    DVK = "Diavik"
    DVL = "Devils Lake Airport"
    DVN = "Davenport"
    DVO = "Francisco Bangoy Intl Airport"
    DVP = "Davenport Downs"
    DVR = "Daly River"
    DVT = "Phoenix Deer Valley Airport"
    DWA = "Dwangwa"
    DWB = "Soalala"
    DWC = "Dubai World Central - Al Maktoum International Airport"
    DWD = "Dawadmi Airport"
    DWF = "Wright AFB"
    DWH = "David Wayne Hooks"
    DWN = "Downtown Airpark"
    DWO = "Diyawanna Oya Seaplane Base"
    DWR = "Dwyer Air Base"
    DWS = "Walt Disney World"
    DXB = "Dubai Airport"
    DXD = "Dixie"
    DXE = "Bruce Campbell Field"
    DXR = "Danbury Municipal Airport"
    DYA = "Dysart"
    DYG = "Zhangjiajie Hehua Airport"
    DYL = "Doylestown"
    DYM = "Diamantina Lakes"
    DYR = "Anadyr Airport"
    DYS = "Dyess AFB"
    DYU = "Dushanbe Airport"
    DYW = "Daly Waters"
    DZA = "Dzaoudzi Airport"
    DZH = "Dazhou Jinya Airport"
    DZI = "Codazzi"
    DZN = "Zhezhazgan Airport"
    DZO = "Santa Bernardina"
    DZU = "Dazu"
    EAA = "Eagle"
    EAB = "Abbse"
    EAE = "Emae"
    EAL = "Elenak"
    EAM = "Nejran"
    EAN = "Phifer Field"
    EAP = "EuroAirport Basel-Mulhouse-Freiburg Airport"
    EAR = "Kearney Regional Airport"
    EAS = "San Sebastian Airport"
    EAT = "Pangborn Field"
    EAU = "Eau Claire Airport"
    EBA = "Marina Di Campo Airport"
    EBB = "Entebbe International Airport"
    EBD = "El Obeid"
    EBG = "El Bagre"
    EBH = "El Bayadh"
    EBJ = "Esbjerg Airport"
    EBL = "Erbil International Airport"
    EBM = "El Borma"
    EBN = "Ebadon"
    EBO = "Ebon Airport"
    EBR = "Downtown"
    EBS = "Municipal"
    EBU = "Boutheon Airport"
    EBW = "Ebolowa"
    ECA = "Emmet County Airport"
    ECG = "Elizabeth City"
    ECH = "Echuca"
    ECI = "Costa Esmeralda Airport"
    ECN = "Ercan Airport"
    ECO = "El Encanto"
    ECP = "NW Florida Beaches Int"
    ECR = "El Charco"
    ECS = "Mondell"
    EDA = "Edna Bay"
    EDB = "Eldebba"
    EDD = "Erldunda"
    EDE = "Municipal"
    EDF = "Elmendorf AFB"
    EDG = "Weide AAF"
    EDI = "Edinburgh Airport"
    EDK = "El Dorado"
    EDL = "Eldoret Airport"
    EDM = "Les Ajoncs"
    EDN = "Enterprise Muni Airport"
    EDO = "Balikesir Koca Seyit Airport"
    EDQ = "Erandique"
    EDR = "Edward River"
    EDW = "Edwards AFB"
    EEA = "Aeroporto Regional do Planalto Serrano"
    EED = "Needles"
    EEK = "Eek Airport"
    EEN = "Dillant-Hopkins"
    EES = "Berenice International Airport"
    EFB = "Eight Fathom Bight"
    EFD = "Ellington Field"
    EFG = "Efogi"
    EFK = "Newport"
    EFL = "Kefallinia Airport"
    EFO = "East Fork Airport"
    EFW = "Municipal"
    EGA = "Engati"
    EGC = "Roumanieres Airport"
    EGE = "Eagle County Airport"
    EGI = "Duke Field"
    EGL = "Neghelli"
    EGM = "Sege Airport"
    EGN = "Geneina Airport"
    EGO = "Belgorod Airport"
    EGP = "Maverick Co"
    EGS = "Egilsstadir Airport"
    EGV = "Eagle River"
    EGX = "Egegik Airport"
    EHL = "El Bolson"
    EHM = "Cape Newenham"
    EHT = "Rentschler"
    EHU = "Ezhou Huahu Airport"
    EIA = "Popondetta"
    EIB = "Eisenach"
    EIE = "Eniseysk"
    EIH = "Einasleigh"
    EIK = "Yeysk"
    EIL = "Eielson AFB"
    EIN = "Eindhoven Airport"
    EIS = "Terrance B. Lettsome International Airport"
    EIY = "Ein Yahav"
    EJA = "Variguies Airport"
    EJH = "Wedjh Airport"
    EJN = "Ejin Banner Taolai Airport"
    EJT = "Enijet"
    EKA = "Murray Field"
    EKB = "Ekibastuz"
    EKD = "Elkedra"
    EKE = "Ekereku"
    EKI = "Municipal"
    EKN = "Elkins"
    EKO = "Elko Airport"
    EKS = "Shakhtyorsk Airport"
    EKT = "Eskilstuna"
    EKX = "Elizabethtown"
    ELA = "Eagle Lake"
    ELB = "San Bernado"
    ELC = "Elcho Island Airport"
    ELD = "South Arkansas Regional Airport"
    ELE = "El Real"
    ELF = "El Fasher Airport"
    ELG = "El Golea Airport"
    ELH = "North Eleuthera International Airport"
    ELI = "Elim Airport"
    ELJ = "El Recreo"
    ELK = "Municipal"
    ELL = "Ellisras"
    ELM = "Elmira Corning Regional Airport"
    ELN = "Bowers Field"
    ELO = "Eldorado"
    ELP = "El Paso International Airport"
    ELQ = "Prince Nayef bin Abdulaziz Regional Airport"
    ELR = "Elelim"
    ELS = "East London Airport"
    ELT = "Tour Sinai City"
    ELU = "Guemar Airport"
    ELV = "Elfin Cove SPB"
    ELW = "Ellamar"
    ELX = "El Tigre"
    ELY = "Yelland"
    ELZ = "Municipal"
    EMA = "East Midlands Airport"
    EMB = "Embarkadero"
    EMD = "Emerald Airport"
    EME = "Emden"
    EMG = "Empangeni"
    EMI = "Emirau"
    EMK = "Emmonak Airport"
    EML = "Emmen"
    EMM = "Kemerer"
    EMN = "Nema"
    EMO = "Emo"
    EMP = "Emporia"
    EMS = "Embessa"
    EMT = "El Monte"
    EMX = "El Maiten"
    EMY = "El Minya"
    ENA = "Kenai Municipal Airport"
    ENB = "Eneabba West"
    ENC = "Essey"
    END = "Vance AFB"
    ENE = "H. Hasan Aroeboesman Airport"
    ENF = "Enontekio"
    ENH = "Enshi Airport"
    ENI = "El Nido"
    ENJ = "El Naranjo"
    ENK = "Enniskillen St. Angelo"
    ENL = "Municipal"
    ENN = "Municipal"
    ENO = "Teniente Prim Alarcon"
    ENQ = "Coronel E Soto Cano AB"
    ENS = "Twente"
    ENT = "Enewetak Island"
    ENU = "Enugu Airport"
    ENV = "Wendover"
    ENW = "Kenosha Regional Airport"
    ENY = "Ershilipu Airport"
    EOH = "Enrique Olaya Herrera Airport"
    EOI = "Eday Airport"
    EOK = "Keokuk"
    EOR = "El Dorado"
    EOS = "Neosho"
    EOZ = "Elorza"
    EPA = "El Palomar"
    EPG = "Browns"
    EPH = "Ephrata"
    EPI = "Epi"
    EPL = "Mirecourt"
    EPN = "Epena"
    EPR = "Esperance Airport"
    EPS = "Arroyo Barril International"
    EPT = "Eliptamin"
    EPU = "Parnu"
    EQS = "Esquel Airport"
    ERA = "Erigavo"
    ERB = "Ernabella"
    ERC = "Erzincan Airport"
    ERD = "Berdyansk"
    ERE = "Erave"
    ERF = "Erfurt Airport"
    ERG = "Erbogachen Airport"
    ERH = "Moulay Ali Cherif Airport"
    ERI = "Erie International Airport"
    ERL = "Eren Hot Airport"
    ERM = "Comandante Kraemer"
    ERN = "Eirunepe"
    ERQ = "Elrose Mine"
    ERR = "Errol"
    ERS = "Eros Airport"
    ERT = "Erdenet"
    ERU = "Erume"
    ERV = "Kerrville"
    ERZ = "Erzurum Airport"
    ESA = "Esa'Ala"
    ESB = "Esenboga International Airport"
    ESC = "Delta County Airport"
    ESD = "Orcas Island Airport"
    ESE = "Ensenada"
    ESF = "Esler Field"
    ESG = "Mariscal Estigarribia"
    ESH = "Shoreham"
    ESI = "Espinosa"
    ESK = "Eskisehir"
    ESL = "Elista Airport"
    ESM = "Esmeraldas Airport"
    ESN = "Easton"
    ESO = "Espanola"
    ESP = "Birchwood-Pocono"
    ESR = "El Salvador"
    ESS = "Essen"
    EST = "Municipal"
    ESU = "Essaouira Airport"
    ESW = "State"
    ETB = "West Bend"
    ETD = "Etadunna"
    ETE = "Genda Wuha"
    ETH = "Eilat Airport"
    ETL = "Svetlaya Airport"
    ETM = "Ramon Airport"
    ETN = "Municipal"
    ETR = "Coronel Artilleria Victor Larrea Airport"
    ETS = "Municipal"
    ETZ = "Metz-Nancy-Lorraine Airport"
    EUA = "Kaufana"
    EUC = "Eucla"
    EUE = "Eureka"
    EUF = "Weedon Field"
    EUG = "Eugene Airport"
    EUM = "Neumuenster"
    EUN = "Hassan I Airport"
    EUO = "Paratebueno"
    EUQ = "Evelio Javier"
    EUX = "F D Roosevelt Airport"
    EVA = "Landing Strip"
    EVD = "Eva Downs"
    EVE = "Harstad/Narvik Airport Evenes"
    EVG = "Sveg Airport"
    EVH = "Evans Head"
    EVM = "Eveleth"
    EVN = "Zvartnots International Airport"
    EVV = "Evansville Regional Airport"
    EVW = "Evanston"
    EVX = "Evreux"
    EWB = "New Bedford Airport"
    EWD = "Wildman Lake"
    EWE = "Ewer"
    EWI = "Enarotali"
    EWK = "City-County"
    EWN = "Coastal Carolina Regional Airport"
    EWO = "Ewo"
    EWR = "Newark Liberty International Airport"
    EXI = "SPB"
    EXM = "Exmouth Gulf"
    EXT = "Exeter International Airport"
    EYK = "Beloyarsky Airport"
    EYL = "Yelimane"
    EYP = "El Yopal Airport"
    EYR = "Yerington"
    EYS = "Eliye Springs"
    EYW = "Key West International Airport"
    EZE = "Ministro Pistarini Airport"
    EZS = "Elazig Airport"
    EZV = "Berezovo"
    FAA = "Faranah"
    FAB = "Farnborough"
    FAC = "Faaite"
    FAE = "Vagar Airport"
    FAF = "Felker AAF"
    FAG = "Fagurholsmyri"
    FAH = "Farah"
    FAI = "Fairbanks International Airport"
    FAJ = "Diego Jimenez Torres"
    FAK = "False Island"
    FAL = "Falcon State"
    FAM = "Regional"
    FAO = "Faro Airport"
    FAQ = "Freida River"
    FAR = "Hector International Airport"
    FAS = "Faskrudsfjordur"
    FAT = "Fresno Yosemite International Airport"
    FAU = "Fahud"
    FAV = "Fakarava Airport"
    FAY = "Fayetteville Regional Airport"
    FAZ = "Fasa"
    FBA = "Fonte Boa"
    FBD = "Faizabad Airport"
    FBE = "Francisco Beltrao"
    FBG = "Simmons AAF"
    FBK = "Ft Wainwright"
    FBL = "Municipal"
    FBM = "Lubumbashi International Airport"
    FBR = "Fort Bridger"
    FBS = "Friday Harbor SPB"
    FBY = "Municipal"
    FCA = "Glacier Park International Airport"
    FCB = "Ficksburg Sentra Oes"
    FCH = "Fresno-Chandler"
    FCM = "Flying Cloud Airport"
    FCN = "Cuxhaven/Nordholz"
    FCO = "Leonardo da Vinci-Fiumicino Airport"
    FCS = "Butts AAF"
    FCT = "Firing Center AAF"
    FCY = "Municipal"
    FDE = "Bringeland Airport"
    FDF = "Martinique Aime Cesaire International Airport"
    FDH = "Friedrichshafen Airport"
    FDK = "Frederick Municipal"
    FDR = "Municipal"
    FDU = "Bandundu"
    FDY = "Findlay"
    FEA = "Fetlar"
    FEB = "Sanfebagar"
    FEC = "Feira De Santana"
    FEG = "Fergana Airport"
    FEJ = "Feijo"
    FEK = "Ferkessedougou"
    FEL = "Fuerstenfeldbruck"
    FEN = "Fernando De Noronha Airport"
    FEP = "Albertus"
    FES = "San Fernando"
    FET = "Municipal"
    FEW = "Warren AFB"
    FEZ = "Fes-Saiss Airport"
    FFA = "First Flight"
    FFD = "Fairford RAF Station"
    FFL = "Municipal"
    FFM = "Fergus Falls"
    FFO = "Patterson AFB"
    FFT = "Capital City"
    FFU = "Futaleufu"
    FGD = "Fderik"
    FGI = "Fagali I Airport"
    FGL = "Fox Glacier"
    FGR = "Fuengirola"
    FGU = "Fangatau"
    FHU = "Municipal"
    FHZ = "Fakahina"
    FIC = "Fire Cove"
    FID = "Elizabeth Field"
    FIE = "Fair Isle"
    FIG = "Fria"
    FIH = "N'djili Airport"
    FIK = "Finke"
    FIL = "Municipal"
    FIN = "Finschhafen"
    FIV = "Five Finger"
    FIZ = "Fitzroy Crossing"
    FJR = "Al-Fujairah International"
    FKB = "Baden-Airpark"
    FKI = "Bangoka International Airport"
    FKJ = "Fukui"
    FKL = "Venango Regional Airport"
    FKN = "Municipal"
    FKQ = "Fak Fak Airport"
    FKS = "Fukushima Airport"
    FLA = "Capitolio Airport"
    FLB = "Cangapara"
    FLC = "Falls Creek"
    FLD = "Fond Du Lac"
    FLE = "Fort Lee AAF"
    FLF = "Schaferhaus"
    FLG = "Flagstaff Pulliam Airport"
    FLH = "Flotta"
    FLI = "Flateyri"
    FLJ = "Falls Bay"
    FLL = "Fort Lauderdale-Hollywood International Airport"
    FLM = "Filadelfia"
    FLN = "Hercilio Luz International Airport"
    FLO = "Florence Airport"
    FLP = "Flippin"
    FLR = "Firenze-Peretola Airport"
    FLS = "Flinders Island Airport"
    FLT = "Flat"
    FLU = "Flushing"
    FLV = "Sherman AAF"
    FLW = "Santa Cruz Airport"
    FLX = "Municipal"
    FLY = "Finley"
    FLZ = "Ferdinand Lumban Tobing Airport"
    FMA = "El Pucu Airport"
    FMC = "Five Mile"
    FME = "Tipton AAF"
    FMG = "Flamingo"
    FMH = "Otis AFB"
    FMI = "Kalemie Airport"
    FMM = "Memmingen Allgau Airport"
    FMN = "Four Corners Regional Airport"
    FMO = "Munster Osnabruck International Airport"
    FMS = "Municipal"
    FMU = "Florence Municipal"
    FMY = "Page Field"
    FNA = "Lungi International Airport"
    FNB = "Neubrandenburg"
    FNC = "Madeira Airport"
    FND = "Funadhoo Airport"
    FNE = "Fane"
    FNG = "Fada Ngourma"
    FNH = "Fincha"
    FNI = "Garons Airport"
    FNJ = "Pyongyang Sunan International Airport"
    FNK = "Fin Creek"
    FNL = "Municipalcipal Airport"
    FNR = "SPB"
    FNT = "Bishop International Airport"
    FNU = "Fenosu"
    FOA = "Foula"
    FOB = "Fort Bragg"
    FOC = "Changle International Airport"
    FOD = "Fort Dodge Airport"
    FOE = "Forbes Field"
    FOG = "Gino Lisa"
    FOK = "Suffolk County"
    FOM = "Foumban"
    FON = "Fortuna Airport"
    FOO = "Numfoor"
    FOP = "Morris AAF"
    FOR = "Pinto Martins Airport"
    FOS = "Forrest"
    FOT = "Forster"
    FOU = "Fougamou"
    FOX = "Fox"
    FOY = "Foya"
    FPO = "Grand Bahama International Airport"
    FPR = "St Lucie County"
    FPY = "Perry-Foley"
    FRA = "Frankfurt Airport"
    FRB = "Forbes"
    FRC = "Franca"
    FRD = "Friday Harbor Airport"
    FRE = "Fera Island Airport"
    FRG = "Republic Field"
    FRH = "Municipal"
    FRI = "Marshall AAF"
    FRK = "Fregate Island"
    FRL = "Luigi Ridolfi"
    FRM = "Fairmont"
    FRN = "Bryant AAF"
    FRO = "Flora Airport"
    FRP = "Fresh Water Bay"
    FRQ = "Feramin"
    FRR = "Front Royal-Warren County"
    FRS = "Santa Elena Airport"
    FRT = "Frutillar"
    FRU = "Manas International Airport"
    FRW = "Francistown Airport"
    FRY = "Fryeburg"
    FRZ = "Fritzlar Airbase"
    FSC = "Sud Corse Airport"
    FSD = "Sioux Falls Regional Airport (Joe Foss Field)"
    FSI = "Henry Post AAF"
    FSK = "Municipal"
    FSL = "Fossil Downs"
    FSM = "Fort Smith Regional Airport"
    FSN = "Haley AAF"
    FSP = "Saint Pierre Airport"
    FSS = "Kinloss"
    FST = "Pecos County"
    FSU = "Fort Sumner"
    FSZ = "Shizuoka Airport"
    FTA = "Futuna Airport"
    FTE = "El Calafate Airport"
    FTI = "Fitiuta"
    FTK = "Godman AAF"
    FTL = "Fortuna Ledge"
    FTU = "Marillac Airport"
    FTW = "Meacham Field"
    FTX = "Owando"
    FTY = "Fulton County"
    FUB = "Fulleborn"
    FUE = "Fuerteventura Airport"
    FUG = "Fuyang Airport"
    FUJ = "Fukue Airport"
    FUK = "Fukuoka Airport"
    FUL = "Municipal"
    FUM = "Fuma"
    FUN = "Funafuti Atol International Airport"
    FUO = "Fuoshan Airport"
    FUT = "Futuna Island"
    FVL = "Flora Valey"
    FVM = "Fumawula"
    FVR = "Forrest River Airport"
    FWA = "Fort Wayne International Airport"
    FWH = "Fort Worth NAS Jrb/Carswell Field"
    FWL = "Farewell"
    FWM = "Heliport"
    FXE = "Fort Lauderdale Executive Airport"
    FXM = "Flaxman Island"
    FXO = "Cuamba"
    FXY = "Municipal"
    FYJ = "Fuyuan Dongji Airport"
    FYM = "Municipal"
    FYN = "Fuyun Koktokay Airport"
    FYT = "Faya"
    FYU = "Fort Yukon Airport"
    FYV = "Municipal (Drake Field)"
    FZL = "Fuzuli International Airport"
    FZO = "Filton"
    GAA = "Guamal"
    GAB = "Gabbs"
    GAC = "Gracias"
    GAD = "Municipal"
    GAE = "Gabès Matmata International Airport"
    GAF = "Gafsa"
    GAG = "Gage"
    GAH = "Gayndah"
    GAI = "Montgomery County"
    GAJ = "Junmachi Airport"
    GAK = "Gakona"
    GAL = "Edward G. Pitka Sr. Airport"
    GAM = "Gambell Airport"
    GAN = "Gan/Seenu Airport"
    GAO = "Los Canos Airport"
    GAP = "Gusap"
    GAQ = "Gao"
    GAR = "Garaina"
    GAS = "Garissa"
    GAT = "Tallard"
    GAU = "Lokpriya Gopinath Bordoloi International Airport"
    GAV = "Gag Island"
    GAW = "Gangaw"
    GAX = "Gamba"
    GAY = "Gaya Airport"
    GAZ = "Guasopa"
    GBA = "Big Bay"
    GBB = "Gabala International Airport"
    GBC = "Gasuke"
    GBD = "Great Bend"
    GBE = "Sir Seretse Khama International Airport"
    GBF = "Negarbo"
    GBG = "Galesburg"
    GBH = "Galbraith Lake"
    GBI = "Auxiliary Airfield"
    GBJ = "Les Bases"
    GBK = "Gbangbatok"
    GBL = "Goulburn Island"
    GBM = "Garbaharey"
    GBN = "San Giovanni Rotondo"
    GBO = "Baltimore Greenbelt T"
    GBP = "Gamboola"
    GBR = "Walter J. Koladza Airport"
    GBS = "Port Fitzroy"
    GBT = "Gorgon Airport"
    GBU = "Khashm El Girba"
    GBV = "Gibb River"
    GBW = "Ginbata Airport"
    GBZ = "Great Barrier Island"
    GCA = "Guacamaya"
    GCC = "Campbell County Airport"
    GCD = "Grand Coulee Dam"
    GCH = "Gachsaran"
    GCI = "Guernsey Airport"
    GCJ = "Grand Central"
    GCK = "Garden City Municipal Airport"
    GCM = "Owen Roberts International Airport"
    GCN = "National Park"
    GCT = "Grand Canyon Bar 10 Airport"
    GCV = "Gravatai"
    GCW = "Grand Canyon West"
    GCY = "Municipal"
    GDA = "Gounda"
    GDB = "Gondia Airport"
    GDC = "Donaldson Center"
    GDD = "Gordon Downs"
    GDE = "Gode/Iddidole Airport"
    GDG = "Magdagachi"
    GDH = "Golden Horn Lodge SPB"
    GDI = "Gordil"
    GDJ = "Gandajika"
    GDL = "Don Miguel Hidal Y Costilla International Airport"
    GDM = "Municipal"
    GDN = "Gdansk Lech Walesa Airport"
    GDO = "Vare Maria"
    GDP = "Guadalupe"
    GDQ = "Gondar Airport"
    GDR = "Angra dos Reis Airport"
    GDT = "Grand Turk Island"
    GDV = "Dawson Community Airport"
    GDW = "Gladwin"
    GDX = "Magadan Airport"
    GDZ = "Gelendzik Airport"
    GEA = "Noumea Magenta Airport"
    GEB = "Gebe"
    GEC = "Gecitkale"
    GED = "Sussex County"
    GEE = "George Town"
    GEF = "Geva Airstrip"
    GEG = "Spokane International Airport"
    GEI = "Green Islands"
    GEK = "Ganes Creek"
    GEL = "Sepe Tiaraju"
    GEM = "President Obiang Nguema International Airport"
    GEN = "Oslo Gardermoen Airport"
    GEO = "Cheddi Jagan International Airport"
    GER = "Rafael Cabrera Airport"
    GES = "General Santos International Airport"
    GET = "Geraldton Airport"
    GEV = "Gallivare Airport"
    GEW = "Gewoia"
    GEX = "Geelong"
    GEY = "South Big Horn County"
    GFA = "Malmstrom AFB"
    GFB = "Togiak Fish"
    GFD = "Pope Field"
    GFE = "Grenfell"
    GFF = "Griffith Airport"
    GFK = "Grand Forks International Airport"
    GFL = "Warren County"
    GFN = "Grafton Airport"
    GFO = "Bartica"
    GFR = "Granville"
    GFY = "Grootfontein"
    GGB = "Água Boa"
    GGC = "Lumbala"
    GGD = "Gregory Downs"
    GGE = "Georgetown"
    GGF = "Almeirim"
    GGG = "Gregg County Airport"
    GGH = "Gastão Mesquita Airport"
    GGJ = "Guaíra Airport"
    GGL = "Gilgal"
    GGM = "Kakamega Airport"
    GGN = "Gagnoa"
    GGO = "Guiglo"
    GGR = "Garoe"
    GGS = "Gobernador Gregores"
    GGT = "Exuma International Airport"
    GGW = "Glasgow International Airport"
    GHA = "Noumerate Airport"
    GHB = "Governor's Harbour Airport"
    GHC = "Great Harbour"
    GHE = "Garachine"
    GHF = "Giebelstadt"
    GHK = "Gahcho Kue Aerodrome"
    GHM = "Municipal"
    GHN = "Guanghan"
    GHS = "Melak Airport"
    GHT = "Ghat"
    GHU = "Gualeguaychu"
    GIB = "North Front Airport"
    GIC = "Boigu Island"
    GID = "Gitega"
    GIF = "Gilbert Field"
    GIG = "Galeao Antonio Carlos Jobim International Airport"
    GII = "Siguiri"
    GIL = "Gilgit Airport"
    GIM = "Miele Mimbale"
    GIR = "Girardot"
    GIS = "Gisborne Airport"
    GIT = "Geita"
    GIU = "Sigiriya Slaf Base"
    GIY = "Giyani"
    GIZ = "Jazan Regional Airport"
    GJA = "Guanaja"
    GJL = "Jijel Ferhat Abbas Airport"
    GJM = "Guajara-Mirim"
    GJR = "Gjogur"
    GJT = "Grand Junction Regional Airport"
    GKA = "Goroka Airport"
    GKD = "Gokceada"
    GKE = "Geilenkirchen"
    GKH = "Gorkha"
    GKK = "Kooddoo Airport"
    GKL = "Great Keppel Island"
    GKN = "Gulkana"
    GKO = "Kongoboumba"
    GKT = "Gatlinburg"
    GLA = "Glasgow International Airport"
    GLB = "San Calos Apache"
    GLC = "Geladi"
    GLD = "Renner Field"
    GLE = "Municipal"
    GLF = "Golfito Airport"
    GLG = "Glengyle"
    GLH = "Greenville Airport"
    GLI = "Glen Innes"
    GLK = "Galcaio"
    GLL = "Klanten Airport"
    GLM = "Glenormiston"
    GLN = "Goulimime Airport"
    GLO = "Gloucestershire"
    GLP = "Gulgubip"
    GLQ = "Glennallen"
    GLR = "Otsego County"
    GLS = "Scholes Field"
    GLT = "Gladstone Airport"
    GLU = "Gelephu Airport"
    GLV = "Golovin Airport"
    GLW = "Municipal"
    GLX = "Galela"
    GLY = "Goldsworthy"
    GLZ = "Gilze-Rijen"
    GMA = "Gemena"
    GMB = "Gambela Airport"
    GMC = "Guerima"
    GMD = "Ben Slimane"
    GME = "Gomel Airport"
    GMI = "Gasmata Island"
    GMM = "Gamboma"
    GMN = "Greymouth"
    GMO = "Gombe Lawanti International Airport"
    GMP = "Gimpo International Airport"
    GMQ = "Golog Maqin Airport"
    GMR = "Gambier Island"
    GMS = "Guimaraes"
    GMT = "Granite Mountain"
    GMU = "Greenville Downtown"
    GMV = "Monument Valley"
    GMZ = "La Gomera Airport"
    GNA = "Grodno Airport"
    GNB = "Grenoble-Isere Airport"
    GND = "Maurice Bishop International Airport"
    GNF = "Gansner Field"
    GNG = "Gooding"
    GNI = "Green Island"
    GNJ = "Ganja International Airport"
    GNM = "Guanambi"
    GNN = "Ghinnir"
    GNR = "General Roca"
    GNS = "Gunungsitoli Airport"
    GNT = "Milan"
    GNU = "Goodnews Bay"
    GNV = "Gainesville Regional Airport"
    GNY = "Sanliurfa GAP Airport"
    GNZ = "Ghanzi"
    GOA = "Genoa Cristoforo Colombo Airport"
    GOB = "Goba"
    GOC = "Gora"
    GOE = "Gonalia"
    GOF = "Goodfellow AFB"
    GOG = "Gobabis"
    GOH = "Nuuk Airport"
    GOI = "Dabolim Airport"
    GOJ = "Nizhny Novgorod International Airport"
    GOK = "Guthrie"
    GOL = "State"
    GOM = "Goma Airport"
    GON = "New London"
    GOO = "Goondiwindi"
    GOP = "Gorakhpur Airport"
    GOQ = "Golmud Airport"
    GOR = "Gore"
    GOS = "Gosford"
    GOT = "Goteborg Landvetter Airport"
    GOU = "Garoua Airport"
    GOV = "Nhulunbuy Airport"
    GOX = "Mopa Airport"
    GOY = "Amparai"
    GOZ = "Gorna Oriahovitsa"
    GPA = "Araxos Airport"
    GPB = "Tancredo Thomaz Faria"
    GPD = "Mount Gordon Mine"
    GPI = "Guapi Airport"
    GPL = "Guapiles"
    GPN = "Garden Point"
    GPO = "General Pico"
    GPS = "Baltra Airport"
    GPT = "Gulfport-Biloxi International Airport"
    GPZ = "Grand Rapids"
    GQQ = "Galion"
    GRA = "Gamarra"
    GRB = "Austin Straubel International Airport"
    GRC = "Grand Cess"
    GRD = "Greenwood"
    GRE = "Municipal"
    GRF = "Gray AAF"
    GRG = "Gardez"
    GRH = "Garuahi"
    GRI = "Grand Island Airport"
    GRJ = "George Airport"
    GRK = "Robert Gray Army Airfield"
    GRL = "Garasa"
    GRM = "Devils Track"
    GRN = "Gordon"
    GRO = "Girona-Costa Brava Airport"
    GRP = "Gurupi"
    GRQ = "Eelde Airport"
    GRR = "Gerald R. Ford International Airport"
    GRS = "Baccarini"
    GRT = "Gujrat"
    GRU = "Sao Paulo-Guarulhos International Airport"
    GRV = "Groznyy Airport"
    GRW = "Graciosa Island Airport"
    GRX = "Granada Airport"
    GRY = "Grimsey"
    GRZ = "Graz Airport"
    GSA = "Long Pasia"
    GSB = "Seymour Johnson AFB"
    GSC = "Gascoyne Junction"
    GSE = "Gothenburg City Airport"
    GSH = "Goshen"
    GSI = "Guadalcanal"
    GSJ = "Puerto San Jose"
    GSL = "Taltheilei Narrows"
    GSM = "Dayrestan Airport"
    GSN = "Mount Gunson"
    GSO = "Piedmont Triad International Airport"
    GSP = "Greenville-Spartanburg International Airport"
    GSQ = "Shark Elowainat"
    GSR = "Gardo"
    GSS = "Sabi Sabi"
    GST = "Gustavus Airport"
    GSU = "Gedaref"
    GSV = "Saratov Gagarin Airport"
    GSY = "Binbrook"
    GTA = "Gatokae Aerodrom"
    GTB = "Genting"
    GTC = "Green Turtle"
    GTE = "Alyangula Airport"
    GTF = "Great Falls International Airport"
    GTG = "Municipal"
    GTI = "Guettin"
    GTK = "Sungei Tekai"
    GTN = "Glentanner"
    GTO = "Tolotio Airport"
    GTP = "Grants Pass"
    GTR = "Golden Triangle Regional Airport"
    GTS = "Granites"
    GTT = "Georgetown Airport"
    GTW = "Holesov"
    GTY = "Gettysburg"
    GTZ = "Kirawira B"
    GUA = "La Aurora International Airport"
    GUB = "Guerrero Negro"
    GUC = "Gunnison Airport"
    GUD = "Goundam"
    GUE = "Guriaso"
    GUF = "Edwards"
    GUG = "Guari"
    GUH = "Gunnedah"
    GUI = "Guiria"
    GUJ = "Guaratingueta"
    GUL = "Goulburn"
    GUM = "A.B. Won Pat International Airport"
    GUN = "Gunter AFB"
    GUO = "Gualaco"
    GUP = "Senator Clark"
    GUQ = "Guanare"
    GUR = "Gurney Airport"
    GUS = "Grissom AFB"
    GUT = "Guetersloh"
    GUU = "Grundarfjordur"
    GUV = "Mougulu"
    GUW = "Atyrau Airport"
    GUX = "Guna"
    GUY = "Guymon"
    GUZ = "Guarapari"
    GVA = "Geneve Airport"
    GVE = "Municipal"
    GVI = "Green River"
    GVL = "Lee Gilmer Memorial"
    GVN = "May-Gatka"
    GVP = "Greenvale"
    GVR = "Governador Valadares Airport"
    GVT = "Majors Field"
    GVW = "Richards-Gebaur"
    GVX = "Sandviken"
    GWA = "Gwa"
    GWD = "Gwadar Airport"
    GWE = "Gweru"
    GWL = "Gwalior Airport"
    GWN = "Gnarowein"
    GWO = "Leflore"
    GWS = "Glenwood Springs"
    GWT = "Westerland - Sylt Airport"
    GWV = "Glendale"
    GWY = "Carnmore"
    GXA = "Beringin Airport"
    GXF = "Seiyun"
    GXG = "Negage"
    GXH = "Gannan Xiahe Airport"
    GXQ = "Ten. Vidal"
    GXX = "Yagoua"
    GXY = "Weld County"
    GYA = "Guayaramerin Airport"
    GYB = "Wodgina Airport"
    GYD = "Heydar Aliyev International Airport"
    GYE = "Jose Joaquin de Olmedo Airport"
    GYG = "Magan Airport"
    GYI = "Gisenyi"
    GYL = "Argyle"
    GYM = "Gen Jose M Yanez"
    GYN = "Santa Genoveva Airport"
    GYO = "Bandar Udara Senubung"
    GYP = "Gympie"
    GYR = "Litchfield"
    GYS = "Guang Yuan Airport"
    GYU = "Guyuan Liupanshan Airport"
    GYY = "Gary/Chicago International"
    GYZ = "Gruyere Mine Airport"
    GZA = "Gaza - Yaser Arafat International Airport"
    GZG = "Garze Gesar Airport"
    GZI = "Ghazni"
    GZM = "Gozo Heliport"
    GZO = "Gizo Airport"
    GZP = "Gazipasa Airport"
    GZT = "Gaziantep Airport"
    GZW = "Ghazvin"
    HAA = "Hasvik Airport"
    HAB = "Marion County"
    HAC = "Hachijo Jima Airport"
    HAD = "Halmstad Airport"
    HAE = "Havasupai"
    HAF = "Half Moon"
    HAH = "Prince Said Ibrahim Internatonal Airport"
    HAI = "Dr Haines"
    HAJ = "Hannover Airport"
    HAK = "Haikou Airport"
    HAL = "Halali"
    HAM = "Hamburg Airport"
    HAN = "Noi Bai International Airport"
    HAO = "Hamilton"
    HAP = "Long Island"
    HAQ = "Hanimaadhoo Airport"
    HAR = "Capital City"
    HAS = "Hail Airport"
    HAT = "Heathlands"
    HAU = "Haugesund Airport"
    HAV = "Jose Marti International Airport"
    HAW = "Haverfordwest"
    HAX = "Hatbox Field"
    HAY = "Haycock"
    HAZ = "Hatzfeldthaven"
    HBA = "Hobart International Airport"
    HBB = "Industrial Airpark"
    HBC = "Hanus Bay"
    HBD = "Habi"
    HBE = "Borg El Arab Airport"
    HBG = "The Hattiesburg-Bobby L. Chain Mun."
    HBH = "Hobart Bay"
    HBI = "Harbour Island"
    HBK = "Holbrook Municipal"
    HBN = "Flamingo"
    HBO = "Municipal"
    HBQ = "Qilian Airport"
    HBR = "Hobart"
    HBT = "Hafr Albatin"
    HBU = "Bulgan Hovd"
    HBX = "Hubli Airport"
    HCA = "Howard County"
    HCB = "Shoal Cove"
    HCC = "Columbia County"
    HCJ = "Hechi Jinchengjiang Airport"
    HCM = "Eil"
    HCN = "Hengchun"
    HCQ = "Halls Creek"
    HCR = "Holy Cross Airport"
    HCW = "Cheraw"
    HCZ = "Chenzhou Beihu Airport"
    HDA = "Hidden Falls"
    HDB = "Airfield Heidelberg"
    HDD = "Hyderabad"
    HDE = "Brewster Field"
    HDF = "Heringsdorf Airport"
    HDG = "Handan Airport"
    HDH = "Dillingham Airfield"
    HDK = "Kulhudhuffushi Airport"
    HDM = "Hamadan Airport"
    HDN = "Yampa Valley Airport"
    HDR = "Havadarya"
    HDS = "Hoedspruit Airport"
    HDY = "Hat Yai International Airport"
    HEA = "Herat International Airport"
    HEB = "Henzada"
    HED = "Herendeen"
    HEE = "Thompson-Robbins"
    HEH = "Heho Airport"
    HEI = "Heide-Buesum"
    HEK = "Heihe Airport"
    HEL = "Helsinki-Vantaa Airport"
    HEM = "Helsinki-malmi"
    HEN = "Hendon"
    HEO = "Haelogo"
    HER = "Heraklion Airport"
    HES = "State"
    HET = "Hohhot Baita International Airport"
    HEV = "Huelva"
    HEW = "Hengdian Airport"
    HEX = "Santo Domingo Herrera"
    HEY = "Hanchey Army Heliport"
    HEZ = "Hardy-Anders"
    HFA = "Haifa Airport"
    HFD = "Brainard"
    HFE = "Hefei Xinqiao Airport"
    HFF = "Mackall AAF"
    HFN = "Hornafjordur"
    HFS = "Hagfors Airport"
    HFT = "Hammerfest Airport"
    HGA = "Hargeisa Airport"
    HGD = "Hughenden"
    HGE = "Higuerote Airport"
    HGH = "Hangzhou Xiaoshan International Airport"
    HGI = "Higlieg"
    HGL = "Helgoland"
    HGN = "Mae Hong Son Airport"
    HGO = "Korhogo Airport"
    HGR = "Wash. County Regional Airport"
    HGS = "Hastings"
    HGT = "Hunter AAF"
    HGU = "Mount Hagen Airport"
    HGZ = "Hogatza"
    HHE = "Hachinohe"
    HHH = "Hilton Head Airport"
    HHI = "Wheeler AFB"
    HHN = "Frankfurt - Hahn Airport"
    HHP = "H K Heliport"
    HHQ = "Hua Hin Airport"
    HHR = "Hawthorne"
    HHZ = "Hikueru"
    HIA = "Huai'an Lianshui Airport"
    HIB = "Chisholm Airport"
    HID = "Horn Island Airport"
    HIE = "Regional"
    HIF = "Hill AFB"
    HIG = "Highbury"
    HIH = "Hook Island"
    HII = "Municipal"
    HIJ = "Hiroshima Airport"
    HIK = "Hickam AFB"
    HIL = "Shillavo"
    HIM = "Hingurakgoda"
    HIN = "Sacheon Airport"
    HIO = "Portland"
    HIP = "Headingly"
    HIR = "Honiara International Airport"
    HIS = "Hayman Island"
    HIT = "Haivaro"
    HIW = "Hiroshima West"
    HJJ = "Zhijiang Airport"
    HJR = "Khajuraho Airport"
    HJT = "Khujirt"
    HKA = "Municipal"
    HKB = "Healy Lake"
    HKD = "Hakodate Airport"
    HKG = "Hong Kong International Airport"
    HKK = "Hokitika Airport"
    HKN = "Hoskins Airport"
    HKR = "Mara North Airstrip"
    HKS = "Hawkins Field"
    HKT = "Phuket International Airport"
    HKV = "Haskovo"
    HKY = "Hickory"
    HLA = "Lanseria International Airport"
    HLB = "Hillenbrand"
    HLC = "Hill City"
    HLD = "Hulunbuir Hailar Airport"
    HLE = "Saint Helena Airport"
    HLF = "Hultsfred - Vimmerby"
    HLG = "Ohio County"
    HLH = "Ulanhot Airport"
    HLI = "Hollister"
    HLJ = "Beidahuang General Airport"
    HLL = "Hillside"
    HLM = "Park Township"
    HLN = "Helena Regional Airport"
    HLP = "Halim Perdanakusuma Airport"
    HLR = "Fort Hood AAF"
    HLS = "St Helens"
    HLT = "Hamilton"
    HLU = "Houailou"
    HLV = "Helenvale"
    HLW = "Hluhluwe"
    HLY = "Anglesey Airport"
    HLZ = "Hamilton International Airport"
    HMA = "Khanty-Mansiysk Airport"
    HMB = "Mubarak International Airport"
    HME = "Oued Irara Airport"
    HMG = "Hermannsburg"
    HMI = "Hami Airport"
    HMJ = "Khmelnitskiy"
    HMN = "Holloman AFB"
    HMO = "Gen Pesqueira Garcia Airport"
    HMR = "Hamar Airport"
    HMS = "Homeshore"
    HMT = "Ryan Field"
    HMV = "Hemavan Airport"
    HMY = "Seosan Airport"
    HNA = "Hanamaki Airport"
    HNB = "Municipal"
    HNC = "Hatteras"
    HND = "Haneda Airport"
    HNE = "Tahneta Pass"
    HNG = "Hienghene"
    HNH = "Hoonah Airport"
    HNI = "Heiweni"
    HNL = "Honolulu International Airport"
    HNM = "Hana Airport"
    HNN = "Honinabi"
    HNS = "Haines Municipal Airport"
    HNX = "Hanna"
    HNY = "Hengyang Nanyue Airport"
    HOA = "Hola"
    HOB = "Lea County Airport"
    HOC = "Komako"
    HOD = "Hodeidah Airport"
    HOE = "Houeisay"
    HOF = "Al-Ahsa Airport"
    HOG = "Frank Pais Airport"
    HOH = "Hohenems-Dornbirn"
    HOI = "Hao Island"
    HOK = "Hooker Creek"
    HOL = "Holikachu"
    HOM = "Homer Airport"
    HON = "Howes"
    HOO = "Nhon Co"
    HOP = "Campbell AAF"
    HOQ = "Hof"
    HOR = "Horta Airport"
    HOS = "Oscar Reguera"
    HOT = "Memorial Field"
    HOU = "William P. Hobby Airport"
    HOV = "Hovden Airport"
    HOW = "Howard AFB"
    HOX = "Homalin Airport"
    HOY = "Hoy Island"
    HPA = "Salote Pilolevu"
    HPB = "Hooper Bay Airport"
    HPE = "Hope Vale"
    HPG = "Shennongjia Hongping Airport"
    HPH = "Cat Bi International Airport"
    HPN = "Westchester County Airport"
    HPT = "Municipal"
    HPV = "Princeville"
    HPY = "Baytown Airport"
    HQL = "Tashkurgan Airport"
    HQM = "Bowerman"
    HRA = "Mansehra"
    HRB = "Harbin Taiping International Airport"
    HRC = "Zhairem"
    HRE = "Harare International Airport"
    HRF = "Hoarafushi Airport"
    HRG = "Hurghada International Airport"
    HRI = "Mattala Rajapaksa International Airport"
    HRJ = "Chaurjhari"
    HRK = "Kharkov Airport"
    HRL = "Valley International Airport"
    HRM = "Tilrempt"
    HRN = "Heliport"
    HRO = "Boone County Airport"
    HRR = "Herrera"
    HRS = "Harrismith Airport"
    HRT = "Linton-On-Ouse"
    HRY = "Henbury"
    HRZ = "Horizontina"
    HSA = "Hazret Sultan International Airport"
    HSB = "Raleigh"
    HSC = "Shaoguan"
    HSF = "Suifenhe Dongning Airport"
    HSG = "Saga Airport"
    HSH = "Henderson Executive"
    HSI = "Hastings"
    HSJ = "Shangjie Airport"
    HSK = "Huesca-Pirineos"
    HSL = "Huslia Airport"
    HSM = "Horsham"
    HSN = "Putuoshan Airport"
    HSP = "Ingalls Field"
    HSS = "Hissar"
    HST = "AFB"
    HSV = "Huntsville International Airport"
    HSZ = "Hsinchu"
    HTA = "Chita Airport"
    HTB = "Terre-de-Bas"
    HTG = "Hatanga Airport"
    HTH = "Hawthorne"
    HTI = "Hamilton Island Airport"
    HTL = "Roscommon County"
    HTM = "Khatgal"
    HTN = "Hotan Airport"
    HTO = "East Hampton"
    HTR = "Hateruma"
    HTS = "Tri-State/Milton Airport"
    HTT = "Huatugou Airport"
    HTU = "Hopetoun"
    HTV = "Huntsville"
    HTW = "Lawrence County Airpark"
    HTY = "Hatay Airport"
    HTZ = "Hato Corozal"
    HUA = "Redstone AAF"
    HUB = "Humbert River"
    HUC = "Humacao Airport"
    HUD = "Humboldt"
    HUE = "Humera Airport"
    HUF = "Hulman Field"
    HUG = "Huehuetenango"
    HUH = "Huahine Airport"
    HUI = "Phu Bai International Airport"
    HUJ = "Hugo"
    HUK = "Hukuntsi"
    HUL = "International"
    HUM = "Terrebonne"
    HUN = "Hualien Airport"
    HUO = "Holingol Huolinhe Airport"
    HUQ = "Houn"
    HUS = "Hughes Municipal Airport"
    HUT = "Hutchinson"
    HUU = "Huanuco Airport"
    HUV = "Hudiksvall"
    HUW = "Humaita"
    HUX = "Huatulco Airport"
    HUY = "Humberside Airport"
    HUZ = "Huizhou Airport"
    HVA = "Analalava"
    HVB = "Hervey Bay Airport"
    HVD = "Khovd Airport"
    HVE = "Intermediate"
    HVG = "Valan Airport"
    HVK = "Holmavik"
    HVN = "New Haven Airport"
    HVR = "Havre City County Airport"
    HVS = "Municipal"
    HWA = "Hawabango"
    HWD = "Hayward Executive Airport"
    HWI = "SPB"
    HWK = "Wilpena Pound"
    HWN = "Hwange Nat Park"
    HWO = "North Perry"
    HXD = "Delingha Airport"
    HXX = "Hay"
    HYA = "Barnstable Municipal Airport"
    HYC = "High Wycombe"
    HYD = "Rajiv Gandhi International Airport"
    HYF = "Hayfields"
    HYG = "Hydaburg Sea Plane Base"
    HYL = "SPB"
    HYN = "Luqiao Airport"
    HYR = "Municipal"
    HYS = "Hays Municipal Airport"
    HYV = "Hyvinkaa"
    HZA = "Establecimiento El Araza Airport"
    HZB = "Merville/Calonne"
    HZG = "Hanzhong Airport"
    HZH = "Liping Airport"
    HZK = "Husavik"
    HZL = "Hazleton"
    HZP = "Horizon"
    HZU = "Chengdu Huaizhou Airport"
    HZV = "Hazyview"
    IAA = "Igarka Airport"
    IAB = "Mcconnell AFB"
    IAD = "Washington Dulles International Airport"
    IAG = "Niagara Falls International Airport"
    IAH = "George Bush Intercontinental Airport"
    IAM = "In Amenas Airport"
    IAN = "Bob Baker Memorial Airport"
    IAO = "Sayak (Siargao)"
    IAQ = "Bahregan"
    IAR = "Tunoshna Airport"
    IAS = "Iasi Airport"
    IAU = "Iaura"
    IBA = "Ibadan Airport"
    IBB = "General Villamil"
    IBE = "Ibague Airport"
    IBI = "Iboki"
    IBL = "Indigo Bay Lodge"
    IBM = "Iron Bridge Mine Airport"
    IBO = "Ibo"
    IBP = "Iberia"
    IBR = "Ibaraki Airport"
    IBZ = "Ibiza Airport"
    ICA = "Icabaru"
    ICC = "Andrés Miguel Salazar Marcano Airport"
    ICI = "Cicia"
    ICK = "Nieuw Nickerie"
    ICL = "Municipal"
    ICN = "Incheon International Airport"
    ICO = "Sicogon Island"
    ICR = "Nicaro"
    ICS = "Cascade"
    ICT = "Wichita Dwight D. Eisenhower National Airport"
    ICY = "Icy Bay"
    IDA = "Idaho Falls Regional Airport"
    IDB = "Idre"
    IDC = "Ila Da Chilonzuene"
    IDF = "Idiofa"
    IDG = "Municipal"
    IDH = "Idaho County"
    IDI = "ndiana County Airport (Jimmy Stewart Field)"
    IDK = "Indulkana"
    IDN = "Indagen"
    IDO = "Rio"
    IDP = "Independence"
    IDR = "Devi Ahilya Bai Holkar Airport"
    IDY = "Ile d'Yeu"
    IEG = "Zielona Gora-Babimost Airport"
    IEJ = "Iejima"
    IES = "Riesa"
    IEV = "Kyiv International Airport"
    IFA = "Iowa Falls"
    IFF = "Iffley"
    IFH = "Hesa"
    IFJ = "Isafjordur Airport"
    IFL = "Innisfail"
    IFN = "Isfahan International Airport"
    IFO = "Ivano-Frankovsk Airport"
    IFP = "Laughlin Bullhead International Airport"
    IFU = "Ifuru Airport"
    IGA = "Inagua Airport"
    IGB = "Ingeniero Jacobacci"
    IGD = "Igdir"
    IGE = "Iguela"
    IGG = "Igiugig Airport"
    IGH = "Ingham"
    IGL = "Cigli AB"
    IGM = "Kingman"
    IGN = "Maria Cristina"
    IGO = "Chigorodo"
    IGR = "Cataratas del Iguazu International Airport"
    IGS = "Ingolstadt-manching"
    IGT = "Magas Airport"
    IGU = "Cataratas International Airport"
    IHA = "Niihama"
    IHC = "Inhaca"
    IHN = "Qishn"
    IHO = "Ihosy"
    IHR = "Iran Shahr"
    IHU = "Ihu"
    IIA = "Inishmaan"
    IIL = "Ilaam Airport"
    IIN = "Nishinoomote"
    IIS = "Nissan Island"
    IJK = "Izhevsk Airport"
    IJU = "J. Batista Bos Filho Airport"
    IJX = "Municipal"
    IKA = "Imam Khomeini International Airport"
    IKB = "Wilkes County"
    IKI = "Iki Airport"
    IKK = "Greater Kankakee"
    IKL = "Ikela"
    IKO = "Nikolski AFS"
    IKP = "Inkerman"
    IKS = "Tiksi Airport"
    IKT = "Irkutsk International Airport"
    IKU = "Issyk-Kul International Airport"
    ILA = "Illaga"
    ILB = "Ilha Solteira"
    ILD = "Lleida-Alguaire Airport"
    ILE = "Municipal"
    ILF = "Ilford"
    ILG = "Greater Wilmington"
    ILH = "Illis Airbase"
    ILI = "Iliamna Airport"
    ILK = "Ilaka"
    ILL = "Willmar"
    ILM = "Wilmington International Airport"
    ILN = "Clinton Field"
    ILO = "Mandurriao Airport"
    ILP = "Ile Des Pins Airport"
    ILQ = "Ilo"
    ILR = "Ilorin International Airport"
    ILS = "Ilopango International Airport"
    ILU = "Kilaguni"
    ILX = "Ileg"
    ILY = "Glenegedale Airport"
    ILZ = "Zilina"
    IMA = "Iamalele"
    IMB = "Imbaimadai"
    IMD = "Imonda"
    IMF = "Imphal Municipal Airport"
    IMG = "Inhaminga"
    IMI = "Ine Island"
    IMK = "Simikot"
    IML = "Imperial"
    IMM = "Immokalee"
    IMN = "Imane"
    IMO = "Zemio"
    IMP = "Imperatriz Airport"
    IMQ = "Maku International Airport"
    IMT = "Ford Airport"
    INA = "Inta Airport"
    INB = "Independence"
    INC = "Yinchuan Hedong International Airport"
    IND = "Indianapolis International Airport"
    INE = "Chinde"
    INF = "Newark Liberty International"
    ING = "Lago Argentino"
    INH = "Inhambane Airport"
    INI = "Nis Constantine the Great Airport"
    INJ = "Injune"
    INK = "Wink"
    INL = "Falls International Airport"
    INM = "Innamincka"
    INN = "Innsbruck Airport"
    INO = "Inongo"
    INQ = "Inisheer"
    INR = "Kincheloe AFB"
    INS = "Af Aux"
    INT = "Smith-Reynolds Airport"
    INU = "Nauru International"
    INV = "Inverness Airport"
    INW = "Winslow-Lindbergh"
    INX = "Inanwatan"
    INY = "Inyati"
    INZ = "In Salah Airport"
    IOA = "Ioannina Airport"
    IOK = "Iokea"
    IOM = "Isle of Man Airport"
    ION = "Impfondo"
    IOP = "Ioma"
    IOR = "Kilronan"
    IOS = "Ilheus/Bahia-Jorge Amado Airport"
    IOU = "Ile Ouen"
    IOW = "Iowa City"
    IPA = "Ipota"
    IPC = "Mataveri International Airport"
    IPE = "Ipil"
    IPG = "Ipiranga"
    IPH = "Ipoh Airport"
    IPI = "San Luis Airport"
    IPL = "Imperial County Airport"
    IPN = "Usiminas Airport"
    IPT = "Lycoming County Airport"
    IPU = "Ipiau"
    IPW = "Ipswich"
    IPZ = "San Isidro de El General Airport"
    IQA = "Al Asad Air Base"
    IQM = "Qiemo Airport"
    IQN = "Qingyang Airport"
    IQQ = "Diego Aracena International Airport"
    IQT = "C.F. Secada Vignetta International Airport"
    IRA = "Kirakira Airport"
    IRB = "Municipal"
    IRC = "Circle City"
    IRD = "Ishurdi"
    IRE = "Irece"
    IRG = "Lockhart River"
    IRI = "Nduli Airport"
    IRJ = "La Rioja Airport"
    IRK = "Kirksville Municipal Airport"
    IRM = "Igrim"
    IRN = "Iriona"
    IRO = "Birao"
    IRP = "Matari"
    IRS = "Kirsch Municipal"
    IRU = "Iranamadu SPB"
    IRZ = "Tapuruquara"
    ISA = "Mount Isa Airport"
    ISB = "Islamabad International Airport"
    ISC = "St Marys"
    ISD = "Iscuande"
    ISE = "Isparta Suleyman Demirel Airport"
    ISG = "Painushima Ishigaki Airport"
    ISH = "Ischia Airport"
    ISI = "Isisford"
    ISJ = "Isla Mujeres"
    ISK = "Gandhinagar Airport"
    ISL = "Istanbul Ataturk Airport"
    ISM = "Kissimmee Gateway"
    ISN = "Sloulin Field International Airport"
    ISO = "Stallings Field"
    ISP = "Long Island MacArthur Airport"
    ISQ = "Schoolcraft County"
    ISS = "Wiscasset"
    IST = "Istanbul New Airport"
    ISU = "Sulaimaniyah International Airport"
    ISW = "Alexander Field"
    ITA = "Itacoatiara"
    ITB = "Itaituba"
    ITE = "Itubera"
    ITH = "Ithaca Tompkins Regional Airport"
    ITI = "Itambacuri"
    ITK = "Itokama"
    ITM = "Itami Airport"
    ITN = "Itabuna"
    ITO = "Hilo International Airport"
    ITP = "Itaperuna"
    ITQ = "Itaqui"
    ITR = "Hidroeletrica"
    ITU = "Iturup"
    IUE = "Hanan Airport"
    IUL = "Ilu"
    IUM = "Summit Lake"
    IUP = "Lorenzo Airport"
    IUS = "Inus"
    IVA = "Ambanja"
    IVC = "Invercargill Airport"
    IVG = "Ivangrad"
    IVH = "Ivishak"
    IVI = "Isla Viveros"
    IVL = "Ivalo Airport"
    IVO = "Chivolo"
    IVR = "Inverell"
    IVW = "Inverway"
    IWA = "Ivanovo Yuzhny Airport"
    IWD = "Gogebic County Airport"
    IWJ = "Hagi-Iwami Airport"
    IWK = "Iwakuni Kintaikyo Airport"
    IWO = "Iwo Jima Airbase"
    IWS = "West Houston"
    IXA = "Agartala Airport"
    IXB = "Bagdogra Airport"
    IXC = "Chandigarh Airport"
    IXD = "Bamrauli Airport"
    IXE = "Mangalore Airport"
    IXG = "Belgaum Airport"
    IXH = "Kailashahar"
    IXI = "Lilabari Airport"
    IXJ = "Satwari Airport"
    IXK = "Keshod"
    IXL = "Leh Airport"
    IXM = "Madurai Airport"
    IXN = "Khowai"
    IXP = "Pathankot"
    IXQ = "Kamalpur"
    IXR = "Birsa Munda Airport"
    IXS = "Kumbhirgram Airport"
    IXT = "Pasighat"
    IXU = "Chikkalthana Airport"
    IXV = "Along"
    IXW = "Sonari"
    IXX = "Bidar Air Force Station"
    IXY = "Kandla"
    IXZ = "Port Blair Airport"
    IYK = "Kern County"
    IZA = "Zona da Mata Regional Airport"
    IZE = "Itzehoe/Hungriger Wolf Airport"
    IZO = "Izumo Airport"
    IZT = "Ixtepec"
    JAA = "Jalalabad"
    JAB = "Jabiru"
    JAC = "Jackson Hole Airport"
    JAD = "Jandakot"
    JAE = "Shumba Airport"
    JAF = "Kankesanturai"
    JAG = "Jacobabad"
    JAI = "Jaipur Airport"
    JAJ = "Perimeter Mall"
    JAK = "Jacmel Regional Airport"
    JAL = "Jalapa"
    JAM = "Jambol"
    JAN = "Jackson-Evers International Airport"
    JAO = "Beaver Ruin"
    JAP = "Punta Renes"
    JAQ = "Jacquinot Bay"
    JAR = "Jahrom"
    JAS = "County"
    JAT = "Jabot"
    JAU = "Jauja Airport"
    JAV = "Ilulissat Airport"
    JAW = "Aeroporto de Araripina"
    JAX = "Jacksonville International Airport"
    JBB = "Notohadinegoro Airport"
    JBC = "Boston City Heliport"
    JBK = "Berkeley"
    JBQ = "La Isabela International Airport"
    JBR = "Jonesboro Airport"
    JBS = "Hacienda Bus.Park Heliport"
    JBT = "City Landing"
    JCA = "Croisette Heliport"
    JCB = "Joacaba"
    JCC = "China Basin Heliport"
    JCD = "Downtown Heliport"
    JCE = "Convention Center Heliport"
    JCH = "Qasigiannguit"
    JCI = "New Century Aircenter Airport"
    JCJ = "Chuja Heliport"
    JCK = "Julia Creek"
    JCM = "Jacobina"
    JCN = "Incheon Heliport"
    JCO = "Heliport"
    JCR = "Jacareacanga"
    JCS = "Aeroporto De Crateus Airport"
    JCT = "Kimble County"
    JCU = "Ceuta Heliport"
    JCX = "Citicorp Plaza Heliport"
    JCY = "Johnson"
    JDA = "John Day"
    JDB = "Downtown Heliport"
    JDE = "Jiande Qiandaohu Airport"
    JDF = "Francisco De Assis"
    JDG = "Jeongseok"
    JDH = "Jodhpur Airport"
    JDM = "Miami Downtown Heliport"
    JDN = "Jordan"
    JDO = "Orlando Bezerra de Menezes Airport"
    JDP = "Heliport De Paris"
    JDR = "Sao Joao Del Rei"
    JDT = "Downtown Heliport"
    JDY = "Heliport"
    JDZ = "Jingdezhen Airport"
    JED = "King Abdulaziz International Airport"
    JEE = "Jeremie"
    JEF = "Memorial"
    JEG = "Aasiaat Airport"
    JEJ = "Jeh"
    JEK = "Jeki Airport"
    JEM = "Heliport"
    JEQ = "Jequie"
    JER = "Jersey Airport"
    JFK = "John F. Kennedy International Airport"
    JFM = "Heliport"
    JFN = "Ashtabula"
    JFR = "Paamiut Airport"
    JGA = "Govardhanpur Airport"
    JGB = "Jagdalpur"
    JGC = "Heliport"
    JGD = "Jiagedaqi Airport"
    JGE = "Heliport"
    JGL = "Galleria Heliport"
    JGN = "Jiayuguan Airport"
    JGO = "Qeqertarsuaq"
    JGP = "Greenway Plaza Heliport"
    JGQ = "Transco Twr Galleria"
    JGR = "Heliport"
    JGS = "Ji'An/Jing Gang Shan Airport"
    JGX = "Heliport"
    JHB = "Senai Airport"
    JHC = "Island Heliport"
    JHE = "Heliport"
    JHF = "São Paulo Catarina Executive Airport"
    JHG = "Xishuangbanna Gasa Airport"
    JHL = "Albian"
    JHM = "Kapalua Airport"
    JHS = "Sisimiut Airport"
    JHW = "Jamestown Airport"
    JHY = "Hyatt Regency Heliport"
    JIA = "Juina"
    JIB = "Djibouti-Ambouli International Airport"
    JIC = "Jinchuan Airport"
    JID = "City Of Industry Heliport"
    JIJ = "Jigiga Airport"
    JIK = "Ikaria Airport"
    JIL = "Jilin"
    JIM = "Jimma Airport"
    JIN = "Jinja"
    JIO = "International Heliport"
    JIP = "Jipijapa"
    JIQ = "Qianjiang Wulingshan Airport"
    JIR = "Jiri"
    JIU = "Jiujiang"
    JIW = "Jiwani"
    JJA = "Jajao"
    JJD = "Jericoacoara"
    JJG = "Jaguaruna Regional Airport"
    JJI = "Juanjui"
    JJM = "Mulika Lodge Airport"
    JJN = "Quanzhou Jinjiang International Airport"
    JJU = "Heliport"
    JKG = "Axamo Airport"
    JKH = "Chios Airport"
    JKL = "Kalymnos Island National Airport"
    JKR = "Janakpur Airport"
    JKV = "Cherokee County"
    JLA = "Quartz Creek"
    JLB = "Long Beach Heliport"
    JLD = "Heliport"
    JLH = "US Army Heliport"
    JLN = "Joplin Airport"
    JLR = "Jabalpur Airport"
    JLS = "Jales"
    JLX = "Union Station Heliport"
    JMA = "Marriot Astrodome"
    JMB = "Jamba"
    JMC = "Marin County"
    JMD = "Market Centre Heliport"
    JMH = "Marriott Heliport"
    JMJ = "Lancang Jingmai Airport"
    JMK = "Mikonos Airport"
    JMM = "Malmo Harbour Heliport"
    JMN = "Municipal Heliport"
    JMO = "Jomsom"
    JMS = "Jamestown Airport"
    JMU = "Jiamusi Airport"
    JMY = "Mammy Yoko Heliport"
    JNA = "Januaria"
    JNB = "O.R. Tambo International Airport"
    JNG = "Jining Airport"
    JNH = "North Park Inn Heliport"
    JNI = "Junin"
    JNJ = "Jaaluni"
    JNN = "Nanortalik"
    JNP = "Heliport"
    JNS = "Heliport"
    JNU = "Juneau International Airport"
    JNX = "Naxos Airport"
    JNZ = "Liaoning Province Airport"
    JOC = "Centerport Heliport"
    JOE = "Joensuu Airport"
    JOG = "Adisutjipto International Airport"
    JOH = "Port Saint Johns"
    JOI = "Joinville-Lauro Carneiro de Loyola Airport"
    JOJ = "Doris Lake Aerodrome"
    JOK = "Yoshkar-Ola Airport"
    JOL = "Jolo"
    JOM = "Njombe"
    JON = "Johnston Island"
    JOP = "Josephstaal"
    JOR = "The City Heliport"
    JOS = "Jos Airport"
    JOT = "Municipal"
    JPA = "Presidente Castro Pinto International Airport"
    JPD = "Heliport"
    JPE = "Nagib Demachki Airport"
    JPN = "Pentagon Army"
    JPO = "Brigadeiro Firmino Ayres Airport"
    JPR = "Ji-Parana Airport"
    JPT = "Park Ten Heliport"
    JPU = "La Defense Heliport"
    JPY = "Paraty Airport"
    JQA = "Qaarsut Airport"
    JQE = "Jaque Airport"
    JRA = "West 30th St Heliport"
    JRB = "Downtown Manhattan Heliport"
    JRC = "Municipalcipal Heliport"
    JRD = "Heliport"
    JRE = "East 60th Street Heliport"
    JRF = "Kalaeloa"
    JRG = "Jharsuguda Airport"
    JRH = "Rowriah Airport"
    JRK = "Arsuk"
    JRN = "Juruena"
    JRO = "Kilimanjaro International Airport"
    JRS = "Atarot"
    JRT = "Juruti Airport"
    JSA = "Jaisalmer"
    JSB = "Walfrido Salmito de Almeida Airport"
    JSD = "Sikorsky Heliport"
    JSG = "San Rafael Heliport"
    JSH = "Sitia Airport"
    JSI = "Skiathos Airport"
    JSJ = "Jiansanjiang Shidi Airport"
    JSK = "Municipalcipal Heliport"
    JSL = "Steel Pier Heliport"
    JSM = "Jose De San Martin"
    JSN = "Sherman Oaks Heliport"
    JSO = "Sodertalje Heliport"
    JSP = "Seogwipo Heliport"
    JSR = "Jessore Airport"
    JST = "Cambria County Airport"
    JSU = "Heliport"
    JSY = "Syros Island Airport"
    JTA = "Pedro Teixeira Castelo Airport"
    JTC = "Bauru-Arealva Airport"
    JTI = "Jatai"
    JTN = "Antônio Ribeiro Nogueira Jr. State Airport"
    JTO = "Heliport"
    JTR = "Santorini International Airport"
    JTY = "Astypalaia Airport"
    JUA = "Juara"
    JUB = "Juba International Airport"
    JUC = "Universal City Heliport"
    JUH = "Chizhou Jiuhuashan Airport"
    JUI = "Juist"
    JUJ = "El Cadillal Airport"
    JUL = "Juliaca Airport"
    JUM = "Jumla"
    JUN = "Jundah"
    JUO = "Jurado"
    JUP = "Cable Heliport"
    JUR = "Jurien Bay"
    JUT = "Juticalpa"
    JUV = "Heliport"
    JUZ = "Quzhou Airport"
    JVA = "Ankavandra"
    JVI = "Central Jersey Regional Airport"
    JVL = "Rock County"
    JWA = "Jwaneng"
    JWH = "Westchase Hilton Heliport"
    JWL = "Woodlawns"
    JWN = "Zanjan"
    JWO = "Jungwon Air Base"
    JXA = "Jixi Airport"
    JXN = "Reynolds Municipal"
    JYR = "Jiroft"
    JYV = "Jyvaskyla Airport"
    JZH = "Jiuzhai Huanglong Airport"
    KAA = "Kasama Airport"
    KAB = "Kariba"
    KAC = "Kameshly Airport"
    KAD = "Kaduna Airport"
    KAE = "SPB"
    KAF = "Karato"
    KAG = "Gangneung"
    KAH = "City Heliport"
    KAI = "Kaieteur"
    KAJ = "Kajaani Airport"
    KAK = "Kar"
    KAL = "Kaltag Airport"
    KAM = "Kamaran Island"
    KAN = "Mallam Aminu Kano International Airport"
    KAO = "Kuusamo Airport"
    KAP = "Kapanga"
    KAQ = "Kamulai"
    KAR = "Kamarang"
    KAS = "Karasburg"
    KAT = "Kaitaia"
    KAU = "Kauhava"
    KAV = "Kavanayen"
    KAW = "Kawthaung Airport"
    KAX = "Kalbarri"
    KAY = "Wakaya Island"
    KAZ = "Kau"
    KBA = "Kabala"
    KBB = "Kirkimbie"
    KBC = "Birch Creek"
    KBD = "Kimberley Downs"
    KBE = "Hot Springs SPB"
    KBF = "Karubaga"
    KBG = "Kabalega Falls"
    KBH = "Kalat"
    KBI = "Kribi"
    KBJ = "Kings Canyon"
    KBK = "Klag Bay"
    KBL = "Kabul International Airport"
    KBM = "Kabwum"
    KBN = "Kabinda"
    KBO = "Kabalo"
    KBP = "Boryspil International Airport"
    KBQ = "Kasungu"
    KBR = "Sultan Ismail Petra Airport"
    KBS = "Bo"
    KBT = "Kaben"
    KBU = "Gusti Syamsir Alam Airport"
    KBV = "Krabi Airport"
    KBW = "Chignik Bay"
    KBX = "Kambuaya"
    KBY = "Streaky Bay"
    KBZ = "Kaikoura"
    KCA = "Kuqa Airport"
    KCB = "Tepoe Airstrip"
    KCC = "Coffman Cove SPB"
    KCD = "Kamur"
    KCE = "Collinsville"
    KCF = "Kadanwari"
    KCG = "Fisheries"
    KCH = "Kuching International Airport"
    KCI = "Kon"
    KCJ = "Komaio"
    KCK = "Kirensk Airport"
    KCL = "Lagoon"
    KCM = "Kahramanmaras Airport"
    KCN = "SPB"
    KCO = "Cengiz Topel Airport"
    KCP = "Kamenets-podolskiy"
    KCQ = "Chignik"
    KCR = "Colorado Creek"
    KCS = "Kings Creek Station"
    KCT = "Koggala Airport"
    KCU = "Masindi"
    KCZ = "Kochi Ryoma Airport"
    KDA = "Kolda"
    KDB = "Kambalda"
    KDC = "Kandi"
    KDD = "Khuzdar"
    KDE = "Koroba"
    KDH = "Kandahar Airport"
    KDI = "Haluoleo Airport"
    KDJ = "Ndjole-Ville"
    KDK = "Municipal"
    KDL = "Kardla Airport"
    KDM = "Kaadedhdhoo"
    KDN = "Ndende"
    KDO = "Kadhdhoo"
    KDP = "Kandep"
    KDQ = "Kamberatoro"
    KDR = "Kandrian"
    KDS = "Kamaran Downs"
    KDT = "Kamphangsaen"
    KDU = "Skardu Airport"
    KDV = "Kandavu Airport"
    KDW = "Vic. Resevour Kandy"
    KDX = "Kadugli"
    KDY = "Mahaweli"
    KDZ = "Polgolla Reservoir Airport"
    KEA = "Keisah Airport"
    KEB = "Nanwalek"
    KEC = "Kasenga"
    KED = "Kaedi"
    KEE = "Kelle"
    KEF = "Keflavik International Airport"
    KEG = "Keglsugl"
    KEH = "Kenmore Air Harbor"
    KEI = "Kepi"
    KEJ = "Kemerovo Airport"
    KEK = "Ekwok"
    KEL = "Kiel-Holtenau"
    KEM = "Kemi/Tornio Airport"
    KEN = "Kenema"
    KEO = "Odienne"
    KEP = "Nepalganj Airport"
    KEQ = "Kebar"
    KER = "Kerman Airport"
    KES = "Kelsey"
    KET = "Keng Tung Airport"
    KEU = "Kelly Bar"
    KEV = "Halli"
    KEW = "Keewaywin"
    KEX = "Kanabea"
    KEY = "Kericho"
    KEZ = "Kelaniya River"
    KFA = "Kiffa"
    KFE = "Fortescue Dave Forrest"
    KFG = "Kalkurung"
    KFM = "Kirby Lake Aerodrome"
    KFP = "False Pass"
    KFS = "Kastamonu Airport"
    KFZ = "Kukës International Airport"
    KGA = "Kananga"
    KGB = "Konge"
    KGC = "Kingscote Airport"
    KGD = "Khrabrovo Airport"
    KGE = "Kagau"
    KGF = "Karaganda Airport"
    KGG = "Kedougou"
    KGH = "Yongai"
    KGI = "Kalgoorlie Airport"
    KGJ = "Karonga"
    KGK = "New Koliganek"
    KGL = "Kigali International Airport"
    KGM = "Kungum"
    KGN = "Kasongo Lunda"
    KGO = "Kirovograd"
    KGP = "Kogalym International Airport"
    KGR = "Kulgera"
    KGS = "Kos Airport"
    KGT = "Kangding Airport"
    KGU = "Keningau"
    KGW = "Kagi"
    KGX = "Grayling Airport"
    KGY = "Kingaroy"
    KGZ = "Glacier Creek"
    KHA = "Khaneh"
    KHC = "Kerch"
    KHD = "Khorramabad"
    KHE = "Kherson International Airport"
    KHG = "Kashi Airport"
    KHH = "Kaohsiung International Airport"
    KHI = "Jinnah International Airport"
    KHJ = "Kauhajoki"
    KHK = "Khark Island"
    KHM = "Khamti"
    KHN = "Nanchang Changbei International Airport"
    KHO = "Khoka Moya"
    KHR = "Kharkhorin"
    KHS = "Khasab Airport"
    KHT = "Khost"
    KHU = "Kremenchug"
    KHV = "Khabarovsk Airport"
    KHW = "Khwai River Lodge"
    KHX = "Savannah Airstrip"
    KHY = "Khoy"
    KHZ = "Kauehi Airport"
    KIA = "Kaiapit"
    KIB = "SPB"
    KIC = "Mesa Del Rey"
    KID = "Kristianstad Airport"
    KIE = "Aropa"
    KIF = "Kingfisher Lake"
    KIG = "Koinghaas"
    KIH = "Kish International Airport"
    KII = "Kibuli"
    KIJ = "Niigata Airport"
    KIK = "Kirkuk"
    KIL = "Kilwa"
    KIM = "Kimberley Airport"
    KIN = "Norman Manley International Airport"
    KIO = "Kili Island"
    KIP = "Kickapoo"
    KIQ = "Kira"
    KIR = "Kerry County Airport"
    KIS = "Kisumu Airport"
    KIT = "Kithira Airport"
    KIU = "Kiunga"
    KIV = "Chisinau International Airport"
    KIW = "Southdowns"
    KIX = "Kansai International Airport"
    KIY = "Kilwa Masoko Airport"
    KIZ = "Kikinonda"
    KJA = "Yemelyanovo Airport"
    KJB = "Uyyalawada Narasimha Reddy Airport"
    KJH = "Kaili Huangping Airport"
    KJI = "Kanasi Airport"
    KJK = "Kortrijk"
    KJP = "Kerama"
    KJT = "Kertajati International Airport"
    KJU = "Kamiraba"
    KJX = "Blangpidie Airport"
    KKA = "Koyuk Airport"
    KKB = "SPB"
    KKC = "Khon Kaen Airport"
    KKD = "Kokoda"
    KKE = "Kerikeri Airport"
    KKF = "Kagvik Creek"
    KKG = "Konawaruk"
    KKH = "Kongiganak Airport"
    KKI = "Spb"
    KKJ = "Kitakyushu Airport"
    KKK = "Kalakaket AFS"
    KKL = "Karluk Lake SPB"
    KKM = "Lop Buri"
    KKN = "Kirkenes Airport Hoeybuktmoen"
    KKO = "Kaikohe"
    KKP = "Koolburra"
    KKQ = "Krasnoselkup"
    KKR = "Kaukura Atoll Airport"
    KKS = "Kashan Airport"
    KKT = "Kentland"
    KKU = "Ekuk"
    KKW = "Kikwit"
    KKX = "Kikaiga Shima"
    KKY = "Kilkenny"
    KKZ = "Koh Kong"
    KLB = "Kalabo Airport"
    KLC = "Kaolack"
    KLD = "Migalovo"
    KLE = "Kaele"
    KLF = "Grabtsevo Airport"
    KLG = "Kalskag Municipal Airport"
    KLH = "Kolhapur"
    KLI = "Kota Koli"
    KLJ = "Klaipeda"
    KLK = "Kalokol"
    KLL = "Levelock"
    KLM = "Kalaleh"
    KLN = "Larsen SPB"
    KLO = "Kalibo International Airport"
    KLP = "Kelp Bay"
    KLQ = "Keluang"
    KLR = "Kalmar Oland Airport"
    KLS = "Longview"
    KLT = "Kaiserslautern"
    KLU = "Klagenfurt Airport"
    KLV = "Karlovy Vary Airport"
    KLW = "Klawock Airport"
    KLX = "Kalamata Airport"
    KLY = "Kalima"
    KLZ = "Kleinzee"
    KMA = "Kerema"
    KMB = "Koinambe"
    KMC = "King Khalid Military"
    KME = "Kamembe"
    KMF = "Kamina"
    KMG = "Kunming Changshui International Airport"
    KMH = "Kuruman"
    KMI = "Miyazaki Airport"
    KMJ = "Kumamoto Airport"
    KMK = "Makabana"
    KML = "Kamileroi"
    KMM = "Kimam"
    KMN = "Kamina"
    KMO = "Manokotak SPB"
    KMP = "J.G.H. Van Der Wath"
    KMQ = "Komatsu Airport"
    KMR = "Karimui"
    KMS = "Kumasi Airport"
    KMT = "Kampot"
    KMU = "Kismayu"
    KMV = "Kalemyo Airport"
    KMW = "Sokerkino"
    KMX = "Khamis Mushait"
    KMY = "Moser Bay"
    KMZ = "Kaoma"
    KNA = "Vina del Mar"
    KNB = "Kanab"
    KND = "Kindu"
    KNE = "Kanainj"
    KNF = "Marham RAF"
    KNG = "Kaimana Airport"
    KNH = "Kinmen Airport"
    KNI = "Katanning"
    KNJ = "Kindamba"
    KNK = "Kokhanok Airport"
    KNL = "Kelanoa"
    KNM = "Kaniama"
    KNN = "Kankan"
    KNO = "Kuala Namu International Airport"
    KNP = "Capanda"
    KNQ = "Kone"
    KNR = "Jam"
    KNS = "King Island Airport"
    KNT = "Municipal"
    KNU = "Kanpur Airport"
    KNV = "Knights Inlet"
    KNW = "New Stuyahok"
    KNX = "Kununurra Airport"
    KNY = "Kinoosao"
    KNZ = "Kenieba"
    KOA = "Kona International Airport at Keahole"
    KOC = "Koumac"
    KOD = "Kotabangun"
    KOE = "El Tari Airport"
    KOF = "Komatipoort"
    KOG = "Khong"
    KOH = "Koolatah"
    KOI = "Kirkwall Airport"
    KOJ = "Kagoshima Airport"
    KOK = "Kruunupyy Airport"
    KOL = "Koumala"
    KOM = "Komo-Manda"
    KON = "Kontum"
    KOO = "Kongolo"
    KOP = "Nakhon Phanom Airport"
    KOQ = "Koethen"
    KOR = "Kokoro"
    KOS = "Sihanouk International Airport"
    KOT = "Kotlik Airport"
    KOU = "Koulamoutou"
    KOV = "Kokshetau Airport"
    KOW = "Ganzhou Airport"
    KOX = "Kokonao"
    KOY = "Olga Bay SPB"
    KOZ = "Ouzinkie SPB"
    KPA = "Kopiago"
    KPB = "Point Baker SPB"
    KPC = "Port Clarence"
    KPD = "King Of Prussia"
    KPE = "Yapsiei"
    KPF = "Kondubol"
    KPG = "Kurupung"
    KPH = "Pauloff Harbor SPB"
    KPI = "Kapit"
    KPK = "Parks SPB"
    KPL = "Kapal"
    KPM = "Kompiam"
    KPN = "Kipnuk SPB"
    KPO = "Pohang Airport"
    KPP = "Kalpowar"
    KPR = "Port Williams SPB"
    KPS = "Kempsey"
    KPT = "Jackpot"
    KPV = "Perryville SPB"
    KPW = "Keperveyem Airport"
    KPY = "Port Bailey SPB"
    KQA = "Akutan"
    KQH = "Kishangarh Airport"
    KQL = "Kol"
    KQR = "Karara Airport"
    KQT = "Qurghonteppa International Airport"
    KRA = "Kerang"
    KRB = "Karumba Airport"
    KRC = "Kerinci"
    KRD = "Kurundi"
    KRE = "Kirundo"
    KRF = "Kramfors Airport"
    KRG = "Karasabai"
    KRI = "Kikori"
    KRJ = "Karawari"
    KRK = "J. Paul II International Airport Krakow-Balice"
    KRL = "Korla Airport"
    KRM = "Karanambo"
    KRN = "Kiruna Airport"
    KRO = "Kurgan Airport"
    KRP = "Karup Airport"
    KRQ = "Kramatorsk"
    KRR = "Krasnodar International Airport"
    KRS = "Kristiansand Airport"
    KRT = "Khartoum International Airport"
    KRU = "Kerau"
    KRV = "Kerio Valley"
    KRW = "Turkmanbashi Airport"
    KRX = "Kar Kar"
    KRY = "Karamay Airport"
    KRZ = "Kiri"
    KSA = "Kosrae Airport"
    KSB = "Kasanombe"
    KSC = "Barca Airport"
    KSD = "Karlstad Airport"
    KSE = "Kasese Airport"
    KSF = "Kassel-Calden Airport"
    KSG = "Kisengan"
    KSH = "Kermanshah Airport"
    KSI = "Kissidougou"
    KSJ = "Kasos Island Airport"
    KSK = "Karlskoga"
    KSL = "Kassala Airport"
    KSM = "Saint Mary's Airport"
    KSN = "Kostanay Airport"
    KSO = "Aristoteles Airport"
    KSP = "Kosipe"
    KSQ = "Karshi Airport"
    KSR = "Federal No 1"
    KSS = "Sikasso"
    KST = "Kosti"
    KSU = "Kristiansund Airport Kvernberget"
    KSV = "Springvale"
    KSW = "Kiryat Shmona"
    KSX = "Yasuru"
    KSY = "Kars Airport"
    KSZ = "Kotlas Airport"
    KTA = "Karratha Airport"
    KTB = "Thorne Bay"
    KTC = "Katiola"
    KTD = "Kitadaito"
    KTE = "Kerteh Airport"
    KTF = "Takaka"
    KTG = "Ketapang Airport"
    KTH = "SPB"
    KTI = "Kratie"
    KTJ = "Kichwa Tembo Airport"
    KTK = "Kanua"
    KTL = "Kitale Airport"
    KTM = "Tribhuvan International Airport"
    KTN = "Ketchikan International Airport"
    KTO = "Kato"
    KTP = "Tinson"
    KTQ = "Kitee"
    KTR = "Tindal"
    KTS = "Brevig Mission Airport"
    KTT = "Kittila Airport"
    KTU = "Kota"
    KTV = "Kamarata"
    KTW = "Katowice International Airport"
    KTX = "Koutiala"
    KTY = "Katukurunda Slaf Base"
    KUA = "Sultan Haji Ahmad Shah Airport"
    KUC = "Kuria"
    KUD = "Kudat Airport"
    KUE = "Kukundu"
    KUF = "Kurumoch International Airport"
    KUG = "Kubin Island"
    KUH = "Kushiro Airport"
    KUI = "Kawau Island"
    KUJ = "Kushimoto"
    KUK = "Kasigluk Airport"
    KUL = "Kuala Lumpur International Airport"
    KUM = "Yakushima Airport"
    KUN = "Kaunas Airport"
    KUO = "Kuopio Airport"
    KUP = "Kupiano"
    KUQ = "Kuri"
    KUR = "Kuran-O-Munjan"
    KUS = "Kulusuk Airport"
    KUT = "Kutaisi International Airport"
    KUU = "Bhuntar Airport"
    KUV = "Gunsan Airport"
    KUW = "Kugururok River"
    KUX = "Kuyol"
    KUY = "Kamusi Airport"
    KUZ = "Gunsan Airbase"
    KVA = "Kavala International Airport"
    KVB = "Skovde"
    KVC = "King Cove"
    KVD = "Gyandzha Airport"
    KVE = "Kitava"
    KVG = "Kavieng Airport"
    KVK = "Kirovsk Airport"
    KVL = "Kivalina Airport"
    KVM = "Markovo Airport"
    KVO = "Morava Airport"
    KVR = "Kavalerovo"
    KVU = "Korolevu"
    KVX = "Kirov Airport"
    KWA = "Kwajalein Airport"
    KWB = "Karimunjawa"
    KWD = "Kawadjia"
    KWE = "Guiyang Longdongbao International Airport"
    KWF = "Waterfall SPB"
    KWG = "Krivoy Rog"
    KWH = "Khwahan"
    KWI = "Kuwait International Airport"
    KWJ = "Gwangju Airport"
    KWK = "Kwigillingok Airport"
    KWL = "Guilin Liangjiang International Airport"
    KWM = "Kowanyama"
    KWN = "Kwinhagak Airport"
    KWO = "Kawito"
    KWP = "Village SPB"
    KWR = "Kwai Harbour"
    KWS = "Kwailabesi Aerodrom"
    KWT = "Kwethluk Airport"
    KWU = "Mansion House"
    KWV = "Kurwina"
    KWX = "Kiwai Island"
    KWY = "Kiwayu"
    KWZ = "Kolwezi"
    KXA = "Kasaan SPB"
    KXB = "Sangia Nibandera Airport"
    KXD = "Kondinskoye Airport"
    KXE = "Klerksdorp"
    KXF = "Koro Island"
    KXK = "Khurba Airport"
    KXR = "Karoola"
    KXU = "Katiu"
    KYA = "Konya Airport"
    KYD = "Orchid Island"
    KYE = "Kleyate"
    KYF = "Yeelirrie"
    KYI = "Yalata Mission"
    KYK = "Karluk"
    KYL = "Port Largo"
    KYN = "Milton Keynes"
    KYO = "Topp Of Tampa"
    KYP = "Kyaukpyu Airport"
    KYS = "Kayes"
    KYT = "Kyauktaw"
    KYU = "Koyukuk Airport"
    KYX = "Yalumet"
    KYZ = "Kyzyl Airport"
    KZB = "Zachar Bay SPB"
    KZC = "Kompong-Chhna"
    KZD = "Krakor"
    KZF = "Kaintiba"
    KZG = "Kitzingen"
    KZH = "Kizhuyak"
    KZI = "Philippos Airport"
    KZN = "Kazan International Airport"
    KZO = "Kzyl-Orda Airport"
    KZR = "Zafer Airport"
    KZS = "Kastellorizo Airport"
    LAA = "Lamar Field"
    LAB = "Lablab"
    LAC = "Layang-Layang Airstrip"
    LAD = "Quatro de Fevereiro Airport"
    LAE = "Nadzab Airport"
    LAF = "Purdue University"
    LAG = "La Guaira"
    LAH = "Labuha"
    LAI = "Servel Airport"
    LAJ = "Correia Pinto Airport"
    LAK = "Aklavik"
    LAL = "Municipal"
    LAM = "Los Alamos"
    LAN = "Capital Region International Airport"
    LAO = "Laoag Airport"
    LAP = "Leon Airport"
    LAQ = "La Braq Airport"
    LAR = "General Brees Field"
    LAS = "McCarran International Airport"
    LAT = "La Uribe"
    LAU = "Lamu"
    LAV = "Lalomalava"
    LAW = "Lawton-Fort Sill Regional Airport"
    LAX = "Los Angeles International Airport"
    LAY = "Ladysmith"
    LAZ = "Bom Jesus Da Lapa"
    LBA = "Leeds Bradford International Airport"
    LBB = "Lubbock Preston Smith International Airport"
    LBC = "Lubeck Blankensee"
    LBD = "Khujand Airport"
    LBE = "Westmoreland County Airport"
    LBF = "Lee Bird Field"
    LBG = "Le Bourget"
    LBH = "Palm Beach SPB"
    LBI = "Le Sequestre"
    LBJ = "Komodo Airport"
    LBK = "Liboi"
    LBL = "Liberal Municipal Airport"
    LBM = "Luabo"
    LBN = "Lake Baringo"
    LBO = "Lusambo"
    LBP = "Long Banga Airfield"
    LBQ = "Lambarene"
    LBR = "Labrea"
    LBS = "Labasa Airport"
    LBT = "Lumberton"
    LBU = "Labuan Airport"
    LBV = "Libreville Airport"
    LBW = "Long Bawan"
    LBX = "Lubang"
    LBY = "Montoir"
    LBZ = "Lukapa"
    LCA = "Larnaca International Airport"
    LCB = "Pontes e Lacerda"
    LCC = "Galatina"
    LCD = "Louis Trichardt"
    LCE = "Goloson International Airport"
    LCF = "Las Vegas"
    LCG = "A Coruna Airport"
    LCH = "Lake Charles Regional Airport"
    LCI = "Municipal"
    LCJ = "Lodz Lublinek Airport"
    LCK = "Rickenbacker International Airport"
    LCL = "La Coloma"
    LCM = "La Cumbre"
    LCN = "Balcanoona"
    LCO = "Lague"
    LCP = "Loncopue"
    LCQ = "Lake City"
    LCR = "La Chorrera"
    LCS = "Las Canas"
    LCT = "Shijiazhuang Luancheng Airport"
    LCV = "Lucca"
    LCX = "Liancheng Airport"
    LCY = "London City Airport"
    LDA = "Malda"
    LDB = "Londrina Airport"
    LDC = "Lindeman Island"
    LDE = "Tarbes Ossun Lourdes Airport"
    LDG = "Leshukonskoye"
    LDH = "Lord Howe Island Airport"
    LDI = "Kikwetu"
    LDJ = "Linden"
    LDK = "Hovby"
    LDM = "Mason County"
    LDN = "Lamidanda"
    LDO = "Ladouanie"
    LDR = "Lodar"
    LDS = "Yichun Shi Airport"
    LDU = "Lahad Datu Airport"
    LDV = "Landivisiau"
    LDW = "Lansdowne"
    LDX = "St-Laurent du Maroni"
    LDY = "City of Derry Airport"
    LDZ = "Londolozi Airport"
    LEA = "Learmonth Airport"
    LEB = "Lebanon Regional Airport"
    LEC = "Coronel Horacio de Mattos Airport"
    LED = "Pulkovo Airport"
    LEE = "Leesburg"
    LEF = "Lebakeng"
    LEG = "Aleg"
    LEH = "Octeville"
    LEI = "Almeria Airport"
    LEJ = "Leipzig/Halle Airport"
    LEK = "Labe"
    LEL = "Lake Evella"
    LEM = "Lemmon"
    LEN = "Leon Airport"
    LEO = "Leconi"
    LEP = "Leopoldina"
    LEQ = "Lands End"
    LER = "Leinster"
    LES = "Lesobeng"
    LET = "Gen. A.V. Cobo Airport"
    LEU = "Seo de Urgel"
    LEV = "Levuka Airfield"
    LEW = "Auburn"
    LEX = "Blue Grass Airport"
    LEY = "Lelystad"
    LEZ = "La Esperanza"
    LFB = "Lumbo"
    LFH = "Lanping Feng Hua Airport"
    LFI = "Langley AFB"
    LFK = "Lufkin Angelina County"
    LFM = "Lamerd Airport"
    LFN = "Franklin"
    LFO = "Kelafo"
    LFP = "Lakefield"
    LFQ = "Linfen Qiaoli Airport"
    LFR = "La Fria Airport"
    LFT = "Lafayette Regional Airport"
    LFW = "Lome Airport"
    LGA = "LaGuardia Airport"
    LGB = "Long Beach Airport"
    LGC = "Calloway"
    LGD = "La Grande"
    LGE = "Lake Gregory"
    LGF = "Laguna AAF"
    LGG = "Liege Airport"
    LGH = "Leigh Creek"
    LGI = "Deadmans Cay Airport"
    LGK = "Langkawi International Airport"
    LGL = "Long Lellang"
    LGM = "Laiagam"
    LGN = "Linga Linga"
    LGO = "Langeoog"
    LGP = "Legaspi Airport"
    LGQ = "Lago Agrio Airport"
    LGR = "Cochrane"
    LGS = "Malargue"
    LGT = "Las Gaviotas"
    LGU = "Cache"
    LGW = "London Gatwick Airport"
    LGX = "Lugh Ganane"
    LGY = "Lagunillas"
    LGZ = "Leguizamo"
    LHA = "Black Forest"
    LHB = "Lost Harbor Sea Port"
    LHE = "Allama Iqbal International Airport"
    LHG = "Lightning Ridge"
    LHI = "Lereh"
    LHK = "Guanghua"
    LHN = "Lishan"
    LHP = "Lehu"
    LHR = "London Heathrow Airport"
    LHS = "Las Heras"
    LHU = "Lianshulu"
    LHV = "W T Piper Memorial"
    LHW = "Lanzhou Zhongchuan International Airport"
    LIA = "Liangping"
    LIB = "Limbunya"
    LIC = "Municipal"
    LIE = "Libenge"
    LIF = "Lifou Airport"
    LIG = "Bellegarde Airport"
    LIH = "Lihue Airport"
    LII = "Mulia"
    LIJ = "Long Island"
    LIK = "Likiep Island"
    LIL = "Lille Airport"
    LIM = "Jorge Chavez International Airport"
    LIN = "Milano Linate Airport"
    LIO = "Limon International Airport"
    LIP = "Lins"
    LIQ = "Lisala"
    LIR = "Liberia Airport"
    LIS = "Lisbon Portela Airport"
    LIT = "Bill and Hillary Clinton National Airport"
    LIV = "Livengood"
    LIW = "Loikaw Airport"
    LIX = "Likoma"
    LIY = "Wright AAF"
    LIZ = "Loring AFB"
    LJA = "Lodja"
    LJC = "Intercontinental"
    LJG = "Lijiang Airport"
    LJN = "Brazoria County"
    LJU = "Ljubljana Joze Pucnik Airport"
    LKA = "Gewayenta Airport"
    LKB = "Lakeba Airport"
    LKC = "Lekana"
    LKD = "Lakeland Downs"
    LKE = "Kenmore Air Harbor SPB"
    LKG = "Lokichoggio"
    LKH = "Long Akah"
    LKI = "Lakeside USAF"
    LKK = "Kulik Lake"
    LKL = "Banak Airport"
    LKN = "Leknes Airport"
    LKO = "Chaudhary Charan Singh International Airport"
    LKP = "Lake Placid"
    LKR = "Las Khoreh"
    LKS = "Lakeside"
    LKU = "Lake Rudolf"
    LKV = "Lake County"
    LKW = "Lekhwair"
    LKY = "Lake Manyara Airport"
    LKZ = "RAF Lakenheath"
    LLA = "Lulea Airport"
    LLB = "Libo County Libo City Airport"
    LLC = "Cagayan North International Airport"
    LLE = "Malelane"
    LLF = "Lingling Airport"
    LLG = "Chillagoe"
    LLH = "Las Limas"
    LLI = "Lalibela Airport"
    LLJ = "Silampari Airport"
    LLK = "Lankaran International Airport"
    LLL = "Lissadell"
    LLM = "Long Lama"
    LLN = "Kelila"
    LLO = "Bua Airport"
    LLP = "Linda Downs"
    LLS = "Las Lomitas"
    LLT = "Lobito"
    LLU = "Alluitsup Paa"
    LLV = "Lüliang Airport"
    LLW = "Lilongwe International Airport"
    LLX = "Lyndonville"
    LLY = "Burlington County"
    LMA = "Lake Minchumina"
    LMB = "Salima"
    LMC = "Lamacarena"
    LMD = "Los Menucos"
    LME = "Arnage"
    LMG = "Lamassa"
    LMH = "Limon"
    LMI = "Lumi"
    LML = "Lae Island"
    LMM = "Federal Airport"
    LMN = "Limbang Airport"
    LMO = "Lossiemouth RAF Station"
    LMP = "Lampedusa Airport"
    LMQ = "Marsa Brega"
    LMR = "Lime Acres"
    LMS = "Winston County"
    LMT = "Crater Lake Klamath Regional Airport"
    LMU = "Letung Airport"
    LMV = "Madivaru Airport"
    LMX = "Lopez De Micay"
    LMY = "Lake Murray"
    LMZ = "Palma"
    LNA = "Palm Beach County Park"
    LNB = "Lamen Bay"
    LNC = "Lengbati"
    LND = "Hunt Field"
    LNE = "Lonorore"
    LNF = "Munbil"
    LNG = "Lese"
    LNH = "Lake Nash"
    LNI = "Dew Station"
    LNJ = "Lincang Airport"
    LNK = "Lincoln Airport"
    LNL = "Longnan Chengzhou Airport"
    LNM = "Langimar"
    LNN = "Lost Nation"
    LNO = "Leonora"
    LNP = "Wise"
    LNQ = "Loani"
    LNR = "Tri County"
    LNS = "Lancaster Airport"
    LNU = "Robert Atty Bessing Airport"
    LNV = "Lihir Island"
    LNX = "Smolensk"
    LNY = "Lanai Airport"
    LNZ = "Linz Airport"
    LOA = "Lorraine"
    LOB = "Los Andes"
    LOC = "Lock"
    LOD = "Longana"
    LOE = "Loei Airport"
    LOF = "Loen"
    LOG = "Longview"
    LOH = "Ciudad de Catamayo Airport"
    LOI = "Helmuth Baungartem"
    LOK = "Lodwar Airport"
    LOL = "Derby Field"
    LOM = "Francisco P. V. Y R."
    LOO = "L'Mekrareg Airport"
    LOP = "Lombok International Airport"
    LOQ = "Lobatse"
    LOR = "Lowe Army Heliport"
    LOS = "Murtala Muhammed International Airport"
    LOT = "Lewis Lockport"
    LOU = "Bowman Field Airport"
    LOV = "Monclova"
    LOW = "Louisa"
    LOX = "Los Tablones Airport"
    LOY = "Loyangalani"
    LOZ = "Corbin-london"
    LPA = "Gran Canaria Airport"
    LPB = "El Alto International Airport"
    LPC = "Lompoc Airport"
    LPD = "La Pedrera"
    LPE = "La Primavera"
    LPF = "Liupanshui Yuezhao Airport"
    LPG = "La Plata"
    LPI = "Linkoping City Airport"
    LPJ = "Pijiguaos"
    LPK = "Lipetsk Airport"
    LPL = "Liverpool John Lennon Airport"
    LPM = "Lamap"
    LPN = "Leron Plains"
    LPO = "Municipal"
    LPP = "Lappeenranta"
    LPQ = "Luang Prabang International Airport"
    LPS = "Lopez Island"
    LPT = "Lampang Airport"
    LPU = "Long Apung"
    LPW = "Little Port Walter"
    LPX = "Liepaya Airport"
    LPY = "Loudes Airport"
    LQK = "Pickens"
    LQM = "Puerto Leguizamo"
    LQN = "Qala Nau"
    LRA = "Larisa"
    LRB = "Leribe"
    LRD = "Laredo International Airport"
    LRE = "Longreach Airport"
    LRF = "Little Rock AFB"
    LRG = "Lora Lai"
    LRH = "Laleu Airport"
    LRI = "Lorica"
    LRJ = "Municipal"
    LRK = "Coast Guard"
    LRL = "Niamtougou"
    LRM = "La Romana Airport"
    LRN = "Larson AFB"
    LRO = "Sharpe AAF"
    LRQ = "Laurie River"
    LRR = "Lar Airport"
    LRS = "Leros Airport"
    LRT = "Lann Bihoue Airport"
    LRU = "Municipal"
    LRV = "Los Roques"
    LSA = "Losuia"
    LSB = "Lordsburg"
    LSC = "La Florida Airport"
    LSD = "Blue Grass Station Army Heliport"
    LSE = "La Crosse Regional Airport"
    LSF = "Lawson AAF"
    LSH = "Lashio"
    LSI = "Sumburgh Airport"
    LSJ = "Long Island"
    LSK = "Lusk"
    LSL = "Los Chiles"
    LSM = "Lawas"
    LSN = "Los Banos"
    LSO = "Talmont"
    LSP = "Josefa Camejo Airport"
    LSQ = "Los Angeles"
    LSR = "Lost River"
    LSS = "Terre-de-Haut"
    LST = "Launceston Airport"
    LSU = "Long Sukang"
    LSV = "Nellis AFB"
    LSW = "Malikus Saleh Airport"
    LSX = "Lhok Sukon"
    LSY = "Lismore Airport"
    LSZ = "Losinj Airport"
    LTA = "Letaba"
    LTB = "Latrobe"
    LTC = "Lai"
    LTD = "Ghadames"
    LTF = "Leitre"
    LTG = "Langtang"
    LTH = "Lathrop Wells"
    LTI = "Altai"
    LTK = "Latakia"
    LTL = "Lastourville"
    LTM = "Lethem"
    LTN = "London Luton Airport"
    LTO = "Loreto Airport"
    LTP = "Lyndhurst"
    LTQ = "Le Touquet"
    LTR = "Letterkenny"
    LTS = "Altus AFB"
    LTT = "La Mole"
    LTU = "Latur"
    LTV = "Lotusvale"
    LTW = "St Marys County"
    LTX = "Cotapaxi International Airport"
    LUA = "Lukla"
    LUB = "Lumid Pau"
    LUC = "Laucala Island"
    LUD = "Luderitz Airport"
    LUE = "Lucenec"
    LUF = "Luke AFB"
    LUG = "Lugano Airport"
    LUH = "Ludhiana Sahnewal Airport"
    LUI = "La Union"
    LUK = "Cincinnati Municipal Lunken Airport"
    LUL = "Hesler-Noble Field"
    LUM = "Dehong Mangshi Airport"
    LUN = "Kenneth Kaunda International Airport"
    LUO = "Luena"
    LUP = "Kalaupapa"
    LUQ = "San Luis Airport"
    LUR = "Cape Lisburne"
    LUS = "Lusanga"
    LUT = "Laura Station"
    LUU = "Laura"
    LUV = "Langgur Airport"
    LUW = "Bubung Airport"
    LUX = "Luxembourg Airport"
    LUZ = "Lublin Airport"
    LVA = "Entrammes"
    LVB = "Dos Galpoes"
    LVD = "Lime Village"
    LVI = "Livingstone Airport"
    LVK = "Livermore"
    LVL = "Lawrenceville"
    LVM = "Mission Field"
    LVO = "Laverton"
    LVP = "Lavan"
    LVR = "Mun. Do Bom Futuro"
    LVS = "Las Vegas"
    LWA = "Lwbak"
    LWB = "Greenbrier Valley Airport"
    LWC = "Lawrence"
    LWE = "Lewoleba"
    LWH = "Lawn Hill"
    LWI = "Lowai"
    LWK = "Lerwick/Tingwall"
    LWL = "Harriet Field"
    LWM = "Lawrence"
    LWN = "Leninakan Airport"
    LWO = "Lviv International Airport"
    LWR = "Leeuwarden"
    LWS = "Lewiston-Nez Perce County Regional Airport"
    LWT = "Municipal"
    LWV = "Municipal"
    LWY = "Lawas Airport"
    LXA = "Lhasa Gonggar Airport"
    LXG = "Luang Namtha Airport"
    LXN = "Lexington"
    LXR = "Luxor International Airport"
    LXS = "Limnos Airport"
    LXU = "Lukulu"
    LXV = "Leadville"
    LYA = "Luoyang Beijiao Airport"
    LYB = "Little Cayman Airport"
    LYC = "Lycksele Airport"
    LYE = "Lyneham RAF Station"
    LYG = "Lianyungang Airport"
    LYH = "Preston-Glenn Field"
    LYI = "Linyi Airport"
    LYK = "Lunyuk"
    LYN = "Bron"
    LYO = "Lyons-Rice County Municipal"
    LYP = "Faisalabad Airport"
    LYR = "Svalbard Airport"
    LYS = "Lyon Saint-Exupery International Airport"
    LYT = "Lady Elliot Island"
    LYU = "Ely"
    LYX = "London Ashford International (Ferryfield)"
    LZA = "Luiza"
    LZC = "Lazaro Cardenas Airport"
    LZG = "Langzhong Airport"
    LZH = "Liuzhou Airport"
    LZI = "Luozi"
    LZM = "Luzamba"
    LZN = "Matsu Nangan Airport"
    LZO = "Luzhou Lantian Airport"
    LZR = "Lizard Island"
    LZU = "Gwinnett County Airport"
    LZY = "Nyingchi Mainling Airport"
    MAA = "Chennai Airport"
    MAB = "Maraba Airport"
    MAC = "Smart"
    MAD = "Adolfo Suarez Madrid-Barajas Airport"
    MAE = "Madera"
    MAF = "Midland International Airport"
    MAG = "Madang Airport"
    MAH = "Menorca Airport"
    MAI = "Mangochi"
    MAJ = "Amata Kabua International Airport"
    MAK = "Malakal"
    MAL = "Mangole"
    MAM = "Matamoros Airport"
    MAN = "Manchester Airport"
    MAO = "Eduardo Gomes International Airport"
    MAP = "Mamai"
    MAQ = "Mae Sot Airport"
    MAR = "La Chinita Airport"
    MAS = "Momote Airport"
    MAT = "Matadi"
    MAU = "Maupiti"
    MAV = "Maloelap Island"
    MAW = "Malden"
    MAX = "Matam"
    MAY = "Mangrove Cay"
    MAZ = "Eugenio M. De Hostos Airport"
    MBA = "Moi International Airport"
    MBB = "Marble Bar"
    MBC = "Mbigou"
    MBD = "Mmabatho International Airport"
    MBE = "Monbetsu Airport"
    MBF = "Mount Buffalo"
    MBG = "Mobridge"
    MBH = "Maryborough"
    MBI = "Mbeya Airport"
    MBJ = "Sangster International Airport"
    MBK = "Matupa"
    MBL = "Blacker Airport"
    MBM = "Mkambati"
    MBN = "Mt Barnett"
    MBO = "Mamburao"
    MBP = "Moyobamba"
    MBQ = "Mbarara"
    MBR = "Mbout"
    MBS = "MBS International Airport"
    MBT = "Masbate Airport"
    MBU = "Mbambanakira"
    MBV = "Masa"
    MBW = "Moorabbin"
    MBX = "Maribor International Airport"
    MBY = "Moberly"
    MBZ = "Maues"
    MCA = "Macenta"
    MCB = "Pike County"
    MCC = "Mcclellan AFB"
    MCD = "Mackinac Island"
    MCE = "Merced Municipal Airport"
    MCF = "Mac Dill AFB"
    MCG = "McGrath Airport"
    MCH = "Machala"
    MCI = "Kansas City International Airport"
    MCJ = "Maicao"
    MCK = "Mc Cook Airport"
    MCL = "Mt Mckinley"
    MCM = "Fontvieille Heliport"
    MCN = "Lewis B Wilson"
    MCO = "Orlando International Airport"
    MCP = "Macapa International Airport"
    MCQ = "Miskolc"
    MCR = "Melchor De Menco"
    MCS = "Monte Caseros"
    MCT = "Muscat International Airport"
    MCU = "Gueret (Lepaud)"
    MCV = "Mcarthur River Airport"
    MCW = "Mason City Airport"
    MCX = "Makhachkala Airport"
    MCY = "Sunshine Coast Airport"
    MCZ = "Maceio-Zumbi dos Palmares International Airport"
    MDA = "Martindale Army Heliport"
    MDB = "Melinda"
    MDC = "Sam Ratulangi International Airport"
    MDD = "Airpark"
    MDE = "Jose Maria Cordova International Airport"
    MDF = "Medford"
    MDG = "Mudanjiang Airport"
    MDH = "Southern Illinois"
    MDI = "Makurdi"
    MDJ = "City-county"
    MDK = "Mbandaka"
    MDL = "Mandalay International Airport"
    MDM = "Munduku"
    MDN = "Jefferson Proving Grd"
    MDO = "Intermediate"
    MDP = "Mindiptana"
    MDQ = "Mar Del Plata Airport"
    MDR = "Medfra"
    MDS = "Middle Caicos"
    MDT = "Harrisburg International Airport"
    MDU = "Mendi Airport"
    MDV = "Medouneu"
    MDW = "Chicago Midway International Airport"
    MDX = "Mercedes"
    MDY = "Sand Island Field"
    MDZ = "El Plumerillo International Airport"
    MEA = "Macae"
    MEB = "Essendon Airport"
    MEC = "Manta Airport"
    MED = "Prince Mohammad Bin Abdulaziz International Airport"
    MEE = "Mare Airport"
    MEF = "Melfi"
    MEG = "Malange"
    MEH = "Mehamn Airport"
    MEI = "Key Field"
    MEJ = "Meadville"
    MEK = "Meknes"
    MEL = "Tullamarine Airport"
    MEM = "Memphis International Airport"
    MEN = "Brenoux"
    MEO = "Dare County Regional"
    MEP = "Mersing"
    MEQ = "Seunagan"
    MER = "Castle AFB"
    MES = "Polonia"
    MET = "Moreton"
    MEU = "Monte Dourado"
    MEV = "Douglas County"
    MEW = "Mweka"
    MEX = "Benito Juarez International Airport"
    MEY = "Meghauli"
    MEZ = "Messina"
    MFA = "Mafia"
    MFB = "Monfort"
    MFC = "Mafeteng"
    MFD = "Lahm Municipal"
    MFE = "McAllen International Airport"
    MFF = "Moanda"
    MFG = "Muzaffarabad"
    MFH = "Mesquite"
    MFI = "Municipal"
    MFJ = "Moala"
    MFK = "Matsu Beigan Airport"
    MFL = "Mount Full Stop"
    MFM = "Macau International Airport"
    MFN = "Milford Sound"
    MFO = "Manguna"
    MFP = "Manners Creek"
    MFQ = "Maradi"
    MFR = "Rogue Valley International-Medford Airport"
    MFS = "Miraflores"
    MFT = "Machu Picchu"
    MFU = "Mfuwe"
    MFV = "Accomack County"
    MFW = "Magaruque"
    MFX = "Meribel"
    MFY = "Mayfa'ah"
    MFZ = "Mesalia"
    MGA = "Augusto C Sandino International Airport"
    MGB = "Mount Gambier Airport"
    MGC = "Michigan City Airport"
    MGD = "Magdalena"
    MGE = "Dobbins AFB"
    MGF = "Regional De Maringa"
    MGG = "Margarima"
    MGH = "Margate Airport"
    MGI = "Aransas National Wildlife Refuge"
    MGJ = "Orange County"
    MGK = "Mong Ton"
    MGL = "Moenchen-gl. - Dus Exp"
    MGM = "Montgomery Regional Airport"
    MGN = "Baracoa"
    MGO = "Manega"
    MGP = "Manga"
    MGQ = "Mogadishu International Airport"
    MGR = "Moultrie Municipal"
    MGS = "Mangaia Island"
    MGT = "Milingimbi"
    MGU = "Manaung"
    MGV = "Margaret River"
    MGW = "Morgantown Airport"
    MGX = "Moabi"
    MGY = "Dayton-Wright Brothers Airport"
    MGZ = "Myeik Airport"
    MHA = "Mahdia"
    MHB = "Mechanics Bay"
    MHC = "Mocopulli Airport"
    MHD = "Mashhad International Airport"
    MHE = "Municipal"
    MHF = "Morichal"
    MHG = "Mannheim Airport"
    MHH = "Marsh Harbour International Airport"
    MHI = "Musha"
    MHK = "Manhattan Municipal Airport"
    MHL = "Memorial Municipal"
    MHM = "Intermediate"
    MHN = "Mullen"
    MHO = "Mount House"
    MHP = "Minsk International 1"
    MHQ = "Mariehamn Airport"
    MHR = "Mather Airport"
    MHS = "Rep"
    MHT = "Manchester Boston Regional Airport"
    MHU = "Mount Hotham"
    MHV = "Kern County"
    MHW = "Monteagudo"
    MHX = "Manihiki Island"
    MHY = "Morehead"
    MHZ = "Mildenhall Airport"
    MIA = "Miami International Airport"
    MIB = "Minot AFB"
    MIC = "Crystal"
    MID = "Manuel Crescencio Rejon International Airport"
    MIE = "Delaware County"
    MIF = "Roy Hurd Memorial"
    MIG = "Mianyang Nanjiao Airport"
    MIH = "Mitchell Plateau"
    MII = "Dr Gastao Vidigal Airport"
    MIJ = "Mili Island"
    MIK = "Mikkeli"
    MIM = "Merimbula Airport"
    MIN = "Minnipa"
    MIO = "Miami"
    MIP = "Mitspeh Ramon"
    MIQ = "Simón Bolívar International"
    MIR = "Habib Bourguiba International Airport"
    MIS = "Misima Island"
    MIT = "Kern County"
    MIU = "Maiduguri"
    MIV = "Millville"
    MIW = "Municipal"
    MIX = "Miriti"
    MIY = "Mittiebah"
    MIZ = "Mainoru"
    MJA = "Manja"
    MJB = "Mejit Island"
    MJC = "Man"
    MJD = "Mohenjodaro"
    MJE = "Majkin"
    MJF = "Kjaerstad Airport"
    MJG = "Mayajigua"
    MJI = "Mitiga Tripoli Airport"
    MJJ = "Moki"
    MJK = "Shark Bay"
    MJL = "Mouila"
    MJM = "Mbuji-Mayi"
    MJN = "Amborovy"
    MJO = "Mount Etjo Lodge"
    MJP = "Manjimup"
    MJQ = "Jackson"
    MJR = "Miramar"
    MJS = "Maganja Da Costa"
    MJT = "Mytilene International Airport"
    MJU = "Tampa Padang Airport"
    MJV = "Murcia-San Javier Airport"
    MJW = "Mahenye"
    MJX = "Robert J. Miller"
    MJY = "Mangunjaya"
    MJZ = "Mirnyj Airport"
    MKA = "Marianske Lazne"
    MKB = "Mekambo"
    MKC = "Charles B. Wheeler Downtown Airport"
    MKE = "General Mitchell International Airport"
    MKF = "Mckenna AAF"
    MKG = "Muskegon Airport"
    MKH = "Mokhotlong"
    MKI = "Mboki"
    MKJ = "Makoua"
    MKK = "Molokai Airport"
    MKL = "Mckellar Airport"
    MKM = "Mukah Airport"
    MKN = "Malekolon"
    MKO = "Davis Field"
    MKP = "Makemo"
    MKQ = "Mopah Airport"
    MKR = "Meekatharra"
    MKS = "Mekane Selam"
    MKT = "Municipal"
    MKU = "Makokou"
    MKV = "Mt Cavenagh"
    MKW = "Rendani Airport"
    MKY = "Mackay Airport"
    MKZ = "Malacca International Airport"
    MLA = "Malta International Airport"
    MLB = "Orlando Melbourne International Airport"
    MLC = "Mc Alester"
    MLD = "Malad City"
    MLE = "Male International Airport"
    MLF = "Milford"
    MLG = "Abdul Rachman Saleh Airport"
    MLH = "EuroAirport Basel-Mulhouse-Freiburg"
    MLI = "Quad City International Airport"
    MLJ = "Baldwin County"
    MLK = "Malta"
    MLL = "Marshall Don Hunter Sr. Airport"
    MLM = "Morelia Airport"
    MLN = "Melilla Airport"
    MLO = "Milos Airport"
    MLP = "Malabang"
    MLQ = "Malalaua"
    MLR = "Millicent"
    MLS = "Municipal"
    MLT = "Millinocket"
    MLU = "Monroe Regional Airport"
    MLV = "Merluna"
    MLW = "Sprigg Payne"
    MLX = "Malatya Airport"
    MLY = "Manley Hot Springs"
    MLZ = "Cerro Largo"
    MMA = "Malmö Bulltofta Airport"
    MMB = "Memanbetsu Airport"
    MMC = "Ciudad Mante"
    MMD = "Maridor"
    MME = "Durham Tees Valley Airport"
    MMF = "Mamfe"
    MMG = "Mount Magnet"
    MMH = "Mammoth Lakes Airport"
    MMI = "McMinn County"
    MMJ = "Matsumoto Airport"
    MMK = "Murmansk Airport"
    MML = "Municipal-Ryan Field"
    MMM = "Middlemount"
    MMN = "Minute Man Airfield"
    MMO = "Vila Do Maio"
    MMP = "Mompos"
    MMQ = "Mbala"
    MMR = "Camp Maybry AHP"
    MMS = "Selfs"
    MMT = "Mc Entire ANG Base"
    MMU = "Morristown Municipal Airport"
    MMV = "Mal"
    MMW = "Moma"
    MMX = "Malmo Airport"
    MMY = "Miyako Airport"
    MMZ = "Maimana"
    MNA = "Melangguane"
    MNB = "Moanda"
    MNC = "Nacala"
    MND = "Medina"
    MNE = "Mungeranie"
    MNF = "Mana Island Airstrip"
    MNG = "Maningrida Airport"
    MNH = "Minneriya"
    MNI = "Bramble Airport"
    MNJ = "Mananjary"
    MNK = "Maiana"
    MNL = "Ninoy Aquino International Airport"
    MNM = "Menominee"
    MNN = "Municipal"
    MNO = "Manono"
    MNP = "Maron"
    MNQ = "Monto"
    MNR = "Mongu"
    MNS = "Mansa"
    MNT = "Minto"
    MNU = "Maulmyine"
    MNV = "Mountain Valley"
    MNW = "Macdonald Downs"
    MNX = "Manicore"
    MNY = "Mono"
    MNZ = "Manassas Regional Airport/Harry P. Davis Field"
    MOA = "Orestes Acosta"
    MOB = "Mobile Regional Airport"
    MOC = "Montes Claros Airport"
    MOD = "Modesto Municipal Airport"
    MOE = "Momeik"
    MOF = "Wai Oti Airport"
    MOG = "Mong Hsat"
    MOH = "Maleo Airport"
    MOI = "Mitiaro Island"
    MOJ = "Moengo"
    MOK = "Muynak Airport"
    MOL = "Molde Airport Aro"
    MOM = "Moudjeria"
    MON = "Mount Cook Airport"
    MOO = "Moomba"
    MOP = "Municipal"
    MOQ = "Morondava Airport"
    MOR = "Moore-Murrell"
    MOS = "Intermediate"
    MOT = "Minot International Airport"
    MOU = "Mountain Village Airport"
    MOV = "Moranbah Airport"
    MOW = "Mpanda Airport"
    MOX = "Municipal"
    MOY = "Monterrey"
    MOZ = "Temae Airport"
    MPA = "Mpacha"
    MPB = "Miami Sea Plane Base"
    MPC = "Muko-Muko"
    MPD = "Mirpur Khas"
    MPE = "Griswold"
    MPF = "Mapoda"
    MPG = "Makini"
    MPH = "Boracay Airport"
    MPI = "Mamitupo"
    MPJ = "Petit Jean Park"
    MPK = "Mokpo"
    MPL = "Montpellier Mediterranee Airport"
    MPM = "Maputo International Airport"
    MPN = "Mount Pleasant"
    MPO = "Mt Pocono"
    MPP = "Mulatupo"
    MPQ = "Maan"
    MPR = "Mcpherson"
    MPS = "Mount Pleasant"
    MPT = "Maliana"
    MPU = "Mapua"
    MPV = "Edward F Knapp State"
    MPW = "Mariupol"
    MPX = "Miyanmin"
    MPY = "Maripasoula"
    MPZ = "Municipal"
    MQA = "Mandora"
    MQB = "Municipal"
    MQC = "Miquelon Airport"
    MQD = "Maquinchao"
    MQE = "Marqua"
    MQF = "Magnitogorsk Airport"
    MQG = "Midgard"
    MQH = "Municipal"
    MQI = "Quincy"
    MQJ = "Moma"
    MQK = "San Matias"
    MQL = "Mildura Airport"
    MQM = "Mardin Airport"
    MQN = "Mo i Rana Airport"
    MQO = "Malam"
    MQP = "Kruger Mpumalanga International Airport"
    MQQ = "Moundou"
    MQR = "Mosquera"
    MQS = "Mustique"
    MQT = "Sawyer International Airport"
    MQU = "Mariquita"
    MQV = "Mostaganem"
    MQW = "Telfair-Wheeler"
    MQX = "Makale Airport"
    MQY = "Smyrna"
    MQZ = "Margaret River"
    MRA = "Misurata Airport"
    MRB = "Eastern Wv Regional Airport/Shepherd Field"
    MRC = "Maury County"
    MRD = "A Carnevalli"
    MRE = "Mara Lodges Airport"
    MRF = "Municipal"
    MRG = "Mareeba"
    MRH = "May River"
    MRI = "Merrill Field"
    MRJ = "Marcala"
    MRK = "Marco Island"
    MRL = "Miners Lake"
    MRM = "Manare"
    MRN = "Lenoir"
    MRO = "Masterton/Hood Aerodrome"
    MRP = "Marla"
    MRQ = "Marinduque"
    MRR = "Macara"
    MRS = "Marseille Provence Airport"
    MRT = "Moroak"
    MRU = "Sir Seewoosagur Ramgoolam International Airport"
    MRV = "Mineralnye Vody Airport"
    MRW = "Maribo"
    MRX = "Mahshahr Airport"
    MRY = "Monterey Regional Airport"
    MRZ = "Moree Airport"
    MSA = "Muskrat Dam"
    MSB = "Marigot SPB"
    MSC = "Falcon Field"
    MSD = "Mt Pleasant"
    MSE = "Kent International"
    MSF = "Mount Swan"
    MSG = "Matsaile"
    MSH = "Masirah"
    MSI = "Masalembo"
    MSJ = "Misawa"
    MSK = "Mastic Point"
    MSL = "Northwest Alabama Regional Airport"
    MSM = "Masi Manimba"
    MSN = "Dane County Regional Airport"
    MSO = "Missoula International Airport"
    MSP = "Minneapolis-St. Paul International Airport"
    MSQ = "Minsk National Airport"
    MSR = "Mus Airport"
    MSS = "Richards Field"
    MST = "Maastricht Aachen Airport"
    MSU = "Moshoeshoe International Airport"
    MSV = "Sullivan County International"
    MSW = "Massawa International"
    MSX = "Mossendjo"
    MSY = "Louis Armstrong New Orleans International Airport"
    MSZ = "Yuri Gagarin Airport"
    MTA = "Matamata"
    MTB = "Monte Libano"
    MTC = "Selfridge ANGB"
    MTD = "Mt Sandford"
    MTE = "Monte Alegre"
    MTF = "Mizan Teferi"
    MTG = "Mato Grosso"
    MTH = "Florida Keys Marathon Airport"
    MTI = "Mosteiros"
    MTJ = "Montrose Regional Airport"
    MTK = "Makin Island"
    MTL = "Maitland"
    MTM = "SPB"
    MTN = "Glenn L Martin"
    MTO = "Coles County Memorial"
    MTP = "Montauk Airport"
    MTQ = "Mitchell"
    MTR = "Los Garzones Airport"
    MTS = "Matsapha International"
    MTT = "Minatitlan Airport"
    MTU = "Montepuez"
    MTV = "Mota Lava"
    MTW = "Municipal"
    MTX = "Metro Field"
    MTY = "Gen Mariano Escobedo Airport"
    MTZ = "Masada"
    MUA = "Munda Airport"
    MUB = "Maun Airport"
    MUC = "Franz Josef Strauss Airport"
    MUD = "Mueda"
    MUE = "Kamuela"
    MUF = "Muting"
    MUG = "Mulege"
    MUH = "Mersa Matruh"
    MUI = "Muir AAF"
    MUJ = "Mui"
    MUK = "Mauke Island"
    MUL = "Spence"
    MUN = "Jose Tadeo Monagas International Airport"
    MUO = "Mountain Home AFB"
    MUP = "Mulga Park"
    MUQ = "Muccan"
    MUR = "Marudi Airport"
    MUS = "Marcus Island"
    MUT = "Muscatine"
    MUU = "Mount Union"
    MUV = "Mustin Alf"
    MUW = "Mascara-Ghriss"
    MUX = "Multan Airport"
    MUY = "Mouyondzi"
    MUZ = "Musoma Airport"
    MVA = "Reykiahlid"
    MVB = "Franceville/Mvengue"
    MVC = "Monroe - Walton County"
    MVD = "Carrasco International Airport"
    MVE = "Montevideo-Chippewa"
    MVF = "Dixsept Rosado"
    MVG = "Mevang"
    MVH = "Macksville"
    MVI = "Manetai"
    MVJ = "Marlboro"
    MVK = "Mulka"
    MVL = "Morrisville-Stowe"
    MVM = "Monument Valley"
    MVN = "Mt Vernon-Outland"
    MVO = "Mongo"
    MVP = "Mitu"
    MVQ = "Mogilev"
    MVR = "Salam"
    MVS = "Aeroporto Max Feffer"
    MVT = "Mataiva"
    MVU = "Musgrave"
    MVV = "Megeve"
    MVW = "Skagit Regional"
    MVX = "Minvoul"
    MVY = "Martha's Vineyard Airport"
    MVZ = "Masvingo"
    MWA = "Williamson County Airport"
    MWB = "Morawa"
    MWC = "Lawrence J Timmerman"
    MWD = "Mianwali"
    MWE = "Merowe"
    MWF = "Maewo"
    MWG = "Marawaka"
    MWH = "Grant County"
    MWI = "Maramuni"
    MWJ = "Matthews Ridge"
    MWK = "Matak"
    MWL = "Mineral Wells Airport"
    MWM = "Windom Municipal"
    MWN = "Mwadui"
    MWO = "Hook Field"
    MWP = "Mountain"
    MWQ = "Magwe"
    MWR = "Motswari Airfield"
    MWS = "Mount Wilson"
    MWT = "Moolawatana"
    MWU = "Mussau"
    MWV = "Mundulkiri"
    MWX = "Muan International Airport"
    MWY = "Miranda Downs"
    MWZ = "Mwanza Airport"
    MXA = "Municipal"
    MXB = "Masamba"
    MXC = "San Juan County"
    MXD = "Marion Downs"
    MXE = "Maxton"
    MXF = "Maxwell AFB"
    MXG = "Marlborough"
    MXH = "Moro Airport"
    MXI = "Imelda Romualdez Marcos"
    MXJ = "Minna"
    MXK = "Mindik"
    MXL = "Mexicali Airport"
    MXM = "Morombe"
    MXN = "Morlaix"
    MXO = "Municipal"
    MXP = "Milano Malpensa Airport"
    MXQ = "Lorenzo Airport"
    MXR = "Mirgorod"
    MXS = "Maota Savaii Island"
    MXT = "Maintirano"
    MXU = "Mullewa"
    MXV = "Moron"
    MXW = "Mandalgobi"
    MXX = "Mora Airport"
    MXY = "Mccarthy"
    MXZ = "Mei Xian Airport"
    MYA = "Moruya Airport"
    MYB = "Mayoumba"
    MYC = "Maracay"
    MYD = "Malindi Airport"
    MYE = "Miyake Jima"
    MYF = "Montgomery Field"
    MYG = "Mayaguana Airport"
    MYH = "Marble Canyon"
    MYI = "Murray Island"
    MYJ = "Matsuyama Airport"
    MYK = "May Creek"
    MYL = "Mccall"
    MYM = "Monkey Mountain"
    MYN = "Mareb"
    MYO = "Myroodah"
    MYP = "Mary Airport"
    MYQ = "Mysore"
    MYR = "Myrtle Beach International Airport"
    MYT = "Myitkyina Airport"
    MYU = "Ellis Field"
    MYV = "Yuba County"
    MYW = "Mtwara Airport"
    MYX = "Menyamya"
    MYY = "Miri Airport"
    MYZ = "Monkey Bay"
    MZA = "Mayor Pnp Nancy Flore Airport"
    MZB = "Mocimboa Praia"
    MZC = "Mitzic"
    MZD = "Mendez"
    MZE = "Manatee"
    MZF = "Mzamba(Wild Coast Sun)"
    MZG = "Magong Airport"
    MZH = "Merzifon Airport"
    MZI = "Mopti"
    MZJ = "Marana"
    MZK = "Marakei"
    MZL = "La Nubia Airport"
    MZM = "Frescaty"
    MZN = "Minj"
    MZO = "Sierra Maestra Airport"
    MZP = "Motueka"
    MZQ = "Mkuze"
    MZR = "Mazar-I-Sharif Airport"
    MZS = "Mostyn"
    MZT = "Mazatlan International Airport"
    MZU = "Muzaffarpur"
    MZV = "Mulu Airport"
    MZW = "Mechria"
    MZX = "Mena"
    MZY = "Mossel Bay"
    MZZ = "Marion"
    NAA = "Narrabri"
    NAB = "Albany NAS"
    NAC = "Naracoorte"
    NAD = "Macanal"
    NAE = "Natitingou"
    NAF = "Banaina"
    NAG = "Dr. Babasaheb Ambedkar International Airport"
    NAH = "Naha"
    NAI = "Annai"
    NAJ = "Nakhichevan Airport"
    NAK = "Nakhon Ratchasima"
    NAL = "Nalchik Airport"
    NAM = "Namlea"
    NAN = "Nadi International Airport"
    NAO = "Nanchong Airport"
    NAP = "Naples International Airport"
    NAQ = "Qaanaaq Airport"
    NAR = "Nare"
    NAS = "Lynden Pindling International Airport"
    NAT = "Sao Goncalo do Amarante-Governador Aluizio Alves Intl Airport"
    NAU = "Napuka Island"
    NAV = "Nevsehir"
    NAW = "Narathiwat Airport"
    NAX = "Kalaeloa John Rodgers Field"
    NAY = "Beijing Nanyuan Airport"
    NAZ = "Nana"
    NBA = "Nambaiyufa"
    NBB = "Barrancominas"
    NBC = "Begishevo Airport"
    NBE = "Enfidha - Hammamet International Airport"
    NBG = "NAS/Alvin Callendar"
    NBH = "Nambucca Heads"
    NBL = "San Blas"
    NBN = "Annobón"
    NBO = "Jomo Kenyatta International Airport"
    NBP = "Battery Pk City/N. Cov"
    NBS = "Changbaishan Airport"
    NBU = "NAS"
    NBV = "Cana Brava"
    NBW = "Guantanamo NAS"
    NBX = "Nabire"
    NCA = "North Caicos"
    NCE = "Cote D'Azur Airport"
    NCG = "Nueva Casas Grandes"
    NCH = "Nachingwea"
    NCI = "Necocli"
    NCJ = "Sunchales"
    NCL = "Newcastle International Airport"
    NCN = "New Chenega"
    NCO = "NAS"
    NCQ = "Atlanta NAS"
    NCR = "San Carlos"
    NCS = "Newcastle"
    NCT = "Guanacaste"
    NCU = "Nukus Airport"
    NCY = "Annecy-Meythe"
    NDA = "Bandanaira"
    NDB = "Nouadhibou Airport"
    NDC = "Nanded"
    NDD = "Sumbe"
    NDE = "Mandera"
    NDF = "Ndalatandos"
    NDG = "Qiqihar Airport"
    NDI = "Namudi"
    NDJ = "Ndjamena Airport"
    NDK = "Namdrik Island"
    NDL = "Ndele"
    NDM = "Mendi"
    NDN = "Nadunumu"
    NDO = "La Palma Del Condado"
    NDP = "Ellyson NAS"
    NDR = "Nador International Airport"
    NDS = "Sandstone"
    NDU = "Rundu"
    NDV = "USN Heliport"
    NDY = "Sanday"
    NEA = "Brunswick Golden Isles"
    NEC = "Necochea"
    NEF = "Neftekamsk"
    NEG = "Negril"
    NEI = "Terney Airport"
    NEJ = "Nejjo"
    NEK = "Nekemt"
    NEL = "Naec"
    NEN = "Olf Usn"
    NER = "Neryungri Airport"
    NES = "East 34th St Landing"
    NET = "New Bight"
    NEU = "Sam Neua"
    NEV = "Newcastle Airport"
    NEW = "Lakefront Airport"
    NFB = "Detroit NAF"
    NFG = "Nefteyugansk"
    NFL = "NAS"
    NFO = "Mata'aho"
    NFR = "Nafoora"
    NGA = "Young"
    NGB = "Ningbo Airport"
    NGC = "North Rim"
    NGD = "Captain Auguste George"
    NGE = "Ngaoundéré"
    NGF = "Marine Corps Air Station Kaneohe Bay"
    NGI = "Ngau Island"
    NGK = "Nogliki Airport"
    NGL = "Ngala Airfield"
    NGN = "Nargana"
    NGO = "Chubu Centrair International Airport"
    NGP = "NAS"
    NGQ = "Ngari Gunsa/Ali Kunsha"
    NGR = "Ningerum"
    NGS = "Nagasaki Airport"
    NGU = "NAS Chambers"
    NGW = "Cabaniss Field"
    NGX = "Manang"
    NGZ = "NAS"
    NHA = "Nha Trang"
    NHD = "Minhad AB"
    NHF = "New Halfa"
    NHK = "Patuxent River NAS"
    NHS = "Nushki"
    NHT = "Northolt"
    NHV = "Nuku Hiva Airport"
    NHX = "Barin Olf Osn"
    NHZ = "NAS"
    NIA = "Nimba"
    NIB = "Nikolai"
    NIC = "Nicosia International"
    NIE = "Niblack"
    NIF = "Nifty Airport"
    NIG = "Nikunau"
    NIK = "Niokolo Koba"
    NIM = "Niamey Airport"
    NIN = "Ninilchik"
    NIO = "Nioki"
    NIP = "Jacksonville NAS"
    NIR = "Chase Field NAS"
    NIS = "Simberi"
    NIT = "Niort"
    NIU = "Niau"
    NIX = "Nioro"
    NJA = "Atsugi NAS"
    NJC = "Nizhnevartovsk Airport"
    NJF = "Al-Najaf International Airport"
    NJJ = "Nenjian Melgen Airport"
    NJK = "El Centro NAF"
    NKA = "Nkan"
    NKB = "Noonkanbah"
    NKC = "Nouakchott International Airport"
    NKD = "Sinak"
    NKG = "Nanjing Lukou International Airport"
    NKI = "Naukiti"
    NKL = "Nkolo"
    NKM = "Nagoya Airport"
    NKN = "Nankina"
    NKO = "Ankokoambo"
    NKP = "Nakhon Phanom Airport"
    NKS = "Nkongsamba"
    NKT = "Shirnak"
    NKU = "Nkaus"
    NKV = "Nichen Cove"
    NKX = "Miramar MS"
    NKY = "Nkayi"
    NLA = "Simon Mwansa Kapwepwe International Airport"
    NLC = "Lemoore NAS (Reeves Field)"
    NLD = "Quetzalcoatl International Airport"
    NLE = "Jerry Tyler Memorial"
    NLF = "Darnley Island"
    NLG = "Nelson Lagoon"
    NLH = "Ninglang Luguhu Airport"
    NLI = "Nikolaevsk-na-Amure"
    NLK = "Norfolk Island Airport"
    NLL = "Nullagine"
    NLN = "Kneeland"
    NLO = "N'dolo"
    NLP = "Nelspruit Airport"
    NLS = "Nicholson"
    NLT = "Nalati Airport"
    NLU = "Santa Lucia"
    NLV = "Nikolaev (Mykolaiv)"
    NMA = "Namangan Airport"
    NMB = "Daman"
    NMC = "Norman's Cay"
    NME = "Nightmute Airport"
    NMF = "Maafaru International Airport"
    NMG = "San Miguel"
    NML = "Mildred Lake"
    NMN = "Nomane"
    NMP = "New Moon"
    NMR = "Nappa Merry"
    NMS = "Namsang"
    NMT = "Namtu"
    NMU = "Namu"
    NNA = "NAF"
    NNB = "Santa Ana Airport"
    NND = "Nangade"
    NNG = "Nanning Airport"
    NNI = "Namutoni"
    NNK = "Naknek"
    NNL = "Nondalton"
    NNM = "Naryan-Mar Airport"
    NNR = "Connemara"
    NNT = "Nan Airport"
    NNU = "Nanuque"
    NNX = "Nunukan Airport"
    NNY = "Nanyang Airport"
    NOA = "Nowra"
    NOB = "Nosara Beach"
    NOC = "Ireland West Airport Knock"
    NOD = "Norden Norddeich Airport"
    NOG = "Nogales"
    NOH = "Chicago NAS"
    NOI = "Novorossijsk"
    NOJ = "Nojabrxsk Airport"
    NOK = "Nova Xavantina"
    NOL = "Nakolik River"
    NOM = "Nomad River"
    NON = "Nonouti"
    NOO = "Naoro"
    NOP = "Sinop Airport - Turkey"
    NOR = "Nordfjordur"
    NOS = "Fascene Airport"
    NOT = "Novato"
    NOU = "Tontouta Airport"
    NOV = "Huambo"
    NOZ = "Novokuznetsk Airport"
    NPA = "Pensacola NAS"
    NPE = "Hawkes Bay Airport"
    NPG = "Nipa"
    NPH = "Nephi"
    NPL = "New Plymouth Airport"
    NPO = "Nangapinoh"
    NPP = "Napperby"
    NPR = "Novo Progresso Municipal"
    NPT = "State"
    NPU = "San Pedro Uraba"
    NPY = "Mpanda Airport"
    NQA = "Millington Regional Jetport"
    NQI = "NAS"
    NQL = "Niquelandia"
    NQN = "Presidente Peron International Airport"
    NQT = "Nottingham Airport"
    NQU = "Nuqui"
    NQX = "Key West NAS /Boca Chica Field (private U. S. Navy )"
    NQY = "Newquay Cornwall Airport"
    NQZ = "Nursultan Nazarbayev International Airport"
    NRA = "Narrandera"
    NRB = "Ns"
    NRC = "Aux Field"
    NRD = "Norderney"
    NRE = "Namrole"
    NRG = "Narrogin"
    NRI = "Shangri-la"
    NRK = "Kungsangen Airport"
    NRL = "North Ronaldsay Airport"
    NRM = "Nara"
    NRN = "Weeze Airport"
    NRR = "Roosevelt NAS"
    NRS = "NAS"
    NRT = "Narita International Airport"
    NRY = "Newry"
    NSB = "North SPB"
    NSE = "Whiting Field NAS"
    NSF = "Andrews NAF"
    NSH = "Now Shahr Airport"
    NSI = "Nsimalen Airport"
    NSK = "Noril'sk Airport"
    NSL = "Slayton Municipal"
    NSM = "Norseman"
    NSN = "Nelson Airport"
    NSO = "Scone"
    NSP = "NAF"
    NSR = "São Raimundo Nonato Airport"
    NST = "Nakhon Si Thammarat Airport"
    NSV = "Noosaville"
    NSX = "Hovercraft/Launch Pt"
    NSY = "NAS Sigonella"
    NTA = "Natadola"
    NTB = "Notodden Airport"
    NTC = "Santa Carolina"
    NTD = "Point Mugu NAS (Naval Base Ventura County"
    NTE = "Nantes Atlantique Airport"
    NTG = "Nantong Xingdong Airport"
    NTI = "Bintuni"
    NTJ = "Manti-Ephraim"
    NTL = "Newcastle Airport"
    NTM = "Miracema Do Norte"
    NTN = "Normanton Airport"
    NTO = "Santo Antao"
    NTQ = "Noto Airport"
    NTR = "Aeropuerto del Norte International Airport"
    NTT = "Kuini Lavenia"
    NTU = "NAS"
    NTX = "Natuna Ranai"
    NTY = "Pilanesberg International Airport"
    NUA = "Gregory's Lake"
    NUB = "Numbulwar"
    NUD = "En Nahud"
    NUE = "Nuremberg Airport"
    NUF = "Castlereigh Reservoir Waterdrome"
    NUG = "Nuguria"
    NUH = "Nunchia"
    NUI = "Nuiqsut Airport"
    NUJ = "Nojeh"
    NUK = "Nukutavake"
    NUL = "Nulato Airport"
    NUM = "Neom Airport"
    NUN = "Saufley NAS"
    NUP = "Nunapitchuk"
    NUQ = "Moffett Field"
    NUR = "Nullarbor"
    NUS = "Norsup Airport"
    NUT = "Nutuve"
    NUU = "Nakuru"
    NUW = "Whidbey Island NAS (Ault Field)"
    NUX = "Novy Urengoy Airport"
    NVA = "Benito Salas Airport"
    NVD = "Nevada"
    NVG = "Nueva Guinea"
    NVI = "Navoi Airport"
    NVK = "Framnes"
    NVM = "Brigadeiro Eduardo Gomes Airport"
    NVN = "Nervino"
    NVP = "Novo Aripuana"
    NVR = "Novgorod"
    NVS = "Nevers"
    NVT = "Navegantes Airport"
    NVY = "Neyveli"
    NWA = "Moheli"
    NWH = "Parlin Field"
    NWI = "Norwich International Airport"
    NWP = "NS"
    NWS = "Pier 11/Wall St. SPB"
    NWT = "Nowata"
    NWU = "Bermuda NAS"
    NXX = "Willow Grove NAS"
    NYA = "Nyagan Airport"
    NYE = "Nyeri"
    NYG = "Quantico NAS"
    NYI = "Sunyani"
    NYK = "Nanyuki"
    NYM = "Nadym Airport"
    NYN = "Nyngan"
    NYO = "Stockholm Skavsta Airport"
    NYR = "Nyurba Airport"
    NYS = "New York Skyports Seaplane Base"
    NYT = "Nay Pyi Taw Airport"
    NYU = "Nyaung U Airport"
    NYW = "Monywar Airport"
    NZA = "Nzagi"
    NZC = "Maria Reiche Neuman Airport"
    NZE = "Nzerekore"
    NZH = "Manzhouli Airport"
    NZL = "Zhalantun Chengjisihan Airport"
    NZW = "South Weymouth"
    NZY = "North Island NAS"
    OAA = "Shank Air Base"
    OAG = "Orange Airport"
    OAH = "Shindand Air Base"
    OAI = "Bagram"
    OAJ = "Albert J Ellis Airport"
    OAK = "Metropolitan Oakland International Airport"
    OAL = "Cacoal Airport"
    OAM = "Oamaru"
    OAN = "Olanchito"
    OAR = "Marina Municipal"
    OAS = "Sharana Air Base"
    OAX = "Xoxocotlan Airport"
    OAZ = "Camp Bastion"
    OBA = "Oban"
    OBC = "Obock"
    OBD = "Obano"
    OBE = "County"
    OBF = "Oberpfaffenhofen"
    OBI = "Obidos"
    OBK = "Sky Harbor"
    OBL = "Zoersel"
    OBM = "Morobe"
    OBN = "Oban Airport"
    OBO = "Tokachi-Obihiro Airport"
    OBS = "Vals-Lanas"
    OBT = "Oakland/Coliseum Stat"
    OBU = "Kobuk/Wien Airport"
    OBX = "Obo"
    OBY = "Ittoqqortoormiit"
    OCA = "Ocean Reef"
    OCC = "Coca Airport"
    OCE = "Municipal"
    OCF = "Taylor Field"
    OCH = "A L Mangham Jr. Regional"
    OCI = "Oceanic"
    OCJ = "Boscobel"
    OCM = "Boolgeeda"
    OCN = "Municipal"
    OCS = "Corisco International Airport"
    OCV = "Aguasclaras"
    OCW = "Warren Field"
    ODA = "Ouadda"
    ODB = "Cordoba"
    ODC = "Oakdale"
    ODD = "Oodnadatta"
    ODE = "Beldringe"
    ODH = "Odiham RAF Station"
    ODJ = "Ouanda Djalle"
    ODL = "Cordillo Downs"
    ODM = "Garrett County Airport"
    ODN = "Long Seridan Airport"
    ODO = "Bodaybo Airport"
    ODR = "Ord River"
    ODS = "Odessa International Airport"
    ODW = "Oak Harbor"
    ODY = "Oudomxay Airport"
    OEA = "Oneal"
    OEC = "Ocussi"
    OEL = "Orel"
    OEM = "Vincent Fayks"
    OEO = "Municipal"
    OER = "Ornskoldsvik Airport"
    OES = "San Antonio Oeste"
    OFF = "Offutt Air Force Base"
    OFI = "Ouango Fitini"
    OFJ = "Olafsfjordur"
    OFK = "Stefan Field"
    OFU = "Airstrip"
    OGA = "Searle Field"
    OGB = "Municipal"
    OGD = "Municipal"
    OGE = "Ogeranang"
    OGG = "Kahului Airport"
    OGL = "Ogle Airport"
    OGM = "Ogobsucum"
    OGN = "Yonaguni Jima"
    OGO = "Abengourou"
    OGR = "Bongor"
    OGS = "Ogdensburg Airport"
    OGU = "Ordu Giresun Airport"
    OGV = "Ongava Game Reserve"
    OGX = "Ain Beida Airport"
    OGZ = "Vladikavkaz Airport"
    OHA = "Royal Air Force Base"
    OHB = "Ambohibary"
    OHC = "AFS"
    OHD = "Ohrid Airport"
    OHE = "Mohe Airport"
    OHH = "Novostroyka Airport"
    OHI = "Oshakati"
    OHO = "Okhotsk"
    OHR = "Wyk Auf Foehr"
    OHS = "Sohar Airport"
    OHT = "Kohat"
    OIA = "Ourilandia"
    OIC = "Eaton"
    OIL = "Splane Memorial"
    OIM = "Oshima"
    OIR = "Okushiri Airport"
    OIT = "Oita Airport"
    OJC = "Johnson Executive"
    OJU = "Tanjung Api Airport"
    OKA = "Naha Airport"
    OKB = "Fraser Island"
    OKC = "Will Rogers World Airport"
    OKD = "Okadama Airport"
    OKE = "Okino Erabu"
    OKF = "Okaukuejo"
    OKG = "Okoyo"
    OKH = "Cottesmor RAF"
    OKI = "Oki Island"
    OKJ = "Okayama Airport"
    OKK = "Kokomo"
    OKL = "Oksibil"
    OKM = "Okmulgee"
    OKN = "Okondja"
    OKO = "Yokota AFB"
    OKP = "Oksapmin"
    OKQ = "Okaba"
    OKR = "Yorke Island"
    OKS = "Oshkosh"
    OKT = "Oktiabrskij"
    OKU = "Mokuti Lodge"
    OKV = "Okao"
    OKY = "Oakey"
    OLA = "Orland"
    OLB = "Olbia Costa Smeralda Airport"
    OLC = "Sen. Eunice Micheles"
    OLD = "Old Town"
    OLE = "Municipal"
    OLF = "Wolf Point International Airport"
    OLG = "Olare Airport"
    OLH = "Old Harbor SPB"
    OLI = "Rif"
    OLJ = "Olpoi"
    OLK = "Fuerte Olimpo"
    OLL = "Ollombo"
    OLM = "Olympia"
    OLN = "Colonia Sarmiento"
    OLO = "Olomouc"
    OLP = "Olympic Dam Airport"
    OLQ = "Olsobip"
    OLR = "Salerno Air Base"
    OLS = "International"
    OLU = "Columbus Municipal"
    OLV = "Olive Branch Airport"
    OLX = "Olkiombo Airport"
    OLY = "Olney-Noble"
    OLZ = "Olokminsk Airport"
    OMA = "Eppley Airfield"
    OMB = "Omboue"
    OMC = "Ormoc"
    OMD = "Oranjemund Airport"
    OME = "Nome Airport"
    OMF = "King Hussein"
    OMG = "Omega"
    OMH = "Urmia Airport"
    OMI = "Omidieh"
    OMJ = "Omura"
    OMK = "Municipal"
    OML = "Omkalai"
    OMM = "Marmul"
    OMO = "Mostar Airport"
    OMR = "Oradea Airport"
    OMS = "Omsk Airport"
    OMY = "Oddor Meanche"
    ONA = "Municipal"
    ONB = "Ononge"
    OND = "Ondangwa Airport"
    ONE = "Onepusu"
    ONG = "Mornington Airport"
    ONH = "Municipal"
    ONI = "Moanamani"
    ONJ = "Odate Noshiro Airport"
    ONK = "Olenyok Airport"
    ONL = "Municipal"
    ONM = "Socorro"
    ONN = "Onion Bay"
    ONO = "Ontario Municipal Airport"
    ONP = "Newport"
    ONQ = "Zonguldak"
    ONR = "Monkira"
    ONS = "Onslow Airport"
    ONT = "Ontario International Airport"
    ONU = "Ono I Lau"
    ONX = "Enrique Adolfo Jimenez"
    ONY = "Olney"
    OOA = "Municipal"
    OOD = "Gudai-Darri Airstrip"
    OOK = "Toksook Bay Airport"
    OOL = "Gold Coast Airport"
    OOM = "Snowy Mountains Airport"
    OOR = "Mooraberree"
    OOT = "Onotoa"
    OPA = "Kopasker"
    OPB = "Open Bay"
    OPF = "Opa-locka Executive Airport"
    OPI = "Oenpelli"
    OPL = "St Landry Parish"
    OPO = "Porto Airport"
    OPP = "Salinópolis Airport"
    OPS = "Sinop Airport"
    OPU = "Balimo"
    OPW = "Opuwa"
    ORA = "Oran"
    ORB = "Orebro-Bofors Airport"
    ORC = "Orocue"
    ORD = "O'Hare International Airport"
    ORE = "Orleans"
    ORF = "Norfolk International Airport"
    ORG = "Zorg En Hoop"
    ORH = "Worcester Regional Airport"
    ORI = "Port Lions SPB"
    ORJ = "Orinduik"
    ORK = "Cork Airport"
    ORL = "Orlando Executive"
    ORM = "Northampton"
    ORN = "Es Senia Airport"
    ORO = "Yoro"
    ORP = "Orapa"
    ORQ = "Heliport"
    ORR = "Yorketown"
    ORS = "Waterport"
    ORT = "Northway"
    ORU = "Oruro"
    ORV = "Robert (Bob) Curtis Memorial Airport"
    ORW = "Ormara"
    ORX = "Oriximina"
    ORY = "Paris Orly Airport"
    ORZ = "Orange Walk"
    OSB = "Osage Beach"
    OSC = "Wurtsmith AFB"
    OSD = "Are Ostersund Airport"
    OSE = "Omora"
    OSF = "Ostafyevo International Business Airport"
    OSG = "Ossima"
    OSH = "Wittman Field"
    OSI = "Osijek Airport"
    OSJ = "Ol Seki Airport"
    OSK = "Oskarshamn"
    OSL = "Oslo Airport Gardermoen"
    OSM = "Mosul"
    OSN = "Osan AB"
    OSO = "Osborne Mine"
    OSR = "Mosnov Airport"
    OSS = "Osh Airport"
    OST = "Ostend-Bruges International Airport"
    OSU = "Ohio State University"
    OSW = "Orsk Airport"
    OSX = "Attala County"
    OSY = "Namsos Airport"
    OSZ = "Koszalin"
    OTA = "Mota"
    OTC = "Bol"
    OTD = "Contadora"
    OTG = "Worthington"
    OTH = "Southwest Oregon Regional Airport"
    OTI = "Pitu"
    OTJ = "Otjiwarongo"
    OTK = "Tillamook"
    OTL = "Boutilimit"
    OTM = "Industrial"
    OTN = "Green"
    OTO = "Vor"
    OTP = "Bucharest Henri Coanda International Airport"
    OTQ = "Otog Front Banner Oljoq Airport"
    OTR = "Coto 47"
    OTS = "Anacortes"
    OTT = "Andre Maggi"
    OTU = "Otu"
    OTV = "Ontong Java"
    OTY = "Oria"
    OTZ = "Ralph Wien Memorial Airport"
    OUA = "Ouagadougou International Airport"
    OUD = "Les Angades Airport"
    OUE = "Ouesso"
    OUG = "Ouahigouya"
    OUH = "Oudtshoorn"
    OUI = "Ban Houei"
    OUK = "Outer Skerries"
    OUL = "Oulu Airport"
    OUM = "Oum Hadjer"
    OUN = "Max Westheimer"
    OUR = "Batouri"
    OUS = "Ourinhos"
    OUT = "Bousso"
    OUU = "Ouanga"
    OUZ = "Zouerate"
    OVA = "Bekily"
    OVB = "Novosibirsk Tolmachevo Airport"
    OVD = "Asturias Airport"
    OVE = "Oroville"
    OVG = "Overberg (FAOB)"
    OVL = "Ovalle"
    OVR = "Olavarria"
    OVS = "Sovetsky Airport"
    OWA = "Owatonna"
    OWB = "Daviess County Airport"
    OWD = "Memorial"
    OWE = "Owendo"
    OWK = "Central Maine Airport of Norridgewock"
    OXB = "Osvaldo Vieira Airport"
    OXC = "Waterbury-oxford"
    OXD = "Miami University"
    OXF = "Oxford (Kidlington)"
    OXO = "Orientos"
    OXR = "Ventura"
    OXY = "Morney"
    OYA = "Goya"
    OYC = "Camopi Airport"
    OYE = "Oyem"
    OYG = "Moyo"
    OYK = "Oiapoque"
    OYL = "Moyale"
    OYN = "Ouyen"
    OYO = "Tres Arroyos"
    OYP = "St-Georges de lOyapock"
    OYS = "Yosemite Ntl Park"
    OZA = "Ozona Municipalcipal"
    OZC = "Labo Airport"
    OZG = "Zagora Airport"
    OZH = "Zaporozhye Airport"
    OZI = "Bobadilla"
    OZP = "Moron"
    OZR = "Cairns AAF"
    OZU = "Montilla"
    OZZ = "Ouarzazate Airport"
    PAA = "Pa-an"
    PAB = "Bilaspur"
    PAC = "Marcos A. Gelabert International Airport"
    PAD = "Paderborn Lippstadt Airport"
    PAE = "Snohomish County - Paine Field"
    PAF = "Pakuba"
    PAG = "Pagadian Airport"
    PAH = "Barkley Regional Airport"
    PAJ = "Para Chinar"
    PAK = "Port Allen"
    PAL = "Palanquero"
    PAM = "Tyndall AFB"
    PAN = "Pattani"
    PAO = "Palo Alto"
    PAP = "Toussaint Louverture International Airport"
    PAQ = "Palmer Municipalcipal"
    PAS = "Paros Airport"
    PAT = "Jay Prakash Narayan International Airport"
    PAU = "Pauk"
    PAV = "Paulo Afonso Airport"
    PAW = "Pambwa"
    PAX = "Port De Paix"
    PAY = "Pamol"
    PAZ = "El Tajin National Airport"
    PBA = "Point Barrow"
    PBB = "Paranaiba"
    PBC = "Huejotsingo Airport"
    PBD = "Porbandar"
    PBE = "Puerto Berrio"
    PBF = "Grider Field"
    PBG = "Plattsburgh International Airport"
    PBH = "Paro Airport"
    PBI = "Palm Beach International Airport"
    PBJ = "Paama"
    PBK = "Pack Creek"
    PBL = "Puerto Cabello"
    PBM = "Zanderij International Airport"
    PBN = "Porto Amboim"
    PBO = "Paraburdoo Airport"
    PBP = "Punta Islita"
    PBQ = "Pimenta Bueno"
    PBR = "Puerto Barrios"
    PBS = "Patong Beach"
    PBT = "Puerto Leda"
    PBU = "Putao"
    PBV = "Porto Dos Gauchos"
    PBW = "Palibelo"
    PBX = "Porto Alegre Do Norte"
    PBY = "Hamilton/Proserpine"
    PBZ = "Plettenberg Bay Airport"
    PCA = "Portage Creek"
    PCB = "Pondok Cabe"
    PCC = "Puerto Rico"
    PCD = "Prairie du Chien Municipal Airport"
    PCE = "Painter Creek"
    PCF = "Potchefstroom"
    PCG = "Paso Caballos"
    PCH = "Palacios"
    PCJ = "Puerto La Victoria"
    PCK = "Porcupine Creek"
    PCL = "Capitan Rolden Airport"
    PCM = "Playa Del Carmen"
    PCN = "Picton Aerodrome"
    PCO = "Punta Colorada"
    PCP = "Principe"
    PCQ = "Bounneua"
    PCR = "Puerto Carreno Airport"
    PCS = "Picos"
    PCT = "Princeton"
    PCU = "Pearl River County"
    PCV = "Punta Chivato"
    PDA = "Puerto Inirida"
    PDB = "Pedro Bay"
    PDC = "Mueo"
    PDD = "Ponta de Ouro"
    PDE = "Pandie Pandie"
    PDF = "Prado"
    PDG = "Minangkabau International Airport"
    PDI = "Pindiu"
    PDK = "DeKalb Peachtree Airport"
    PDL = "Joao Paulo II Airport"
    PDM = "Pedasí Airport"
    PDN = "Parndana"
    PDO = "Pendopo"
    PDP = "Capitan de Corbeta Carlos A. Curbelo International Airport"
    PDR = "Presidente Dutra"
    PDS = "Piedras Negras International Airport"
    PDT = "Eastern Oregon Regional Airport"
    PDU = "Paysandu"
    PDV = "Plovdiv Airport"
    PDX = "Portland International Airport"
    PDZ = "Pedernales"
    PEA = "Penneshaw"
    PEB = "Pebane"
    PEC = "Pelican SPB"
    PED = "Pardubice Airport"
    PEE = "Perm International Airport"
    PEF = "Peenemuende"
    PEG = "Sant Egidio Airport"
    PEH = "Pehuajo"
    PEI = "Matecana International Airport"
    PEJ = "Peschiei"
    PEK = "Beijing Capital International Airport"
    PEL = "Pelaneng"
    PEM = "Puerto Maldonado Airport"
    PEN = "Penang International Airport"
    PEP = "Peppimenarti"
    PEQ = "Pecos City"
    PER = "Perth Airport"
    PES = "Petrozavodsk Airport"
    PET = "Federal Airport"
    PEU = "Puerto Lempira"
    PEV = "Pecs Pogany"
    PEW = "Bacha Khan International Airport"
    PEX = "Pechora Airport"
    PEY = "Penong"
    PEZ = "Penza Airport"
    PFA = "Paf Warren"
    PFB = "Passo Fundo Airport"
    PFC = "Pacific City State"
    PFD = "Port Frederick"
    PFJ = "Patreksfjordur"
    PFM = "Primrose Aerodrome"
    PFN = "Bay County"
    PFO = "Paphos International Airport"
    PFQ = "Parsabad"
    PFR = "Ilebo"
    PGA = "Page Airport"
    PGB = "Pangoa"
    PGC = "Grant County"
    PGD = "Charlotte County Airport"
    PGE = "Yegepa"
    PGF = "Llabanere Airport"
    PGG = "Progresso"
    PGH = "Pantnagar Airport"
    PGI = "Chitato"
    PGK = "Depati Amir Airport"
    PGL = "Jackson County"
    PGM = "Port Graham"
    PGN = "Pangia"
    PGO = "Stevens Field"
    PGP = "Porto Alegre"
    PGQ = "Buli Airport"
    PGR = "Paragould Kirk Field"
    PGS = "Peach Springs"
    PGU = "Ala'Marvdasht Airport"
    PGV = "Pitt-Greenville Airport"
    PGX = "Perigueux Airport"
    PGZ = "Comte Antonio Amilton Beraldo Airport"
    PHA = "Phan Rang"
    PHB = "Santos Dumont"
    PHC = "Port Harcourt International Airport"
    PHD = "Harry Clever Field"
    PHE = "Port Hedland International Airport"
    PHF = "Newport News/Williamsburg International Airport"
    PHG = "Port Harcourt City"
    PHH = "Phan Thiet"
    PHI = "Pinheiro"
    PHJ = "Port Hunter"
    PHK = "Palm Beach Co Glades"
    PHL = "Philadelphia International Airport"
    PHN = "St Clair County International"
    PHO = "Point Hope Airport"
    PHP = "Philip"
    PHQ = "The Monument Airport"
    PHR = "Pacific Harbor"
    PHS = "Phitsanulok Airport"
    PHT = "Henry County"
    PHU = "Phu Vinh"
    PHW = "Phalaborwa Airport"
    PHX = "Phoenix Sky Harbor International Airport"
    PHY = "Phetchabun"
    PHZ = "Phi Phi Island"
    PIA = "Peoria International Airport"
    PIB = "Hattiesburg-Laurel Regional Airport"
    PIC = "Pine Cay"
    PID = "Paradise Island"
    PIE = "St. Petersburg-Clearwater International Airport"
    PIF = "Pingtung"
    PIG = "Pitinga"
    PIH = "Pocatello Regional Airport"
    PII = "Phillips Field"
    PIK = "Glasgow Prestwick Airport"
    PIL = "Pilar"
    PIM = "Garden Harris County"
    PIN = "Parintins"
    PIO = "Capitan FAP Renan Elias Olivera Airport"
    PIP = "Pilot Point"
    PIQ = "Pipillipai"
    PIR = "Pierre Regional Airport"
    PIS = "Poitiers-Biard Airport"
    PIT = "Pittsburgh International Airport"
    PIU = "Cap. FAP Guillermo Concha Iberico International Airport"
    PIV = "Pirapora"
    PIW = "Pikwitonei"
    PIX = "Pico Island Airport"
    PIZ = "Dew Station Airport"
    PJA = "Pajala Airport"
    PJB = "Payson"
    PJC = "Pedro Juan Caballero"
    PJG = "Panjgur"
    PJM = "Puerto Jimenez"
    PJS = "Port San Juan"
    PJZ = "Puerto Juarez"
    PKA = "Napaskiak Sea Plane Base"
    PKB = "Wood County Airport"
    PKC = "Petropavlovsk-Kamchatsky Airport"
    PKD = "Park Rapids"
    PKE = "Parkes Airport"
    PKF = "Park Falls"
    PKG = "Pangkor Airport"
    PKH = "Alexion"
    PKJ = "Playa Grande"
    PKK = "Pakokku"
    PKL = "Pakatoa Island"
    PKM = "Port Kaituma"
    PKN = "Iskandar Airport"
    PKO = "Parakou"
    PKP = "Puka Puka"
    PKR = "Pokhara Airport"
    PKS = "Paksane"
    PKT = "Port Keats"
    PKU = "Sultan Syarif Kasim II International Airport"
    PKV = "Pskov Airport"
    PKW = "Selebi-Phikwe"
    PKX = "Beijing Daxing International Airport"
    PKY = "Tjilik Riwut Airport"
    PKZ = "Pakse Airport"
    PLA = "Planadas"
    PLC = "Planeta Rica"
    PLD = "Playa Samara"
    PLE = "Paiela"
    PLF = "Pala"
    PLH = "Plymouth"
    PLI = "Palm Island"
    PLJ = "Placencia"
    PLK = "M. Graham Clark - Taney County"
    PLL = "Ponta Pelada"
    PLM = "Sultan Mahmud Badaruddin II Airport"
    PLN = "Emmet County Airport"
    PLO = "Port Lincoln Airport"
    PLP = "La Palma"
    PLQ = "Palanga International Airport"
    PLR = "St Clair County"
    PLS = "Providenciales International Airport"
    PLT = "Plato"
    PLU = "Belo Horizonte Airport"
    PLV = "Poltava"
    PLW = "Mutiara Airport"
    PLX = "Semipalatinsk Airport"
    PLY = "Plymouth"
    PLZ = "Port Elizabeth International Airport"
    PMA = "Wawi Airport"
    PMB = "Intermediate"
    PMC = "El Tepual Airport"
    PMD = "La Palmdale Regional Airport"
    PME = "Portsmouth"
    PMF = "Parma Airport"
    PMG = "International"
    PMH = "Greater Portsmouth Regional"
    PMI = "Palma de Mallorca Airport"
    PMK = "Palm Island Airport"
    PML = "AFS"
    PMM = "Phanom Sarakham"
    PMN = "Pumani"
    PMO = "Falcone-Borsellino Airport"
    PMP = "Pimaga"
    PMQ = "Perito Moreno"
    PMR = "Palmerston North Airport"
    PMS = "Palmyra"
    PMT = "Paramakotoi"
    PMU = "SPB"
    PMV = "Santiago Marino International Airport"
    PMW = "Palmas Airport"
    PMX = "Metropolitan"
    PMY = "El Tehuelche"
    PMZ = "Palmar Sur"
    PNA = "Pamplona Airport"
    PNB = "Porto Nacional"
    PNC = "Ponca City"
    PND = "Punta Gorda"
    PNE = "North Philadelphia"
    PNF = "Peterson's Point"
    PNG = "Paranagua"
    PNH = "Phnom Penh International Airport"
    PNI = "Pohnpei Airport"
    PNJ = "Peng Lai/Sha He Kou"
    PNK = "Supadio International Airport"
    PNL = "Pantelleria Airport"
    PNN = "Princeton"
    PNO = "Pinotepa Nacional"
    PNP = "Girua Airport"
    PNQ = "Pune Airport"
    PNR = "Pointe Noire Airport"
    PNS = "Pensacola International Airport"
    PNT = "Teniente J. Gallardo"
    PNU = "Panguitch"
    PNV = "Panevezys"
    PNX = "Grayson County"
    PNY = "Pondicherry"
    PNZ = "Petrolina International Airport"
    POA = "Salgado Filho International Airport"
    POB = "Pope AFB"
    POC = "Brackett Field"
    POD = "Podor"
    POE = "Polk AAF"
    POF = "Earl Fields Memorial"
    POG = "Port Gentil"
    POH = "Pocahontas Municipal"
    POI = "Potosi"
    POJ = "Patos De Minas"
    POL = "Pemba Airport"
    POM = "Jacksons International Airport"
    PON = "Poptun"
    POO = "Pocos De Caldas"
    POP = "La Union Airport"
    POQ = "Polk Inlet"
    POR = "Pori Airport"
    POS = "Piarco International Airport"
    POT = "Ken Jones"
    POU = "Dutchess County"
    POV = "Presov"
    POW = "Portoroz"
    POX = "Paris Cergy Pontoise"
    POY = "Powell"
    POZ = "Poznan Airport"
    PPA = "Perry Lefors Field"
    PPB = "A. De Barros Airport"
    PPC = "Prospect Creek"
    PPD = "Palmas Del Mar"
    PPE = "Puerto Penasco"
    PPF = "Tri-City"
    PPG = "Pago Pago International Airport"
    PPH = "Peraitepuy"
    PPI = "Port Pirie"
    PPJ = "Pulau Panjang"
    PPK = "Petropavlovsk Airport"
    PPL = "Phaplu"
    PPM = "Pompano Beach"
    PPN = "Guillermo Leon Valencia Airport"
    PPO = "Powell Point"
    PPP = "Whitsunday Coast Airport"
    PPQ = "Paraparaumu Airport"
    PPR = "Pasir Pangarayan"
    PPS = "Puerto Princesa International Airport"
    PPT = "Tahiti Faa'a Airport"
    PPU = "Papun"
    PPV = "Port Protection"
    PPW = "Papa Westray Airport"
    PPX = "Param"
    PPY = "Pouso Alegre"
    PPZ = "Puerto Paez"
    PQC = "Phu Quoc Airport"
    PQD = "Pasikudha SPB"
    PQI = "Presque Isle Municipal Airport"
    PQM = "Palenque"
    PQQ = "Port Macquarie Airport"
    PQS = "Pilot Station Airport"
    PQT = "Qeqertaq Heliport"
    PRA = "General Justo Jose de Urquiza Airport"
    PRB = "Paso Robles"
    PRC = "Prescott Airport"
    PRD = "Pardoo"
    PRE = "Pore"
    PRF = "Port Johnson"
    PRG = "Vaclav Havel Airport Prague"
    PRH = "Phrae Airport"
    PRI = "Praslin Island Airport"
    PRJ = "Capri"
    PRK = "Prieska"
    PRL = "Port Oceanic"
    PRM = "Portimao Airport"
    PRN = "Pristina International Airport"
    PRO = "Perry Municipal"
    PRP = "Propriano"
    PRQ = "Pres. Roque Saenz Pena"
    PRR = "Paruima"
    PRS = "Parasi"
    PRT = "Coast Guard Heliport"
    PRU = "Prome"
    PRV = "Prerov"
    PRW = "Prentice"
    PRX = "Cox Field"
    PRY = "Wonderboom Airport"
    PRZ = "Prineville"
    PSA = "Pisa International Airport"
    PSB = "Bellefonte"
    PSC = "Tri-Cities Airport"
    PSD = "Port Said"
    PSE = "Mercedita Airport"
    PSF = "Pittsfield"
    PSG = "Petersburg Municipal Airport"
    PSH = "St Peter"
    PSI = "Pasni"
    PSJ = "Poso"
    PSK = "New River Valley"
    PSL = "Perth"
    PSM = "Pease Air Force Base"
    PSN = "Palestine Municipalcipal Airport"
    PSO = "Cano Airport"
    PSP = "Palm Springs International Airport"
    PSQ = "SPB"
    PSR = "Abruzzo Airport"
    PSS = "Posadas Airport"
    PST = "Preston"
    PSU = "Putussibau Airport"
    PSV = "Papa Stour"
    PSW = "Passos"
    PSX = "Palacios"
    PSY = "Port Stanley"
    PSZ = "Puerto Suarez"
    PTA = "Port Alsworth"
    PTB = "Dinwiddie County Airport"
    PTC = "Port Alice"
    PTD = "Port Alexander"
    PTF = "Malololailai"
    PTG = "Polokwane Airport"
    PTH = "Port Heiden"
    PTI = "Port Douglas"
    PTJ = "Portland"
    PTK = "Pontiac"
    PTL = "Port Armstrong"
    PTM = "Palmarito"
    PTN = "Williams Memorial"
    PTO = "Pato Branco"
    PTP = "Pointe-a-Pitre International Airport"
    PTQ = "Porto de Moz"
    PTR = "Pleasant Harbour"
    PTS = "Atkinson Municipal Airport"
    PTT = "Pratt"
    PTU = "Platinum Airport"
    PTV = "Porterville"
    PTW = "Pottstown/Limerick"
    PTX = "Pitalito"
    PTY = "Tocumen International Airport"
    PTZ = "Pastaza"
    PUA = "Puas"
    PUB = "Pueblo Memorial Airport"
    PUC = "Carbon County"
    PUD = "Puerto Deseado"
    PUE = "Puerto Obaldia"
    PUF = "The Pau-Pyrenees International Airport"
    PUG = "Port Augusta"
    PUH = "Pochutla"
    PUI = "Pureni"
    PUJ = "Punta Cana International Airport"
    PUK = "Pukarua"
    PUL = "Poulsbo"
    PUM = "Pomala"
    PUN = "Punia"
    PUO = "Prudhoe Bay"
    PUP = "Po"
    PUQ = "Pres Ibanez Airport"
    PUR = "Puerto Rico"
    PUS = "Gimhae International Airport"
    PUT = "Puttaprathe"
    PUU = "Puerto Asis Airport"
    PUV = "Poum"
    PUW = "Moscow Regional Airport"
    PUX = "Puerto Varas"
    PUY = "Pula Airport"
    PUZ = "Puerto Cabezas"
    PVA = "Providencia"
    PVC = "Provincetown Airport"
    PVD = "Theodore Francis Green Memorial State Airport"
    PVE = "El Porvenir"
    PVF = "Placerville"
    PVG = "Shanghai Pudong International Airport"
    PVH = "Porto Velho International Airport"
    PVI = "Edu Chaves"
    PVK = "Aktion Airport"
    PVL = "Pike County Airport"
    PVO = "Reales Tamarindos"
    PVR = "Gustavo Diaz Ordaz International Airport"
    PVS = "Provideniya"
    PVU = "Provo Airport"
    PVW = "Hale County"
    PVY = "Pope Vanoy"
    PVZ = "Casement"
    PWA = "Wiley Post"
    PWD = "Sherwood"
    PWE = "Pevek Airport"
    PWI = "Beles"
    PWK = "Chicago Executive Airport"
    PWL = "Purwokerto"
    PWM = "Portland International Jetport"
    PWN = "Pitts Town"
    PWO = "Pweto"
    PWQ = "Pavlodar Airport"
    PWR = "Port Walter"
    PWT = "Bremerton"
    PWY = "Ralph Wenz Field"
    PXA = "Atung Bungsu Airport"
    PXH = "Prominent Hill"
    PXL = "Polacca"
    PXM = "Puerto Escondido Airport"
    PXO = "Porto Santo Airport"
    PXR = "Surin"
    PXS = "Puerto De Santa Maria"
    PXU = "Pleiku Airport"
    PYA = "Puerto Boyaca"
    PYB = "Jeypore"
    PYC = "Playon Chico"
    PYE = "Penrhyn Island"
    PYG = "Gangtok-Pakyong Airport"
    PYH = "Puerto Ayacucho"
    PYJ = "Polyarnyj Airport"
    PYK = "Payam"
    PYL = "Perry SPB"
    PYM = "Plymouth"
    PYN = "Payan"
    PYO = "Putumayo"
    PYR = "Andravida"
    PYS = "Skypark"
    PYV = "Yaviza"
    PYX = "Pattaya"
    PYY = "Pai Airport"
    PZA = "Casanare"
    PZB = "Pietermaritzburg Airport"
    PZE = "Penzance"
    PZH = "Zhob"
    PZI = "Pan Zhi Hua Bao An Ying"
    PZK = "Puka Puka Island"
    PZL = "Zulu Inyala"
    PZO = "Manuel Carlos Piar Guayana Airport"
    PZS = "Temuco Maquehue Airport"
    PZU = "Port Sudan Airport"
    PZY = "Piestany"
    QAQ = "L'Aquila–Preturo Airport"
    QBC = "Bella Coola Airport"
    QCU = "Heliport"
    QCY = "Coningsby RAF Station"
    QDV = "Comte. Rolim Adolfo Amaro State Airport"
    QFI = "Heliport"
    QFK = "Harbour"
    QFQ = "Harbour"
    QGP = "Garanhuns Airport"
    QGQ = "Heliport"
    QGV = "Neu Isenburg"
    QHU = "Husum"
    QIG = "Dr. Francisco Tomé da Frota Airport"
    QJE = "Heliport"
    QJI = "Heliport"
    QKS = "Keystone Airport"
    QKU = "Messe/Deutz Rail Station"
    QLR = "Leiria Gandara Airport"
    QLU = "Lublin Radawiec Airport"
    QLV = "Leverkusen Mitte"
    QMK = "Heliport"
    QMV = "Montvale"
    QNY = "Marine Air Terminal"
    QOR = "Ordu"
    QOW = "Sam Mbakwe International Airport"
    QPG = "Paya Lebar"
    QPW = "Heliport"
    QRA = "Rand/Germiston"
    QRO = "Queretaro Intercontinental Airport"
    QRW = "Warri"
    QRY = "Heliport"
    QSC = "Sao Carlos"
    QSF = "Setif Airport"
    QSG = "Sonderborg"
    QSR = "Pontecagnano"
    QSZ = "Shache Airport"
    QUB = "Ubari"
    QUG = "Goodwood"
    QUO = "Akwa Ibom Airport"
    QUP = "Heliport"
    QUY = "Wyton RAF Station"
    QWG = "Wilgrove Air Park"
    QYW = "Vieux Port"
    QZD = "Szeged"
    RAA = "Rakanda"
    RAB = "Tokua Airport"
    RAC = "John H. Batten Field"
    RAD = "Road Town"
    RAE = "Arar Airport"
    RAF = "Rafaela"
    RAG = "Raglan"
    RAH = "Rafha Airport"
    RAI = "Nelson Mandela International Airport"
    RAJ = "Civil Airport"
    RAK = "Menara Airport"
    RAL = "Riverside Municipalcipal"
    RAM = "Ramingining"
    RAN = "La Spreta"
    RAO = "Dr. Leite Lopes State Airport"
    RAP = "Rapid City Regional Airport"
    RAQ = "Sugimanuru"
    RAR = "Rarotonga Airport"
    RAS = "Rasht Airport"
    RAT = "Raduzhnyi"
    RAV = "Cravo Norte"
    RAW = "Arawa"
    RAX = "Oram"
    RAZ = "Rawala Kot"
    RBA = "Sale Airport"
    RBB = "Borba"
    RBC = "Robinvale"
    RBD = "Redbird"
    RBE = "Ratanakiri"
    RBF = "Big Bear City Airport"
    RBG = "Roseburg Municipal Airport"
    RBH = "Brooks Lodge"
    RBI = "Rabi"
    RBJ = "Rebun"
    RBK = "French Valley"
    RBL = "Red Bluff Fss"
    RBM = "Wallmuhle"
    RBN = "Fort Jefferson"
    RBO = "Robore"
    RBP = "Rabaraba"
    RBQ = "Rurrenabaque"
    RBR = "Pres. Medici Airport"
    RBS = "Orbost"
    RBT = "Marsabit"
    RBU = "Roebourne"
    RBV = "Ramata"
    RBW = "Lowcountry Regional"
    RBX = "Rumbek"
    RBY = "Ruby Airport"
    RCA = "Ellsworth AFB"
    RCB = "Richards Bay Airport"
    RCE = "Roche Harbor"
    RCH = "Riohacha Airport"
    RCK = "Coffield"
    RCL = "Redcliffe"
    RCM = "Richmond"
    RCN = "American River"
    RCO = "Saint Agnant"
    RCP = "Cinder River"
    RCQ = "Reconquista"
    RCR = "Fulton County"
    RCS = "Rochester"
    RCT = "Miller Field"
    RCU = "Rio Cuarto"
    RCY = "Rum Cay"
    RDA = "Rockhampton Downs"
    RDB = "Red Dog"
    RDC = "Redencao"
    RDD = "Redding Municipal Airport"
    RDE = "Merdey"
    RDG = "Municipalcipal/Spaatz Field"
    RDL = "Al Bardawil International Airport"
    RDM = "Roberts Field Redmond Municipal Airport"
    RDN = "LTS Pulau Redang"
    RDO = "Radom Airport"
    RDP = "Kazi Nazrul Islam Airport"
    RDR = "Grand Forks AFB"
    RDS = "Rincon de los Sauces"
    RDT = "Richard Toll"
    RDU = "Raleigh-Durham International Airport"
    RDV = "Red Devil"
    RDZ = "Marcillac Airport"
    REA = "Reao"
    REB = "Rechlin"
    REC = "Guararapes-Gilberto Freyre International Airport"
    RED = "Mifflin County"
    REE = "Reese AFB"
    REG = "Tito Menniti Airport"
    REH = "Rehoboth Beach"
    REI = "Regina"
    REL = "Trelew Airport"
    REN = "Orenburg Airport"
    REO = "Rome State"
    REP = "Siem Reap International Airport"
    REQ = "Reko Diq"
    RER = "Base Aerea Del Sur"
    RES = "Resistencia Airport"
    RET = "Stolport Airport"
    REU = "Reus Airport"
    REW = "Rewa"
    REX = "Gen Lucio Blanco International Airport"
    REY = "Reyes"
    REZ = "Resende"
    RFA = "Rafai"
    RFD = "Chicago Rockford International Airport"
    RFG = "Rooke Field"
    RFK = "Rollang Field"
    RFN = "Raufarhofn"
    RFP = "Raiatea Airport"
    RFR = "Rio Frio"
    RFS = "Rosita"
    RGA = "Rio Grande Airport"
    RGE = "Porgera"
    RGH = "Balurghat"
    RGI = "Rangiroa Airport"
    RGK = "Gorno-Altaysk Airport"
    RGL = "Rio Gallegos Internacional Airport"
    RGN = "Yangon International Airport"
    RGO = "Orang"
    RGR = "Ranger Municipalcipal"
    RGS = "Burgos"
    RGT = "Japura"
    RHA = "Reykholar"
    RHD = "Rio Hondo Airport"
    RHE = "Reims"
    RHG = "Ruhengeri"
    RHI = "Oneida County Airport"
    RHL = "Roy Hill"
    RHN = "Rosh Pina"
    RHO = "Rhodes Airport"
    RHP = "Ramechhap"
    RHR = "Al Hamra SPB"
    RHT = "Alxa Right Banner"
    RHV = "Reid-Hillview"
    RIA = "Santa Maria Airport"
    RIB = "Gen Buech Airport"
    RIC = "Richmond International Airport (Byrd Field)"
    RID = "Richmond Municipalcipal Airport"
    RIE = "Rice Lake"
    RIF = "Reynolds"
    RIG = "Rio Grande"
    RIH = "Scarlett Martínez International Airport"
    RIJ = "Rioja"
    RIK = "Carrillo"
    RIL = "Garfield County"
    RIM = "Rodriguez De Mendoza"
    RIN = "Ringi Cove"
    RIR = "Riverside Fla-Bob"
    RIS = "Rishiri Airport"
    RIT = "Rio Tigre"
    RIV = "March ARB"
    RIW = "Riverton Airport"
    RIX = "Riga International Airport"
    RIY = "Riyan Mukalla"
    RIZ = "Rio Alzucar"
    RJA = "Rajahmundry Airport"
    RJB = "Rajbiraj"
    RJH = "Rajshahi Airport"
    RJI = "Rajouri"
    RJK = "Rijeka Airport"
    RJL = "Agoncillo Airport"
    RJM = "Marinda Airport"
    RJN = "Rafsanjan"
    RKA = "Aratika-Nord"
    RKC = "Yreka"
    RKD = "Knox County Regional Airport"
    RKE = "Roskilde Airport"
    RKH = "Rock Hill"
    RKI = "Rokot"
    RKO = "Sipora"
    RKP = "Aransas County"
    RKR = "Robert S Kerr"
    RKS = "Rock Springs-Sweetwater County Airport"
    RKT = "Ras Al Khaimah International Airport"
    RKU = "Kairuku"
    RKV = "Reykjavik International Airport"
    RKW = "Rockwood Municipal Airport"
    RKY = "Rokeby"
    RKZ = "Peace"
    RLA = "National"
    RLD = "Richland"
    RLG = "Laage Airport"
    RLI = "Reilly AHP"
    RLK = "Bayannur Tianjitai Airport"
    RLO = "Valle Del Conlara"
    RLP = "Rosella Plains"
    RLR = "Relais de la Reine"
    RLT = "Arlit"
    RLU = "Bornite Upper"
    RMA = "Roma Airport"
    RMB = "Buraimi"
    RMD = "Ramagundam"
    RME = "Griffiss AFB"
    RMF = "Marsa Alam International Airport"
    RMG = "Richard B Russell"
    RMI = "Miramare Airport"
    RMK = "Renmark"
    RML = "Ratmalana"
    RMN = "Rumginae"
    RMP = "Rampart"
    RMQ = "Taichung International Airport"
    RMS = "Ramstein"
    RMT = "Rimatara"
    RMU = "Corvera International"
    RMY = "Mariposa-Yosemite"
    RMZ = "Tobolsk Remezov Airport"
    RNA = "Ulawa Airport"
    RNB = "Kallinge Airport"
    RNC = "Warren County"
    RND = "Randolph AFB"
    RNE = "Renaison"
    RNG = "Rangely"
    RNH = "New Richmond Municipal Airport"
    RNI = "Corn Island"
    RNJ = "Yoron Airport"
    RNL = "Rennell"
    RNM = "Qarn Alam"
    RNN = "Bornholm Airport"
    RNO = "Reno/Tahoe International Airport"
    RNP = "Rongelap Island"
    RNR = "Robinson River"
    RNS = "Rennes Airport"
    RNT = "Renton"
    RNU = "Ranau"
    RNZ = "Rensselaer"
    ROA = "Roanoke-Blacksburg Regional Airport"
    ROB = "Roberts International Airport"
    ROC = "Greater Rochester International Airport"
    ROD = "Robertson"
    ROF = "Yreka Rohrer Field"
    ROG = "Rogers"
    ROH = "Robinhood"
    ROI = "Roi Et Airport"
    ROK = "Rockhampton Airport"
    ROL = "Roosevelt"
    RON = "Rondon"
    ROO = "Rondonopolis Airport"
    ROP = "Rota Airport"
    ROR = "Airai Airport"
    ROS = "Fisherton Airport"
    ROT = "Rotorua International Airport"
    ROU = "Rousse"
    ROV = "Platov International Airport"
    ROW = "Roswell International Air Center"
    ROX = "Roseau Municipal Airport"
    ROY = "Rio Mayo"
    ROZ = "US Naval Station"
    RPA = "Rolpa"
    RPB = "Roper Bar"
    RPM = "Ngukurr"
    RPN = "Rosh Pina"
    RPR = "Swami Vivekananda Airport"
    RPU = "San Fernando Airport"
    RPV = "Roper Valley"
    RPX = "Roundup"
    RQA = "Ruoqiang Loulan Airport"
    RQW = "West"
    RRA = "Ronda"
    RRE = "Marree"
    RRG = "Rodrigues Island Airport"
    RRI = "Barora"
    RRJ = "Jacarepaguá Airport"
    RRK = "Rourkela"
    RRL = "Merrill Municipal Airport"
    RRM = "Marromeu"
    RRN = "Serra Norte"
    RRO = "Sorrento"
    RRR = "Raroia"
    RRS = "Roros Airport"
    RRT = "Warroad"
    RRV = "Robinson River"
    RSA = "Santa Rosa Airport"
    RSB = "Roseberth"
    RSD = "South Eleuthera Airport"
    RSE = "Rose Bay"
    RSG = "Serra Pelada"
    RSH = "Russian SPB"
    RSI = "Rio Sidra"
    RSJ = "Rosario SPB"
    RSK = "Ransiki"
    RSL = "Russell"
    RSN = "Ruston"
    RSP = "Raspberry Strait"
    RSS = "Roseires"
    RST = "Rochester International Airport"
    RSU = "Yeosu Airport"
    RSW = "Southwest Florida International Airport"
    RSX = "Rouses Point"
    RTA = "Rotuma Island"
    RTB = "Roatan Airport"
    RTC = "Ratnagiri"
    RTD = "Rotunda"
    RTE = "Marguerite Bay"
    RTG = "Ruteng"
    RTI = "Roti"
    RTL = "Spirit Lake"
    RTM = "Rotterdam The Hague Airport"
    RTN = "Crews Field"
    RTP = "Rutland Plains"
    RTS = "Rottnest Island"
    RTW = "Saratov Tsentralny Airport"
    RTY = "Merty"
    RUA = "Arua"
    RUD = "Shahrud"
    RUE = "Butembo"
    RUF = "Yuruf"
    RUG = "Rugao"
    RUH = "King Khaled International Airport"
    RUI = "Ruidoso Sierra Blanca Regional Airport"
    RUK = "Rukumkot"
    RUL = "Maavaarulaa Airport"
    RUM = "Rumjatar"
    RUN = "Reunion Roland Garros Airport"
    RUP = "Rupsi"
    RUR = "Rurutu"
    RUS = "Marau Sound"
    RUT = "Rutland Airport"
    RUU = "Ruti"
    RUV = "Rubelsanto"
    RUY = "Copan"
    RVA = "Farafangana"
    RVC = "Rivercess"
    RVD = "Rio Verde Airport"
    RVE = "Los Colonizadores"
    RVH = "Rzhevka"
    RVI = "Rostov Airport"
    RVK = "Ryumsjoen Airport"
    RVN = "Rovaniemi Airport"
    RVO = "Reivilo"
    RVR = "Green River"
    RVS = "R.Lloyd Jones"
    RVT = "Ravensthorpe"
    RVV = "Raivavae"
    RVY = "Rivera"
    RWB = "Rowan Bay"
    RWF = "Redwood Falls Municipal"
    RWI = "Rocky Mount-wilson"
    RWL = "Rawlins"
    RWN = "Rovno"
    RWS = "Sumare"
    RXA = "Raudha"
    RXE = "Madison County"
    RXS = "Roxas City Airport"
    RYB = "Rybinsk"
    RYG = "Moss Airport"
    RYK = "Rahim Yar Khan Airport"
    RYL = "Royal Airport"
    RYN = "Medis"
    RYO = "Rio Turbio"
    RZA = "Santa Cruz"
    RZE = "Rzeszow International Airport"
    RZH = "Preobrazheniye"
    RZN = "Ryazan"
    RZP = "CLR Airport"
    RZR = "Ramsar"
    RZS = "Sawan"
    RZV = "Rize–Artvin Airport"
    RZZ = "Halifax County"
    SAA = "Shively Field"
    SAB = "J. Yrausquin Airport"
    SAC = "Sacramento Executive Airport"
    SAD = "Safford"
    SAE = "Sangir"
    SAF = "Santa Fe"
    SAG = "Shirdi"
    SAH = "Sana'a International Airport"
    SAK = "Saudarkrokur"
    SAL = "El Salvador International Airport"
    SAM = "Salamo"
    SAN = "San Diego International Airport"
    SAP = "Ramon Villeda Morales International Airport"
    SAQ = "San Andros"
    SAR = "Sparta Community"
    SAS = "Salton City"
    SAT = "San Antonio International Airport"
    SAU = "Sawu"
    SAV = "Savannah/Hilton Head Airport"
    SAW = "Sabiha Gokcen International Airport"
    SAX = "Sambu"
    SAY = "Siena"
    SAZ = "Sasstown"
    SBA = "Santa Barbara Municipal Airport"
    SBB = "Santa Barbara Ba"
    SBC = "Selbang"
    SBD = "Norton AFB"
    SBE = "Suabi"
    SBF = "Sardeh Band"
    SBG = "Maimun Saleh"
    SBH = "St. Barthelemy Airport"
    SBI = "Sambailo"
    SBJ = "Sao Mateus"
    SBK = "Saint Brieuc-Armor"
    SBL = "Yacuma"
    SBM = "Memorial"
    SBN = "South Bend Regional"
    SBO = "Salina"
    SBP = "San Luis County Regional Airport"
    SBQ = "Sibi"
    SBR = "Saibai Island"
    SBS = "Steamboat Springs"
    SBT = "Sabetta"
    SBU = "Springbok"
    SBV = "Sabah"
    SBW = "Sibu Airport"
    SBX = "Shelby"
    SBY = "Wicomico Regional Airport"
    SBZ = "Sibiu Airport"
    SCA = "Santa Catalina"
    SCB = "State"
    SCC = "Prudhoe Bay/Deadhorse Airport"
    SCD = "Sulaco"
    SCE = "University Park Airport"
    SCF = "Scottsdale Airport"
    SCG = "Spring Creek"
    SCH = "Schenectady County"
    SCI = "San Cristobal"
    SCJ = "Smith Cove"
    SCK = "Stockton Airport"
    SCL = "Arturo Merino Benitez Airport"
    SCM = "SPB"
    SCN = "Ensheim Airport"
    SCO = "Aktau International Airport"
    SCP = "St Crepin"
    SCQ = "Santiago De Compostela Airport"
    SCR = "Scandinavian Mountains Airport"
    SCS = "Scatsta"
    SCT = "Socotra"
    SCU = "Antonio Maceo Airport"
    SCV = "Suceava Airport"
    SCW = "Syktyvkar Airport"
    SCX = "Salina Cruz"
    SCY = "San Cristobal Airport"
    SCZ = "Santa Cruz Island"
    SDB = "Langebaanweg"
    SDC = "Sandcreek"
    SDD = "Lubango Airport"
    SDE = "Santiago Del Estero Airport"
    SDF = "Louisville International Airport"
    SDG = "Sanandaj Airport"
    SDH = "Santa Rosa Copan"
    SDI = "Saidor"
    SDJ = "Sendai Airport"
    SDK = "Sandakan Airport"
    SDL = "Sundsvall-Timra Airport"
    SDM = "Brown Field Municipalcipal"
    SDN = "Sandane Airport"
    SDO = "Ryotsu Sado Island"
    SDP = "Sand Point Municipal Airport"
    SDQ = "Las Americas International Airport"
    SDR = "Santander Airport"
    SDS = "Sado Shima"
    SDT = "Saidu Sharif"
    SDU = "Santos Dumont Airport"
    SDV = "Dov Hoz Airport"
    SDW = "Sindhudurg Airport"
    SDX = "Sedona"
    SDY = "Richland Municipal Airport"
    SDZ = "Shetland Islands	Metropolitan Area"
    SEA = "Seattle-Tacoma International Airport"
    SEB = "Sebha"
    SED = "Min'hat Hashnayim"
    SEE = "Gillespie Field"
    SEF = "Sebring Regional Airport"
    SEG = "Penn Valley"
    SEH = "Senggeh"
    SEI = "Senhor Do Bonfim"
    SEK = "Srednekolymsk Airport"
    SEM = "Craig AFB"
    SEN = "London Southend Airport"
    SEO = "Seguela"
    SEP = "Clark Field"
    SEQ = "Sungai Pakning"
    SER = "Freeman Municipalcipal"
    SES = "Selfield"
    SET = "San Esteban"
    SEU = "Seronera Airstrip"
    SEV = "Severodoneck"
    SEW = "Siwa"
    SEY = "Selibaby"
    SEZ = "Seychelles International Airport"
    SFA = "Sfax El Maou Airport"
    SFB = "Orlando Sanford International Airport"
    SFC = "St Francois"
    SFD = "Las Flecheras"
    SFE = "San Fernando"
    SFF = "Felts Field"
    SFG = "Esperance Airport"
    SFH = "San Felipe"
    SFJ = "Kangerlussuaq Airport"
    SFK = "Soure"
    SFL = "Sao Filipe"
    SFM = "Sanford"
    SFN = "Santa Fe Airport"
    SFO = "San Francisco International Airport"
    SFP = "Surfers Paradise"
    SFQ = "Sanliurfa"
    SFR = "San Fernando"
    SFS = "Subic Bay International"
    SFT = "Skelleftea Airport"
    SFU = "Safia"
    SFV = "Santa Fe Do Sul"
    SFW = "Santa Fe"
    SFX = "San Felix"
    SFY = "Tri-Township Airport"
    SFZ = "North Central"
    SGA = "Sheghnan"
    SGB = "Singaua"
    SGC = "Surgut Airport"
    SGD = "Sonderborg Airport"
    SGE = "Siegerland Airport"
    SGF = "Springfield-Branson National Airport"
    SGG = "Simanggang"
    SGH = "Springfield"
    SGI = "Sargodha Airport"
    SGJ = "Sagarai"
    SGK = "Sangapi"
    SGL = "Sangley Point NAS"
    SGM = "San Ignacio"
    SGN = "Tan Son Nhat International Airport"
    SGO = "St George"
    SGP = "Shay Gap"
    SGQ = "Sanggata"
    SGR = "Sugar Land Regional"
    SGS = "Sanga Sanga"
    SGT = "Stuttgart Municipalcipal"
    SGU = "Saint George Municipal Airport"
    SGV = "Sierra Grande"
    SGW = "Saginaw Bay"
    SGX = "Songea"
    SGY = "Skagway Municipal"
    SGZ = "Songkhla"
    SHA = "Shanghai Hongqiao International Airport"
    SHB = "Nakashibetsu Airport"
    SHC = "Indaselassie"
    SHD = "Shenandoah Valley Airport"
    SHE = "Shenyang Taoxian International Airport"
    SHF = "Shihezi Huayuan Airport"
    SHG = "Shungnak Airport"
    SHH = "Shishmaref Airport"
    SHI = "Shimojishima"
    SHJ = "Sharjah International Airport"
    SHK = "Sehonghong"
    SHL = "Shillong Airport"
    SHM = "Shirahama Airport"
    SHN = "Sanderson Field"
    SHO = "King Mswati III International Airport"
    SHP = "Qinhuangdao"
    SHQ = "Southport"
    SHR = "Sheridan"
    SHS = "Shashi"
    SHT = "Shepparton"
    SHU = "Smith Point"
    SHV = "Shreveport Regional Airport"
    SHW = "Sharurah Airport"
    SHX = "Shageluk Airport"
    SHY = "Shinyanga"
    SHZ = "Seshutes"
    SIA = "Xi'an Xiguan Airport"
    SIB = "Sibiti"
    SIC = "Sinop Airport"
    SID = "Amilcar Cabral International Airport"
    SIE = "Sines"
    SIF = "Simara"
    SIG = "Isla Grande"
    SIH = "Silgadi Doti"
    SII = "Sidi Ifni"
    SIJ = "Siglufjordur"
    SIK = "Memorial"
    SIL = "Sila"
    SIM = "Simbai"
    SIN = "Changi International Airport"
    SIO = "Smithton"
    SIP = "Simferopol International Airport"
    SIQ = "Dabo"
    SIR = "Sion"
    SIS = "Sishen Airport"
    SIT = "Sitka Airport"
    SIU = "Siuna"
    SIV = "County"
    SIW = "Sibisa"
    SIX = "Singleton"
    SIY = "Siskiyou County"
    SIZ = "Sissano"
    SJA = "San Juan"
    SJB = "San Joaquin"
    SJC = "Norman Y. Mineta San Jose International Airport"
    SJD = "Los Cabos International Airport"
    SJE = "San Jose Del Gua"
    SJF = "St John Island"
    SJG = "San Pedro Jagua"
    SJH = "San Juan Del Cesar"
    SJI = "San Jose"
    SJJ = "Sarajevo International Airport"
    SJK = "Sao Jose Dos Campos"
    SJL = "Da Cachoeira"
    SJM = "San Juan"
    SJN = "St. Johns Industrial Air Park"
    SJO = "Juan Santamaria International Airport"
    SJP = "Sao Jose do Rio Preto Airport"
    SJQ = "Sesheke"
    SJR = "San Juan D Ur"
    SJS = "San Jose"
    SJT = "San Angelo Regional Airport"
    SJU = "Luis Munoz Marin International Airport"
    SJV = "San Javier"
    SJW = "Shijiazhuang Daguocun Airport"
    SJX = "Sartaneja"
    SJY = "Ilmajoki"
    SJZ = "Sao Jorge Island Airport"
    SKA = "Fairchild AFB"
    SKB = "Robert L. Bradshaw International Airport"
    SKC = "Suki"
    SKD = "Samarkand Airport"
    SKE = "Skien"
    SKF = "Kelly AFB"
    SKG = "Thessaloniki International Airport"
    SKH = "Surkhet"
    SKI = "Skikda"
    SKJ = "Sitkinak Cgs"
    SKK = "Shaktoolik Airport"
    SKL = "Broadford"
    SKM = "Skeldon"
    SKN = "Stokmarknes Skagen Airport"
    SKO = "Sokoto"
    SKP = "Skopje Alexander the Great Airport"
    SKQ = "Sekakes"
    SKR = "Shakiso"
    SKS = "Vojens"
    SKT = "Sialkot Airport"
    SKU = "Skiros Airport"
    SKV = "Mount Sinai"
    SKW = "Intermediate"
    SKX = "Saransk Airport"
    SKY = "Griffing Sandusky"
    SKZ = "Sukkur Airport"
    SLA = "Martin Miguel de Guemes International Airport"
    SLB = "Storm Lake Municipal Airport"
    SLC = "Salt Lake City International Airport"
    SLD = "Sliac"
    SLE = "Mcnary Field"
    SLF = "Sulayel"
    SLG = "Smith Field"
    SLH = "Sola"
    SLI = "Solwezi"
    SLJ = "Stellar Air Park"
    SLK = "Adirondack Airport"
    SLL = "Salalah International Airport"
    SLM = "Matacan Airport"
    SLN = "Salina Regional Airport"
    SLO = "Leckrone"
    SLP = "San Luis Potosi Airport"
    SLQ = "Sleetmute"
    SLR = "Sulphur Springs"
    SLS = "Silistra"
    SLT = "Salida"
    SLU = "George F. L. Charles Airport"
    SLV = "Simla"
    SLW = "Plan de Guadalupe International Airport"
    SLX = "Salt Cay"
    SLY = "Salekhard Airport"
    SLZ = "Marechal Cunha Machado International Airport"
    SMA = "Vila Do Porto Airport"
    SMB = "Cerro Sombrero"
    SMC = "Santa Maria"
    SMD = "Smith Field"
    SME = "Pulaski County"
    SMF = "Sacramento International Airport"
    SMG = "Santa Maria"
    SMH = "Sapmanga"
    SMI = "Samos Airport"
    SMJ = "Sim"
    SMK = "St. Michael Airport"
    SML = "Estate Airstrip"
    SMM = "Semporna"
    SMN = "Salmon"
    SMO = "Santa Monica"
    SMP = "Stockholm"
    SMQ = "H. Asan Airport"
    SMR = "Simon Bolivar International Airport"
    SMS = "Sainte Marie"
    SMT = "Sun Moon Lake"
    SMU = "Sheep Mountain"
    SMV = "Samedan"
    SMW = "Smara"
    SMX = "Santa Maria Public Airport"
    SMY = "Simenti"
    SMZ = "Stoelmans Eiland"
    SNA = "John Wayne Airport"
    SNB = "Snake Bay"
    SNC = "General Ulpiano Paez Airport"
    SND = "Seno"
    SNE = "Preguica"
    SNF = "San Felipe"
    SNG = "San Ignacio De Velasco"
    SNH = "Stanthorpe"
    SNI = "R.E. Murray"
    SNJ = "San Julian"
    SNK = "Winston Field"
    SNL = "Shawnee Municipal"
    SNM = "San Ignacio De M"
    SNN = "Shannon Airport"
    SNO = "Sakon Nakhon Airport"
    SNP = "Saint Paul Island Airport"
    SNQ = "San Quintin"
    SNR = "Montoir Airport"
    SNS = "Salinas"
    SNT = "Sabana De Torres"
    SNU = "Santa Clara Airport"
    SNV = "Santa Elena"
    SNW = "Thandwe Airport"
    SNX = "Sabana De Mar"
    SNY = "Sidney"
    SNZ = "Santa Cruz"
    SOA = "Soc Trang"
    SOB = "Sármellék/Balaton"
    SOC = "Adi Sumarmo International Airport"
    SOD = "Sorocaba"
    SOE = "Souanke"
    SOF = "Sofia Airport"
    SOG = "Sogndal Airport"
    SOH = "Solita"
    SOI = "South Molle Island"
    SOJ = "Sorkjosen Airport"
    SOK = "Semongkong"
    SOL = "Solomon"
    SOM = "Edmundo Barrios"
    SON = "Santo Pekoa International Airport"
    SOO = "Helsinge Airport"
    SOP = "Pinehurst-S. Pines"
    SOQ = "Sorong Airport"
    SOR = "Al Thaurah"
    SOT = "Sodankyla"
    SOU = "Southampton Airport"
    SOV = "Seldovia"
    SOW = "Show Low Airport"
    SOX = "Alberto Lleras Camargo"
    SOY = "Stronsay Airport"
    SOZ = "Solenzara"
    SPA = "Spartanburg Downtown Memorial"
    SPB = "SPB"
    SPC = "La Palma Airport"
    SPD = "Saidpur Airport"
    SPE = "Sepulot"
    SPF = "Black Hills"
    SPG = "Whitted"
    SPH = "Sopu"
    SPI = "Capital Airport"
    SPJ = "Eleftherios Venizelos"
    SPK = "Sapporo	Metropolitan Area"
    SPM = "Spangdahlem"
    SPN = "Saipan International Airport"
    SPO = "San Pablo"
    SPP = "Menongue"
    SPQ = "Catalina SPB"
    SPR = "San Pedro"
    SPS = "Sheppard AFB"
    SPT = "Sipitang"
    SPU = "Split Airport"
    SPV = "Sepik Plains"
    SPW = "Spencer Municipal"
    SPX = "Houston Gulf Airport"
    SPY = "San Pedro"
    SPZ = "Springdale Municipal"
    SQA = "Santa Ynez"
    SQB = "Santa Ana"
    SQC = "Southern Cross"
    SQD = "Shangrao Sanqingshan Airport"
    SQE = "San Luis De Pale"
    SQF = "Solano"
    SQG = "Sorong Airport"
    SQH = "Na-San"
    SQI = "Whiteside County"
    SQJ = "Sanming Shaxian Airport"
    SQK = "Sidi Barani"
    SQL = "San Carlos"
    SQM = "São Miguel de Aragao"
    SQN = "Sanana"
    SQO = "Gunnarn"
    SQQ = "Siauliai International Airport"
    SQR = "Inco Soroako Waws"
    SQS = "Matthew Spain"
    SQT = "China Straits Airstrip"
    SQU = "Saposoa"
    SQV = "Sequim Valley Airport"
    SQW = "Skive Airport"
    SQX = "Sao Miguel do Oeste"
    SQY = "Sao Lourenco Do Sul"
    SQZ = "Scampton RAF Station"
    SRA = "Santa Rosa"
    SRB = "Santa Rosa"
    SRC = "Searcy"
    SRD = "San Ramon"
    SRE = "Juana Azurduy de Padilla International Airport"
    SRF = "Hamilton Field"
    SRG = "Achmad Yani International Airport"
    SRH = "Sarh"
    SRI = "Temindung Airport"
    SRJ = "Capitan G Q Guardia"
    SRL = "Santa Rosalia"
    SRM = "Sandringham"
    SRN = "Strahan"
    SRO = "Santana Ramos"
    SRP = "Stord Airport"
    SRQ = "Sarasota Bradenton International Airport"
    SRR = "Dunwich"
    SRS = "Cartagena"
    SRT = "Soroti"
    SRU = "Skypark"
    SRV = "Stony River"
    SRW = "Rowan County"
    SRX = "Sert"
    SRY = "Dashte Naz Airport"
    SRZ = "El Trompillo"
    SSA = "Deputado Luis Eduardo Magalhaes International Airport"
    SSB = "SPB"
    SSC = "Shaw AFB"
    SSD = "San Felipe"
    SSE = "Sholapur"
    SSF = "Stinson Municipalcipal"
    SSG = "Malabo Airport"
    SSH = "Sharm El Sheikh Airport"
    SSI = "Malcolm Mckinnon"
    SSJ = "Stokka Airport"
    SSK = "Sturt Creek"
    SSL = "Santa Rosalia"
    SSM = "Sault Ste. Marie Airport"
    SSN = "Seoul AB"
    SSO = "Sao Lourenco"
    SSP = "Silver Plains"
    SSQ = "La Sarre"
    SSR = "Sara"
    SSS = "Siassi"
    SST = "Santa Teresita"
    SSU = "Greenbrier"
    SSV = "Siasi"
    SSW = "Stuart Island"
    SSX = "Samsun Samair Airport"
    SSY = "M'banza Congo"
    SSZ = "Santos"
    STA = "Stauning Vestjyllands Airport"
    STB = "L Delicias"
    STC = "Saint Cloud Regional"
    STD = "Mayo Guerrero"
    STE = "Stevens Point"
    STF = "Stephen Island"
    STG = "St. George Island Airport"
    STH = "Strathmore"
    STI = "Cibao International Airport"
    STJ = "Rosecrans Memorial"
    STK = "Crosson Field"
    STL = "Lambert-St. Louis International Airport"
    STM = "Santarem-Maestro Wilson Fonseca Airport"
    STN = "Stansted Airport"
    STP = "St. Paul Downtown Airport"
    STQ = "St Marys"
    STR = "Stuttgart Airport"
    STS = "Sonoma County Airport"
    STT = "Cyril E. King Airport"
    STU = "Santa Cruz"
    STV = "Surat Gujarat Airport"
    STW = "Stavropol Airport"
    STX = "Henry E. Rohlsen Airport"
    STY = "Salto"
    STZ = "Confresa"
    SUA = "Witham Field"
    SUB = "Juanda International Airport"
    SUC = "Schloredt"
    SUD = "Stroud"
    SUE = "Door County"
    SUF = "Lamezia Terme International Airport"
    SUG = "Surigao Airport"
    SUH = "Sur"
    SUI = "Babusheri"
    SUJ = "Satu Mare International Airport"
    SUK = "Sakkyryr Airport"
    SUL = "Sui"
    SUM = "Sumter Municipal Airport"
    SUN = "Friedman Memorial Airport"
    SUO = "Sun River"
    SUP = "Trunojoyo"
    SUQ = "Sucua"
    SUR = "Summer Beaver"
    SUS = "Spirit of St. Louis Airport"
    SUT = "Sumbawanga"
    SUU = "Travis AFB"
    SUV = "Nausori Airport"
    SUW = "Richard I Bong Airport"
    SUX = "Sioux Gateway Airport"
    SUY = "Suntar"
    SUZ = "Suria"
    SVA = "Savoonga Airport"
    SVB = "Sambava"
    SVC = "Grant County Airport"
    SVD = "Argyle International Airport"
    SVE = "Susanville"
    SVF = "Save"
    SVG = "Stavanger Airport Sola"
    SVH = "Statesville Municipal"
    SVI = "San Vicente"
    SVJ = "Helle Airport"
    SVK = "Silver Creek"
    SVL = "Savonlinna Airport"
    SVM = "St Pauls"
    SVN = "Hunter AAF"
    SVO = "Sheremetyevo International Airport"
    SVP = "Kuito (Silva Porto)"
    SVQ = "Seville Airport"
    SVS = "Stevens Village"
    SVT = "Savuti"
    SVU = "Savusavu Airport"
    SVV = "San Salvador De"
    SVW = "Sparrevohn AFS"
    SVX = "Koltsovo International Airport"
    SVY = "Savo"
    SVZ = "San Antonio"
    SWA = "Jieyang Chaoshan Airport"
    SWB = "Shaw River"
    SWC = "Stawell"
    SWD = "Seward"
    SWE = "Siwea"
    SWF = "Stewart International Airport"
    SWG = "Satwag"
    SWH = "Swan Hill"
    SWJ = "South West Bay"
    SWL = "Spanish Wells"
    SWM = "Suia-Missu"
    SWN = "Sahiwal"
    SWO = "Searcy Field"
    SWP = "Swakopmund"
    SWQ = "Sultan Muhammad Kaharuddin III Airport"
    SWR = "Silur"
    SWS = "Swansea Airport"
    SWT = "Strezhevoy Airport"
    SWU = "Suwon"
    SWV = "Severo-Evensk Airport"
    SWW = "Sweetwater"
    SWX = "Shakawe"
    SWY = "Sitiawan"
    SXA = "Sialum"
    SXB = "Strasbourg Airport"
    SXC = "Avalo Vor/WP"
    SXE = "Sale"
    SXF = "Schonefeld Airport"
    SXG = "Senanga"
    SXH = "Sehulea"
    SXI = "Sirri Island"
    SXJ = "Shanshan"
    SXK = "Saumlaki Olilit Airport"
    SXL = "Sligo"
    SXM = "Princess Juliana International Airport"
    SXN = "Suapan"
    SXO = "Sao Felix Do Araguaia"
    SXP = "Sheldon Sea Plane Base"
    SXQ = "Soldotna"
    SXR = "Srinagar International Airport"
    SXS = "Sahabat 16"
    SXT = "Taman Negara"
    SXU = "Soddu"
    SXV = "Salem"
    SXW = "Sauren"
    SXX = "Sao Felix Do Xingu"
    SXY = "Sidney"
    SXZ = "Siirt Airport"
    SYA = "Shemya AFB"
    SYB = "Seal Bay"
    SYC = "Shiringayoc"
    SYD = "Sydney (Kingsford Smith) Airport"
    SYE = "Sadah"
    SYF = "Silva Bay"
    SYH = "Syangboche"
    SYI = "Bomar Field"
    SYJ = "Sirjan"
    SYK = "Stykkisholmur"
    SYL = "Roberts AAF"
    SYM = "Pu'er Simao Airport"
    SYN = "Carleton"
    SYO = "Shonai Airport"
    SYP = "Santiago"
    SYQ = "Tobias Bolaños International"
    SYR = "Hancock International Airport"
    SYS = "Yeosu"
    SYT = "Charolais Bourgogne S."
    SYU = "Warraber Island"
    SYV = "Sylvester"
    SYW = "Sehwen Sharif"
    SYX = "Sanya Phoenix International Airport"
    SYY = "Stornoway Airport"
    SYZ = "Shiraz International Airport"
    SZA = "Soyo Airport"
    SZB = "Sultan Abdul Aziz Shah Airport"
    SZC = "Guanacaste"
    SZE = "Semera Airport"
    SZF = "Samsun-Carsamba Airport"
    SZG = "W. A. Mozart Salzburg Airport"
    SZH = "Senipah"
    SZI = "Zaisan"
    SZJ = "Siguanea"
    SZK = "Skukuza Airport"
    SZL = "Whiteman AFB"
    SZM = "Sesriem"
    SZN = "Santa Cruz Island"
    SZP = "Oxnard"
    SZQ = "Saenz Pena"
    SZR = "Stara Zagora"
    SZS = "Stewart Island"
    SZT = "San Cristobal Airport"
    SZU = "Segou"
    SZV = "Suzhou"
    SZW = "Parchim Airport"
    SZX = "Shenzhen Bao'an International Airport"
    SZY = "Olsztyn-Mazury Airport"
    SZZ = "Goleniow Airport"
    TAA = "Tarapaina"
    TAB = "A.N.R. Robinson International Airport"
    TAC = "D. Z. Romualdez Airport"
    TAD = "Las Animas"
    TAE = "Daegu International Airport"
    TAF = "Tafaraoui"
    TAG = "Bohol-Panglao"
    TAH = "Tanna Airport"
    TAI = "Al Janad"
    TAJ = "Tadji"
    TAK = "Takamatsu Airport"
    TAL = "Ralph Calhoun"
    TAM = "Tampico International Airport"
    TAN = "Tangalooma"
    TAO = "Qingdao Liuting International Airport"
    TAP = "Tapachula International Airport"
    TAQ = "Tarcoola"
    TAR = "M. A. Grottag"
    TAS = "Yuzhny Airport"
    TAT = "Poprad/Tatry Airport"
    TAU = "Tauramena"
    TAV = "Tau Island Airport"
    TAW = "Tacuarembo"
    TAX = "Taliabu"
    TAY = "Tartu Airport"
    TAZ = "Dashoguz"
    TBA = "Tabibuga"
    TBB = "Tuy Hoa Airport"
    TBC = "Tuba City"
    TBD = "Timbiqui"
    TBE = "Timbunke"
    TBF = "Tabiteuea North"
    TBG = "Tabubil Airport"
    TBH = "Romblon"
    TBI = "New Bright"
    TBJ = "Tabarka"
    TBK = "Timber Creek"
    TBL = "Tableland"
    TBM = "Tumbang Samba"
    TBN = "Forney AAF"
    TBO = "Tabora Airport"
    TBP = "Capitan FAP Pedro Canga Rodriguez Airport"
    TBQ = "Tarabo"
    TBR = "Statesboro-Bulloch County Airport"
    TBS = "Tbilisi International Airport"
    TBT = "Tabatinga International Airport"
    TBU = "Fua'amotu International Airport"
    TBV = "Tabal"
    TBW = "Tambov Donskoye Airport"
    TBX = "Tambelan Airport"
    TBY = "Tsabong"
    TBZ = "Tabriz Airport"
    TCA = "Tennant Creek"
    TCB = "Treasure Cay Airport"
    TCC = "Tucumcari"
    TCD = "Tarapaca"
    TCE = "Tulcea"
    TCF = "Tocoa"
    TCG = "Tacheng"
    TCH = "Tchibanga"
    TCI = "Terney Airport"
    TCJ = "Torembi Airport"
    TCK = "Tinboli Airport"
    TCL = "Van De Graaf"
    TCM = "McChord AFB"
    TCN = "Tehuacan"
    TCO = "La Florida Airport"
    TCP = "Taba International"
    TCQ = "Tacna Airport"
    TCR = "Tuticorin Airport"
    TCS = "Truth or Consequences"
    TCT = "Takotna"
    TCU = "Thaba Nchu"
    TCW = "Tocumwal"
    TCX = "Tabas"
    TCY = "Terrace Bay"
    TCZ = "Tengchong Tuofeng Airport"
    TDA = "Trinidad"
    TDB = "Tetabedi"
    TDD = "Teniente Jorge Henrich Arauz Airport"
    TDG = "Tandag"
    TDJ = "Tadjoura"
    TDK = "Taldy-Kurgan"
    TDL = "Tandil"
    TDN = "Theda Station"
    TDO = "Winlock"
    TDP = "Trompeteros"
    TDR = "Theodore"
    TDS = "Sasereme"
    TDT = "Tanda Tula"
    TDV = "Tanandava"
    TDW = "Tradewind"
    TDX = "Trat Airport"
    TDZ = "Toledo"
    TEA = "Tela"
    TEB = "Teterboro Airport"
    TEC = "Telemaco Borba"
    TED = "Thisted"
    TEE = "Cheikh Larbi Tebessi Airport"
    TEF = "Telfer Airport"
    TEG = "Tenkodogo"
    TEH = "Tetlin"
    TEI = "Tezu"
    TEK = "Tatitlek"
    TEL = "Telupid"
    TEM = "Temora"
    TEN = "Tongren Airport"
    TEO = "Terapo"
    TEP = "Teptep"
    TEQ = "Corlu"
    TER = "Lajes Field"
    TES = "Tessenei"
    TET = "Matundo Airport"
    TEU = "Manapouri"
    TEV = "Teruel Airport"
    TEX = "Telluride Regional"
    TEY = "Thingeyri"
    TEZ = "Tezpur Airport"
    TFB = "Tifalmin"
    TFF = "Tefe Airport"
    TFI = "Tufi"
    TFL = "Teofilo Otoni"
    TFM = "Telefomin"
    TFN = "Tenerife North Airport"
    TFR = "Ramadan"
    TFS = "Tenerife South Airport"
    TFT = "Taftan"
    TFU = "Chengdu Tianfu International Airport"
    TFY = "Muhammad Taufiq Kiemas Airport"
    TGA = "Tengah Air Base"
    TGB = "Tagbita"
    TGC = "Tanjung Manis Airport"
    TGD = "Podgorica Airport"
    TGE = "Sharpe Field"
    TGG = "Sultan Mahmud Airport"
    TGH = "Tongoa"
    TGI = "Tingo Maria"
    TGJ = "Tiga"
    TGK = "Taganrog"
    TGL = "Tagula"
    TGM = "Transilvania"
    TGN = "La Trobe Regional"
    TGO = "Tongliao Airport"
    TGP = "Podkamennaya Tunguska Airport"
    TGQ = "Tangara da Serra"
    TGR = "Touggourt Airport"
    TGS = "Chokwe"
    TGT = "Tanga Airport"
    TGU = "Toncontin Airport"
    TGV = "Targovishte"
    TGZ = "Angel Albino Corzo International Airport"
    THA = "Tullahoma/William Northern Field"
    THB = "Thaba-Tseka"
    THC = "Tchien"
    THD = "Bai Thuong Airport"
    THE = "Teresina Airport"
    THG = "Thangool"
    THH = "Taharoa"
    THI = "Tichitt"
    THK = "Thakhek"
    THL = "Tachilek Airport"
    THM = "Thompsonfield"
    THN = "Trollhattan Airport"
    THO = "Thorshofn"
    THP = "Hot Springs"
    THQ = "Maijishan"
    THR = "Mehrabad International Airport"
    THS = "Sukhothai Airport"
    THT = "Tamchakett"
    THU = "Pituffik Airport"
    THV = "York Airport"
    THW = "Harbour SPB"
    THX = "Turukhansk Airport"
    THY = "Thohoyandou"
    THZ = "Tahoua"
    TIA = "Tirana International Airport"
    TIB = "Tibu"
    TIC = "Tinak Island"
    TID = "Bouchekif Abde Al-hafidh Boussof"
    TIE = "Tippi"
    TIF = "Taif Airport"
    TIG = "Tingwon"
    TIH = "Tikehau Atoll Airport"
    TII = "Tirinkot"
    TIJ = "Tijuana Airport"
    TIK = "Tinker AFB"
    TIL = "Inverlake"
    TIM = "Timika Airport"
    TIN = "Tindouf Airport"
    TIO = "Tilin"
    TIP = "Tripoli International Airport"
    TIQ = "Tinian International"
    TIR = "Tirupati Airport"
    TIS = "Thursday Island"
    TIU = "Timaru Airport"
    TIV = "Tivat Airport"
    TIW = "Industrial"
    TIX = "Space Coast Regional"
    TIY = "Tidjikja"
    TIZ = "Tari Airport"
    TJA = "Capitan Oriel Lea Plaza Airport"
    TJB = "Tanjung Balai"
    TJC = "Ticantiki"
    TJG = "Tanjung Warukin"
    TJH = "Tajima"
    TJI = "Capiro"
    TJK = "Tokat"
    TJL = "Três Lagoas Airport"
    TJM = "Roshchino International Airport"
    TJN = "Takume"
    TJQ = "Bulutumbang Airport"
    TJS = "Tanjung Selor"
    TJU = "Kulyab Airport"
    TJV = "Thanjavur"
    TKA = "Talkeetna"
    TKB = "Tekadu"
    TKC = "Tiko"
    TKD = "Takoradi Airport"
    TKE = "Tenakee SPB"
    TKF = "Truckee-Tahoe"
    TKG = "Radin Inten II Airport"
    TKH = "Nakhon Sawan"
    TKI = "Tokeen"
    TKJ = "Tok"
    TKK = "Chuuk International Airport"
    TKL = "Taku SPB"
    TKM = "El Peten"
    TKN = "Tokunoshima"
    TKO = "Tlokoeng"
    TKP = "Takapoto"
    TKQ = "Kigoma Airport"
    TKR = "Thakurgaon"
    TKS = "Tokushima Awaodori Airport"
    TKT = "Tak"
    TKU = "Turku Airport"
    TKV = "Tatakoto"
    TKW = "Tekin"
    TKX = "Takaroa"
    TKY = "Turkey Creek"
    TKZ = "Tokoroa"
    TLA = "Teller Airport"
    TLB = "Tarbela"
    TLC = "Toluca International Airport"
    TLD = "Limpopo Valley"
    TLE = "Tulear"
    TLF = "Telida"
    TLG = "Tulagi Island"
    TLH = "Tallahassee International Airport"
    TLI = "Tolitoli"
    TLJ = "Tatalina AFS"
    TLK = "Talakan"
    TLL = "Tallinn Airport"
    TLM = "Zenata Airport"
    TLN = "Hyeres Airport"
    TLO = "Tol"
    TLP = "Tumolbil"
    TLQ = "Turpan Jiaohe Airport"
    TLR = "Mefford Field"
    TLS = "Toulouse-Blagnac Airport"
    TLT = "Tuluksak Airport"
    TLU = "Tolu"
    TLV = "Ben Gurion International Airport"
    TLW = "Talasea"
    TLX = "Talca"
    TLY = "Plastun Airport"
    TLZ = "Catalao"
    TMA = "Henry Tift Myers"
    TMB = "Tamiami"
    TMC = "Tambolaka Airport"
    TMD = "Timbedra"
    TME = "Gabriel Vargas Santos Airport"
    TMF = "Thimarafushi Airport"
    TMG = "Tomanggong"
    TMH = "Tanahmerah"
    TMI = "Tumling Tar Airport"
    TMJ = "Termez Airport"
    TMK = "Tamky"
    TML = "Tamale Airport"
    TMM = "Tamatave"
    TMN = "Tamana Island"
    TMO = "Tumeremo"
    TMP = "Tampere-Pirkkala Airport"
    TMQ = "Tambao"
    TMR = "Aguenar - Hadj Bey Akhamok Airport"
    TMS = "Sao Tome Island Airport"
    TMT = "Trombetas"
    TMU = "Tambor Airport"
    TMW = "Tamworth Airport"
    TMX = "Timimoun Airport"
    TMY = "Tiom"
    TMZ = "Thames"
    TNA = "Jinan Yaoqiang International Airport"
    TNB = "Tanah Grogot"
    TNC = "Tin City Afs"
    TND = "Trinidad"
    TNE = "Tanegashima"
    TNF = "Toussus-le-noble"
    TNG = "Tangier Ibn Battouta Airport"
    TNH = "Tonghua Sanyuanpu Airport"
    TNI = "Satna"
    TNJ = "Kidjang Airport"
    TNK = "Tununak"
    TNL = "Ternopol"
    TNM = "Teniente R. Marsh Martin"
    TNN = "Tainan Airport"
    TNO = "Tamarindo"
    TNP = "Twentynine Palms"
    TNQ = "Teraina"
    TNR = "Antananarivo Airport"
    TNS = "Tungsten"
    TNT = "Dade Collier"
    TNU = "Newton Municipal Airport"
    TNV = "Tabuaeran"
    TNW = "Jumandy"
    TNX = "Stung Treng"
    TNZ = "Tosontsengel"
    TOA = "Torrance Airport"
    TOB = "Tobruk"
    TOC = "Toccoa RG Letourneau Field"
    TOD = "Tioman"
    TOE = "Tozeur Airport"
    TOF = "Tomsk Airport"
    TOG = "Togiak Village"
    TOH = "Torres Airstrip"
    TOI = "Troy Municipal Airport"
    TOJ = "Torrejon AFB"
    TOK = "Torokina"
    TOL = "Toledo Express Airport"
    TOM = "Tombouctou"
    TON = "Tonu"
    TOO = "San Vito"
    TOP = "Philip Billard"
    TOQ = "Barriles"
    TOR = "Torrington Municipal Airport"
    TOS = "Tromso/Langnes Airport"
    TOT = "Coronie"
    TOU = "Touho"
    TOV = "West End SPB"
    TOW = "Toledo"
    TOX = "Tobolsk"
    TOY = "Toyama Airport"
    TOZ = "Touba"
    TPA = "Tampa International Airport"
    TPC = "Tarapoa"
    TPE = "Taiwan Taoyuan International Airport"
    TPF = "Peter O'Knight"
    TPG = "Taiping"
    TPH = "Tonopah Airport"
    TPI = "Tapini"
    TPJ = "Taplejung Suketar"
    TPK = "Tapaktuan"
    TPL = "Draughon-miller Central Texas Regional"
    TPN = "Tiputini"
    TPO = "Tanalian Point"
    TPP = "Cad. FAP Guillermo del Castillo Paredes Airport"
    TPQ = "Tepic Airport"
    TPR = "Tom Price"
    TPS = "Trapani-Birgi Airport"
    TPT = "Tapeta"
    TPU = "Tikapur"
    TPX = "Tupai"
    TQD = "Al Taqaddum AB"
    TQL = "Tarko-Sale"
    TQN = "Taluqan"
    TQP = "Trepell Airport"
    TQQ = "Maranggo Airport"
    TQR = "San Domino Island"
    TQS = "Tres Esquinas"
    TRA = "Tarama"
    TRB = "Gonzalo"
    TRC = "Francisco Sarabia International Airport"
    TRD = "Trondheim Airport Vaernes"
    TRE = "Tiree Airport"
    TRF = "Torp Sandefjord Airport"
    TRG = "Tauranga City Airport"
    TRH = "Trona"
    TRI = "Tri-Cities Regional Airport"
    TRJ = "Tarakbits"
    TRK = "Juwata International Airport"
    TRL = "Terrell Field"
    TRM = "Thermal"
    TRN = "Turin Airport"
    TRO = "Taree Airport"
    TRP = "Tree Point Heliport"
    TRQ = "Tarauaca"
    TRR = "China Bay"
    TRS = "Trieste - Friuli Venezia Giulia Airport"
    TRT = "Tremonton"
    TRU = "Trujillo Airport"
    TRV = "Trivandrum International Airport"
    TRW = "Bonriki Airport"
    TRX = "Memorial"
    TRY = "Tororo"
    TRZ = "Tiruchirapalli International Airport"
    TSA = "Taipei Songshan Airport"
    TSB = "Tsumeb"
    TSC = "Taisha"
    TSD = "Tshipise"
    TSE = "Astana (Nursultan) International Airport"
    TSF = "Treviso Airport"
    TSG = "Intermediate"
    TSH = "Tshikapa"
    TSI = "Tsili Tsili"
    TSJ = "Tsushima Airport"
    TSK = "Taskul"
    TSL = "Tamuin"
    TSM = "Taos"
    TSN = "Tianjin Binhai International Airport"
    TSO = "Tresco"
    TSP = "Kern County"
    TSQ = "Torres"
    TSR = "Timisoara Traian Vuia International Airport"
    TSS = "East 34th St Heliport"
    TST = "Trang Airport"
    TSU = "Tabiteuea South"
    TSV = "Townsville Airport"
    TSW = "Tsewi"
    TSX = "Tanjung Santan"
    TSY = "Tasikmalaya"
    TSZ = "Tsetserleg"
    TTA = "Tan Tan Airport"
    TTB = "Arbatax"
    TTC = "Taltal"
    TTD = "Troutdale"
    TTE = "Babullah Airport"
    TTG = "Tartagal"
    TTH = "Thumrait"
    TTI = "Tetiaroa Island"
    TTJ = "Tottori Airport"
    TTL = "Turtle Island"
    TTM = "Tablon De Tamara"
    TTN = "Trenton-Mercer Airport"
    TTO = "Britton Municipal Airport"
    TTQ = "Tortuquero"
    TTR = "Tana Toraja"
    TTS = "Tsaratanana"
    TTT = "Taitung Airport"
    TTU = "Sania Ramel"
    TTW = "Tissa Tank"
    TTX = "Mungalalu Truscott Airbase"
    TUA = "Tulcan"
    TUB = "Tubuai"
    TUC = "Benj Matienzo"
    TUD = "Tambacounda"
    TUE = "Tupile"
    TUF = "Val de Loire Airport"
    TUG = "Tuguegarao Airport"
    TUH = "Arnold AFS"
    TUI = "Turaif Airport"
    TUJ = "Tum"
    TUK = "Turbat Airport"
    TUL = "Tulsa International Airport"
    TUM = "Tumut"
    TUN = "Tunis-Carthage International Airport"
    TUO = "Taupo Airport"
    TUP = "Tupelo Regional Airport"
    TUQ = "Tougan"
    TUR = "Tucurui"
    TUS = "Tucson International Airport"
    TUT = "Tauta"
    TUU = "Tabuk Regional Airport"
    TUV = "Tucupita"
    TUW = "Tubala"
    TUX = "Tumbler Ridge"
    TUY = "Tulum"
    TUZ = "Tucuma"
    TVA = "Morafenobe"
    TVC = "Cherry Capital Airport"
    TVF = "Thief River Falls Regional Airport"
    TVI = "Thomasville Municipal Airport"
    TVL = "South Lake Tahoe"
    TVS = "Tangshan Sannuhe Airport"
    TVU = "Matei Airport"
    TVY = "Dawe Airport"
    TWA = "Twin Hills"
    TWB = "Toowoomba"
    TWC = "Tumxuk Tangwangcheng Airport"
    TWD = "Port Townsend"
    TWE = "Taylor"
    TWF = "Magic Valley Regional Airport"
    TWH = "Two Harbors"
    TWN = "Tewantin"
    TWP = "Torwood"
    TWT = "Tawitawi"
    TWU = "Tawau Airport"
    TWY = "Tawa"
    TWZ = "Pukaki/Twizel"
    TXC = "Balbasovo Air Base"
    TXE = "Rembele Airport"
    TXF = "Teixeira de Freitas Airport"
    TXG = "Taichung"
    TXK = "Texarkana Municipal Airport"
    TXL = "Tegel Airport"
    TXM = "Teminabuan"
    TXN = "Huangshan Tunxi International Airport"
    TXR = "Tanbar"
    TXU = "Tabou"
    TYA = "Tula"
    TYB = "Tibooburra"
    TYC = "Taiyuan Yaocheng Airport"
    TYD = "Tynda Airport"
    TYE = "Tyonek"
    TYF = "Torsby Airport"
    TYG = "Thylungra"
    TYL = "Captain FAP Victor Montes Arias Airport"
    TYM = "Staniel Cay"
    TYN = "Taiyuan Wusu International Airport"
    TYP = "Tobermorey"
    TYR = "Tyler Pounds Regional Airport"
    TYS = "McGhee Tyson Airport"
    TYT = "Treinta-y-Tres"
    TYZ = "Taylor"
    TZA = "Municipal"
    TZC = "Tuscola Area"
    TZL = "Tuzla International Airport"
    TZM = "Tizimin"
    TZN = "South Andros"
    TZO = "Tsimiroro"
    TZX = "Trabzon Airport"
    UAB = "Adana-Incirlik Airbase"
    UAC = "San Luis Rio Colorado"
    UAE = "Mount Aue"
    UAH = "Ua Huka"
    UAI = "Suai"
    UAK = "Narsarsuaq Airport"
    UAL = "Luau"
    UAM = "Andersen AFB"
    UAP = "Ua Pou"
    UAQ = "San Juan Airport"
    UAR = "Bouarfa"
    UAS = "Samburu"
    UAX = "Uaxactun"
    UBA = "Uberaba Airport"
    UBB = "Mabuiag Island"
    UBI = "Buin"
    UBJ = "Yamaguchi Ube Airport"
    UBN = "New Ulaanbaatar International Airport"
    UBP = "Ubon Ratchathani International Airport"
    UBR = "Ubrub"
    UBS = "Lowndes County"
    UBT = "Ubatuba"
    UBU = "Kalumburu"
    UCA = "Oneida County"
    UCB = "Ulanqab Jining Airport"
    UCC = "Yucca Flat"
    UCE = "Eunice"
    UCK = "Lutsk"
    UCN = "Buchanan"
    UCT = "Ukhta Airport"
    UCY = "Everett-Stewart"
    UDA = "Undarra"
    UDD = "Bermuda Dunes"
    UDE = "Volkel"
    UDI = "Uberlandia-Ten. Cel. Av. Cesar Bombonato Airport"
    UDJ = "Uzhgorod"
    UDN = "Airfield"
    UDO = "Udomxay"
    UDR = "Maharana Pratap Airport"
    UEE = "Queenstown"
    UEL = "Quelimane Airport"
    UEN = "Urengoy"
    UEO = "Kume-jima Airport"
    UER = "Puertollano"
    UES = "Waukesha"
    UET = "Quetta Airport"
    UFA = "Ufa International Airport"
    UGA = "Bulgan"
    UGB = "Ugashik Bay"
    UGC = "Urgench Airport"
    UGI = "Uganik"
    UGL = "Union Glacier Blue-Ice Runway"
    UGN = "Memorial"
    UGO = "Uige"
    UGS = "Ugashik"
    UGT = "Umnugobitour"
    UGU = "Zugapa"
    UHE = "Kunovice"
    UHS = "Aleksandrovsk-Sakhalinskiy Airport"
    UIB = "El Carano Airport"
    UIH = "Phu Cat Airport"
    UII = "Utila"
    UIK = "Ust-Ilimsk"
    UIL = "Quillayute State"
    UIN = "Quincy Municipal Airport"
    UIO = "Mariscal Sucre International Airport"
    UIP = "Pluguffan Airport"
    UIQ = "Quine Hill"
    UIR = "Quirindi"
    UIT = "Jaluit Island"
    UIZ = "Berz-Macomb"
    UJE = "Ujae Island"
    UJN = "Uljin"
    UJU = "Uiju Airfield"
    UKA = "Ukunda Airport"
    UKB = "Kobe Airport"
    UKG = "Ust-Kuiga"
    UKH = "Mukhaizna"
    UKI = "Ukiah"
    UKK = "Ust-Kamenogorsk Airport"
    UKN = "Waukon Municipal Airport"
    UKR = "Mukeiras"
    UKS = "Belbek"
    UKT = "Upper Bucks"
    UKU = "Nuku"
    UKX = "Ust-Kut Airport"
    UKY = "Kyoto"
    ULA = "San Julian"
    ULB = "Ulei"
    ULC = "Los Cerrillos"
    ULD = "Ulundi"
    ULE = "Sule"
    ULG = "Ulgit"
    ULH = "Prince Abdul Majeed bin Abdulaziz Airport"
    ULI = "Ulithi"
    ULK = "Lensk Airport"
    ULL = "Mull"
    ULM = "New Ulm"
    ULN = "Chinggis Khaan International Airport"
    ULO = "Ulaangom"
    ULP = "Quilpie"
    ULQ = "Farfan"
    ULS = "Mulatos"
    ULU = "Gulu"
    ULV = "Baratayevka"
    ULX = "Ulusaba"
    ULY = "Ulyanovsk Vostochny Airport"
    ULZ = "Uliastai"
    UMA = "Punta De Maisi"
    UMB = "North Shore"
    UMC = "Umba"
    UMD = "Uummannaq"
    UME = "Umea Airport"
    UMI = "Quincemil"
    UMM = "Summit"
    UMR = "Woomera"
    UMS = "Ust-Maya"
    UMT = "Umiat"
    UMU = "Ernesto Geisel"
    UMY = "Sumy"
    UMZ = "Mena Intermountain Municipal Airport"
    UNA = "Una"
    UNC = "Unguia"
    UND = "Kunduz"
    UNE = "Qachas Nek"
    UNG = "Kiunga"
    UNI = "Union Island"
    UNK = "Unalakleet Airport"
    UNN = "Ranong Airport"
    UNR = "Underkhaan"
    UNS = "Umnak"
    UNT = "Baltasound"
    UNU = "Dodge County"
    UOA = "Mururoa Airstrip"
    UOL = "Buol"
    UON = "Muong Sai"
    UOS = "Franklin County"
    UOX = "University-Oxford"
    UPA = "Punta Alegre"
    UPB = "Playa Baracoa"
    UPG = "Sultan Hasanuddin International Airport"
    UPL = "Upala"
    UPN = "Licenciado y General Ignacio Lopez Rayon Airport"
    UPP = "Upolu Point"
    UPR = "Upiara"
    UPV = "Upavon"
    UQE = "Queen"
    URA = "Uralsk Airport"
    URB = "Ernesto Pochler"
    URC = "Urumqi Diwopu International Airport"
    URD = "Burg Feuerstein"
    URE = "Kuressaare Airport"
    URG = "Ruben Berta Airport"
    URI = "Uribe"
    URJ = "Uraj Airport"
    URM = "Uriman"
    URN = "Urgoon"
    URO = "Boos"
    URR = "Urrao"
    URS = "Kursk Vostochny Airport"
    URT = "Surat Thani Airport"
    URU = "Uroubi"
    URY = "Gurayat Airport"
    URZ = "Uruzgan"
    USA = "Concord-Padgett Regional Airport"
    USC = "Union County Airport"
    USH = "Malvinas Argentinas International Airport"
    USI = "Mabaruma"
    USJ = "Usharal"
    USK = "Usinsk Airport"
    USL = "Useless Loop"
    USM = "Koh Samui Airport"
    USN = "Ulsan Airport"
    USO = "Usino"
    USQ = "Usak"
    USR = "Ust-Nera Airport"
    USS = "Sancti Spiritus"
    UST = "St. Augustine Airport"
    USU = "Busuanga Airport"
    UTA = "Mutare"
    UTB = "Muttaburra"
    UTC = "Soesterberg"
    UTD = "Nutwood Downs"
    UTG = "Quthing"
    UTH = "Udon Thani International Airport"
    UTI = "Utti"
    UTK = "Utirik Island"
    UTL = "Torremolinos"
    UTM = "Tunica Municipalcipal Airport"
    UTN = "Upington Airport"
    UTO = "Indian Mountain AFS"
    UTP = "Utapao Airport"
    UTR = "Uttaradit"
    UTS = "Ust-Tsilma"
    UTT = "Umtata Airport"
    UTU = "Ustupo"
    UTW = "Queenstown"
    UUA = "Bugulma Airport"
    UUD = "Ulan-Ude Airport"
    UUK = "Kuparuk"
    UUN = "Baruun-Urt"
    UUS = "Yuzhno-Sakhalinsk Airport"
    UUU = "Manumu"
    UVA = "Garner Field"
    UVE = "Ouvea Airport"
    UVF = "Hewanorra Airport"
    UVI = "União da Vitória Airport"
    UVL = "Kharga"
    UVO = "Uvol"
    UWA = "Ware"
    UYL = "Nyala"
    UYN = "Yulin Yuyang Airport"
    UYU = "Uyuni"
    UZC = "Uzice-Ponikve"
    UZH = "Unayzah"
    UZM = "Hope Bay"
    UZR = "Urzhar Airport"
    UZU = "Curuzu Cuatia"
    VAA = "Vaasa Airport"
    VAB = "Yavarate"
    VAC = "Varrelbusch"
    VAD = "Moody AFB"
    VAF = "Chabeuil"
    VAG = "Major-Brigadeiro Trompowsky Airport"
    VAH = "Vallegrande"
    VAI = "Vanimo Airport"
    VAK = "Chevak Airport"
    VAL = "Valenca"
    VAM = "Villa International Airport Maamigili"
    VAN = "Van Ferit Melen Airport"
    VAO = "Suavanao Airstrip"
    VAP = "Valparaiso"
    VAR = "Varna Airport"
    VAS = "Sivas Airport"
    VAT = "Vatomandry"
    VAU = "Vatukoula"
    VAV = "Lupepau'u Airport"
    VAW = "Vardoe Airport"
    VBA = "Ann"
    VBC = "Mandalay Chanmyathazi Airport"
    VBG = "Vandenberg AFB"
    VBM = "Blue Mountain"
    VBP = "Bokpyin Airport"
    VBS = "Montichiari Airport"
    VBV = "Vanuabalavu"
    VBY = "Visby Airport"
    VCA = "Can Tho Airport"
    VCB = "View Cove"
    VCC = "New Vacaria Airport"
    VCD = "Victoria River Downs"
    VCE = "Venice Marco Polo Airport"
    VCF = "Valcheta Airport"
    VCH = "Vichadero"
    VCL = "Chu Lai International Airport"
    VCP = "Viracopos Airport"
    VCR = "Carora"
    VCS = "Con Dao"
    VCT = "County-Foster"
    VCV = "Southern California Logistics"
    VDA = "Ovda Airport"
    VDB = "Valdres Lufthavn Leirin"
    VDC = "Vitoria Da Conquista Airport"
    VDE = "Hierro Airport"
    VDH = "Dong Hoi Airport"
    VDI = "Vidalia Municipal Airport"
    VDM = "Gobernador Edgardo Castello Airport"
    VDO = "Van Don"
    VDP = "Valle De Pascua"
    VDR = "Villa Dolores"
    VDS = "Vadso Airport"
    VDU = "Tom O'Connor Oilfield"
    VDY = "Jindal"
    VDZ = "Valdez Municipal Airport"
    VEE = "Venetie"
    VEG = "Maikwak"
    VEL = "Vernal Regional Airport"
    VER = "Veracruz International Airport"
    VEV = "Barakoma"
    VEX = "Tioga Municipal Airport"
    VEY = "Vestmannaeyjar"
    VFA = "Victoria Falls Airport"
    VGA = "Vijayawada Airport"
    VGD = "Vologda Airport"
    VGG = "Vangrieng"
    VGO = "Vigo Airport"
    VGS = "General Villegas"
    VGT = "North Air Terminal"
    VGZ = "Villagarzon"
    VHC = "Saurimo"
    VHM = "Vilhelmina Airport"
    VHN = "Culberson County"
    VHV = "Verhnevilyuisk"
    VHY = "Charmeil"
    VHZ = "Vahitahi"
    VIA = "Vienna"
    VIB = "Villa Constitucion"
    VIC = "Trissino"
    VIE = "Vienna International Airport"
    VIF = "Vieste"
    VIG = "El Vigia"
    VIH = "Rolla National"
    VII = "Vinh Airport"
    VIJ = "Virgin Gorda Airport"
    VIK = "Airstrip"
    VIL = "Dakhla Airport"
    VIN = "Havryshivka Vinnytsia International Airport"
    VIQ = "Viqueque"
    VIR = "Virginia"
    VIS = "Visalia"
    VIT = "Vitoria Airport"
    VIU = "Viru Harbour Airstrip"
    VIV = "Vivigani"
    VIX = "Eurico de Aguiar Salles Airport"
    VIY = "Villa Coublay"
    VJB = "Xai Xai"
    VJI = "Virginia Highlands"
    VJQ = "Gurue"
    VKG = "Rach Gia Airport"
    VKO = "Vnukovo Airport"
    VKS = "Vicksburg"
    VKT = "Vorkuta Airport"
    VKW = "West Kavik"
    VLA = "Vandalia"
    VLC = "Valencia Airport"
    VLD = "Valdosta Regional Airport"
    VLE = "J t Robidoux"
    VLG = "Villa Gesell"
    VLI = "Bauerfield Airport"
    VLK = "Volgodonsk"
    VLL = "Valladolid Airport"
    VLM = "Villamontes"
    VLN = "Arturo Michelena International Airport"
    VLO = "Stolport"
    VLP = "Vila Rica"
    VLR = "Vallenar"
    VLS = "Valesdir"
    VLU = "Velikiye Luki"
    VLV = "Carvajal"
    VLY = "Anglesey Airport"
    VME = "Villa Mercedes"
    VMI = "INC"
    VMU = "Baimuru"
    VNA = "Saravane"
    VNC = "Venice Municipalcipal"
    VND = "Vangaindrano"
    VNE = "Meucon"
    VNG = "Viengxay"
    VNO = "Vilnius International Airport"
    VNR = "Vanrook"
    VNS = "Lal Bahadur Shastri International Airport"
    VNT = "Ventspils"
    VNX = "Vilanculos Airport"
    VNY = "Van Nuys Airport"
    VOD = "Vodochody"
    VOG = "Volgograd International Airport"
    VOH = "Vohemar"
    VOI = "Voinjama"
    VOK = "Volk Field"
    VOL = "Nea Anchialos"
    VOT = "Votuporanga"
    VOZ = "Voronezh Airport"
    VPE = "Ondjiva"
    VPG = "Vipingo"
    VPN = "Vopnafjordur"
    VPS = "Destin Fort Walton Beach Airport"
    VPY = "Chimoio Airport"
    VPZ = "Porter County"
    VQQ = "Cecil Field"
    VQS = "Antonio Rivera Rodriguez Airport"
    VRA = "Juan Gualberto Gomez Airport"
    VRB = "Vero Beach Municipal Airport"
    VRC = "Virac Airport"
    VRE = "Vredendal"
    VRI = "Varandey"
    VRK = "Varkaus"
    VRL = "Vila Real Airport"
    VRN = "Verona Villafranca Airport"
    VRO = "Kawama"
    VRS = "Versailles"
    VRU = "Vryburg"
    VRY = "Stolport (Not operational)"
    VRZ = "Lavras Airport"
    VSA = "Carlos Rovirosa Perez International Airport"
    VSE = "Viseu Airport"
    VSF = "State"
    VSG = "Lugansk"
    VSK = "Vista Field"
    VSO = "Phuoclong"
    VST = "Vasteras/Hasslo Airport"
    VTA = "Victoria"
    VTB = "Vitebsk"
    VTE = "Wattay International Airport"
    VTF = "Vatulele"
    VTG = "Vung Tau"
    VTL = "Vittel"
    VTM = "Nevatim AFB"
    VTN = "Miller Field"
    VTU = "Las Tunas"
    VTZ = "Vishakhapatnam Airport"
    VUP = "Valledupar Airport"
    VUS = "Velikij Ustyug Airport"
    VUU = "Mvuu Camp"
    VVB = "Mahanoro"
    VVC = "La Vanguardia Airport"
    VVI = "Viru Viru International Airport"
    VVK = "Vastervik"
    VVN = "Malvinas"
    VVO = "Vladivostok International Airport"
    VVZ = "Illizi Airport"
    VXC = "Lichinga Airport"
    VXE = "Cesaria Evora International Airport"
    VXO = "Vaxjo Airport"
    VYD = "Vryheid"
    VYI = "Vilyuisk"
    VYS = "Illinois Valley Regnl"
    WAA = "Wales Airport"
    WAB = "Wabag"
    WAC = "Waca"
    WAD = "Andriamena"
    WAE = "Wadi Ad Dawasir Airport"
    WAF = "Wana"
    WAG = "Wanganui Airport"
    WAH = "Wahpeton"
    WAI = "Antsohihy"
    WAJ = "Wawoi Falls"
    WAK = "Ankazoabo"
    WAL = "Wallops Flight Center"
    WAM = "Ambatondrazaka"
    WAN = "Waverney"
    WAO = "Wabo"
    WAP = "Alto Palena"
    WAQ = "Antsalova"
    WAR = "Waris"
    WAT = "Waterford"
    WAU = "Wauchope"
    WAV = "Kalkgurung"
    WAW = "Frederic Chopin Airport"
    WAX = "Zuwarah"
    WAY = "Greene County"
    WAZ = "Warwick"
    WBA = "Wahai"
    WBB = "Stebbins Airport"
    WBC = "Wapolu"
    WBD = "Befandriana"
    WBE = "Bealanana"
    WBG = "Schleswig-jagel"
    WBI = "Broker Inn"
    WBK = "Community"
    WBM = "Wapenamanda Airport"
    WBN = "Cummings Park"
    WBO = "Beroroha"
    WBQ = "Beaver"
    WBR = "Big Rapids"
    WBU = "Boulder Municipal"
    WBW = "Wilkes-Barre/Wyoming Valley"
    WCA = "Gamboa"
    WCD = "Carosue Dam Airport"
    WCH = "Chaiten"
    WCR = "Chandalar"
    WDA = "Wadi Ain"
    WDB = "Deep Bay"
    WDG = "Enid Woodring Mun."
    WDH = "Hosea Kutako International Airport"
    WDI = "Wondai"
    WDN = "Waldron Island"
    WDR = "Winder"
    WDS = "Shiyan Wudangshan Airport"
    WDY = "Kodiak Fss"
    WEA = "Parker County"
    WED = "Wedau"
    WEF = "Weifang Airport"
    WEH = "Weihai International Airport"
    WEI = "Weipa Airport"
    WEL = "Welkom"
    WEP = "Weam"
    WES = "Weasua Airport"
    WET = "Wagethe"
    WEW = "Wee Waa"
    WFB = "Waterfront SPB"
    WFD = "Woodford"
    WFI = "Fianarantsoa"
    WFK = "Frenchville"
    WGA = "Wagga Wagga Airport"
    WGB = "Bahawalnagar"
    WGC = "Warangal"
    WGE = "Walgett"
    WGN = "Waitangi"
    WGO = "Winchester Regional"
    WGP = "Waingapu Airport"
    WGT = "Wangaratta"
    WGU = "Wagau"
    WGY = "Wagny"
    WHA = "Wuhu Xuanzhou Airport"
    WHB = "Eliwana Airport"
    WHD = "SPB"
    WHF = "Wadi Halfa"
    WHH = "Hiltons Har H"
    WHK = "Whakatane Airport"
    WHL = "Welshpool"
    WHO = "Franz Josef"
    WHP = "Whiteman"
    WHS = "Whalsay"
    WHT = "Wharton"
    WHU = "Wuhu"
    WIB = "Wilbarger County"
    WIC = "Wick Airport"
    WIE = "Air Base"
    WIK = "Surfdale"
    WIL = "Wilson Airport"
    WIN = "Winton Airport"
    WIO = "Wilcannia"
    WIR = "Wairoa"
    WIT = "Wittenoom"
    WIU = "Witu"
    WJA = "Woja"
    WJF = "William J Fox"
    WJR = "Wajir Airport"
    WJU = "Wonju Airport"
    WKA = "Wanaka"
    WKB = "Warracknabeal"
    WKF = "Waterkloof AFB"
    WKI = "Hwange"
    WKJ = "Hokkaido Airport"
    WKK = "Aleknagik"
    WKL = "Waikoloa Airport"
    WKN = "Wakunai"
    WKR = "Walker's Cay"
    WLA = "Wallal"
    WLB = "Labouchere Bay"
    WLC = "Walcha"
    WLD = "Arkansas City"
    WLE = "Miles Airport"
    WLG = "Wellington International Airport"
    WLH = "Walaha"
    WLK = "Selawik Airport"
    WLL = "Wollogorang"
    WLM = "Waltham"
    WLN = "Little Naukati"
    WLO = "Waterloo"
    WLP = "West Angelas Airport"
    WLR = "Loring"
    WLS = "Wallis Island Airport"
    WLW = "Glenn County"
    WMA = "Mandritsara"
    WMB = "Warrnambool"
    WMC = "Winnemucca"
    WMD = "Mandabe"
    WME = "Mount Keith"
    WMH = "Mountain Home"
    WMI = "Warsaw-Modlin Airport"
    WMK = "SPB"
    WML = "Malaimbandy"
    WMN = "Maroantsetra"
    WMO = "White Mountain Airport"
    WMP = "Mampikony"
    WMR = "Mananara"
    WMT = "Zunyi Maotai Airport"
    WMV = "Madirovalo"
    WMX = "Wamena Airport"
    WNA = "Napakiak Sea Plane Base"
    WNC = "Naukati Bay SPB"
    WND = "Windarra"
    WNE = "Wora Na Ye"
    WNH = "Wenshan Puzhehei Airport"
    WNI = "Matahora Airport"
    WNN = "Wunnummin Lake Airport"
    WNP = "Naga Airport"
    WNR = "Windorah"
    WNS = "Nawabshah"
    WNU = "Wanuma"
    WNZ = "Wenzhou Longwan International Airport"
    WOA = "Wonenara"
    WOD = "Wood River"
    WOE = "Woensdrecht"
    WOG = "Woodgreen Airport"
    WOK = "Wonken"
    WOL = "Wollongong"
    WON = "Wondoola"
    WOO = "Woodchopper"
    WOR = "Moramba"
    WOS = "Wonsan"
    WOT = "Wonan"
    WOW = "Willow"
    WPA = "Puerto Aisen"
    WPB = "Port Berge"
    WPC = "Pincher Creek"
    WPK = "Wrotham Park"
    WPL = "Powell Lake"
    WPM = "Wipim"
    WPO = "North Fork Valley"
    WPR = "Porvenir"
    WPU = "Puerto Williams"
    WRA = "Warder"
    WRB = "Robins AFB"
    WRE = "Whangarei Airport"
    WRG = "Wrangell Airport"
    WRH = "Wrench Creek"
    WRI = "Mc Guire AFB"
    WRL = "Worland Municipalcipal"
    WRN = "Windarling Airport"
    WRO = "Wroclaw Airport"
    WRT = "Warton Aerodrome"
    WRW = "Warrawagine"
    WRY = "Westray Airport"
    WRZ = "Wirawila"
    WSA = "Wasua"
    WSB = "SPB"
    WSD = "Condron AAF"
    WSF = "Sarichef"
    WSG = "County"
    WSH = "Brookhaven"
    WSJ = "San Juan SPB"
    WSK = "Chongqing Wushan Airport"
    WSM = "Wiseman"
    WSN = "South Naknek"
    WSO = "Washabo"
    WSP = "Waspam"
    WSR = "Wasior"
    WST = "Westerly State"
    WSU = "Wasu"
    WSX = "Westsound"
    WSY = "Whitsunday Airstrip"
    WSZ = "Westport Airport"
    WTA = "Tambohorano"
    WTB = "Toowoomba Wellcamp Airport"
    WTC = "World Trade Center"
    WTD = "West End"
    WTE = "Wotje Island"
    WTK = "Noatak"
    WTL = "Tuntutuliak"
    WTN = "Waddington RAF Station"
    WTO = "Wotho Island"
    WTP = "Woitape"
    WTR = "White River"
    WTS = "Tsiroanomandidy"
    WTT = "Wantoat"
    WTZ = "Whitianga"
    WUA = "Wuhai Airport"
    WUD = "Wudinna"
    WUG = "Wau"
    WUH = "Wuhan Tianhe International Airport"
    WUI = "Murrin Murrin Airport"
    WUM = "Wasum"
    WUN = "Wiluna"
    WUS = "Wuyishan Airport"
    WUT = "Xinzhou Wutaishan Airport"
    WUU = "Wau"
    WUV = "Wuvulu Island"
    WUX = "Sunan Shuofang International Airport"
    WUZ = "Changzhoudao"
    WVB = "Rooikop Airport"
    WVI = "Watsonville"
    WVK = "Manakara"
    WVL = "Robert Lafleur"
    WVN = "Wilhelmshaven"
    WWA = "Wasilla"
    WWD = "Cape May County"
    WWI = "Woodie Woodie"
    WWK = "Boram Airport"
    WWP = "Whale Pass"
    WWR = "West Woodward"
    WWT = "Newtok"
    WWY = "West Wyalong"
    WXN = "Wanxian Airport"
    WYA = "Whyalla Airport"
    WYB = "SPB"
    WYE = "Yengema"
    WYN = "Wyndham"
    WYS = "Yellowstone Airport"
    WZA = "Wa Airport"
    WZQ = "Urad Middle Banner"
    WZY = "Paradise Island Seaplane Base"
    XAA = "Yerevan Stadium"
    XAI = "Xinyang Minggang Airport"
    XAL = "Alamos"
    XAP = "Chapeco Airport"
    XAR = "Aribinda"
    XAU = "Saul"
    XAY = "Xayabury"
    XBB = "Blubber Bay"
    XBE = "Bearskin Lake"
    XBG = "Bogande"
    XBJ = "Birjand Airport"
    XBL = "Buno Bedelle"
    XBN = "Biniguni"
    XBO = "Boulsa"
    XBR = "Brockville"
    XBW = "Killineq"
    XCH = "Christmas Island Airport"
    XCL = "Cluff Lake"
    XCM = "Chatham"
    XCN = "Coron Airport"
    XCO = "Colac"
    XCR = "Chalons Vatry Airport"
    XDE = "Diebougou"
    XDJ = "Djibo"
    XEN = "Xingcheng"
    XEO = "Harbour"
    XEQ = "Harbour"
    XES = "Lake Geneva Aire Estates Airport"
    XEX = "Aerogare"
    XFN = "Xiangyang Airport"
    XFW = "Hamburg Finkenwerder Airport"
    XFZ = "Charny"
    XGA = "Gaoua"
    XGG = "Gorom-Gorom"
    XGL = "Granville Lake"
    XGN = "Xangongo"
    XGR = "Kangiqsualujjuaq Airport"
    XHN = "Guillemins, Raiway Stn"
    XIC = "Xichang Airport"
    XIE = "Xienglom"
    XIG = "Xinguara"
    XIJ = "Ahmed Al Jaber"
    XIL = "Xilinhot Airport"
    XIN = "Xingning"
    XIQ = "Harbour"
    XIY = "Xianyang International Airport"
    XJD = "Al Udeid AB"
    XJH = "Hong Kong Harbour"
    XJM = "Mangla Airport"
    XKA = "Kantchari"
    XKH = "Xieng Khouang Airport"
    XKO = "Kemano"
    XKS = "Kasabonika"
    XKY = "Kaya"
    XLB = "Lac Brochet"
    XLF = "Leaf Bay"
    XLO = "Long Xuyen"
    XLS = "St Louis"
    XLU = "Leo"
    XLW = "Lemwerder"
    XMA = "Maramag"
    XMC = "Mallacoota"
    XMD = "Madison"
    XMG = "Mahendranagar"
    XMH = "Manihi"
    XMI = "Masasi"
    XML = "Minlaton"
    XMN = "Xiamen Gaoqi International Airport"
    XMP = "Macmillan Pass"
    XMS = "Macas"
    XMY = "Yam Island"
    XNA = "Northwest Arkansas Regional"
    XNG = "Quang Ngai"
    XNH = "Nasiriyah Airport"
    XNN = "Xining Caojiabao Airport"
    XNT = "Xingtai"
    XNU = "Nouna"
    XNY = "39th Street Ferry"
    XOF = "Stratford International Rail Station"
    XPA = "Pama"
    XPK = "Pukatawagan"
    XPL = "Coronel Enrique Soto Cano AB"
    XPP = "Poplar River"
    XPR = "Pine Ridge"
    XPU = "West Kuparuk"
    XPZ = "Harbour"
    XQP = "Quepos Airport"
    XQU = "Qualicum"
    XRH = "Richmond AFB"
    XRQ = "Xinbarag Youqi Baogede Airport"
    XRR = "Ross River"
    XRY = "Jerez Airport"
    XSB = "Sir Bani Yas Island Airport"
    XSC = "International"
    XSD = "Test Range"
    XSE = "Sebba"
    XSI = "South Indian Lake"
    XSM = "St Marys"
    XSO = "Siocon"
    XSP = "Seletar"
    XTG = "Thargomindah"
    XTL = "Tadoule Lake"
    XTO = "Taroom"
    XTR = "Tara"
    XTT = "Etoile"
    XUZ = "Xuzhou Guanyin Airport"
    XVL = "Vinh Long"
    XWA = "Williston Basin International Airport"
    XWZ = "Nykoping"
    XXK = "Katrineholm"
    XYA = "Yandina"
    XYE = "Ye"
    XYP = "Avesta Krylbo"
    XYR = "Yellow River"
    XZA = "Zabre"
    YAA = "Anahim Lake"
    YAB = "Arctic Bay"
    YAC = "Cat Lake"
    YAD = "Moose Lake"
    YAE = "Alta Lake"
    YAF = "Asbestos Hill"
    YAG = "Fort Frances Municipal Airport"
    YAH = "Lagrande 4"
    YAI = "Chillan"
    YAJ = "Lyall Harbour"
    YAK = "Yakutat Airport"
    YAL = "Alert Bay"
    YAM = "Sault Ste. Marie Airport"
    YAN = "Yangambi"
    YAO = "Yaounde Airport"
    YAP = "Yap International Airport"
    YAQ = "Maple Bay"
    YAR = "Lagrande 3"
    YAS = "Yasawa Island"
    YAT = "Attawapiskat"
    YAU = "Kattiniq/donaldson"
    YAV = "Miners Bay"
    YAW = "Shearwater"
    YAX = "Angling Lake Airport"
    YAY = "St Anthony"
    YAZ = "Tofino Airport"
    YBA = "Banff"
    YBB = "Kugaaruk"
    YBC = "Baie-Comeau Airport"
    YBD = "New Westminster"
    YBE = "Uranium City"
    YBF = "Bamfield"
    YBG = "Saguenay-Bagotville Airport"
    YBH = "Bull Harbour"
    YBI = "Black Tickle"
    YBJ = "Baie Johan Beetz"
    YBK = "Baker Lake"
    YBL = "Campbell River Airport"
    YBM = "Bronson Creek"
    YBN = "Borden"
    YBO = "Bob Quinn Lake"
    YBP = "Yibin Caiba Airport"
    YBQ = "Telegraph Harbour"
    YBR = "Brandon Municipal Airport"
    YBS = "Musselwhite"
    YBT = "Brochet"
    YBV = "Berens River Airport"
    YBW = "Springbank"
    YBX = "Blanc Sablon"
    YBY = "Bonnyville"
    YCA = "Courtenay"
    YCB = "Cambridge Bay Airport"
    YCC = "Regional"
    YCD = "Nanaimo Airport"
    YCE = "Centralia"
    YCF = "Cortes Bay"
    YCG = "Castlegar Airport"
    YCH = "Miramichi"
    YCI = "Caribou Island"
    YCJ = "Cape St James"
    YCK = "Colville Lake"
    YCL = "Charlo"
    YCM = "Niagara District Airport"
    YCN = "Cochrane"
    YCO = "Kugluktuk Airport"
    YCP = "Co-op Point"
    YCQ = "Chetwynd"
    YCR = "Cross Lake"
    YCS = "Chesterfield Inlet"
    YCT = "Coronation"
    YCU = "Yuncheng Airport"
    YCV = "Cartierville"
    YCW = "Chilliwack Municipalcipal Airport"
    YCX = "Gagetown"
    YCY = "Clyde River"
    YCZ = "Fairmont Hot Springs"
    YDA = "Dawson City Airport"
    YDB = "Burwash Landings"
    YDC = "Industrial Airport"
    YDE = "Paradise River"
    YDF = "Deer Lake Regional Airport"
    YDG = "Digby"
    YDH = "Daniels Harbour"
    YDI = "Davis Inlet"
    YDJ = "Hatchet Lake"
    YDK = "Main Duck Island"
    YDL = "Dease Lake"
    YDN = "Dauphin"
    YDO = "St Methode"
    YDP = "Nain"
    YDQ = "Dawson Creek"
    YDR = "Broadview"
    YDS = "Desolation Sound"
    YDT = "Boundary Bay Airport"
    YDU = "Kasba Lake"
    YDV = "Bloodvein"
    YDW = "Obre Lake"
    YDX = "Doc Creek"
    YEB = "Bar River"
    YEC = "Yecheon"
    YED = "Namao Field"
    YEG = "Edmonton International Airport"
    YEH = "Yinchuan Helanshan Airport"
    YEI = "Yenisehir Airport"
    YEK = "Arviat"
    YEL = "Elliot Lake"
    YEM = "East Manitoulin"
    YEN = "Estevan"
    YEO = "Yeovilton"
    YEP = "Estevan Point"
    YEQ = "Yenkis"
    YER = "Fort Severn"
    YES = "Yasouj"
    YET = "Edson"
    YEU = "Eureka"
    YEV = "Inuvik Mike Zubko Airport"
    YEY = "Amos"
    YFA = "Fort Albany"
    YFB = "Iqaluit Airport"
    YFC = "Fredericton International Airport"
    YFE = "Forestville"
    YFG = "Fontanges"
    YFH = "Fort Hope"
    YFI = "Firebag"
    YFJ = "Snare Lake"
    YFL = "Fort Reliance"
    YFO = "Flin Flon Airport"
    YFR = "Fort Resolution"
    YFS = "Fort Simpson"
    YFX = "Fox Harbour (St Lewis)"
    YGA = "Gagnon"
    YGB = "Gillies Bay"
    YGC = "Grande Cache"
    YGE = "Gorge Harbor"
    YGG = "Ganges Harbor"
    YGH = "Fort Good Hope"
    YGJ = "Miho Airport"
    YGK = "Kingston/Norman Rogers Airport"
    YGL = "La Grande Airport"
    YGM = "Gimli"
    YGN = "Greenway Sound"
    YGO = "Gods Lake Narrows Airport"
    YGP = "Michel-Pouliot Gaspe Airport"
    YGQ = "Geraldton"
    YGR = "Iles De La Madeleine"
    YGS = "Germansen"
    YGT = "Igloolik Airport"
    YGV = "Havre St Pierre"
    YGW = "Kuujjuarapik Airport"
    YGX = "Gillam"
    YGY = "Deception"
    YGZ = "Grise Fiord"
    YHA = "Port Hope Simpson"
    YHB = "Hudson Bay"
    YHC = "Hakai Pass"
    YHD = "Dryden Regional Airport"
    YHE = "Hope"
    YHF = "Hearst"
    YHG = "Charlottetown"
    YHH = "Harbor SPB"
    YHI = "Holman"
    YHK = "Gjoa Haven Airport"
    YHM = "Hamilton Airport"
    YHN = "Hornepayne"
    YHO = "Hopedale"
    YHP = "Poplar Hill"
    YHR = "Chevery"
    YHS = "Sechelt"
    YHT = "Haines Junction"
    YHU = "St. Hubert Airport"
    YHY = "Hay River"
    YHZ = "Halifax Stanfield International Airport"
    YIA = "Yogyakarta International Airport"
    YIB = "Atikokan"
    YIC = "Yichun Mingyueshan Airport"
    YIE = "Arxan Yiershi Airport"
    YIF = "Pakuashipi"
    YIG = "Big Bay Marina"
    YIH = "Yichang Sanxia Airport"
    YIK = "Ivujivik"
    YIN = "Yining Airport"
    YIO = "Pond Inlet Airport"
    YIP = "Willow Run Airport"
    YIV = "Island Lake Airport"
    YIW = "Yiwu Airport"
    YJA = "Jasper Airport"
    YJF = "Fort Liard"
    YJN = "St Jean"
    YJO = "Johnny Mountain"
    YJP = "Jasper-hinton"
    YJS = "Samjiyon"
    YJT = "Stephenville"
    YKA = "Kamloops Airport"
    YKC = "Collins Bay"
    YKD = "Township Airport"
    YKE = "Knee Lake"
    YKF = "Region of Waterloo International Airport"
    YKG = "Kangirsuk Airport"
    YKH = "Yingkou Lanqi Airport"
    YKI = "Kennosao Lake"
    YKJ = "Key Lake"
    YKK = "Kitkatla"
    YKL = "Schefferville Airport"
    YKM = "Yakima Air Terminal"
    YKN = "Chan Gurney"
    YKO = "Hakkari–Yüksekova Airport"
    YKQ = "Waskaganish Airport"
    YKS = "Yakutsk Airport"
    YKT = "Klemtu"
    YKU = "Chisasibi"
    YKX = "Kirkland Lake"
    YKY = "Kindersley"
    YKZ = "Buttonville Municipalcipal"
    YLA = "Langara"
    YLB = "Lac Biche"
    YLC = "Kimmirut"
    YLD = "Chapleau"
    YLE = "Wha Ti"
    YLF = "LaForges"
    YLG = "Yalgoo"
    YLH = "Lansdowne House"
    YLI = "Ylivieska"
    YLJ = "Meadow Lake"
    YLK = "Lake Simcoe Regional"
    YLL = "Lloydminster"
    YLM = "Clinton Creek"
    YLN = "Yilan"
    YLO = "Shilo"
    YLP = "Mingan"
    YLQ = "La Tuque"
    YLR = "Leaf Rapids"
    YLS = "Lebel-Sur-Quevillon"
    YLT = "Alert"
    YLV = "Yevlakh Airport"
    YLW = "Kelowna International Airport"
    YLX = "Long Point"
    YLY = "Langley Regional"
    YMA = "Mayo"
    YMB = "Merritt"
    YMC = "Maricourt Airstrip"
    YMD = "Mould Bay"
    YME = "Matane"
    YMF = "Montagne Harbor"
    YMG = "Manitouwadge"
    YMH = "Mary's Harbour"
    YMI = "Minaki"
    YMJ = "Moose Jaw / Air Vice Marshal C. M. Mcewen Airport"
    YMK = "Mys-Kamenny"
    YML = "Charlevoix"
    YMM = "Fort McMurray International Airport"
    YMN = "Makkovik Airport"
    YMO = "Moosonee"
    YMP = "Port McNeil"
    YMR = "Merry Island"
    YMS = "Yurimaguas"
    YMT = "Chibougamau Airport"
    YMU = "Mansons Landing SPB"
    YMV = "Mary River"
    YMW = "Maniwaki"
    YMX = "Mirabel International Airport"
    YNA = "Natashquan"
    YNB = "Yanbu Airport"
    YNC = "Wemindji"
    YND = "Gatineau Airport"
    YNE = "Norway House Airport"
    YNF = "Deer Lake/Stephenville"
    YNG = "Youngstown"
    YNH = "Hudson Hope"
    YNI = "Nitchequon"
    YNJ = "Yanji Chaoyangchuan Airport"
    YNK = "Nootka Sound"
    YNL = "Points North Landing"
    YNM = "Matagami"
    YNN = "Yandi"
    YNO = "North Spirit Lake"
    YNP = "Natuashish Airport"
    YNR = "Arnes"
    YNS = "Nemiscau Airport"
    YNT = "Yantai Laishan International Airport"
    YNX = "Snap Lake"
    YNY = "Yangyang Airport"
    YNZ = "Yancheng Nanyang International Airport"
    YOA = "Ekati"
    YOC = "Old Crow"
    YOD = "Cold Lake"
    YOE = "Falher"
    YOG = "Ogoki"
    YOH = "Oxford House"
    YOI = "Opinaca"
    YOJ = "Footner Lake Airport"
    YOK = "Yokohama"
    YOL = "Yola Airport"
    YON = "Yongphulla Airport"
    YOO = "Oshawa"
    YOP = "Rainbow Lake"
    YOS = "Billy Bishop Regional"
    YOT = "Yotvata"
    YOW = "Ottawa/Macdonald-Cartier International Airport"
    YOY = "Valcartier"
    YPA = "Glass Field"
    YPB = "Port Alberni"
    YPC = "Paulatuk"
    YPD = "Parry Sound"
    YPE = "Peace River"
    YPF = "Esquimalt"
    YPG = "Portage La Prairie"
    YPH = "Inukjuak"
    YPI = "Port Simpson"
    YPJ = "Aupaluk Airport"
    YPL = "Pickle Lake"
    YPM = "Pikangikum"
    YPN = "Port Menier"
    YPO = "Peawanuck"
    YPP = "Pine Point"
    YPQ = "Peterborough"
    YPR = "Digby Island Airport"
    YPS = "Port Hawkesbury"
    YPT = "Pender Harbor"
    YPW = "Powell River"
    YPX = "Puvirnituq"
    YPY = "Fort Chipewyan Airport"
    YPZ = "Burns Lake"
    YQA = "Muskoka"
    YQB = "Quebec City Jean Lesage International Airport"
    YQC = "Quaqtaq"
    YQD = "Clearwater"
    YQE = "Kimberley"
    YQF = "Red Deer Regional Airport"
    YQG = "Windsor International Airport"
    YQH = "Watson Lake"
    YQI = "Yarmouth"
    YQJ = "April Point SPB"
    YQK = "Kenora Airport"
    YQL = "Lethbridge Airport"
    YQM = "Greater Moncton International Airport"
    YQN = "Nakina"
    YQQ = "Comox Airport"
    YQR = "Regina International Airport"
    YQS = "Pembroke Area Municipalcipal"
    YQT = "Thunder Bay International Airport"
    YQU = "Grande Prairie Airport"
    YQV = "Yorkton"
    YQW = "North Battleford"
    YQX = "Gander International Airport"
    YQY = "Sydney Airport"
    YQZ = "Quesnel Airport"
    YRA = "Rae Lakes"
    YRB = "Resolute Bay Airport"
    YRC = "Refuge Cove SPB"
    YRD = "Dean River"
    YRE = "Resolution Island"
    YRF = "Cartwright"
    YRG = "Rigolet"
    YRI = "Riviere Du Loup"
    YRJ = "Roberval"
    YRL = "Red Lake Airport"
    YRM = "Rocky Mountain House"
    YRN = "Rivers Inlet"
    YRO = "Rockcliffe St"
    YRQ = "Trois-Rivieres"
    YRR = "Stuart Island"
    YRS = "Red Sucker Lake"
    YRT = "Rankin Inlet Airport"
    YRV = "Revelstoke"
    YSA = "Sable Island"
    YSB = "Sudbury Airport"
    YSC = "Sherbrooke"
    YSD = "Suffield"
    YSE = "Squamish"
    YSF = "Stony Rapids"
    YSG = "Lutselke"
    YSH = "Smith Falls"
    YSI = "Sans Souci"
    YSJ = "Saint John Airport"
    YSK = "Sanikiluaq Airport"
    YSL = "St Leonard"
    YSM = "Fort Smith Airport"
    YSN = "Salmon Arm"
    YSO = "Postville Airport"
    YSP = "Marathon"
    YSQ = "Spring Island"
    YSR = "Nanisivik"
    YSS = "Slate Island"
    YST = "Ste Therese Point"
    YSU = "Summerside"
    YSV = "Saglek"
    YSX = "Shearwater"
    YSY = "Sachs Harbour"
    YSZ = "Squirrel Cove"
    YTA = "Pembroke And Area Airport"
    YTB = "Hartley Bay"
    YTC = "Sturdee Valley Airport"
    YTD = "Thicket Portage"
    YTE = "Cape Dorset"
    YTF = "Alma"
    YTG = "Sullivan Bay"
    YTH = "Thompson"
    YTI = "Triple Island"
    YTJ = "Terrace Bay"
    YTK = "Tulugak"
    YTL = "Big Trout"
    YTM = "La Macaza"
    YTN = "Riviere Au Tonnerre"
    YTP = "Seaplane Base"
    YTQ = "Tasiujuaq Airport"
    YTR = "Trenton"
    YTS = "Timmins Victor M. Power Airport"
    YTT = "Tisdale"
    YTU = "Tasu"
    YTW = "Yutian Wanfang Airport"
    YTX = "Telegraph Creek"
    YTY = "Yangzhou Taizhou Airport"
    YTZ = "Toronto City Centre Airport"
    YUA = "Yuanmou"
    YUB = "Tuktoyaktuk"
    YUD = "Umiujaq"
    YUE = "Yuendumu"
    YUL = "Montreal-Pierre Elliott Trudeau International Airport"
    YUM = "Yuma International Airport"
    YUS = "Yushu Batang Airport"
    YUT = "Repulse Bay"
    YUX = "Hall Beach"
    YUY = "Rouyn-Noranda Airport"
    YVA = "Iconi"
    YVB = "Bonaventure"
    YVC = "La Ronge"
    YVD = "Yeva"
    YVE = "Vernon Regional Airport"
    YVG = "Vermilion"
    YVM = "Qikiqtarjuaq"
    YVN = "Cape Dyer"
    YVO = "Val-d'Or Airport"
    YVP = "Kuujjuaq Airport"
    YVQ = "Norman Wells"
    YVR = "Vancouver International Airport"
    YVT = "Buffalo Narrows"
    YVV = "Wiarton/Keppel Airport"
    YVZ = "Deer Lake"
    YWA = "Petawawa"
    YWB = "Kangiqsujuaq Airport"
    YWF = "Downtown Waterfront Heliport"
    YWG = "Winnipeg James Armstrong Richardson International Airport"
    YWH = "Victoria Inner Harbour Airport"
    YWJ = "Deline"
    YWK = "Wabush Airport"
    YWL = "Williams Lake Airport"
    YWM = "Williams Harbour"
    YWN = "Winisk"
    YWO = "Lupin"
    YWP = "Webequie"
    YWQ = "Chute-Des-Passes"
    YWR = "White River"
    YWS = "Whistler"
    YWY = "Wrigley"
    YXC = "Canadian Rockies International Airport"
    YXD = "Edmonton City Centre (Blatchford Field) Airport"
    YXE = "Saskatoon International Airport"
    YXF = "Snake River"
    YXH = "Medicine Hat Regional Airport"
    YXI = "Killaloe"
    YXJ = "North Peace Regional Airport"
    YXK = "Rimouski"
    YXL = "Sioux Lookout Airport"
    YXN = "Whale Cove"
    YXP = "Pangnirtung Airport"
    YXQ = "Beaver Creek"
    YXR = "Earlton"
    YXS = "Prince George Airport"
    YXT = "Northwest Regional Airport"
    YXU = "London International Airport"
    YXX = "Abbotsford Airport"
    YXY = "Whitehorse Airport"
    YXZ = "Wawa Airport"
    YYA = "Big Bay Yacht Club"
    YYB = "Jack Garland Airport"
    YYC = "Calgary International Airport"
    YYD = "Smithers Airport"
    YYE = "Northern Rockies Regional Airport"
    YYF = "Penticton Airport"
    YYG = "Charlottetown Airport"
    YYH = "Taloyoak"
    YYI = "Rivers"
    YYJ = "Victoria International Airport"
    YYL = "Lynn Lake"
    YYM = "Cowley"
    YYN = "Swift Current"
    YYQ = "Churchill Airport"
    YYR = "Goose Bay Airport"
    YYT = "St. John's International Airport"
    YYU = "Kapuskasing Airport"
    YYW = "Armstrong"
    YYY = "Mont Joli Airport"
    YYZ = "Pearson International Airport"
    YZA = "Ashcroft"
    YZC = "Beatton River"
    YZE = "Gore Bay"
    YZF = "Yellowknife Airport"
    YZG = "Salluit"
    YZH = "Slave Lake"
    YZM = "Buchans"
    YZP = "Sandspit Airport"
    YZR = "Sarnia Airport"
    YZS = "Coral Harbour Airport"
    YZT = "Port Hardy Airport"
    YZU = "Whitecourt"
    YZV = "Sept-Iles Airport"
    YZW = "Teslin"
    YZX = "Greenwood"
    YZY = "Zhangye Ganzhou Airport"
    YZZ = "Trail Regional Airport"
    ZAA = "Alice Arm"
    ZAC = "York Landing"
    ZAD = "Zadar Airport"
    ZAG = "Zagreb International Airport"
    ZAH = "Zahedan Airport"
    ZAJ = "Zaranj"
    ZAL = "Pichoy Airport"
    ZAM = "Zamboanga International Airport"
    ZAO = "Laberandie"
    ZAR = "Zaria"
    ZAT = "Zhaotong Airport"
    ZAZ = "Zaragoza Airport"
    ZBE = "Dolni Benesov"
    ZBF = "Bathurst Airport"
    ZBK = "Zabljak"
    ZBL = "Biloela"
    ZBM = "Bromont"
    ZBO = "Bowen"
    ZBR = "Chah-Bahar Airport"
    ZBU = "Aarhus Limo"
    ZBY = "Sayaboury"
    ZCL = "La Calera Airport"
    ZCO = "Temuco Airport"
    ZDY = "Delma Island Airport"
    ZEC = "Secunda"
    ZEG = "Senggo"
    ZEL = "Bella Bella Airport"
    ZEM = "East Main"
    ZEN = "Zenag"
    ZER = "Zero"
    ZFA = "Faro"
    ZFB = "Old Fort Bay"
    ZFD = "Fond-du-Lac Airport"
    ZFL = "South Trout Lake"
    ZFM = "Fort Mcpherson"
    ZFN = "Tulita"
    ZFU = "Aruja"
    ZFW = "Fairview"
    ZFZ = "Buffalo Depew Rr"
    ZGF = "Grand Forks"
    ZGI = "Gods River Airport"
    ZGL = "South Galway"
    ZGM = "Ngoma"
    ZGR = "Little Grand Rapids"
    ZGS = "Gethsemani"
    ZGU = "Gaua"
    ZGY = "Kuching Port"
    ZHA = "Zhanjiang Airport"
    ZHI = "Grenchen"
    ZHM = "Shamshernagar"
    ZHP = "High Prairie"
    ZHY = "Zhongwei Airport"
    ZIA = "Zhukovsky International Airport"
    ZIC = "Victoria"
    ZIE = "Harbour (Eolie Island)"
    ZIG = "Ziguinchor"
    ZIH = "Ixtapa/Zihuatanejo Internacional Airport"
    ZIP = "Harbour (Eolie Island)"
    ZIS = "Alzintan Airport"
    ZIX = "Zhigansk Airport"
    ZIZ = "Zamzama"
    ZJG = "Jenpeg"
    ZJN = "Swan River"
    ZJT = "Tanjung Pelepas Port"
    ZKB = "Kasaba Bay"
    ZKE = "Kaschechewan"
    ZKG = "Kegaska"
    ZKL = "Steenkool"
    ZKM = "Sette Cama"
    ZKP = "Zyryanka Airport"
    ZLG = "El Gouera"
    ZLO = "Manzanillo Airport"
    ZLT = "La Tabatiere"
    ZLW = "Pasir Gudang Port"
    ZLX = "Zalingei Airport"
    ZMD = "Sena Madureira"
    ZMF = "Beverello Harbor"
    ZMH = "South Cariboo Regional Airport"
    ZMJ = "Mergellina Harbour"
    ZML = "Milwaukee General Mitchell"
    ZMM = "Zamora"
    ZMT = "Masset Airport"
    ZMY = "Harbour"
    ZNA = "Nanaimo Harbour"
    ZNC = "Nyac"
    ZND = "Zinder"
    ZNE = "Newman Airport"
    ZNG = "Negginan"
    ZNU = "Namu"
    ZNZ = "Zanzibar International Airport"
    ZOF = "Ocean Falls"
    ZOS = "Canal Bajo Airport"
    ZPB = "Sachigo Lake Airport"
    ZPC = "Pucon"
    ZPH = "Zephyrhills"
    ZPO = "Pine House"
    ZQF = "Fohren"
    ZQN = "Queenstown Airport"
    ZQS = "Queen Charlotte Island"
    ZQW = "Zweibruecken Airport"
    ZQZ = "Zhangjiakou Ningyuan Airport"
    ZRH = "Zurich Airport"
    ZRI = "Serui"
    ZRJ = "Round Lake Airport"
    ZRM = "Sarmi"
    ZSA = "San Salvador Airport"
    ZSE = "St Pierre dela Reunion"
    ZSJ = "Sandy Lake"
    ZSP = "St Paul"
    ZSS = "Sassandra"
    ZST = "Stewart"
    ZSW = "Seal Cove"
    ZTA = "Tureira"
    ZTB = "Tete-a-La Baleine"
    ZTH = "Zakinthos Airport"
    ZTM = "Shamattawa Airport"
    ZTR = "Zhitomir Airport"
    ZTS = "Tahsis"
    ZTU = "Zaqatala"
    ZUC = "Ignace"
    ZUD = "Ancud"
    ZUH = "Zhuhai Jinwan Airport"
    ZUL = "Zilfi"
    ZUM = "Churchill Falls"
    ZVA = "Miandrivazo"
    ZVG = "Springvale"
    ZVK = "Savannakhet"
    ZWA = "Andapa"
    ZWL = "Wollaston Lake"
    ZWR = "Kota Kinabalu Port"
    ZXT = "Heydar Aliyev"
    ZYD = "Lisbon TP"
    ZYF = "Faro TP"
    ZYI = "Zunyi Xinzhou Airport"
    ZYL = "Civil Airport"
    ZZE = "Zangilan International Airport"
    ZZN = "Nationaltheatret RailS"
    ZZO = "Zonalnoye"
    ZZU = "Mzuzu"
    ZZV = "Zanesville"
