# coding: utf-8

"""
    Prompt.io APIs

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class BulkActionsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def abort_bulk_action(self, bulk_action_id, **kwargs):  # noqa: E501
        """Abort a Bulk Action  # noqa: E501

        _in snippets: platform.api.bulkActions.abortBulkAction_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.abort_bulk_action(bulk_action_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bulk_action_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.abort_bulk_action_with_http_info(bulk_action_id, **kwargs)  # noqa: E501
        else:
            (data) = self.abort_bulk_action_with_http_info(bulk_action_id, **kwargs)  # noqa: E501
            return data

    def abort_bulk_action_with_http_info(self, bulk_action_id, **kwargs):  # noqa: E501
        """Abort a Bulk Action  # noqa: E501

        _in snippets: platform.api.bulkActions.abortBulkAction_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.abort_bulk_action_with_http_info(bulk_action_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bulk_action_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bulk_action_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method abort_bulk_action" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bulk_action_id' is set
        if ('bulk_action_id' not in params or
                params['bulk_action_id'] is None):
            raise ValueError("Missing the required parameter `bulk_action_id` when calling `abort_bulk_action`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bulk_action_id' in params:
            path_params['bulkActionId'] = params['bulk_action_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/bulk_actions/{bulkActionId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_bulk_action(self, **kwargs):  # noqa: E501
        """Creates a Bulk Action and starts it  # noqa: E501

        _in snippets: platform.api.bulkActions.addBulkAction_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_bulk_action(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddBulkActionModel body:
        :return: BulkActionModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_bulk_action_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.add_bulk_action_with_http_info(**kwargs)  # noqa: E501
            return data

    def add_bulk_action_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a Bulk Action and starts it  # noqa: E501

        _in snippets: platform.api.bulkActions.addBulkAction_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_bulk_action_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddBulkActionModel body:
        :return: BulkActionModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_bulk_action" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/bulk_actions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BulkActionModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def disable_variant(self, bulk_action_id, variant_id, **kwargs):  # noqa: E501
        """Disable a vairant if the BulkAction is using A/B testing  # noqa: E501

        _in snippets: platform.api.bulkActions.disableVariant_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.disable_variant(bulk_action_id, variant_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bulk_action_id: (required)
        :param int variant_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.disable_variant_with_http_info(bulk_action_id, variant_id, **kwargs)  # noqa: E501
        else:
            (data) = self.disable_variant_with_http_info(bulk_action_id, variant_id, **kwargs)  # noqa: E501
            return data

    def disable_variant_with_http_info(self, bulk_action_id, variant_id, **kwargs):  # noqa: E501
        """Disable a vairant if the BulkAction is using A/B testing  # noqa: E501

        _in snippets: platform.api.bulkActions.disableVariant_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.disable_variant_with_http_info(bulk_action_id, variant_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bulk_action_id: (required)
        :param int variant_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bulk_action_id', 'variant_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_variant" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bulk_action_id' is set
        if ('bulk_action_id' not in params or
                params['bulk_action_id'] is None):
            raise ValueError("Missing the required parameter `bulk_action_id` when calling `disable_variant`")  # noqa: E501
        # verify the required parameter 'variant_id' is set
        if ('variant_id' not in params or
                params['variant_id'] is None):
            raise ValueError("Missing the required parameter `variant_id` when calling `disable_variant`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bulk_action_id' in params:
            path_params['bulkActionId'] = params['bulk_action_id']  # noqa: E501
        if 'variant_id' in params:
            path_params['variantId'] = params['variant_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/bulk_actions/{bulkActionId}/variant/{variantId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bulk_action(self, bulk_action_id, **kwargs):  # noqa: E501
        """Gets a specific Bulk Action  # noqa: E501

        _in snippets: platform.api.bulkActions.getBulkAction_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bulk_action(bulk_action_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bulk_action_id: (required)
        :return: BulkActionModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_bulk_action_with_http_info(bulk_action_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_bulk_action_with_http_info(bulk_action_id, **kwargs)  # noqa: E501
            return data

    def get_bulk_action_with_http_info(self, bulk_action_id, **kwargs):  # noqa: E501
        """Gets a specific Bulk Action  # noqa: E501

        _in snippets: platform.api.bulkActions.getBulkAction_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bulk_action_with_http_info(bulk_action_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bulk_action_id: (required)
        :return: BulkActionModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bulk_action_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bulk_action" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bulk_action_id' is set
        if ('bulk_action_id' not in params or
                params['bulk_action_id'] is None):
            raise ValueError("Missing the required parameter `bulk_action_id` when calling `get_bulk_action`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bulk_action_id' in params:
            path_params['bulkActionId'] = params['bulk_action_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/bulk_actions/{bulkActionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BulkActionModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bulk_actions(self, **kwargs):  # noqa: E501
        """Gets all Bulk Actions  # noqa: E501

        _in snippets: platform.api.bulkActions.getBulkActions_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bulk_actions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int first:
        :param int max:
        :return: BulkActionModelPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_bulk_actions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_bulk_actions_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_bulk_actions_with_http_info(self, **kwargs):  # noqa: E501
        """Gets all Bulk Actions  # noqa: E501

        _in snippets: platform.api.bulkActions.getBulkActions_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bulk_actions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int first:
        :param int max:
        :return: BulkActionModelPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['first', 'max']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bulk_actions" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'first' in params:
            query_params.append(('first', params['first']))  # noqa: E501
        if 'max' in params:
            query_params.append(('max', params['max']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/bulk_actions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BulkActionModelPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_contacts_for_resolution(self, bulk_action_id, resolution, **kwargs):  # noqa: E501
        """Get a list of customers for a particular Resolution string for this Bulk Action  # noqa: E501

        _in snippets: platform.api.bulkActions.getContactsForResolution_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contacts_for_resolution(bulk_action_id, resolution, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bulk_action_id: (required)
        :param str resolution: (required)
        :return: ResolutionContactModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_contacts_for_resolution_with_http_info(bulk_action_id, resolution, **kwargs)  # noqa: E501
        else:
            (data) = self.get_contacts_for_resolution_with_http_info(bulk_action_id, resolution, **kwargs)  # noqa: E501
            return data

    def get_contacts_for_resolution_with_http_info(self, bulk_action_id, resolution, **kwargs):  # noqa: E501
        """Get a list of customers for a particular Resolution string for this Bulk Action  # noqa: E501

        _in snippets: platform.api.bulkActions.getContactsForResolution_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contacts_for_resolution_with_http_info(bulk_action_id, resolution, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bulk_action_id: (required)
        :param str resolution: (required)
        :return: ResolutionContactModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bulk_action_id', 'resolution']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contacts_for_resolution" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bulk_action_id' is set
        if ('bulk_action_id' not in params or
                params['bulk_action_id'] is None):
            raise ValueError("Missing the required parameter `bulk_action_id` when calling `get_contacts_for_resolution`")  # noqa: E501
        # verify the required parameter 'resolution' is set
        if ('resolution' not in params or
                params['resolution'] is None):
            raise ValueError("Missing the required parameter `resolution` when calling `get_contacts_for_resolution`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bulk_action_id' in params:
            path_params['bulkActionId'] = params['bulk_action_id']  # noqa: E501
        if 'resolution' in params:
            path_params['resolution'] = params['resolution']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/bulk_actions/{bulkActionId}/resolution/{resolution}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResolutionContactModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_resolution_counts(self, bulk_action_id, **kwargs):  # noqa: E501
        """Retrieves the counts for each resolution string for this Bulk Action  # noqa: E501

        _in snippets: platform.api.bulkActions.getResolutionCounts_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_resolution_counts(bulk_action_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bulk_action_id: (required)
        :param int first:
        :param int max:
        :return: ResolutionCountModelPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_resolution_counts_with_http_info(bulk_action_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_resolution_counts_with_http_info(bulk_action_id, **kwargs)  # noqa: E501
            return data

    def get_resolution_counts_with_http_info(self, bulk_action_id, **kwargs):  # noqa: E501
        """Retrieves the counts for each resolution string for this Bulk Action  # noqa: E501

        _in snippets: platform.api.bulkActions.getResolutionCounts_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_resolution_counts_with_http_info(bulk_action_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bulk_action_id: (required)
        :param int first:
        :param int max:
        :return: ResolutionCountModelPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bulk_action_id', 'first', 'max']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_resolution_counts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bulk_action_id' is set
        if ('bulk_action_id' not in params or
                params['bulk_action_id'] is None):
            raise ValueError("Missing the required parameter `bulk_action_id` when calling `get_resolution_counts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bulk_action_id' in params:
            path_params['bulkActionId'] = params['bulk_action_id']  # noqa: E501

        query_params = []
        if 'first' in params:
            query_params.append(('first', params['first']))  # noqa: E501
        if 'max' in params:
            query_params.append(('max', params['max']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/bulk_actions/{bulkActionId}/resolutionCounts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResolutionCountModelPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def perform_action(self, bulk_action_id, **kwargs):  # noqa: E501
        """Performs an action on the contacts or subset of contacts in the Bulk Action  # noqa: E501

        _in snippets: platform.api.bulkActions.performAction_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.perform_action(bulk_action_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bulk_action_id: (required)
        :param BulkActionPerformActionModel body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.perform_action_with_http_info(bulk_action_id, **kwargs)  # noqa: E501
        else:
            (data) = self.perform_action_with_http_info(bulk_action_id, **kwargs)  # noqa: E501
            return data

    def perform_action_with_http_info(self, bulk_action_id, **kwargs):  # noqa: E501
        """Performs an action on the contacts or subset of contacts in the Bulk Action  # noqa: E501

        _in snippets: platform.api.bulkActions.performAction_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.perform_action_with_http_info(bulk_action_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bulk_action_id: (required)
        :param BulkActionPerformActionModel body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bulk_action_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method perform_action" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bulk_action_id' is set
        if ('bulk_action_id' not in params or
                params['bulk_action_id'] is None):
            raise ValueError("Missing the required parameter `bulk_action_id` when calling `perform_action`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bulk_action_id' in params:
            path_params['bulkActionId'] = params['bulk_action_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/bulk_actions/{bulkActionId}/perform_action', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_bulk_resolution(self, bulk_action_id, customer_id, **kwargs):  # noqa: E501
        """Set a bulk action resolution string for a contact.  # noqa: E501

        _in snippets: platform.api.bulkActions.setBulkResolution_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_bulk_resolution(bulk_action_id, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bulk_action_id: (required)
        :param int customer_id: (required)
        :param str resolution:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_bulk_resolution_with_http_info(bulk_action_id, customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_bulk_resolution_with_http_info(bulk_action_id, customer_id, **kwargs)  # noqa: E501
            return data

    def set_bulk_resolution_with_http_info(self, bulk_action_id, customer_id, **kwargs):  # noqa: E501
        """Set a bulk action resolution string for a contact.  # noqa: E501

        _in snippets: platform.api.bulkActions.setBulkResolution_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_bulk_resolution_with_http_info(bulk_action_id, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bulk_action_id: (required)
        :param int customer_id: (required)
        :param str resolution:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bulk_action_id', 'customer_id', 'resolution']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_bulk_resolution" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bulk_action_id' is set
        if ('bulk_action_id' not in params or
                params['bulk_action_id'] is None):
            raise ValueError("Missing the required parameter `bulk_action_id` when calling `set_bulk_resolution`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `set_bulk_resolution`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bulk_action_id' in params:
            path_params['bulkActionId'] = params['bulk_action_id']  # noqa: E501
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []
        if 'resolution' in params:
            query_params.append(('resolution', params['resolution']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/bulk_actions/{bulkActionId}/contacts/{customerId}/resolution', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def unlock_bulk_action_contact(self, bulk_action_id, bulk_action_contact_id, **kwargs):  # noqa: E501
        """Confirms a Bulk Action that is set to require manual sending  # noqa: E501

        _in snippets: platform.api.bulkActions.unlockBulkActionContact_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unlock_bulk_action_contact(bulk_action_id, bulk_action_contact_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bulk_action_id: (required)
        :param int bulk_action_contact_id: (required)
        :param BulkActionConfirmationDetailsModel body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.unlock_bulk_action_contact_with_http_info(bulk_action_id, bulk_action_contact_id, **kwargs)  # noqa: E501
        else:
            (data) = self.unlock_bulk_action_contact_with_http_info(bulk_action_id, bulk_action_contact_id, **kwargs)  # noqa: E501
            return data

    def unlock_bulk_action_contact_with_http_info(self, bulk_action_id, bulk_action_contact_id, **kwargs):  # noqa: E501
        """Confirms a Bulk Action that is set to require manual sending  # noqa: E501

        _in snippets: platform.api.bulkActions.unlockBulkActionContact_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unlock_bulk_action_contact_with_http_info(bulk_action_id, bulk_action_contact_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int bulk_action_id: (required)
        :param int bulk_action_contact_id: (required)
        :param BulkActionConfirmationDetailsModel body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bulk_action_id', 'bulk_action_contact_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unlock_bulk_action_contact" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bulk_action_id' is set
        if ('bulk_action_id' not in params or
                params['bulk_action_id'] is None):
            raise ValueError("Missing the required parameter `bulk_action_id` when calling `unlock_bulk_action_contact`")  # noqa: E501
        # verify the required parameter 'bulk_action_contact_id' is set
        if ('bulk_action_contact_id' not in params or
                params['bulk_action_contact_id'] is None):
            raise ValueError("Missing the required parameter `bulk_action_contact_id` when calling `unlock_bulk_action_contact`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bulk_action_id' in params:
            path_params['bulkActionId'] = params['bulk_action_id']  # noqa: E501
        if 'bulk_action_contact_id' in params:
            path_params['bulkActionContactId'] = params['bulk_action_contact_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/bulk_actions/confirm/{bulkActionId}/{bulkActionContactId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
