# coding: utf-8

"""
    Prompt.io APIs

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class CustomersApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_customer(self, **kwargs):  # noqa: E501
        """Creates a customer  # noqa: E501

        _in snippets: platform.api.customers.addCustomer_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_customer(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddCustomerModel body:
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_customer_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.add_customer_with_http_info(**kwargs)  # noqa: E501
            return data

    def add_customer_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a customer  # noqa: E501

        _in snippets: platform.api.customers.addCustomer_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_customer_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddCustomerModel body:
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_customer" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/customers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_customer_tags(self, customer_id, **kwargs):  # noqa: E501
        """Adds tags to a customer  # noqa: E501

        _in snippets: platform.api.customers.addCustomerTags_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_customer_tags(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :param list[TagModel] body:
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_customer_tags_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_customer_tags_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def add_customer_tags_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Adds tags to a customer  # noqa: E501

        _in snippets: platform.api.customers.addCustomerTags_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_customer_tags_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :param list[TagModel] body:
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_customer_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `add_customer_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/tags', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_identity(self, customer_id, **kwargs):  # noqa: E501
        """Adds an identity to a customer  # noqa: E501

        _in snippets: platform.api.customers.addIdentity_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_identity(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :param CustomerIdentityModel body:
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_identity_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_identity_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def add_identity_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Adds an identity to a customer  # noqa: E501

        _in snippets: platform.api.customers.addIdentity_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_identity_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :param CustomerIdentityModel body:
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_identity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `add_identity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/identities', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_or_update_customer(self, **kwargs):  # noqa: E501
        """Creates or updates a customer  # noqa: E501

        _in snippets: platform.api.customers.addOrUpdateCustomer_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_or_update_customer(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddCustomerModel body:
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_or_update_customer_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.add_or_update_customer_with_http_info(**kwargs)  # noqa: E501
            return data

    def add_or_update_customer_with_http_info(self, **kwargs):  # noqa: E501
        """Creates or updates a customer  # noqa: E501

        _in snippets: platform.api.customers.addOrUpdateCustomer_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_or_update_customer_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddCustomerModel body:
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_or_update_customer" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/customers', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_instant_app(self, customer_id, **kwargs):  # noqa: E501
        """Creates an Instant App for the customer.  # noqa: E501

        _in snippets: platform.api.customers.createInstantApp_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_instant_app(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :param InstantAppModel body:
        :return: InstantAppModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_instant_app_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_instant_app_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def create_instant_app_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Creates an Instant App for the customer.  # noqa: E501

        _in snippets: platform.api.customers.createInstantApp_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_instant_app_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :param InstantAppModel body:
        :return: InstantAppModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_instant_app" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `create_instant_app`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/instant_apps', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstantAppModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_identity(self, customer_id, **kwargs):  # noqa: E501
        """Deletes an identity from a customer  # noqa: E501

        _in snippets: platform.api.customers.deleteIdentity_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_identity(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :param CustomerIdentityModel body:
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_identity_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_identity_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def delete_identity_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Deletes an identity from a customer  # noqa: E501

        _in snippets: platform.api.customers.deleteIdentity_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_identity_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :param CustomerIdentityModel body:
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_identity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `delete_identity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/identities', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer(self, customer_id, **kwargs):  # noqa: E501
        """Gets the details for a specific customer  # noqa: E501

        _in snippets: platform.api.customers.getCustomer_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def get_customer_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Gets the details for a specific customer  # noqa: E501

        _in snippets: platform.api.customers.getCustomer_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_customer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_by_channel(self, type, key, **kwargs):  # noqa: E501
        """Gets the details for a specific customer based on an the channel type and channel key  # noqa: E501

        _in snippets: platform.api.customers.getCustomerByChannel_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_by_channel(type, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: (required)
        :param str key: (required)
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_by_channel_with_http_info(type, key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_by_channel_with_http_info(type, key, **kwargs)  # noqa: E501
            return data

    def get_customer_by_channel_with_http_info(self, type, key, **kwargs):  # noqa: E501
        """Gets the details for a specific customer based on an the channel type and channel key  # noqa: E501

        _in snippets: platform.api.customers.getCustomerByChannel_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_by_channel_with_http_info(type, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: (required)
        :param str key: (required)
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_by_channel" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in params or
                params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `get_customer_by_channel`")  # noqa: E501
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `get_customer_by_channel`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in params:
            path_params['type'] = params['type']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/customers/channel_types/{type}/channel_keys/{key}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_by_identity(self, type, key, **kwargs):  # noqa: E501
        """Gets the details for a specific customer based on an identity  # noqa: E501

        _in snippets: platform.api.customers.getCustomerByIdentity_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_by_identity(type, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: (required)
        :param str key: (required)
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_by_identity_with_http_info(type, key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_by_identity_with_http_info(type, key, **kwargs)  # noqa: E501
            return data

    def get_customer_by_identity_with_http_info(self, type, key, **kwargs):  # noqa: E501
        """Gets the details for a specific customer based on an identity  # noqa: E501

        _in snippets: platform.api.customers.getCustomerByIdentity_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_by_identity_with_http_info(type, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: (required)
        :param str key: (required)
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_by_identity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in params or
                params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `get_customer_by_identity`")  # noqa: E501
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `get_customer_by_identity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in params:
            path_params['type'] = params['type']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/customers/identity_types/{type}/identity_keys/{key}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_tags(self, customer_id, **kwargs):  # noqa: E501
        """Gets the tags for a specific customer  # noqa: E501

        _in snippets: platform.api.customers.getCustomerTags_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_tags(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :return: list[TagModel]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_tags_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_tags_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def get_customer_tags_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Gets the tags for a specific customer  # noqa: E501

        _in snippets: platform.api.customers.getCustomerTags_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_tags_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :return: list[TagModel]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_customer_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/tags', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TagModel]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customers(self, **kwargs):  # noqa: E501
        """Gets all the customers in the org ordered by their create date  # noqa: E501

        _in snippets: platform.api.customers.getCustomers_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int first:
        :param int max:
        :return: CustomerModelPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_customers_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_customers_with_http_info(self, **kwargs):  # noqa: E501
        """Gets all the customers in the org ordered by their create date  # noqa: E501

        _in snippets: platform.api.customers.getCustomers_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int first:
        :param int max:
        :return: CustomerModelPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['first', 'max']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'first' in params:
            query_params.append(('first', params['first']))  # noqa: E501
        if 'max' in params:
            query_params.append(('max', params['max']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/customers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerModelPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instant_apps(self, customer_id, **kwargs):  # noqa: E501
        """Gets all the Instant Apps for the customer  # noqa: E501

        _in snippets: platform.api.customers.getInstantApps_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instant_apps(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :param int first:
        :param int max:
        :param bool desc:
        :return: InstantAppModelPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instant_apps_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instant_apps_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def get_instant_apps_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Gets all the Instant Apps for the customer  # noqa: E501

        _in snippets: platform.api.customers.getInstantApps_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instant_apps_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :param int first:
        :param int max:
        :param bool desc:
        :return: InstantAppModelPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'first', 'max', 'desc']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instant_apps" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_instant_apps`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []
        if 'first' in params:
            query_params.append(('first', params['first']))  # noqa: E501
        if 'max' in params:
            query_params.append(('max', params['max']))  # noqa: E501
        if 'desc' in params:
            query_params.append(('desc', params['desc']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/instant_apps', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InstantAppModelPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_tag(self, customer_id, tag_name, **kwargs):  # noqa: E501
        """Removes a tag from a customer  # noqa: E501

        _in snippets: platform.api.customers.removeTag_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_tag(customer_id, tag_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :param str tag_name: (required)
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_tag_with_http_info(customer_id, tag_name, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_tag_with_http_info(customer_id, tag_name, **kwargs)  # noqa: E501
            return data

    def remove_tag_with_http_info(self, customer_id, tag_name, **kwargs):  # noqa: E501
        """Removes a tag from a customer  # noqa: E501

        _in snippets: platform.api.customers.removeTag_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_tag_with_http_info(customer_id, tag_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :param str tag_name: (required)
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'tag_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_tag" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `remove_tag`")  # noqa: E501
        # verify the required parameter 'tag_name' is set
        if ('tag_name' not in params or
                params['tag_name'] is None):
            raise ValueError("Missing the required parameter `tag_name` when calling `remove_tag`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'tag_name' in params:
            path_params['tagName'] = params['tag_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/tags/{tagName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_tags(self, customer_id, **kwargs):  # noqa: E501
        """Removes all tags from a customer  # noqa: E501

        _in snippets: platform.api.customers.removeTags_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_tags(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_tags_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_tags_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def remove_tags_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Removes all tags from a customer  # noqa: E501

        _in snippets: platform.api.customers.removeTags_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_tags_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `remove_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/tags', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_customer(self, customer_id, **kwargs):  # noqa: E501
        """Updates a customer  # noqa: E501

        _in snippets: platform.api.customers.updateCustomer_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :param UpdateCustomerRequestModel body:
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_customer_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_customer_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def update_customer_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Updates a customer  # noqa: E501

        _in snippets: platform.api.customers.updateCustomer_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :param UpdateCustomerRequestModel body:
        :return: CustomerModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_customer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `update_customer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_customer_location(self, customer_id, **kwargs):  # noqa: E501
        """Updates a customers location  # noqa: E501

        _in snippets: platform.api.customers.updateCustomerLocation_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_location(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :param LocationModel body:
        :return: UserLocationModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_customer_location_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_customer_location_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def update_customer_location_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Updates a customers location  # noqa: E501

        _in snippets: platform.api.customers.updateCustomerLocation_  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_location_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int customer_id: (required)
        :param LocationModel body:
        :return: UserLocationModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_customer_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `update_customer_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['org_token']  # noqa: E501

        return self.api_client.call_api(
            '/customers/{customerId}/location', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserLocationModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
