# coding: utf-8

"""
    FINBOURNE Workflows API

    FINBOURNE Technology  # noqa: E501

    The version of the OpenAPI document: 0.1.39
    Contact: info@finbourne.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from lusid_workflows.configuration import Configuration


class TransitWorkflowRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
      required_map (dict): The key is attribute name
                           and the value is whether it is 'required' or 'optional'.
    """
    openapi_types = {
        'action': 'str',
        'context': 'dict(str, str)'
    }

    attribute_map = {
        'action': 'action',
        'context': 'context'
    }

    required_map = {
        'action': 'required',
        'context': 'optional'
    }

    def __init__(self, action=None, context=None, local_vars_configuration=None):  # noqa: E501
        """TransitWorkflowRequest - a model defined in OpenAPI"
        
        :param action:  Action to be passed to the workflow. A workflow may take a decision based on the action. For example,  IssueWorkflow may wait for a Resolve action to close the workflow or UnAssign action to go back to previous state/step. (required)
        :type action: str
        :param context:  Any data to be added to the existing ExecutionContext of the workflow
        :type context: dict(str, str)

        """  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._action = None
        self._context = None
        self.discriminator = None

        self.action = action
        self.context = context

    @property
    def action(self):
        """Gets the action of this TransitWorkflowRequest.  # noqa: E501

        Action to be passed to the workflow. A workflow may take a decision based on the action. For example,  IssueWorkflow may wait for a Resolve action to close the workflow or UnAssign action to go back to previous state/step.  # noqa: E501

        :return: The action of this TransitWorkflowRequest.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this TransitWorkflowRequest.

        Action to be passed to the workflow. A workflow may take a decision based on the action. For example,  IssueWorkflow may wait for a Resolve action to close the workflow or UnAssign action to go back to previous state/step.  # noqa: E501

        :param action: The action of this TransitWorkflowRequest.  # noqa: E501
        :type action: str
        """
        if self.local_vars_configuration.client_side_validation and action is None:  # noqa: E501
            raise ValueError("Invalid value for `action`, must not be `None`")  # noqa: E501

        self._action = action

    @property
    def context(self):
        """Gets the context of this TransitWorkflowRequest.  # noqa: E501

        Any data to be added to the existing ExecutionContext of the workflow  # noqa: E501

        :return: The context of this TransitWorkflowRequest.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._context

    @context.setter
    def context(self, context):
        """Sets the context of this TransitWorkflowRequest.

        Any data to be added to the existing ExecutionContext of the workflow  # noqa: E501

        :param context: The context of this TransitWorkflowRequest.  # noqa: E501
        :type context: dict(str, str)
        """

        self._context = context

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TransitWorkflowRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TransitWorkflowRequest):
            return True

        return self.to_dict() != other.to_dict()
