"""
    (c) 2019 Momsen Reincke <mail@momsenreincke.de> 
    
    this python file defines the five dictionaries primer_IGHV, primer_IGHJ, primer_IGLV, primer_IGKV, 
    primer_IGKJ. they contain the primer corresponding to certain IgG genes. 
    
    It is deprecated, but will be kept for backwards compatibility.
    
    Example:
    The 5' primer corresponding to IGH1-2*02 can be found in the dictionary primer_IGHV under the key '1-2*02'
    (the primer has the name 'H5 2/3-1'). Analogously, the 3' primer corresponding to IGK1-9*01 can be found 
    in the dictionary primer_IGKJ under the key '1-9*01' (the primer has the name 'K5 3-2')
"""

primer_IGHV = {
    # all primers w H5 2/3-1
    "1-2*02": "H5 2/3-1",
    "1-2*04": "H5 2/3-1",
    "1-8*01": "H5 2/3-1",
    "1-46*01": "H5 2/3-1",
    "1-69*01": "H5 2/3-1",
    "1-69*06": "H5 2/3-1",
    "1-69*09": "H5 2/3-1",
    "1-18*01": "H5 3-7",
    "3-11*01": "H5 3-10",
    "1-69*10": "H5 3-8",
    # all primers w 'H5 2/3-2'
    "5-51*01": "H5 2/3-2",
    "5-51*02": "H5 2/3-2",
    "5-51*03": "H5 2/3-2",
    "5-51*04": "H5 2/3-2",
    # all primers w 'H5 2/3-3'
    "3-7*01": "H5 2/3-3",
    "3-7*03": "H5 2/3-3",
    "3-13*01": "H5 2/3-3",
    "3-15*01": "H5 2/3-3",
    "3-15*07": "H5 2/3-3",
    "3-20*01": "H5 2/3-3",
    "3-21*01": "H5 2/3-3",
    "3-48*01": "H5 2/3-3",
    "3-48*03": "H5 2/3-3",
    "3-49*03": "H5 2/3-3",
    "3-49*04": "H5 2/3-3",
    "3-53*01": "H5 2/3-3",
    "3-53*04": "H5 2/3-3",
    "3-64*01": "H5 2/3-3",
    "3-72*01": "H5 2/3-3",
    "3-73*02": "H5 2/3-3",
    "3-74*01": "H5 2/3-3",
    "3-74*03": "H5 2/3-3",
    # all primers w H5 3-9
    "3-9*01": "H5 3-9",
    "3-23*04": "H5 3-9",
    "3-43*02": "H5 3-9",
    # all primers w H5 2/3-4
    "3-23*01": "H5 2/3-4",
    "3-23*05": "H5 2/3-4",
    # all primers w H5 3-10
    "3-11*01": "H5 3-10",
    "3-30*01": "H5 3-10",
    "3-30*03": "H5 3-10",
    "3-30*04": "H5 3-10",
    "3-30*07": "H5 3-10",
    "3-30*18": "H5 3-10",
    "3-30-3*01": "H5 3-10",
    "3-33*01": "H5 3-10",
    # all primers w H5 2/3-5
    "4-4*02": "H5 2/3-5",
    "4-4*07": "H5 2/3-5",
    "4-30-4*01": "H5 2/3-5",
    "4-31*03": "H5 2/3-5",
    "4-38-2*02": "H5 2/3-5",
    "4-59*01": "H5 2/3-5",
    "4-59*08": "H5 2/3-5",
    # H5 2/3-6
    "4-34*01": "H5 2/3-6",
    # H5 3-11
    "4-30-2*01": "H5 3-11",
    "4-39*01": "H5 3-11",
    "4-39*02": "H5 3-11",
    "4-39*07": "H5 3-11",
    # H5 3-12	missing
    # misc
    "7-4-1*02": "H5 3-13",
    "5-10-1*03": "H5 3-14",
    "1-3*01": "H5 3-15",
    "1-69*11": "H5 3-16",
    ###Recheck w Jakob:
    "3-48*04": "H5 2/3-3",  # zeile 134, 88FI99_D11
    "3-9*03": "H5 3-9",  # zeile 172
    "7-4-1*04": "H5 3-13",  # zeile 226
    "N/A": "",
}

primer_IGHJ = {
    # H3 3-1	all IGHJ genes of IGHJ 1, 2, 4 and 5 gene family
    "1*01": "H3 3-1",
    "1*02": "H3 3-1",
    "2*01": "H3 3-1",
    "2*02": "H3 3-1",
    "4*01": "H3 3-1",
    "4*02": "H3 3-1",
    "4*03": "H3 3-1",
    "5*01": "H3 3-1",
    "5*02": "H3 3-1",
    # H3 3-2	all IGHJ genes of IGHJ 3 gene family
    "3*01": "H3 3-2",
    "3*02": "H3 3-2",
    # H3 3-3	all IGHJ genes of IGHJ 6 gene family
    "6*01": "H3 3-3",
    "6*02": "H3 3-3",
    "6*03": "H3 3-3",
    "6*04": "H3 3-3",
    "N/A": "",
}

primer_IGKV = {
    # K5 3-1	1-5*03, 1-12*01, 1-16*01/02, 1-17*01/02/03, 1-27*01, 1-33*01, 1-39*01, 1D-12*01, 1D-33*01
    "1-5*03": "K5 3-1",
    "1-12*01": "K5 3-1",
    "1-16*01": "K5 3-1",
    "1-16*02": "K5 3-1",
    "1-17*01": "K5 3-1",
    "1-17*02": "K5 3-1",
    "1-17*03": "K5 3-1",
    "1-27*01": "K5 3-1",
    "1-33*01": "K5 3-1",
    "1-39*01": "K5 3-1",
    ":1D-12*01": "K5 3-1",
    "1D-33*01": "K5 3-1",
    # K5 3-2	1-9*01
    "1-9*01": "K5 3-2",
    # K5 3-2	1-9*01
    "1-9*01": "K5 3-2",
    # K5 3-3	1-8*01
    "1-8*01": "K5 3-3",
    # K5 3-4	2-24*01, 2-29*02
    "2-24*01": "K5 3-4",
    "2-29*02": "K5 3-4",
    # K5 3-5	2-28*01
    "2-28*01": "K5 3-5",
    # K5 3-6	2-30*01/02
    "2-30*01": "K5 3-6",
    "2-30*02": "K5 3-6",
    "3-11*01": "K5 3-7",
    "3-15*01": "K5 3-8",
    "3-20*01": "K5 3-9",
    "4-1*01": "K5 3-10",
    "N/A": "",
}

primer_IGKJ = {
    # all IGKJ genes of IGKJ 1 and 4 gene family
    "1*01": "K3 3-1",
    "4*01": "K3 3-1",
    # K3 3-2	all IGKJ genes of IGKJ 2 gene family
    "2*01": "K3 3-2",
    "2*02": "K3 3-2",
    # K3 3-2	all IGKJ genes of IGKJ 2 gene family
    "3*01": "K3 3-3",
    # K3 3-4	all IGKJ genes of IGKJ 5 gene family
    "5*01": "K3 3-4",
    "N/A": "",
}

primer_IGLV = {
    # L5 2/3-1	all IGLV genes of IGLV 1 gene family
    "1-40*01": "L5 2/3-1",
    "1-47*01": "L5 2/3-1",
    "1-47*02": "L5 2/3-1",
    "1-44*01": "L5 2/3-1",
    "1-51*01": "L5 2/3-1",
    # L5 2/3-2	all IGLV genes of IGLV 2 gene family
    "2-11*01": "L5 2/3-2",
    "2-14*01": "L5 2/3-2",
    "2-8*01": "L5 2/3-2",
    "2-23*01": "L5 2/3-2",
    "2-14*01": "L5 2/3-2",
    "2-23*02": "L5 2/3-2",
    "2-14*03": "Anfang deletiert - kein Primer",
    # L5 2/3-4	all IGLV genes of IGLV 4 and 5 gene family and 9-49*01/03
    "4-69*01": "L5 2/3-4",
    "9-49*01": "L5 2/3-4",
    "9-49*03": "L5 2/3-4",
    "5-52*01": "L5 2/3-4",
    # L5 2/3-3	all IGLV genes of IGLV 3 gene family
    "3-1*01": "L5 2/3-3",
    "3-9*01": "L5 2/3-3",
    "3-21*01": "L5 2/3-3",
    "3-21*02": "L5 2/3-3",
    "3-25*03": "L5 2/3-3",
    # L5 2/3-5	all IGLV genes of IGLV 6 gene family
    "6-57*01": "L5 2/3-5",
    # L5 2/3-6	all IGLV genes of IGLV 7 and 8 gene family
    "7-46*01": "L5 2/3-6",
}
