import { CfnCondition } from './cfn-condition';
import { CfnRefElement } from './cfn-element';
import { CfnCreationPolicy, CfnDeletionPolicy, CfnUpdatePolicy } from './cfn-resource-policy';
import { Construct, IConstruct } from './construct';
import { Reference } from './reference';
import { RemovalPolicy, RemovalPolicyOptions } from './removal-policy';
export interface CfnResourceProps {
    /**
     * CloudFormation resource type (e.g. `AWS::S3::Bucket`).
     */
    readonly type: string;
    /**
     * Resource properties.
     *
     * @default - No resource properties.
     */
    readonly properties?: {
        [name: string]: any;
    };
}
/**
 * Represents a CloudFormation resource.
 */
export declare class CfnResource extends CfnRefElement {
    /**
     * Check whether the given construct is a CfnResource
     */
    static isCfnResource(construct: IConstruct): construct is CfnResource;
    /**
     * Options for this resource, such as condition, update policy etc.
     */
    readonly cfnOptions: ICfnResourceOptions;
    /**
     * AWS resource type.
     */
    readonly cfnResourceType: string;
    /**
     * An object to be merged on top of the entire resource definition.
     */
    private readonly rawOverrides;
    /**
     * Logical IDs of dependencies.
     *
     * Is filled during prepare().
     */
    private readonly dependsOn;
    /**
     * Creates a resource construct.
     * @param cfnResourceType The CloudFormation type of this resource (e.g. AWS::DynamoDB::Table)
     */
    constructor(scope: Construct, id: string, props: CfnResourceProps);
    /**
     * Sets the deletion policy of the resource based on the removal policy specified.
     */
    applyRemovalPolicy(policy: RemovalPolicy | undefined, options?: RemovalPolicyOptions): void;
    /**
     * Returns a token for an runtime attribute of this resource.
     * Ideally, use generated attribute accessors (e.g. `resource.arn`), but this can be used for future compatibility
     * in case there is no generated attribute.
     * @param attributeName The name of the attribute.
     */
    getAtt(attributeName: string): Reference;
    /**
     * Adds an override to the synthesized CloudFormation resource. To add a
     * property override, either use `addPropertyOverride` or prefix `path` with
     * "Properties." (i.e. `Properties.TopicName`).
     *
     * If the override is nested, separate each nested level using a dot (.) in the path parameter.
     * If there is an array as part of the nesting, specify the index in the path.
     *
     * For example,
     * ```typescript
     * addOverride('Properties.GlobalSecondaryIndexes.0.Projection.NonKeyAttributes', ['myattribute'])
     * addOverride('Properties.GlobalSecondaryIndexes.1.ProjectionType', 'INCLUDE')
     * ```
     * would add the overrides
     * ```json
     * "Properties": {
     *   "GlobalSecondaryIndexes": [
     *     {
     *       "Projection": {
     *         "NonKeyAttributes": [ "myattribute" ]
     *         ...
     *       }
     *       ...
     *     },
     *     {
     *       "ProjectionType": "INCLUDE"
     *       ...
     *     },
     *   ]
     *   ...
     * }
     * ```
     *
     * @param path - The path of the property, you can use dot notation to
     *        override values in complex types. Any intermdediate keys
     *        will be created as needed.
     * @param value - The value. Could be primitive or complex.
     */
    addOverride(path: string, value: any): void;
    /**
     * Syntactic sugar for `addOverride(path, undefined)`.
     * @param path The path of the value to delete
     */
    addDeletionOverride(path: string): void;
    /**
     * Adds an override to a resource property.
     *
     * Syntactic sugar for `addOverride("Properties.<...>", value)`.
     *
     * @param propertyPath The path of the property
     * @param value The value
     */
    addPropertyOverride(propertyPath: string, value: any): void;
    /**
     * Adds an override that deletes the value of a property from the resource definition.
     * @param propertyPath The path to the property.
     */
    addPropertyDeletionOverride(propertyPath: string): void;
    /**
     * Indicates that this resource depends on another resource and cannot be
     * provisioned unless the other resource has been successfully provisioned.
     *
     * This can be used for resources across stacks (or nested stack) boundaries
     * and the dependency will automatically be transferred to the relevant scope.
     */
    addDependsOn(target: CfnResource): void;
    /**
     * @returns a string representation of this resource
     */
    toString(): string;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
    /**
     * Return properties modified after initiation
     *
     * Resources that expose mutable properties should override this function to
     * collect and return the properties object for this resource.
     */
    protected get updatedProperites(): {
        [key: string]: any;
    };
    protected validateProperties(_properties: any): void;
}
export declare enum TagType {
    STANDARD = "StandardTag",
    AUTOSCALING_GROUP = "AutoScalingGroupTag",
    MAP = "StringToStringMap",
    KEY_VALUE = "KeyValue",
    NOT_TAGGABLE = "NotTaggable"
}
export interface ICfnResourceOptions {
    /**
     * A condition to associate with this resource. This means that only if the condition evaluates to 'true' when the stack
     * is deployed, the resource will be included. This is provided to allow CDK projects to produce legacy templates, but noramlly
     * there is no need to use it in CDK projects.
     */
    condition?: CfnCondition;
    /**
     * Associate the CreationPolicy attribute with a resource to prevent its status from reaching create complete until
     * AWS CloudFormation receives a specified number of success signals or the timeout period is exceeded. To signal a
     * resource, you can use the cfn-signal helper script or SignalResource API. AWS CloudFormation publishes valid signals
     * to the stack events so that you track the number of signals sent.
     */
    creationPolicy?: CfnCreationPolicy;
    /**
     * With the DeletionPolicy attribute you can preserve or (in some cases) backup a resource when its stack is deleted.
     * You specify a DeletionPolicy attribute for each resource that you want to control. If a resource has no DeletionPolicy
     * attribute, AWS CloudFormation deletes the resource by default. Note that this capability also applies to update operations
     * that lead to resources being removed.
     */
    deletionPolicy?: CfnDeletionPolicy;
    /**
     * Use the UpdatePolicy attribute to specify how AWS CloudFormation handles updates to the AWS::AutoScaling::AutoScalingGroup
     * resource. AWS CloudFormation invokes one of three update policies depending on the type of change you make or whether a
     * scheduled action is associated with the Auto Scaling group.
     */
    updatePolicy?: CfnUpdatePolicy;
    /**
     * Use the UpdateReplacePolicy attribute to retain or (in some cases) backup the existing physical instance of a resource
     * when it is replaced during a stack update operation.
     */
    updateReplacePolicy?: CfnDeletionPolicy;
    /**
     * Metadata associated with the CloudFormation resource. This is not the same as the construct metadata which can be added
     * using construct.addMetadata(), but would not appear in the CloudFormation template automatically.
     */
    metadata?: {
        [key: string]: any;
    };
}
