"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.poll = void 0;
function poll(fn, timeout = 2000, interval = 100) {
    const endTime = Number(new Date()) + timeout;
    const checkCondition = function (resolve, reject) {
        // If the condition is met, we're done! 
        var result = fn();
        if (result) {
            resolve(result);
        }
        // If the condition isn't met but the timeout hasn't elapsed, go again
        else if (Number(new Date()) < endTime) {
            setTimeout(checkCondition, interval, resolve, reject);
        }
        // Didn't match and too much time, reject!
        else {
            reject(new Error('timed out for ' + fn + ': ' + arguments));
        }
    };
    return new Promise(checkCondition);
}
exports.poll = poll;
//# sourceMappingURL=poll.js.map