"use strict";
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTestModel = exports.DummyManager = exports.MockComm = void 0;
const widgets = __importStar(require("@jupyter-widgets/base"));
let numComms = 0;
class MockComm {
    constructor() {
        this.target_name = 'dummy';
        this._on_msg = null;
        this._on_close = null;
        this.comm_id = `mock-comm-id-${numComms}`;
        numComms += 1;
    }
    on_close(fn) {
        this._on_close = fn;
    }
    on_msg(fn) {
        this._on_msg = fn;
    }
    _process_msg(msg) {
        if (this._on_msg) {
            return this._on_msg(msg);
        }
        else {
            return Promise.resolve();
        }
    }
    close() {
        if (this._on_close) {
            this._on_close();
        }
        return 'dummy';
    }
    send() {
        return 'dummy';
    }
    open() {
        return 'dummy';
    }
}
exports.MockComm = MockComm;
class DummyManager extends widgets.ManagerBase {
    constructor() {
        super();
        this.testClasses = {};
        this.el = window.document.createElement('div');
    }
    display_view(msg, view, options) {
        // TODO: make this a spy
        // TODO: return an html element
        return Promise.resolve(view).then(view => {
            this.el.appendChild(view.el);
            view.on('remove', () => console.log('view removed', view));
            return view.el;
        });
    }
    loadClass(className, moduleName, moduleVersion) {
        if (moduleName === '@jupyter-widgets/base') {
            if (widgets[className]) {
                return Promise.resolve(widgets[className]);
            }
            else {
                return Promise.reject(`Cannot find class ${className}`);
            }
        }
        else if (moduleName === 'jupyter-datawidgets') {
            if (this.testClasses[className]) {
                return Promise.resolve(this.testClasses[className]);
            }
            else {
                return Promise.reject(`Cannot find class ${className}`);
            }
        }
        else {
            return Promise.reject(`Cannot find module ${moduleName}`);
        }
    }
    _get_comm_info() {
        return Promise.resolve({});
    }
    _create_comm() {
        return Promise.resolve(new MockComm());
    }
}
exports.DummyManager = DummyManager;
function createTestModel(constructor, attributes) {
    let id = widgets.uuid();
    let widget_manager = new DummyManager();
    let modelOptions = {
        widget_manager: widget_manager,
        model_id: id,
    };
    return new constructor(attributes, modelOptions);
}
exports.createTestModel = createTestModel;
//# sourceMappingURL=createTestModel.js.map