"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
/**
 * Use a CloudFront Distribution as an alias record target.
 *
 * @stability stable
 */
class CloudFrontTarget {
    /**
     * @stability stable
     */
    constructor(distribution) {
        this.distribution = distribution;
    }
    /**
     * Get the hosted zone id for the current scope.
     *
     * @param scope - scope in which this resource is defined.
     * @stability stable
     */
    static getHostedZoneId(scope) {
        var _b;
        const mappingName = 'AWSCloudFrontPartitionHostedZoneIdMap';
        const scopeStack = core_1.Stack.of(scope);
        let mapping = (_b = scopeStack.node.tryFindChild(mappingName)) !== null && _b !== void 0 ? _b : new core_1.CfnMapping(scopeStack, mappingName, {
            mapping: {
                ['aws']: {
                    zoneId: 'Z2FDTNDATAQYW2',
                },
                ['aws-cn']: {
                    zoneId: 'Z3RFFRIM2A3IF5',
                },
            },
        });
        return mapping.findInMap(core_1.Aws.PARTITION, 'zoneId');
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record) {
        return {
            hostedZoneId: CloudFrontTarget.getHostedZoneId(this.distribution),
            dnsName: this.distribution.domainName,
        };
    }
}
exports.CloudFrontTarget = CloudFrontTarget;
_a = JSII_RTTI_SYMBOL_1;
CloudFrontTarget[_a] = { fqn: "@aws-cdk/aws-route53-targets.CloudFrontTarget", version: "1.91.0" };
/**
 * The hosted zone Id if using an alias record in Route53.
 *
 * This value never changes.
 *
 * @stability stable
 */
CloudFrontTarget.CLOUDFRONT_ZONE_ID = 'Z2FDTNDATAQYW2';
//# sourceMappingURL=data:application/json;base64,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