# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.  # noqa: E501

    The version of the OpenAPI document: 1.12.21
    Contact: info@songtradr.com
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from songtradr_api_client_python import schemas  # noqa: F401


class FilesSummaryDTO(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Summary of content of files
    """


    class MetaOapg:
        required = {
            "totalFiles",
        }
        
        class properties:
            totalFiles = schemas.Int32Schema
            
            
            class fileDetailsSummary(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['FieldSummaryDTO']:
                        return FieldSummaryDTO
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple['FieldSummaryDTO'], typing.List['FieldSummaryDTO']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'fileDetailsSummary':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'FieldSummaryDTO':
                    return super().__getitem__(i)
            
            
            class genreSummary(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['GenresSummaryDTO']:
                        return GenresSummaryDTO
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple['GenresSummaryDTO'], typing.List['GenresSummaryDTO']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'genreSummary':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'GenresSummaryDTO':
                    return super().__getitem__(i)
            
            
            class tagSummary(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['TagsSummaryDTO']:
                        return TagsSummaryDTO
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple['TagsSummaryDTO'], typing.List['TagsSummaryDTO']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'tagSummary':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'TagsSummaryDTO':
                    return super().__getitem__(i)
            
            
            class musicalFeaturesSummary(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['FieldSummaryDTO']:
                        return FieldSummaryDTO
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple['FieldSummaryDTO'], typing.List['FieldSummaryDTO']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'musicalFeaturesSummary':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'FieldSummaryDTO':
                    return super().__getitem__(i)
            bpmMin = schemas.Float32Schema
            bpmMax = schemas.Float32Schema
            __annotations__ = {
                "totalFiles": totalFiles,
                "fileDetailsSummary": fileDetailsSummary,
                "genreSummary": genreSummary,
                "tagSummary": tagSummary,
                "musicalFeaturesSummary": musicalFeaturesSummary,
                "bpmMin": bpmMin,
                "bpmMax": bpmMax,
            }
    
    totalFiles: MetaOapg.properties.totalFiles
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["totalFiles"]) -> MetaOapg.properties.totalFiles: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["fileDetailsSummary"]) -> MetaOapg.properties.fileDetailsSummary: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["genreSummary"]) -> MetaOapg.properties.genreSummary: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tagSummary"]) -> MetaOapg.properties.tagSummary: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["musicalFeaturesSummary"]) -> MetaOapg.properties.musicalFeaturesSummary: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["bpmMin"]) -> MetaOapg.properties.bpmMin: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["bpmMax"]) -> MetaOapg.properties.bpmMax: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["totalFiles", "fileDetailsSummary", "genreSummary", "tagSummary", "musicalFeaturesSummary", "bpmMin", "bpmMax", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["totalFiles"]) -> MetaOapg.properties.totalFiles: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["fileDetailsSummary"]) -> typing.Union[MetaOapg.properties.fileDetailsSummary, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["genreSummary"]) -> typing.Union[MetaOapg.properties.genreSummary, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tagSummary"]) -> typing.Union[MetaOapg.properties.tagSummary, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["musicalFeaturesSummary"]) -> typing.Union[MetaOapg.properties.musicalFeaturesSummary, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["bpmMin"]) -> typing.Union[MetaOapg.properties.bpmMin, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["bpmMax"]) -> typing.Union[MetaOapg.properties.bpmMax, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["totalFiles", "fileDetailsSummary", "genreSummary", "tagSummary", "musicalFeaturesSummary", "bpmMin", "bpmMax", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        totalFiles: typing.Union[MetaOapg.properties.totalFiles, decimal.Decimal, int, ],
        fileDetailsSummary: typing.Union[MetaOapg.properties.fileDetailsSummary, list, tuple, schemas.Unset] = schemas.unset,
        genreSummary: typing.Union[MetaOapg.properties.genreSummary, list, tuple, schemas.Unset] = schemas.unset,
        tagSummary: typing.Union[MetaOapg.properties.tagSummary, list, tuple, schemas.Unset] = schemas.unset,
        musicalFeaturesSummary: typing.Union[MetaOapg.properties.musicalFeaturesSummary, list, tuple, schemas.Unset] = schemas.unset,
        bpmMin: typing.Union[MetaOapg.properties.bpmMin, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        bpmMax: typing.Union[MetaOapg.properties.bpmMax, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'FilesSummaryDTO':
        return super().__new__(
            cls,
            *_args,
            totalFiles=totalFiles,
            fileDetailsSummary=fileDetailsSummary,
            genreSummary=genreSummary,
            tagSummary=tagSummary,
            musicalFeaturesSummary=musicalFeaturesSummary,
            bpmMin=bpmMin,
            bpmMax=bpmMax,
            _configuration=_configuration,
            **kwargs,
        )

from songtradr_api_client_python.model.field_summary_dto import FieldSummaryDTO
from songtradr_api_client_python.model.genres_summary_dto import GenresSummaryDTO
from songtradr_api_client_python.model.tags_summary_dto import TagsSummaryDTO
