# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.  # noqa: E501

    The version of the OpenAPI document: 1.12.21
    Contact: info@songtradr.com
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from songtradr_api_client_python import schemas  # noqa: F401


class MusicalFeaturesDTO(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    AI generated musical features of a recording.
    """


    class MetaOapg:
        
        class properties:
            
            
            class space(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "very compact": "VERY_COMPACT",
                        "compact": "COMPACT",
                        "moderate space": "MODERATE_SPACE",
                        "wide": "WIDE",
                        "very wide": "VERY_WIDE",
                    }
                
                @schemas.classproperty
                def VERY_COMPACT(cls):
                    return cls("very compact")
                
                @schemas.classproperty
                def COMPACT(cls):
                    return cls("compact")
                
                @schemas.classproperty
                def MODERATE_SPACE(cls):
                    return cls("moderate space")
                
                @schemas.classproperty
                def WIDE(cls):
                    return cls("wide")
                
                @schemas.classproperty
                def VERY_WIDE(cls):
                    return cls("very wide")
            primaryMoodClusterAffinity = schemas.Float32Schema
            
            
            class secondaryMoodCluster(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "aggressive": "AGGRESSIVE",
                        "amusing": "AMUSING",
                        "anxious": "ANXIOUS",
                        "calm": "CALM",
                        "devotional": "DEVOTIONAL",
                        "dreamy": "DREAMY",
                        "energetic": "ENERGETIC",
                        "enigmatic": "ENIGMATIC",
                        "epic": "EPIC",
                        "erotic": "EROTIC",
                        "positive": "POSITIVE",
                        "sad": "SAD",
                        "scary": "SCARY",
                        "wild": "WILD",
                    }
                
                @schemas.classproperty
                def AGGRESSIVE(cls):
                    return cls("aggressive")
                
                @schemas.classproperty
                def AMUSING(cls):
                    return cls("amusing")
                
                @schemas.classproperty
                def ANXIOUS(cls):
                    return cls("anxious")
                
                @schemas.classproperty
                def CALM(cls):
                    return cls("calm")
                
                @schemas.classproperty
                def DEVOTIONAL(cls):
                    return cls("devotional")
                
                @schemas.classproperty
                def DREAMY(cls):
                    return cls("dreamy")
                
                @schemas.classproperty
                def ENERGETIC(cls):
                    return cls("energetic")
                
                @schemas.classproperty
                def ENIGMATIC(cls):
                    return cls("enigmatic")
                
                @schemas.classproperty
                def EPIC(cls):
                    return cls("epic")
                
                @schemas.classproperty
                def EROTIC(cls):
                    return cls("erotic")
                
                @schemas.classproperty
                def POSITIVE(cls):
                    return cls("positive")
                
                @schemas.classproperty
                def SAD(cls):
                    return cls("sad")
                
                @schemas.classproperty
                def SCARY(cls):
                    return cls("scary")
                
                @schemas.classproperty
                def WILD(cls):
                    return cls("wild")
            secondaryMoodClusterAffinity = schemas.Float32Schema
            
            
            class tertiaryMoodCluster(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "aggressive": "AGGRESSIVE",
                        "amusing": "AMUSING",
                        "anxious": "ANXIOUS",
                        "calm": "CALM",
                        "devotional": "DEVOTIONAL",
                        "dreamy": "DREAMY",
                        "energetic": "ENERGETIC",
                        "enigmatic": "ENIGMATIC",
                        "epic": "EPIC",
                        "erotic": "EROTIC",
                        "positive": "POSITIVE",
                        "sad": "SAD",
                        "scary": "SCARY",
                        "wild": "WILD",
                    }
                
                @schemas.classproperty
                def AGGRESSIVE(cls):
                    return cls("aggressive")
                
                @schemas.classproperty
                def AMUSING(cls):
                    return cls("amusing")
                
                @schemas.classproperty
                def ANXIOUS(cls):
                    return cls("anxious")
                
                @schemas.classproperty
                def CALM(cls):
                    return cls("calm")
                
                @schemas.classproperty
                def DEVOTIONAL(cls):
                    return cls("devotional")
                
                @schemas.classproperty
                def DREAMY(cls):
                    return cls("dreamy")
                
                @schemas.classproperty
                def ENERGETIC(cls):
                    return cls("energetic")
                
                @schemas.classproperty
                def ENIGMATIC(cls):
                    return cls("enigmatic")
                
                @schemas.classproperty
                def EPIC(cls):
                    return cls("epic")
                
                @schemas.classproperty
                def EROTIC(cls):
                    return cls("erotic")
                
                @schemas.classproperty
                def POSITIVE(cls):
                    return cls("positive")
                
                @schemas.classproperty
                def SAD(cls):
                    return cls("sad")
                
                @schemas.classproperty
                def SCARY(cls):
                    return cls("scary")
                
                @schemas.classproperty
                def WILD(cls):
                    return cls("wild")
            tertiaryMoodClusterAffinity = schemas.Float32Schema
            vocalsAffinity = schemas.Float32Schema
            dominantInstrumentAffinity = schemas.Float32Schema
            
            
            class secondaryInstrument(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "electric guitar": "ELECTRIC_GUITAR",
                        "piano": "PIANO",
                        "electronics": "ELECTRONICS",
                        "guitar": "GUITAR",
                        "strings": "STRINGS",
                        "synthesizer": "SYNTHESIZER",
                        "wind": "WIND",
                        "saxophone": "SAXOPHONE",
                        "flute": "FLUTE",
                        "trumpet": "TRUMPET",
                        "drum kit": "DRUM_KIT",
                        "keys": "KEYS",
                        "accordion": "ACCORDION",
                        "violin": "VIOLIN",
                        "harpsichord": "HARPSICHORD",
                        "choir": "CHOIR",
                        "cello": "CELLO",
                        "electric bass": "ELECTRIC_BASS",
                        "organ": "ORGAN",
                        "brass": "BRASS",
                        "percussion": "PERCUSSION",
                        "vocals": "VOCALS",
                        "double bass": "DOUBLE_BASS",
                        "harp": "HARP",
                    }
                
                @schemas.classproperty
                def ELECTRIC_GUITAR(cls):
                    return cls("electric guitar")
                
                @schemas.classproperty
                def PIANO(cls):
                    return cls("piano")
                
                @schemas.classproperty
                def ELECTRONICS(cls):
                    return cls("electronics")
                
                @schemas.classproperty
                def GUITAR(cls):
                    return cls("guitar")
                
                @schemas.classproperty
                def STRINGS(cls):
                    return cls("strings")
                
                @schemas.classproperty
                def SYNTHESIZER(cls):
                    return cls("synthesizer")
                
                @schemas.classproperty
                def WIND(cls):
                    return cls("wind")
                
                @schemas.classproperty
                def SAXOPHONE(cls):
                    return cls("saxophone")
                
                @schemas.classproperty
                def FLUTE(cls):
                    return cls("flute")
                
                @schemas.classproperty
                def TRUMPET(cls):
                    return cls("trumpet")
                
                @schemas.classproperty
                def DRUM_KIT(cls):
                    return cls("drum kit")
                
                @schemas.classproperty
                def KEYS(cls):
                    return cls("keys")
                
                @schemas.classproperty
                def ACCORDION(cls):
                    return cls("accordion")
                
                @schemas.classproperty
                def VIOLIN(cls):
                    return cls("violin")
                
                @schemas.classproperty
                def HARPSICHORD(cls):
                    return cls("harpsichord")
                
                @schemas.classproperty
                def CHOIR(cls):
                    return cls("choir")
                
                @schemas.classproperty
                def CELLO(cls):
                    return cls("cello")
                
                @schemas.classproperty
                def ELECTRIC_BASS(cls):
                    return cls("electric bass")
                
                @schemas.classproperty
                def ORGAN(cls):
                    return cls("organ")
                
                @schemas.classproperty
                def BRASS(cls):
                    return cls("brass")
                
                @schemas.classproperty
                def PERCUSSION(cls):
                    return cls("percussion")
                
                @schemas.classproperty
                def VOCALS(cls):
                    return cls("vocals")
                
                @schemas.classproperty
                def DOUBLE_BASS(cls):
                    return cls("double bass")
                
                @schemas.classproperty
                def HARP(cls):
                    return cls("harp")
            secondaryInstrumentAffinity = schemas.Float32Schema
            
            
            class tertiaryInstrument(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "electric guitar": "ELECTRIC_GUITAR",
                        "piano": "PIANO",
                        "electronics": "ELECTRONICS",
                        "guitar": "GUITAR",
                        "strings": "STRINGS",
                        "synthesizer": "SYNTHESIZER",
                        "wind": "WIND",
                        "saxophone": "SAXOPHONE",
                        "flute": "FLUTE",
                        "trumpet": "TRUMPET",
                        "drum kit": "DRUM_KIT",
                        "keys": "KEYS",
                        "accordion": "ACCORDION",
                        "violin": "VIOLIN",
                        "harpsichord": "HARPSICHORD",
                        "choir": "CHOIR",
                        "cello": "CELLO",
                        "electric bass": "ELECTRIC_BASS",
                        "organ": "ORGAN",
                        "brass": "BRASS",
                        "percussion": "PERCUSSION",
                        "vocals": "VOCALS",
                        "double bass": "DOUBLE_BASS",
                        "harp": "HARP",
                    }
                
                @schemas.classproperty
                def ELECTRIC_GUITAR(cls):
                    return cls("electric guitar")
                
                @schemas.classproperty
                def PIANO(cls):
                    return cls("piano")
                
                @schemas.classproperty
                def ELECTRONICS(cls):
                    return cls("electronics")
                
                @schemas.classproperty
                def GUITAR(cls):
                    return cls("guitar")
                
                @schemas.classproperty
                def STRINGS(cls):
                    return cls("strings")
                
                @schemas.classproperty
                def SYNTHESIZER(cls):
                    return cls("synthesizer")
                
                @schemas.classproperty
                def WIND(cls):
                    return cls("wind")
                
                @schemas.classproperty
                def SAXOPHONE(cls):
                    return cls("saxophone")
                
                @schemas.classproperty
                def FLUTE(cls):
                    return cls("flute")
                
                @schemas.classproperty
                def TRUMPET(cls):
                    return cls("trumpet")
                
                @schemas.classproperty
                def DRUM_KIT(cls):
                    return cls("drum kit")
                
                @schemas.classproperty
                def KEYS(cls):
                    return cls("keys")
                
                @schemas.classproperty
                def ACCORDION(cls):
                    return cls("accordion")
                
                @schemas.classproperty
                def VIOLIN(cls):
                    return cls("violin")
                
                @schemas.classproperty
                def HARPSICHORD(cls):
                    return cls("harpsichord")
                
                @schemas.classproperty
                def CHOIR(cls):
                    return cls("choir")
                
                @schemas.classproperty
                def CELLO(cls):
                    return cls("cello")
                
                @schemas.classproperty
                def ELECTRIC_BASS(cls):
                    return cls("electric bass")
                
                @schemas.classproperty
                def ORGAN(cls):
                    return cls("organ")
                
                @schemas.classproperty
                def BRASS(cls):
                    return cls("brass")
                
                @schemas.classproperty
                def PERCUSSION(cls):
                    return cls("percussion")
                
                @schemas.classproperty
                def VOCALS(cls):
                    return cls("vocals")
                
                @schemas.classproperty
                def DOUBLE_BASS(cls):
                    return cls("double bass")
                
                @schemas.classproperty
                def HARP(cls):
                    return cls("harp")
            tertiaryInstrumentAffinity = schemas.Float32Schema
            soundGenerationAffinity = schemas.Float32Schema
            rhythmAffinity = schemas.Float32Schema
            primarySoundCharacterAffinity = schemas.Float32Schema
            tonalityAffinity = schemas.Float32Schema
            bpm = schemas.Float32Schema
            
            
            class productionRating(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "low production quality": "LOW_PRODUCTION_QUALITY",
                        "medium production quality": "MEDIUM_PRODUCTION_QUALITY",
                        "high production quality": "HIGH_PRODUCTION_QUALITY",
                    }
                
                @schemas.classproperty
                def LOW_PRODUCTION_QUALITY(cls):
                    return cls("low production quality")
                
                @schemas.classproperty
                def MEDIUM_PRODUCTION_QUALITY(cls):
                    return cls("medium production quality")
                
                @schemas.classproperty
                def HIGH_PRODUCTION_QUALITY(cls):
                    return cls("high production quality")
            productionRatingAffinity = schemas.Float32Schema
            
            
            class performanceRating(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "low performance quality": "LOW_PERFORMANCE_QUALITY",
                        "medium performance quality": "MEDIUM_PERFORMANCE_QUALITY",
                        "high performance quality": "HIGH_PERFORMANCE_QUALITY",
                    }
                
                @schemas.classproperty
                def LOW_PERFORMANCE_QUALITY(cls):
                    return cls("low performance quality")
                
                @schemas.classproperty
                def MEDIUM_PERFORMANCE_QUALITY(cls):
                    return cls("medium performance quality")
                
                @schemas.classproperty
                def HIGH_PERFORMANCE_QUALITY(cls):
                    return cls("high performance quality")
            performanceRatingAffinity = schemas.Float32Schema
            
            
            class songRating(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "low song quality": "LOW_SONG_QUALITY",
                        "medium song quality": "MEDIUM_SONG_QUALITY",
                        "high song quality": "HIGH_SONG_QUALITY",
                    }
                
                @schemas.classproperty
                def LOW_SONG_QUALITY(cls):
                    return cls("low song quality")
                
                @schemas.classproperty
                def MEDIUM_SONG_QUALITY(cls):
                    return cls("medium song quality")
                
                @schemas.classproperty
                def HIGH_SONG_QUALITY(cls):
                    return cls("high song quality")
            songRatingAffinity = schemas.Float32Schema
            
            
            class audienceAge(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "Generation Z": "GENERATION_Z",
                        "Younger Generation Y": "YOUNGER_GENERATION_Y",
                        "Older Generation Y": "OLDER_GENERATION_Y",
                        "Generation X": "GENERATION_X",
                        "Younger Generation B": "YOUNGER_GENERATION_B",
                        "Older Generation B": "OLDER_GENERATION_B",
                    }
                
                @schemas.classproperty
                def GENERATION_Z(cls):
                    return cls("Generation Z")
                
                @schemas.classproperty
                def YOUNGER_GENERATION_Y(cls):
                    return cls("Younger Generation Y")
                
                @schemas.classproperty
                def OLDER_GENERATION_Y(cls):
                    return cls("Older Generation Y")
                
                @schemas.classproperty
                def GENERATION_X(cls):
                    return cls("Generation X")
                
                @schemas.classproperty
                def YOUNGER_GENERATION_B(cls):
                    return cls("Younger Generation B")
                
                @schemas.classproperty
                def OLDER_GENERATION_B(cls):
                    return cls("Older Generation B")
            audienceAgeAffinity = schemas.Float32Schema
            
            
            class secondaryAudienceAge(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "Generation Z": "GENERATION_Z",
                        "Younger Generation Y": "YOUNGER_GENERATION_Y",
                        "Older Generation Y": "OLDER_GENERATION_Y",
                        "Generation X": "GENERATION_X",
                        "Younger Generation B": "YOUNGER_GENERATION_B",
                        "Older Generation B": "OLDER_GENERATION_B",
                    }
                
                @schemas.classproperty
                def GENERATION_Z(cls):
                    return cls("Generation Z")
                
                @schemas.classproperty
                def YOUNGER_GENERATION_Y(cls):
                    return cls("Younger Generation Y")
                
                @schemas.classproperty
                def OLDER_GENERATION_Y(cls):
                    return cls("Older Generation Y")
                
                @schemas.classproperty
                def GENERATION_X(cls):
                    return cls("Generation X")
                
                @schemas.classproperty
                def YOUNGER_GENERATION_B(cls):
                    return cls("Younger Generation B")
                
                @schemas.classproperty
                def OLDER_GENERATION_B(cls):
                    return cls("Older Generation B")
            secondaryAudienceAgeAffinity = schemas.Float32Schema
            
            
            class tertiaryAudienceAge(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "Generation Z": "GENERATION_Z",
                        "Younger Generation Y": "YOUNGER_GENERATION_Y",
                        "Older Generation Y": "OLDER_GENERATION_Y",
                        "Generation X": "GENERATION_X",
                        "Younger Generation B": "YOUNGER_GENERATION_B",
                        "Older Generation B": "OLDER_GENERATION_B",
                    }
                
                @schemas.classproperty
                def GENERATION_Z(cls):
                    return cls("Generation Z")
                
                @schemas.classproperty
                def YOUNGER_GENERATION_Y(cls):
                    return cls("Younger Generation Y")
                
                @schemas.classproperty
                def OLDER_GENERATION_Y(cls):
                    return cls("Older Generation Y")
                
                @schemas.classproperty
                def GENERATION_X(cls):
                    return cls("Generation X")
                
                @schemas.classproperty
                def YOUNGER_GENERATION_B(cls):
                    return cls("Younger Generation B")
                
                @schemas.classproperty
                def OLDER_GENERATION_B(cls):
                    return cls("Older Generation B")
            tertiaryAudienceAgeAffinity = schemas.Float32Schema
            
            
            class audienceGender(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "male": "MALE",
                        "female": "FEMALE",
                    }
                
                @schemas.classproperty
                def MALE(cls):
                    return cls("male")
                
                @schemas.classproperty
                def FEMALE(cls):
                    return cls("female")
            audienceGenderAffinity = schemas.Float32Schema
            audienceRegionAffinity = schemas.Float32Schema
            
            
            class secondaryAudienceRegion(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "Australia and New Zealand": "AUSTRALIA_AND_NEW_ZEALAND",
                        "Central America and the Carribean": "CENTRAL_AMERICA_AND_THE_CARRIBEAN",
                        "Central and Southern Asia": "CENTRAL_AND_SOUTHERN_ASIA",
                        "Eastern Asia": "EASTERN_ASIA",
                        "Eastern Europe": "EASTERN_EUROPE",
                        "Northern Africa and Western Asia": "NORTHERN_AFRICA_AND_WESTERN_ASIA",
                        "Northern America": "NORTHERN_AMERICA",
                        "Oceania": "OCEANIA",
                        "South America": "SOUTH_AMERICA",
                        "South-Eastern Asia": "SOUTHEASTERN_ASIA",
                        "Southern Europe": "SOUTHERN_EUROPE",
                        "Sub-Saharan Africa": "SUBSAHARAN_AFRICA",
                        "Western and Northern Europe": "WESTERN_AND_NORTHERN_EUROPE",
                    }
                
                @schemas.classproperty
                def AUSTRALIA_AND_NEW_ZEALAND(cls):
                    return cls("Australia and New Zealand")
                
                @schemas.classproperty
                def CENTRAL_AMERICA_AND_THE_CARRIBEAN(cls):
                    return cls("Central America and the Carribean")
                
                @schemas.classproperty
                def CENTRAL_AND_SOUTHERN_ASIA(cls):
                    return cls("Central and Southern Asia")
                
                @schemas.classproperty
                def EASTERN_ASIA(cls):
                    return cls("Eastern Asia")
                
                @schemas.classproperty
                def EASTERN_EUROPE(cls):
                    return cls("Eastern Europe")
                
                @schemas.classproperty
                def NORTHERN_AFRICA_AND_WESTERN_ASIA(cls):
                    return cls("Northern Africa and Western Asia")
                
                @schemas.classproperty
                def NORTHERN_AMERICA(cls):
                    return cls("Northern America")
                
                @schemas.classproperty
                def OCEANIA(cls):
                    return cls("Oceania")
                
                @schemas.classproperty
                def SOUTH_AMERICA(cls):
                    return cls("South America")
                
                @schemas.classproperty
                def SOUTHEASTERN_ASIA(cls):
                    return cls("South-Eastern Asia")
                
                @schemas.classproperty
                def SOUTHERN_EUROPE(cls):
                    return cls("Southern Europe")
                
                @schemas.classproperty
                def SUBSAHARAN_AFRICA(cls):
                    return cls("Sub-Saharan Africa")
                
                @schemas.classproperty
                def WESTERN_AND_NORTHERN_EUROPE(cls):
                    return cls("Western and Northern Europe")
            secondaryAudienceRegionAffinity = schemas.Float32Schema
            
            
            class tertiaryAudienceRegion(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "Australia and New Zealand": "AUSTRALIA_AND_NEW_ZEALAND",
                        "Central America and the Carribean": "CENTRAL_AMERICA_AND_THE_CARRIBEAN",
                        "Central and Southern Asia": "CENTRAL_AND_SOUTHERN_ASIA",
                        "Eastern Asia": "EASTERN_ASIA",
                        "Eastern Europe": "EASTERN_EUROPE",
                        "Northern Africa and Western Asia": "NORTHERN_AFRICA_AND_WESTERN_ASIA",
                        "Northern America": "NORTHERN_AMERICA",
                        "Oceania": "OCEANIA",
                        "South America": "SOUTH_AMERICA",
                        "South-Eastern Asia": "SOUTHEASTERN_ASIA",
                        "Southern Europe": "SOUTHERN_EUROPE",
                        "Sub-Saharan Africa": "SUBSAHARAN_AFRICA",
                        "Western and Northern Europe": "WESTERN_AND_NORTHERN_EUROPE",
                    }
                
                @schemas.classproperty
                def AUSTRALIA_AND_NEW_ZEALAND(cls):
                    return cls("Australia and New Zealand")
                
                @schemas.classproperty
                def CENTRAL_AMERICA_AND_THE_CARRIBEAN(cls):
                    return cls("Central America and the Carribean")
                
                @schemas.classproperty
                def CENTRAL_AND_SOUTHERN_ASIA(cls):
                    return cls("Central and Southern Asia")
                
                @schemas.classproperty
                def EASTERN_ASIA(cls):
                    return cls("Eastern Asia")
                
                @schemas.classproperty
                def EASTERN_EUROPE(cls):
                    return cls("Eastern Europe")
                
                @schemas.classproperty
                def NORTHERN_AFRICA_AND_WESTERN_ASIA(cls):
                    return cls("Northern Africa and Western Asia")
                
                @schemas.classproperty
                def NORTHERN_AMERICA(cls):
                    return cls("Northern America")
                
                @schemas.classproperty
                def OCEANIA(cls):
                    return cls("Oceania")
                
                @schemas.classproperty
                def SOUTH_AMERICA(cls):
                    return cls("South America")
                
                @schemas.classproperty
                def SOUTHEASTERN_ASIA(cls):
                    return cls("South-Eastern Asia")
                
                @schemas.classproperty
                def SOUTHERN_EUROPE(cls):
                    return cls("Southern Europe")
                
                @schemas.classproperty
                def SUBSAHARAN_AFRICA(cls):
                    return cls("Sub-Saharan Africa")
                
                @schemas.classproperty
                def WESTERN_AND_NORTHERN_EUROPE(cls):
                    return cls("Western and Northern Europe")
            tertiaryAudienceRegionAffinity = schemas.Float32Schema
            
            
            class originRegion(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "Australia and New Zealand": "AUSTRALIA_AND_NEW_ZEALAND",
                        "Central America and the Carribean": "CENTRAL_AMERICA_AND_THE_CARRIBEAN",
                        "Central and Southern Asia": "CENTRAL_AND_SOUTHERN_ASIA",
                        "Eastern Asia": "EASTERN_ASIA",
                        "Eastern Europe": "EASTERN_EUROPE",
                        "Northern Africa and Western Asia": "NORTHERN_AFRICA_AND_WESTERN_ASIA",
                        "Northern America": "NORTHERN_AMERICA",
                        "Oceania": "OCEANIA",
                        "South America": "SOUTH_AMERICA",
                        "South-Eastern Asia": "SOUTHEASTERN_ASIA",
                        "Southern Europe": "SOUTHERN_EUROPE",
                        "Sub-Saharan Africa": "SUBSAHARAN_AFRICA",
                        "Western and Northern Europe": "WESTERN_AND_NORTHERN_EUROPE",
                    }
                
                @schemas.classproperty
                def AUSTRALIA_AND_NEW_ZEALAND(cls):
                    return cls("Australia and New Zealand")
                
                @schemas.classproperty
                def CENTRAL_AMERICA_AND_THE_CARRIBEAN(cls):
                    return cls("Central America and the Carribean")
                
                @schemas.classproperty
                def CENTRAL_AND_SOUTHERN_ASIA(cls):
                    return cls("Central and Southern Asia")
                
                @schemas.classproperty
                def EASTERN_ASIA(cls):
                    return cls("Eastern Asia")
                
                @schemas.classproperty
                def EASTERN_EUROPE(cls):
                    return cls("Eastern Europe")
                
                @schemas.classproperty
                def NORTHERN_AFRICA_AND_WESTERN_ASIA(cls):
                    return cls("Northern Africa and Western Asia")
                
                @schemas.classproperty
                def NORTHERN_AMERICA(cls):
                    return cls("Northern America")
                
                @schemas.classproperty
                def OCEANIA(cls):
                    return cls("Oceania")
                
                @schemas.classproperty
                def SOUTH_AMERICA(cls):
                    return cls("South America")
                
                @schemas.classproperty
                def SOUTHEASTERN_ASIA(cls):
                    return cls("South-Eastern Asia")
                
                @schemas.classproperty
                def SOUTHERN_EUROPE(cls):
                    return cls("Southern Europe")
                
                @schemas.classproperty
                def SUBSAHARAN_AFRICA(cls):
                    return cls("Sub-Saharan Africa")
                
                @schemas.classproperty
                def WESTERN_AND_NORTHERN_EUROPE(cls):
                    return cls("Western and Northern Europe")
            originRegionAffinity = schemas.Float32Schema
            originDecadeAffinity = schemas.Float32Schema
            languageOfPerformanceAffinity = schemas.Float32Schema
            curateabilityAffinity = schemas.Float32Schema
            useCaseAffinity = schemas.Float32Schema
            
            
            class industrySuitability(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "Automobiles and Parts": "AUTOMOBILES_AND_PARTS",
                        "Consumer Products and Services": "CONSUMER_PRODUCTS_AND_SERVICES",
                        "Financial Services": "FINANCIAL_SERVICES",
                        "Food, Beverage and Tobacco": "FOOD_BEVERAGE_AND_TOBACCO",
                        "Health Care": "HEALTH_CARE",
                        "Insurance": "INSURANCE",
                        "Media": "MEDIA",
                        "Politics, Government and Organizations": "POLITICS_GOVERNMENT_AND_ORGANIZATIONS",
                        "Real Estate": "REAL_ESTATE",
                        "Retail": "RETAIL",
                        "Technology": "TECHNOLOGY",
                        "Telecommunications": "TELECOMMUNICATIONS",
                        "Travel and Leisure": "TRAVEL_AND_LEISURE",
                    }
                
                @schemas.classproperty
                def AUTOMOBILES_AND_PARTS(cls):
                    return cls("Automobiles and Parts")
                
                @schemas.classproperty
                def CONSUMER_PRODUCTS_AND_SERVICES(cls):
                    return cls("Consumer Products and Services")
                
                @schemas.classproperty
                def FINANCIAL_SERVICES(cls):
                    return cls("Financial Services")
                
                @schemas.classproperty
                def FOOD_BEVERAGE_AND_TOBACCO(cls):
                    return cls("Food, Beverage and Tobacco")
                
                @schemas.classproperty
                def HEALTH_CARE(cls):
                    return cls("Health Care")
                
                @schemas.classproperty
                def INSURANCE(cls):
                    return cls("Insurance")
                
                @schemas.classproperty
                def MEDIA(cls):
                    return cls("Media")
                
                @schemas.classproperty
                def POLITICS_GOVERNMENT_AND_ORGANIZATIONS(cls):
                    return cls("Politics, Government and Organizations")
                
                @schemas.classproperty
                def REAL_ESTATE(cls):
                    return cls("Real Estate")
                
                @schemas.classproperty
                def RETAIL(cls):
                    return cls("Retail")
                
                @schemas.classproperty
                def TECHNOLOGY(cls):
                    return cls("Technology")
                
                @schemas.classproperty
                def TELECOMMUNICATIONS(cls):
                    return cls("Telecommunications")
                
                @schemas.classproperty
                def TRAVEL_AND_LEISURE(cls):
                    return cls("Travel and Leisure")
            industrySuitabilityAffinity = schemas.Float32Schema
            
            
            class audienceRegion(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "Australia and New Zealand": "AUSTRALIA_AND_NEW_ZEALAND",
                        "Central America and the Carribean": "CENTRAL_AMERICA_AND_THE_CARRIBEAN",
                        "Central and Southern Asia": "CENTRAL_AND_SOUTHERN_ASIA",
                        "Eastern Asia": "EASTERN_ASIA",
                        "Eastern Europe": "EASTERN_EUROPE",
                        "Northern Africa and Western Asia": "NORTHERN_AFRICA_AND_WESTERN_ASIA",
                        "Northern America": "NORTHERN_AMERICA",
                        "Oceania": "OCEANIA",
                        "South America": "SOUTH_AMERICA",
                        "South-Eastern Asia": "SOUTHEASTERN_ASIA",
                        "Southern Europe": "SOUTHERN_EUROPE",
                        "Sub-Saharan Africa": "SUBSAHARAN_AFRICA",
                        "Western and Northern Europe": "WESTERN_AND_NORTHERN_EUROPE",
                    }
                
                @schemas.classproperty
                def AUSTRALIA_AND_NEW_ZEALAND(cls):
                    return cls("Australia and New Zealand")
                
                @schemas.classproperty
                def CENTRAL_AMERICA_AND_THE_CARRIBEAN(cls):
                    return cls("Central America and the Carribean")
                
                @schemas.classproperty
                def CENTRAL_AND_SOUTHERN_ASIA(cls):
                    return cls("Central and Southern Asia")
                
                @schemas.classproperty
                def EASTERN_ASIA(cls):
                    return cls("Eastern Asia")
                
                @schemas.classproperty
                def EASTERN_EUROPE(cls):
                    return cls("Eastern Europe")
                
                @schemas.classproperty
                def NORTHERN_AFRICA_AND_WESTERN_ASIA(cls):
                    return cls("Northern Africa and Western Asia")
                
                @schemas.classproperty
                def NORTHERN_AMERICA(cls):
                    return cls("Northern America")
                
                @schemas.classproperty
                def OCEANIA(cls):
                    return cls("Oceania")
                
                @schemas.classproperty
                def SOUTH_AMERICA(cls):
                    return cls("South America")
                
                @schemas.classproperty
                def SOUTHEASTERN_ASIA(cls):
                    return cls("South-Eastern Asia")
                
                @schemas.classproperty
                def SOUTHERN_EUROPE(cls):
                    return cls("Southern Europe")
                
                @schemas.classproperty
                def SUBSAHARAN_AFRICA(cls):
                    return cls("Sub-Saharan Africa")
                
                @schemas.classproperty
                def WESTERN_AND_NORTHERN_EUROPE(cls):
                    return cls("Western and Northern Europe")
            
            
            class arousal(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "very calm": "VERY_CALM",
                        "calm": "CALM",
                        "moderate arousal": "MODERATE_AROUSAL",
                        "energetic": "ENERGETIC",
                        "very energetic": "VERY_ENERGETIC",
                        "varying arousal": "VARYING_AROUSAL",
                    }
                
                @schemas.classproperty
                def VERY_CALM(cls):
                    return cls("very calm")
                
                @schemas.classproperty
                def CALM(cls):
                    return cls("calm")
                
                @schemas.classproperty
                def MODERATE_AROUSAL(cls):
                    return cls("moderate arousal")
                
                @schemas.classproperty
                def ENERGETIC(cls):
                    return cls("energetic")
                
                @schemas.classproperty
                def VERY_ENERGETIC(cls):
                    return cls("very energetic")
                
                @schemas.classproperty
                def VARYING_AROUSAL(cls):
                    return cls("varying arousal")
            
            
            class dominantInstrument(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "electric guitar": "ELECTRIC_GUITAR",
                        "piano": "PIANO",
                        "electronics": "ELECTRONICS",
                        "guitar": "GUITAR",
                        "strings": "STRINGS",
                        "synthesizer": "SYNTHESIZER",
                        "wind": "WIND",
                        "saxophone": "SAXOPHONE",
                        "flute": "FLUTE",
                        "trumpet": "TRUMPET",
                        "drum kit": "DRUM_KIT",
                        "keys": "KEYS",
                        "accordion": "ACCORDION",
                        "violin": "VIOLIN",
                        "harpsichord": "HARPSICHORD",
                        "choir": "CHOIR",
                        "cello": "CELLO",
                        "electric bass": "ELECTRIC_BASS",
                        "organ": "ORGAN",
                        "brass": "BRASS",
                        "percussion": "PERCUSSION",
                        "vocals": "VOCALS",
                        "double bass": "DOUBLE_BASS",
                        "harp": "HARP",
                    }
                
                @schemas.classproperty
                def ELECTRIC_GUITAR(cls):
                    return cls("electric guitar")
                
                @schemas.classproperty
                def PIANO(cls):
                    return cls("piano")
                
                @schemas.classproperty
                def ELECTRONICS(cls):
                    return cls("electronics")
                
                @schemas.classproperty
                def GUITAR(cls):
                    return cls("guitar")
                
                @schemas.classproperty
                def STRINGS(cls):
                    return cls("strings")
                
                @schemas.classproperty
                def SYNTHESIZER(cls):
                    return cls("synthesizer")
                
                @schemas.classproperty
                def WIND(cls):
                    return cls("wind")
                
                @schemas.classproperty
                def SAXOPHONE(cls):
                    return cls("saxophone")
                
                @schemas.classproperty
                def FLUTE(cls):
                    return cls("flute")
                
                @schemas.classproperty
                def TRUMPET(cls):
                    return cls("trumpet")
                
                @schemas.classproperty
                def DRUM_KIT(cls):
                    return cls("drum kit")
                
                @schemas.classproperty
                def KEYS(cls):
                    return cls("keys")
                
                @schemas.classproperty
                def ACCORDION(cls):
                    return cls("accordion")
                
                @schemas.classproperty
                def VIOLIN(cls):
                    return cls("violin")
                
                @schemas.classproperty
                def HARPSICHORD(cls):
                    return cls("harpsichord")
                
                @schemas.classproperty
                def CHOIR(cls):
                    return cls("choir")
                
                @schemas.classproperty
                def CELLO(cls):
                    return cls("cello")
                
                @schemas.classproperty
                def ELECTRIC_BASS(cls):
                    return cls("electric bass")
                
                @schemas.classproperty
                def ORGAN(cls):
                    return cls("organ")
                
                @schemas.classproperty
                def BRASS(cls):
                    return cls("brass")
                
                @schemas.classproperty
                def PERCUSSION(cls):
                    return cls("percussion")
                
                @schemas.classproperty
                def VOCALS(cls):
                    return cls("vocals")
                
                @schemas.classproperty
                def DOUBLE_BASS(cls):
                    return cls("double bass")
                
                @schemas.classproperty
                def HARP(cls):
                    return cls("harp")
            
            
            class energy(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "very quiet": "VERY_QUIET",
                        "quiet": "QUIET",
                        "moderate": "MODERATE",
                        "loud": "LOUD",
                        "very loud": "VERY_LOUD",
                        "dynamic": "DYNAMIC",
                    }
                
                @schemas.classproperty
                def VERY_QUIET(cls):
                    return cls("very quiet")
                
                @schemas.classproperty
                def QUIET(cls):
                    return cls("quiet")
                
                @schemas.classproperty
                def MODERATE(cls):
                    return cls("moderate")
                
                @schemas.classproperty
                def LOUD(cls):
                    return cls("loud")
                
                @schemas.classproperty
                def VERY_LOUD(cls):
                    return cls("very loud")
                
                @schemas.classproperty
                def DYNAMIC(cls):
                    return cls("dynamic")
            
            
            class engagement(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "very unengaging": "VERY_UNENGAGING",
                        "unengaging": "UNENGAGING",
                        "neutral engagement": "NEUTRAL_ENGAGEMENT",
                        "engaging": "ENGAGING",
                        "very engaging": "VERY_ENGAGING",
                        "varying engagement": "VARYING_ENGAGEMENT",
                    }
                
                @schemas.classproperty
                def VERY_UNENGAGING(cls):
                    return cls("very unengaging")
                
                @schemas.classproperty
                def UNENGAGING(cls):
                    return cls("unengaging")
                
                @schemas.classproperty
                def NEUTRAL_ENGAGEMENT(cls):
                    return cls("neutral engagement")
                
                @schemas.classproperty
                def ENGAGING(cls):
                    return cls("engaging")
                
                @schemas.classproperty
                def VERY_ENGAGING(cls):
                    return cls("very engaging")
                
                @schemas.classproperty
                def VARYING_ENGAGEMENT(cls):
                    return cls("varying engagement")
            
            
            class groovyness(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "very steady": "VERY_STEADY",
                        "steady": "STEADY",
                        "moderate rhythm feel": "MODERATE_RHYTHM_FEEL",
                        "groovy": "GROOVY",
                        "very groovy": "VERY_GROOVY",
                    }
                
                @schemas.classproperty
                def VERY_STEADY(cls):
                    return cls("very steady")
                
                @schemas.classproperty
                def STEADY(cls):
                    return cls("steady")
                
                @schemas.classproperty
                def MODERATE_RHYTHM_FEEL(cls):
                    return cls("moderate rhythm feel")
                
                @schemas.classproperty
                def GROOVY(cls):
                    return cls("groovy")
                
                @schemas.classproperty
                def VERY_GROOVY(cls):
                    return cls("very groovy")
            
            
            class harmony(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "very dissonant": "VERY_DISSONANT",
                        "dissonant": "DISSONANT",
                        "moderate harmonies": "MODERATE_HARMONIES",
                        "harmonious": "HARMONIOUS",
                        "very harmonious": "VERY_HARMONIOUS",
                    }
                
                @schemas.classproperty
                def VERY_DISSONANT(cls):
                    return cls("very dissonant")
                
                @schemas.classproperty
                def DISSONANT(cls):
                    return cls("dissonant")
                
                @schemas.classproperty
                def MODERATE_HARMONIES(cls):
                    return cls("moderate harmonies")
                
                @schemas.classproperty
                def HARMONIOUS(cls):
                    return cls("harmonious")
                
                @schemas.classproperty
                def VERY_HARMONIOUS(cls):
                    return cls("very harmonious")
            
            
            class pleasantness(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "very unpleasant": "VERY_UNPLEASANT",
                        "unpleasant": "UNPLEASANT",
                        "neutral pleasantness": "NEUTRAL_PLEASANTNESS",
                        "pleasant": "PLEASANT",
                        "very pleasant": "VERY_PLEASANT",
                        "varying pleasantness": "VARYING_PLEASANTNESS",
                    }
                
                @schemas.classproperty
                def VERY_UNPLEASANT(cls):
                    return cls("very unpleasant")
                
                @schemas.classproperty
                def UNPLEASANT(cls):
                    return cls("unpleasant")
                
                @schemas.classproperty
                def NEUTRAL_PLEASANTNESS(cls):
                    return cls("neutral pleasantness")
                
                @schemas.classproperty
                def PLEASANT(cls):
                    return cls("pleasant")
                
                @schemas.classproperty
                def VERY_PLEASANT(cls):
                    return cls("very pleasant")
                
                @schemas.classproperty
                def VARYING_PLEASANTNESS(cls):
                    return cls("varying pleasantness")
            
            
            class primaryMoodCluster(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "aggressive": "AGGRESSIVE",
                        "amusing": "AMUSING",
                        "anxious": "ANXIOUS",
                        "calm": "CALM",
                        "devotional": "DEVOTIONAL",
                        "dreamy": "DREAMY",
                        "energetic": "ENERGETIC",
                        "enigmatic": "ENIGMATIC",
                        "epic": "EPIC",
                        "erotic": "EROTIC",
                        "positive": "POSITIVE",
                        "sad": "SAD",
                        "scary": "SCARY",
                        "wild": "WILD",
                    }
                
                @schemas.classproperty
                def AGGRESSIVE(cls):
                    return cls("aggressive")
                
                @schemas.classproperty
                def AMUSING(cls):
                    return cls("amusing")
                
                @schemas.classproperty
                def ANXIOUS(cls):
                    return cls("anxious")
                
                @schemas.classproperty
                def CALM(cls):
                    return cls("calm")
                
                @schemas.classproperty
                def DEVOTIONAL(cls):
                    return cls("devotional")
                
                @schemas.classproperty
                def DREAMY(cls):
                    return cls("dreamy")
                
                @schemas.classproperty
                def ENERGETIC(cls):
                    return cls("energetic")
                
                @schemas.classproperty
                def ENIGMATIC(cls):
                    return cls("enigmatic")
                
                @schemas.classproperty
                def EPIC(cls):
                    return cls("epic")
                
                @schemas.classproperty
                def EROTIC(cls):
                    return cls("erotic")
                
                @schemas.classproperty
                def POSITIVE(cls):
                    return cls("positive")
                
                @schemas.classproperty
                def SAD(cls):
                    return cls("sad")
                
                @schemas.classproperty
                def SCARY(cls):
                    return cls("scary")
                
                @schemas.classproperty
                def WILD(cls):
                    return cls("wild")
            
            
            class languageOfPerformance(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "en": "EN",
                        "de": "DE",
                        "no": "NO",
                        "fr": "FR",
                        "es": "ES",
                        "pt": "PT",
                        "fi": "FI",
                        "ru": "RU",
                        "it": "IT",
                        "la": "LA",
                        "el": "EL",
                        "ar": "AR",
                        "nl": "NL",
                        "ja": "JA",
                        "pl": "PL",
                        "sv": "SV",
                        "zu": "ZU",
                        "da": "DA",
                        "cs": "CS",
                        "hu": "HU",
                        "af": "AF",
                        "hi": "HI",
                        "tr": "TR",
                        "zh": "ZH",
                        "ms": "MS",
                        "pa": "PA",
                        "id": "ID",
                        "ko": "KO",
                        "vi": "VI",
                    }
                
                @schemas.classproperty
                def EN(cls):
                    return cls("en")
                
                @schemas.classproperty
                def DE(cls):
                    return cls("de")
                
                @schemas.classproperty
                def NO(cls):
                    return cls("no")
                
                @schemas.classproperty
                def FR(cls):
                    return cls("fr")
                
                @schemas.classproperty
                def ES(cls):
                    return cls("es")
                
                @schemas.classproperty
                def PT(cls):
                    return cls("pt")
                
                @schemas.classproperty
                def FI(cls):
                    return cls("fi")
                
                @schemas.classproperty
                def RU(cls):
                    return cls("ru")
                
                @schemas.classproperty
                def IT(cls):
                    return cls("it")
                
                @schemas.classproperty
                def LA(cls):
                    return cls("la")
                
                @schemas.classproperty
                def EL(cls):
                    return cls("el")
                
                @schemas.classproperty
                def AR(cls):
                    return cls("ar")
                
                @schemas.classproperty
                def NL(cls):
                    return cls("nl")
                
                @schemas.classproperty
                def JA(cls):
                    return cls("ja")
                
                @schemas.classproperty
                def PL(cls):
                    return cls("pl")
                
                @schemas.classproperty
                def SV(cls):
                    return cls("sv")
                
                @schemas.classproperty
                def ZU(cls):
                    return cls("zu")
                
                @schemas.classproperty
                def DA(cls):
                    return cls("da")
                
                @schemas.classproperty
                def CS(cls):
                    return cls("cs")
                
                @schemas.classproperty
                def HU(cls):
                    return cls("hu")
                
                @schemas.classproperty
                def AF(cls):
                    return cls("af")
                
                @schemas.classproperty
                def HI(cls):
                    return cls("hi")
                
                @schemas.classproperty
                def TR(cls):
                    return cls("tr")
                
                @schemas.classproperty
                def ZH(cls):
                    return cls("zh")
                
                @schemas.classproperty
                def MS(cls):
                    return cls("ms")
                
                @schemas.classproperty
                def PA(cls):
                    return cls("pa")
                
                @schemas.classproperty
                def ID(cls):
                    return cls("id")
                
                @schemas.classproperty
                def KO(cls):
                    return cls("ko")
                
                @schemas.classproperty
                def VI(cls):
                    return cls("vi")
            
            
            class primarySoundCharacter(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "brassy": "BRASSY",
                        "bright": "BRIGHT",
                        "clear": "CLEAR",
                        "deep": "DEEP",
                        "distorted": "DISTORTED",
                        "flat": "FLAT",
                        "full": "FULL",
                        "groovy": "GROOVY",
                        "melodious": "MELODIOUS",
                        "natural": "NATURAL",
                        "resonant": "RESONANT",
                        "shrill": "SHRILL",
                        "steady": "STEADY",
                        "thin": "THIN",
                        "warm": "WARM",
                    }
                
                @schemas.classproperty
                def BRASSY(cls):
                    return cls("brassy")
                
                @schemas.classproperty
                def BRIGHT(cls):
                    return cls("bright")
                
                @schemas.classproperty
                def CLEAR(cls):
                    return cls("clear")
                
                @schemas.classproperty
                def DEEP(cls):
                    return cls("deep")
                
                @schemas.classproperty
                def DISTORTED(cls):
                    return cls("distorted")
                
                @schemas.classproperty
                def FLAT(cls):
                    return cls("flat")
                
                @schemas.classproperty
                def FULL(cls):
                    return cls("full")
                
                @schemas.classproperty
                def GROOVY(cls):
                    return cls("groovy")
                
                @schemas.classproperty
                def MELODIOUS(cls):
                    return cls("melodious")
                
                @schemas.classproperty
                def NATURAL(cls):
                    return cls("natural")
                
                @schemas.classproperty
                def RESONANT(cls):
                    return cls("resonant")
                
                @schemas.classproperty
                def SHRILL(cls):
                    return cls("shrill")
                
                @schemas.classproperty
                def STEADY(cls):
                    return cls("steady")
                
                @schemas.classproperty
                def THIN(cls):
                    return cls("thin")
                
                @schemas.classproperty
                def WARM(cls):
                    return cls("warm")
            
            
            class rhythm(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "common time": "COMMON_TIME",
                        "triple meter": "TRIPLE_METER",
                        "complex time signature": "COMPLEX_TIME_SIGNATURE",
                        "binary rhythm": "BINARY_RHYTHM",
                        "ternary rhythm": "TERNARY_RHYTHM",
                    }
                
                @schemas.classproperty
                def COMMON_TIME(cls):
                    return cls("common time")
                
                @schemas.classproperty
                def TRIPLE_METER(cls):
                    return cls("triple meter")
                
                @schemas.classproperty
                def COMPLEX_TIME_SIGNATURE(cls):
                    return cls("complex time signature")
                
                @schemas.classproperty
                def BINARY_RHYTHM(cls):
                    return cls("binary rhythm")
                
                @schemas.classproperty
                def TERNARY_RHYTHM(cls):
                    return cls("ternary rhythm")
            
            
            class roughness(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "very clear": "VERY_CLEAR",
                        "clear": "CLEAR",
                        "moderate roughness": "MODERATE_ROUGHNESS",
                        "distorted": "DISTORTED",
                        "very distorted": "VERY_DISTORTED",
                    }
                
                @schemas.classproperty
                def VERY_CLEAR(cls):
                    return cls("very clear")
                
                @schemas.classproperty
                def CLEAR(cls):
                    return cls("clear")
                
                @schemas.classproperty
                def MODERATE_ROUGHNESS(cls):
                    return cls("moderate roughness")
                
                @schemas.classproperty
                def DISTORTED(cls):
                    return cls("distorted")
                
                @schemas.classproperty
                def VERY_DISTORTED(cls):
                    return cls("very distorted")
            
            
            class scale(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "major key": "MAJOR_KEY",
                        "minor key": "MINOR_KEY",
                        "neutral key": "NEUTRAL_KEY",
                    }
                
                @schemas.classproperty
                def MAJOR_KEY(cls):
                    return cls("major key")
                
                @schemas.classproperty
                def MINOR_KEY(cls):
                    return cls("minor key")
                
                @schemas.classproperty
                def NEUTRAL_KEY(cls):
                    return cls("neutral key")
            
            
            class soundGeneration(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "acoustic": "ACOUSTIC",
                        "electric": "ELECTRIC",
                        "electronic": "ELECTRONIC",
                        "mixed sound generation": "MIXED_SOUND_GENERATION",
                    }
                
                @schemas.classproperty
                def ACOUSTIC(cls):
                    return cls("acoustic")
                
                @schemas.classproperty
                def ELECTRIC(cls):
                    return cls("electric")
                
                @schemas.classproperty
                def ELECTRONIC(cls):
                    return cls("electronic")
                
                @schemas.classproperty
                def MIXED_SOUND_GENERATION(cls):
                    return cls("mixed sound generation")
            
            
            class tempo(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "very slow": "VERY_SLOW",
                        "slow": "SLOW",
                        "mid-tempo": "MIDTEMPO",
                        "fast": "FAST",
                        "very fast": "VERY_FAST",
                        "varying tempo": "VARYING_TEMPO",
                    }
                
                @schemas.classproperty
                def VERY_SLOW(cls):
                    return cls("very slow")
                
                @schemas.classproperty
                def SLOW(cls):
                    return cls("slow")
                
                @schemas.classproperty
                def MIDTEMPO(cls):
                    return cls("mid-tempo")
                
                @schemas.classproperty
                def FAST(cls):
                    return cls("fast")
                
                @schemas.classproperty
                def VERY_FAST(cls):
                    return cls("very fast")
                
                @schemas.classproperty
                def VARYING_TEMPO(cls):
                    return cls("varying tempo")
            
            
            class texture(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "very thin": "VERY_THIN",
                        "thin": "THIN",
                        "moderate texture": "MODERATE_TEXTURE",
                        "full": "FULL",
                        "very full": "VERY_FULL",
                    }
                
                @schemas.classproperty
                def VERY_THIN(cls):
                    return cls("very thin")
                
                @schemas.classproperty
                def THIN(cls):
                    return cls("thin")
                
                @schemas.classproperty
                def MODERATE_TEXTURE(cls):
                    return cls("moderate texture")
                
                @schemas.classproperty
                def FULL(cls):
                    return cls("full")
                
                @schemas.classproperty
                def VERY_FULL(cls):
                    return cls("very full")
            
            
            class timbre(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "very warm": "VERY_WARM",
                        "warm": "WARM",
                        "moderate timbre": "MODERATE_TIMBRE",
                        "bright": "BRIGHT",
                        "very bright": "VERY_BRIGHT",
                    }
                
                @schemas.classproperty
                def VERY_WARM(cls):
                    return cls("very warm")
                
                @schemas.classproperty
                def WARM(cls):
                    return cls("warm")
                
                @schemas.classproperty
                def MODERATE_TIMBRE(cls):
                    return cls("moderate timbre")
                
                @schemas.classproperty
                def BRIGHT(cls):
                    return cls("bright")
                
                @schemas.classproperty
                def VERY_BRIGHT(cls):
                    return cls("very bright")
            
            
            class tonality(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "monotonous": "MONOTONOUS",
                        "moderate melodiousness": "MODERATE_MELODIOUSNESS",
                        "melodious": "MELODIOUS",
                        "atonal": "ATONAL",
                    }
                
                @schemas.classproperty
                def MONOTONOUS(cls):
                    return cls("monotonous")
                
                @schemas.classproperty
                def MODERATE_MELODIOUSNESS(cls):
                    return cls("moderate melodiousness")
                
                @schemas.classproperty
                def MELODIOUS(cls):
                    return cls("melodious")
                
                @schemas.classproperty
                def ATONAL(cls):
                    return cls("atonal")
            
            
            class valence(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "very sad": "VERY_SAD",
                        "sad": "SAD",
                        "moderate valence": "MODERATE_VALENCE",
                        "positive": "POSITIVE",
                        "very positive": "VERY_POSITIVE",
                        "varying valence": "VARYING_VALENCE",
                    }
                
                @schemas.classproperty
                def VERY_SAD(cls):
                    return cls("very sad")
                
                @schemas.classproperty
                def SAD(cls):
                    return cls("sad")
                
                @schemas.classproperty
                def MODERATE_VALENCE(cls):
                    return cls("moderate valence")
                
                @schemas.classproperty
                def POSITIVE(cls):
                    return cls("positive")
                
                @schemas.classproperty
                def VERY_POSITIVE(cls):
                    return cls("very positive")
                
                @schemas.classproperty
                def VARYING_VALENCE(cls):
                    return cls("varying valence")
            
            
            class vocals(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "instrumental": "INSTRUMENTAL",
                        "female vocals": "FEMALE_VOCALS",
                        "male vocals": "MALE_VOCALS",
                        "mixed vocals": "MIXED_VOCALS",
                        "diverse gender vocals": "DIVERSE_GENDER_VOCALS",
                    }
                
                @schemas.classproperty
                def INSTRUMENTAL(cls):
                    return cls("instrumental")
                
                @schemas.classproperty
                def FEMALE_VOCALS(cls):
                    return cls("female vocals")
                
                @schemas.classproperty
                def MALE_VOCALS(cls):
                    return cls("male vocals")
                
                @schemas.classproperty
                def MIXED_VOCALS(cls):
                    return cls("mixed vocals")
                
                @schemas.classproperty
                def DIVERSE_GENDER_VOCALS(cls):
                    return cls("diverse gender vocals")
            
            
            class originDecade(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "pre-1950s": "PRE1950S",
                        "1950s": "DIGIT_ONE_950S",
                        "1960s": "DIGIT_ONE_960S",
                        "1970s": "DIGIT_ONE_970S",
                        "1980s": "DIGIT_ONE_980S",
                        "1990s": "DIGIT_ONE_990S",
                        "2000s": "DIGIT_TWO_000S",
                        "2010s": "DIGIT_TWO_010S",
                        "2020s": "DIGIT_TWO_020S",
                    }
                
                @schemas.classproperty
                def PRE1950S(cls):
                    return cls("pre-1950s")
                
                @schemas.classproperty
                def DIGIT_ONE_950S(cls):
                    return cls("1950s")
                
                @schemas.classproperty
                def DIGIT_ONE_960S(cls):
                    return cls("1960s")
                
                @schemas.classproperty
                def DIGIT_ONE_970S(cls):
                    return cls("1970s")
                
                @schemas.classproperty
                def DIGIT_ONE_980S(cls):
                    return cls("1980s")
                
                @schemas.classproperty
                def DIGIT_ONE_990S(cls):
                    return cls("1990s")
                
                @schemas.classproperty
                def DIGIT_TWO_000S(cls):
                    return cls("2000s")
                
                @schemas.classproperty
                def DIGIT_TWO_010S(cls):
                    return cls("2010s")
                
                @schemas.classproperty
                def DIGIT_TWO_020S(cls):
                    return cls("2020s")
            
            
            class curateability(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "curateable": "CURATEABLE",
                        "uncurateable": "UNCURATEABLE",
                    }
                
                @schemas.classproperty
                def CURATEABLE(cls):
                    return cls("curateable")
                
                @schemas.classproperty
                def UNCURATEABLE(cls):
                    return cls("uncurateable")
            
            
            class useCase(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "background": "BACKGROUND",
                        "sport": "SPORT",
                        "focus": "FOCUS",
                        "christmas": "CHRISTMAS",
                        "film": "FILM",
                        "summer": "SUMMER",
                        "adverts": "ADVERTS",
                        "party": "PARTY",
                        "relax": "RELAX",
                    }
                
                @schemas.classproperty
                def BACKGROUND(cls):
                    return cls("background")
                
                @schemas.classproperty
                def SPORT(cls):
                    return cls("sport")
                
                @schemas.classproperty
                def FOCUS(cls):
                    return cls("focus")
                
                @schemas.classproperty
                def CHRISTMAS(cls):
                    return cls("christmas")
                
                @schemas.classproperty
                def FILM(cls):
                    return cls("film")
                
                @schemas.classproperty
                def SUMMER(cls):
                    return cls("summer")
                
                @schemas.classproperty
                def ADVERTS(cls):
                    return cls("adverts")
                
                @schemas.classproperty
                def PARTY(cls):
                    return cls("party")
                
                @schemas.classproperty
                def RELAX(cls):
                    return cls("relax")
            
            
            class channelSuitability(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "Spotify": "SPOTIFY",
                        "TikTok": "TIK_TOK",
                        "Unfitting": "UNFITTING",
                        "YouTube": "YOU_TUBE",
                    }
                
                @schemas.classproperty
                def SPOTIFY(cls):
                    return cls("Spotify")
                
                @schemas.classproperty
                def TIK_TOK(cls):
                    return cls("TikTok")
                
                @schemas.classproperty
                def UNFITTING(cls):
                    return cls("Unfitting")
                
                @schemas.classproperty
                def YOU_TUBE(cls):
                    return cls("YouTube")
            valenceAffinity = schemas.Float32Schema
            arousalAffinity = schemas.Float32Schema
            pleasantnessAffinity = schemas.Float32Schema
            engagementAffinity = schemas.Float32Schema
            energyAffinity = schemas.Float32Schema
            tempoAffinity = schemas.Float32Schema
            scaleAffinity = schemas.Float32Schema
            timbreAffinity = schemas.Float32Schema
            roughnessAffinity = schemas.Float32Schema
            harmonyAffinity = schemas.Float32Schema
            textureAffinity = schemas.Float32Schema
            groovynessAffinity = schemas.Float32Schema
            spaceAffinity = schemas.Float32Schema
            keyAffinity = schemas.Float32Schema
            channelSuitabilityAffinity = schemas.Float32Schema
            
            
            class key(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "C": "C",
                        "C#": "C",
                        "D": "D",
                        "D#": "D",
                        "E": "E",
                        "F": "F",
                        "F#": "F",
                        "G": "G",
                        "G#": "G",
                        "A": "A",
                        "A#": "A",
                        "B": "B",
                        "unclear": "UNCLEAR",
                    }
                
                @schemas.classproperty
                def C(cls):
                    return cls("C")
                
                @schemas.classproperty
                def C(cls):
                    return cls("C#")
                
                @schemas.classproperty
                def D(cls):
                    return cls("D")
                
                @schemas.classproperty
                def D(cls):
                    return cls("D#")
                
                @schemas.classproperty
                def E(cls):
                    return cls("E")
                
                @schemas.classproperty
                def F(cls):
                    return cls("F")
                
                @schemas.classproperty
                def F(cls):
                    return cls("F#")
                
                @schemas.classproperty
                def G(cls):
                    return cls("G")
                
                @schemas.classproperty
                def G(cls):
                    return cls("G#")
                
                @schemas.classproperty
                def A(cls):
                    return cls("A")
                
                @schemas.classproperty
                def A(cls):
                    return cls("A#")
                
                @schemas.classproperty
                def B(cls):
                    return cls("B")
                
                @schemas.classproperty
                def UNCLEAR(cls):
                    return cls("unclear")
            __annotations__ = {
                "space": space,
                "primaryMoodClusterAffinity": primaryMoodClusterAffinity,
                "secondaryMoodCluster": secondaryMoodCluster,
                "secondaryMoodClusterAffinity": secondaryMoodClusterAffinity,
                "tertiaryMoodCluster": tertiaryMoodCluster,
                "tertiaryMoodClusterAffinity": tertiaryMoodClusterAffinity,
                "vocalsAffinity": vocalsAffinity,
                "dominantInstrumentAffinity": dominantInstrumentAffinity,
                "secondaryInstrument": secondaryInstrument,
                "secondaryInstrumentAffinity": secondaryInstrumentAffinity,
                "tertiaryInstrument": tertiaryInstrument,
                "tertiaryInstrumentAffinity": tertiaryInstrumentAffinity,
                "soundGenerationAffinity": soundGenerationAffinity,
                "rhythmAffinity": rhythmAffinity,
                "primarySoundCharacterAffinity": primarySoundCharacterAffinity,
                "tonalityAffinity": tonalityAffinity,
                "bpm": bpm,
                "productionRating": productionRating,
                "productionRatingAffinity": productionRatingAffinity,
                "performanceRating": performanceRating,
                "performanceRatingAffinity": performanceRatingAffinity,
                "songRating": songRating,
                "songRatingAffinity": songRatingAffinity,
                "audienceAge": audienceAge,
                "audienceAgeAffinity": audienceAgeAffinity,
                "secondaryAudienceAge": secondaryAudienceAge,
                "secondaryAudienceAgeAffinity": secondaryAudienceAgeAffinity,
                "tertiaryAudienceAge": tertiaryAudienceAge,
                "tertiaryAudienceAgeAffinity": tertiaryAudienceAgeAffinity,
                "audienceGender": audienceGender,
                "audienceGenderAffinity": audienceGenderAffinity,
                "audienceRegionAffinity": audienceRegionAffinity,
                "secondaryAudienceRegion": secondaryAudienceRegion,
                "secondaryAudienceRegionAffinity": secondaryAudienceRegionAffinity,
                "tertiaryAudienceRegion": tertiaryAudienceRegion,
                "tertiaryAudienceRegionAffinity": tertiaryAudienceRegionAffinity,
                "originRegion": originRegion,
                "originRegionAffinity": originRegionAffinity,
                "originDecadeAffinity": originDecadeAffinity,
                "languageOfPerformanceAffinity": languageOfPerformanceAffinity,
                "curateabilityAffinity": curateabilityAffinity,
                "useCaseAffinity": useCaseAffinity,
                "industrySuitability": industrySuitability,
                "industrySuitabilityAffinity": industrySuitabilityAffinity,
                "audienceRegion": audienceRegion,
                "arousal": arousal,
                "dominantInstrument": dominantInstrument,
                "energy": energy,
                "engagement": engagement,
                "groovyness": groovyness,
                "harmony": harmony,
                "pleasantness": pleasantness,
                "primaryMoodCluster": primaryMoodCluster,
                "languageOfPerformance": languageOfPerformance,
                "primarySoundCharacter": primarySoundCharacter,
                "rhythm": rhythm,
                "roughness": roughness,
                "scale": scale,
                "soundGeneration": soundGeneration,
                "tempo": tempo,
                "texture": texture,
                "timbre": timbre,
                "tonality": tonality,
                "valence": valence,
                "vocals": vocals,
                "originDecade": originDecade,
                "curateability": curateability,
                "useCase": useCase,
                "channelSuitability": channelSuitability,
                "valenceAffinity": valenceAffinity,
                "arousalAffinity": arousalAffinity,
                "pleasantnessAffinity": pleasantnessAffinity,
                "engagementAffinity": engagementAffinity,
                "energyAffinity": energyAffinity,
                "tempoAffinity": tempoAffinity,
                "scaleAffinity": scaleAffinity,
                "timbreAffinity": timbreAffinity,
                "roughnessAffinity": roughnessAffinity,
                "harmonyAffinity": harmonyAffinity,
                "textureAffinity": textureAffinity,
                "groovynessAffinity": groovynessAffinity,
                "spaceAffinity": spaceAffinity,
                "keyAffinity": keyAffinity,
                "channelSuitabilityAffinity": channelSuitabilityAffinity,
                "key": key,
            }
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["space"]) -> MetaOapg.properties.space: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["primaryMoodClusterAffinity"]) -> MetaOapg.properties.primaryMoodClusterAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["secondaryMoodCluster"]) -> MetaOapg.properties.secondaryMoodCluster: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["secondaryMoodClusterAffinity"]) -> MetaOapg.properties.secondaryMoodClusterAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tertiaryMoodCluster"]) -> MetaOapg.properties.tertiaryMoodCluster: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tertiaryMoodClusterAffinity"]) -> MetaOapg.properties.tertiaryMoodClusterAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["vocalsAffinity"]) -> MetaOapg.properties.vocalsAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["dominantInstrumentAffinity"]) -> MetaOapg.properties.dominantInstrumentAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["secondaryInstrument"]) -> MetaOapg.properties.secondaryInstrument: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["secondaryInstrumentAffinity"]) -> MetaOapg.properties.secondaryInstrumentAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tertiaryInstrument"]) -> MetaOapg.properties.tertiaryInstrument: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tertiaryInstrumentAffinity"]) -> MetaOapg.properties.tertiaryInstrumentAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["soundGenerationAffinity"]) -> MetaOapg.properties.soundGenerationAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["rhythmAffinity"]) -> MetaOapg.properties.rhythmAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["primarySoundCharacterAffinity"]) -> MetaOapg.properties.primarySoundCharacterAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tonalityAffinity"]) -> MetaOapg.properties.tonalityAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["bpm"]) -> MetaOapg.properties.bpm: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["productionRating"]) -> MetaOapg.properties.productionRating: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["productionRatingAffinity"]) -> MetaOapg.properties.productionRatingAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["performanceRating"]) -> MetaOapg.properties.performanceRating: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["performanceRatingAffinity"]) -> MetaOapg.properties.performanceRatingAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["songRating"]) -> MetaOapg.properties.songRating: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["songRatingAffinity"]) -> MetaOapg.properties.songRatingAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["audienceAge"]) -> MetaOapg.properties.audienceAge: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["audienceAgeAffinity"]) -> MetaOapg.properties.audienceAgeAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["secondaryAudienceAge"]) -> MetaOapg.properties.secondaryAudienceAge: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["secondaryAudienceAgeAffinity"]) -> MetaOapg.properties.secondaryAudienceAgeAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tertiaryAudienceAge"]) -> MetaOapg.properties.tertiaryAudienceAge: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tertiaryAudienceAgeAffinity"]) -> MetaOapg.properties.tertiaryAudienceAgeAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["audienceGender"]) -> MetaOapg.properties.audienceGender: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["audienceGenderAffinity"]) -> MetaOapg.properties.audienceGenderAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["audienceRegionAffinity"]) -> MetaOapg.properties.audienceRegionAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["secondaryAudienceRegion"]) -> MetaOapg.properties.secondaryAudienceRegion: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["secondaryAudienceRegionAffinity"]) -> MetaOapg.properties.secondaryAudienceRegionAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tertiaryAudienceRegion"]) -> MetaOapg.properties.tertiaryAudienceRegion: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tertiaryAudienceRegionAffinity"]) -> MetaOapg.properties.tertiaryAudienceRegionAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["originRegion"]) -> MetaOapg.properties.originRegion: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["originRegionAffinity"]) -> MetaOapg.properties.originRegionAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["originDecadeAffinity"]) -> MetaOapg.properties.originDecadeAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["languageOfPerformanceAffinity"]) -> MetaOapg.properties.languageOfPerformanceAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["curateabilityAffinity"]) -> MetaOapg.properties.curateabilityAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["useCaseAffinity"]) -> MetaOapg.properties.useCaseAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["industrySuitability"]) -> MetaOapg.properties.industrySuitability: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["industrySuitabilityAffinity"]) -> MetaOapg.properties.industrySuitabilityAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["audienceRegion"]) -> MetaOapg.properties.audienceRegion: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["arousal"]) -> MetaOapg.properties.arousal: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["dominantInstrument"]) -> MetaOapg.properties.dominantInstrument: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["energy"]) -> MetaOapg.properties.energy: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["engagement"]) -> MetaOapg.properties.engagement: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["groovyness"]) -> MetaOapg.properties.groovyness: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["harmony"]) -> MetaOapg.properties.harmony: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["pleasantness"]) -> MetaOapg.properties.pleasantness: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["primaryMoodCluster"]) -> MetaOapg.properties.primaryMoodCluster: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["languageOfPerformance"]) -> MetaOapg.properties.languageOfPerformance: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["primarySoundCharacter"]) -> MetaOapg.properties.primarySoundCharacter: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["rhythm"]) -> MetaOapg.properties.rhythm: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["roughness"]) -> MetaOapg.properties.roughness: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["scale"]) -> MetaOapg.properties.scale: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["soundGeneration"]) -> MetaOapg.properties.soundGeneration: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tempo"]) -> MetaOapg.properties.tempo: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["texture"]) -> MetaOapg.properties.texture: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["timbre"]) -> MetaOapg.properties.timbre: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tonality"]) -> MetaOapg.properties.tonality: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["valence"]) -> MetaOapg.properties.valence: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["vocals"]) -> MetaOapg.properties.vocals: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["originDecade"]) -> MetaOapg.properties.originDecade: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["curateability"]) -> MetaOapg.properties.curateability: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["useCase"]) -> MetaOapg.properties.useCase: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["channelSuitability"]) -> MetaOapg.properties.channelSuitability: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["valenceAffinity"]) -> MetaOapg.properties.valenceAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["arousalAffinity"]) -> MetaOapg.properties.arousalAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["pleasantnessAffinity"]) -> MetaOapg.properties.pleasantnessAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["engagementAffinity"]) -> MetaOapg.properties.engagementAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["energyAffinity"]) -> MetaOapg.properties.energyAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tempoAffinity"]) -> MetaOapg.properties.tempoAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["scaleAffinity"]) -> MetaOapg.properties.scaleAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["timbreAffinity"]) -> MetaOapg.properties.timbreAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["roughnessAffinity"]) -> MetaOapg.properties.roughnessAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["harmonyAffinity"]) -> MetaOapg.properties.harmonyAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["textureAffinity"]) -> MetaOapg.properties.textureAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["groovynessAffinity"]) -> MetaOapg.properties.groovynessAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["spaceAffinity"]) -> MetaOapg.properties.spaceAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["keyAffinity"]) -> MetaOapg.properties.keyAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["channelSuitabilityAffinity"]) -> MetaOapg.properties.channelSuitabilityAffinity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["key"]) -> MetaOapg.properties.key: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["space", "primaryMoodClusterAffinity", "secondaryMoodCluster", "secondaryMoodClusterAffinity", "tertiaryMoodCluster", "tertiaryMoodClusterAffinity", "vocalsAffinity", "dominantInstrumentAffinity", "secondaryInstrument", "secondaryInstrumentAffinity", "tertiaryInstrument", "tertiaryInstrumentAffinity", "soundGenerationAffinity", "rhythmAffinity", "primarySoundCharacterAffinity", "tonalityAffinity", "bpm", "productionRating", "productionRatingAffinity", "performanceRating", "performanceRatingAffinity", "songRating", "songRatingAffinity", "audienceAge", "audienceAgeAffinity", "secondaryAudienceAge", "secondaryAudienceAgeAffinity", "tertiaryAudienceAge", "tertiaryAudienceAgeAffinity", "audienceGender", "audienceGenderAffinity", "audienceRegionAffinity", "secondaryAudienceRegion", "secondaryAudienceRegionAffinity", "tertiaryAudienceRegion", "tertiaryAudienceRegionAffinity", "originRegion", "originRegionAffinity", "originDecadeAffinity", "languageOfPerformanceAffinity", "curateabilityAffinity", "useCaseAffinity", "industrySuitability", "industrySuitabilityAffinity", "audienceRegion", "arousal", "dominantInstrument", "energy", "engagement", "groovyness", "harmony", "pleasantness", "primaryMoodCluster", "languageOfPerformance", "primarySoundCharacter", "rhythm", "roughness", "scale", "soundGeneration", "tempo", "texture", "timbre", "tonality", "valence", "vocals", "originDecade", "curateability", "useCase", "channelSuitability", "valenceAffinity", "arousalAffinity", "pleasantnessAffinity", "engagementAffinity", "energyAffinity", "tempoAffinity", "scaleAffinity", "timbreAffinity", "roughnessAffinity", "harmonyAffinity", "textureAffinity", "groovynessAffinity", "spaceAffinity", "keyAffinity", "channelSuitabilityAffinity", "key", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["space"]) -> typing.Union[MetaOapg.properties.space, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["primaryMoodClusterAffinity"]) -> typing.Union[MetaOapg.properties.primaryMoodClusterAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["secondaryMoodCluster"]) -> typing.Union[MetaOapg.properties.secondaryMoodCluster, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["secondaryMoodClusterAffinity"]) -> typing.Union[MetaOapg.properties.secondaryMoodClusterAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tertiaryMoodCluster"]) -> typing.Union[MetaOapg.properties.tertiaryMoodCluster, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tertiaryMoodClusterAffinity"]) -> typing.Union[MetaOapg.properties.tertiaryMoodClusterAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["vocalsAffinity"]) -> typing.Union[MetaOapg.properties.vocalsAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["dominantInstrumentAffinity"]) -> typing.Union[MetaOapg.properties.dominantInstrumentAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["secondaryInstrument"]) -> typing.Union[MetaOapg.properties.secondaryInstrument, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["secondaryInstrumentAffinity"]) -> typing.Union[MetaOapg.properties.secondaryInstrumentAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tertiaryInstrument"]) -> typing.Union[MetaOapg.properties.tertiaryInstrument, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tertiaryInstrumentAffinity"]) -> typing.Union[MetaOapg.properties.tertiaryInstrumentAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["soundGenerationAffinity"]) -> typing.Union[MetaOapg.properties.soundGenerationAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["rhythmAffinity"]) -> typing.Union[MetaOapg.properties.rhythmAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["primarySoundCharacterAffinity"]) -> typing.Union[MetaOapg.properties.primarySoundCharacterAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tonalityAffinity"]) -> typing.Union[MetaOapg.properties.tonalityAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["bpm"]) -> typing.Union[MetaOapg.properties.bpm, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["productionRating"]) -> typing.Union[MetaOapg.properties.productionRating, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["productionRatingAffinity"]) -> typing.Union[MetaOapg.properties.productionRatingAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["performanceRating"]) -> typing.Union[MetaOapg.properties.performanceRating, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["performanceRatingAffinity"]) -> typing.Union[MetaOapg.properties.performanceRatingAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["songRating"]) -> typing.Union[MetaOapg.properties.songRating, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["songRatingAffinity"]) -> typing.Union[MetaOapg.properties.songRatingAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["audienceAge"]) -> typing.Union[MetaOapg.properties.audienceAge, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["audienceAgeAffinity"]) -> typing.Union[MetaOapg.properties.audienceAgeAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["secondaryAudienceAge"]) -> typing.Union[MetaOapg.properties.secondaryAudienceAge, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["secondaryAudienceAgeAffinity"]) -> typing.Union[MetaOapg.properties.secondaryAudienceAgeAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tertiaryAudienceAge"]) -> typing.Union[MetaOapg.properties.tertiaryAudienceAge, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tertiaryAudienceAgeAffinity"]) -> typing.Union[MetaOapg.properties.tertiaryAudienceAgeAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["audienceGender"]) -> typing.Union[MetaOapg.properties.audienceGender, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["audienceGenderAffinity"]) -> typing.Union[MetaOapg.properties.audienceGenderAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["audienceRegionAffinity"]) -> typing.Union[MetaOapg.properties.audienceRegionAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["secondaryAudienceRegion"]) -> typing.Union[MetaOapg.properties.secondaryAudienceRegion, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["secondaryAudienceRegionAffinity"]) -> typing.Union[MetaOapg.properties.secondaryAudienceRegionAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tertiaryAudienceRegion"]) -> typing.Union[MetaOapg.properties.tertiaryAudienceRegion, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tertiaryAudienceRegionAffinity"]) -> typing.Union[MetaOapg.properties.tertiaryAudienceRegionAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["originRegion"]) -> typing.Union[MetaOapg.properties.originRegion, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["originRegionAffinity"]) -> typing.Union[MetaOapg.properties.originRegionAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["originDecadeAffinity"]) -> typing.Union[MetaOapg.properties.originDecadeAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["languageOfPerformanceAffinity"]) -> typing.Union[MetaOapg.properties.languageOfPerformanceAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["curateabilityAffinity"]) -> typing.Union[MetaOapg.properties.curateabilityAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["useCaseAffinity"]) -> typing.Union[MetaOapg.properties.useCaseAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["industrySuitability"]) -> typing.Union[MetaOapg.properties.industrySuitability, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["industrySuitabilityAffinity"]) -> typing.Union[MetaOapg.properties.industrySuitabilityAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["audienceRegion"]) -> typing.Union[MetaOapg.properties.audienceRegion, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["arousal"]) -> typing.Union[MetaOapg.properties.arousal, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["dominantInstrument"]) -> typing.Union[MetaOapg.properties.dominantInstrument, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["energy"]) -> typing.Union[MetaOapg.properties.energy, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["engagement"]) -> typing.Union[MetaOapg.properties.engagement, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["groovyness"]) -> typing.Union[MetaOapg.properties.groovyness, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["harmony"]) -> typing.Union[MetaOapg.properties.harmony, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["pleasantness"]) -> typing.Union[MetaOapg.properties.pleasantness, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["primaryMoodCluster"]) -> typing.Union[MetaOapg.properties.primaryMoodCluster, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["languageOfPerformance"]) -> typing.Union[MetaOapg.properties.languageOfPerformance, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["primarySoundCharacter"]) -> typing.Union[MetaOapg.properties.primarySoundCharacter, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["rhythm"]) -> typing.Union[MetaOapg.properties.rhythm, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["roughness"]) -> typing.Union[MetaOapg.properties.roughness, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["scale"]) -> typing.Union[MetaOapg.properties.scale, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["soundGeneration"]) -> typing.Union[MetaOapg.properties.soundGeneration, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tempo"]) -> typing.Union[MetaOapg.properties.tempo, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["texture"]) -> typing.Union[MetaOapg.properties.texture, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["timbre"]) -> typing.Union[MetaOapg.properties.timbre, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tonality"]) -> typing.Union[MetaOapg.properties.tonality, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["valence"]) -> typing.Union[MetaOapg.properties.valence, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["vocals"]) -> typing.Union[MetaOapg.properties.vocals, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["originDecade"]) -> typing.Union[MetaOapg.properties.originDecade, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["curateability"]) -> typing.Union[MetaOapg.properties.curateability, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["useCase"]) -> typing.Union[MetaOapg.properties.useCase, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["channelSuitability"]) -> typing.Union[MetaOapg.properties.channelSuitability, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["valenceAffinity"]) -> typing.Union[MetaOapg.properties.valenceAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["arousalAffinity"]) -> typing.Union[MetaOapg.properties.arousalAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["pleasantnessAffinity"]) -> typing.Union[MetaOapg.properties.pleasantnessAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["engagementAffinity"]) -> typing.Union[MetaOapg.properties.engagementAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["energyAffinity"]) -> typing.Union[MetaOapg.properties.energyAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tempoAffinity"]) -> typing.Union[MetaOapg.properties.tempoAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["scaleAffinity"]) -> typing.Union[MetaOapg.properties.scaleAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["timbreAffinity"]) -> typing.Union[MetaOapg.properties.timbreAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["roughnessAffinity"]) -> typing.Union[MetaOapg.properties.roughnessAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["harmonyAffinity"]) -> typing.Union[MetaOapg.properties.harmonyAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["textureAffinity"]) -> typing.Union[MetaOapg.properties.textureAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["groovynessAffinity"]) -> typing.Union[MetaOapg.properties.groovynessAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["spaceAffinity"]) -> typing.Union[MetaOapg.properties.spaceAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["keyAffinity"]) -> typing.Union[MetaOapg.properties.keyAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["channelSuitabilityAffinity"]) -> typing.Union[MetaOapg.properties.channelSuitabilityAffinity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["key"]) -> typing.Union[MetaOapg.properties.key, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["space", "primaryMoodClusterAffinity", "secondaryMoodCluster", "secondaryMoodClusterAffinity", "tertiaryMoodCluster", "tertiaryMoodClusterAffinity", "vocalsAffinity", "dominantInstrumentAffinity", "secondaryInstrument", "secondaryInstrumentAffinity", "tertiaryInstrument", "tertiaryInstrumentAffinity", "soundGenerationAffinity", "rhythmAffinity", "primarySoundCharacterAffinity", "tonalityAffinity", "bpm", "productionRating", "productionRatingAffinity", "performanceRating", "performanceRatingAffinity", "songRating", "songRatingAffinity", "audienceAge", "audienceAgeAffinity", "secondaryAudienceAge", "secondaryAudienceAgeAffinity", "tertiaryAudienceAge", "tertiaryAudienceAgeAffinity", "audienceGender", "audienceGenderAffinity", "audienceRegionAffinity", "secondaryAudienceRegion", "secondaryAudienceRegionAffinity", "tertiaryAudienceRegion", "tertiaryAudienceRegionAffinity", "originRegion", "originRegionAffinity", "originDecadeAffinity", "languageOfPerformanceAffinity", "curateabilityAffinity", "useCaseAffinity", "industrySuitability", "industrySuitabilityAffinity", "audienceRegion", "arousal", "dominantInstrument", "energy", "engagement", "groovyness", "harmony", "pleasantness", "primaryMoodCluster", "languageOfPerformance", "primarySoundCharacter", "rhythm", "roughness", "scale", "soundGeneration", "tempo", "texture", "timbre", "tonality", "valence", "vocals", "originDecade", "curateability", "useCase", "channelSuitability", "valenceAffinity", "arousalAffinity", "pleasantnessAffinity", "engagementAffinity", "energyAffinity", "tempoAffinity", "scaleAffinity", "timbreAffinity", "roughnessAffinity", "harmonyAffinity", "textureAffinity", "groovynessAffinity", "spaceAffinity", "keyAffinity", "channelSuitabilityAffinity", "key", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        space: typing.Union[MetaOapg.properties.space, str, schemas.Unset] = schemas.unset,
        primaryMoodClusterAffinity: typing.Union[MetaOapg.properties.primaryMoodClusterAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        secondaryMoodCluster: typing.Union[MetaOapg.properties.secondaryMoodCluster, str, schemas.Unset] = schemas.unset,
        secondaryMoodClusterAffinity: typing.Union[MetaOapg.properties.secondaryMoodClusterAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        tertiaryMoodCluster: typing.Union[MetaOapg.properties.tertiaryMoodCluster, str, schemas.Unset] = schemas.unset,
        tertiaryMoodClusterAffinity: typing.Union[MetaOapg.properties.tertiaryMoodClusterAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        vocalsAffinity: typing.Union[MetaOapg.properties.vocalsAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        dominantInstrumentAffinity: typing.Union[MetaOapg.properties.dominantInstrumentAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        secondaryInstrument: typing.Union[MetaOapg.properties.secondaryInstrument, str, schemas.Unset] = schemas.unset,
        secondaryInstrumentAffinity: typing.Union[MetaOapg.properties.secondaryInstrumentAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        tertiaryInstrument: typing.Union[MetaOapg.properties.tertiaryInstrument, str, schemas.Unset] = schemas.unset,
        tertiaryInstrumentAffinity: typing.Union[MetaOapg.properties.tertiaryInstrumentAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        soundGenerationAffinity: typing.Union[MetaOapg.properties.soundGenerationAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        rhythmAffinity: typing.Union[MetaOapg.properties.rhythmAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        primarySoundCharacterAffinity: typing.Union[MetaOapg.properties.primarySoundCharacterAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        tonalityAffinity: typing.Union[MetaOapg.properties.tonalityAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        bpm: typing.Union[MetaOapg.properties.bpm, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        productionRating: typing.Union[MetaOapg.properties.productionRating, str, schemas.Unset] = schemas.unset,
        productionRatingAffinity: typing.Union[MetaOapg.properties.productionRatingAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        performanceRating: typing.Union[MetaOapg.properties.performanceRating, str, schemas.Unset] = schemas.unset,
        performanceRatingAffinity: typing.Union[MetaOapg.properties.performanceRatingAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        songRating: typing.Union[MetaOapg.properties.songRating, str, schemas.Unset] = schemas.unset,
        songRatingAffinity: typing.Union[MetaOapg.properties.songRatingAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        audienceAge: typing.Union[MetaOapg.properties.audienceAge, str, schemas.Unset] = schemas.unset,
        audienceAgeAffinity: typing.Union[MetaOapg.properties.audienceAgeAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        secondaryAudienceAge: typing.Union[MetaOapg.properties.secondaryAudienceAge, str, schemas.Unset] = schemas.unset,
        secondaryAudienceAgeAffinity: typing.Union[MetaOapg.properties.secondaryAudienceAgeAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        tertiaryAudienceAge: typing.Union[MetaOapg.properties.tertiaryAudienceAge, str, schemas.Unset] = schemas.unset,
        tertiaryAudienceAgeAffinity: typing.Union[MetaOapg.properties.tertiaryAudienceAgeAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        audienceGender: typing.Union[MetaOapg.properties.audienceGender, str, schemas.Unset] = schemas.unset,
        audienceGenderAffinity: typing.Union[MetaOapg.properties.audienceGenderAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        audienceRegionAffinity: typing.Union[MetaOapg.properties.audienceRegionAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        secondaryAudienceRegion: typing.Union[MetaOapg.properties.secondaryAudienceRegion, str, schemas.Unset] = schemas.unset,
        secondaryAudienceRegionAffinity: typing.Union[MetaOapg.properties.secondaryAudienceRegionAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        tertiaryAudienceRegion: typing.Union[MetaOapg.properties.tertiaryAudienceRegion, str, schemas.Unset] = schemas.unset,
        tertiaryAudienceRegionAffinity: typing.Union[MetaOapg.properties.tertiaryAudienceRegionAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        originRegion: typing.Union[MetaOapg.properties.originRegion, str, schemas.Unset] = schemas.unset,
        originRegionAffinity: typing.Union[MetaOapg.properties.originRegionAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        originDecadeAffinity: typing.Union[MetaOapg.properties.originDecadeAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        languageOfPerformanceAffinity: typing.Union[MetaOapg.properties.languageOfPerformanceAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        curateabilityAffinity: typing.Union[MetaOapg.properties.curateabilityAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        useCaseAffinity: typing.Union[MetaOapg.properties.useCaseAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        industrySuitability: typing.Union[MetaOapg.properties.industrySuitability, str, schemas.Unset] = schemas.unset,
        industrySuitabilityAffinity: typing.Union[MetaOapg.properties.industrySuitabilityAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        audienceRegion: typing.Union[MetaOapg.properties.audienceRegion, str, schemas.Unset] = schemas.unset,
        arousal: typing.Union[MetaOapg.properties.arousal, str, schemas.Unset] = schemas.unset,
        dominantInstrument: typing.Union[MetaOapg.properties.dominantInstrument, str, schemas.Unset] = schemas.unset,
        energy: typing.Union[MetaOapg.properties.energy, str, schemas.Unset] = schemas.unset,
        engagement: typing.Union[MetaOapg.properties.engagement, str, schemas.Unset] = schemas.unset,
        groovyness: typing.Union[MetaOapg.properties.groovyness, str, schemas.Unset] = schemas.unset,
        harmony: typing.Union[MetaOapg.properties.harmony, str, schemas.Unset] = schemas.unset,
        pleasantness: typing.Union[MetaOapg.properties.pleasantness, str, schemas.Unset] = schemas.unset,
        primaryMoodCluster: typing.Union[MetaOapg.properties.primaryMoodCluster, str, schemas.Unset] = schemas.unset,
        languageOfPerformance: typing.Union[MetaOapg.properties.languageOfPerformance, str, schemas.Unset] = schemas.unset,
        primarySoundCharacter: typing.Union[MetaOapg.properties.primarySoundCharacter, str, schemas.Unset] = schemas.unset,
        rhythm: typing.Union[MetaOapg.properties.rhythm, str, schemas.Unset] = schemas.unset,
        roughness: typing.Union[MetaOapg.properties.roughness, str, schemas.Unset] = schemas.unset,
        scale: typing.Union[MetaOapg.properties.scale, str, schemas.Unset] = schemas.unset,
        soundGeneration: typing.Union[MetaOapg.properties.soundGeneration, str, schemas.Unset] = schemas.unset,
        tempo: typing.Union[MetaOapg.properties.tempo, str, schemas.Unset] = schemas.unset,
        texture: typing.Union[MetaOapg.properties.texture, str, schemas.Unset] = schemas.unset,
        timbre: typing.Union[MetaOapg.properties.timbre, str, schemas.Unset] = schemas.unset,
        tonality: typing.Union[MetaOapg.properties.tonality, str, schemas.Unset] = schemas.unset,
        valence: typing.Union[MetaOapg.properties.valence, str, schemas.Unset] = schemas.unset,
        vocals: typing.Union[MetaOapg.properties.vocals, str, schemas.Unset] = schemas.unset,
        originDecade: typing.Union[MetaOapg.properties.originDecade, str, schemas.Unset] = schemas.unset,
        curateability: typing.Union[MetaOapg.properties.curateability, str, schemas.Unset] = schemas.unset,
        useCase: typing.Union[MetaOapg.properties.useCase, str, schemas.Unset] = schemas.unset,
        channelSuitability: typing.Union[MetaOapg.properties.channelSuitability, str, schemas.Unset] = schemas.unset,
        valenceAffinity: typing.Union[MetaOapg.properties.valenceAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        arousalAffinity: typing.Union[MetaOapg.properties.arousalAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        pleasantnessAffinity: typing.Union[MetaOapg.properties.pleasantnessAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        engagementAffinity: typing.Union[MetaOapg.properties.engagementAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        energyAffinity: typing.Union[MetaOapg.properties.energyAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        tempoAffinity: typing.Union[MetaOapg.properties.tempoAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        scaleAffinity: typing.Union[MetaOapg.properties.scaleAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        timbreAffinity: typing.Union[MetaOapg.properties.timbreAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        roughnessAffinity: typing.Union[MetaOapg.properties.roughnessAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        harmonyAffinity: typing.Union[MetaOapg.properties.harmonyAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        textureAffinity: typing.Union[MetaOapg.properties.textureAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        groovynessAffinity: typing.Union[MetaOapg.properties.groovynessAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        spaceAffinity: typing.Union[MetaOapg.properties.spaceAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        keyAffinity: typing.Union[MetaOapg.properties.keyAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        channelSuitabilityAffinity: typing.Union[MetaOapg.properties.channelSuitabilityAffinity, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        key: typing.Union[MetaOapg.properties.key, str, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'MusicalFeaturesDTO':
        return super().__new__(
            cls,
            *_args,
            space=space,
            primaryMoodClusterAffinity=primaryMoodClusterAffinity,
            secondaryMoodCluster=secondaryMoodCluster,
            secondaryMoodClusterAffinity=secondaryMoodClusterAffinity,
            tertiaryMoodCluster=tertiaryMoodCluster,
            tertiaryMoodClusterAffinity=tertiaryMoodClusterAffinity,
            vocalsAffinity=vocalsAffinity,
            dominantInstrumentAffinity=dominantInstrumentAffinity,
            secondaryInstrument=secondaryInstrument,
            secondaryInstrumentAffinity=secondaryInstrumentAffinity,
            tertiaryInstrument=tertiaryInstrument,
            tertiaryInstrumentAffinity=tertiaryInstrumentAffinity,
            soundGenerationAffinity=soundGenerationAffinity,
            rhythmAffinity=rhythmAffinity,
            primarySoundCharacterAffinity=primarySoundCharacterAffinity,
            tonalityAffinity=tonalityAffinity,
            bpm=bpm,
            productionRating=productionRating,
            productionRatingAffinity=productionRatingAffinity,
            performanceRating=performanceRating,
            performanceRatingAffinity=performanceRatingAffinity,
            songRating=songRating,
            songRatingAffinity=songRatingAffinity,
            audienceAge=audienceAge,
            audienceAgeAffinity=audienceAgeAffinity,
            secondaryAudienceAge=secondaryAudienceAge,
            secondaryAudienceAgeAffinity=secondaryAudienceAgeAffinity,
            tertiaryAudienceAge=tertiaryAudienceAge,
            tertiaryAudienceAgeAffinity=tertiaryAudienceAgeAffinity,
            audienceGender=audienceGender,
            audienceGenderAffinity=audienceGenderAffinity,
            audienceRegionAffinity=audienceRegionAffinity,
            secondaryAudienceRegion=secondaryAudienceRegion,
            secondaryAudienceRegionAffinity=secondaryAudienceRegionAffinity,
            tertiaryAudienceRegion=tertiaryAudienceRegion,
            tertiaryAudienceRegionAffinity=tertiaryAudienceRegionAffinity,
            originRegion=originRegion,
            originRegionAffinity=originRegionAffinity,
            originDecadeAffinity=originDecadeAffinity,
            languageOfPerformanceAffinity=languageOfPerformanceAffinity,
            curateabilityAffinity=curateabilityAffinity,
            useCaseAffinity=useCaseAffinity,
            industrySuitability=industrySuitability,
            industrySuitabilityAffinity=industrySuitabilityAffinity,
            audienceRegion=audienceRegion,
            arousal=arousal,
            dominantInstrument=dominantInstrument,
            energy=energy,
            engagement=engagement,
            groovyness=groovyness,
            harmony=harmony,
            pleasantness=pleasantness,
            primaryMoodCluster=primaryMoodCluster,
            languageOfPerformance=languageOfPerformance,
            primarySoundCharacter=primarySoundCharacter,
            rhythm=rhythm,
            roughness=roughness,
            scale=scale,
            soundGeneration=soundGeneration,
            tempo=tempo,
            texture=texture,
            timbre=timbre,
            tonality=tonality,
            valence=valence,
            vocals=vocals,
            originDecade=originDecade,
            curateability=curateability,
            useCase=useCase,
            channelSuitability=channelSuitability,
            valenceAffinity=valenceAffinity,
            arousalAffinity=arousalAffinity,
            pleasantnessAffinity=pleasantnessAffinity,
            engagementAffinity=engagementAffinity,
            energyAffinity=energyAffinity,
            tempoAffinity=tempoAffinity,
            scaleAffinity=scaleAffinity,
            timbreAffinity=timbreAffinity,
            roughnessAffinity=roughnessAffinity,
            harmonyAffinity=harmonyAffinity,
            textureAffinity=textureAffinity,
            groovynessAffinity=groovynessAffinity,
            spaceAffinity=spaceAffinity,
            keyAffinity=keyAffinity,
            channelSuitabilityAffinity=channelSuitabilityAffinity,
            key=key,
            _configuration=_configuration,
            **kwargs,
        )
