# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.  # noqa: E501

    The version of the OpenAPI document: 1.12.21
    Contact: info@songtradr.com
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from songtradr_api_client_python import schemas  # noqa: F401


class PartyLargeDTO(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Party (person, group or organization) with a large field-set.
    """


    class MetaOapg:
        required = {
            "fullName",
        }
        
        class properties:
            fullName = schemas.StrSchema
            birthDate = schemas.StrSchema
            deathDate = schemas.StrSchema
            birthYear = schemas.StrSchema
            deathYear = schemas.StrSchema
            birthPlace = schemas.StrSchema
            musicbrainzType = schemas.StrSchema
            area = schemas.StrSchema
            __annotations__ = {
                "fullName": fullName,
                "birthDate": birthDate,
                "deathDate": deathDate,
                "birthYear": birthYear,
                "deathYear": deathYear,
                "birthPlace": birthPlace,
                "musicbrainzType": musicbrainzType,
                "area": area,
            }
    
    fullName: MetaOapg.properties.fullName
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["fullName"]) -> MetaOapg.properties.fullName: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["birthDate"]) -> MetaOapg.properties.birthDate: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deathDate"]) -> MetaOapg.properties.deathDate: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["birthYear"]) -> MetaOapg.properties.birthYear: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deathYear"]) -> MetaOapg.properties.deathYear: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["birthPlace"]) -> MetaOapg.properties.birthPlace: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["musicbrainzType"]) -> MetaOapg.properties.musicbrainzType: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["area"]) -> MetaOapg.properties.area: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["fullName", "birthDate", "deathDate", "birthYear", "deathYear", "birthPlace", "musicbrainzType", "area", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["fullName"]) -> MetaOapg.properties.fullName: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["birthDate"]) -> typing.Union[MetaOapg.properties.birthDate, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deathDate"]) -> typing.Union[MetaOapg.properties.deathDate, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["birthYear"]) -> typing.Union[MetaOapg.properties.birthYear, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deathYear"]) -> typing.Union[MetaOapg.properties.deathYear, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["birthPlace"]) -> typing.Union[MetaOapg.properties.birthPlace, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["musicbrainzType"]) -> typing.Union[MetaOapg.properties.musicbrainzType, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["area"]) -> typing.Union[MetaOapg.properties.area, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["fullName", "birthDate", "deathDate", "birthYear", "deathYear", "birthPlace", "musicbrainzType", "area", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        fullName: typing.Union[MetaOapg.properties.fullName, str, ],
        birthDate: typing.Union[MetaOapg.properties.birthDate, str, schemas.Unset] = schemas.unset,
        deathDate: typing.Union[MetaOapg.properties.deathDate, str, schemas.Unset] = schemas.unset,
        birthYear: typing.Union[MetaOapg.properties.birthYear, str, schemas.Unset] = schemas.unset,
        deathYear: typing.Union[MetaOapg.properties.deathYear, str, schemas.Unset] = schemas.unset,
        birthPlace: typing.Union[MetaOapg.properties.birthPlace, str, schemas.Unset] = schemas.unset,
        musicbrainzType: typing.Union[MetaOapg.properties.musicbrainzType, str, schemas.Unset] = schemas.unset,
        area: typing.Union[MetaOapg.properties.area, str, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'PartyLargeDTO':
        return super().__new__(
            cls,
            *_args,
            fullName=fullName,
            birthDate=birthDate,
            deathDate=deathDate,
            birthYear=birthYear,
            deathYear=deathYear,
            birthPlace=birthPlace,
            musicbrainzType=musicbrainzType,
            area=area,
            _configuration=_configuration,
            **kwargs,
        )
