# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.  # noqa: E501

    The version of the OpenAPI document: 1.12.21
    Contact: info@songtradr.com
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from songtradr_api_client_python import schemas  # noqa: F401


class SavePlaylistDTO(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Save a playlist
    """


    class MetaOapg:
        required = {
            "songtradrPlaylistGuid",
            "name",
            "state",
            "usages",
        }
        
        class properties:
            songtradrPlaylistGuid = schemas.StrSchema
            name = schemas.StrSchema
            
            
            class state(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "active": "ACTIVE",
                        "draft": "DRAFT",
                    }
                
                @schemas.classproperty
                def ACTIVE(cls):
                    return cls("active")
                
                @schemas.classproperty
                def DRAFT(cls):
                    return cls("draft")
            
            
            class usages(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'usages':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            description = schemas.StrSchema
            assetUrl = schemas.StrSchema
            pretzelTier = schemas.StrSchema
            usage = schemas.StrSchema
            
            
            class recordings(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['SaveRecordingPlaylistDTO']:
                        return SaveRecordingPlaylistDTO
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple['SaveRecordingPlaylistDTO'], typing.List['SaveRecordingPlaylistDTO']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'recordings':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'SaveRecordingPlaylistDTO':
                    return super().__getitem__(i)
            __annotations__ = {
                "songtradrPlaylistGuid": songtradrPlaylistGuid,
                "name": name,
                "state": state,
                "usages": usages,
                "description": description,
                "assetUrl": assetUrl,
                "pretzelTier": pretzelTier,
                "usage": usage,
                "recordings": recordings,
            }
    
    songtradrPlaylistGuid: MetaOapg.properties.songtradrPlaylistGuid
    name: MetaOapg.properties.name
    state: MetaOapg.properties.state
    usages: MetaOapg.properties.usages
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["songtradrPlaylistGuid"]) -> MetaOapg.properties.songtradrPlaylistGuid: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["name"]) -> MetaOapg.properties.name: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["state"]) -> MetaOapg.properties.state: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["usages"]) -> MetaOapg.properties.usages: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["description"]) -> MetaOapg.properties.description: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["assetUrl"]) -> MetaOapg.properties.assetUrl: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["pretzelTier"]) -> MetaOapg.properties.pretzelTier: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["usage"]) -> MetaOapg.properties.usage: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["recordings"]) -> MetaOapg.properties.recordings: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["songtradrPlaylistGuid", "name", "state", "usages", "description", "assetUrl", "pretzelTier", "usage", "recordings", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["songtradrPlaylistGuid"]) -> MetaOapg.properties.songtradrPlaylistGuid: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["name"]) -> MetaOapg.properties.name: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["state"]) -> MetaOapg.properties.state: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["usages"]) -> MetaOapg.properties.usages: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["description"]) -> typing.Union[MetaOapg.properties.description, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["assetUrl"]) -> typing.Union[MetaOapg.properties.assetUrl, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["pretzelTier"]) -> typing.Union[MetaOapg.properties.pretzelTier, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["usage"]) -> typing.Union[MetaOapg.properties.usage, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["recordings"]) -> typing.Union[MetaOapg.properties.recordings, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["songtradrPlaylistGuid", "name", "state", "usages", "description", "assetUrl", "pretzelTier", "usage", "recordings", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        songtradrPlaylistGuid: typing.Union[MetaOapg.properties.songtradrPlaylistGuid, str, ],
        name: typing.Union[MetaOapg.properties.name, str, ],
        state: typing.Union[MetaOapg.properties.state, str, ],
        usages: typing.Union[MetaOapg.properties.usages, list, tuple, ],
        description: typing.Union[MetaOapg.properties.description, str, schemas.Unset] = schemas.unset,
        assetUrl: typing.Union[MetaOapg.properties.assetUrl, str, schemas.Unset] = schemas.unset,
        pretzelTier: typing.Union[MetaOapg.properties.pretzelTier, str, schemas.Unset] = schemas.unset,
        usage: typing.Union[MetaOapg.properties.usage, str, schemas.Unset] = schemas.unset,
        recordings: typing.Union[MetaOapg.properties.recordings, list, tuple, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'SavePlaylistDTO':
        return super().__new__(
            cls,
            *_args,
            songtradrPlaylistGuid=songtradrPlaylistGuid,
            name=name,
            state=state,
            usages=usages,
            description=description,
            assetUrl=assetUrl,
            pretzelTier=pretzelTier,
            usage=usage,
            recordings=recordings,
            _configuration=_configuration,
            **kwargs,
        )

from songtradr_api_client_python.model.save_recording_playlist_dto import SaveRecordingPlaylistDTO
