# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.  # noqa: E501

    The version of the OpenAPI document: 1.12.21
    Contact: info@songtradr.com
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from songtradr_api_client_python import schemas  # noqa: F401


class SearchFilterValuesDTO(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Categories of musical features that can be used as search filters.
    """


    class MetaOapg:
        required = {
            "harmony",
            "dominantInstrument",
            "engagement",
            "originRegion",
            "pleasantness",
            "scale",
            "tempo",
            "tertiaryInstrument",
            "curateability",
            "audienceRegion",
            "space",
            "channelSuitability",
            "groovyness",
            "timbre",
            "productionRating",
            "tertiaryAudienceAge",
            "roughness",
            "songRating",
            "soundGeneration",
            "secondaryAudienceAge",
            "key",
            "secondaryMoodCluster",
            "tertiaryMoodCluster",
            "energy",
            "secondaryAudienceRegion",
            "audienceAge",
            "texture",
            "primaryMoodCluster",
            "tonality",
            "valence",
            "rhythm",
            "originDecade",
            "secondaryInstrument",
            "performanceRating",
            "useCase",
            "primarySoundCharacter",
            "languageOfPerformance",
            "audienceGender",
            "vocals",
            "tertiaryAudienceRegion",
            "arousal",
        }
        
        class properties:
            
            
            class primaryMoodCluster(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'primaryMoodCluster':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class secondaryMoodCluster(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'secondaryMoodCluster':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class tertiaryMoodCluster(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'tertiaryMoodCluster':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class valence(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'valence':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class arousal(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'arousal':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class pleasantness(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'pleasantness':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class engagement(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'engagement':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class vocals(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'vocals':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class dominantInstrument(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'dominantInstrument':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class secondaryInstrument(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'secondaryInstrument':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class tertiaryInstrument(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'tertiaryInstrument':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class energy(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'energy':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class soundGeneration(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'soundGeneration':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class tempo(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'tempo':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class scale(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'scale':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class key(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'key':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class rhythm(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'rhythm':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class primarySoundCharacter(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'primarySoundCharacter':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class timbre(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'timbre':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class roughness(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'roughness':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class tonality(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'tonality':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class harmony(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'harmony':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class texture(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'texture':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class groovyness(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'groovyness':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class space(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'space':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class productionRating(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'productionRating':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class performanceRating(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'performanceRating':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class songRating(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'songRating':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class audienceAge(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'audienceAge':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class secondaryAudienceAge(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'secondaryAudienceAge':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class tertiaryAudienceAge(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'tertiaryAudienceAge':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class audienceGender(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'audienceGender':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class audienceRegion(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'audienceRegion':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class secondaryAudienceRegion(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'secondaryAudienceRegion':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class tertiaryAudienceRegion(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'tertiaryAudienceRegion':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class originDecade(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'originDecade':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class originRegion(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'originRegion':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class languageOfPerformance(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'languageOfPerformance':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class curateability(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'curateability':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class useCase(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'useCase':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class channelSuitability(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.StrSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'channelSuitability':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            __annotations__ = {
                "primaryMoodCluster": primaryMoodCluster,
                "secondaryMoodCluster": secondaryMoodCluster,
                "tertiaryMoodCluster": tertiaryMoodCluster,
                "valence": valence,
                "arousal": arousal,
                "pleasantness": pleasantness,
                "engagement": engagement,
                "vocals": vocals,
                "dominantInstrument": dominantInstrument,
                "secondaryInstrument": secondaryInstrument,
                "tertiaryInstrument": tertiaryInstrument,
                "energy": energy,
                "soundGeneration": soundGeneration,
                "tempo": tempo,
                "scale": scale,
                "key": key,
                "rhythm": rhythm,
                "primarySoundCharacter": primarySoundCharacter,
                "timbre": timbre,
                "roughness": roughness,
                "tonality": tonality,
                "harmony": harmony,
                "texture": texture,
                "groovyness": groovyness,
                "space": space,
                "productionRating": productionRating,
                "performanceRating": performanceRating,
                "songRating": songRating,
                "audienceAge": audienceAge,
                "secondaryAudienceAge": secondaryAudienceAge,
                "tertiaryAudienceAge": tertiaryAudienceAge,
                "audienceGender": audienceGender,
                "audienceRegion": audienceRegion,
                "secondaryAudienceRegion": secondaryAudienceRegion,
                "tertiaryAudienceRegion": tertiaryAudienceRegion,
                "originDecade": originDecade,
                "originRegion": originRegion,
                "languageOfPerformance": languageOfPerformance,
                "curateability": curateability,
                "useCase": useCase,
                "channelSuitability": channelSuitability,
            }
    
    harmony: MetaOapg.properties.harmony
    dominantInstrument: MetaOapg.properties.dominantInstrument
    engagement: MetaOapg.properties.engagement
    originRegion: MetaOapg.properties.originRegion
    pleasantness: MetaOapg.properties.pleasantness
    scale: MetaOapg.properties.scale
    tempo: MetaOapg.properties.tempo
    tertiaryInstrument: MetaOapg.properties.tertiaryInstrument
    curateability: MetaOapg.properties.curateability
    audienceRegion: MetaOapg.properties.audienceRegion
    space: MetaOapg.properties.space
    channelSuitability: MetaOapg.properties.channelSuitability
    groovyness: MetaOapg.properties.groovyness
    timbre: MetaOapg.properties.timbre
    productionRating: MetaOapg.properties.productionRating
    tertiaryAudienceAge: MetaOapg.properties.tertiaryAudienceAge
    roughness: MetaOapg.properties.roughness
    songRating: MetaOapg.properties.songRating
    soundGeneration: MetaOapg.properties.soundGeneration
    secondaryAudienceAge: MetaOapg.properties.secondaryAudienceAge
    key: MetaOapg.properties.key
    secondaryMoodCluster: MetaOapg.properties.secondaryMoodCluster
    tertiaryMoodCluster: MetaOapg.properties.tertiaryMoodCluster
    energy: MetaOapg.properties.energy
    secondaryAudienceRegion: MetaOapg.properties.secondaryAudienceRegion
    audienceAge: MetaOapg.properties.audienceAge
    texture: MetaOapg.properties.texture
    primaryMoodCluster: MetaOapg.properties.primaryMoodCluster
    tonality: MetaOapg.properties.tonality
    valence: MetaOapg.properties.valence
    rhythm: MetaOapg.properties.rhythm
    originDecade: MetaOapg.properties.originDecade
    secondaryInstrument: MetaOapg.properties.secondaryInstrument
    performanceRating: MetaOapg.properties.performanceRating
    useCase: MetaOapg.properties.useCase
    primarySoundCharacter: MetaOapg.properties.primarySoundCharacter
    languageOfPerformance: MetaOapg.properties.languageOfPerformance
    audienceGender: MetaOapg.properties.audienceGender
    vocals: MetaOapg.properties.vocals
    tertiaryAudienceRegion: MetaOapg.properties.tertiaryAudienceRegion
    arousal: MetaOapg.properties.arousal
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["primaryMoodCluster"]) -> MetaOapg.properties.primaryMoodCluster: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["secondaryMoodCluster"]) -> MetaOapg.properties.secondaryMoodCluster: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tertiaryMoodCluster"]) -> MetaOapg.properties.tertiaryMoodCluster: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["valence"]) -> MetaOapg.properties.valence: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["arousal"]) -> MetaOapg.properties.arousal: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["pleasantness"]) -> MetaOapg.properties.pleasantness: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["engagement"]) -> MetaOapg.properties.engagement: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["vocals"]) -> MetaOapg.properties.vocals: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["dominantInstrument"]) -> MetaOapg.properties.dominantInstrument: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["secondaryInstrument"]) -> MetaOapg.properties.secondaryInstrument: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tertiaryInstrument"]) -> MetaOapg.properties.tertiaryInstrument: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["energy"]) -> MetaOapg.properties.energy: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["soundGeneration"]) -> MetaOapg.properties.soundGeneration: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tempo"]) -> MetaOapg.properties.tempo: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["scale"]) -> MetaOapg.properties.scale: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["key"]) -> MetaOapg.properties.key: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["rhythm"]) -> MetaOapg.properties.rhythm: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["primarySoundCharacter"]) -> MetaOapg.properties.primarySoundCharacter: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["timbre"]) -> MetaOapg.properties.timbre: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["roughness"]) -> MetaOapg.properties.roughness: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tonality"]) -> MetaOapg.properties.tonality: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["harmony"]) -> MetaOapg.properties.harmony: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["texture"]) -> MetaOapg.properties.texture: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["groovyness"]) -> MetaOapg.properties.groovyness: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["space"]) -> MetaOapg.properties.space: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["productionRating"]) -> MetaOapg.properties.productionRating: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["performanceRating"]) -> MetaOapg.properties.performanceRating: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["songRating"]) -> MetaOapg.properties.songRating: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["audienceAge"]) -> MetaOapg.properties.audienceAge: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["secondaryAudienceAge"]) -> MetaOapg.properties.secondaryAudienceAge: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tertiaryAudienceAge"]) -> MetaOapg.properties.tertiaryAudienceAge: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["audienceGender"]) -> MetaOapg.properties.audienceGender: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["audienceRegion"]) -> MetaOapg.properties.audienceRegion: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["secondaryAudienceRegion"]) -> MetaOapg.properties.secondaryAudienceRegion: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tertiaryAudienceRegion"]) -> MetaOapg.properties.tertiaryAudienceRegion: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["originDecade"]) -> MetaOapg.properties.originDecade: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["originRegion"]) -> MetaOapg.properties.originRegion: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["languageOfPerformance"]) -> MetaOapg.properties.languageOfPerformance: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["curateability"]) -> MetaOapg.properties.curateability: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["useCase"]) -> MetaOapg.properties.useCase: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["channelSuitability"]) -> MetaOapg.properties.channelSuitability: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["primaryMoodCluster", "secondaryMoodCluster", "tertiaryMoodCluster", "valence", "arousal", "pleasantness", "engagement", "vocals", "dominantInstrument", "secondaryInstrument", "tertiaryInstrument", "energy", "soundGeneration", "tempo", "scale", "key", "rhythm", "primarySoundCharacter", "timbre", "roughness", "tonality", "harmony", "texture", "groovyness", "space", "productionRating", "performanceRating", "songRating", "audienceAge", "secondaryAudienceAge", "tertiaryAudienceAge", "audienceGender", "audienceRegion", "secondaryAudienceRegion", "tertiaryAudienceRegion", "originDecade", "originRegion", "languageOfPerformance", "curateability", "useCase", "channelSuitability", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["primaryMoodCluster"]) -> MetaOapg.properties.primaryMoodCluster: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["secondaryMoodCluster"]) -> MetaOapg.properties.secondaryMoodCluster: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tertiaryMoodCluster"]) -> MetaOapg.properties.tertiaryMoodCluster: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["valence"]) -> MetaOapg.properties.valence: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["arousal"]) -> MetaOapg.properties.arousal: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["pleasantness"]) -> MetaOapg.properties.pleasantness: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["engagement"]) -> MetaOapg.properties.engagement: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["vocals"]) -> MetaOapg.properties.vocals: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["dominantInstrument"]) -> MetaOapg.properties.dominantInstrument: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["secondaryInstrument"]) -> MetaOapg.properties.secondaryInstrument: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tertiaryInstrument"]) -> MetaOapg.properties.tertiaryInstrument: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["energy"]) -> MetaOapg.properties.energy: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["soundGeneration"]) -> MetaOapg.properties.soundGeneration: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tempo"]) -> MetaOapg.properties.tempo: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["scale"]) -> MetaOapg.properties.scale: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["key"]) -> MetaOapg.properties.key: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["rhythm"]) -> MetaOapg.properties.rhythm: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["primarySoundCharacter"]) -> MetaOapg.properties.primarySoundCharacter: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["timbre"]) -> MetaOapg.properties.timbre: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["roughness"]) -> MetaOapg.properties.roughness: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tonality"]) -> MetaOapg.properties.tonality: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["harmony"]) -> MetaOapg.properties.harmony: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["texture"]) -> MetaOapg.properties.texture: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["groovyness"]) -> MetaOapg.properties.groovyness: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["space"]) -> MetaOapg.properties.space: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["productionRating"]) -> MetaOapg.properties.productionRating: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["performanceRating"]) -> MetaOapg.properties.performanceRating: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["songRating"]) -> MetaOapg.properties.songRating: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["audienceAge"]) -> MetaOapg.properties.audienceAge: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["secondaryAudienceAge"]) -> MetaOapg.properties.secondaryAudienceAge: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tertiaryAudienceAge"]) -> MetaOapg.properties.tertiaryAudienceAge: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["audienceGender"]) -> MetaOapg.properties.audienceGender: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["audienceRegion"]) -> MetaOapg.properties.audienceRegion: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["secondaryAudienceRegion"]) -> MetaOapg.properties.secondaryAudienceRegion: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tertiaryAudienceRegion"]) -> MetaOapg.properties.tertiaryAudienceRegion: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["originDecade"]) -> MetaOapg.properties.originDecade: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["originRegion"]) -> MetaOapg.properties.originRegion: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["languageOfPerformance"]) -> MetaOapg.properties.languageOfPerformance: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["curateability"]) -> MetaOapg.properties.curateability: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["useCase"]) -> MetaOapg.properties.useCase: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["channelSuitability"]) -> MetaOapg.properties.channelSuitability: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["primaryMoodCluster", "secondaryMoodCluster", "tertiaryMoodCluster", "valence", "arousal", "pleasantness", "engagement", "vocals", "dominantInstrument", "secondaryInstrument", "tertiaryInstrument", "energy", "soundGeneration", "tempo", "scale", "key", "rhythm", "primarySoundCharacter", "timbre", "roughness", "tonality", "harmony", "texture", "groovyness", "space", "productionRating", "performanceRating", "songRating", "audienceAge", "secondaryAudienceAge", "tertiaryAudienceAge", "audienceGender", "audienceRegion", "secondaryAudienceRegion", "tertiaryAudienceRegion", "originDecade", "originRegion", "languageOfPerformance", "curateability", "useCase", "channelSuitability", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        harmony: typing.Union[MetaOapg.properties.harmony, list, tuple, ],
        dominantInstrument: typing.Union[MetaOapg.properties.dominantInstrument, list, tuple, ],
        engagement: typing.Union[MetaOapg.properties.engagement, list, tuple, ],
        originRegion: typing.Union[MetaOapg.properties.originRegion, list, tuple, ],
        pleasantness: typing.Union[MetaOapg.properties.pleasantness, list, tuple, ],
        scale: typing.Union[MetaOapg.properties.scale, list, tuple, ],
        tempo: typing.Union[MetaOapg.properties.tempo, list, tuple, ],
        tertiaryInstrument: typing.Union[MetaOapg.properties.tertiaryInstrument, list, tuple, ],
        curateability: typing.Union[MetaOapg.properties.curateability, list, tuple, ],
        audienceRegion: typing.Union[MetaOapg.properties.audienceRegion, list, tuple, ],
        space: typing.Union[MetaOapg.properties.space, list, tuple, ],
        channelSuitability: typing.Union[MetaOapg.properties.channelSuitability, list, tuple, ],
        groovyness: typing.Union[MetaOapg.properties.groovyness, list, tuple, ],
        timbre: typing.Union[MetaOapg.properties.timbre, list, tuple, ],
        productionRating: typing.Union[MetaOapg.properties.productionRating, list, tuple, ],
        tertiaryAudienceAge: typing.Union[MetaOapg.properties.tertiaryAudienceAge, list, tuple, ],
        roughness: typing.Union[MetaOapg.properties.roughness, list, tuple, ],
        songRating: typing.Union[MetaOapg.properties.songRating, list, tuple, ],
        soundGeneration: typing.Union[MetaOapg.properties.soundGeneration, list, tuple, ],
        secondaryAudienceAge: typing.Union[MetaOapg.properties.secondaryAudienceAge, list, tuple, ],
        key: typing.Union[MetaOapg.properties.key, list, tuple, ],
        secondaryMoodCluster: typing.Union[MetaOapg.properties.secondaryMoodCluster, list, tuple, ],
        tertiaryMoodCluster: typing.Union[MetaOapg.properties.tertiaryMoodCluster, list, tuple, ],
        energy: typing.Union[MetaOapg.properties.energy, list, tuple, ],
        secondaryAudienceRegion: typing.Union[MetaOapg.properties.secondaryAudienceRegion, list, tuple, ],
        audienceAge: typing.Union[MetaOapg.properties.audienceAge, list, tuple, ],
        texture: typing.Union[MetaOapg.properties.texture, list, tuple, ],
        primaryMoodCluster: typing.Union[MetaOapg.properties.primaryMoodCluster, list, tuple, ],
        tonality: typing.Union[MetaOapg.properties.tonality, list, tuple, ],
        valence: typing.Union[MetaOapg.properties.valence, list, tuple, ],
        rhythm: typing.Union[MetaOapg.properties.rhythm, list, tuple, ],
        originDecade: typing.Union[MetaOapg.properties.originDecade, list, tuple, ],
        secondaryInstrument: typing.Union[MetaOapg.properties.secondaryInstrument, list, tuple, ],
        performanceRating: typing.Union[MetaOapg.properties.performanceRating, list, tuple, ],
        useCase: typing.Union[MetaOapg.properties.useCase, list, tuple, ],
        primarySoundCharacter: typing.Union[MetaOapg.properties.primarySoundCharacter, list, tuple, ],
        languageOfPerformance: typing.Union[MetaOapg.properties.languageOfPerformance, list, tuple, ],
        audienceGender: typing.Union[MetaOapg.properties.audienceGender, list, tuple, ],
        vocals: typing.Union[MetaOapg.properties.vocals, list, tuple, ],
        tertiaryAudienceRegion: typing.Union[MetaOapg.properties.tertiaryAudienceRegion, list, tuple, ],
        arousal: typing.Union[MetaOapg.properties.arousal, list, tuple, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'SearchFilterValuesDTO':
        return super().__new__(
            cls,
            *_args,
            harmony=harmony,
            dominantInstrument=dominantInstrument,
            engagement=engagement,
            originRegion=originRegion,
            pleasantness=pleasantness,
            scale=scale,
            tempo=tempo,
            tertiaryInstrument=tertiaryInstrument,
            curateability=curateability,
            audienceRegion=audienceRegion,
            space=space,
            channelSuitability=channelSuitability,
            groovyness=groovyness,
            timbre=timbre,
            productionRating=productionRating,
            tertiaryAudienceAge=tertiaryAudienceAge,
            roughness=roughness,
            songRating=songRating,
            soundGeneration=soundGeneration,
            secondaryAudienceAge=secondaryAudienceAge,
            key=key,
            secondaryMoodCluster=secondaryMoodCluster,
            tertiaryMoodCluster=tertiaryMoodCluster,
            energy=energy,
            secondaryAudienceRegion=secondaryAudienceRegion,
            audienceAge=audienceAge,
            texture=texture,
            primaryMoodCluster=primaryMoodCluster,
            tonality=tonality,
            valence=valence,
            rhythm=rhythm,
            originDecade=originDecade,
            secondaryInstrument=secondaryInstrument,
            performanceRating=performanceRating,
            useCase=useCase,
            primarySoundCharacter=primarySoundCharacter,
            languageOfPerformance=languageOfPerformance,
            audienceGender=audienceGender,
            vocals=vocals,
            tertiaryAudienceRegion=tertiaryAudienceRegion,
            arousal=arousal,
            _configuration=_configuration,
            **kwargs,
        )
