# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.  # noqa: E501

    The version of the OpenAPI document: 1.12.21
    Contact: info@songtradr.com
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from songtradr_api_client_python import schemas  # noqa: F401


class UserDTO(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    All details on a user.
    """


    class MetaOapg:
        required = {
            "artistDetailAllowed",
            "b2bAllowed",
            "fingerprintAllowed",
            "reducedMusicalFeatures",
            "language",
            "isAdmin",
            "signupAllowed",
            "confirmed",
            "fullSearchAllowed",
            "uploadAllowed",
            "widgetsAllowed",
            "emailAddress",
            "recordingDetailAllowed",
            "voiceSearchAllowed",
            "editorAllowed",
            "playlistPredictionAllowed",
            "audiotaggingAllowed",
            "username",
        }
        
        class properties:
            username = schemas.StrSchema
            emailAddress = schemas.StrSchema
            isAdmin = schemas.BoolSchema
            fullSearchAllowed = schemas.BoolSchema
            voiceSearchAllowed = schemas.BoolSchema
            recordingDetailAllowed = schemas.BoolSchema
            artistDetailAllowed = schemas.BoolSchema
            playlistPredictionAllowed = schemas.BoolSchema
            widgetsAllowed = schemas.BoolSchema
            signupAllowed = schemas.BoolSchema
            uploadAllowed = schemas.BoolSchema
            fingerprintAllowed = schemas.BoolSchema
            audiotaggingAllowed = schemas.BoolSchema
            b2bAllowed = schemas.BoolSchema
            editorAllowed = schemas.BoolSchema
            reducedMusicalFeatures = schemas.BoolSchema
            confirmed = schemas.BoolSchema
            language = schemas.StrSchema
            companyName = schemas.StrSchema
            admin = schemas.BoolSchema
            __annotations__ = {
                "username": username,
                "emailAddress": emailAddress,
                "isAdmin": isAdmin,
                "fullSearchAllowed": fullSearchAllowed,
                "voiceSearchAllowed": voiceSearchAllowed,
                "recordingDetailAllowed": recordingDetailAllowed,
                "artistDetailAllowed": artistDetailAllowed,
                "playlistPredictionAllowed": playlistPredictionAllowed,
                "widgetsAllowed": widgetsAllowed,
                "signupAllowed": signupAllowed,
                "uploadAllowed": uploadAllowed,
                "fingerprintAllowed": fingerprintAllowed,
                "audiotaggingAllowed": audiotaggingAllowed,
                "b2bAllowed": b2bAllowed,
                "editorAllowed": editorAllowed,
                "reducedMusicalFeatures": reducedMusicalFeatures,
                "confirmed": confirmed,
                "language": language,
                "companyName": companyName,
                "admin": admin,
            }
    
    artistDetailAllowed: MetaOapg.properties.artistDetailAllowed
    b2bAllowed: MetaOapg.properties.b2bAllowed
    fingerprintAllowed: MetaOapg.properties.fingerprintAllowed
    reducedMusicalFeatures: MetaOapg.properties.reducedMusicalFeatures
    language: MetaOapg.properties.language
    isAdmin: MetaOapg.properties.isAdmin
    signupAllowed: MetaOapg.properties.signupAllowed
    confirmed: MetaOapg.properties.confirmed
    fullSearchAllowed: MetaOapg.properties.fullSearchAllowed
    uploadAllowed: MetaOapg.properties.uploadAllowed
    widgetsAllowed: MetaOapg.properties.widgetsAllowed
    emailAddress: MetaOapg.properties.emailAddress
    recordingDetailAllowed: MetaOapg.properties.recordingDetailAllowed
    voiceSearchAllowed: MetaOapg.properties.voiceSearchAllowed
    editorAllowed: MetaOapg.properties.editorAllowed
    playlistPredictionAllowed: MetaOapg.properties.playlistPredictionAllowed
    audiotaggingAllowed: MetaOapg.properties.audiotaggingAllowed
    username: MetaOapg.properties.username
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["username"]) -> MetaOapg.properties.username: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["emailAddress"]) -> MetaOapg.properties.emailAddress: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["isAdmin"]) -> MetaOapg.properties.isAdmin: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["fullSearchAllowed"]) -> MetaOapg.properties.fullSearchAllowed: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["voiceSearchAllowed"]) -> MetaOapg.properties.voiceSearchAllowed: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["recordingDetailAllowed"]) -> MetaOapg.properties.recordingDetailAllowed: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["artistDetailAllowed"]) -> MetaOapg.properties.artistDetailAllowed: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["playlistPredictionAllowed"]) -> MetaOapg.properties.playlistPredictionAllowed: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["widgetsAllowed"]) -> MetaOapg.properties.widgetsAllowed: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["signupAllowed"]) -> MetaOapg.properties.signupAllowed: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["uploadAllowed"]) -> MetaOapg.properties.uploadAllowed: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["fingerprintAllowed"]) -> MetaOapg.properties.fingerprintAllowed: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["audiotaggingAllowed"]) -> MetaOapg.properties.audiotaggingAllowed: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["b2bAllowed"]) -> MetaOapg.properties.b2bAllowed: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["editorAllowed"]) -> MetaOapg.properties.editorAllowed: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["reducedMusicalFeatures"]) -> MetaOapg.properties.reducedMusicalFeatures: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["confirmed"]) -> MetaOapg.properties.confirmed: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["language"]) -> MetaOapg.properties.language: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["companyName"]) -> MetaOapg.properties.companyName: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["admin"]) -> MetaOapg.properties.admin: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["username", "emailAddress", "isAdmin", "fullSearchAllowed", "voiceSearchAllowed", "recordingDetailAllowed", "artistDetailAllowed", "playlistPredictionAllowed", "widgetsAllowed", "signupAllowed", "uploadAllowed", "fingerprintAllowed", "audiotaggingAllowed", "b2bAllowed", "editorAllowed", "reducedMusicalFeatures", "confirmed", "language", "companyName", "admin", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["username"]) -> MetaOapg.properties.username: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["emailAddress"]) -> MetaOapg.properties.emailAddress: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["isAdmin"]) -> MetaOapg.properties.isAdmin: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["fullSearchAllowed"]) -> MetaOapg.properties.fullSearchAllowed: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["voiceSearchAllowed"]) -> MetaOapg.properties.voiceSearchAllowed: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["recordingDetailAllowed"]) -> MetaOapg.properties.recordingDetailAllowed: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["artistDetailAllowed"]) -> MetaOapg.properties.artistDetailAllowed: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["playlistPredictionAllowed"]) -> MetaOapg.properties.playlistPredictionAllowed: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["widgetsAllowed"]) -> MetaOapg.properties.widgetsAllowed: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["signupAllowed"]) -> MetaOapg.properties.signupAllowed: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["uploadAllowed"]) -> MetaOapg.properties.uploadAllowed: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["fingerprintAllowed"]) -> MetaOapg.properties.fingerprintAllowed: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["audiotaggingAllowed"]) -> MetaOapg.properties.audiotaggingAllowed: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["b2bAllowed"]) -> MetaOapg.properties.b2bAllowed: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["editorAllowed"]) -> MetaOapg.properties.editorAllowed: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["reducedMusicalFeatures"]) -> MetaOapg.properties.reducedMusicalFeatures: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["confirmed"]) -> MetaOapg.properties.confirmed: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["language"]) -> MetaOapg.properties.language: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["companyName"]) -> typing.Union[MetaOapg.properties.companyName, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["admin"]) -> typing.Union[MetaOapg.properties.admin, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["username", "emailAddress", "isAdmin", "fullSearchAllowed", "voiceSearchAllowed", "recordingDetailAllowed", "artistDetailAllowed", "playlistPredictionAllowed", "widgetsAllowed", "signupAllowed", "uploadAllowed", "fingerprintAllowed", "audiotaggingAllowed", "b2bAllowed", "editorAllowed", "reducedMusicalFeatures", "confirmed", "language", "companyName", "admin", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        artistDetailAllowed: typing.Union[MetaOapg.properties.artistDetailAllowed, bool, ],
        b2bAllowed: typing.Union[MetaOapg.properties.b2bAllowed, bool, ],
        fingerprintAllowed: typing.Union[MetaOapg.properties.fingerprintAllowed, bool, ],
        reducedMusicalFeatures: typing.Union[MetaOapg.properties.reducedMusicalFeatures, bool, ],
        language: typing.Union[MetaOapg.properties.language, str, ],
        isAdmin: typing.Union[MetaOapg.properties.isAdmin, bool, ],
        signupAllowed: typing.Union[MetaOapg.properties.signupAllowed, bool, ],
        confirmed: typing.Union[MetaOapg.properties.confirmed, bool, ],
        fullSearchAllowed: typing.Union[MetaOapg.properties.fullSearchAllowed, bool, ],
        uploadAllowed: typing.Union[MetaOapg.properties.uploadAllowed, bool, ],
        widgetsAllowed: typing.Union[MetaOapg.properties.widgetsAllowed, bool, ],
        emailAddress: typing.Union[MetaOapg.properties.emailAddress, str, ],
        recordingDetailAllowed: typing.Union[MetaOapg.properties.recordingDetailAllowed, bool, ],
        voiceSearchAllowed: typing.Union[MetaOapg.properties.voiceSearchAllowed, bool, ],
        editorAllowed: typing.Union[MetaOapg.properties.editorAllowed, bool, ],
        playlistPredictionAllowed: typing.Union[MetaOapg.properties.playlistPredictionAllowed, bool, ],
        audiotaggingAllowed: typing.Union[MetaOapg.properties.audiotaggingAllowed, bool, ],
        username: typing.Union[MetaOapg.properties.username, str, ],
        companyName: typing.Union[MetaOapg.properties.companyName, str, schemas.Unset] = schemas.unset,
        admin: typing.Union[MetaOapg.properties.admin, bool, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'UserDTO':
        return super().__new__(
            cls,
            *_args,
            artistDetailAllowed=artistDetailAllowed,
            b2bAllowed=b2bAllowed,
            fingerprintAllowed=fingerprintAllowed,
            reducedMusicalFeatures=reducedMusicalFeatures,
            language=language,
            isAdmin=isAdmin,
            signupAllowed=signupAllowed,
            confirmed=confirmed,
            fullSearchAllowed=fullSearchAllowed,
            uploadAllowed=uploadAllowed,
            widgetsAllowed=widgetsAllowed,
            emailAddress=emailAddress,
            recordingDetailAllowed=recordingDetailAllowed,
            voiceSearchAllowed=voiceSearchAllowed,
            editorAllowed=editorAllowed,
            playlistPredictionAllowed=playlistPredictionAllowed,
            audiotaggingAllowed=audiotaggingAllowed,
            username=username,
            companyName=companyName,
            admin=admin,
            _configuration=_configuration,
            **kwargs,
        )
