# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.8.2508
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from vrt_lss_studio.models.model_break import ModelBreak
from typing import Optional, Set
from typing_extensions import Self

class BreakRules(BaseModel):
    """
    Rules for accounting for breaks.
    """ # noqa: E501
    first: Optional[ModelBreak]
    consecutive: Optional[ModelBreak] = None
    relocating_duration_type: Optional[StrictStr] = Field(default='TOTAL', description="Type of accounting for time spent moving between locations (total or continuous).")
    __properties: ClassVar[List[str]] = ["first", "consecutive", "relocating_duration_type"]

    @field_validator('relocating_duration_type')
    def relocating_duration_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['TOTAL', 'CONTINUOUS']):
            raise ValueError("must be one of enum values ('TOTAL', 'CONTINUOUS')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BreakRules from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of first
        if self.first:
            _dict['first'] = self.first.to_dict()
        # override the default output from pydantic by calling `to_dict()` of consecutive
        if self.consecutive:
            _dict['consecutive'] = self.consecutive.to_dict()
        # set to None if first (nullable) is None
        # and model_fields_set contains the field
        if self.first is None and "first" in self.model_fields_set:
            _dict['first'] = None

        # set to None if consecutive (nullable) is None
        # and model_fields_set contains the field
        if self.consecutive is None and "consecutive" in self.model_fields_set:
            _dict['consecutive'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BreakRules from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "first": ModelBreak.from_dict(obj["first"]) if obj.get("first") is not None else None,
            "consecutive": ModelBreak.from_dict(obj["consecutive"]) if obj.get("consecutive") is not None else None,
            "relocating_duration_type": obj.get("relocating_duration_type") if obj.get("relocating_duration_type") is not None else 'TOTAL'
        })
        return _obj


