# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.8.2508
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from vrt_lss_studio.models.table_filter_bool_list import TableFilterBoolList
from vrt_lss_studio.models.table_filter_datetime_range import TableFilterDatetimeRange
from vrt_lss_studio.models.table_filter_enum_list import TableFilterEnumList
from vrt_lss_studio.models.table_filter_float_range import TableFilterFloatRange
from vrt_lss_studio.models.table_filter_int_range import TableFilterIntRange
from vrt_lss_studio.models.table_filter_string_list import TableFilterStringList
from vrt_lss_studio.models.table_filter_string_search import TableFilterStringSearch
from vrt_lss_studio.models.table_filter_type import TableFilterType
from vrt_lss_studio.models.table_hardlink_column_type import TableHardlinkColumnType
from typing import Optional, Set
from typing_extensions import Self

class TableHardlinkFilter(BaseModel):
    """
    Universal filter for table.
    """ # noqa: E501
    type: TableFilterType
    column: TableHardlinkColumnType
    datetime_range: Optional[TableFilterDatetimeRange] = None
    int_range: Optional[TableFilterIntRange] = None
    float_range: Optional[TableFilterFloatRange] = None
    bool_list: Optional[TableFilterBoolList] = None
    string_list: Optional[TableFilterStringList] = None
    enum_list: Optional[TableFilterEnumList] = None
    string_search: Optional[TableFilterStringSearch] = None
    __properties: ClassVar[List[str]] = ["type", "column", "datetime_range", "int_range", "float_range", "bool_list", "string_list", "enum_list", "string_search"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TableHardlinkFilter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of datetime_range
        if self.datetime_range:
            _dict['datetime_range'] = self.datetime_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of int_range
        if self.int_range:
            _dict['int_range'] = self.int_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of float_range
        if self.float_range:
            _dict['float_range'] = self.float_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of bool_list
        if self.bool_list:
            _dict['bool_list'] = self.bool_list.to_dict()
        # override the default output from pydantic by calling `to_dict()` of string_list
        if self.string_list:
            _dict['string_list'] = self.string_list.to_dict()
        # override the default output from pydantic by calling `to_dict()` of enum_list
        if self.enum_list:
            _dict['enum_list'] = self.enum_list.to_dict()
        # override the default output from pydantic by calling `to_dict()` of string_search
        if self.string_search:
            _dict['string_search'] = self.string_search.to_dict()
        # set to None if datetime_range (nullable) is None
        # and model_fields_set contains the field
        if self.datetime_range is None and "datetime_range" in self.model_fields_set:
            _dict['datetime_range'] = None

        # set to None if int_range (nullable) is None
        # and model_fields_set contains the field
        if self.int_range is None and "int_range" in self.model_fields_set:
            _dict['int_range'] = None

        # set to None if float_range (nullable) is None
        # and model_fields_set contains the field
        if self.float_range is None and "float_range" in self.model_fields_set:
            _dict['float_range'] = None

        # set to None if bool_list (nullable) is None
        # and model_fields_set contains the field
        if self.bool_list is None and "bool_list" in self.model_fields_set:
            _dict['bool_list'] = None

        # set to None if string_list (nullable) is None
        # and model_fields_set contains the field
        if self.string_list is None and "string_list" in self.model_fields_set:
            _dict['string_list'] = None

        # set to None if enum_list (nullable) is None
        # and model_fields_set contains the field
        if self.enum_list is None and "enum_list" in self.model_fields_set:
            _dict['enum_list'] = None

        # set to None if string_search (nullable) is None
        # and model_fields_set contains the field
        if self.string_search is None and "string_search" in self.model_fields_set:
            _dict['string_search'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TableHardlinkFilter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "column": obj.get("column"),
            "datetime_range": TableFilterDatetimeRange.from_dict(obj["datetime_range"]) if obj.get("datetime_range") is not None else None,
            "int_range": TableFilterIntRange.from_dict(obj["int_range"]) if obj.get("int_range") is not None else None,
            "float_range": TableFilterFloatRange.from_dict(obj["float_range"]) if obj.get("float_range") is not None else None,
            "bool_list": TableFilterBoolList.from_dict(obj["bool_list"]) if obj.get("bool_list") is not None else None,
            "string_list": TableFilterStringList.from_dict(obj["string_list"]) if obj.get("string_list") is not None else None,
            "enum_list": TableFilterEnumList.from_dict(obj["enum_list"]) if obj.get("enum_list") is not None else None,
            "string_search": TableFilterStringSearch.from_dict(obj["string_search"]) if obj.get("string_search") is not None else None
        })
        return _obj


