# coding: utf-8

"""
    Sidra API

    Sidra API  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: sidra@plainconcepts.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from SidraCoreApiPythonClient.api_client import ApiClient


class DataFactoryTriggersTriggersApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def api_datafactory_triggers_get(self, **kwargs):  # noqa: E501
        """Gets a list of triggers filtered  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_datafactory_triggers_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int skip:
        :param int take:
        :param str text:
        :param str field:
        :param bool exact_match:
        :param str sort_field:
        :param bool sort_desc:
        :param str api_version: The requested API version
        :return: FilterResponseDataFactoryTriggersTriggerFullDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_datafactory_triggers_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_datafactory_triggers_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_datafactory_triggers_get_with_http_info(self, **kwargs):  # noqa: E501
        """Gets a list of triggers filtered  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_datafactory_triggers_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int skip:
        :param int take:
        :param str text:
        :param str field:
        :param bool exact_match:
        :param str sort_field:
        :param bool sort_desc:
        :param str api_version: The requested API version
        :return: FilterResponseDataFactoryTriggersTriggerFullDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['skip', 'take', 'text', 'field', 'exact_match', 'sort_field', 'sort_desc', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_datafactory_triggers_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501
        if 'take' in params:
            query_params.append(('take', params['take']))  # noqa: E501
        if 'text' in params:
            query_params.append(('text', params['text']))  # noqa: E501
        if 'field' in params:
            query_params.append(('field', params['field']))  # noqa: E501
        if 'exact_match' in params:
            query_params.append(('exactMatch', params['exact_match']))  # noqa: E501
        if 'sort_field' in params:
            query_params.append(('sortField', params['sort_field']))  # noqa: E501
        if 'sort_desc' in params:
            query_params.append(('sortDesc', params['sort_desc']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/datafactory/triggers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FilterResponseDataFactoryTriggersTriggerFullDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_datafactory_triggers_get_all_by_template_type_async_id_trigger_template_type_get(self, id_trigger_template_type, **kwargs):  # noqa: E501
        """Gets a list of triggers by template type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_datafactory_triggers_get_all_by_template_type_async_id_trigger_template_type_get(id_trigger_template_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DataIngestionTriggerTemplateTypeEnum id_trigger_template_type: (required)
        :param str api_version: The requested API version
        :return: list[DataFactoryTriggersTriggerFullDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_datafactory_triggers_get_all_by_template_type_async_id_trigger_template_type_get_with_http_info(id_trigger_template_type, **kwargs)  # noqa: E501
        else:
            (data) = self.api_datafactory_triggers_get_all_by_template_type_async_id_trigger_template_type_get_with_http_info(id_trigger_template_type, **kwargs)  # noqa: E501
            return data

    def api_datafactory_triggers_get_all_by_template_type_async_id_trigger_template_type_get_with_http_info(self, id_trigger_template_type, **kwargs):  # noqa: E501
        """Gets a list of triggers by template type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_datafactory_triggers_get_all_by_template_type_async_id_trigger_template_type_get_with_http_info(id_trigger_template_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DataIngestionTriggerTemplateTypeEnum id_trigger_template_type: (required)
        :param str api_version: The requested API version
        :return: list[DataFactoryTriggersTriggerFullDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_trigger_template_type', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_datafactory_triggers_get_all_by_template_type_async_id_trigger_template_type_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_trigger_template_type' is set
        if ('id_trigger_template_type' not in params or
                params['id_trigger_template_type'] is None):
            raise ValueError("Missing the required parameter `id_trigger_template_type` when calling `api_datafactory_triggers_get_all_by_template_type_async_id_trigger_template_type_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_trigger_template_type' in params:
            path_params['idTriggerTemplateType'] = params['id_trigger_template_type']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/datafactory/triggers/getAllByTemplateTypeAsync/{idTriggerTemplateType}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DataFactoryTriggersTriggerFullDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_datafactory_triggers_id_delete(self, id, **kwargs):  # noqa: E501
        """Delete a specific Trigger  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_datafactory_triggers_id_delete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the Trigger to be deleted (required)
        :param bool delete_from_data_factory:
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_datafactory_triggers_id_delete_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_datafactory_triggers_id_delete_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_datafactory_triggers_id_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete a specific Trigger  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_datafactory_triggers_id_delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the Trigger to be deleted (required)
        :param bool delete_from_data_factory:
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'delete_from_data_factory', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_datafactory_triggers_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_datafactory_triggers_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'delete_from_data_factory' in params:
            query_params.append(('deleteFromDataFactory', params['delete_from_data_factory']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/datafactory/triggers/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_datafactory_triggers_id_put(self, id, **kwargs):  # noqa: E501
        """Updates a trigger by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_datafactory_triggers_id_put(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of Trigger to edit (required)
        :param DataFactoryTriggersTriggerDTO body: Model to edit Trigger
        :param str api_version: The requested API version
        :return: DataFactoryTriggersTriggerDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_datafactory_triggers_id_put_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_datafactory_triggers_id_put_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_datafactory_triggers_id_put_with_http_info(self, id, **kwargs):  # noqa: E501
        """Updates a trigger by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_datafactory_triggers_id_put_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of Trigger to edit (required)
        :param DataFactoryTriggersTriggerDTO body: Model to edit Trigger
        :param str api_version: The requested API version
        :return: DataFactoryTriggersTriggerDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_datafactory_triggers_id_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_datafactory_triggers_id_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/datafactory/triggers/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataFactoryTriggersTriggerDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_datafactory_triggers_id_trigger_pipelines_get(self, id_trigger, **kwargs):  # noqa: E501
        """Get all pipelines associated with the specific Trigger  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_datafactory_triggers_id_trigger_pipelines_get(id_trigger, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_trigger: The Trigger to query (required)
        :param str api_version: The requested API version
        :return: list[DataFactoryTriggersTriggerPipelineDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_datafactory_triggers_id_trigger_pipelines_get_with_http_info(id_trigger, **kwargs)  # noqa: E501
        else:
            (data) = self.api_datafactory_triggers_id_trigger_pipelines_get_with_http_info(id_trigger, **kwargs)  # noqa: E501
            return data

    def api_datafactory_triggers_id_trigger_pipelines_get_with_http_info(self, id_trigger, **kwargs):  # noqa: E501
        """Get all pipelines associated with the specific Trigger  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_datafactory_triggers_id_trigger_pipelines_get_with_http_info(id_trigger, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_trigger: The Trigger to query (required)
        :param str api_version: The requested API version
        :return: list[DataFactoryTriggersTriggerPipelineDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_trigger', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_datafactory_triggers_id_trigger_pipelines_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_trigger' is set
        if ('id_trigger' not in params or
                params['id_trigger'] is None):
            raise ValueError("Missing the required parameter `id_trigger` when calling `api_datafactory_triggers_id_trigger_pipelines_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_trigger' in params:
            path_params['idTrigger'] = params['id_trigger']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/datafactory/triggers/{idTrigger}/pipelines', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DataFactoryTriggersTriggerPipelineDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_datafactory_triggers_id_trigger_pipelines_id_pipeline_delete(self, id_trigger, id_pipeline, **kwargs):  # noqa: E501
        """Delete the association of the Pipeline with the Trigger  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_datafactory_triggers_id_trigger_pipelines_id_pipeline_delete(id_trigger, id_pipeline, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_trigger: The Trigger to use (required)
        :param int id_pipeline: The Pipeline to remove (required)
        :param bool delete_from_datafactory:
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_datafactory_triggers_id_trigger_pipelines_id_pipeline_delete_with_http_info(id_trigger, id_pipeline, **kwargs)  # noqa: E501
        else:
            (data) = self.api_datafactory_triggers_id_trigger_pipelines_id_pipeline_delete_with_http_info(id_trigger, id_pipeline, **kwargs)  # noqa: E501
            return data

    def api_datafactory_triggers_id_trigger_pipelines_id_pipeline_delete_with_http_info(self, id_trigger, id_pipeline, **kwargs):  # noqa: E501
        """Delete the association of the Pipeline with the Trigger  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_datafactory_triggers_id_trigger_pipelines_id_pipeline_delete_with_http_info(id_trigger, id_pipeline, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_trigger: The Trigger to use (required)
        :param int id_pipeline: The Pipeline to remove (required)
        :param bool delete_from_datafactory:
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_trigger', 'id_pipeline', 'delete_from_datafactory', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_datafactory_triggers_id_trigger_pipelines_id_pipeline_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_trigger' is set
        if ('id_trigger' not in params or
                params['id_trigger'] is None):
            raise ValueError("Missing the required parameter `id_trigger` when calling `api_datafactory_triggers_id_trigger_pipelines_id_pipeline_delete`")  # noqa: E501
        # verify the required parameter 'id_pipeline' is set
        if ('id_pipeline' not in params or
                params['id_pipeline'] is None):
            raise ValueError("Missing the required parameter `id_pipeline` when calling `api_datafactory_triggers_id_trigger_pipelines_id_pipeline_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_trigger' in params:
            path_params['idTrigger'] = params['id_trigger']  # noqa: E501
        if 'id_pipeline' in params:
            path_params['idPipeline'] = params['id_pipeline']  # noqa: E501

        query_params = []
        if 'delete_from_datafactory' in params:
            query_params.append(('deleteFromDatafactory', params['delete_from_datafactory']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/datafactory/triggers/{idTrigger}/pipelines/{idPipeline}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_datafactory_triggers_id_trigger_pipelines_id_pipeline_post(self, id_trigger, id_pipeline, **kwargs):  # noqa: E501
        """Associate a Pipeline with a Trigger  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_datafactory_triggers_id_trigger_pipelines_id_pipeline_post(id_trigger, id_pipeline, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_trigger: The Trigger to associate with (required)
        :param int id_pipeline: The Pipeline to be associated (required)
        :param str api_version: The requested API version
        :return: list[DataFactoryTriggersTriggerPipelineDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_datafactory_triggers_id_trigger_pipelines_id_pipeline_post_with_http_info(id_trigger, id_pipeline, **kwargs)  # noqa: E501
        else:
            (data) = self.api_datafactory_triggers_id_trigger_pipelines_id_pipeline_post_with_http_info(id_trigger, id_pipeline, **kwargs)  # noqa: E501
            return data

    def api_datafactory_triggers_id_trigger_pipelines_id_pipeline_post_with_http_info(self, id_trigger, id_pipeline, **kwargs):  # noqa: E501
        """Associate a Pipeline with a Trigger  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_datafactory_triggers_id_trigger_pipelines_id_pipeline_post_with_http_info(id_trigger, id_pipeline, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_trigger: The Trigger to associate with (required)
        :param int id_pipeline: The Pipeline to be associated (required)
        :param str api_version: The requested API version
        :return: list[DataFactoryTriggersTriggerPipelineDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_trigger', 'id_pipeline', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_datafactory_triggers_id_trigger_pipelines_id_pipeline_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_trigger' is set
        if ('id_trigger' not in params or
                params['id_trigger'] is None):
            raise ValueError("Missing the required parameter `id_trigger` when calling `api_datafactory_triggers_id_trigger_pipelines_id_pipeline_post`")  # noqa: E501
        # verify the required parameter 'id_pipeline' is set
        if ('id_pipeline' not in params or
                params['id_pipeline'] is None):
            raise ValueError("Missing the required parameter `id_pipeline` when calling `api_datafactory_triggers_id_trigger_pipelines_id_pipeline_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_trigger' in params:
            path_params['idTrigger'] = params['id_trigger']  # noqa: E501
        if 'id_pipeline' in params:
            path_params['idPipeline'] = params['id_pipeline']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/datafactory/triggers/{idTrigger}/pipelines/{idPipeline}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DataFactoryTriggersTriggerPipelineDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_datafactory_triggers_item_id_post(self, item_id, **kwargs):  # noqa: E501
        """Update trigger definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_datafactory_triggers_item_id_post(item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: Id of trigger to edit (required)
        :param DataFactoryTriggersTriggerUpsertDefinitionRequest body: Model to edit trigger definition
        :param str api_version: The requested API version
        :return: DataIngestionTrigger
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_datafactory_triggers_item_id_post_with_http_info(item_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_datafactory_triggers_item_id_post_with_http_info(item_id, **kwargs)  # noqa: E501
            return data

    def api_datafactory_triggers_item_id_post_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Update trigger definition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_datafactory_triggers_item_id_post_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: Id of trigger to edit (required)
        :param DataFactoryTriggersTriggerUpsertDefinitionRequest body: Model to edit trigger definition
        :param str api_version: The requested API version
        :return: DataIngestionTrigger
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_id', 'body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_datafactory_triggers_item_id_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in params or
                params['item_id'] is None):
            raise ValueError("Missing the required parameter `item_id` when calling `api_datafactory_triggers_item_id_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in params:
            path_params['itemId'] = params['item_id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/datafactory/triggers/{itemId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataIngestionTrigger',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_datafactory_triggers_pipeline_template_name_parameters_get(self, pipeline_template_name, **kwargs):  # noqa: E501
        """Get parameters needed for a specific trigger template name  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_datafactory_triggers_pipeline_template_name_parameters_get(pipeline_template_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pipeline_template_name: (required)
        :param str trigger_template_name:
        :param str api_version: The requested API version
        :return: list[DataFactoryCommonBaseParameterResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_datafactory_triggers_pipeline_template_name_parameters_get_with_http_info(pipeline_template_name, **kwargs)  # noqa: E501
        else:
            (data) = self.api_datafactory_triggers_pipeline_template_name_parameters_get_with_http_info(pipeline_template_name, **kwargs)  # noqa: E501
            return data

    def api_datafactory_triggers_pipeline_template_name_parameters_get_with_http_info(self, pipeline_template_name, **kwargs):  # noqa: E501
        """Get parameters needed for a specific trigger template name  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_datafactory_triggers_pipeline_template_name_parameters_get_with_http_info(pipeline_template_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pipeline_template_name: (required)
        :param str trigger_template_name:
        :param str api_version: The requested API version
        :return: list[DataFactoryCommonBaseParameterResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pipeline_template_name', 'trigger_template_name', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_datafactory_triggers_pipeline_template_name_parameters_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pipeline_template_name' is set
        if ('pipeline_template_name' not in params or
                params['pipeline_template_name'] is None):
            raise ValueError("Missing the required parameter `pipeline_template_name` when calling `api_datafactory_triggers_pipeline_template_name_parameters_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pipeline_template_name' in params:
            path_params['pipelineTemplateName'] = params['pipeline_template_name']  # noqa: E501

        query_params = []
        if 'trigger_template_name' in params:
            query_params.append(('triggerTemplateName', params['trigger_template_name']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/datafactory/triggers/{pipelineTemplateName}/parameters', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DataFactoryCommonBaseParameterResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_datafactory_triggers_post(self, **kwargs):  # noqa: E501
        """Creates a trigger  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_datafactory_triggers_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DataFactoryTriggersTriggerDTO body: Trigger model to create
        :param str api_version: The requested API version
        :return: DataFactoryTriggersTriggerDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_datafactory_triggers_post_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_datafactory_triggers_post_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_datafactory_triggers_post_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a trigger  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_datafactory_triggers_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DataFactoryTriggersTriggerDTO body: Trigger model to create
        :param str api_version: The requested API version
        :return: DataFactoryTriggersTriggerDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_datafactory_triggers_post" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/datafactory/triggers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataFactoryTriggersTriggerDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_trigger_by_id_async(self, id, **kwargs):  # noqa: E501
        """Get a trigger by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trigger_by_id_async(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of trigger to find (required)
        :param str api_version: The requested API version
        :return: DataFactoryTriggersTriggerFullDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_trigger_by_id_async_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_trigger_by_id_async_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_trigger_by_id_async_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a trigger by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trigger_by_id_async_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of trigger to find (required)
        :param str api_version: The requested API version
        :return: DataFactoryTriggersTriggerFullDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trigger_by_id_async" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_trigger_by_id_async`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/datafactory/triggers/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DataFactoryTriggersTriggerFullDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
