# coding: utf-8

"""
    Sidra API

    Sidra API  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: sidra@plainconcepts.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from SidraCoreApiPythonClient.api_client import ApiClient


class MetadataAttributesAttributesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def all(self, **kwargs):  # noqa: E501
        """Get the list of attributes in the system  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.all(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param datetime start_date: Date from which Entity associated will be retrieved. In {YYYY-MM-dd HH:mm:ss} format.              This value is optional and could not be provided. In case of null, it will return all Attributes from history.
        :param str api_version: The requested API version
        :return: list[CommonModelAttributeResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.all_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.all_with_http_info(**kwargs)  # noqa: E501
            return data

    def all_with_http_info(self, **kwargs):  # noqa: E501
        """Get the list of attributes in the system  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.all_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param datetime start_date: Date from which Entity associated will be retrieved. In {YYYY-MM-dd HH:mm:ss} format.              This value is optional and could not be provided. In case of null, it will return all Attributes from history.
        :param str api_version: The requested API version
        :return: list[CommonModelAttributeResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['start_date', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'start_date' in params:
            query_params.append(('startDate', params['start_date']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/attributes/all', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CommonModelAttributeResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_attributes_attribute_id_tags_get(self, attribute_id, **kwargs):  # noqa: E501
        """Get tags of this attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_attributes_attribute_id_tags_get(attribute_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int attribute_id: The Id of the Attribute to get the tags. (required)
        :param str api_version: The requested API version
        :return: list[MetadataTagsTagTagTypeFullDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_attributes_attribute_id_tags_get_with_http_info(attribute_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_attributes_attribute_id_tags_get_with_http_info(attribute_id, **kwargs)  # noqa: E501
            return data

    def api_metadata_attributes_attribute_id_tags_get_with_http_info(self, attribute_id, **kwargs):  # noqa: E501
        """Get tags of this attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_attributes_attribute_id_tags_get_with_http_info(attribute_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int attribute_id: The Id of the Attribute to get the tags. (required)
        :param str api_version: The requested API version
        :return: list[MetadataTagsTagTagTypeFullDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['attribute_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_attributes_attribute_id_tags_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'attribute_id' is set
        if ('attribute_id' not in params or
                params['attribute_id'] is None):
            raise ValueError("Missing the required parameter `attribute_id` when calling `api_metadata_attributes_attribute_id_tags_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'attribute_id' in params:
            path_params['attributeId'] = params['attribute_id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/attributes/{attributeId}/tags', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[MetadataTagsTagTagTypeFullDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_attributes_attribute_id_tags_post(self, attribute_id, **kwargs):  # noqa: E501
        """Add a Tag into an Attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_attributes_attribute_id_tags_post(attribute_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int attribute_id: Attribute where the tag is going to be added (required)
        :param MetadataTagsTagTagTypeDTO body: Tag that is going to be added
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_attributes_attribute_id_tags_post_with_http_info(attribute_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_attributes_attribute_id_tags_post_with_http_info(attribute_id, **kwargs)  # noqa: E501
            return data

    def api_metadata_attributes_attribute_id_tags_post_with_http_info(self, attribute_id, **kwargs):  # noqa: E501
        """Add a Tag into an Attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_attributes_attribute_id_tags_post_with_http_info(attribute_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int attribute_id: Attribute where the tag is going to be added (required)
        :param MetadataTagsTagTagTypeDTO body: Tag that is going to be added
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['attribute_id', 'body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_attributes_attribute_id_tags_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'attribute_id' is set
        if ('attribute_id' not in params or
                params['attribute_id'] is None):
            raise ValueError("Missing the required parameter `attribute_id` when calling `api_metadata_attributes_attribute_id_tags_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'attribute_id' in params:
            path_params['attributeId'] = params['attribute_id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/attributes/{attributeId}/tags', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_attributes_attribute_id_tags_tag_id_delete(self, attribute_id, tag_id, **kwargs):  # noqa: E501
        """Removes a Tag from an Attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_attributes_attribute_id_tags_tag_id_delete(attribute_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int attribute_id: Attribute where the tag is going to be removed (required)
        :param int tag_id: Tag that is going to be removed (required)
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_attributes_attribute_id_tags_tag_id_delete_with_http_info(attribute_id, tag_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_attributes_attribute_id_tags_tag_id_delete_with_http_info(attribute_id, tag_id, **kwargs)  # noqa: E501
            return data

    def api_metadata_attributes_attribute_id_tags_tag_id_delete_with_http_info(self, attribute_id, tag_id, **kwargs):  # noqa: E501
        """Removes a Tag from an Attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_attributes_attribute_id_tags_tag_id_delete_with_http_info(attribute_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int attribute_id: Attribute where the tag is going to be removed (required)
        :param int tag_id: Tag that is going to be removed (required)
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['attribute_id', 'tag_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_attributes_attribute_id_tags_tag_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'attribute_id' is set
        if ('attribute_id' not in params or
                params['attribute_id'] is None):
            raise ValueError("Missing the required parameter `attribute_id` when calling `api_metadata_attributes_attribute_id_tags_tag_id_delete`")  # noqa: E501
        # verify the required parameter 'tag_id' is set
        if ('tag_id' not in params or
                params['tag_id'] is None):
            raise ValueError("Missing the required parameter `tag_id` when calling `api_metadata_attributes_attribute_id_tags_tag_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'attribute_id' in params:
            path_params['attributeId'] = params['attribute_id']  # noqa: E501
        if 'tag_id' in params:
            path_params['tagId'] = params['tag_id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/attributes/{attributeId}/tags/{tagId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_attributes_get(self, **kwargs):  # noqa: E501
        """Gets a list of Attributes filtered  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_attributes_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int skip:
        :param int take:
        :param str text:
        :param str field:
        :param bool exact_match:
        :param str sort_field:
        :param bool sort_desc:
        :param str api_version: The requested API version
        :return: FilterResponseMetadataAttributesAttributeFullDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_attributes_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_attributes_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_metadata_attributes_get_with_http_info(self, **kwargs):  # noqa: E501
        """Gets a list of Attributes filtered  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_attributes_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int skip:
        :param int take:
        :param str text:
        :param str field:
        :param bool exact_match:
        :param str sort_field:
        :param bool sort_desc:
        :param str api_version: The requested API version
        :return: FilterResponseMetadataAttributesAttributeFullDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['skip', 'take', 'text', 'field', 'exact_match', 'sort_field', 'sort_desc', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_attributes_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501
        if 'take' in params:
            query_params.append(('take', params['take']))  # noqa: E501
        if 'text' in params:
            query_params.append(('text', params['text']))  # noqa: E501
        if 'field' in params:
            query_params.append(('field', params['field']))  # noqa: E501
        if 'exact_match' in params:
            query_params.append(('exactMatch', params['exact_match']))  # noqa: E501
        if 'sort_field' in params:
            query_params.append(('sortField', params['sort_field']))  # noqa: E501
        if 'sort_desc' in params:
            query_params.append(('sortDesc', params['sort_desc']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/attributes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FilterResponseMetadataAttributesAttributeFullDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_attributes_id_delete(self, id, **kwargs):  # noqa: E501
        """Delete a specific Attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_attributes_id_delete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The Id of the Attribute to remove (required)
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_attributes_id_delete_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_attributes_id_delete_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_metadata_attributes_id_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete a specific Attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_attributes_id_delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The Id of the Attribute to remove (required)
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_attributes_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_metadata_attributes_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/attributes/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_attributes_id_get(self, id, **kwargs):  # noqa: E501
        """Get a Attributes by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_attributes_id_get(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of Attributes to find (required)
        :param str api_version: The requested API version
        :return: MetadataAttributesAttributeFullDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_attributes_id_get_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_attributes_id_get_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_metadata_attributes_id_get_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a Attributes by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_attributes_id_get_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of Attributes to find (required)
        :param str api_version: The requested API version
        :return: MetadataAttributesAttributeFullDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_attributes_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_metadata_attributes_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/attributes/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetadataAttributesAttributeFullDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_attributes_id_put(self, id, **kwargs):  # noqa: E501
        """Updates a Attributes by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_attributes_id_put(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of Attribute to edit (required)
        :param MetadataAttributesAttributeFlattenedTagsFullDto body: Model to edit Attribute
        :param str api_version: The requested API version
        :return: MetadataAttributesAttributeFlattenedTagsFullDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_attributes_id_put_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_attributes_id_put_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_metadata_attributes_id_put_with_http_info(self, id, **kwargs):  # noqa: E501
        """Updates a Attributes by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_attributes_id_put_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of Attribute to edit (required)
        :param MetadataAttributesAttributeFlattenedTagsFullDto body: Model to edit Attribute
        :param str api_version: The requested API version
        :return: MetadataAttributesAttributeFlattenedTagsFullDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_attributes_id_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_metadata_attributes_id_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/attributes/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetadataAttributesAttributeFlattenedTagsFullDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_attributes_latest_get(self, **kwargs):  # noqa: E501
        """Get the list of attributes in the system  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_attributes_latest_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[int] providers_ids: IDs of the providers associated to the entities to be retrieved.
        :param datetime start_date: Date from which Entity associated will be retrieved. In {YYYY-MM-dd HH:mm:ss} format.              This value is optional and could not be provided. In case of null, it will return all Attributes from history.
        :param str api_version: The requested API version
        :return: list[CommonModelAttributeResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_attributes_latest_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_attributes_latest_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_metadata_attributes_latest_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get the list of attributes in the system  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_attributes_latest_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[int] providers_ids: IDs of the providers associated to the entities to be retrieved.
        :param datetime start_date: Date from which Entity associated will be retrieved. In {YYYY-MM-dd HH:mm:ss} format.              This value is optional and could not be provided. In case of null, it will return all Attributes from history.
        :param str api_version: The requested API version
        :return: list[CommonModelAttributeResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['providers_ids', 'start_date', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_attributes_latest_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'providers_ids' in params:
            query_params.append(('providersIds', params['providers_ids']))  # noqa: E501
            collection_formats['providersIds'] = 'multi'  # noqa: E501
        if 'start_date' in params:
            query_params.append(('startDate', params['start_date']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/attributes/latest', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CommonModelAttributeResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_attributes_post(self, **kwargs):  # noqa: E501
        """Creates a Attributes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_attributes_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MetadataAttributesAttributeDTO body: Attribute model to create
        :param str api_version: The requested API version
        :return: MetadataAttributesAttributeFullDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_attributes_post_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_attributes_post_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_metadata_attributes_post_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a Attributes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_attributes_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MetadataAttributesAttributeDTO body: Attribute model to create
        :param str api_version: The requested API version
        :return: MetadataAttributesAttributeFullDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_attributes_post" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/attributes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetadataAttributesAttributeFullDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_metadata_attributes_with_popularity_by_entity_entity_id_get(self, entity_id, **kwargs):  # noqa: E501
        """Gets the basic information of all attributes of an entity and their popularities ordered by 'Name'.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_attributes_with_popularity_by_entity_entity_id_get(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entity_id: Entity identifier. (required)
        :param bool sort_desc: Indicates if the ordering should be 'desc' or 'asc'
        :param int skip: Number of elements to skip
        :param int take: Number of elements to take
        :param str api_version: The requested API version
        :return: MetadataAttributesAttributesBasicWithPopularitiesDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_metadata_attributes_with_popularity_by_entity_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_metadata_attributes_with_popularity_by_entity_entity_id_get_with_http_info(entity_id, **kwargs)  # noqa: E501
            return data

    def api_metadata_attributes_with_popularity_by_entity_entity_id_get_with_http_info(self, entity_id, **kwargs):  # noqa: E501
        """Gets the basic information of all attributes of an entity and their popularities ordered by 'Name'.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_metadata_attributes_with_popularity_by_entity_entity_id_get_with_http_info(entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entity_id: Entity identifier. (required)
        :param bool sort_desc: Indicates if the ordering should be 'desc' or 'asc'
        :param int skip: Number of elements to skip
        :param int take: Number of elements to take
        :param str api_version: The requested API version
        :return: MetadataAttributesAttributesBasicWithPopularitiesDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'sort_desc', 'skip', 'take', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_metadata_attributes_with_popularity_by_entity_entity_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `api_metadata_attributes_with_popularity_by_entity_entity_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_id' in params:
            path_params['entityId'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'sort_desc' in params:
            query_params.append(('sortDesc', params['sort_desc']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501
        if 'take' in params:
            query_params.append(('take', params['take']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/metadata/attributes/withPopularityByEntity/{entityId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetadataAttributesAttributesBasicWithPopularitiesDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
