# coding: utf-8

"""
    Sidra API

    Sidra API  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: sidra@plainconcepts.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from SidraCoreApiPythonClient.api_client import ApiClient


class QueryQueryApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def api_query_entity_id_entity_csv_get(self, id_entity, **kwargs):  # noqa: E501
        """Execute a query and drop the result in text format in the selected storage account with the parameters provided.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_query_entity_id_entity_csv_get(id_entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_entity: The Id of the Entity from which get the information to create the query. This parameter is mandatory. (required)
        :param str storage_name: The storage name used to drop the content of the query. This parameter is mandatory.
        :param str storage_token: The URL with a SAS token to the container in the storage name to be dropped. This SAS token should contains fully permissions (read, write, list, delete, etc)/>. This parameter is mandatory.
        :param str container_name: The container name where the content will be dropped inside the storageName. Should be the same as included in the storageToken.  This parameter is mandatory.
        :param str output_folder_name: Output folder where the content will be dropped inside the containerName.  This parameter is mandatory.
        :param str comma_separated_attributes: Comma separated list of attributes to select in the query. This parameter is mandatory.
        :param str filter_expression: Condition included in the where clause to filter the selection. This parameter is optional.
        :param list[int] id_source_items: Array of ids of SourceItems that will be used to filter the selection in the where clause.
        :param bool include_data_with_errors: True to include data without HasErrors = TRUE in the query. False by default.
        :param bool overwrite: Overwrite the content present in the outputFolderName when the query drops the result. If FALSE and there are content, the query will fail as it cannot overwrite. True by default.
        :param str row_sepataror_character: Optional: Separator char to split the file. Default value is PlainConcepts.Sidra.API.Query.Model.Output.CSVQueryOutput.DEFAULT_ROW_SEPARATOR
        :param str null_value_replacement: Optional: Separator char to print null values the file. Default value is PlainConcepts.Sidra.API.Query.Model.Output.CSVQueryOutput.NullValue
        :param str encoding: Optional: Separator char to encode the file. Default value is PlainConcepts.Sidra.API.Query.Model.Output.CSVQueryOutput.Encoding
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_query_entity_id_entity_csv_get_with_http_info(id_entity, **kwargs)  # noqa: E501
        else:
            (data) = self.api_query_entity_id_entity_csv_get_with_http_info(id_entity, **kwargs)  # noqa: E501
            return data

    def api_query_entity_id_entity_csv_get_with_http_info(self, id_entity, **kwargs):  # noqa: E501
        """Execute a query and drop the result in text format in the selected storage account with the parameters provided.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_query_entity_id_entity_csv_get_with_http_info(id_entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_entity: The Id of the Entity from which get the information to create the query. This parameter is mandatory. (required)
        :param str storage_name: The storage name used to drop the content of the query. This parameter is mandatory.
        :param str storage_token: The URL with a SAS token to the container in the storage name to be dropped. This SAS token should contains fully permissions (read, write, list, delete, etc)/>. This parameter is mandatory.
        :param str container_name: The container name where the content will be dropped inside the storageName. Should be the same as included in the storageToken.  This parameter is mandatory.
        :param str output_folder_name: Output folder where the content will be dropped inside the containerName.  This parameter is mandatory.
        :param str comma_separated_attributes: Comma separated list of attributes to select in the query. This parameter is mandatory.
        :param str filter_expression: Condition included in the where clause to filter the selection. This parameter is optional.
        :param list[int] id_source_items: Array of ids of SourceItems that will be used to filter the selection in the where clause.
        :param bool include_data_with_errors: True to include data without HasErrors = TRUE in the query. False by default.
        :param bool overwrite: Overwrite the content present in the outputFolderName when the query drops the result. If FALSE and there are content, the query will fail as it cannot overwrite. True by default.
        :param str row_sepataror_character: Optional: Separator char to split the file. Default value is PlainConcepts.Sidra.API.Query.Model.Output.CSVQueryOutput.DEFAULT_ROW_SEPARATOR
        :param str null_value_replacement: Optional: Separator char to print null values the file. Default value is PlainConcepts.Sidra.API.Query.Model.Output.CSVQueryOutput.NullValue
        :param str encoding: Optional: Separator char to encode the file. Default value is PlainConcepts.Sidra.API.Query.Model.Output.CSVQueryOutput.Encoding
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_entity', 'storage_name', 'storage_token', 'container_name', 'output_folder_name', 'comma_separated_attributes', 'filter_expression', 'id_source_items', 'include_data_with_errors', 'overwrite', 'row_sepataror_character', 'null_value_replacement', 'encoding', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_query_entity_id_entity_csv_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_entity' is set
        if ('id_entity' not in params or
                params['id_entity'] is None):
            raise ValueError("Missing the required parameter `id_entity` when calling `api_query_entity_id_entity_csv_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_entity' in params:
            path_params['idEntity'] = params['id_entity']  # noqa: E501

        query_params = []
        if 'storage_name' in params:
            query_params.append(('storageName', params['storage_name']))  # noqa: E501
        if 'storage_token' in params:
            query_params.append(('storageToken', params['storage_token']))  # noqa: E501
        if 'container_name' in params:
            query_params.append(('containerName', params['container_name']))  # noqa: E501
        if 'output_folder_name' in params:
            query_params.append(('outputFolderName', params['output_folder_name']))  # noqa: E501
        if 'comma_separated_attributes' in params:
            query_params.append(('commaSeparatedAttributes', params['comma_separated_attributes']))  # noqa: E501
        if 'filter_expression' in params:
            query_params.append(('filterExpression', params['filter_expression']))  # noqa: E501
        if 'id_source_items' in params:
            query_params.append(('idSourceItems', params['id_source_items']))  # noqa: E501
            collection_formats['idSourceItems'] = 'multi'  # noqa: E501
        if 'include_data_with_errors' in params:
            query_params.append(('includeDataWithErrors', params['include_data_with_errors']))  # noqa: E501
        if 'overwrite' in params:
            query_params.append(('overwrite', params['overwrite']))  # noqa: E501
        if 'row_sepataror_character' in params:
            query_params.append(('rowSepatarorCharacter', params['row_sepataror_character']))  # noqa: E501
        if 'null_value_replacement' in params:
            query_params.append(('nullValueReplacement', params['null_value_replacement']))  # noqa: E501
        if 'encoding' in params:
            query_params.append(('encoding', params['encoding']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/Query/entity/{idEntity}/csv', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_query_entity_id_entity_csv_post(self, id_entity, **kwargs):  # noqa: E501
        """Execute a query and drop the result in text format in the selected storage account with the parameters provided.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_query_entity_id_entity_csv_post(id_entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_entity: (required)
        :param QueryQueryRequestDtoTextOutput body: Object containing the details of the query to execute
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_query_entity_id_entity_csv_post_with_http_info(id_entity, **kwargs)  # noqa: E501
        else:
            (data) = self.api_query_entity_id_entity_csv_post_with_http_info(id_entity, **kwargs)  # noqa: E501
            return data

    def api_query_entity_id_entity_csv_post_with_http_info(self, id_entity, **kwargs):  # noqa: E501
        """Execute a query and drop the result in text format in the selected storage account with the parameters provided.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_query_entity_id_entity_csv_post_with_http_info(id_entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_entity: (required)
        :param QueryQueryRequestDtoTextOutput body: Object containing the details of the query to execute
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_entity', 'body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_query_entity_id_entity_csv_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_entity' is set
        if ('id_entity' not in params or
                params['id_entity'] is None):
            raise ValueError("Missing the required parameter `id_entity` when calling `api_query_entity_id_entity_csv_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_entity' in params:
            path_params['idEntity'] = params['id_entity']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/Query/entity/{idEntity}/csv', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_query_entity_id_entity_parquet_get(self, id_entity, **kwargs):  # noqa: E501
        """Execute a query and drop the result in parquet format in the selected storage account with the parameters provided.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_query_entity_id_entity_parquet_get(id_entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_entity: The Id of the Entity from which get the information to create the query. This parameter is mandatory. (required)
        :param str storage_name: The storage name used to drop the content of the query. This parameter is mandatory.
        :param str storage_token: The URL with a SAS token to the container in the storage name to be dropped. This SAS token should contains fully permissions (read, write, list, delete, etc)/>. This parameter is mandatory.
        :param str container_name: The container name where the content will be dropped inside the storageName. Should be the same as included in the storageToken.  This parameter is mandatory.
        :param str output_folder_name: Output folder where the content will be dropped inside the containerName.  This parameter is mandatory.
        :param str comma_separated_attributes: Comma separated list of attributes to select in the query. This parameter is mandatory.
        :param str filter_expression: Condition included in the where clause to filter the selection. This parameter is optional.
        :param list[int] id_source_items: Array of ids of SourceItems that will be used to filter the selection in the where clause.
        :param bool include_data_with_errors: True to include data without HasErrors = TRUE in the query. False by default.
        :param bool overwrite: Overwrite the content present in the outputFolderName when the query drops the result. If FALSE the content will be appended to the existing one. True by default.
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_query_entity_id_entity_parquet_get_with_http_info(id_entity, **kwargs)  # noqa: E501
        else:
            (data) = self.api_query_entity_id_entity_parquet_get_with_http_info(id_entity, **kwargs)  # noqa: E501
            return data

    def api_query_entity_id_entity_parquet_get_with_http_info(self, id_entity, **kwargs):  # noqa: E501
        """Execute a query and drop the result in parquet format in the selected storage account with the parameters provided.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_query_entity_id_entity_parquet_get_with_http_info(id_entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id_entity: The Id of the Entity from which get the information to create the query. This parameter is mandatory. (required)
        :param str storage_name: The storage name used to drop the content of the query. This parameter is mandatory.
        :param str storage_token: The URL with a SAS token to the container in the storage name to be dropped. This SAS token should contains fully permissions (read, write, list, delete, etc)/>. This parameter is mandatory.
        :param str container_name: The container name where the content will be dropped inside the storageName. Should be the same as included in the storageToken.  This parameter is mandatory.
        :param str output_folder_name: Output folder where the content will be dropped inside the containerName.  This parameter is mandatory.
        :param str comma_separated_attributes: Comma separated list of attributes to select in the query. This parameter is mandatory.
        :param str filter_expression: Condition included in the where clause to filter the selection. This parameter is optional.
        :param list[int] id_source_items: Array of ids of SourceItems that will be used to filter the selection in the where clause.
        :param bool include_data_with_errors: True to include data without HasErrors = TRUE in the query. False by default.
        :param bool overwrite: Overwrite the content present in the outputFolderName when the query drops the result. If FALSE the content will be appended to the existing one. True by default.
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_entity', 'storage_name', 'storage_token', 'container_name', 'output_folder_name', 'comma_separated_attributes', 'filter_expression', 'id_source_items', 'include_data_with_errors', 'overwrite', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_query_entity_id_entity_parquet_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_entity' is set
        if ('id_entity' not in params or
                params['id_entity'] is None):
            raise ValueError("Missing the required parameter `id_entity` when calling `api_query_entity_id_entity_parquet_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_entity' in params:
            path_params['idEntity'] = params['id_entity']  # noqa: E501

        query_params = []
        if 'storage_name' in params:
            query_params.append(('storageName', params['storage_name']))  # noqa: E501
        if 'storage_token' in params:
            query_params.append(('storageToken', params['storage_token']))  # noqa: E501
        if 'container_name' in params:
            query_params.append(('containerName', params['container_name']))  # noqa: E501
        if 'output_folder_name' in params:
            query_params.append(('outputFolderName', params['output_folder_name']))  # noqa: E501
        if 'comma_separated_attributes' in params:
            query_params.append(('commaSeparatedAttributes', params['comma_separated_attributes']))  # noqa: E501
        if 'filter_expression' in params:
            query_params.append(('filterExpression', params['filter_expression']))  # noqa: E501
        if 'id_source_items' in params:
            query_params.append(('idSourceItems', params['id_source_items']))  # noqa: E501
            collection_formats['idSourceItems'] = 'multi'  # noqa: E501
        if 'include_data_with_errors' in params:
            query_params.append(('includeDataWithErrors', params['include_data_with_errors']))  # noqa: E501
        if 'overwrite' in params:
            query_params.append(('overwrite', params['overwrite']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/Query/entity/{idEntity}/parquet', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_query_entity_id_entity_parquet_post(self, id_entity, **kwargs):  # noqa: E501
        """Execute a query and drop the result in parquet format in the selected storage account with the parameters provided.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_query_entity_id_entity_parquet_post(id_entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_entity: (required)
        :param QueryQueryRequestDto body: Object containing the details of the query to execute
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_query_entity_id_entity_parquet_post_with_http_info(id_entity, **kwargs)  # noqa: E501
        else:
            (data) = self.api_query_entity_id_entity_parquet_post_with_http_info(id_entity, **kwargs)  # noqa: E501
            return data

    def api_query_entity_id_entity_parquet_post_with_http_info(self, id_entity, **kwargs):  # noqa: E501
        """Execute a query and drop the result in parquet format in the selected storage account with the parameters provided.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_query_entity_id_entity_parquet_post_with_http_info(id_entity, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_entity: (required)
        :param QueryQueryRequestDto body: Object containing the details of the query to execute
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_entity', 'body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_query_entity_id_entity_parquet_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_entity' is set
        if ('id_entity' not in params or
                params['id_entity'] is None):
            raise ValueError("Missing the required parameter `id_entity` when calling `api_query_entity_id_entity_parquet_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_entity' in params:
            path_params['idEntity'] = params['id_entity']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/Query/entity/{idEntity}/parquet', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_status_route(self, run_id, **kwargs):  # noqa: E501
        """Gets the information of the execution status of a query and the SAS tokens to access to the results in case it has finished.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_status_route(run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int run_id: RunId of the query to check (required)
        :param str polling_token: The polling token that contains the information about the query execution to check. This parameter is mandatory.
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.query_status_route_with_http_info(run_id, **kwargs)  # noqa: E501
        else:
            (data) = self.query_status_route_with_http_info(run_id, **kwargs)  # noqa: E501
            return data

    def query_status_route_with_http_info(self, run_id, **kwargs):  # noqa: E501
        """Gets the information of the execution status of a query and the SAS tokens to access to the results in case it has finished.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_status_route_with_http_info(run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int run_id: RunId of the query to check (required)
        :param str polling_token: The polling token that contains the information about the query execution to check. This parameter is mandatory.
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['run_id', 'polling_token', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_status_route" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'run_id' is set
        if ('run_id' not in params or
                params['run_id'] is None):
            raise ValueError("Missing the required parameter `run_id` when calling `query_status_route`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'run_id' in params:
            path_params['runId'] = params['run_id']  # noqa: E501

        query_params = []
        if 'polling_token' in params:
            query_params.append(('pollingToken', params['polling_token']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/Query/{runId}/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
