# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetIpToSgtMappingGroupResult',
    'AwaitableGetIpToSgtMappingGroupResult',
    'get_ip_to_sgt_mapping_group',
    'get_ip_to_sgt_mapping_group_output',
]

@pulumi.output_type
class GetIpToSgtMappingGroupResult:
    """
    A collection of values returned by getIpToSgtMappingGroup.
    """
    def __init__(__self__, deploy_to=None, deploy_type=None, description=None, id=None, name=None, sgt=None):
        if deploy_to and not isinstance(deploy_to, str):
            raise TypeError("Expected argument 'deploy_to' to be a str")
        pulumi.set(__self__, "deploy_to", deploy_to)
        if deploy_type and not isinstance(deploy_type, str):
            raise TypeError("Expected argument 'deploy_type' to be a str")
        pulumi.set(__self__, "deploy_type", deploy_type)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if sgt and not isinstance(sgt, str):
            raise TypeError("Expected argument 'sgt' to be a str")
        pulumi.set(__self__, "sgt", sgt)

    @property
    @pulumi.getter(name="deployTo")
    def deploy_to(self) -> str:
        """
        Mandatory unless `deploy_type` is `ALL`
        """
        return pulumi.get(self, "deploy_to")

    @property
    @pulumi.getter(name="deployType")
    def deploy_type(self) -> str:
        """
        Deploy Type
        """
        return pulumi.get(self, "deploy_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the object
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the IP to SGT mapping Group
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def sgt(self) -> str:
        """
        Trustsec Security Group ID
        """
        return pulumi.get(self, "sgt")


class AwaitableGetIpToSgtMappingGroupResult(GetIpToSgtMappingGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpToSgtMappingGroupResult(
            deploy_to=self.deploy_to,
            deploy_type=self.deploy_type,
            description=self.description,
            id=self.id,
            name=self.name,
            sgt=self.sgt)


def get_ip_to_sgt_mapping_group(id: Optional[str] = None,
                                name: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpToSgtMappingGroupResult:
    """
    This data source can read the TrustSec IP to SGT Mapping Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ise as ise

    example = ise.trustsec.get_ip_to_sgt_mapping_group(id="76d24097-41c4-4558-a4d0-a8c07ac08470")
    ```


    :param str id: The id of the object
    :param str name: The name of the IP to SGT mapping Group
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ise:trustsec/getIpToSgtMappingGroup:getIpToSgtMappingGroup', __args__, opts=opts, typ=GetIpToSgtMappingGroupResult).value

    return AwaitableGetIpToSgtMappingGroupResult(
        deploy_to=pulumi.get(__ret__, 'deploy_to'),
        deploy_type=pulumi.get(__ret__, 'deploy_type'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        sgt=pulumi.get(__ret__, 'sgt'))


@_utilities.lift_output_func(get_ip_to_sgt_mapping_group)
def get_ip_to_sgt_mapping_group_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                                       name: Optional[pulumi.Input[Optional[str]]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIpToSgtMappingGroupResult]:
    """
    This data source can read the TrustSec IP to SGT Mapping Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ise as ise

    example = ise.trustsec.get_ip_to_sgt_mapping_group(id="76d24097-41c4-4558-a4d0-a8c07ac08470")
    ```


    :param str id: The id of the object
    :param str name: The name of the IP to SGT mapping Group
    """
    ...
