"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const route53 = require("@aws-cdk/aws-route53");
const cdk = require("@aws-cdk/core");
const targets = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-interface-vpc-endpoint', {
    env: {
        region: 'us-west-2',
    },
});
const vpc = new ec2.Vpc(stack, 'VPC');
const interfaceVpcEndpoint = new ec2.InterfaceVpcEndpoint(stack, 'InterfaceEndpoint', {
    vpc,
    service: {
        name: 'com.amazonaws.us-west-2.sms',
        port: 80,
    },
    privateDnsEnabled: false,
    subnets: {
        subnetType: ec2.SubnetType.PRIVATE,
    },
});
const zone = new route53.PrivateHostedZone(stack, 'PrivateZone', {
    vpc,
    zoneName: 'test.aws.cdk.com',
});
new route53.ARecord(stack, 'AliasEndpointRecord', {
    zone,
    recordName: 'foo',
    target: route53.RecordTarget.fromAlias(new targets.InterfaceVpcEndpointTarget(interfaceVpcEndpoint)),
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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