"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const aws_cognito_1 = require("@aws-cdk/aws-cognito");
const aws_route53_1 = require("@aws-cdk/aws-route53");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
test('use user pool domain as record target', () => {
    // GIVEN
    const stack = new core_1.Stack();
    const zone = new aws_route53_1.PublicHostedZone(stack, 'HostedZone', { zoneName: 'test.public' });
    const userPool = new aws_cognito_1.UserPool(stack, 'UserPool');
    const domain = new aws_cognito_1.UserPoolDomain(stack, 'UserPoolDomain', {
        userPool,
        cognitoDomain: { domainPrefix: 'domain-prefix' },
    });
    // WHEN
    new aws_route53_1.ARecord(zone, 'Alias', {
        zone,
        target: aws_route53_1.RecordTarget.fromAlias(new lib_1.UserPoolDomainTarget(domain)),
    });
    // THEN
    expect(stack).toHaveResource('AWS::Route53::RecordSet', {
        AliasTarget: {
            DNSName: {
                'Fn::GetAtt': ['UserPoolDomainCloudFrontDomainName0B254952', 'DomainDescription.CloudFrontDistribution'],
            },
            HostedZoneId: {
                'Fn::FindInMap': [
                    'AWSCloudFrontPartitionHostedZoneIdMap',
                    {
                        Ref: 'AWS::Partition',
                    },
                    'zoneId',
                ],
            },
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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