/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime.functionmanager;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.ray.runtime.functionmanager.FunctionDescriptor;
import org.ray.runtime.generated.Common;

public final class JavaFunctionDescriptor
implements FunctionDescriptor {
    public final String className;
    public final String name;
    public final String signature;

    public JavaFunctionDescriptor(String className, String name, String signature) {
        this.className = className;
        this.name = name;
        this.signature = signature;
    }

    public String toString() {
        return this.className + "." + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaFunctionDescriptor that = (JavaFunctionDescriptor)o;
        return Objects.equal(this.className, that.className) && Objects.equal(this.name, that.name) && Objects.equal(this.signature, that.signature);
    }

    public int hashCode() {
        return Objects.hashCode(this.className, this.name, this.signature);
    }

    @Override
    public List<String> toList() {
        return ImmutableList.of(this.className, this.name, this.signature);
    }

    @Override
    public Common.Language getLanguage() {
        return Common.Language.JAVA;
    }
}

