/*
 * Decompiled with CFR 0.152.
 */
package org.ray.runtime.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;

public class BinaryFileUtil {
    public static final String REDIS_SERVER_BINARY_NAME = "redis-server";
    public static final String GCS_SERVER_BINARY_NAME = "gcs_server";
    public static final String PLASMA_STORE_SERVER_BINARY_NAME = "plasma_store_server";
    public static final String RAYLET_BINARY_NAME = "raylet";
    public static final String REDIS_MODULE_LIBRARY_NAME = "libray_redis_module.so";
    public static final String CORE_WORKER_JAVA_LIBRARY = System.mapLibraryName("core_worker_library_java");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File getFile(String destDir, String fileName) {
        File dir = new File(destDir);
        if (!dir.exists()) {
            try {
                FileUtils.forceMkdir(dir);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't make directory: " + dir.getAbsolutePath(), e);
            }
        }
        String lockFilePath = destDir + File.separator + "file_lock";
        try (FileLock ignored = new RandomAccessFile(lockFilePath, "rw").getChannel().lock();){
            File file2 = new File(String.format("%s/%s", destDir, fileName));
            if (file2.exists()) {
                File file3 = file2;
                return file3;
            }
            try (InputStream is = BinaryFileUtil.class.getResourceAsStream("/" + fileName);){
                Preconditions.checkNotNull(is, "{} doesn't exist.", (Object)fileName);
                Files.copy(is, Paths.get(file2.getCanonicalPath(), new String[0]), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't get temp file from resource " + fileName, e);
            }
            File file = file2;
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

