/*
 * Decompiled with CFR 0.152.
 */
package org.ray.streaming.runtime.core.processor;

import org.ray.streaming.operator.OneInputOperator;
import org.ray.streaming.operator.OperatorType;
import org.ray.streaming.operator.StreamOperator;
import org.ray.streaming.operator.TwoInputOperator;
import org.ray.streaming.operator.impl.SourceOperator;
import org.ray.streaming.runtime.core.processor.OneInputProcessor;
import org.ray.streaming.runtime.core.processor.SourceProcessor;
import org.ray.streaming.runtime.core.processor.StreamProcessor;
import org.ray.streaming.runtime.core.processor.TwoInputProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessBuilder.class);

    public static StreamProcessor buildProcessor(StreamOperator streamOperator) {
        OperatorType type = streamOperator.getOpType();
        LOGGER.info("Building StreamProcessor, operator type = {}, operator = {}.", (Object)type, (Object)streamOperator.getClass().getSimpleName().toString());
        switch (type) {
            case SOURCE: {
                return new SourceProcessor((SourceOperator)streamOperator);
            }
            case ONE_INPUT: {
                return new OneInputProcessor((OneInputOperator)((Object)streamOperator));
            }
            case TWO_INPUT: {
                return new TwoInputProcessor((TwoInputOperator)((Object)streamOperator));
            }
        }
        throw new RuntimeException("current operator type is not support");
    }
}

