from typing import Any, Dict, List, Optional

import httpx
from staffology.propagate_exceptions import raise_staffology_exception

from ...client import Client
from ...models.employer_evc_opt_in_history import EmployerEvcOptInHistory
from ...types import Response


def _get_kwargs(
    id: str,
    *,
    client: Client,
) -> Dict[str, Any]:
    url = "{}/employers/{id}/evc".format(client.base_url, id=id)

    headers: Dict[str, str] = client.get_headers()
    cookies: Dict[str, Any] = client.get_cookies()

    return {
        "method": "get",
        "url": url,
        "headers": headers,
        "cookies": cookies,
        "timeout": client.get_timeout(),
    }


def _parse_response(*, response: httpx.Response) -> Optional[List[EmployerEvcOptInHistory]]:
    if response.status_code == 200:
        response_200 = []
        _response_200 = response.json()
        for response_200_item_data in _response_200:
            response_200_item = EmployerEvcOptInHistory.from_dict(response_200_item_data)

            response_200.append(response_200_item)

        return response_200
    return raise_staffology_exception(response)


def _build_response(*, response: httpx.Response) -> Response[List[EmployerEvcOptInHistory]]:
    return Response(
        status_code=response.status_code,
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(response=response),
    )


def sync_detailed(
    id: str,
    *,
    client: Client,
) -> Response[List[EmployerEvcOptInHistory]]:
    """Get EVC OptIn History

     Gets the history of changes to the EVC OptIn setting for the employer.

    Args:
        id (str):

    Returns:
        Response[List[EmployerEvcOptInHistory]]
    """

    kwargs = _get_kwargs(
        id=id,
        client=client,
    )

    response = httpx.request(
        verify=client.verify_ssl,
        **kwargs,
    )

    return _build_response(response=response)


def sync(
    id: str,
    *,
    client: Client,
) -> Optional[List[EmployerEvcOptInHistory]]:
    """Get EVC OptIn History

     Gets the history of changes to the EVC OptIn setting for the employer.

    Args:
        id (str):

    Returns:
        Response[List[EmployerEvcOptInHistory]]
    """

    return sync_detailed(
        id=id,
        client=client,
    ).parsed


async def asyncio_detailed(
    id: str,
    *,
    client: Client,
) -> Response[List[EmployerEvcOptInHistory]]:
    """Get EVC OptIn History

     Gets the history of changes to the EVC OptIn setting for the employer.

    Args:
        id (str):

    Returns:
        Response[List[EmployerEvcOptInHistory]]
    """

    kwargs = _get_kwargs(
        id=id,
        client=client,
    )

    async with httpx.AsyncClient(verify=client.verify_ssl) as _client:
        response = await _client.request(**kwargs)

    return _build_response(response=response)


async def asyncio(
    id: str,
    *,
    client: Client,
) -> Optional[List[EmployerEvcOptInHistory]]:
    """Get EVC OptIn History

     Gets the history of changes to the EVC OptIn setting for the employer.

    Args:
        id (str):

    Returns:
        Response[List[EmployerEvcOptInHistory]]
    """

    return (
        await asyncio_detailed(
            id=id,
            client=client,
        )
    ).parsed
