from typing import Any, Dict, Optional, Union

import httpx
from staffology.propagate_exceptions import raise_staffology_exception

from ...client import Client
from ...models.pay_periods import PayPeriods
from ...models.report_response import ReportResponse
from ...models.tax_year import TaxYear
from ...types import UNSET, Response, Unset


def _get_kwargs(
    employer_id: str,
    tax_year: TaxYear,
    pay_period: PayPeriods,
    period_number: int,
    *,
    client: Client,
    ordinal: Union[Unset, None, int] = 1,
    unemailed: Union[Unset, None, bool] = False,
    dept_code: Union[Unset, None, str] = UNSET,
    employee_filter: Union[Unset, None, str] = UNSET,
    accept: Union[Unset, str] = UNSET,

) -> Dict[str, Any]:
    url = "{}/employers/{employerId}/reports/{taxYear}/{payPeriod}/{periodNumber}/payslips".format(
        client.base_url,employerId=employer_id,taxYear=tax_year,payPeriod=pay_period,periodNumber=period_number)

    headers: Dict[str, str] = client.get_headers()
    cookies: Dict[str, Any] = client.get_cookies()

    if not isinstance(accept, Unset):
        headers["accept"] = accept



    

    params: Dict[str, Any] = {}
    params["ordinal"] = ordinal


    params["unemailed"] = unemailed


    params["deptCode"] = dept_code


    params["employeeFilter"] = employee_filter



    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}


    

    

    return {
	    "method": "get",
        "url": url,
        "headers": headers,
        "cookies": cookies,
        "timeout": client.get_timeout(),
        "params": params,
    }


def _parse_response(*, response: httpx.Response) -> Optional[ReportResponse]:
    if response.status_code == 200:
        response_200 = ReportResponse.from_dict(response.json())



        return response_200
    return raise_staffology_exception(response)


def _build_response(*, response: httpx.Response) -> Response[ReportResponse]:
    return Response(
        status_code=response.status_code,
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(response=response),
    )


def sync_detailed(
    employer_id: str,
    tax_year: TaxYear,
    pay_period: PayPeriods,
    period_number: int,
    *,
    client: Client,
    ordinal: Union[Unset, None, int] = 1,
    unemailed: Union[Unset, None, bool] = False,
    dept_code: Union[Unset, None, str] = UNSET,
    employee_filter: Union[Unset, None, str] = UNSET,
    accept: Union[Unset, str] = UNSET,

) -> Response[ReportResponse]:
    """Payslips

     Returns all Payslips for the given PayRun
    If you set the accept header to \"text/html\" then unlike other reports the html is NOT in the
    ```Content``` field.
    As there are multiple HTML documents they are encoded as a JSON array of strings in the ```Model```
    field.

    Args:
        employer_id (str):
        tax_year (TaxYear):
        pay_period (PayPeriods):
        period_number (int):
        ordinal (Union[Unset, None, int]):  Default: 1.
        unemailed (Union[Unset, None, bool]):
        dept_code (Union[Unset, None, str]):
        employee_filter (Union[Unset, None, str]):
        accept (Union[Unset, str]):

    Returns:
        Response[ReportResponse]
    """


    kwargs = _get_kwargs(
        employer_id=employer_id,
tax_year=tax_year,
pay_period=pay_period,
period_number=period_number,
client=client,
ordinal=ordinal,
unemailed=unemailed,
dept_code=dept_code,
employee_filter=employee_filter,
accept=accept,

    )

    response = httpx.request(
        verify=client.verify_ssl,
        **kwargs,
    )

    return _build_response(response=response)

def sync(
    employer_id: str,
    tax_year: TaxYear,
    pay_period: PayPeriods,
    period_number: int,
    *,
    client: Client,
    ordinal: Union[Unset, None, int] = 1,
    unemailed: Union[Unset, None, bool] = False,
    dept_code: Union[Unset, None, str] = UNSET,
    employee_filter: Union[Unset, None, str] = UNSET,
    accept: Union[Unset, str] = UNSET,

) -> Optional[ReportResponse]:
    """Payslips

     Returns all Payslips for the given PayRun
    If you set the accept header to \"text/html\" then unlike other reports the html is NOT in the
    ```Content``` field.
    As there are multiple HTML documents they are encoded as a JSON array of strings in the ```Model```
    field.

    Args:
        employer_id (str):
        tax_year (TaxYear):
        pay_period (PayPeriods):
        period_number (int):
        ordinal (Union[Unset, None, int]):  Default: 1.
        unemailed (Union[Unset, None, bool]):
        dept_code (Union[Unset, None, str]):
        employee_filter (Union[Unset, None, str]):
        accept (Union[Unset, str]):

    Returns:
        Response[ReportResponse]
    """


    return sync_detailed(
        employer_id=employer_id,
tax_year=tax_year,
pay_period=pay_period,
period_number=period_number,
client=client,
ordinal=ordinal,
unemailed=unemailed,
dept_code=dept_code,
employee_filter=employee_filter,
accept=accept,

    ).parsed

async def asyncio_detailed(
    employer_id: str,
    tax_year: TaxYear,
    pay_period: PayPeriods,
    period_number: int,
    *,
    client: Client,
    ordinal: Union[Unset, None, int] = 1,
    unemailed: Union[Unset, None, bool] = False,
    dept_code: Union[Unset, None, str] = UNSET,
    employee_filter: Union[Unset, None, str] = UNSET,
    accept: Union[Unset, str] = UNSET,

) -> Response[ReportResponse]:
    """Payslips

     Returns all Payslips for the given PayRun
    If you set the accept header to \"text/html\" then unlike other reports the html is NOT in the
    ```Content``` field.
    As there are multiple HTML documents they are encoded as a JSON array of strings in the ```Model```
    field.

    Args:
        employer_id (str):
        tax_year (TaxYear):
        pay_period (PayPeriods):
        period_number (int):
        ordinal (Union[Unset, None, int]):  Default: 1.
        unemailed (Union[Unset, None, bool]):
        dept_code (Union[Unset, None, str]):
        employee_filter (Union[Unset, None, str]):
        accept (Union[Unset, str]):

    Returns:
        Response[ReportResponse]
    """


    kwargs = _get_kwargs(
        employer_id=employer_id,
tax_year=tax_year,
pay_period=pay_period,
period_number=period_number,
client=client,
ordinal=ordinal,
unemailed=unemailed,
dept_code=dept_code,
employee_filter=employee_filter,
accept=accept,

    )

    async with httpx.AsyncClient(verify=client.verify_ssl) as _client:
        response = await _client.request(
            **kwargs
        )

    return _build_response(response=response)

async def asyncio(
    employer_id: str,
    tax_year: TaxYear,
    pay_period: PayPeriods,
    period_number: int,
    *,
    client: Client,
    ordinal: Union[Unset, None, int] = 1,
    unemailed: Union[Unset, None, bool] = False,
    dept_code: Union[Unset, None, str] = UNSET,
    employee_filter: Union[Unset, None, str] = UNSET,
    accept: Union[Unset, str] = UNSET,

) -> Optional[ReportResponse]:
    """Payslips

     Returns all Payslips for the given PayRun
    If you set the accept header to \"text/html\" then unlike other reports the html is NOT in the
    ```Content``` field.
    As there are multiple HTML documents they are encoded as a JSON array of strings in the ```Model```
    field.

    Args:
        employer_id (str):
        tax_year (TaxYear):
        pay_period (PayPeriods):
        period_number (int):
        ordinal (Union[Unset, None, int]):  Default: 1.
        unemailed (Union[Unset, None, bool]):
        dept_code (Union[Unset, None, str]):
        employee_filter (Union[Unset, None, str]):
        accept (Union[Unset, str]):

    Returns:
        Response[ReportResponse]
    """


    return (await asyncio_detailed(
        employer_id=employer_id,
tax_year=tax_year,
pay_period=pay_period,
period_number=period_number,
client=client,
ordinal=ordinal,
unemailed=unemailed,
dept_code=dept_code,
employee_filter=employee_filter,
accept=accept,

    )).parsed

