from pathlib import Path

from .config import Config, ConfigKey

env = Config(
    path=Path.home() / ".cache" / "docketanalyzer" / "config.json",
    keys=[
        ConfigKey(
            name="DA_DATA_DIR",
            alias_names=["DATA_DIR"],
            key_type="path",
            description="\nChoose directory for data managed by Docket Analyzer\n",
            default=Path.home() / "docketanalyzer",
            group="docketanalyzer",
        ),
        ConfigKey(
            name="PACER_USERNAME",
            key_type="str",
            description="\nConfigure PACER Credentials\n",
            default=None,
            group="pacer",
        ),
        ConfigKey(
            name="PACER_PASSWORD",
            key_type="str",
            default=None,
            mask=True,
            group="pacer",
        ),
        ConfigKey(
            name="COURTLISTENER_TOKEN",
            key_type="str",
            description="\nConfigure CourtListener API\n",
            default=None,
            mask=True,
            group="recap",
        ),
        # ML Tools
        ConfigKey(
            name="HF_TOKEN",
            key_type="str",
            description="\nConfigure Hugging Face Token\n",
            default=None,
            mask=True,
            group="huggingface",
        ),
        ConfigKey(
            name="WANDB_API_KEY",
            key_type="str",
            description="\nConfigure Weights and Biases\n",
            default=None,
            mask=True,
            group="wandb",
        ),
        # LLM Providers
        ConfigKey(
            name="ANTHROPIC_API_KEY",
            key_type="str",
            description="\nConfigure Anthropic\n",
            default=None,
            mask=True,
            group="anthropic",
        ),
        ConfigKey(
            name="OPENAI_API_KEY",
            key_type="str",
            description="\nConfigure OpenAI\n",
            default=None,
            mask=True,
            group="openai",
        ),
        ConfigKey(
            name="COHERE_API_KEY",
            key_type="str",
            description="\nConfigure Cohere\n",
            default=None,
            mask=True,
            group="cohere",
        ),
        ConfigKey(
            name="GROQ_API_KEY",
            key_type="str",
            description="\nConfigure Groq\n",
            default=None,
            mask=True,
            group="groq",
        ),
        ConfigKey(
            name="TOGETHER_API_KEY",
            key_type="str",
            description="\nConfigure Together AI\n",
            default=None,
            mask=True,
            group="together",
        ),
        # Runpod
        ConfigKey(
            name="RUNPOD_API_KEY",
            key_type="str",
            description="\nConfigure Runpod\n",
            default=None,
            mask=True,
            group="runpod",
        ),
        ConfigKey(
            name="RUNPOD_INFERENCE_ENDPOINT_ID",
            key_type="str",
            default=None,
            mask=True,
            group="runpod",
        ),
        ConfigKey(
            name="RUNPOD_ROUTINES_ENDPOINT_ID",
            key_type="str",
            default=None,
            mask=True,
            group="runpod",
        ),
        ConfigKey(
            name="RUNPOD_OCR_ENDPOINT_ID",
            key_type="str",
            default=None,
            mask=True,
            group="runpod",
        ),
        # Services
        ConfigKey(
            name="ELASTIC_URL",
            key_type="str",
            description="\nConfigure Elasticsearch\n",
            default=None,
            mask=True,
            group="elastic",
        ),
        ConfigKey(
            name="POSTGRES_URL",
            key_type="str",
            description="\nConfigure Postgres\n",
            default=None,
            mask=True,
            group="psql",
        ),
        ConfigKey(
            name="REDIS_URL",
            key_type="str",
            description="\nConfigure Redis\n",
            default=None,
            mask=True,
            group="redis",
        ),
        ConfigKey(
            name="AWS_ACCESS_KEY_ID",
            key_type="str",
            description="\nConfigure S3\n",
            default=None,
            mask=True,
            group="s3",
        ),
        ConfigKey(
            name="AWS_SECRET_ACCESS_KEY",
            key_type="str",
            default=None,
            mask=True,
            group="s3",
        ),
        ConfigKey(
            name="AWS_S3_BUCKET_NAME",
            key_type="str",
            default=None,
            group="s3",
        ),
        ConfigKey(
            name="AWS_S3_ENDPOINT_URL",
            key_type="str",
            default=None,
            group="s3",
        ),
        # Dev
        ConfigKey(
            name="PYPI_TOKEN",
            key_type="str",
            default=None,
            mask=True,
            hide=True,
            group="dev",
        ),
    ],
)
