# A collection of Notebooks for using IPython effectively

The following notebooks showcase multiple aspects of IPython, from its basic
use to more advanced scenarios.  They introduce you to the use of the Notebook
and also cover aspects of IPython that are available in other clients, such as
the cell magics for multi-language integration or our extended display
protocol.

For beginners, we recommend that you start with the 5-part series that
introduces the system, and later read others as the topics interest you.

Once you are familiar with the notebook system, we encourage you to visit our
[gallery](https://github.com/ipython/ipython/wiki/A-gallery-of-interesting-IPython-Notebooks)
where you will find many more examples that cover areas from basic Python
programming to advanced topics in scientific computing.

* [Animations Using clear_output](http://nbviewer.ipython.org/url/github.com/ipython/ipython/raw/master/examples/notebooks/Animations%20Using%20clear_output.ipynb)
* [Cell Magics](http://nbviewer.ipython.org/url/github.com/ipython/ipython/raw/master/examples/notebooks/Cell%20Magics.ipynb)
* [Custom Display Logic](http://nbviewer.ipython.org/url/github.com/ipython/ipython/raw/master/examples/notebooks/Custom%20Display%20Logic.ipynb)
* [Cython Magics](http://nbviewer.ipython.org/url/github.com/ipython/ipython/raw/master/examples/notebooks/Cython%20Magics.ipynb)
* [Data Publication API](http://nbviewer.ipython.org/url/github.com/ipython/ipython/raw/master/examples/notebooks/Data%20Publication%20API.ipynb)
* [Frontend-Kernel Model](http://nbviewer.ipython.org/url/github.com/ipython/ipython/raw/master/examples/notebooks/Frontend-Kernel%20Model.ipynb)
* [Octave Magic](http://nbviewer.ipython.org/url/github.com/ipython/ipython/raw/master/examples/notebooks/Octave%20Magic.ipynb)
* [Part 1 - Running Code](http://nbviewer.ipython.org/url/github.com/ipython/ipython/raw/master/examples/notebooks/Part%201%20-%20Running%20Code.ipynb)
* [Part 2 - Basic Output](http://nbviewer.ipython.org/url/github.com/ipython/ipython/raw/master/examples/notebooks/Part%202%20-%20Basic%20Output.ipynb)
* [Part 3 - Pylab and Matplotlib](http://nbviewer.ipython.org/url/github.com/ipython/ipython/raw/master/examples/notebooks/Part%203%20-%20Pylab%20and%20Matplotlib.ipynb)
* [Part 4 - Markdown Cells](http://nbviewer.ipython.org/url/github.com/ipython/ipython/raw/master/examples/notebooks/Part%204%20-%20Markdown%20Cells.ipynb)
* [Part 5 - Rich Display System](http://nbviewer.ipython.org/url/github.com/ipython/ipython/raw/master/examples/notebooks/Part%205%20-%20Rich%20Display%20System.ipynb)
* [Progress Bars](http://nbviewer.ipython.org/url/github.com/ipython/ipython/raw/master/examples/notebooks/Progress%20Bars.ipynb)
* [R Magics](http://nbviewer.ipython.org/url/github.com/ipython/ipython/raw/master/examples/notebooks/R%20Magics.ipynb)
* [Script Magics](http://nbviewer.ipython.org/url/github.com/ipython/ipython/raw/master/examples/notebooks/Script%20Magics.ipynb)
* [SymPy Examples](http://nbviewer.ipython.org/url/github.com/ipython/ipython/raw/master/examples/notebooks/SymPy%20Examples.ipynb)
* [Trapezoid Rule](http://nbviewer.ipython.org/url/github.com/ipython/ipython/raw/master/examples/notebooks/Trapezoid%20Rule.ipynb)
* [Typesetting Math Using MathJax](http://nbviewer.ipython.org/url/github.com/ipython/ipython/raw/master/examples/notebooks/Typesetting%20Math%20Using%20MathJax.ipynb)
